/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateArray$;
import org.apache.spark.sql.catalyst.expressions.DecimalLiteral$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NonFoldableLiteral$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.collection.OpenHashMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u0005\u000b\u0001eAQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013%1\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0011\u0019i\u0004\u0001)A\u0005_!)a\b\u0001C\u0005\u007f!)\u0001\r\u0001C\u0005C\")Q\u000f\u0001C\u0005m\ny\u0001+\u001a:dK:$\u0018\u000e\\3Tk&$XM\u0003\u0002\f\u0019\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u001b9\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0002E\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011CE\u0001\u0004gFd'BA\n\u0015\u0003\u0015\u0019\b/\u0019:l\u0015\t)b#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0007\t\u00037qi\u0011AE\u0005\u0003;I\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u000b\u0003\u0019\u0011\u0018M\u001c3p[V\tA\u0005\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!Q\u000f^5m\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\rI\u000bg\u000eZ8n\u0003\u001d\u0011\u0018M\u001c3p[\u0002\nA\u0001Z1uCV\tq\u0006E\u00021oej\u0011!\r\u0006\u0003eM\n\u0011\"[7nkR\f'\r\\3\u000b\u0005Q*\u0014AC2pY2,7\r^5p]*\ta'A\u0003tG\u0006d\u0017-\u0003\u00029c\tQ\u0011J\u001c3fq\u0016$7+Z9\u0011\u0005iZT\"A\u001b\n\u0005q*$aA%oi\u0006)A-\u0019;bA\u00059!/\u001e8UKN$H\u0003\u0002!D\u0011j\u0003\"AO!\n\u0005\t+$\u0001B+oSRDQ\u0001\u0012\u0004A\u0002\u0015\u000b1!Y4h!\t\tc)\u0003\u0002H\u0015\tQ\u0001+\u001a:dK:$\u0018\u000e\\3\t\u000b%3\u0001\u0019\u0001&\u0002\tI|wo\u001d\t\u0004\u0017N3fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\ty\u0005$\u0001\u0004=e>|GOP\u0005\u0002m%\u0011!+N\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0002TKFT!AU\u001b\u0011\u0007-\u001bv\u000b\u0005\u0002;1&\u0011\u0011,\u000e\u0002\u0004\u0003:L\b\"B.\u0007\u0001\u0004a\u0016aE3ya\u0016\u001cG/\u001a3QKJ\u001cWM\u001c;jY\u0016\u001c\bcA&T;B\u0011!HX\u0005\u0003?V\u0012a\u0001R8vE2,\u0017!D2p[B\f'/Z#rk\u0006d7\u000fF\u0002cKN\u0004\"AO2\n\u0005\u0011,$a\u0002\"p_2,\u0017M\u001c\u0005\u0006M\u001e\u0001\raZ\u0001\u0005Y\u00164G\u000f\u0005\u0003iW6\u0004X\"A5\u000b\u0005QR'BA\u0014\u0013\u0013\ta\u0017NA\u0006Pa\u0016t\u0007*Y:i\u001b\u0006\u0004\bC\u0001\u001eo\u0013\tyWG\u0001\u0004B]f\u0014VM\u001a\t\u0003uEL!A]\u001b\u0003\t1{gn\u001a\u0005\u0006i\u001e\u0001\raZ\u0001\u0006e&<\u0007\u000e^\u0001\fCN\u001cXM\u001d;FcV\fG.\u0006\u0002xwR!\u0001\t_A\u0002\u0011\u00151\u0007\u00021\u0001z!\tQ8\u0010\u0004\u0001\u0005\u000bqD!\u0019A?\u0003\u0003Q\u000b\"A`,\u0011\u0005iz\u0018bAA\u0001k\t9aj\u001c;iS:<\u0007\"\u0002;\t\u0001\u0004I\b")
public class PercentileSuite
extends SparkFunSuite {
    private final Random random = new Random();
    private final IndexedSeq<Object> data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10000).map((Function1)(JFunction1.mcII.sp & Serializable)x$1 -> this.random().nextInt(10000));

    private Random random() {
        return this.random;
    }

    private IndexedSeq<Object> data() {
        return this.data;
    }

    private void runTest(Percentile agg, Seq<Seq<Object>> rows, Seq<Object> expectedPercentiles) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(agg.nullable(), "agg.nullable", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        Range group1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), rows.length() / 2);
        OpenHashMap group1Buffer = agg.createAggregationBuffer();
        group1.foreach((Function1 & Serializable)index -> PercentileSuite.$anonfun$runTest$1(rows, agg, group1Buffer, BoxesRunTime.unboxToInt((Object)index)));
        Range group2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(rows.length() / 2), rows.length());
        OpenHashMap group2Buffer = agg.createAggregationBuffer();
        group2.foreach((Function1 & Serializable)index -> PercentileSuite.$anonfun$runTest$2(rows, agg, group2Buffer, BoxesRunTime.unboxToInt((Object)index)));
        OpenHashMap mergeBuffer = agg.createAggregationBuffer();
        agg.merge(mergeBuffer, group1Buffer);
        agg.merge(mergeBuffer, group2Buffer);
        Object object = agg.eval(mergeBuffer);
        if (object instanceof ArrayData) {
            ArrayData arrayData = (ArrayData)object;
            double[] percentiles = arrayData.toDoubleArray();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(percentiles), expectedPercentiles)), (Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)PercentileSuite.$anonfun$runTest$3(pair))), "scala.Predef.refArrayOps[(Double, Double)](scala.Predef.doubleArrayOps(percentiles).zip[Double](expectedPercentiles)).forall(((pair: (Double, Double)) => pair._1.==(pair._2)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            return;
        }
        throw new MatchError(object);
    }

    private boolean compareEquals(OpenHashMap<Object, Object> left, OpenHashMap<Object, Object> right) {
        return left.size() == right.size() && left.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PercentileSuite.$anonfun$compareEquals$1(right, x0$1)));
    }

    private <T> void assertEqual(T left, T right) {
        T $org_scalatest_assert_macro_right;
        T $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals($org_scalatest_assert_macro_left = left, $org_scalatest_assert_macro_right = right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
    }

    public static final /* synthetic */ long $anonfun$new$2(OpenHashMap buffer$1, int key) {
        return buffer$1.changeValue$mcJ$sp((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L, (Function1)(JFunction1.mcJJ.sp & Serializable)x$2 -> x$2 + 1L);
    }

    public static final /* synthetic */ Seq $anonfun$new$7(int x) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{x}));
    }

    public static final /* synthetic */ Seq $anonfun$new$8(int x) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{x, x})).$colon$plus((Object)BoxesRunTime.boxToLong((long)x));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$new$9(int current) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), current).map((Function1)(JFunction1.mcII.sp & Serializable)y -> current);
    }

    public static final /* synthetic */ Seq $anonfun$new$11(int x$4) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{x$4}));
    }

    public static final /* synthetic */ OpenHashMap $anonfun$runTest$1(Seq rows$1, Percentile agg$1, OpenHashMap group1Buffer$1, int index) {
        InternalRow input = InternalRow$.MODULE$.apply((Seq)rows$1.apply(index));
        return agg$1.update(group1Buffer$1, input);
    }

    public static final /* synthetic */ OpenHashMap $anonfun$runTest$2(Seq rows$1, Percentile agg$1, OpenHashMap group2Buffer$1, int index) {
        InternalRow input = InternalRow$.MODULE$.apply((Seq)rows$1.apply(index));
        return agg$1.update(group2Buffer$1, input);
    }

    public static final /* synthetic */ boolean $anonfun$runTest$3(Tuple2 pair) {
        return pair._1$mcD$sp() == pair._2$mcD$sp();
    }

    public static final /* synthetic */ void $anonfun$new$15(PercentileSuite $this, Literal percentage$1, NumericType dataType) {
        String x$1 = "a";
        NumericType x$2 = dataType;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$2, x$3, x$4);
        AttributeReference child = new AttributeReference("a", (DataType)x$2, x$3, x$4, x$5, x$6);
        Percentile percentile = new Percentile((Expression)child, (Expression)percentage$1);
        $this.assertEqual(percentile.checkInputDataTypes(), TypeCheckResult.TypeCheckSuccess$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$17(PercentileSuite $this, NumericType dataType$1, Literal percentage$1, IntegralType frequencyType) {
        String x$7 = "a";
        NumericType x$8 = dataType$1;
        boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$8, x$9, x$10);
        AttributeReference child = new AttributeReference("a", (DataType)x$8, x$9, x$10, x$11, x$12);
        String x$13 = "frq";
        IntegralType x$14 = frequencyType;
        boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5("frq", (DataType)x$14, x$15, x$16);
        Seq x$18 = AttributeReference$.MODULE$.apply$default$6("frq", (DataType)x$14, x$15, x$16);
        AttributeReference frq = new AttributeReference("frq", (DataType)x$14, x$15, x$16, x$17, x$18);
        Percentile percentile = new Percentile((Expression)child, (Expression)percentage$1, (Expression)frq);
        $this.assertEqual(percentile.checkInputDataTypes(), TypeCheckResult.TypeCheckSuccess$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$25(PercentileSuite $this, Cast child$1, Expression percentage) {
        Percentile percentile1 = new Percentile((Expression)child$1, percentage);
        $this.assertEqual(percentile1.checkInputDataTypes(), TypeCheckResult.TypeCheckSuccess$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$27(PercentileSuite $this, Cast child$1, Expression percentage) {
        Percentile percentile2 = new Percentile((Expression)child$1, percentage);
        Object object = percentage.eval(percentage.eval$default$1());
        if (object instanceof ArrayData) {
            ArrayData arrayData = (ArrayData)object;
            $this.assertEqual(percentile2.checkInputDataTypes(), new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)"[0.0, 1.0]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(arrayData.toDoubleArray()), (Function1 & Serializable)x$7 -> Cast$.MODULE$.toSQLValue((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$7)), (DataType)DoubleType$.MODULE$), ClassTag$.MODULE$.apply(String.class))).mkString(","))}))));
            return;
        }
        $this.assertEqual(percentile2.checkInputDataTypes(), new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)"[0.0, 1.0]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)new Object[]{object}), (Function1 & Serializable)x$8 -> Cast$.MODULE$.toSQLValue(x$8, (DataType)DoubleType$.MODULE$), ClassTag$.MODULE$.apply(String.class))).mkString(","))}))));
    }

    public static final /* synthetic */ void $anonfun$new$31(PercentileSuite $this, Cast child$1, Expression percentage) {
        Percentile percentile3 = new Percentile((Expression)child$1, percentage);
        $this.assertEqual(percentile3.checkInputDataTypes(), new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)Cast$.MODULE$.toSQLId("percentage")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)percentage.dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(percentage))}))));
    }

    public static final /* synthetic */ boolean $anonfun$compareEquals$1(OpenHashMap right$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object key = tuple2._1();
            long count = tuple2._2$mcJ$sp();
            return right$1.apply$mcJ$sp(key) == count;
        }
        throw new MatchError((Object)tuple2);
    }

    public PercentileSuite() {
        this.test("serialize and de-serialize", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Percentile agg = new Percentile((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)));
            OpenHashMap.mcJ.sp buffer = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), (ClassTag)ClassTag$.MODULE$.Long());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.compareEquals((OpenHashMap<Object, Object>)agg.deserialize(agg.serialize((OpenHashMap)buffer)), (OpenHashMap<Object, Object>)buffer), "PercentileSuite.this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            this.data().foreach((Function1)((JFunction1.mcJI.sp & Serializable)arg_0 -> PercentileSuite.$anonfun$new$2((OpenHashMap)buffer, arg_0)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.compareEquals((OpenHashMap<Object, Object>)agg.deserialize(agg.serialize((OpenHashMap)buffer)), (OpenHashMap<Object, Object>)buffer), "PercentileSuite.this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("class Percentile, high level interface, update, merge, eval...", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int count = 10000;
            Seq percentages = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.25, 0.5, 0.75, 1.0}));
            Seq expectedPercentiles = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{1.0, 2500.75, 5000.5, 7500.25, 10000.0}));
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, false), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            CreateArray percentageExpression = CreateArray$.MODULE$.apply((Seq)percentages.toSeq().map((Function1 & Serializable)x$3 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$3)))));
            Percentile agg = new Percentile((Expression)childExpression, (Expression)percentageExpression);
            IndexedSeq rows = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)x -> PercentileSuite.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)x)));
            this.runTest(agg, (Seq<Seq<Object>>)rows, (Seq<Object>)expectedPercentiles);
            int countForFrequencyTest = 1000;
            IndexedSeq rowsWithFrequency = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), countForFrequencyTest).map((Function1 & Serializable)x -> PercentileSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)x)));
            Seq expectedPercentilesWithFrequency = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{1.0, 500.0, 707.0, 866.0, 1000.0}));
            BoundReference frequencyExpressionInt = new BoundReference(1, (DataType)IntegerType$.MODULE$, false);
            Percentile aggInt = new Percentile((Expression)childExpression, (Expression)percentageExpression, (Expression)frequencyExpressionInt);
            this.runTest(aggInt, (Seq<Seq<Object>>)rowsWithFrequency, (Seq<Object>)expectedPercentilesWithFrequency);
            BoundReference frequencyExpressionLong = new BoundReference(2, (DataType)LongType$.MODULE$, false);
            Percentile aggLong = new Percentile((Expression)childExpression, (Expression)percentageExpression, (Expression)frequencyExpressionLong);
            this.runTest(aggLong, (Seq<Seq<Object>>)rowsWithFrequency, (Seq<Object>)expectedPercentilesWithFrequency);
            IndexedSeq flattenRows = (IndexedSeq)((IndexedSeqOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), countForFrequencyTest).flatMap((Function1 & Serializable)current -> PercentileSuite.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)current)))).map((Function1 & Serializable)x$4 -> PercentileSuite.$anonfun$new$11(BoxesRunTime.unboxToInt((Object)x$4)));
            this.runTest(agg, (Seq<Seq<Object>>)flattenRows, (Seq<Object>)expectedPercentilesWithFrequency);
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("class Percentile, low level interface, update, merge, eval...", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            int inputAggregationBufferOffset = 1;
            int mutableAggregationBufferOffset = 2;
            double percentage = 0.5;
            Percentile agg = new Percentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)percentage))).withNewInputAggBufferOffset(inputAggregationBufferOffset).withNewMutableAggBufferOffset(mutableAggregationBufferOffset);
            GenericInternalRow mutableAggBuffer = new GenericInternalRow(new Object[mutableAggregationBufferOffset + 1]);
            agg.initialize((InternalRow)mutableAggBuffer);
            int dataCount = 10;
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), dataCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)data -> agg.update((InternalRow)mutableAggBuffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)data)}))));
            agg.serializeAggregateBufferInPlace((InternalRow)mutableAggBuffer);
            byte[] serialized = mutableAggBuffer.getBinary(mutableAggregationBufferOffset);
            GenericInternalRow inputAggBuffer = new GenericInternalRow(new Object[]{null, serialized});
            agg.initialize((InternalRow)mutableAggBuffer);
            agg.merge((InternalRow)mutableAggBuffer, (InternalRow)inputAggBuffer);
            double expectedPercentile = 5.5;
            double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)agg.eval((InternalRow)mutableAggBuffer));
            double $org_scalatest_assert_macro_right = expectedPercentile;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("fail analysis if childExpression is invalid", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon validDataTypes = new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)Nil$.MODULE$))))));
            Literal percentage = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5));
            validDataTypes.foreach((Function1 & Serializable)dataType -> {
                PercentileSuite.$anonfun$new$15(this, percentage, dataType);
                return BoxedUnit.UNIT;
            });
            .colon.colon validFrequencyTypes = new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$))));
            validDataTypes.foreach(arg_0 -> PercentileSuite.$anonfun$new$16$adapted(this, (Seq)validFrequencyTypes, percentage, arg_0));
            .colon.colon invalidDataTypes = new .colon.colon((Object)BooleanType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)CalendarIntervalType$.MODULE$, (List)new .colon.colon((Object)NullType$.MODULE$, (List)Nil$.MODULE$))))));
            invalidDataTypes.foreach((Function1 & Serializable)dataType -> {
                String x$19 = "a";
                DataType x$20 = dataType;
                boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$23 = AttributeReference$.MODULE$.apply$default$5("a", x$20, x$21, x$22);
                Seq x$24 = AttributeReference$.MODULE$.apply$default$6("a", x$20, x$21, x$22);
                AttributeReference child = new AttributeReference("a", x$20, x$21, x$22, x$23, x$24);
                Percentile percentile = new Percentile((Expression)child, (Expression)percentage);
                TypeCheckResult $org_scalatest_assert_macro_left = percentile.checkInputDataTypes();
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"(\"NUMERIC\" or \"INTERVAL DAY TO SECOND\" or \"INTERVAL YEAR TO MONTH\")"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"a\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)dataType))})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            });
            Seq invalidFrequencyDataTypes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{FloatType$.MODULE$, DoubleType$.MODULE$, BooleanType$.MODULE$, StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, CalendarIntervalType$.MODULE$, NullType$.MODULE$}));
            invalidDataTypes.foreach(arg_0 -> PercentileSuite.$anonfun$new$19$adapted((Seq)validFrequencyTypes, percentage, arg_0));
            validDataTypes.foreach((Function1 & Serializable)dataType -> {
                invalidFrequencyDataTypes.foreach((Function1 & Serializable)frequencyType -> {
                    String x$37 = "a";
                    NumericType x$38 = dataType;
                    boolean x$39 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$40 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$41 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$38, x$39, x$40);
                    Seq x$42 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$38, x$39, x$40);
                    AttributeReference child = new AttributeReference("a", (DataType)x$38, x$39, x$40, x$41, x$42);
                    String x$43 = "frq";
                    DataType x$44 = frequencyType;
                    boolean x$45 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$46 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$47 = AttributeReference$.MODULE$.apply$default$5("frq", x$44, x$45, x$46);
                    Seq x$48 = AttributeReference$.MODULE$.apply$default$6("frq", x$44, x$45, x$46);
                    AttributeReference frq = new AttributeReference("frq", x$44, x$45, x$46, x$47, x$48);
                    Percentile percentile = new Percentile((Expression)child, (Expression)percentage$1, (Expression)frq);
                    TypeCheckResult $org_scalatest_assert_macro_left = percentile.checkInputDataTypes();
                    TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"INTEGRAL\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"frq\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)frequencyType))})));
                    TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("fails analysis if percentage(s) are invalid", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Cast child = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, false), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            .colon.colon validPercentages = new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.0)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 1.0})).map((Function1 & Serializable)x$5 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$5))))), (List)Nil$.MODULE$))));
            validPercentages.foreach((Function1 & Serializable)percentage -> {
                PercentileSuite.$anonfun$new$25(this, child, percentage);
                return BoxedUnit.UNIT;
            });
            .colon.colon invalidPercentages = new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)-0.5)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.5)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)2.0)), (List)new .colon.colon((Object)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-0.5, 0.0, 2.0})).map((Function1 & Serializable)x$6 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$6))))), (List)Nil$.MODULE$))));
            invalidPercentages.foreach((Function1 & Serializable)percentage -> {
                PercentileSuite.$anonfun$new$27(this, child, percentage);
                return BoxedUnit.UNIT;
            });
            .colon.colon nonFoldablePercentage = new .colon.colon((Object)NonFoldableLiteral$.MODULE$.apply(BoxesRunTime.boxToDouble((double)0.5)), (List)new .colon.colon((Object)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 1.0})).map((Function1 & Serializable)x$9 -> NonFoldableLiteral$.MODULE$.apply(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$9))))), (List)Nil$.MODULE$));
            nonFoldablePercentage.foreach((Function1 & Serializable)percentage -> {
                PercentileSuite.$anonfun$new$31(this, child, percentage);
                return BoxedUnit.UNIT;
            });
            Seq invalidDataTypes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, BooleanType$.MODULE$, StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, CalendarIntervalType$.MODULE$, NullType$.MODULE$}));
            invalidDataTypes.foreach((Function1 & Serializable)dataType -> {
                TypeCheckResult checkResult;
                Literal percentage = Literal$.MODULE$.default(dataType);
                Percentile percentile4 = new Percentile((Expression)child, (Expression)percentage);
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult = percentile4.checkInputDataTypes();
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"DOUBLE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr((Expression)percentage)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)dataType))})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            });
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("class ApproximatePercentile, automatically add type casting for parameters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Attribute[] attributeArray = new Attribute[1];
            String x$49 = "a";
            IntegerType$ x$50 = IntegerType$.MODULE$;
            boolean x$51 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$52 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$53 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$50, x$51, x$52);
            Seq x$54 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$50, x$51, x$52);
            attributeArray[0] = new AttributeReference("a", (DataType)x$50, x$51, x$52, x$53, x$54);
            LocalRelation testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeArray));
            .colon.colon percentageExpressions = new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.3f)), (List)new .colon.colon((Object)DecimalLiteral$.MODULE$.apply(0.5), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"0.2"), (List)new .colon.colon((Object)CreateArray$.MODULE$.apply((Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.3f)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (List)new .colon.colon((Object)DecimalLiteral$.MODULE$.apply(0.7), (List)Nil$.MODULE$)))), (List)Nil$.MODULE$))));
            percentageExpressions.foreach((Function1 & Serializable)percentageExpression -> {
                Alias alias;
                Expression agg;
                Percentile agg2 = new Percentile((Expression)UnresolvedAttribute$.MODULE$.apply("a"), percentageExpression);
                Expression analyzed = (Expression)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)testRelation).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{agg2}))).analyze().expressions().head();
                Expression expression = analyzed;
                if (expression instanceof Alias && (agg = (alias = (Alias)expression).child()) instanceof Percentile) {
                    Bool bool;
                    Percentile percentile = (Percentile)agg;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(percentile.resolved(), "agg.resolved", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
                    DataType $org_scalatest_assert_macro_left = percentile.child().dataType();
                    IntegerType$ $org_scalatest_assert_macro_right = IntegerType$.MODULE$;
                    DataType dataType = $org_scalatest_assert_macro_left;
                    IntegerType$ integerType$ = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
                    DataType $org_scalatest_assert_macro_left2 = percentile.percentageExpression().dataType();
                    DoubleType$ $org_scalatest_assert_macro_right2 = DoubleType$.MODULE$;
                    DataType dataType2 = $org_scalatest_assert_macro_left2;
                    DoubleType$ doubleType$ = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left3.value()) {
                        bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                    } else {
                        DataType $org_scalatest_assert_macro_left4 = percentile.percentageExpression().dataType();
                        ArrayType $org_scalatest_assert_macro_right3 = new ArrayType((DataType)DoubleType$.MODULE$, false);
                        DataType dataType3 = $org_scalatest_assert_macro_left4;
                        ArrayType arrayType = $org_scalatest_assert_macro_right3;
                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right4 = bool;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "||", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left3.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
                }
                throw this.fail(new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            });
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        this.test("nulls in percentage expression", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$55 = "a";
            DoubleType$ x$56 = DoubleType$.MODULE$;
            boolean x$57 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$58 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$59 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$56, x$57, x$58);
            Seq x$60 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$56, x$57, x$58);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new Percentile((Expression)new AttributeReference("a", (DataType)x$56, x$57, x$58, x$59, x$60), (Expression)new Literal(null, (DataType)DoubleType$.MODULE$)).checkInputDataTypes());
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            .colon.colon nullPercentageExprs = new .colon.colon((Object)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null})).map((Function1 & Serializable)x$10 -> Literal$.MODULE$.apply(null))), (List)new .colon.colon((Object)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.1), null})).map((Function1 & Serializable)x$11 -> Literal$.MODULE$.apply(x$11))), (List)Nil$.MODULE$));
            nullPercentageExprs.foreach((Function1 & Serializable)percentageExpression -> {
                String x$61 = "a";
                DoubleType$ x$62 = DoubleType$.MODULE$;
                boolean x$63 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$64 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$65 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$62, x$63, x$64);
                Seq x$66 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$62, x$63, x$64);
                Percentile wrongPercentage = new Percentile((Expression)new AttributeReference("a", (DataType)x$62, x$63, x$64, x$65, x$66), (Expression)percentageExpression);
                TypeCheckResult $org_scalatest_assert_macro_left = wrongPercentage.checkInputDataTypes();
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"ARRAY<DOUBLE>\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr((Expression)percentageExpression)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"ARRAY<VOID>\"")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            });
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        this.test("null handling", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            Percentile agg = new Percentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)));
            GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
            agg.initialize((InternalRow)buffer);
            Object $org_scalatest_assert_macro_left = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var6_5 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var6_5) : var6_5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            Object $org_scalatest_assert_macro_left2 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right2 = null;
            Object object2 = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", null, !(object2 != null ? !object2.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            Cast frequencyExpression = new Cast((Expression)new BoundReference(1, (DataType)IntegerType$.MODULE$, true), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            Percentile aggWithFrequency = new Percentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)frequencyExpression);
            GenericInternalRow bufferWithFrequency = new GenericInternalRow(new Object[2]);
            aggWithFrequency.initialize((InternalRow)bufferWithFrequency);
            Object $org_scalatest_assert_macro_left3 = aggWithFrequency.eval((InternalRow)bufferWithFrequency);
            Object $org_scalatest_assert_macro_right3 = null;
            Object object3 = $org_scalatest_assert_macro_left3;
            Object var17_16 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", null, !(object3 != null ? !object3.equals(var17_16) : var17_16 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            aggWithFrequency.update((InternalRow)bufferWithFrequency, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, null})));
            Object $org_scalatest_assert_macro_left4 = aggWithFrequency.eval((InternalRow)bufferWithFrequency);
            Object $org_scalatest_assert_macro_right4 = null;
            Object object4 = $org_scalatest_assert_macro_left4;
            Object var21_20 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", null, !(object4 != null ? !object4.equals(var21_20) : var21_20 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            aggWithFrequency.update((InternalRow)bufferWithFrequency, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), null})));
            Object $org_scalatest_assert_macro_left5 = aggWithFrequency.eval((InternalRow)bufferWithFrequency);
            Object $org_scalatest_assert_macro_right5 = null;
            Object object5 = $org_scalatest_assert_macro_left5;
            Object var25_24 = null;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "==", null, !(object5 != null ? !object5.equals(var25_24) : var25_24 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            aggWithFrequency.update((InternalRow)bufferWithFrequency, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)})));
            Object $org_scalatest_assert_macro_left6 = aggWithFrequency.eval((InternalRow)bufferWithFrequency);
            Object $org_scalatest_assert_macro_right6 = null;
            Object object6 = $org_scalatest_assert_macro_left6;
            Object var29_28 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", null, !(object6 != null ? !object6.equals(var29_28) : var29_28 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            aggWithFrequency.update((InternalRow)bufferWithFrequency, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})));
            Object $org_scalatest_assert_macro_left7 = aggWithFrequency.eval((InternalRow)bufferWithFrequency);
            Object $org_scalatest_assert_macro_right7 = null;
            Object object7 = $org_scalatest_assert_macro_left7;
            Object var33_32 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left7, "!=", null, object7 == null ? var33_32 != null : !object7.equals(var33_32), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        this.test("negatives frequency column handling", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            Cast freqExpression = new Cast((Expression)new BoundReference(1, (DataType)IntegerType$.MODULE$, true), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            Percentile agg = new Percentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)freqExpression);
            GenericInternalRow buffer = new GenericInternalRow(new Object[2]);
            agg.initialize((InternalRow)buffer);
            SparkIllegalArgumentException x$67 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> {
                agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-5)})));
                return agg.eval((InternalRow)buffer);
            }, ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408))));
            String x$68 = "NEGATIVE_VALUES_IN_FREQUENCY_EXPRESSION";
            Map x$69 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"frequencyExpression"), (Object)"\"boundreference()\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"negativeValue"), (Object)"-5L")}));
            Option x$70 = this.checkError$default$3();
            boolean x$71 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$72 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$67, "NEGATIVE_VALUES_IN_FREQUENCY_EXPRESSION", x$70, x$69, x$71, x$72);
        }, new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
    }

    public static final /* synthetic */ Object $anonfun$new$16$adapted(PercentileSuite $this, Seq validFrequencyTypes$1, Literal percentage$1, NumericType dataType) {
        validFrequencyTypes$1.foreach((Function1 & Serializable)frequencyType -> {
            PercentileSuite.$anonfun$new$17($this, dataType, percentage$1, frequencyType);
            return BoxedUnit.UNIT;
        });
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$new$19$adapted(Seq validFrequencyTypes$1, Literal percentage$1, DataType dataType) {
        validFrequencyTypes$1.foreach((Function1 & Serializable)frequencyType -> {
            String x$25 = "a";
            DataType x$26 = dataType;
            boolean x$27 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$28 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$29 = AttributeReference$.MODULE$.apply$default$5("a", x$26, x$27, x$28);
            Seq x$30 = AttributeReference$.MODULE$.apply$default$6("a", x$26, x$27, x$28);
            AttributeReference child = new AttributeReference("a", x$26, x$27, x$28, x$29, x$30);
            String x$31 = "frq";
            IntegralType x$32 = frequencyType;
            boolean x$33 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$34 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$35 = AttributeReference$.MODULE$.apply$default$5("frq", (DataType)x$32, x$33, x$34);
            Seq x$36 = AttributeReference$.MODULE$.apply$default$6("frq", (DataType)x$32, x$33, x$34);
            AttributeReference frq = new AttributeReference("frq", (DataType)x$32, x$33, x$34, x$35, x$36);
            Percentile percentile = new Percentile((Expression)child, (Expression)percentage$1, (Expression)frq);
            TypeCheckResult $org_scalatest_assert_macro_left = percentile.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"(\"NUMERIC\" or \"INTERVAL DAY TO SECOND\" or \"INTERVAL YEAR TO MONTH\")"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"a\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)dataType))})));
            TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        });
        return BoxedUnit.UNIT;
    }
}

