/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.UUID;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Cube$;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.Exists$;
import org.apache.spark.sql.catalyst.expressions.Explode;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ListQuery$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.PythonUDF$;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.Sequence;
import org.apache.spark.sql.catalyst.expressions.Sequence$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.optimizer.FilterPushdownSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.ExistenceJoin;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RebalancePartitions;
import org.apache.spark.sql.catalyst.plans.logical.RebalancePartitions$;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Union$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005m4A!\u0007\u000e\u0001O!)!\u0007\u0001C\u0001g\u001d)a\u0007\u0001E\u0001o\u0019)\u0011\b\u0001E\u0001u!)!g\u0001C\u0001\u000f\"9\u0001j\u0001b\u0001\n\u0003I\u0005B\u0002-\u0004A\u0003%!\nC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\r\u0005\u0004\u0001\u0015!\u0003\\\u0011\u001d\u0011\u0007A1A\u0005\u0002iCaa\u0019\u0001!\u0002\u0013Y\u0006b\u00023\u0001\u0005\u0004%\tA\u0017\u0005\u0007K\u0002\u0001\u000b\u0011B.\t\u000f\u0019\u0004!\u0019!C\u00015\"1q\r\u0001Q\u0001\nmCq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0001j\u0011\u0019y\u0007\u0001)A\u0005U\"9\u0001\u000f\u0001b\u0001\n\u0003\t\bBB;\u0001A\u0003%!\u000fC\u0004w\u0001\t\u0007I\u0011A<\t\ra\u0004\u0001\u0015!\u0003B\u0011\u001dI\bA1A\u0005\u0002%DaA\u001f\u0001!\u0002\u0013Q'a\u0005$jYR,'\u000fU;tQ\u0012|wO\\*vSR,'BA\u000e\u001d\u0003%y\u0007\u000f^5nSj,'O\u0003\u0002\u001e=\u0005A1-\u0019;bYf\u001cHO\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013!B:qCJ\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001Q1\u0002\"!\u000b\u0016\u000e\u0003\u0001J!a\u000b\u0011\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\ti\u0003'D\u0001/\u0015\tyC$A\u0003qY\u0006t7/\u0003\u00022]\tA\u0001\u000b\\1o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002iA\u0011Q\u0007A\u0007\u00025\u0005Aq\n\u001d;j[&TX\r\u0005\u00029\u00075\t\u0001A\u0001\u0005PaRLW.\u001b>f'\t\u00191\bE\u0002=\u007f\u0005k\u0011!\u0010\u0006\u0003}q\tQA];mKNL!\u0001Q\u001f\u0003\u0019I+H.Z#yK\u000e,Ho\u001c:\u0011\u0005\t+U\"A\"\u000b\u0005\u0011s\u0013a\u00027pO&\u001c\u0017\r\\\u0005\u0003\r\u000e\u00131\u0002T8hS\u000e\fG\u000e\u00157b]R\tq'A\u0004cCR\u001c\u0007.Z:\u0016\u0003)\u00032a\u0013*U\u001b\u0005a%BA'O\u0003%IW.\\;uC\ndWM\u0003\u0002P!\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015'\u0003\t1K7\u000f\u001e\t\u0003+Zk\u0011aA\u0005\u0003/~\u0012QAQ1uG\"\f\u0001BY1uG\",7\u000fI\u0001\u0006CR$(/Q\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011a\fH\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002a;\n\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003\u0019\tG\u000f\u001e:BA\u0005)\u0011\r\u001e;s\u0005\u00061\u0011\r\u001e;s\u0005\u0002\nQ!\u0019;ue\u000e\u000ba!\u0019;ue\u000e\u0003\u0013!B1uiJ$\u0015AB1uiJ$\u0005%\u0001\u0007uKN$(+\u001a7bi&|g.F\u0001k!\t\u00115.\u0003\u0002m\u0007\niAj\\2bYJ+G.\u0019;j_:\fQ\u0002^3tiJ+G.\u0019;j_:\u0004\u0013!\u0004;fgR\u0014V\r\\1uS>t\u0017'\u0001\buKN$(+\u001a7bi&|g.\r\u0011\u00025MLW\u000e\u001d7f\t&\u001c(.\u001e8di&4X\r\u0015:fI&\u001c\u0017\r^3\u0016\u0003I\u0004\"\u0001X:\n\u0005Ql&!\u0003)sK\u0012L7-\u0019;f\u0003m\u0019\u0018.\u001c9mK\u0012K7O[;oGRLg/\u001a)sK\u0012L7-\u0019;fA\u0005yR\r\u001f9fGR,G\r\u0015:fI&\u001c\u0017\r^3QkNDGi\\<o%\u0016\u001cX\u000f\u001c;\u0016\u0003\u0005\u000b\u0001%\u001a=qK\u000e$X\r\u001a)sK\u0012L7-\u0019;f!V\u001c\b\u000eR8x]J+7/\u001e7uA\u0005IB/Z:u%\u0016d\u0017\r^5p]^KG\u000f[!se\u0006LH+\u001f9f\u0003i!Xm\u001d;SK2\fG/[8o/&$\b.\u0011:sCf$\u0016\u0010]3!\u0001")
public class FilterPushdownSuite
extends SparkFunSuite
implements PlanTest {
    private volatile FilterPushdownSuite$Optimize$ Optimize$module;
    private final AttributeReference attrA;
    private final AttributeReference attrB;
    private final AttributeReference attrC;
    private final AttributeReference attrD;
    private final LocalRelation testRelation;
    private final LocalRelation testRelation1;
    private final Predicate simpleDisjunctivePredicate;
    private final LogicalPlan expectedPredicatePushDownResult;
    private final LocalRelation testRelationWithArrayType;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public FilterPushdownSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        FilterPushdownSuite filterPushdownSuite = this;
        synchronized (filterPushdownSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public AttributeReference attrA() {
        return this.attrA;
    }

    public AttributeReference attrB() {
        return this.attrB;
    }

    public AttributeReference attrC() {
        return this.attrC;
    }

    public AttributeReference attrD() {
        return this.attrD;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public LocalRelation testRelation1() {
        return this.testRelation1;
    }

    public Predicate simpleDisjunctivePredicate() {
        return this.simpleDisjunctivePredicate;
    }

    public LogicalPlan expectedPredicatePushDownResult() {
        return this.expectedPredicatePushDownResult;
    }

    public LocalRelation testRelationWithArrayType() {
        return this.testRelationWithArrayType;
    }

    private final void Optimize$lzycompute$1() {
        FilterPushdownSuite filterPushdownSuite = this;
        synchronized (filterPushdownSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new FilterPushdownSuite$Optimize$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$54(FilterPushdownSuite $this, Function1 agg) {
        LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)$this.testRelation()).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)agg.apply((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(42)))).analyze();
        LogicalPlan optimized = (LogicalPlan)$this.Optimize().execute((TreeNode)originalQuery);
        LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)$this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(42)))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)agg.apply((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))}))).analyze();
        $this.comparePlans(optimized, correctAnswer, $this.comparePlans$default$3());
    }

    public FilterPushdownSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        this.attrA = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int();
        this.attrB = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).int();
        this.attrC = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).int();
        this.attrD = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).int();
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{this.attrA(), this.attrB(), this.attrC()}));
        this.testRelation1 = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{this.attrD()}));
        this.simpleDisjunctivePredicate = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(13)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))));
        LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))))).subquery("x");
        LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(13))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))))).subquery("y");
        package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(left);
        LogicalPlan x$1 = right;
        Some x$2 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(13)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))))));
        JoinType x$3 = qual$1.join$default$2();
        this.expectedPredicatePushDownResult = package.plans$.MODULE$.DslLogicalPlan(qual$1.join(x$1, x$3, (Option)x$2)).analyze();
        this.test("eliminate subqueries", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y")).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr()}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("simple push down", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("combine redundant filters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("do not combine non-deterministic filters even if they are identical", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(0L)).$greater((Expression)package.expressions$.MODULE$.doubleToLiteral(0.1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(0L)).$greater((Expression)package.expressions$.MODULE$.doubleToLiteral(0.1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("SPARK-16164: Filter pushdown should keep the ordering in the logical plan", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            LogicalPlan $org_scalatest_assert_macro_left = optimized;
            LogicalPlan $org_scalatest_assert_macro_right = correctAnswer;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("SPARK-16994: filter should not be pushed through limit", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).limit((Expression)package.expressions$.MODULE$.intToLiteral(10))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("can't push without rewrite", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).as("e")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).as("e")}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("nondeterministic: can always push down filter through project with deterministic field", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("nondeterministic: can't push down filter through project with nondeterministic field", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as("rand"), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("nondeterministic: can't push down filter through aggregate with nondeterministic field", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as("rand")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("nondeterministic: push down part of filter through aggregate with deterministic field", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        this.test("Can't push down nondeterministic filter through aggregate", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c")}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("filters: combines filters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("joins: push to either side", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$4 = y;
            JoinType x$5 = qual$2.join$default$2();
            Option x$6 = qual$2.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$2.join(x$4, x$5, x$6)).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$7 = right;
            JoinType x$8 = qual$3.join$default$2();
            Option x$9 = qual$3.join$default$3();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$3.join(x$7, x$8, x$9)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("joins: push to one side", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$10 = y;
            JoinType x$11 = qual$4.join$default$2();
            Option x$12 = qual$4.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$4.join(x$10, x$11, x$12)).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LocalRelation right = this.testRelation();
            package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(left);
            LocalRelation x$13 = right;
            JoinType x$14 = qual$5.join$default$2();
            Option x$15 = qual$5.join$default$3();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$5.join((LogicalPlan)x$13, x$14, x$15)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("joins: do not push down non-deterministic filters into join condition", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            package.plans$.DslLogicalPlan qual$6 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$16 = y;
            JoinType x$17 = qual$6.join$default$2();
            Option x$18 = qual$6.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$6.join(x$16, x$17, x$18)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).$greater((Expression)package.expressions$.MODULE$.doubleToLiteral(5.0)))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("joins: push to one side after transformCondition", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            package.plans$.DslLogicalPlan qual$7 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$19 = y;
            JoinType x$20 = qual$7.join$default$2();
            Option x$21 = qual$7.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$7.join(x$19, x$20, x$21)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.d").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("x.b").attr()))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.d").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("x.c").attr()))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LocalRelation right = this.testRelation1();
            package.plans$.DslLogicalPlan qual$8 = package.plans$.MODULE$.DslLogicalPlan(left);
            LocalRelation x$22 = right;
            Some x$23 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("d").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("b").attr())).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("d").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("c").attr())));
            JoinType x$24 = qual$8.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$8.join((LogicalPlan)x$22, x$24, (Option)x$23)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("joins: rewrite filter to push to either side", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$9 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$25 = y;
            JoinType x$26 = qual$9.join$default$2();
            Option x$27 = qual$9.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$9.join(x$25, x$26, x$27)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            package.plans$.DslLogicalPlan qual$10 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$28 = right;
            JoinType x$29 = qual$10.join$default$2();
            Option x$30 = qual$10.join$default$3();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$10.join(x$28, x$29, x$30)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        this.test("joins: push down left semi join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftSemi$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.d").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)LeftSemi$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("joins: push down left outer join #1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$11 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$31 = y;
            LeftOuter$ x$32 = LeftOuter$.MODULE$;
            Option x$33 = qual$11.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$11.join(x$31, (JoinType)x$32, x$33)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            package.plans$.DslLogicalPlan qual$12 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$34 = y;
            LeftOuter$ x$35 = LeftOuter$.MODULE$;
            Option x$36 = qual$12.join$default$3();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$12.join(x$34, (JoinType)x$35, x$36)).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        this.test("joins: push down right outer join #1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$13 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$37 = y;
            RightOuter$ x$38 = RightOuter$.MODULE$;
            Option x$39 = qual$13.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$13.join(x$37, (JoinType)x$38, x$39)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("d");
            package.plans$.DslLogicalPlan qual$14 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$40 = right;
            RightOuter$ x$41 = RightOuter$.MODULE$;
            Option x$42 = qual$14.join$default$3();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$14.join(x$40, (JoinType)x$41, x$42)).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("joins: push down left outer join #2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("d");
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(y, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("d.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        this.test("joins: push down right outer join #2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("d");
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(right, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("d.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        this.test("joins: push down left outer join #3", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("l");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery("r");
            package.plans$.DslLogicalPlan qual$15 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$43 = right;
            LeftOuter$ x$44 = LeftOuter$.MODULE$;
            Option x$45 = qual$15.join$default$3();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$15.join(x$43, (JoinType)x$44, x$45)).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("r.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.test("joins: push down right outer join #3", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("r");
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(right, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("r.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        this.test("joins: push down left outer join #4", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.c").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.c").attr())));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("l");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery("r");
            package.plans$.DslLogicalPlan qual$16 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$46 = right;
            LeftOuter$ x$47 = LeftOuter$.MODULE$;
            Option x$48 = qual$16.join$default$3();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$16.join(x$46, (JoinType)x$47, x$48)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("r.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("l.c").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("r.c").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        this.test("joins: push down right outer join #4", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.c").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.c").attr())));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("l");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("r");
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("r.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("l.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("l.c").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("r.c").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        this.test("joins: push down left outer join #5", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.c").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.c").attr())));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("l");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery("r");
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("l.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("r.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("l.c").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("r.c").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        this.test("joins: push down right outer join #5", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.c").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.c").attr())));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).subquery("l");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).subquery("r");
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("r.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("l.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("l.c").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("r.c").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        this.test("joins: can't push down", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$17 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$49 = y;
            Some x$50 = new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr()));
            JoinType x$51 = qual$17.join$default$2();
            LogicalPlan originalQuery = qual$17.join(x$49, x$51, (Option)x$50);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            this.comparePlans(package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze(), optimized, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
        this.test("joins: conjunctive predicates", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$18 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$52 = y;
            JoinType x$53 = qual$18.join$default$2();
            Option x$54 = qual$18.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$18.join(x$52, x$53, x$54)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery("x");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery("y");
            package.plans$.DslLogicalPlan qual$19 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$55 = right;
            Some x$56 = new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr()));
            JoinType x$57 = qual$19.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$19.join(x$55, x$57, (Option)x$56)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
        this.test("joins: conjunctive predicates #2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$20 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$58 = y;
            JoinType x$59 = qual$20.join$default$2();
            Option x$60 = qual$20.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$20.join(x$58, x$59, x$60)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery("x");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$21 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$61 = right;
            Some x$62 = new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr()));
            JoinType x$63 = qual$21.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$21.join(x$61, x$63, (Option)x$62)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
        this.test("joins: conjunctive predicates #3", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan z = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("z");
            package.plans$.DslLogicalPlan qual$22 = package.plans$.MODULE$.DslLogicalPlan(z);
            package.plans$.DslLogicalPlan qual$23 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$64 = y;
            JoinType x$65 = qual$23.join$default$2();
            Option x$66 = qual$23.join$default$3();
            LogicalPlan x$67 = qual$23.join(x$64, x$65, x$66);
            JoinType x$68 = qual$22.join$default$2();
            Option x$69 = qual$22.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$22.join(x$67, x$68, x$69)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("z.a").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("z.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("x.b").attr())));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan lleft = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).subquery("z");
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery("x");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$24 = package.plans$.MODULE$.DslLogicalPlan(lleft);
            package.plans$.DslLogicalPlan qual$25 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$70 = right;
            Some x$71 = new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr()));
            JoinType x$72 = qual$25.join$default$2();
            LogicalPlan x$73 = qual$25.join(x$70, x$72, (Option)x$71);
            Some x$74 = new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("z.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("x.b").attr()));
            JoinType x$75 = qual$24.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$24.join(x$73, x$75, (Option)x$74)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
        this.test("joins: push down where clause into left anti join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftAnti$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).join(y, (JoinType)LeftAnti$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        this.test("joins: only push down join conditions to the right of a left anti join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftAnti$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10))), (JoinType)LeftAnti$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
        this.test("joins: only push down join conditions to the right of an existence join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            AttributeReference fillerVal = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)).boolean();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)new ExistenceJoin((Attribute)fillerVal), (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2)))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.b").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2))), (JoinType)new ExistenceJoin((Attribute)fillerVal), (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
        this.testRelationWithArrayType = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c_arr"}))).$((Seq)Nil$.MODULE$)).array((DataType)IntegerType$.MODULE$)}));
        this.test("generate: predicate referenced no generated column", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package.plans$.DslLogicalPlan qual$26 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationWithArrayType());
            Explode x$76 = new Explode((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c_arr"}))).$((Seq)Nil$.MODULE$));
            Some x$77 = new Some((Object)"arr");
            Seq x$78 = qual$26.generate$default$2();
            boolean x$79 = qual$26.generate$default$3();
            Seq x$80 = qual$26.generate$default$5();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$26.generate((Generator)x$76, x$78, x$79, (Option)x$77, x$80)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            package.plans$.DslLogicalPlan qual$27 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationWithArrayType()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6)))));
            Explode x$81 = new Explode((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c_arr"}))).$((Seq)Nil$.MODULE$));
            Some x$82 = new Some((Object)"arr");
            Seq x$83 = qual$27.generate$default$2();
            boolean x$84 = qual$27.generate$default$3();
            Seq x$85 = qual$27.generate$default$5();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$27.generate((Generator)x$81, x$83, x$84, (Option)x$82, x$85)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        this.test("generate: non-deterministic predicate referenced no generated column", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package.plans$.DslLogicalPlan qual$28 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationWithArrayType());
            Explode x$86 = new Explode((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c_arr"}))).$((Seq)Nil$.MODULE$));
            Some x$87 = new Some((Object)"arr");
            Seq x$88 = qual$28.generate$default$2();
            boolean x$89 = qual$28.generate$default$3();
            Seq x$90 = qual$28.generate$default$5();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$28.generate((Generator)x$86, x$88, x$89, (Option)x$87, x$90)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as("rnd"))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            package.plans$.DslLogicalPlan qual$29 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationWithArrayType()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            Explode x$91 = new Explode((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c_arr"}))).$((Seq)Nil$.MODULE$));
            Some x$92 = new Some((Object)"arr");
            Seq x$93 = qual$29.generate$default$2();
            boolean x$94 = qual$29.generate$default$3();
            Seq x$95 = qual$29.generate$default$5();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$29.generate((Generator)x$91, x$93, x$94, (Option)x$92, x$95)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as("rnd"))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
        this.test("generate: part of conjuncts referenced generated column", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Explode generator = new Explode((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c_arr"}))).$((Seq)Nil$.MODULE$));
            package.plans$.DslLogicalPlan qual$30 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationWithArrayType());
            Explode x$96 = generator;
            Some x$97 = new Some((Object)"arr");
            .colon.colon x$98 = new .colon.colon((Object)"c", (List)Nil$.MODULE$);
            Seq x$99 = qual$30.generate$default$2();
            boolean x$100 = qual$30.generate$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$30.generate((Generator)x$96, x$99, x$100, (Option)x$97, (Seq)x$98)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            package.plans$.DslLogicalPlan qual$31 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationWithArrayType()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            Explode x$101 = generator;
            Some x$102 = new Some((Object)"arr");
            .colon.colon x$103 = new .colon.colon((Object)"c", (List)Nil$.MODULE$);
            Seq x$104 = qual$31.generate$default$2();
            boolean x$105 = qual$31.generate$default$3();
            LogicalPlan referenceResult = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$31.generate((Generator)x$101, x$104, x$105, (Option)x$102, (Seq)x$103)).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6)))).analyze();
            this.assertResult(Filter.class, optimized.getClass(), Prettifier$.MODULE$.default(), new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)((Filter)optimized).condition().references().size()), Prettifier$.MODULE$.default(), new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
            this.assertResult("c", ((NamedExpression)((Filter)optimized).condition().references().toSeq().apply(0)).name(), Prettifier$.MODULE$.default(), new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
            this.comparePlans((LogicalPlan)optimized.children().apply(0), (LogicalPlan)referenceResult.children().apply(0), this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        this.test("generate: all conjuncts referenced generated column", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package.plans$.DslLogicalPlan qual$32 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationWithArrayType());
            Explode x$106 = new Explode((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c_arr"}))).$((Seq)Nil$.MODULE$));
            Some x$107 = new Some((Object)"arr");
            Seq x$108 = qual$32.generate$default$2();
            boolean x$109 = qual$32.generate$default$3();
            Seq x$110 = qual$32.generate$default$5();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$32.generate((Generator)x$106, x$108, x$109, (Option)x$107, x$110)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(6))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
        this.test("aggregate: push down filter when filter on group by expression", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c")}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c")}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
        this.test("aggregate: don't push down filter when filter not on group by expression", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            this.comparePlans(optimized, package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze(), this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
        this.test("aggregate: push down filters partially which are subset of group by expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c")}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
        this.test("aggregate: push down filters with alias", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as("aa"), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c")}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(4)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.intToLiteral(3))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).$less((Expression)package.expressions$.MODULE$.intToLiteral(3)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as("aa"), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c")}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(4))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        this.test("aggregate: push down filters with literal", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c"), (Expression)package.expressions$.MODULE$.DslString("s").as("d")}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("s"))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslString("s").$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("s")))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c"), (Expression)package.expressions$.MODULE$.DslString("s").as("d")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791));
        this.test("aggregate: don't push down filters that are nondeterministic", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)Rand$.MODULE$.apply(10L))).as("aa"), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c"), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(11L)).as("rnd")}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as("rnd"))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rnd"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)Rand$.MODULE$.apply(10L))).as("aa"), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("c"), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(11L)).as("rnd")}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as("rnd"))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rnd"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
        this.test("SPARK-17712: aggregate: don't push down filters that are data-independent", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new LocalRelation(this.testRelation().output(), (Seq)package$.MODULE$.Seq().empty(), LocalRelation$.MODULE$.apply$default$3(), LocalRelation$.MODULE$.apply$default$4())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())}))).where((Expression)package.expressions$.MODULE$.booleanToLiteral(false));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())}))).where((Expression)package.expressions$.MODULE$.booleanToLiteral(false))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
        this.test("aggregate: don't push filters if the aggregate has no grouping expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new LocalRelation(this.testRelation().output(), (Seq)package$.MODULE$.Seq().empty(), LocalRelation$.MODULE$.apply$default$3(), LocalRelation$.MODULE$.apply$default$4())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)Nil$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.count$default$2())}))).where((Expression)package.expressions$.MODULE$.booleanToLiteral(false));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        this.test("SPARK-32940: aggregate: push filters through first, last and collect", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Function1 & Serializable)x$1 -> package.expressions$.MODULE$.first(x$1, package.expressions$.MODULE$.first$default$2()), (List)new .colon.colon((Function1 & Serializable)x$2 -> package.expressions$.MODULE$.last(x$2, package.expressions$.MODULE$.last$default$2()), (List)new .colon.colon((Function1 & Serializable)x$3 -> package.expressions$.MODULE$.collectList(x$3, package.expressions$.MODULE$.collectList$default$2()), (List)new .colon.colon((Function1 & Serializable)x$4 -> package.expressions$.MODULE$.collectSet(x$4, package.expressions$.MODULE$.collectSet$default$2()), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)agg -> {
            FilterPushdownSuite.$anonfun$new$54(this, agg);
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 858));
        this.test("union", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LocalRelation testRelation2 = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int()}));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Union((Seq)new .colon.colon((Object)this.testRelation(), (List)new .colon.colon((Object)testRelation2, (List)Nil$.MODULE$)), Union$.MODULE$.apply$default$2(), Union$.MODULE$.apply$default$3())).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as("rnd"))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.longToLiteral(5L))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Union((Seq)new .colon.colon((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.longToLiteral(5L)))), (List)new .colon.colon((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)testRelation2).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(2L))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.longToLiteral(5L)))), (List)Nil$.MODULE$)), Union$.MODULE$.apply$default$2(), Union$.MODULE$.apply$default$3())).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as("rnd"))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
        this.test("union filter pushdown w/reference to grand-child field", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructField nonNullableArray = new StructField("a", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField bField = new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            LocalRelation testRelationNonNull = LocalRelation$.MODULE$.apply(nonNullableArray, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{bField}));
            LocalRelation testRelationNull = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).array((DataType)IntegerType$.MODULE$), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).int()}));
            AttributeReference nonNullArrayRef = new AttributeReference("a", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), AttributeReference$.MODULE$.apply$default$3(), AttributeReference$.MODULE$.apply$default$4(), ((NamedExpression)testRelationNonNull.output().apply(0)).exprId(), (Seq)Nil$.MODULE$);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Union((Seq)new .colon.colon((Object)testRelationNonNull, (List)new .colon.colon((Object)testRelationNull, (List)Nil$.MODULE$)), Union$.MODULE$.apply$default$2(), Union$.MODULE$.apply$default$3())).where((Expression)new IsNotNull((Expression)nonNullArrayRef));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Union((Seq)new .colon.colon((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)testRelationNonNull).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$))), (List)new .colon.colon((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)testRelationNull).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$))), (List)Nil$.MODULE$)), Union$.MODULE$.apply$default$2(), Union$.MODULE$.apply$default$3())).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
        this.test("expand", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Aggregate agg = (Aggregate)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{Cube$.MODULE$.apply((Seq)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$)))}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.sum$default$2())}))).analyze();
            Attribute a = (Attribute)agg.output().apply(0);
            Attribute b = (Attribute)agg.output().apply(1);
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)agg).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)a).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)b).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            LogicalPlan x$111 = package.plans$.MODULE$.DslLogicalPlan(agg.child()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)a).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)b).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            Seq x$112 = agg.copy$default$1();
            Seq x$113 = agg.copy$default$2();
            Option x$114 = agg.copy$default$4();
            LogicalPlan correctedAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)agg.copy(x$112, x$113, x$111, x$114)).analyze();
            this.comparePlans(optimized, correctedAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 922));
        this.test("predicate subquery: push down simple", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan z = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).int()}))).subquery("z");
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())))).where((Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(z).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("z.a").attr())), Exists$.MODULE$.apply$default$2(), Exists$.MODULE$.apply$default$3(), Exists$.MODULE$.apply$default$4(), Exists$.MODULE$.apply$default$5()))).analyze();
            LogicalPlan answer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(z).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("z.a").attr())), Exists$.MODULE$.apply$default$2(), Exists$.MODULE$.apply$default$3(), Exists$.MODULE$.apply$default$4(), Exists$.MODULE$.apply$default$5()))).join(y, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute(this.Optimize().execute((TreeNode)query));
            this.comparePlans(optimized, answer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
        this.test("predicate subquery: push down complex", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan w = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("w");
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan z = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).int()}))).subquery("z");
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(w).join(x, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("w.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("x.a").attr())))).join(y, (JoinType)LeftOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())))).where((Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(z).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("w.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("z.a").attr())), Exists$.MODULE$.apply$default$2(), Exists$.MODULE$.apply$default$3(), Exists$.MODULE$.apply$default$4(), Exists$.MODULE$.apply$default$5()))).analyze();
            LogicalPlan answer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(w).where((Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(z).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("w.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("z.a").attr())), Exists$.MODULE$.apply$default$2(), Exists$.MODULE$.apply$default$3(), Exists$.MODULE$.apply$default$4(), Exists$.MODULE$.apply$default$5()))).join(x, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("w.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("x.a").attr())))).join(y, (JoinType)LeftOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute(this.Optimize().execute((TreeNode)query));
            this.comparePlans(optimized, answer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 954));
        this.test("SPARK-20094: don't push predicate with IN subquery into join condition", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan z = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("z");
            LogicalPlan w = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("w");
            package.plans$.DslLogicalPlan qual$33 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$115 = z;
            JoinType x$116 = qual$33.join$default$2();
            Option x$117 = qual$33.join$default$3();
            LogicalPlan queryPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$33.join(x$115, x$116, x$117)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("z.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("z.c").attr()).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new ListQuery(package.plans$.MODULE$.DslLogicalPlan(w).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslString("w.d").attr()})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5(), ListQuery$.MODULE$.apply$default$6())})))))).analyze();
            LogicalPlan expectedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(z, (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("z.b").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("z.c").attr()).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new ListQuery(package.plans$.MODULE$.DslLogicalPlan(w).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslString("w.d").attr()})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5(), ListQuery$.MODULE$.apply$default$6())}))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)queryPlan);
            this.comparePlans(optimized, expectedPlan, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 974));
        this.test("Window: predicate push down -- basic", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$);
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowExpression winExpr = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window");
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$);
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 994));
        this.test("Window: predicate push down -- predicates with compound predicate using only one column", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowExpression winExpr = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window")}))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$times((Expression)package.expressions$.MODULE$.intToLiteral(3))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(15)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window");
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$times((Expression)package.expressions$.MODULE$.intToLiteral(3))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(15)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute4).$colon$colon((Object)unresolvedAttribute3), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1008));
        this.test("Window: predicate push down -- multi window expressions with the same window spec", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr1 = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec);
            WindowExpression winExpr2 = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.sum$default$2()), winSpec);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr1).as("window1"), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr2).as("window2")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExpr1).as("window1");
            NamedExpression namedExpression2 = package.expressions$.MODULE$.DslExpression((Expression)winExpr2).as("window2");
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression2).$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute4).$colon$colon((Object)unresolvedAttribute3), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window2"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1023));
        this.test("Window: predicate push down -- multi window specification - 1", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec1 = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr1 = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec1);
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec2 = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute4).$colon$colon((Object)unresolvedAttribute3), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr2 = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec2);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr1).as("window1"), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr2).as("window2")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExpr1).as("window1");
            UnresolvedAttribute unresolvedAttribute5 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute6 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            NamedExpression namedExpression2 = package.expressions$.MODULE$.DslExpression((Expression)winExpr2).as("window2");
            UnresolvedAttribute unresolvedAttribute7 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute8 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder4 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute6).$colon$colon((Object)unresolvedAttribute5), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression2), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute8).$colon$colon((Object)unresolvedAttribute7), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder4))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window2"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            NamedExpression namedExpression3 = package.expressions$.MODULE$.DslExpression((Expression)winExpr2).as("window2");
            UnresolvedAttribute unresolvedAttribute9 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute10 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder5 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).asc();
            NamedExpression namedExpression4 = package.expressions$.MODULE$.DslExpression((Expression)winExpr1).as("window1");
            UnresolvedAttribute unresolvedAttribute11 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute12 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder6 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression3), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute10).$colon$colon((Object)unresolvedAttribute9), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder5))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression4), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute12).$colon$colon((Object)unresolvedAttribute11), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder6))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window2"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            LogicalPlan optimizedQuery = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            try {
                this.comparePlans(optimizedQuery, correctAnswer1, this.comparePlans$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ae) {
                this.comparePlans(optimizedQuery, correctAnswer2, this.comparePlans$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1040));
        this.test("Window: predicate push down -- multi window specification - 2", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec1 = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr1 = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec1);
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec2 = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr2 = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec2);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr1).as("window1"), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr2).as("window2")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExpr1).as("window1");
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            NamedExpression namedExpression2 = package.expressions$.MODULE$.DslExpression((Expression)winExpr2).as("window2");
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder4 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute3), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression2), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute4), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder4))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window2"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            NamedExpression namedExpression3 = package.expressions$.MODULE$.DslExpression((Expression)winExpr2).as("window2");
            UnresolvedAttribute unresolvedAttribute5 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder5 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            NamedExpression namedExpression4 = package.expressions$.MODULE$.DslExpression((Expression)winExpr1).as("window1");
            UnresolvedAttribute unresolvedAttribute6 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder6 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression3), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute5), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder5))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression4), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute6), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder6))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window2"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            LogicalPlan optimizedQuery = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            try {
                this.comparePlans(optimizedQuery, correctAnswer1, this.comparePlans$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ae) {
                this.comparePlans(optimizedQuery, correctAnswer2, this.comparePlans$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1073));
        this.test("Window: predicate push down -- predicates with multiple partitioning columns", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowExpression winExpr = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window")}))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window");
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute4).$colon$colon((Object)unresolvedAttribute3), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1106));
        this.ignore("Window: predicate push down -- complex predicate with the same expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Expression expression = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr()).$plus((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr());
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)expression), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec);
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_w0"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpecAnalyzed = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExprAnalyzed = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpecAnalyzed);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window")}))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExprAnalyzed).as("window");
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_w0"}))).$((Seq)Nil$.MODULE$);
            SortOrder sortOrder3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).as("_w0")}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1124));
        this.test("Window: no predicate push down -- predicates are not from partitioning keys", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window");
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute4).$colon$colon((Object)unresolvedAttribute3), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1147));
        this.test("Window: no predicate push down -- partial compound partition key", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Expression expression = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr()).$plus((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr());
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute).$colon$colon((Object)expression), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window")}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_w0"}))).$((Seq)Nil$.MODULE$)).attr();
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpecAnalyzed = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute3).$colon$colon((Object)unresolvedAttribute2), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExprAnalyzed = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpecAnalyzed);
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExprAnalyzed).as("window");
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_w0"}))).$((Seq)Nil$.MODULE$);
            UnresolvedAttribute unresolvedAttribute5 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).as("_w0")}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute5).$colon$colon((Object)unresolvedAttribute4), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1164));
        this.test("Window: no predicate push down -- complex predicates containing non partitioning columns", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window")}))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window");
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1188));
        this.test("Window: no predicate push down -- complex predicate with different expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Expression expression = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).attr()).$plus((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).attr());
            SortOrder sortOrder = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpec = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)expression), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExpr = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpec);
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_w0"}))).$((Seq)Nil$.MODULE$)).attr();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            WindowSpecDefinition winSpecAnalyzed = package.expressions$.MODULE$.windowSpec((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder2), (WindowFrame)UnspecifiedFrame$.MODULE$);
            WindowExpression winExprAnalyzed = package.expressions$.MODULE$.windowExpr(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2()), winSpecAnalyzed);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)winExpr).as("window")}))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$minus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            NamedExpression namedExpression = package.expressions$.MODULE$.DslExpression((Expression)winExprAnalyzed).as("window");
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_w0"}))).$((Seq)Nil$.MODULE$);
            SortOrder sortOrder3 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).as("_w0")}))).window((Seq)Nil$.MODULE$.$colon$colon((Object)namedExpression), (Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$minus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1205));
        this.test("watermark pushdown: no pushdown on watermark attribute #1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            CalendarInterval interval = new CalendarInterval(2, 2, 2000L);
            LocalRelation relation = new LocalRelation((Seq)new .colon.colon((Object)this.attrA(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).timestamp(), (List)new .colon.colon((Object)this.attrC(), (List)Nil$.MODULE$))), (Seq)Nil$.MODULE$, true, LocalRelation$.MODULE$.apply$default$4());
            UUID nodeId = UUID.randomUUID();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new EventTimeWatermark(nodeId, (Attribute)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), interval, (LogicalPlan)relation)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.timestampToLiteral(new Timestamp(0L))))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new EventTimeWatermark(nodeId, (Attribute)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), interval, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5)))))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.timestampToLiteral(new Timestamp(0L))));
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), package.plans$.MODULE$.DslLogicalPlan(correctAnswer).analyze(), this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1228));
        this.test("watermark pushdown: no pushdown for nondeterministic filter", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            CalendarInterval interval = new CalendarInterval(2, 2, 2000L);
            LocalRelation relation = new LocalRelation((Seq)new .colon.colon((Object)this.attrA(), (List)new .colon.colon((Object)this.attrB(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).timestamp(), (List)Nil$.MODULE$))), (Seq)Nil$.MODULE$, true, LocalRelation$.MODULE$.apply$default$4());
            UUID nodeId = UUID.randomUUID();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new EventTimeWatermark(nodeId, (Attribute)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), interval, (LogicalPlan)relation)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)Rand$.MODULE$.apply(10L)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.timestampToLiteral(new Timestamp(0L)))));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new EventTimeWatermark(nodeId, (Attribute)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), interval, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)Rand$.MODULE$.apply(10L))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.timestampToLiteral(new Timestamp(0L)))));
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), package.plans$.MODULE$.DslLogicalPlan(correctAnswer).analyze(), false);
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1244));
        this.test("watermark pushdown: full pushdown", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            CalendarInterval interval = new CalendarInterval(2, 2, 2000L);
            LocalRelation relation = new LocalRelation((Seq)new .colon.colon((Object)this.attrA(), (List)new .colon.colon((Object)this.attrB(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).timestamp(), (List)Nil$.MODULE$))), (Seq)Nil$.MODULE$, true, LocalRelation$.MODULE$.apply$default$4());
            UUID nodeId = UUID.randomUUID();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new EventTimeWatermark(nodeId, (Attribute)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), interval, (LogicalPlan)relation)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10))));
            EventTimeWatermark correctAnswer = new EventTimeWatermark(nodeId, (Attribute)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), interval, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10)))));
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)correctAnswer).analyze(), false);
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1261));
        this.test("watermark pushdown: no pushdown on watermark attribute #2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            CalendarInterval interval = new CalendarInterval(2, 2, 2000L);
            LocalRelation relation = new LocalRelation((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).timestamp(), (List)new .colon.colon((Object)this.attrB(), (List)new .colon.colon((Object)this.attrC(), (List)Nil$.MODULE$))), (Seq)Nil$.MODULE$, true, LocalRelation$.MODULE$.apply$default$4());
            UUID nodeId = UUID.randomUUID();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new EventTimeWatermark(nodeId, (Attribute)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), interval, (LogicalPlan)relation)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.timestampToLiteral(new Timestamp(0L)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10))));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new EventTimeWatermark(nodeId, (Attribute)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), interval, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10))))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.timestampToLiteral(new Timestamp(0L))));
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze()), package.plans$.MODULE$.DslLogicalPlan(correctAnswer).analyze(), false);
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1277));
        this.test("push down predicate through expand", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)new Expand((Seq)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(1), (List)Nil$.MODULE$))))), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(2), (List)Nil$.MODULE$))))), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (LogicalPlan)this.testRelation()))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Expand((Seq)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(1), (List)Nil$.MODULE$))))), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(2), (List)Nil$.MODULE$))))), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)this.testRelation()))).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1291));
        this.test("SPARK-28345: PythonUDF predicate should be able to pushdown to join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            PythonUDF pythonUDF = new PythonUDF("pythonUDF", null, (DataType)IntegerType$.MODULE$, (Seq)new .colon.colon((Object)this.attrA(), (List)Nil$.MODULE$), PythonEvalType$.MODULE$.SQL_BATCHED_UDF(), true, PythonUDF$.MODULE$.apply$default$7());
            Predicate pythonUDFJoinCond = package.expressions$.MODULE$.DslExpression((Expression)pythonUDF).$eq$eq$eq((Expression)this.attrD());
            package.plans$.DslLogicalPlan qual$34 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation());
            LocalRelation x$118 = this.testRelation1();
            Cross$ x$119 = Cross$.MODULE$;
            Option x$120 = qual$34.join$default$3();
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(qual$34.join((LogicalPlan)x$118, (JoinType)x$119, x$120)).where((Expression)pythonUDFJoinCond);
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).join((LogicalPlan)this.testRelation1(), (JoinType)Cross$.MODULE$, (Option)new Some((Object)pythonUDFJoinCond))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze()), expected, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1313));
        this.test("push down filter predicates through inner join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$35 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$121 = y;
            JoinType x$122 = qual$35.join$default$2();
            Option x$123 = qual$35.join$default$3();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$35.join(x$121, x$122, x$123)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)this.simpleDisjunctivePredicate()));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            this.comparePlans(optimized, this.expectedPredicatePushDownResult(), this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1335));
        this.test("push down join predicates through inner join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$36 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$124 = y;
            Some x$125 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)this.simpleDisjunctivePredicate()));
            JoinType x$126 = qual$36.join$default$2();
            LogicalPlan originalQuery = qual$36.join(x$124, x$126, (Option)x$125);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            this.comparePlans(optimized, this.expectedPredicatePushDownResult(), this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1345));
        this.test("push down complex predicates through inner join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            Predicate joinCondition = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(14))))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(9)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(27)))));
            package.plans$.DslLogicalPlan qual$37 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$127 = y;
            Some x$128 = new Some((Object)joinCondition);
            JoinType x$129 = qual$37.join$default$2();
            LogicalPlan originalQuery = qual$37.join(x$127, x$129, (Option)x$128);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).subquery("x");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(14))))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(9))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(27)))))).subquery("y");
            package.plans$.DslLogicalPlan qual$38 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$130 = right;
            Some x$131 = new Some((Object)joinCondition);
            JoinType x$132 = qual$38.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$38.join(x$130, x$132, (Option)x$131)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1356));
        this.test("push down predicates(with NOT predicate) through inner join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$39 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$133 = y;
            Some x$134 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)new Not((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(2))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(13))))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11)))))));
            JoinType x$135 = qual$39.join$default$2();
            LogicalPlan originalQuery = qual$39.join(x$133, x$135, (Option)x$134);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(3))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))))).subquery("x");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$40 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$136 = right;
            Some x$137 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(3))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(13)))))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(11)))));
            JoinType x$138 = qual$40.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$40.join(x$136, x$138, (Option)x$137)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1377));
        this.test("push down predicates through left join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)this.simpleDisjunctivePredicate())));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(13))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))))).subquery("y");
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(13)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11)))))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1397));
        this.test("push down predicates through right join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)this.simpleDisjunctivePredicate())));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))))).subquery("x");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(13)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11)))))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1416));
        this.test("SPARK-32302: avoid generating too many predicates", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            package.plans$.DslLogicalPlan qual$41 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$139 = y;
            Some x$140 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(13)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.c").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(5)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.c").attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(1))))));
            JoinType x$141 = qual$41.join$default$2();
            LogicalPlan originalQuery = qual$41.join(x$139, x$141, (Option)x$140);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(5))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))))).subquery("y");
            package.plans$.DslLogicalPlan qual$42 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$142 = right;
            Some x$143 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(13)))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.c").attr()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(5)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.c").attr()).$less((Expression)package.expressions$.MODULE$.intToLiteral(1))))));
            JoinType x$144 = qual$42.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$42.join(x$142, x$144, (Option)x$143)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1435));
        this.test("push down predicate through multiple joins", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("y");
            LogicalPlan z = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("z");
            package.plans$.DslLogicalPlan qual$43 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$145 = y;
            Some x$146 = new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr()));
            JoinType x$147 = qual$43.join$default$2();
            LogicalPlan xJoinY = qual$43.join(x$145, x$147, (Option)x$146);
            package.plans$.DslLogicalPlan qual$44 = package.plans$.MODULE$.DslLogicalPlan(z);
            LogicalPlan x$148 = xJoinY;
            Some x$149 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("z.a").attr())).$amp$amp((Expression)this.simpleDisjunctivePredicate()));
            JoinType x$150 = qual$44.join$default$2();
            LogicalPlan originalQuery = qual$44.join(x$148, x$150, (Option)x$149);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(13))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(11))));
            package.plans$.DslLogicalPlan qual$45 = package.plans$.MODULE$.DslLogicalPlan(z);
            package.plans$.DslLogicalPlan qual$46 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$151 = right;
            Some x$152 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())).$amp$amp((Expression)this.simpleDisjunctivePredicate()));
            JoinType x$153 = qual$46.join$default$2();
            LogicalPlan x$154 = qual$46.join(x$151, x$153, (Option)x$152);
            Some x$155 = new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("z.a").attr()));
            JoinType x$156 = qual$45.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$45.join(x$154, x$156, (Option)x$155)).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1453));
        this.test("SPARK-37828: Push down filters through RebalancePartitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new RebalancePartitions((Seq)package$.MODULE$.Seq().empty(), (LogicalPlan)this.testRelation(), RebalancePartitions$.MODULE$.apply$default$3(), RebalancePartitions$.MODULE$.apply$default$4())).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new RebalancePartitions((Seq)package$.MODULE$.Seq().empty(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(3))), RebalancePartitions$.MODULE$.apply$default$3(), RebalancePartitions$.MODULE$.apply$default$4())).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1470));
        this.test("SPARK-46707: push down predicate with sequence (without step) through joins", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan queryWithStep = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"y.d"}))).$((Seq)Nil$.MODULE$))))).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)new Some((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), Sequence$.MODULE$.apply$default$4())))).analyze();
            LogicalPlan optimizedQueryWithStep = (LogicalPlan)this.Optimize().execute((TreeNode)queryWithStep);
            this.comparePlans(optimizedQueryWithStep, queryWithStep, this.comparePlans$default$3());
            LogicalPlan queryWithoutStep = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"y.d"}))).$((Seq)Nil$.MODULE$))))).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)None$.MODULE$, Sequence$.MODULE$.apply$default$4())))).analyze();
            LogicalPlan optimizedQueryWithoutStep = (LogicalPlan)this.Optimize().execute((TreeNode)queryWithoutStep);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)None$.MODULE$, Sequence$.MODULE$.apply$default$4())))).join(y, (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.c"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"y.d"}))).$((Seq)Nil$.MODULE$))))).analyze();
            this.comparePlans(optimizedQueryWithoutStep, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1478));
        this.test("SPARK-46707: push down predicate with sequence (without step) through aggregates", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan queryWithStep = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)new Some((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), Sequence$.MODULE$.apply$default$4())))).analyze();
            LogicalPlan optimizedQueryWithStep = (LogicalPlan)this.Optimize().execute((TreeNode)queryWithStep);
            LogicalPlan correctAnswerWithStep = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)new Some((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), Sequence$.MODULE$.apply$default$4())))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans(optimizedQueryWithStep, correctAnswerWithStep, this.comparePlans$default$3());
            LogicalPlan queryWithoutStep = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)None$.MODULE$, Sequence$.MODULE$.apply$default$4())))).analyze();
            LogicalPlan optimizedQueryWithoutStep = (LogicalPlan)this.Optimize().execute((TreeNode)queryWithoutStep);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)None$.MODULE$, Sequence$.MODULE$.apply$default$4())))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans(optimizedQueryWithoutStep, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1500));
        this.test("SPARK-46707: combine predicate with sequence (without step) with other filters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan queryWithStep = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)new Some((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), Sequence$.MODULE$.apply$default$4())))).analyze();
            LogicalPlan optimizedQueryWithStep = (LogicalPlan)this.Optimize().execute((TreeNode)queryWithStep);
            this.comparePlans(optimizedQueryWithStep, queryWithStep, this.comparePlans$default$3());
            LogicalPlan queryWithoutStep = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).where((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)None$.MODULE$, Sequence$.MODULE$.apply$default$4())))).analyze();
            LogicalPlan optimizedQueryWithoutStep = (LogicalPlan)this.Optimize().execute((TreeNode)queryWithoutStep);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)new Sequence((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.b"}))).$((Seq)Nil$.MODULE$), (Option)None$.MODULE$, Sequence$.MODULE$.apply$default$4()))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x.c"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))))).analyze();
            this.comparePlans(optimizedQueryWithoutStep, correctAnswer, this.comparePlans$default$3());
        }, new Position("FilterPushdownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1523));
    }
}

