/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildRight$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.optimizer.JoinSelectionHelper;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.BROADCAST$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.NO_BROADCAST_HASH$;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_HASH$;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005I3AAD\b\u00019!)1\u0006\u0001C\u0001Y!9a\u0006\u0001b\u0001\n\u0013y\u0003B\u0002\u001c\u0001A\u0003%\u0001\u0007C\u00048\u0001\t\u0007I\u0011B\u0018\t\ra\u0002\u0001\u0015!\u00031\u0011\u001dI\u0004A1A\u0005\niBa!\u0011\u0001!\u0002\u0013Y\u0004b\u0002\"\u0001\u0005\u0004%Ia\u0011\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002#\t\u000f9\u0003!\u0019!C\u0005\u0007\"1q\n\u0001Q\u0001\n\u0011Cq\u0001\u0015\u0001C\u0002\u0013%1\t\u0003\u0004R\u0001\u0001\u0006I\u0001\u0012\u0002\u0019\u0015>LgnU3mK\u000e$\u0018n\u001c8IK2\u0004XM]*vSR,'B\u0001\t\u0012\u0003%y\u0007\u000f^5nSj,'O\u0003\u0002\u0013'\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001;\u0005:\u0003C\u0001\u0010 \u001b\u0005)\u0012B\u0001\u0011\u0016\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!%J\u0007\u0002G)\u0011A%E\u0001\u0006a2\fgn]\u0005\u0003M\r\u0012\u0001\u0002\u00157b]R+7\u000f\u001e\t\u0003Q%j\u0011aD\u0005\u0003U=\u00111CS8j]N+G.Z2uS>t\u0007*\u001a7qKJ\fa\u0001P5oSRtD#A\u0017\u0011\u0005!\u0002\u0011\u0001\u00027fMR,\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0003gE\tqb\u001d;biN,5\u000f^5nCRLwN\\\u0005\u0003kI\u0012Qb\u0015;biN$Vm\u001d;QY\u0006t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0003k_&tW#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005y\u001a\u0013a\u00027pO&\u001c\u0017\r\\\u0005\u0003\u0001v\u0012AAS8j]\u0006)!n\\5oA\u0005i\u0001.\u001b8u\u0005J|\u0017\rZ2bgR,\u0012\u0001\u0012\t\u0004\u000b\"SU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\tM{W.\u001a\t\u0003y-K!\u0001T\u001f\u0003\u0011!Kg\u000e^%oM>\fa\u0002[5oi\n\u0013x.\u00193dCN$\b%\u0001\niS:$hj\u001c;U_\n\u0013x.\u00193dCN$\u0018a\u00055j]Rtu\u000e\u001e+p\u0005J|\u0017\rZ2bgR\u0004\u0013a\u00045j]R\u001c\u0006.\u001e4gY\u0016D\u0015m\u001d5\u0002!!Lg\u000e^*ik\u001a4G.\u001a%bg\"\u0004\u0003")
public class JoinSelectionHelperSuite
extends SparkFunSuite
implements PlanTest,
JoinSelectionHelper {
    private final StatsTestPlan left;
    private final StatsTestPlan right;
    private final Join join;
    private final Some<HintInfo> hintBroadcast;
    private final Some<HintInfo> hintNotToBroadcast;
    private final Some<HintInfo> hintShuffleHash;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public Option<BuildSide> getBroadcastBuildSide(Join join, boolean hintOnly, SQLConf conf) {
        return JoinSelectionHelper.getBroadcastBuildSide$((JoinSelectionHelper)this, (Join)join, (boolean)hintOnly, (SQLConf)conf);
    }

    public Option<BuildSide> getShuffleHashJoinBuildSide(Join join, boolean hintOnly, SQLConf conf) {
        return JoinSelectionHelper.getShuffleHashJoinBuildSide$((JoinSelectionHelper)this, (Join)join, (boolean)hintOnly, (SQLConf)conf);
    }

    public Option<BuildSide> getBroadcastNestedLoopJoinBuildSide(JoinHint hint, JoinType joinType) {
        return JoinSelectionHelper.getBroadcastNestedLoopJoinBuildSide$((JoinSelectionHelper)this, (JoinHint)hint, (JoinType)joinType);
    }

    public BuildSide getSmallerSide(LogicalPlan left, LogicalPlan right) {
        return JoinSelectionHelper.getSmallerSide$((JoinSelectionHelper)this, (LogicalPlan)left, (LogicalPlan)right);
    }

    public boolean canBroadcastBySize(LogicalPlan plan, SQLConf conf) {
        return JoinSelectionHelper.canBroadcastBySize$((JoinSelectionHelper)this, (LogicalPlan)plan, (SQLConf)conf);
    }

    public boolean canBuildBroadcastLeft(JoinType joinType) {
        return JoinSelectionHelper.canBuildBroadcastLeft$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canBuildBroadcastRight(JoinType joinType) {
        return JoinSelectionHelper.canBuildBroadcastRight$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canBuildShuffledHashJoinLeft(JoinType joinType) {
        return JoinSelectionHelper.canBuildShuffledHashJoinLeft$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canBuildShuffledHashJoinRight(JoinType joinType) {
        return JoinSelectionHelper.canBuildShuffledHashJoinRight$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean hashJoinSupported(Seq<Expression> leftKeys, Seq<Expression> rightKeys) {
        return JoinSelectionHelper.hashJoinSupported$((JoinSelectionHelper)this, leftKeys, rightKeys);
    }

    public boolean canPlanAsBroadcastHashJoin(Join join, SQLConf conf) {
        return JoinSelectionHelper.canPlanAsBroadcastHashJoin$((JoinSelectionHelper)this, (Join)join, (SQLConf)conf);
    }

    public boolean canPruneLeft(JoinType joinType) {
        return JoinSelectionHelper.canPruneLeft$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean canPruneRight(JoinType joinType) {
        return JoinSelectionHelper.canPruneRight$((JoinSelectionHelper)this, (JoinType)joinType);
    }

    public boolean hintToBroadcastLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToBroadcastLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToBroadcastRight(JoinHint hint) {
        return JoinSelectionHelper.hintToBroadcastRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToNotBroadcastLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToNotBroadcastLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToNotBroadcastRight(JoinHint hint) {
        return JoinSelectionHelper.hintToNotBroadcastRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToShuffleHashJoinLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToShuffleHashJoinLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToShuffleHashJoinRight(JoinHint hint) {
        return JoinSelectionHelper.hintToShuffleHashJoinRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToPreferShuffleHashJoinLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToPreferShuffleHashJoinLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToPreferShuffleHashJoinRight(JoinHint hint) {
        return JoinSelectionHelper.hintToPreferShuffleHashJoinRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToPreferShuffleHashJoin(JoinHint hint) {
        return JoinSelectionHelper.hintToPreferShuffleHashJoin$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToShuffleHashJoin(JoinHint hint) {
        return JoinSelectionHelper.hintToShuffleHashJoin$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToSortMergeJoin(JoinHint hint) {
        return JoinSelectionHelper.hintToSortMergeJoin$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToShuffleReplicateNL(JoinHint hint) {
        return JoinSelectionHelper.hintToShuffleReplicateNL$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToNotBroadcastAndReplicate(JoinHint hint) {
        return JoinSelectionHelper.hintToNotBroadcastAndReplicate$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToNotBroadcastAndReplicateLeft(JoinHint hint) {
        return JoinSelectionHelper.hintToNotBroadcastAndReplicateLeft$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    public boolean hintToNotBroadcastAndReplicateRight(JoinHint hint) {
        return JoinSelectionHelper.hintToNotBroadcastAndReplicateRight$((JoinSelectionHelper)this, (JoinHint)hint);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        JoinSelectionHelperSuite joinSelectionHelperSuite = this;
        synchronized (joinSelectionHelperSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private StatsTestPlan left() {
        return this.left;
    }

    private StatsTestPlan right() {
        return this.right;
    }

    private Join join() {
        return this.join;
    }

    private Some<HintInfo> hintBroadcast() {
        return this.hintBroadcast;
    }

    private Some<HintInfo> hintNotToBroadcast() {
        return this.hintNotToBroadcast;
    }

    private Some<HintInfo> hintShuffleHash() {
        return this.hintShuffleHash;
    }

    public JoinSelectionHelperSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        JoinSelectionHelper.$init$((JoinSelectionHelper)this);
        .colon.colon x$1 = new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$)));
        BigInt x$2 = BigInt$.MODULE$.int2bigInt(20000000);
        Some x$3 = new Some((Object)BigInt$.MODULE$.int2bigInt(20000000));
        AttributeMap x$4 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.left = new StatsTestPlan((Seq<Attribute>)x$1, x$2, (AttributeMap<ColumnStat>)x$4, (Option<BigInt>)x$3);
        .colon.colon x$5 = new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$);
        BigInt x$6 = BigInt$.MODULE$.int2bigInt(1000);
        Some x$7 = new Some((Object)BigInt$.MODULE$.int2bigInt(1000));
        AttributeMap x$8 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.right = new StatsTestPlan((Seq<Attribute>)x$5, x$6, (AttributeMap<ColumnStat>)x$8, (Option<BigInt>)x$7);
        this.join = new Join((LogicalPlan)this.left(), (LogicalPlan)this.right(), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$));
        this.hintBroadcast = new Some((Object)new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$)));
        this.hintNotToBroadcast = new Some((Object)new HintInfo((Option)new Some((Object)NO_BROADCAST_HASH$.MODULE$)));
        this.hintShuffleHash = new Some((Object)new HintInfo((Option)new Some((Object)SHUFFLE_HASH$.MODULE$)));
        this.test("getBroadcastBuildSide (hintOnly = true) return BuildLeft with only a left hint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$9 = new JoinHint(this.hintBroadcast(), (Option)None$.MODULE$);
            LogicalPlan x$10 = this.join().copy$default$1();
            LogicalPlan x$11 = this.join().copy$default$2();
            JoinType x$12 = this.join().copy$default$3();
            Option x$13 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.join().copy(x$10, x$11, x$12, x$13, x$9), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildLeft$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("getBroadcastBuildSide (hintOnly = true) return BuildRight with only a right hint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$14 = new JoinHint((Option)None$.MODULE$, this.hintBroadcast());
            LogicalPlan x$15 = this.join().copy$default$1();
            LogicalPlan x$16 = this.join().copy$default$2();
            JoinType x$17 = this.join().copy$default$3();
            Option x$18 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.join().copy(x$15, x$16, x$17, x$18, x$14), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("getBroadcastBuildSide (hintOnly = true) return smaller side with both having hints", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$19 = new JoinHint(this.hintBroadcast(), this.hintBroadcast());
            LogicalPlan x$20 = this.join().copy$default$1();
            LogicalPlan x$21 = this.join().copy$default$2();
            JoinType x$22 = this.join().copy$default$3();
            Option x$23 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.join().copy(x$20, x$21, x$22, x$23, x$19), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("getBroadcastBuildSide (hintOnly = true) return None when no side has a hint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$24 = new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$);
            LogicalPlan x$25 = this.join().copy$default$1();
            LogicalPlan x$26 = this.join().copy$default$2();
            JoinType x$27 = this.join().copy$default$3();
            Option x$28 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.join().copy(x$25, x$26, x$27, x$28, x$24), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("getBroadcastBuildSide (hintOnly = false) return BuildRight when right is broadcastable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$29 = new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$);
            LogicalPlan x$30 = this.join().copy$default$1();
            LogicalPlan x$31 = this.join().copy$default$2();
            JoinType x$32 = this.join().copy$default$3();
            Option x$33 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.join().copy(x$30, x$31, x$32, x$33, x$29), false, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("getBroadcastBuildSide (hintOnly = false) return None when right has no broadcast hint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"10MB")}), (Function0 & Serializable)() -> {
            JoinHint x$34 = new JoinHint((Option)None$.MODULE$, this.hintNotToBroadcast());
            LogicalPlan x$35 = this.join().copy$default$1();
            LogicalPlan x$36 = this.join().copy$default$2();
            JoinType x$37 = this.join().copy$default$3();
            Option x$38 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.join().copy(x$35, x$36, x$37, x$38, x$34), false, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("getShuffleHashJoinBuildSide (hintOnly = true) return BuildLeft with only a left hint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$39 = new JoinHint(this.hintShuffleHash(), (Option)None$.MODULE$);
            LogicalPlan x$40 = this.join().copy$default$1();
            LogicalPlan x$41 = this.join().copy$default$2();
            JoinType x$42 = this.join().copy$default$3();
            Option x$43 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getShuffleHashJoinBuildSide(this.join().copy(x$40, x$41, x$42, x$43, x$39), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildLeft$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("getShuffleHashJoinBuildSide (hintOnly = true) return BuildRight with only a right hint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$44 = new JoinHint((Option)None$.MODULE$, this.hintShuffleHash());
            LogicalPlan x$45 = this.join().copy$default$1();
            LogicalPlan x$46 = this.join().copy$default$2();
            JoinType x$47 = this.join().copy$default$3();
            Option x$48 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getShuffleHashJoinBuildSide(this.join().copy(x$45, x$46, x$47, x$48, x$44), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("getShuffleHashJoinBuildSide (hintOnly = true) return smaller side when both have hints", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$49 = new JoinHint(this.hintShuffleHash(), this.hintShuffleHash());
            LogicalPlan x$50 = this.join().copy$default$1();
            LogicalPlan x$51 = this.join().copy$default$2();
            JoinType x$52 = this.join().copy$default$3();
            Option x$53 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getShuffleHashJoinBuildSide(this.join().copy(x$50, x$51, x$52, x$53, x$49), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("getShuffleHashJoinBuildSide (hintOnly = true) return None when no side has a hint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$54 = new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$);
            LogicalPlan x$55 = this.join().copy$default$1();
            LogicalPlan x$56 = this.join().copy$default$2();
            JoinType x$57 = this.join().copy$default$3();
            Option x$58 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getShuffleHashJoinBuildSide(this.join().copy(x$55, x$56, x$57, x$58, x$54), true, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("getShuffleHashJoinBuildSide (hintOnly = false) return BuildRight when right is smaller", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JoinHint x$59 = new JoinHint((Option)None$.MODULE$, (Option)None$.MODULE$);
            LogicalPlan x$60 = this.join().copy$default$1();
            LogicalPlan x$61 = this.join().copy$default$2();
            JoinType x$62 = this.join().copy$default$3();
            Option x$63 = this.join().copy$default$4();
            Option<BuildSide> broadcastSide = this.getBroadcastBuildSide(this.join().copy(x$60, x$61, x$62, x$63, x$59), false, SQLConf$.MODULE$.get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(broadcastSide);
            Some $org_scalatest_assert_macro_right = new Some((Object)BuildRight$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("getSmallerSide should return BuildRight", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getSmallerSide(this.left(), this.right()));
            BuildRight$ $org_scalatest_assert_macro_right = BuildRight$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }, new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("canBroadcastBySize should return true if the plan size is less than 10MB", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"10MB")}), (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.canBroadcastBySize(this.left(), SQLConf$.MODULE$.get())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.canBroadcastBySize(this.right(), SQLConf$.MODULE$.get())));
            boolean $org_scalatest_assert_macro_right2 = true;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }), new Position("JoinSelectionHelperSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
    }
}

