/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.CollapseProject$;
import org.apache.spark.sql.catalyst.optimizer.ColumnPruning$;
import org.apache.spark.sql.catalyst.optimizer.OptimizerLoggingSuite$Optimize$;
import org.apache.spark.sql.catalyst.optimizer.PushPredicateThroughNonJoin$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000594A\u0001C\u0005\u0001-!)\u0011\u0005\u0001C\u0001E\u001d)Q\u0005\u0001E\u0001M\u0019)\u0001\u0006\u0001E\u0001S!)\u0011e\u0001C\u0001m!9qg\u0001b\u0001\n\u0003A\u0004BB$\u0004A\u0003%\u0011\bC\u0003I\u0001\u0011%\u0011JA\u000bPaRLW.\u001b>fe2{wmZ5oON+\u0018\u000e^3\u000b\u0005)Y\u0011!C8qi&l\u0017N_3s\u0015\taQ\"\u0001\u0005dCR\fG._:u\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001qc\u0007\t\u00031ei\u0011aD\u0005\u00035=\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\f\u0003\u0015\u0001H.\u00198t\u0013\t\u0001SD\u0001\u0005QY\u0006tG+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t\u0011\"\u0001\u0005PaRLW.\u001b>f!\t93!D\u0001\u0001\u0005!y\u0005\u000f^5nSj,7CA\u0002+!\rYc\u0006M\u0007\u0002Y)\u0011QfC\u0001\u0006eVdWm]\u0005\u0003_1\u0012ABU;mK\u0016CXmY;u_J\u0004\"!\r\u001b\u000e\u0003IR!aM\u000f\u0002\u000f1|w-[2bY&\u0011QG\r\u0002\f\u0019><\u0017nY1m!2\fg\u000eF\u0001'\u0003\u001d\u0011\u0017\r^2iKN,\u0012!\u000f\t\u0004u\u0005\u001bU\"A\u001e\u000b\u0005qj\u0014!C5n[V$\u0018M\u00197f\u0015\tqt(\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005n\u0012A\u0001T5tiB\u0011A)R\u0007\u0002\u0007%\u0011aI\f\u0002\u0006\u0005\u0006$8\r[\u0001\tE\u0006$8\r[3tA\u0005Ia/\u001a:jMfdun\u001a\u000b\u0004\u0015:C\u0006CA&M\u001b\u0005y\u0014BA'@\u0005\u0011)f.\u001b;\t\u000b=;\u0001\u0019\u0001)\u0002\u001b\u0015D\b/Z2uK\u0012dUM^3m!\t\tf+D\u0001S\u0015\t\u0019F+A\u0003m_\u001e$$N\u0003\u0002V#\u00059An\\4hS:<\u0017BA,S\u0005\u0015aUM^3m\u0011\u0015Iv\u00011\u0001[\u0003Y)\u0007\u0010]3di\u0016$'+\u001e7fg>\u0013()\u0019;dQ\u0016\u001c\bcA.dM:\u0011A,\u0019\b\u0003;\u0002l\u0011A\u0018\u0006\u0003?V\ta\u0001\u0010:p_Rt\u0014\"\u0001!\n\u0005\t|\u0014a\u00029bG.\fw-Z\u0005\u0003I\u0016\u00141aU3r\u0015\t\u0011w\b\u0005\u0002hW:\u0011\u0001.\u001b\t\u0003;~J!A[ \u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003U~\u0002")
public class OptimizerLoggingSuite
extends SparkFunSuite
implements PlanTest {
    private volatile OptimizerLoggingSuite$Optimize$ Optimize$module;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public OptimizerLoggingSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        OptimizerLoggingSuite optimizerLoggingSuite = this;
        synchronized (optimizerLoggingSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private void verifyLog(Level expectedLevel, Seq<String> expectedRulesOrBatches) {
        SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, "optimizer rules", this.LogAppender().$lessinit$greater$default$2());
        logAppender.setThreshold(expectedLevel);
        this.withLogAppender((AbstractAppender)logAppender, (Seq)new .colon.colon((Object)"org.apache.spark.sql.catalyst.rules.PlanChangeLogger", (List)Nil$.MODULE$), (Option)new Some((Object)Level.TRACE), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LocalRelation input = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).string(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).double()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)input).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).analyze();
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)input).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)query), expected, this.comparePlans$default$3());
        });
        ArrayBuffer events = (ArrayBuffer)logAppender.loggingEvents().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)OptimizerLoggingSuite.$anonfun$verifyLog$2(x0$1)));
        ArrayBuffer logMessages = (ArrayBuffer)events.map((Function1 & Serializable)x$1 -> x$1.getMessage().getFormattedMessage());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(expectedRulesOrBatches.forall((Function1 & Serializable)ruleOrBatch -> BoxesRunTime.boxToBoolean((boolean)logMessages.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(ruleOrBatch))))), "expectedRulesOrBatches.forall(((ruleOrBatch: String) => logMessages.exists(((x$2: String) => x$2.contains(ruleOrBatch)))))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(events.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)OptimizerLoggingSuite.$anonfun$verifyLog$7(expectedLevel, x$3))), "events.forall(((x$3: org.apache.logging.log4j.core.LogEvent) => x$3.getLevel().==(expectedLevel)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        .colon.colon expectedMetrics = new .colon.colon((Object)"Total number of runs: 7", (List)new .colon.colon((Object)"Total time:", (List)new .colon.colon((Object)"Total number of effective runs: 3", (List)new .colon.colon((Object)"Total time of effective runs:", (List)Nil$.MODULE$))));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedMetrics.forall((Function1 & Serializable)metrics -> BoxesRunTime.boxToBoolean((boolean)logMessages.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains(metrics))))), "expectedMetrics.forall(((metrics: String) => logMessages.exists(((x$4: String) => x$4.contains(metrics)))))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
    }

    private final void Optimize$lzycompute$1() {
        OptimizerLoggingSuite optimizerLoggingSuite = this;
        synchronized (optimizerLoggingSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new OptimizerLoggingSuite$Optimize$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyLog$2(LogEvent x0$1) {
        LogEvent logEvent = x0$1;
        String string = logEvent.getMessage().getFormattedMessage();
        return new .colon.colon((Object)"Applying Rule", (List)new .colon.colon((Object)"Result of Batch", (List)new .colon.colon((Object)"has no effect", (List)new .colon.colon((Object)"Metrics of Executed Rules", (List)Nil$.MODULE$)))).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)string.contains(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLog$7(Level expectedLevel$1, LogEvent x$3) {
        Level level = x$3.getLevel();
        Level level2 = expectedLevel$1;
        return !(level != null ? !level.equals(level2) : level2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$5(OptimizerLoggingSuite $this, String level) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_LEVEL().key()), (Object)level)}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {}), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106)));
        String x$2 = "INVALID_CONF_VALUE.OUT_OF_RANGE_OF_OPTIONS";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confName"), (Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_LEVEL().key()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confValue"), (Object)level), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confOptions"), (Object)Predef$.MODULE$.wrapRefArray((Object[])org.slf4j.event.Level.class.getEnumConstants()).mkString(", "))}));
        Option x$4 = $this.checkError$default$3();
        boolean x$5 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$1, "INVALID_CONF_VALUE.OUT_OF_RANGE_OF_OPTIONS", x$4, x$3, x$5, x$6);
    }

    public static final /* synthetic */ void $anonfun$new$12(OptimizerLoggingSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rulesConf = (String)tuple2._1();
            Seq expectedRules = (Seq)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_RULES().key()), (Object)rulesConf), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_LEVEL().key()), (Object)"INFO")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.verifyLog(Level.INFO, (Seq<String>)expectedRules));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public OptimizerLoggingSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        this.test("test log level", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq levels = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TRACE"), (Object)Level.TRACE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"trace"), (Object)Level.TRACE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DEBUG"), (Object)Level.DEBUG), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"debug"), (Object)Level.DEBUG), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INFO"), (Object)Level.INFO), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"info"), (Object)Level.INFO), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WARN"), (Object)Level.WARN), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"warn"), (Object)Level.WARN), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ERROR"), (Object)Level.ERROR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Level.ERROR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deBUG"), (Object)Level.DEBUG)}));
            levels.foreach((Function1 & Serializable)level -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_LEVEL().key()), level._1())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.verifyLog((Level)level._2(), (Seq<String>)new .colon.colon((Object)PushPredicateThroughNonJoin$.MODULE$.ruleName(), (List)new .colon.colon((Object)ColumnPruning$.MODULE$.ruleName(), (List)new .colon.colon((Object)CollapseProject$.MODULE$.ruleName(), (List)Nil$.MODULE$)))));
                return BoxedUnit.UNIT;
            });
        }, new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("test invalid log level conf", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon levels = new .colon.colon((Object)"", (List)new .colon.colon((Object)"*d_", (List)new .colon.colon((Object)"infoo", (List)Nil$.MODULE$)));
            levels.foreach((Function1 & Serializable)level -> {
                OptimizerLoggingSuite.$anonfun$new$5(this, level);
                return BoxedUnit.UNIT;
            });
        }, new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("test log rules", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon rulesSeq = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PushPredicateThroughNonJoin$.MODULE$.ruleName(), ColumnPruning$.MODULE$.ruleName(), CollapseProject$.MODULE$.ruleName()})).reduce((Function2 & Serializable)(x$5, x$6) -> x$5 + "," + x$6)), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PushPredicateThroughNonJoin$.MODULE$.ruleName(), ColumnPruning$.MODULE$.ruleName(), CollapseProject$.MODULE$.ruleName()}))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PushPredicateThroughNonJoin$.MODULE$.ruleName(), ColumnPruning$.MODULE$.ruleName()})).reduce((Function2 & Serializable)(x$7, x$8) -> x$7 + "," + x$8)), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PushPredicateThroughNonJoin$.MODULE$.ruleName(), ColumnPruning$.MODULE$.ruleName()}))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CollapseProject$.MODULE$.ruleName()), (Object)new .colon.colon((Object)CollapseProject$.MODULE$.ruleName(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ColumnPruning$.MODULE$.ruleName(), "DummyRule"})).reduce((Function2 & Serializable)(x$9, x$10) -> x$9 + "," + x$10)), (Object)new .colon.colon((Object)ColumnPruning$.MODULE$.ruleName(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DummyRule"), (Object)Nil$.MODULE$), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)Nil$.MODULE$), (List)Nil$.MODULE$))))));
            rulesSeq.foreach((Function1 & Serializable)x0$1 -> {
                OptimizerLoggingSuite.$anonfun$new$12(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("test log batches which change the plan", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_BATCHES().key()), (Object)"Optimizer Batch"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_LEVEL().key()), (Object)"INFO")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.verifyLog(Level.INFO, (Seq<String>)new .colon.colon((Object)"Optimizer Batch", (List)Nil$.MODULE$))), new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("test log batches which do not change the plan", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_BATCHES().key()), (Object)"Batch Has No Effect"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PLAN_CHANGE_LOG_LEVEL().key()), (Object)"INFO")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.verifyLog(Level.INFO, (Seq<String>)new .colon.colon((Object)"Batch Has No Effect", (List)Nil$.MODULE$))), new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("SPARK-50329: toString for InSet should be valid for unresolved plan", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LocalRelation input = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).string(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).double()}));
            InSet inSetPredicate = new InSet((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)input).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)inSetPredicate);
            LogicalPlan analyzed = package.plans$.MODULE$.DslLogicalPlan(query).analyze();
            String $org_scalatest_assert_macro_left = query.toString();
            String $org_scalatest_assert_macro_right = "'a INSET (values with unresolved data types)";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            String $org_scalatest_assert_macro_left2 = analyzed.toString();
            String $org_scalatest_assert_macro_right2 = "INSET 1, 2";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("OptimizerLoggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
    }
}

