/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.RaiseError$;
import org.apache.spark.sql.catalyst.optimizer.OuterJoinEliminationSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005M3Aa\u0003\u0007\u00013!)A\u0005\u0001C\u0001K\u001d)\u0001\u0006\u0001E\u0001S\u0019)1\u0006\u0001E\u0001Y!)Ae\u0001C\u0001s!9!h\u0001b\u0001\n\u0003Y\u0004B\u0002&\u0004A\u0003%A\bC\u0004L\u0001\t\u0007I\u0011\u0001'\t\rA\u0003\u0001\u0015!\u0003N\u0011\u001d\t\u0006A1A\u0005\u00021CaA\u0015\u0001!\u0002\u0013i%!G(vi\u0016\u0014(j\\5o\u000b2LW.\u001b8bi&|gnU;ji\u0016T!!\u0004\b\u0002\u0013=\u0004H/[7ju\u0016\u0014(BA\b\u0011\u0003!\u0019\u0017\r^1msN$(BA\t\u0013\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001b=A\u00111\u0004H\u0007\u0002%%\u0011QD\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005r\u0011!\u00029mC:\u001c\u0018BA\u0012!\u0005!\u0001F.\u00198UKN$\u0018A\u0002\u001fj]&$h\bF\u0001'!\t9\u0003!D\u0001\r\u0003!y\u0005\u000f^5nSj,\u0007C\u0001\u0016\u0004\u001b\u0005\u0001!\u0001C(qi&l\u0017N_3\u0014\u0005\ri\u0003c\u0001\u00182g5\tqF\u0003\u00021\u001d\u0005)!/\u001e7fg&\u0011!g\f\u0002\r%VdW-\u0012=fGV$xN\u001d\t\u0003i]j\u0011!\u000e\u0006\u0003m\u0001\nq\u0001\\8hS\u000e\fG.\u0003\u00029k\tYAj\\4jG\u0006d\u0007\u000b\\1o)\u0005I\u0013a\u00022bi\u000eDWm]\u000b\u0002yA\u0019Q\b\u0012$\u000e\u0003yR!a\u0010!\u0002\u0013%lW.\u001e;bE2,'BA!C\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0010\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002H\u00116\t1!\u0003\u0002Jc\t)!)\u0019;dQ\u0006A!-\u0019;dQ\u0016\u001c\b%\u0001\u0007uKN$(+\u001a7bi&|g.F\u0001N!\t!d*\u0003\u0002Pk\tiAj\\2bYJ+G.\u0019;j_:\fQ\u0002^3tiJ+G.\u0019;j_:\u0004\u0013!\u0004;fgR\u0014V\r\\1uS>t\u0017'\u0001\buKN$(+\u001a7bi&|g.\r\u0011")
public class OuterJoinEliminationSuite
extends SparkFunSuite
implements PlanTest {
    private volatile OuterJoinEliminationSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation;
    private final LocalRelation testRelation1;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public OuterJoinEliminationSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        OuterJoinEliminationSuite outerJoinEliminationSuite = this;
        synchronized (outerJoinEliminationSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public LocalRelation testRelation1() {
        return this.testRelation1;
    }

    private final void Optimize$lzycompute$1() {
        OuterJoinEliminationSuite outerJoinEliminationSuite = this;
        synchronized (outerJoinEliminationSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new OuterJoinEliminationSuite$Optimize$(this);
            }
        }
    }

    public OuterJoinEliminationSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).int()}));
        this.testRelation1 = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int()}));
        this.test("joins: full outer to inner", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.d").attr()).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("joins: full outer to right", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.d").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LocalRelation left = this.testRelation();
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)left).join(right, (JoinType)RightOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("joins: full outer to left", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LocalRelation right = this.testRelation1();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join((LogicalPlan)right, (JoinType)LeftOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("joins: right to inner", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)RightOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(2)));
            LocalRelation right = this.testRelation1();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join((LogicalPlan)right, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("joins: left to inner", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.e").attr()).isNotNull());
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LocalRelation left = this.testRelation();
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).isNotNull());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)left).join(right, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("joins: left to inner with complicated filter predicates #1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).isNull()).unary_$bang()).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).isNotNull()).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).isNull())));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LocalRelation left = this.testRelation();
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).isNull()).unary_$bang()).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).isNotNull()).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).isNull())));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)left).join(right, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("joins: left to inner with complicated filter predicates #2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.intToLiteral(2)})));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LocalRelation left = this.testRelation();
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.intToLiteral(2)})));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)left).join(right, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("joins: left to inner with complicated filter predicates #3", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).isNull()).unary_$bang()).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).isNotNull()).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).isNull()))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).isNull()));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LocalRelation left = this.testRelation();
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).isNull()).unary_$bang()).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).isNotNull()).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).isNull()))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).isNull()));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)left).join(right, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("joins: left to inner with complicated filter predicates #4", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$plus((Expression)package.expressions$.MODULE$.intToLiteral(3))).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.e").attr()));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LocalRelation left = this.testRelation();
            LocalRelation right = this.testRelation1();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)left).join((LogicalPlan)right, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("b").attr()).$plus((Expression)package.expressions$.MODULE$.intToLiteral(3))).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("e").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr()))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("joins: no outer join elimination if the filter is not NULL eliminated", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslString("y.e").attr();
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslString("x.a").attr();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Coalesce((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LocalRelation left = this.testRelation();
            LocalRelation right = this.testRelation1();
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslString("e").attr();
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.DslString("a").attr();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)left).join((LogicalPlan)right, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Coalesce((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute4).$colon$colon((Object)unresolvedAttribute3))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("joins: no outer join elimination if the filter's constraints are not NULL eliminated", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.DslString("y.e").attr();
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.DslString("x.a").attr();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)new IsNotNull((Expression)new Coalesce((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LocalRelation left = this.testRelation();
            LocalRelation right = this.testRelation1();
            UnresolvedAttribute unresolvedAttribute3 = package.expressions$.MODULE$.DslString("e").attr();
            UnresolvedAttribute unresolvedAttribute4 = package.expressions$.MODULE$.DslString("a").attr();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)left).join((LogicalPlan)right, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("d").attr())))).where((Expression)new IsNotNull((Expression)new Coalesce((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute4).$colon$colon((Object)unresolvedAttribute3))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("no outer join elimination if constraint propagation is disabled", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CONSTRAINT_PROPAGATION_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)FullOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.b").attr()).$plus((Expression)package.expressions$.MODULE$.DslString("y.d").attr())).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(3)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            this.comparePlans(optimized, package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze(), this.comparePlans$default$3());
        }), new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("SPARK-38868: exception thrown from filter predicate does not propagate", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            Literal message = new Literal((Object)UTF8String.fromString((String)"Bad value"), (DataType)StringType$.MODULE$);
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.d").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new If((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.DslString("y.d").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0)), (Expression)package.expressions$.MODULE$.booleanToLiteral(true), (Expression)RaiseError$.MODULE$.apply((Expression)message))).isNull());
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            this.comparePlans(optimized, package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze(), this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        this.test("SPARK-39172: Remove left/right outer join if only left/right side columns are selected and the join keys on the other side are unique", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery("x");
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).subquery("y");
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(package.plans$.MODULE$.DslLogicalPlan(y).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)})), (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).analyze()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).analyze(), this.comparePlans$default$3());
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(package.plans$.MODULE$.DslLogicalPlan(y).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("x")})), (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).analyze()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).analyze(), this.comparePlans$default$3());
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).join(y, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)}))).analyze()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(y).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)}))).analyze(), this.comparePlans$default$3());
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.count$default$2())).as("x")}))).join(y, (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)}))).analyze()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(y).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)}))).analyze(), this.comparePlans$default$3());
            LogicalPlan p1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(package.plans$.MODULE$.DslLogicalPlan(y).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)})), (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)p1), p1, this.comparePlans$default$3());
            LogicalPlan p2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(package.plans$.MODULE$.DslLogicalPlan(y).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)})), (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)p2), p2, this.comparePlans$default$3());
            LogicalPlan p3 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(package.plans$.MODULE$.DslLogicalPlan(y).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)})), (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)p3), p3, this.comparePlans$default$3());
        }, new Position("OuterJoinEliminationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
    }
}

