/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.CompoundBody;
import org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement;
import org.apache.spark.sql.catalyst.plans.logical.CreateVariable;
import org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler;
import org.apache.spark.sql.catalyst.plans.logical.ForStatement;
import org.apache.spark.sql.catalyst.plans.logical.IfElseStatement;
import org.apache.spark.sql.catalyst.plans.logical.IterateStatement;
import org.apache.spark.sql.catalyst.plans.logical.LeaveStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.LoopStatement;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RepeatStatement;
import org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement;
import org.apache.spark.sql.catalyst.plans.logical.SetVariable;
import org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement;
import org.apache.spark.sql.catalyst.plans.logical.SingleStatement;
import org.apache.spark.sql.catalyst.plans.logical.WhileStatement;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.exceptions.SqlScriptingException;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i2A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!)!\u0005\u0001C)G!)!\u0006\u0001C)G!)1\u0006\u0001C\u0001Y\t92+\u001d7TGJL\u0007\u000f^5oOB\u000b'o]3s'VLG/\u001a\u0006\u0003\u000f!\ta\u0001]1sg\u0016\u0014(BA\u0005\u000b\u0003!\u0019\u0017\r^1msN$(BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u00151A\u0011QCF\u0007\u0002\u0019%\u0011q\u0003\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mA\u0011!\u00029mC:\u001c\u0018BA\u000f\u001b\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\r\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t!QK\\5u\u0003!\tg\r^3s\u00032d\u0017AF2mK\u0006tW\u000f]*uCR,W.\u001a8u'R\u0014\u0018N\\4\u0015\u00055B\u0004C\u0001\u00186\u001d\ty3\u0007\u0005\u00021M5\t\u0011G\u0003\u00023%\u00051AH]8pizJ!\u0001\u000e\u0014\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003i\u0019BQ!\u000f\u0003A\u00025\nAb\u001d;bi\u0016lWM\u001c;TiJ\u0004")
public class SqlScriptingParserSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        SqlScriptingParserSuite sqlScriptingParserSuite = this;
        synchronized (sqlScriptingParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public void beforeAll() {
        super.beforeAll();
        this.conf().setConf(SQLConf$.MODULE$.SQL_SCRIPTING_CONTINUE_HANDLER_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public void afterAll() {
        this.conf().unsetConf(SQLConf$.MODULE$.SQL_SCRIPTING_CONTINUE_HANDLER_ENABLED().key());
        super.afterAll();
    }

    public String cleanupStatementString(String statementStr) {
        return statementStr.replace("\n", "").replace("BEGIN", "").replace("END", "").trim();
    }

    public static final /* synthetic */ boolean $anonfun$new$7(CompoundPlanStatement x$1) {
        return x$1 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$17(CompoundPlanStatement x$2) {
        return x$2 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$26(CompoundPlanStatement x$3) {
        return x$3 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$28(CompoundPlanStatement x$4) {
        return x$4 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$47(CompoundPlanStatement x$5) {
        return x$5 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$49(CompoundPlanStatement x$6) {
        return x$6 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$51(CompoundPlanStatement x$7) {
        return x$7 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$52(CompoundPlanStatement x$8) {
        return ((SingleStatement)x$8).parsedPlan() instanceof CreateVariable;
    }

    public static final /* synthetic */ boolean $anonfun$new$154(CompoundPlanStatement x$9) {
        return x$9 instanceof ForStatement;
    }

    public SqlScriptingParserSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("single select", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan statement;
            String sqlScriptText = "SELECT 1;";
            LogicalPlan $org_scalatest_assert_macro_left = statement = CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left instanceof CompoundBody, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("multi select without ; - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = "SELECT 1 SELECT 1";
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "SELECT";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("multi select with ; - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = "SELECT 1; SELECT 1;";
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "SELECT";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("multi select", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = "BEGIN SELECT 1;SELECT 2; END";
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$7(x$1))), "tree.collection.forall(((x$1: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$1.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sqlScriptText.split(";")), (Function1 & Serializable)statementStr -> this.cleanupStatementString((String)statementStr), ClassTag$.MODULE$.apply(String.class))), (IterableOnce)tree.collection())), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String statementText;
                    String expected = (String)tuple2._1();
                    CompoundPlanStatement statement = (CompoundPlanStatement)tuple2._2();
                    SingleStatement sparkStatement = (SingleStatement)statement;
                    String $org_scalatest_assert_macro_left = statementText = sparkStatement.getText();
                    String $org_scalatest_assert_macro_right = expected;
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("empty singleCompoundStatement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("empty beginEndCompoundBlock", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | BEGIN\n        | END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            CompoundBody innerBody = (CompoundBody)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = innerBody.collection();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("multiple ; in row - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;;\n        |  SELECT 2;\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "at or near ';'";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("without ; in last statement - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  SELECT 2\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "at or near end of input";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("multi statement", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$17(x$2))), "tree.collection.forall(((x$2: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$2.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sqlScriptText.split(";")), (Function1 & Serializable)statementStr -> this.cleanupStatementString((String)statementStr), ClassTag$.MODULE$.apply(String.class))), (IterableOnce)tree.collection())), (Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String statementText;
                    String expected = (String)tuple2._1();
                    CompoundPlanStatement statement = (CompoundPlanStatement)tuple2._2();
                    SingleStatement sparkStatement = (SingleStatement)statement;
                    String $org_scalatest_assert_macro_left = statementText = sparkStatement.getText();
                    String $org_scalatest_assert_macro_right = expected;
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("nested begin end", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  BEGIN\n        |  SELECT 1;\n        |  END;\n        |  BEGIN\n        |    BEGIN\n        |      SELECT 2;\n        |      SELECT 3;\n        |    END;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            CompoundBody body1 = (CompoundBody)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = body1.collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            String $org_scalatest_assert_macro_left4 = ((SingleStatement)body1.collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            CompoundBody body2 = (CompoundBody)tree.collection().apply(1);
            Seq $org_scalatest_assert_macro_left5 = body2.collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)body2.collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            CompoundBody nestedBody = (CompoundBody)body2.collection().head();
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)nestedBody.collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 2";
            String string3 = $org_scalatest_assert_macro_left7;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)nestedBody.collection().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 3";
            String string5 = $org_scalatest_assert_macro_left8;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("not atomic body", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan tree;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN NOT ATOMIC\n        |  SELECT 1;\n        |END"));
            LogicalPlan $org_scalatest_assert_macro_left = tree = CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left instanceof CompoundBody, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("nested not atomic body", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN NOT ATOMIC\n        |  BEGIN NOT ATOMIC\n        |    SELECT 1;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            CompoundPlanStatement $org_scalatest_assert_macro_left = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left instanceof CompoundBody, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("top level compound: labels not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl: BEGIN\n        |  SELECT 1;\n        |END"));
            ParseException x$1 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            String x$2 = "PARSE_SYNTAX_ERROR";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'lbl'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "PARSE_SYNTAX_ERROR", x$4, x$3, x$5, x$6);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.test("compound: beginLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$26(x$3))), "tree.collection.forall(((x$3: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$3.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            Option $org_scalatest_assert_macro_left3 = tree.label();
            String $org_scalatest_assert_macro_right3 = "lbl";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("compound: beginLabel + endLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END lbl;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$28(x$4))), "tree.collection.forall(((x$4: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$4.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            Option $org_scalatest_assert_macro_left3 = tree.label();
            String $org_scalatest_assert_macro_right3 = "lbl";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("compound: beginLabel + endLabel - case sensitivity check", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END LbL;\n        |END"));
            return CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("compound: beginLabel + endLabel with different values", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl_begin: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END lbl_end;\n        |END"));
            SqlScriptingException x$7 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            String x$8 = "LABELS_MISMATCH";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"beginLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl_begin")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl_end"))}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "LABELS_MISMATCH", x$10, x$9, x$11, x$12);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("compound: forbidden label - system", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  system: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$13 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            String x$14 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("system"))}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$16, x$15, x$17, x$18);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        this.test("compound: forbidden label - starting with sys", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  sysXYZ: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$19 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            String x$20 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("sysxyz"))}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$22, x$21, x$23, x$24);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        this.test("compound: forbidden label - session", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  session: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$25 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            String x$26 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("session"))}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$28, x$27, x$29, x$30);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        this.test("compound: forbidden label - builtin", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  builtin: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$31 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            String x$32 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("builtin"))}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$34, x$33, x$35, x$36);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("compound: forbidden label - system - case insensitive", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SySTeM: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$37 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            String x$38 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("system"))}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$42 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$37, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$40, x$39, x$41, x$42);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        this.test("compound: forbidden label - session - case insensitive", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SEsSiON: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$43 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            String x$44 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$45 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("session"))}));
            Option x$46 = this.checkError$default$3();
            boolean x$47 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$48 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$43, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$46, x$45, x$47, x$48);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("compound: endLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END lbl;\n        |END"));
            SqlScriptingException x$49 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
            String x$50 = "END_LABEL_WITHOUT_BEGIN_LABEL";
            Map x$51 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$52 = this.checkError$default$3();
            boolean x$53 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$54 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$49, "END_LABEL_WITHOUT_BEGIN_LABEL", x$52, x$51, x$53, x$54);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 9;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        this.test("compound: beginLabel + endLabel with different casing", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  LBL: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END lbl;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$47(x$5))), "tree.collection.forall(((x$5: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$5.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
            Option $org_scalatest_assert_macro_left3 = tree.label();
            String $org_scalatest_assert_macro_right3 = "lbl";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        this.test("compound: no labels provided, random label should be generated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$49(x$6))), "tree.collection.forall(((x$6: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$6.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
            Option $org_scalatest_assert_macro_left3 = tree.label();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        this.test("declare at the beginning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE testVariable1 VARCHAR(50);\n        |  DECLARE testVariable2 INTEGER;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$51(x$7))), "tree.collection.forall(((x$7: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$7.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$52(x$8))), "tree.collection.forall(((x$8: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$8.asInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement].parsedPlan.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.CreateVariable]))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        this.test("declare after beginning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  DECLARE testVariable INTEGER;\n        |END"));
            SqlScriptingException x$55 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
            String x$56 = "INVALID_VARIABLE_DECLARATION.ONLY_AT_BEGINNING";
            Map x$57 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)"`testVariable`")}));
            Option x$58 = this.checkError$default$3();
            boolean x$59 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$60 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$55, "INVALID_VARIABLE_DECLARATION.ONLY_AT_BEGINNING", x$58, x$57, x$59, x$60);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        this.test("declare variable in wrong scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   DECLARE testVariable INTEGER;\n        | END IF;\n        |END"));
            SqlScriptingException x$61 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
            String x$62 = "INVALID_VARIABLE_DECLARATION.NOT_ALLOWED_IN_SCOPE";
            Map x$63 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)"`testVariable`")}));
            Option x$64 = this.checkError$default$3();
            boolean x$65 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$66 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$61, "INVALID_VARIABLE_DECLARATION.NOT_ALLOWED_IN_SCOPE", x$64, x$63, x$65, x$66);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        this.test("SET statement test", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE totalInsCnt = 0;\n        |  SET totalInsCnt = (SELECT x FROM y WHERE id = 1);\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left2 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
            CompoundPlanStatement $org_scalatest_assert_macro_left3 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
        this.test("SET statement test - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE totalInsCnt = 0;\n        |  SET totalInsCnt = (SELECT x FROMERROR y WHERE id = 1);\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        this.test("if", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   SELECT 42;\n        | END IF;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1=1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        this.test("if with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | IF 1 = 1 THEN\n        | END IF;\n        |END\n      "));
            ParseException x$67 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
            String x$68 = "PARSE_SYNTAX_ERROR";
            Map x$69 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'IF'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$70 = this.checkError$default$3();
            boolean x$71 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$72 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$67, "PARSE_SYNTAX_ERROR", x$70, x$69, x$71, x$72);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
        this.test("if else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSE\n        |  SELECT 2;\n        |END IF;\n        |END\n        "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
            SingleStatement $org_scalatest_assert_macro_left5 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
            Seq $org_scalatest_assert_macro_left7 = ((CompoundBody)ifStmt.conditionalBodies().head()).collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            Seq $org_scalatest_assert_macro_left10 = ((CompoundBody)ifStmt.elseBody().get()).collection();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string5 = $org_scalatest_assert_macro_left12;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
        this.test("if elseif", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSEIF 2 = 2 THEN\n        |  SELECT 2;\n        |ELSE\n        |  SELECT 3;\n        |END IF;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
            SingleStatement $org_scalatest_assert_macro_left5 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            SingleStatement $org_scalatest_assert_macro_left9 = (SingleStatement)ifStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)ifStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "2 = 2";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 3";
            String string9 = $org_scalatest_assert_macro_left14;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
        this.test("if multi elseif", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSEIF 2 = 2 THEN\n        |  SELECT 2;\n        |ELSEIF 3 = 3 THEN\n        |  SELECT 3;\n        |END IF;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
            Option $org_scalatest_assert_macro_left5 = ifStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 714));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "2 = 2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left13;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
            SingleStatement $org_scalatest_assert_macro_left14 = (SingleStatement)ifStmt.conditions().apply(2);
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)ifStmt.conditions().apply(2)).getText();
            String $org_scalatest_assert_macro_right8 = "3 = 3";
            String string9 = $org_scalatest_assert_macro_left15;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 3";
            String string11 = $org_scalatest_assert_macro_left17;
            String string12 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right9, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
        this.test("if - multi elseif - else nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSEIF 2 = 2 THEN\n        |  SELECT 2;\n        |ELSE\n        |  IF 3 = 3 THEN\n        |    SELECT 3;\n        |  ELSEIF 4 = 4 THEN\n        |    SELECT 4;\n        |  ELSE\n        |    IF 5 = 5 THEN\n        |      SELECT 5;\n        |    ELSE\n        |      SELECT 6;\n        |    END IF;\n        |  END IF;\n        |END IF;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
            Option $org_scalatest_assert_macro_left5 = ifStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 760));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "2 = 2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left13;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left14 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
            IfElseStatement nestedIf_1 = (IfElseStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Seq $org_scalatest_assert_macro_left15 = nestedIf_1.conditions();
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left15, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
            Seq $org_scalatest_assert_macro_left16 = nestedIf_1.conditionalBodies();
            int $org_scalatest_assert_macro_right9 = 2;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left16, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left16.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
            Option $org_scalatest_assert_macro_left17 = nestedIf_1.elseBody();
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left17, "nonEmpty", $org_scalatest_assert_macro_left17.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
            SingleStatement $org_scalatest_assert_macro_left18 = (SingleStatement)nestedIf_1.conditions().head();
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left18, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left18 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
            String $org_scalatest_assert_macro_left19 = ((SingleStatement)nestedIf_1.conditions().head()).getText();
            String $org_scalatest_assert_macro_right10 = "3 = 3";
            String string9 = $org_scalatest_assert_macro_left19;
            String string10 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "==", (Object)$org_scalatest_assert_macro_right10, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
            CompoundPlanStatement $org_scalatest_assert_macro_left20 = (CompoundPlanStatement)((CompoundBody)nestedIf_1.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left20, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left20 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 785));
            String $org_scalatest_assert_macro_left21 = ((SingleStatement)((CompoundBody)nestedIf_1.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right11 = "SELECT 3";
            String string11 = $org_scalatest_assert_macro_left21;
            String string12 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "==", (Object)$org_scalatest_assert_macro_right11, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
            SingleStatement $org_scalatest_assert_macro_left22 = (SingleStatement)nestedIf_1.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left22, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left22 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
            String $org_scalatest_assert_macro_left23 = ((SingleStatement)nestedIf_1.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right12 = "4 = 4";
            String string13 = $org_scalatest_assert_macro_left23;
            String string14 = $org_scalatest_assert_macro_right12;
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "==", (Object)$org_scalatest_assert_macro_right12, !(string13 != null ? !string13.equals(string14) : string14 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
            CompoundPlanStatement $org_scalatest_assert_macro_left24 = (CompoundPlanStatement)((CompoundBody)nestedIf_1.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left24, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left24 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
            String $org_scalatest_assert_macro_left25 = ((SingleStatement)((CompoundBody)nestedIf_1.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right13 = "SELECT 4";
            String string15 = $org_scalatest_assert_macro_left25;
            String string16 = $org_scalatest_assert_macro_right13;
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "==", (Object)$org_scalatest_assert_macro_right13, !(string15 != null ? !string15.equals(string16) : string16 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
            CompoundPlanStatement $org_scalatest_assert_macro_left26 = (CompoundPlanStatement)((CompoundBody)nestedIf_1.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left26, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left26 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
            IfElseStatement nestedIf_2 = (IfElseStatement)((CompoundBody)nestedIf_1.elseBody().get()).collection().head();
            Seq $org_scalatest_assert_macro_left27 = nestedIf_2.conditions();
            int $org_scalatest_assert_macro_right14 = 1;
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left27, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left27.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
            Seq $org_scalatest_assert_macro_left28 = nestedIf_2.conditionalBodies();
            int $org_scalatest_assert_macro_right15 = 1;
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left28, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left28.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
            Option $org_scalatest_assert_macro_left29 = nestedIf_2.elseBody();
            Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left29, "nonEmpty", $org_scalatest_assert_macro_left29.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            String $org_scalatest_assert_macro_left30 = ((SingleStatement)((CompoundBody)nestedIf_2.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right16 = "SELECT 5";
            String string17 = $org_scalatest_assert_macro_left30;
            String string18 = $org_scalatest_assert_macro_right16;
            Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left30, "==", (Object)$org_scalatest_assert_macro_right16, !(string17 != null ? !string17.equals(string18) : string18 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
            String $org_scalatest_assert_macro_left31 = ((SingleStatement)((CompoundBody)nestedIf_2.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right17 = "SELECT 6";
            String string19 = $org_scalatest_assert_macro_left31;
            String string20 = $org_scalatest_assert_macro_right17;
            Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left31, "==", (Object)$org_scalatest_assert_macro_right17, !(string19 != null ? !string19.equals(string20) : string20 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
        this.test("if nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   IF 2=1 THEN\n        |     SELECT 41;\n        |   ELSE\n        |     SELECT 42;\n        |   END IF;\n        | END IF;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
            Option $org_scalatest_assert_macro_left5 = ifStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1=1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 833));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left8 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
            IfElseStatement nestedIfStmt = (IfElseStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Seq $org_scalatest_assert_macro_left9 = nestedIfStmt.conditions();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
            Seq $org_scalatest_assert_macro_left10 = nestedIfStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(nestedIfStmt.elseBody().isDefined(), "nestedIfStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
            SingleStatement $org_scalatest_assert_macro_left11 = (SingleStatement)nestedIfStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)nestedIfStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right7 = "2=1";
            String string3 = $org_scalatest_assert_macro_left12;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedIfStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedIfStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 41";
            String string5 = $org_scalatest_assert_macro_left14;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
            CompoundPlanStatement $org_scalatest_assert_macro_left15 = (CompoundPlanStatement)((CompoundBody)nestedIfStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left15, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left15 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 849));
            String $org_scalatest_assert_macro_left16 = ((SingleStatement)((CompoundBody)nestedIfStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string7 = $org_scalatest_assert_macro_left16;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
        this.test("while", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  SELECT 1;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 863));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 867));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 868));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
            Option $org_scalatest_assert_macro_left9 = whileStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left9.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 854));
        this.test("while with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | WHILE 1 = 1 DO\n        | END WHILE;\n        |END\n      "));
            ParseException x$73 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 886));
            String x$74 = "PARSE_SYNTAX_ERROR";
            Map x$75 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'WHILE'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$76 = this.checkError$default$3();
            boolean x$77 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$78 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$73, "PARSE_SYNTAX_ERROR", x$76, x$75, x$77, x$78);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
        this.test("while with complex condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |CREATE TABLE t (a INT, b STRING, c DOUBLE) USING parquet;\n        |WHILE (SELECT COUNT(*) < 2 FROM t) DO\n        |  SELECT 42;\n        |END WHILE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
            WhileStatement whileStmt = (WhileStatement)tree.collection().apply(1);
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "(SELECT COUNT(*) < 2 FROM t)";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 913));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893));
        this.test("while with if else block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  IF 1 = 1 THEN\n        |    SELECT 1;\n        |  ELSE\n        |    SELECT 2;\n        |  END IF;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 930));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 931));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left7 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 939));
            IfElseStatement ifStmt = (IfElseStatement)whileStmt.body().collection().head();
            Seq $org_scalatest_assert_macro_left8 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942));
            Seq $org_scalatest_assert_macro_left9 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 944));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 946));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right6 = "1 = 1";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 949));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 950));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 953));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left15;
            String string8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 954));
            Option $org_scalatest_assert_macro_left16 = whileStmt.label();
            String $org_scalatest_assert_macro_right9 = "lbl";
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left16.contains((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 917));
        this.test("nested while", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  WHILE 2 = 2 DO\n        |    SELECT 42;\n        |  END WHILE;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 971));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 972));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 976));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 978));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 979));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left7 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 980));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 983));
            String $org_scalatest_assert_macro_left9 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 984));
            CompoundBody $org_scalatest_assert_macro_left10 = nestedWhileStmt.body();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left10 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 986));
            Seq $org_scalatest_assert_macro_left11 = nestedWhileStmt.body().collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left11, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 988));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 989));
            Option $org_scalatest_assert_macro_left14 = whileStmt.label();
            String $org_scalatest_assert_macro_right7 = "lbl";
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 992));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960));
        this.test("leave compound block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  END;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1005));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1008));
            CompoundPlanStatement $org_scalatest_assert_macro_left3 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1009));
            CompoundPlanStatement $org_scalatest_assert_macro_left4 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left4 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995));
        this.test("leave while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1023));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1027));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1030));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1031));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1033));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1034));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)whileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left9 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1036));
            String $org_scalatest_assert_macro_left10 = ((LeaveStatement)whileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1037));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1013));
        this.test("leave repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  UNTIL 1 = 2\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1051));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1052));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1055));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 2";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1056));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1058));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1059));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1061));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1062));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)repeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left9 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
            String $org_scalatest_assert_macro_left10 = ((LeaveStatement)repeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1065));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1040));
        this.test("iterate compound block - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  END;\n        |END"));
            SqlScriptingException x$79 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1078));
            String x$80 = "INVALID_LABEL_USAGE.ITERATE_IN_COMPOUND";
            Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"LBL")}));
            Option x$82 = this.checkError$default$3();
            boolean x$83 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$84 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$79, "INVALID_LABEL_USAGE.ITERATE_IN_COMPOUND", x$82, x$81, x$83, x$84);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1068));
        this.test("iterate while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1095));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1096));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1099));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1100));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1102));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1103));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1105));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1106));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)whileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left9 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1108));
            String $org_scalatest_assert_macro_left10 = ((IterateStatement)whileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1109));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1085));
        this.test("iterate repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  UNTIL 1 = 2\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1123));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1124));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1127));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 2";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1128));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1130));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1131));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1133));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1134));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)repeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left9 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1136));
            String $org_scalatest_assert_macro_left10 = ((IterateStatement)repeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1137));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1112));
        this.test("leave with wrong label - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    LEAVE randomlbl;\n        |  END;\n        |END"));
            SqlScriptingException x$85 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1150));
            String x$86 = "INVALID_LABEL_USAGE.DOES_NOT_EXIST";
            Map x$87 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"RANDOMLBL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)"LEAVE")}));
            Option x$88 = this.checkError$default$3();
            boolean x$89 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$90 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$85, "INVALID_LABEL_USAGE.DOES_NOT_EXIST", x$88, x$87, x$89, x$90);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1140));
        this.test("iterate with wrong label - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    ITERATE randomlbl;\n        |  END;\n        |END"));
            SqlScriptingException x$91 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1167));
            String x$92 = "INVALID_LABEL_USAGE.DOES_NOT_EXIST";
            Map x$93 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"RANDOMLBL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)"ITERATE")}));
            Option x$94 = this.checkError$default$3();
            boolean x$95 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$96 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$91, "INVALID_LABEL_USAGE.DOES_NOT_EXIST", x$94, x$93, x$95, x$96);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1157));
        this.test("leave outer loop from nested while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    lbl2: WHILE 2 = 2 DO\n        |      SELECT 1;\n        |      LEAVE lbl;\n        |    END WHILE;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1186));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1190));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1191));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1193));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1194));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1197));
            String $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1198));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1200));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1201));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedWhileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left11 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1203));
            String $org_scalatest_assert_macro_left12 = ((LeaveStatement)nestedWhileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1204));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1174));
        this.test("leave outer loop from nested repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    lbl2: REPEAT\n        |      SELECT 1;\n        |      LEAVE lbl;\n        |    UNTIL 2 = 2\n        |    END REPEAT;\n        |  UNTIL 1 = 1\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1221));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1222));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1225));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1226));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1228));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1229));
            RepeatStatement nestedRepeatStmt = (RepeatStatement)repeatStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedRepeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1232));
            String $org_scalatest_assert_macro_left8 = nestedRepeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1233));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1235));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedRepeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1236));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left11 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1239));
            String $org_scalatest_assert_macro_left12 = ((LeaveStatement)nestedRepeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1240));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1207));
        this.test("iterate outer loop from nested while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    lbl2: WHILE 2 = 2 DO\n        |      SELECT 1;\n        |      ITERATE lbl;\n        |    END WHILE;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1255));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1256));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1259));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1260));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1262));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1263));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1266));
            String $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1267));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1269));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1270));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedWhileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left11 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1272));
            String $org_scalatest_assert_macro_left12 = ((IterateStatement)nestedWhileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1273));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1243));
        this.test("iterate outer loop from nested repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    lbl2: REPEAT\n        |      SELECT 1;\n        |      ITERATE lbl;\n        |    UNTIL 2 = 2\n        |    END REPEAT;\n        |  UNTIL 1 = 1\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1290));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1291));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1294));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1295));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1297));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1298));
            RepeatStatement nestedRepeatStmt = (RepeatStatement)repeatStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedRepeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1301));
            String $org_scalatest_assert_macro_left8 = nestedRepeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1302));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1304));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedRepeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1305));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left11 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1308));
            String $org_scalatest_assert_macro_left12 = ((IterateStatement)nestedRepeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1309));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1276));
        this.test("repeat", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  SELECT 1;\n        | UNTIL 1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1322));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1323));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1326));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1327));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1329));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1330));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1331));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1332));
            Option $org_scalatest_assert_macro_left9 = repeatStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left9.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1334));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1312));
        this.test("repeat with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | REPEAT UNTIL 1 = 1\n        | END REPEAT;\n        |END\n      "));
            ParseException x$97 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1345));
            String x$98 = "PARSE_SYNTAX_ERROR";
            Map x$99 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'1'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$100 = this.checkError$default$3();
            boolean x$101 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$102 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$97, "PARSE_SYNTAX_ERROR", x$100, x$99, x$101, x$102);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1337));
        this.test("repeat with complex condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |CREATE TABLE t (a INT, b STRING, c DOUBLE) USING parquet;\n        |REPEAT\n        | SELECT 42;\n        |UNTIL\n        | (SELECT COUNT(*) < 2 FROM t)\n        |END REPEAT;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1366));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1367));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().apply(1);
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1370));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "(SELECT COUNT(*) < 2 FROM t)";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1371));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1373));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1374));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1375));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1376));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1352));
        this.test("repeat with if else block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  IF 1 = 1 THEN\n        |    SELECT 1;\n        |  ELSE\n        |    SELECT 2;\n        |  END IF;\n        |UNTIL\n        |  1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1394));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1395));
            RepeatStatement whileStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1398));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1399));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1401));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left7 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403));
            IfElseStatement ifStmt = (IfElseStatement)whileStmt.body().collection().head();
            Seq $org_scalatest_assert_macro_left8 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1406));
            Seq $org_scalatest_assert_macro_left9 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1407));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1408));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1410));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right6 = "1 = 1";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1413));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1414));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1417));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left15;
            String string8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1418));
            Option $org_scalatest_assert_macro_left16 = whileStmt.label();
            String $org_scalatest_assert_macro_right9 = "lbl";
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left16.contains((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1421));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1379));
        this.test("nested repeat", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  REPEAT\n        |    SELECT 42;\n        |  UNTIL\n        |    2 = 2\n        |  END REPEAT;\n        |UNTIL\n        |   1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1439));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1440));
            RepeatStatement whileStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1443));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1444));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1446));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1447));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left7 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1448));
            RepeatStatement nestedWhileStmt = (RepeatStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1451));
            String $org_scalatest_assert_macro_left9 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1452));
            CompoundBody $org_scalatest_assert_macro_left10 = nestedWhileStmt.body();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left10 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1454));
            Seq $org_scalatest_assert_macro_left11 = nestedWhileStmt.body().collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left11, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1455));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1456));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1457));
            Option $org_scalatest_assert_macro_left14 = whileStmt.label();
            String $org_scalatest_assert_macro_right7 = "lbl";
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1460));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1424));
        this.test("searched case statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1474));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left2 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1475));
            SearchedCaseStatement caseStmt = (SearchedCaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1477));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1478));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1 = 1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1463));
        this.test("searched case statement with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | CASE\n        |  WHEN 1 = 1 THEN\n        | END CASE;\n        |END\n      "));
            ParseException x$103 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1491));
            String x$104 = "PARSE_SYNTAX_ERROR";
            Map x$105 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'CASE'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$106 = this.checkError$default$3();
            boolean x$107 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$108 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$103, "PARSE_SYNTAX_ERROR", x$106, x$105, x$107, x$108);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1482));
        this.test("searched case statement - multi when", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 IN (1,2,3) THEN\n        |     SELECT 1;\n        |   WHEN (SELECT * FROM t) THEN\n        |     SELECT * FROM b;\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1514));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left2 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1515));
            SearchedCaseStatement caseStmt = (SearchedCaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1518));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1519));
            Option $org_scalatest_assert_macro_left5 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1520));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1522));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 IN (1,2,3)";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1523));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1525));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1526));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)caseStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1529));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)caseStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "(SELECT * FROM t)";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1530));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1532));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT * FROM b";
            String string7 = $org_scalatest_assert_macro_left13;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1533));
            SingleStatement $org_scalatest_assert_macro_left14 = (SingleStatement)caseStmt.conditions().apply(2);
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1536));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)caseStmt.conditions().apply(2)).getText();
            String $org_scalatest_assert_macro_right8 = "1 = 1";
            String string9 = $org_scalatest_assert_macro_left15;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1537));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1539));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string11 = $org_scalatest_assert_macro_left17;
            String string12 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right9, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1540));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1498));
        this.test("searched case statement with else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        |   ELSE\n        |     SELECT 43;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1557));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left2 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1558));
            SearchedCaseStatement caseStmt = (SearchedCaseStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(caseStmt.elseBody().isDefined(), "caseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1560));
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1561));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1562));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1 = 1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1563));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1565));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 43";
            String string3 = $org_scalatest_assert_macro_left7;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1566));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1544));
        this.test("searched case statement nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     CASE\n        |       WHEN 2 = 1 THEN\n        |         SELECT 41;\n        |       ELSE\n        |         SELECT 42;\n        |     END CASE;\n        |  END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1586));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left2 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1587));
            SearchedCaseStatement caseStmt = (SearchedCaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1590));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1591));
            Option $org_scalatest_assert_macro_left5 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1592));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1594));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1595));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left8 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1597));
            SearchedCaseStatement nestedCaseStmt = (SearchedCaseStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Seq $org_scalatest_assert_macro_left9 = nestedCaseStmt.conditions();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1601));
            Seq $org_scalatest_assert_macro_left10 = nestedCaseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1602));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(nestedCaseStmt.elseBody().isDefined(), "nestedCaseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1603));
            SingleStatement $org_scalatest_assert_macro_left11 = (SingleStatement)nestedCaseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1605));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)nestedCaseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right7 = "2 = 1";
            String string3 = $org_scalatest_assert_macro_left12;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1606));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1608));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 41";
            String string5 = $org_scalatest_assert_macro_left14;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1609));
            CompoundPlanStatement $org_scalatest_assert_macro_left15 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left15, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left15 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1612));
            String $org_scalatest_assert_macro_left16 = ((SingleStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string7 = $org_scalatest_assert_macro_left16;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1613));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1570));
        this.test("simple case statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 1;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1628));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left2 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1629));
            SimpleCaseStatement caseStmt = (SimpleCaseStatement)tree.collection().head();
            Expression $org_scalatest_assert_macro_left3 = caseStmt.caseVariableExpression();
            Literal $org_scalatest_assert_macro_right2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression = $org_scalatest_assert_macro_left3;
            Literal literal = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1631));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1632));
            Expression $org_scalatest_assert_macro_left5 = (Expression)caseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression2 = $org_scalatest_assert_macro_left5;
            Literal literal2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(expression2 != null ? !expression2.equals(literal2) : literal2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1633));
            Seq $org_scalatest_assert_macro_left6 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1635));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1636));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1617));
        this.test("simple case statement with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | CASE 1\n        |  WHEN 1 THEN\n        | END CASE;\n        |END\n      "));
            ParseException x$109 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1649));
            String x$110 = "PARSE_SYNTAX_ERROR";
            Map x$111 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'CASE'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$112 = this.checkError$default$3();
            boolean x$113 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$114 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$109, "PARSE_SYNTAX_ERROR", x$112, x$111, x$113, x$114);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1640));
        this.test("simple case statement - multi when", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 1;\n        |   WHEN (SELECT 2) THEN\n        |     SELECT * FROM b;\n        |   WHEN 3 IN (1,2,3) THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1672));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left2 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1673));
            SimpleCaseStatement caseStmt = (SimpleCaseStatement)tree.collection().head();
            Expression $org_scalatest_assert_macro_left3 = caseStmt.caseVariableExpression();
            Literal $org_scalatest_assert_macro_right2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression = $org_scalatest_assert_macro_left3;
            Literal literal = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1676));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1677));
            Seq $org_scalatest_assert_macro_left5 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1678));
            Option $org_scalatest_assert_macro_left6 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1679));
            Expression $org_scalatest_assert_macro_left7 = (Expression)caseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right5 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression2 = $org_scalatest_assert_macro_left7;
            Literal literal2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(expression2 != null ? !expression2.equals(literal2) : literal2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1681));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1683));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left9;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1684));
            Expression $org_scalatest_assert_macro_left10 = (Expression)caseStmt.conditionExpressions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.ScalarSubquery", $org_scalatest_assert_macro_left10 instanceof ScalarSubquery, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1687));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1689));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT * FROM b";
            String string3 = $org_scalatest_assert_macro_left12;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1690));
            Expression $org_scalatest_assert_macro_left13 = (Expression)caseStmt.conditionExpressions().apply(2);
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.In", $org_scalatest_assert_macro_left13 instanceof In, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1693));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1695));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left15;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1696));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1656));
        this.test("simple case statement with else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 42;\n        |   ELSE\n        |     SELECT 43;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1713));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left2 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1714));
            SimpleCaseStatement caseStmt = (SimpleCaseStatement)tree.collection().head();
            Expression $org_scalatest_assert_macro_left3 = caseStmt.caseVariableExpression();
            Literal $org_scalatest_assert_macro_right2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression = $org_scalatest_assert_macro_left3;
            Literal literal = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1717));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(caseStmt.elseBody().isDefined(), "caseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1718));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1719));
            Expression $org_scalatest_assert_macro_left5 = (Expression)caseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression2 = $org_scalatest_assert_macro_left5;
            Literal literal2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(expression2 != null ? !expression2.equals(literal2) : literal2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1720));
            Seq $org_scalatest_assert_macro_left6 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1722));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1723));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1726));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 43";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1727));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1700));
        this.test("simple case statement nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE (SELECT 1)\n        |   WHEN 1 THEN\n        |     CASE 2\n        |       WHEN 2 THEN\n        |         SELECT 41;\n        |       ELSE\n        |         SELECT 42;\n        |     END CASE;\n        |  END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1747));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left2 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1748));
            SimpleCaseStatement caseStmt = (SimpleCaseStatement)tree.collection().head();
            Expression $org_scalatest_assert_macro_left3 = caseStmt.caseVariableExpression();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.ScalarSubquery", $org_scalatest_assert_macro_left3 instanceof ScalarSubquery, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1752));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1753));
            Seq $org_scalatest_assert_macro_left5 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1754));
            Option $org_scalatest_assert_macro_left6 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1755));
            Expression $org_scalatest_assert_macro_left7 = (Expression)caseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression = $org_scalatest_assert_macro_left7;
            Literal literal = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1757));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left8 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1759));
            SimpleCaseStatement nestedCaseStmt = (SimpleCaseStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Expression $org_scalatest_assert_macro_left9 = nestedCaseStmt.caseVariableExpression();
            Literal $org_scalatest_assert_macro_right5 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            Expression expression2 = $org_scalatest_assert_macro_left9;
            Literal literal2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(expression2 != null ? !expression2.equals(literal2) : literal2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1763));
            Seq $org_scalatest_assert_macro_left10 = nestedCaseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1764));
            Seq $org_scalatest_assert_macro_left11 = nestedCaseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left11, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1765));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(nestedCaseStmt.elseBody().isDefined(), "nestedCaseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1766));
            Expression $org_scalatest_assert_macro_left12 = (Expression)nestedCaseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right8 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            Expression expression3 = $org_scalatest_assert_macro_left12;
            Literal literal3 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right8, !(expression3 != null ? !expression3.equals(literal3) : literal3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1768));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1770));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 41";
            String string = $org_scalatest_assert_macro_left14;
            String string2 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right9, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1771));
            CompoundPlanStatement $org_scalatest_assert_macro_left15 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left15, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left15 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1774));
            String $org_scalatest_assert_macro_left16 = ((SingleStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right10 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left16;
            String string4 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right10, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1775));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1731));
        this.test("loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: LOOP\n        |  SELECT 1;\n        |  SELECT 2;\n        |END LOOP lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1789));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1790));
            LoopStatement whileStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1794));
            Seq $org_scalatest_assert_macro_left4 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1795));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1796));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1797));
            Option $org_scalatest_assert_macro_left7 = whileStmt.label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left7.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1799));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1779));
        this.test("loop with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | LOOP\n        | END LOOP;\n        |END\n      "));
            ParseException x$115 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1810));
            String x$116 = "PARSE_SYNTAX_ERROR";
            Map x$117 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'LOOP'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$118 = this.checkError$default$3();
            boolean x$119 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$120 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$115, "PARSE_SYNTAX_ERROR", x$118, x$117, x$119, x$120);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1802));
        this.test("loop with if else block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: LOOP\n        | IF 1 = 1 THEN\n        |   SELECT 1;\n        | ELSE\n        |   SELECT 2;\n        | END IF;\n        |END LOOP lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1831));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1832));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1836));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1837));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)loopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left5 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1838));
            IfElseStatement ifStmt = (IfElseStatement)loopStmt.body().collection().head();
            Seq $org_scalatest_assert_macro_left6 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1841));
            Seq $org_scalatest_assert_macro_left7 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1842));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1843));
            SingleStatement $org_scalatest_assert_macro_left8 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1845));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right5 = "1 = 1";
            String string = $org_scalatest_assert_macro_left9;
            String string2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1846));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1848));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1849));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1852));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1853));
            Option $org_scalatest_assert_macro_left14 = loopStmt.label();
            String $org_scalatest_assert_macro_right8 = "lbl";
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1856));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1817));
        this.test("nested loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: LOOP\n        |  LOOP\n        |    SELECT 42;\n        |  END LOOP;\n        |END LOOP lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1870));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1871));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1875));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1876));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)loopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left5 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1877));
            LoopStatement nestedLoopStmt = (LoopStatement)loopStmt.body().collection().head();
            CompoundBody $org_scalatest_assert_macro_left6 = nestedLoopStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1880));
            Seq $org_scalatest_assert_macro_left7 = nestedLoopStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1881));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)nestedLoopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1882));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)nestedLoopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 42";
            String string = $org_scalatest_assert_macro_left9;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1883));
            Option $org_scalatest_assert_macro_left10 = loopStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left10.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1886));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1859));
        this.test("leave loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: LOOP\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  END LOOP;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1899));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1900));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1904));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1905));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)loopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1907));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)loopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1908));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)loopStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left7 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1910));
            String $org_scalatest_assert_macro_left8 = ((LeaveStatement)loopStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1911));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1889));
        this.test("iterate loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: LOOP\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  END LOOP;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1924));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1925));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1929));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1930));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)loopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1932));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)loopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1933));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)loopStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left7 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1935));
            String $org_scalatest_assert_macro_left8 = ((IterateStatement)loopStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1936));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1914));
        this.test("leave outer loop from nested loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: LOOP\n        |    lbl2: LOOP\n        |      SELECT 1;\n        |      LEAVE lbl;\n        |    END LOOP;\n        |  END LOOP;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1951));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1952));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1956));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1957));
            LoopStatement nestedLoopStmt = (LoopStatement)loopStmt.body().collection().head();
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)nestedLoopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1961));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)nestedLoopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1962));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)nestedLoopStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left7 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1965));
            String $org_scalatest_assert_macro_left8 = ((LeaveStatement)nestedLoopStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1966));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1939));
        this.test("iterate outer loop from nested loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: LOOP\n        |    lbl2: LOOP\n        |      SELECT 1;\n        |      ITERATE lbl;\n        |    END LOOP;\n        |  END LOOP;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1981));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1982));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1986));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1987));
            LoopStatement nestedLoopStmt = (LoopStatement)loopStmt.body().collection().head();
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)nestedLoopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1991));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)nestedLoopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1992));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)nestedLoopStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left7 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1995));
            String $org_scalatest_assert_macro_left8 = ((IterateStatement)nestedLoopStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1996));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1969));
        this.test("unique label names: nested begin-end blocks", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END;\n        |END\n      "));
            SqlScriptingException x$121 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2009));
            String x$122 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$123 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$124 = this.checkError$default$3();
            boolean x$125 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$126 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$121, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$124, x$123, x$125, x$126);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1999));
        this.test("unique label names: nested begin-end blocks - case sensitivity check 1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |LbL: BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END;\n        |END\n      "));
            SqlScriptingException x$127 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2028));
            String x$128 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$129 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$130 = this.checkError$default$3();
            boolean x$131 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$132 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$127, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$130, x$129, x$131, x$132);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2018));
        this.test("unique label names: nested begin-end blocks - case sensitivity check 2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  LbL: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END;\n        |END\n      "));
            SqlScriptingException x$133 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2047));
            String x$134 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$135 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$136 = this.checkError$default$3();
            boolean x$137 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$138 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$133, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$136, x$135, x$137, x$138);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2037));
        this.test("unique label names: nested begin-end blocks with same prefix", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl_1: BEGIN\n        |  lbl_11: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2067));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2068));
            CompoundBody body_1 = (CompoundBody)tree.collection().head();
            String $org_scalatest_assert_macro_left3 = (String)body_1.label().get();
            String $org_scalatest_assert_macro_right2 = "lbl_1";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2070));
            Seq $org_scalatest_assert_macro_left4 = body_1.collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2071));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)body_1.collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2072));
            CompoundBody body_11 = (CompoundBody)body_1.collection().head();
            String $org_scalatest_assert_macro_left6 = (String)body_11.label().get();
            String $org_scalatest_assert_macro_right4 = "lbl_11";
            String string3 = $org_scalatest_assert_macro_left6;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2074));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2056));
        this.test("unique label names: multi-level nested begin-end blocks", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl_1: BEGIN\n        |  lbl_2: BEGIN\n        |    lbl_1: BEGIN\n        |      SELECT 1;\n        |    END;\n        |  END;\n        |END;\n        |END\n      "));
            SqlScriptingException x$139 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2089));
            String x$140 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$141 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl_1"))}));
            Option x$142 = this.checkError$default$3();
            boolean x$143 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$144 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$139, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$142, x$141, x$143, x$144);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2077));
        this.test("unique label names: while loop in begin-end block", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  lbl: WHILE 1=1 DO\n        |    SELECT 1;\n        |  END WHILE;\n        |END;\n        |END\n      "));
            SqlScriptingException x$145 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2108));
            String x$146 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$147 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$148 = this.checkError$default$3();
            boolean x$149 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$150 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$145, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$148, x$147, x$149, x$150);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2098));
        this.test("unique label names: begin-end block in while loop", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1=1 DO\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END WHILE;\n        |END\n      "));
            SqlScriptingException x$151 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2127));
            String x$152 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$153 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$154 = this.checkError$default$3();
            boolean x$155 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$156 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$151, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$154, x$153, x$155, x$156);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2117));
        this.test("unique label names: nested while loops", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |w_loop: WHILE 1=1 DO\n        |  w_loop: WHILE 2=2 DO\n        |    SELECT 1;\n        |  END WHILE;\n        |END WHILE;\n        |END\n      "));
            SqlScriptingException x$157 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2146));
            String x$158 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$159 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("w_loop"))}));
            Option x$160 = this.checkError$default$3();
            boolean x$161 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$162 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$157, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$160, x$159, x$161, x$162);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2136));
        this.test("unique label names: nested repeat loops", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |r_loop: REPEAT\n        |  r_loop: REPEAT\n        |    SELECT 1;\n        |  UNTIL 1 = 1\n        |  END REPEAT;\n        |UNTIL 1 = 1\n        |END REPEAT;\n        |END\n      "));
            SqlScriptingException x$163 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2167));
            String x$164 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$165 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("r_loop"))}));
            Option x$166 = this.checkError$default$3();
            boolean x$167 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$168 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$163, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$166, x$165, x$167, x$168);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2155));
        this.test("unique label names: nested loop loops", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |l_loop: LOOP\n        |  l_loop: LOOP\n        |    SELECT 1;\n        |  END LOOP;\n        |END LOOP;\n        |END\n      "));
            SqlScriptingException x$169 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2186));
            String x$170 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$171 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("l_loop"))}));
            Option x$172 = this.checkError$default$3();
            boolean x$173 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$174 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$169, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$172, x$171, x$173, x$174);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2176));
        this.test("unique label names: nested for loops", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |f_loop: FOR x AS SELECT 1 DO\n        |  f_loop: FOR y AS SELECT 2 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END FOR;\n        |END\n      "));
            SqlScriptingException x$175 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2205));
            String x$176 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$177 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("f_loop"))}));
            Option x$178 = this.checkError$default$3();
            boolean x$179 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$180 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$175, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$178, x$177, x$179, x$180);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2195));
        this.test("unique label names: begin-end block on the same level", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  SELECT 1;\n        |END;\n        |lbl: BEGIN\n        |  SELECT 2;\n        |END;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2226));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2227));
            String $org_scalatest_assert_macro_left3 = (String)((CompoundBody)tree.collection().head()).label().get();
            String $org_scalatest_assert_macro_right2 = "lbl";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2228));
            CompoundPlanStatement $org_scalatest_assert_macro_left4 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left4 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2229));
            String $org_scalatest_assert_macro_left5 = (String)((CompoundBody)tree.collection().apply(1)).label().get();
            String $org_scalatest_assert_macro_right3 = "lbl";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2230));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2214));
        this.test("unique label names: begin-end block and loops on the same level", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  SELECT 1;\n        |END;\n        |lbl: WHILE 1=1 DO\n        |  SELECT 2;\n        |END WHILE;\n        |lbl: LOOP\n        |  SELECT 3;\n        |END LOOP;\n        |lbl: REPEAT\n        |  SELECT 4;\n        |UNTIL 1=1\n        |END REPEAT;\n        |lbl: FOR x AS SELECT 1 DO\n        |  SELECT 5;\n        |END FOR;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2255));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2256));
            String $org_scalatest_assert_macro_left3 = (String)((CompoundBody)tree.collection().head()).label().get();
            String $org_scalatest_assert_macro_right2 = "lbl";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2257));
            CompoundPlanStatement $org_scalatest_assert_macro_left4 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left4 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2258));
            String $org_scalatest_assert_macro_left5 = (String)((WhileStatement)tree.collection().apply(1)).label().get();
            String $org_scalatest_assert_macro_right3 = "lbl";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2259));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)tree.collection().apply(2);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left6 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2260));
            String $org_scalatest_assert_macro_left7 = (String)((LoopStatement)tree.collection().apply(2)).label().get();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string5 = $org_scalatest_assert_macro_left7;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2261));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)tree.collection().apply(3);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left8 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2262));
            String $org_scalatest_assert_macro_left9 = (String)((RepeatStatement)tree.collection().apply(3)).label().get();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string7 = $org_scalatest_assert_macro_left9;
            String string8 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2263));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)tree.collection().apply(4);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left10 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2264));
            String $org_scalatest_assert_macro_left11 = (String)((ForStatement)tree.collection().apply(4)).label().get();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string9 = $org_scalatest_assert_macro_left11;
            String string10 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2265));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2233));
        this.test("qualified label name: label cannot be qualified", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  part1.part2: BEGIN\n        |  END;\n        |END"));
            SqlScriptingException x$181 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2276));
            String x$182 = "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME";
            Map x$183 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"PART1.PART2")}));
            Option x$184 = this.checkError$default$3();
            boolean x$185 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$186 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$181, "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME", x$184, x$183, x$185, x$186);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2268));
        this.test("qualified label name: label cannot be qualified + end label", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  part1.part2: BEGIN\n        |  END part1.part2;\n        |END"));
            SqlScriptingException x$187 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2291));
            String x$188 = "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME";
            Map x$189 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"PART1.PART2")}));
            Option x$190 = this.checkError$default$3();
            boolean x$191 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$192 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$187, "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME", x$190, x$189, x$191, x$192);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2283));
        this.test("unique label names: nested labeled scope statements", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl_0: BEGIN\n        |  lbl_1: WHILE 1=1 DO\n        |    lbl_2: LOOP\n        |      lbl_3: REPEAT\n        |        lbl_4: FOR x AS SELECT 1 DO\n        |          SELECT 4;\n        |        END FOR;\n        |      UNTIL 1=1\n        |      END REPEAT;\n        |    END LOOP;\n        |  END WHILE;\n        |END;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2316));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2317));
            CompoundBody body = (CompoundBody)tree.collection().head();
            String $org_scalatest_assert_macro_left3 = (String)body.label().get();
            String $org_scalatest_assert_macro_right2 = "lbl_0";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2320));
            CompoundPlanStatement $org_scalatest_assert_macro_left4 = (CompoundPlanStatement)body.collection().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left4 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2321));
            WhileStatement whileStatement = (WhileStatement)body.collection().head();
            String $org_scalatest_assert_macro_left5 = (String)whileStatement.label().get();
            String $org_scalatest_assert_macro_right3 = "lbl_1";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2324));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)whileStatement.body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left6 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2325));
            LoopStatement loopStatement = (LoopStatement)whileStatement.body().collection().head();
            String $org_scalatest_assert_macro_left7 = (String)loopStatement.label().get();
            String $org_scalatest_assert_macro_right4 = "lbl_2";
            String string5 = $org_scalatest_assert_macro_left7;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2328));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)loopStatement.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left8 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2329));
            RepeatStatement repeatStatement = (RepeatStatement)loopStatement.body().collection().head();
            String $org_scalatest_assert_macro_left9 = (String)repeatStatement.label().get();
            String $org_scalatest_assert_macro_right5 = "lbl_3";
            String string7 = $org_scalatest_assert_macro_left9;
            String string8 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2332));
            ForStatement forStatement = (ForStatement)repeatStatement.body().collection().head();
            String $org_scalatest_assert_macro_left10 = (String)forStatement.label().get();
            String $org_scalatest_assert_macro_right6 = "lbl_4";
            String string9 = $org_scalatest_assert_macro_left10;
            String string10 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right6, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2335));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2298));
        this.test("for variable not the same as labels in scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  L1: BEGIN\n        |    L2: BEGIN\n        |      L3: FOR L4 AS SELECT 1 DO\n        |        SELECT 1;\n        |        FOR L5 AS SELECT 3 DO\n        |          BEGIN\n        |            SELECT L4;\n        |          END;\n        |         SELECT 4;\n        |        END FOR;\n        |      END FOR L3;\n        |    END L2;\n        |    L4: BEGIN\n        |      SELECT 3;\n        |    END L4;\n        |  END L1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2361));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2362));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2338));
        this.test("for variable name is the same as a label in scope - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  L1: BEGIN\n        |    L2: BEGIN\n        |      L3: FOR L2 AS SELECT 1 DO\n        |        SELECT 1;\n        |        SELECT 2;\n        |      END FOR L3;\n        |    END L2;\n        |    L4: BEGIN\n        |      SELECT 3;\n        |    END L4;\n        |  END L1;\n        |END"));
            SqlScriptingException x$193 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2383));
            String x$194 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$195 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"`l2`")}));
            Option x$196 = this.checkError$default$3();
            boolean x$197 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$198 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$193, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$196, x$195, x$197, x$198);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2365));
        this.test("for variable name is the same as the label of the for loop - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  L1: FOR L1 AS SELECT 1 DO\n        |    SELECT 2;\n        |  END FOR L1;\n        |END"));
            SqlScriptingException x$199 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2400));
            String x$200 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$201 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"`l1`")}));
            Option x$202 = this.checkError$default$3();
            boolean x$203 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$204 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$199, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$202, x$201, x$203, x$204);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2390));
        this.test("label name is the same as the for loop variable name - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR L1 AS SELECT 1 DO\n        |    L1: BEGIN\n        |      SELECT 2;\n        |    END L1;\n        |  END FOR;\n        |END"));
            SqlScriptingException x$205 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2419));
            String x$206 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$207 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"`l1`")}));
            Option x$208 = this.checkError$default$3();
            boolean x$209 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$210 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$205, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$208, x$207, x$209, x$210);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2407));
        this.test("nested for loop variable names are the same - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR L1 AS SELECT 1 DO\n        |    FOR L1 AS SELECT 2 DO\n        |     SELECT 3;\n        |    END FOR;\n        |  END FOR;\n        |END"));
            SqlScriptingException x$211 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2438));
            String x$212 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$213 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"`l1`")}));
            Option x$214 = this.checkError$default$3();
            boolean x$215 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$216 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$211, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$214, x$213, x$215, x$216);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2426));
        this.test("for loop variable names are the same but for loops are not nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR L1 AS SELECT 1 DO\n        |    SELECT 2;\n        |  END FOR;\n        |  FOR L1 AS SELECT 3 DO\n        |    SELECT 4;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2458));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$154(x$9))), "tree.collection.forall(((x$9: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$9.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.ForStatement]))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2459));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2445));
        this.test("for statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR x AS SELECT 5 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2471));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2472));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2475));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 5";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2476));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            String $org_scalatest_assert_macro_right3 = "x";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2477));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2479));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2480));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2481));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2482));
            Option $org_scalatest_assert_macro_left10 = forStmt.label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left10.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2484));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2462));
        this.test("for statement - empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR x AS SELECT 5 DO\n        |  END FOR;\n        |END"));
            ParseException x$217 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2495));
            String x$218 = "PARSE_SYNTAX_ERROR";
            Map x$219 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'FOR'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$220 = this.checkError$default$3();
            boolean x$221 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$222 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$217, "PARSE_SYNTAX_ERROR", x$220, x$219, x$221, x$222);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2487));
        this.test("for statement - no label", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR x AS SELECT 5 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2511));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2512));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2515));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 5";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2516));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            String $org_scalatest_assert_macro_right3 = "x";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2517));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2519));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2520));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2521));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2522));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(forStmt.label().isDefined(), "forStmt.label.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2525));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2502));
        this.test("for statement - with complex subquery", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR x AS SELECT c1, c2 FROM t WHERE c2 = 5 GROUP BY c1 ORDER BY c1 DO\n        |    SELECT x.c1;\n        |    SELECT x.c2;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2538));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2539));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2542));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT c1, c2 FROM t WHERE c2 = 5 GROUP BY c1 ORDER BY c1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2543));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            String $org_scalatest_assert_macro_right3 = "x";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2544));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2546));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2547));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2548));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT x.c1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2549));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)forStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2550));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)forStmt.body().collection().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT x.c2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2551));
            Option $org_scalatest_assert_macro_left12 = forStmt.label();
            String $org_scalatest_assert_macro_right7 = "lbl";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left12.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2553));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2528));
        this.test("for statement - nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl1: FOR i AS SELECT 1 DO\n        |    lbl2: FOR j AS SELECT 2 DO\n        |      SELECT i + j;\n        |    END FOR lbl2;\n        |  END FOR lbl1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2567));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2568));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2571));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2572));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            String $org_scalatest_assert_macro_right3 = "i";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2573));
            Option $org_scalatest_assert_macro_left6 = forStmt.label();
            String $org_scalatest_assert_macro_right4 = "lbl1";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2574));
            CompoundBody $org_scalatest_assert_macro_left7 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left7 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2576));
            Seq $org_scalatest_assert_macro_left8 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2577));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left9 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2578));
            ForStatement nestedForStmt = (ForStatement)forStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left10 = nestedForStmt.query();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2581));
            String $org_scalatest_assert_macro_left11 = nestedForStmt.query().getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 2";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2582));
            Option $org_scalatest_assert_macro_left12 = nestedForStmt.variableName();
            String $org_scalatest_assert_macro_right7 = "j";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left12.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2583));
            Option $org_scalatest_assert_macro_left13 = nestedForStmt.label();
            String $org_scalatest_assert_macro_right8 = "lbl2";
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left13.contains((Object)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2584));
            CompoundBody $org_scalatest_assert_macro_left14 = nestedForStmt.body();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left14 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2586));
            Seq $org_scalatest_assert_macro_left15 = nestedForStmt.body().collection();
            int $org_scalatest_assert_macro_right9 = 1;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left15, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2587));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)nestedForStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2588));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)nestedForStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right10 = "SELECT i + j";
            String string5 = $org_scalatest_assert_macro_left17;
            String string6 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right10, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2589));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2556));
        this.test("for statement - no variable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR SELECT 5 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2602));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2603));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2606));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 5";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2607));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2608));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2610));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2611));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2612));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2613));
            Option $org_scalatest_assert_macro_left10 = forStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left10.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2615));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2593));
        this.test("for statement - no variable - empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR SELECT 5 DO\n        |  END FOR;\n        |END"));
            ParseException x$223 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2626));
            String x$224 = "PARSE_SYNTAX_ERROR";
            Map x$225 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'FOR'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$226 = this.checkError$default$3();
            boolean x$227 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$228 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$223, "PARSE_SYNTAX_ERROR", x$226, x$225, x$227, x$228);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2618));
        this.test("for statement - no variable - no label", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR SELECT 5 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2642));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2643));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2646));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 5";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2647));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2648));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2650));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2651));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2652));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2653));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(forStmt.label().isDefined(), "forStmt.label.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2656));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2633));
        this.test("for statement - no variable - with complex subquery", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR SELECT c1, c2 FROM t WHERE c2 = 5 GROUP BY c1 ORDER BY c1 DO\n        |    SELECT 1;\n        |    SELECT 2;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2669));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2670));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2673));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT c1, c2 FROM t WHERE c2 = 5 GROUP BY c1 ORDER BY c1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2674));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2675));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2677));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2678));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2679));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2680));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)forStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2681));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)forStmt.body().collection().apply(1)).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2682));
            Option $org_scalatest_assert_macro_left12 = forStmt.label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left12.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2684));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2659));
        this.test("for statement - no variable - nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl1: FOR SELECT 1 DO\n        |    lbl2: FOR SELECT 2 DO\n        |      SELECT 3;\n        |    END FOR lbl2;\n        |  END FOR lbl1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2698));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2699));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2702));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2703));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2704));
            Option $org_scalatest_assert_macro_left6 = forStmt.label();
            String $org_scalatest_assert_macro_right3 = "lbl1";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2705));
            CompoundBody $org_scalatest_assert_macro_left7 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left7 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2707));
            Seq $org_scalatest_assert_macro_left8 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2708));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left9 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2709));
            ForStatement nestedForStmt = (ForStatement)forStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left10 = nestedForStmt.query();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2712));
            String $org_scalatest_assert_macro_left11 = nestedForStmt.query().getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 2";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2713));
            Option $org_scalatest_assert_macro_left12 = nestedForStmt.variableName();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2714));
            Option $org_scalatest_assert_macro_left13 = nestedForStmt.label();
            String $org_scalatest_assert_macro_right6 = "lbl2";
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left13.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2715));
            CompoundBody $org_scalatest_assert_macro_left14 = nestedForStmt.body();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left14 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2717));
            Seq $org_scalatest_assert_macro_left15 = nestedForStmt.body().collection();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left15, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2718));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)nestedForStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2719));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)nestedForStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 3";
            String string5 = $org_scalatest_assert_macro_left17;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2720));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2687));
        this.test("declare condition: custom sqlstate", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE test CONDITION FOR SQLSTATE '12000';\n        |  SELECT 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = tree.conditions();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2732));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((String)tree.conditions().apply((Object)"TEST")).equals("12000"), "tree.conditions.apply(\"TEST\").equals(\"12000\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2733));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2724));
        this.test("declare condition: default sqlstate", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE test CONDITION;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = tree.conditions();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2743));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((String)tree.conditions().apply((Object)"TEST")).equals("45000"), "tree.conditions.apply(\"TEST\").equals(\"45000\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2744));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2736));
        this.test("declare condition in wrong place", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  DECLARE test_condition CONDITION FOR SQLSTATE '12345';\n        |END"));
            SqlScriptingException x$229 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2754));
            String x$230 = "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT";
            Map x$231 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)"`TEST_CONDITION`")}));
            Option x$232 = this.checkError$default$3();
            boolean x$233 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$234 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$229, "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT", x$232, x$231, x$233, x$234);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2761));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2747));
        this.test("declare condition in wrong scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12345';\n        | END IF;\n        |END"));
            SqlScriptingException x$235 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2772));
            String x$236 = "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT";
            Map x$237 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)DataTypeErrors$.MODULE$.toSQLId("TEST_CONDITION"))}));
            Option x$238 = this.checkError$default$3();
            boolean x$239 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$240 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$235, "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT", x$238, x$237, x$239, x$240);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2779));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2764));
        this.test("declare qualified condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST.CONDITION CONDITION FOR SQLSTATE '12345';\n        |END"));
            SqlScriptingException x$241 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2788));
            String x$242 = "INVALID_ERROR_CONDITION_DECLARATION.QUALIFIED_CONDITION_NAME";
            Map x$243 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)"TEST.CONDITION")}));
            Option x$244 = this.checkError$default$3();
            boolean x$245 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$246 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$241, "INVALID_ERROR_CONDITION_DECLARATION.QUALIFIED_CONDITION_NAME", x$244, x$243, x$245, x$246);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2795));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2782));
        this.test("declare condition with special characters", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE `test-condition` CONDITION FOR SQLSTATE '12345';\n        |END"));
            SqlScriptingException x$247 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2804));
            String x$248 = "INVALID_ERROR_CONDITION_DECLARATION.SPECIAL_CHARACTER_FOUND";
            Map x$249 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)DataTypeErrors$.MODULE$.toSQLId("test-condition"))}));
            Option x$250 = this.checkError$default$3();
            boolean x$251 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$252 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$247, "INVALID_ERROR_CONDITION_DECLARATION.SPECIAL_CHARACTER_FOUND", x$250, x$249, x$251, x$252);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2811));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2798));
        this.test("declare duplicate condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12000';\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '13000';\n        |  SELECT 1;\n        |END"));
            SqlScriptingException x$253 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2822));
            String x$254 = "DUPLICATE_CONDITION_IN_SCOPE";
            Map x$255 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)DataTypeErrors$.MODULE$.toSQLId("TEST_CONDITION"))}));
            Option x$256 = this.checkError$default$3();
            boolean x$257 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$258 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$253, "DUPLICATE_CONDITION_IN_SCOPE", x$256, x$255, x$257, x$258);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2829));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2814));
        this.test("declare duplicate condition nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12000';\n        |  BEGIN\n        |    IF (1 = 1) THEN\n        |      BEGIN\n        |        DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '13000';\n        |      END;\n        |    END IF;\n        |  END;\n        |  SELECT 1;\n        |END"));
            SqlScriptingException x$259 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2846));
            String x$260 = "DUPLICATE_CONDITION_IN_SCOPE";
            Map x$261 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)DataTypeErrors$.MODULE$.toSQLId("TEST_CONDITION"))}));
            Option x$262 = this.checkError$default$3();
            boolean x$263 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$264 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$259, "DUPLICATE_CONDITION_IN_SCOPE", x$262, x$261, x$263, x$264);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2853));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2832));
        this.test("continue handler not supported", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SQL_SCRIPTING_CONTINUE_HANDLER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |BEGIN\n          |  DECLARE OR REPLACE flag INT = -1;\n          |  DECLARE CONTINUE HANDLER FOR SQLSTATE '22012'\n          |  BEGIN\n          |    SET flag = 1;\n          |  END;\n          |  SELECT 1/0;\n          |  SELECT flag;\n          |END\n          |"));
            SqlScriptingException x$265 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2872));
            String x$266 = "UNSUPPORTED_FEATURE.CONTINUE_EXCEPTION_HANDLER";
            Map x$267 = Predef$.MODULE$.Map().empty();
            Option x$268 = this.checkError$default$3();
            boolean x$269 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$270 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$265, "UNSUPPORTED_FEATURE.CONTINUE_EXCEPTION_HANDLER", x$268, x$267, x$269, x$270);
        }), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2856));
        this.test("declare exit handler for qualified condition name that is not supported", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE EXIT HANDLER FOR qualified.condition.name\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$271 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2894));
            String x$272 = "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND";
            Map x$273 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"QUALIFIED.CONDITION.NAME")}));
            Option x$274 = this.checkError$default$3();
            boolean x$275 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$276 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$271, "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND", x$274, x$273, x$275, x$276);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2880));
        this.test("declare continue handler for qualified condition name that is not supported", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE CONTINUE HANDLER FOR qualified.condition.name\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$277 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2915));
            String x$278 = "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND";
            Map x$279 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"QUALIFIED.CONDITION.NAME")}));
            Option x$280 = this.checkError$default$3();
            boolean x$281 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$282 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$277, "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND", x$280, x$279, x$281, x$282);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2901));
        this.test("declare exit handler for undefined condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR undefined_condition BEGIN SELECT 1; END;\n        |  SELECT 1;\n        |END"));
            SqlScriptingException x$283 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2929));
            String x$284 = "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND";
            Map x$285 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"UNDEFINED_CONDITION")}));
            Option x$286 = this.checkError$default$3();
            boolean x$287 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$288 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$283, "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND", x$286, x$285, x$287, x$288);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2936));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2922));
        this.test("declare continue handler for undefined condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE CONTINUE HANDLER FOR undefined_condition BEGIN SELECT 1; END;\n        |  SELECT 1;\n        |END"));
            SqlScriptingException x$289 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2946));
            String x$290 = "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND";
            Map x$291 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"UNDEFINED_CONDITION")}));
            Option x$292 = this.checkError$default$3();
            boolean x$293 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$294 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$289, "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND", x$292, x$291, x$293, x$294);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2953));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2939));
        this.test("declare exit handler in wrong place", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO BEGIN SELECT 1; END;\n        |END"));
            SqlScriptingException x$295 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2963));
            String x$296 = "INVALID_HANDLER_DECLARATION.WRONG_PLACE_OF_DECLARATION";
            Map x$297 = Predef$.MODULE$.Map().empty();
            Option x$298 = this.checkError$default$3();
            boolean x$299 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$300 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$295, "INVALID_HANDLER_DECLARATION.WRONG_PLACE_OF_DECLARATION", x$298, x$297, x$299, x$300);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2970));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2956));
        this.test("declare continue handler in wrong place", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  DECLARE CONTINUE HANDLER FOR DIVIDE_BY_ZERO BEGIN SELECT 1; END;\n        |END"));
            SqlScriptingException x$301 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2980));
            String x$302 = "INVALID_HANDLER_DECLARATION.WRONG_PLACE_OF_DECLARATION";
            Map x$303 = Predef$.MODULE$.Map().empty();
            Option x$304 = this.checkError$default$3();
            boolean x$305 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$306 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$301, "INVALID_HANDLER_DECLARATION.WRONG_PLACE_OF_DECLARATION", x$304, x$303, x$305, x$306);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2987));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2973));
        this.test("duplicate condition in exit handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE DUPLICATE_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  DECLARE EXIT HANDLER FOR duplicate_condition, duplicate_condition\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$307 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3005));
            String x$308 = "INVALID_HANDLER_DECLARATION.DUPLICATE_CONDITION_IN_HANDLER_DECLARATION";
            Map x$309 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"DUPLICATE_CONDITION")}));
            Option x$310 = this.checkError$default$3();
            boolean x$311 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$312 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$307, "INVALID_HANDLER_DECLARATION.DUPLICATE_CONDITION_IN_HANDLER_DECLARATION", x$310, x$309, x$311, x$312);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2990));
        this.test("duplicate condition in continue handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE DUPLICATE_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  DECLARE CONTINUE HANDLER FOR duplicate_condition, duplicate_condition\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$313 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3027));
            String x$314 = "INVALID_HANDLER_DECLARATION.DUPLICATE_CONDITION_IN_HANDLER_DECLARATION";
            Map x$315 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"DUPLICATE_CONDITION")}));
            Option x$316 = this.checkError$default$3();
            boolean x$317 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$318 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$313, "INVALID_HANDLER_DECLARATION.DUPLICATE_CONDITION_IN_HANDLER_DECLARATION", x$316, x$315, x$317, x$318);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3012));
        this.test("duplicate sqlState in exit handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE EXIT HANDLER FOR SQLSTATE '12345', SQLSTATE '12345'\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$319 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3048));
            String x$320 = "INVALID_HANDLER_DECLARATION.DUPLICATE_SQLSTATE_IN_HANDLER_DECLARATION";
            Map x$321 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlState"), (Object)"12345")}));
            Option x$322 = this.checkError$default$3();
            boolean x$323 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$324 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$319, "INVALID_HANDLER_DECLARATION.DUPLICATE_SQLSTATE_IN_HANDLER_DECLARATION", x$322, x$321, x$323, x$324);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3034));
        this.test("duplicate sqlState in continue handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE CONTINUE HANDLER FOR SQLSTATE '12345', SQLSTATE '12345'\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$325 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3069));
            String x$326 = "INVALID_HANDLER_DECLARATION.DUPLICATE_SQLSTATE_IN_HANDLER_DECLARATION";
            Map x$327 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlState"), (Object)"12345")}));
            Option x$328 = this.checkError$default$3();
            boolean x$329 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$330 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$325, "INVALID_HANDLER_DECLARATION.DUPLICATE_SQLSTATE_IN_HANDLER_DECLARATION", x$328, x$327, x$329, x$330);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3055));
        this.test("invalid condition combination in exit handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE EXIT HANDLER FOR SQLEXCEPTION, SQLSTATE '12345'\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$331 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3090));
            String x$332 = "INVALID_HANDLER_DECLARATION.INVALID_CONDITION_COMBINATION";
            Map x$333 = Predef$.MODULE$.Map().empty();
            Option x$334 = this.checkError$default$3();
            boolean x$335 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$336 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$331, "INVALID_HANDLER_DECLARATION.INVALID_CONDITION_COMBINATION", x$334, x$333, x$335, x$336);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3076));
        this.test("invalid condition combination in continue handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE CONTINUE HANDLER FOR SQLEXCEPTION, SQLSTATE '12345'\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$337 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3111));
            String x$338 = "INVALID_HANDLER_DECLARATION.INVALID_CONDITION_COMBINATION";
            Map x$339 = Predef$.MODULE$.Map().empty();
            Option x$340 = this.checkError$default$3();
            boolean x$341 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$342 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$337, "INVALID_HANDLER_DECLARATION.INVALID_CONDITION_COMBINATION", x$340, x$339, x$341, x$342);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3097));
        this.test("declare exit handler with compound body", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO BEGIN SELECT 1; END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3125));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3126));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3127));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3128));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3129));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3130));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3131));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3118));
        this.test("declare continue handler with compound body", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE CONTINUE HANDLER FOR DIVIDE_BY_ZERO BEGIN SELECT 1; END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3142));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3143));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3144));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3145));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3146));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3147));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3148));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3135));
        this.test("declare exit handler single statement with END", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO SELECT 1 END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3161));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3162));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3163));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3164));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3165));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3166));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3167));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3154));
        this.test("declare continue handler single statement with END", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE CONTINUE HANDLER FOR DIVIDE_BY_ZERO SELECT 1 END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3178));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3179));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3180));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3181));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3182));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3183));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3184));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3171));
        this.test("declare exit handler single statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO SELECT 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3195));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3196));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3197));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3198));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3199));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3200));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3201));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3188));
        this.test("declare continue handler single statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE CONTINUE HANDLER FOR DIVIDE_BY_ZERO SELECT 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3212));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3213));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3214));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3215));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3216));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3217));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3218));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3205));
        this.test("declare exit handler set statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3229));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3230));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3231));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3232));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3233));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3234));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SetVariable", $org_scalatest_assert_macro_left7 instanceof SetVariable, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3235));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3222));
        this.test("declare continue handler set statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE CONTINUE HANDLER FOR DIVIDE_BY_ZERO SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3246));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3247));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3248));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3249));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3250));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3251));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SetVariable", $org_scalatest_assert_macro_left7 instanceof SetVariable, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3252));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3239));
        this.test("declare exit handler with multiple conditions/sqlstates", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION_1 CONDITION FOR SQLSTATE '12345';\n        |  DECLARE TEST_CONDITION_2 CONDITION FOR SQLSTATE '54321';\n        |  DECLARE EXIT HANDLER FOR SQLSTATE '22012', TEST_CONDITION_1, test_condition_2\n        |    SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3266));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3267));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3268));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "TEST_CONDITION_1";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3269));
            Set $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right4 = "TEST_CONDITION_2";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3270));
            Set $org_scalatest_assert_macro_left6 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3271));
            Set $org_scalatest_assert_macro_left7 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            String $org_scalatest_assert_macro_right6 = "22012";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3272));
            Seq $org_scalatest_assert_macro_left8 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3273));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3274));
            LogicalPlan $org_scalatest_assert_macro_left10 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SetVariable", $org_scalatest_assert_macro_left10 instanceof SetVariable, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3275));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3256));
        this.test("declare continue handler with multiple conditions/sqlstates", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION_1 CONDITION FOR SQLSTATE '12345';\n        |  DECLARE TEST_CONDITION_2 CONDITION FOR SQLSTATE '54321';\n        |  DECLARE CONTINUE HANDLER FOR SQLSTATE '22012', TEST_CONDITION_1, test_condition_2\n        |    SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3289));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3290));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3291));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "TEST_CONDITION_1";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3292));
            Set $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right4 = "TEST_CONDITION_2";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3293));
            Set $org_scalatest_assert_macro_left6 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3294));
            Set $org_scalatest_assert_macro_left7 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            String $org_scalatest_assert_macro_right6 = "22012";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3295));
            Seq $org_scalatest_assert_macro_left8 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3296));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3297));
            LogicalPlan $org_scalatest_assert_macro_left10 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SetVariable", $org_scalatest_assert_macro_left10 instanceof SetVariable, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3298));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3279));
        this.test("declare exit handler for SQLEXCEPTION", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR SQLEXCEPTION SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3309));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3310));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3311));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3312));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3313));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3314));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3315));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3302));
        this.test("declare continue handler for SQLEXCEPTION", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3325));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3326));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3327));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3328));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3329));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3330));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3331));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3318));
        this.test("declare exit handler for NOT FOUND", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR NOT FOUND SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3341));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3342));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3343));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3344));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3345));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3346));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3347));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3334));
        this.test("declare continue handler for NOT FOUND", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE CONTINUE HANDLER FOR NOT FOUND SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3357));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3358));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3359));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3360));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3361));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3362));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3363));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3350));
        this.test("declare exit handler with condition and sqlstate with same value", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE K2000 CONDITION FOR SQLSTATE '12345';\n        |  DECLARE EXIT HANDLER FOR K2000, SQLSTATE VALUE 'K2000' SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3374));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3375));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3376));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "K2000";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3377));
            Set $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3378));
            Set $org_scalatest_assert_macro_left6 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            String $org_scalatest_assert_macro_right5 = "K2000";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3379));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3380));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3381));
            Seq $org_scalatest_assert_macro_left7 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3382));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3366));
        this.test("declare continue handler with condition and sqlstate with same value", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE K2000 CONDITION FOR SQLSTATE '12345';\n        |  DECLARE CONTINUE HANDLER FOR K2000, SQLSTATE VALUE 'K2000' SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3393));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3394));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3395));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "K2000";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3396));
            Set $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3397));
            Set $org_scalatest_assert_macro_left6 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            String $org_scalatest_assert_macro_right5 = "K2000";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3398));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3399));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3400));
            Seq $org_scalatest_assert_macro_left7 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3401));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3385));
        this.test("declare exit handler for condition in parent scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  BEGIN\n        |    DECLARE EXIT HANDLER FOR TEST_CONDITION SET test_var = 1;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            CompoundBody handlerBody = (CompoundBody)tree.collection().head();
            Seq $org_scalatest_assert_macro_left = handlerBody.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3415));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)handlerBody.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3416));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)handlerBody.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3417));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)handlerBody.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "TEST_CONDITION";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3418));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)handlerBody.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3419));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3404));
        this.test("declare continue handler for condition in parent scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  BEGIN\n        |    DECLARE CONTINUE HANDLER FOR TEST_CONDITION SET test_var = 1;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            CompoundBody handlerBody = (CompoundBody)tree.collection().head();
            Seq $org_scalatest_assert_macro_left = handlerBody.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3433));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)handlerBody.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3434));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)handlerBody.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3435));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)handlerBody.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "TEST_CONDITION";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3436));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)handlerBody.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3437));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3422));
        this.test("declare nested exit handler for condition in parent scope of parent handler", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  BEGIN\n        |    DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO\n        |      BEGIN\n        |        DECLARE EXIT HANDLER FOR TEST_CONDITION SET test_var = 1;\n        |      END;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            ExceptionHandler handlerBody = (ExceptionHandler)((ExceptionHandler)((CompoundBody)tree.collection().head()).handlers().head()).body().handlers().head();
            Set $org_scalatest_assert_macro_left = handlerBody.exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right = "TEST_CONDITION";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3457));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3440));
        this.test("declare nested continue handler for condition in parent scope of parent handler", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  BEGIN\n        |    DECLARE CONTINUE HANDLER FOR DIVIDE_BY_ZERO\n        |      BEGIN\n        |        DECLARE CONTINUE HANDLER FOR TEST_CONDITION SET test_var = 1;\n        |      END;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            ExceptionHandler handlerBody = (ExceptionHandler)((ExceptionHandler)((CompoundBody)tree.collection().head()).handlers().head()).body().handlers().head();
            Set $org_scalatest_assert_macro_left = handlerBody.exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right = "TEST_CONDITION";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3477));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3460));
    }
}

