/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.AssertTrue;
import org.apache.spark.sql.catalyst.expressions.AssertTrue$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CommonExpressionDef;
import org.apache.spark.sql.catalyst.expressions.CommonExpressionDef$;
import org.apache.spark.sql.catalyst.expressions.CommonExpressionId;
import org.apache.spark.sql.catalyst.expressions.CommonExpressionId$;
import org.apache.spark.sql.catalyst.expressions.CommonExpressionRef;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.plans.NormalizePlan$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005!2Aa\u0001\u0003\u0001#!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0005?\t\u0011bj\u001c:nC2L'0\u001a)mC:\u001cV/\u001b;f\u0015\t)a!A\u0003qY\u0006t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9\u0002$D\u0001\u0007\u0013\tIbAA\u0007T#2\u001buN\u001c4IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\u0011\t1d]3u)&lWM_8oK\u001a{'/\u00117m\u000bb\u0004(/Z:tS>tGC\u0001\u0011'!\t\tC%D\u0001#\u0015\t\u0019C!A\u0004m_\u001eL7-\u00197\n\u0005\u0015\u0012#a\u0003'pO&\u001c\u0017\r\u001c)mC:DQa\n\u0002A\u0002\u0001\nA\u0001\u001d7b]\u0002")
public class NormalizePlanSuite
extends SparkFunSuite
implements SQLConfHelper {
    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private LogicalPlan setTimezoneForAllExpression(LogicalPlan plan) {
        return (LogicalPlan)plan.transformAllExpressions((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizePlanSuite $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                TimeZoneAwareExpression timeZoneAwareExpression;
                A1 A1 = x1;
                if (A1 instanceof TimeZoneAwareExpression && (timeZoneAwareExpression = (TimeZoneAwareExpression)A1).timeZoneId().isEmpty()) {
                    return (B1)timeZoneAwareExpression.withTimeZone(this.$outer.conf().sessionLocalTimeZone());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                TimeZoneAwareExpression timeZoneAwareExpression;
                Expression expression = x1;
                return expression instanceof TimeZoneAwareExpression && (timeZoneAwareExpression = (TimeZoneAwareExpression)expression).timeZoneId().isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public NormalizePlanSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        this.test("Normalize Project", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            AttributeReference baselineCol1 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int();
            AttributeReference testCol1 = baselineCol1.newInstance();
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{baselineCol1}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{baselineCol1}));
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{testCol1}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{testCol1}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = testPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("Normalize ordering in a project list of an inner Project under Project", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = testPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("Normalize ordering in a project list of an inner Project under Aggregate", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = testPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Normalize ordering in an aggregate list of an inner Aggregate under Project", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = testPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("Normalize ordering in an aggregate list of an inner Aggregate under Project and Filter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = testPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("Normalize ordering in an aggregate list of an inner Aggregate under Project and Sort", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}))).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3())}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}))).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3())}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = testPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("Normalize ordering in an aggregate list of an inner Aggregate under Project Sort and Filter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3())}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)).string()}))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3())}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = testPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("Normalize InheritAnalysisRules expressions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Cast castWithoutTimezone = Cast$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (DataType)BooleanType$.MODULE$, this.conf().ansiEnabled());
            TimeZoneAwareExpression castWithTimezone = castWithoutTimezone.withTimeZone(this.conf().sessionLocalTimeZone());
            AssertTrue baselineExpression = AssertTrue$.MODULE$.apply((Expression)castWithTimezone);
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{baselineExpression}));
            AssertTrue testExpression = AssertTrue$.MODULE$.apply((Expression)castWithoutTimezone);
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{testExpression}));
            testPlan.expressions().foreach((Function1 & Serializable)x0$1 -> {
                Expression expression = x0$1;
                if (expression instanceof AssertTrue) {
                    AssertTrue assertTrue = (AssertTrue)expression;
                    Expression firstCast = assertTrue.left();
                    Expression expression2 = assertTrue.replacement();
                    if (firstCast instanceof Cast) {
                        If if_;
                        Expression secondCast;
                        Cast cast = (Cast)firstCast;
                        if (expression2 instanceof If && (secondCast = (if_ = (If)expression2).predicate()) instanceof Cast) {
                            Cast cast2 = (Cast)secondCast;
                            Option $org_scalatest_assert_macro_left = cast.timeZoneId();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                            Option $org_scalatest_assert_macro_left2 = cast2.timeZoneId();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
                        }
                    }
                }
                return BoxedUnit.UNIT;
            });
            LogicalPlan resolvedBaselinePlan = this.setTimezoneForAllExpression(baselinePlan);
            LogicalPlan resolvedTestPlan = this.setTimezoneForAllExpression(testPlan);
            resolvedTestPlan.expressions().foreach((Function1 & Serializable)x0$2 -> {
                Expression expression = x0$2;
                if (expression instanceof AssertTrue) {
                    AssertTrue assertTrue = (AssertTrue)expression;
                    Expression firstCast = assertTrue.left();
                    Expression expression2 = assertTrue.replacement();
                    if (firstCast instanceof Cast) {
                        If if_;
                        Expression secondCast;
                        Cast cast = (Cast)firstCast;
                        if (expression2 instanceof If && (secondCast = (if_ = (If)expression2).predicate()) instanceof Cast) {
                            Cast cast2 = (Cast)secondCast;
                            Option $org_scalatest_assert_macro_left = cast.timeZoneId();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(cast2.timeZoneId().isDefined(), "secondCast.timeZoneId.isDefined", Prettifier$.MODULE$.default());
                            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
                        }
                    }
                }
                return BoxedUnit.UNIT;
            });
            LogicalPlan $org_scalatest_assert_macro_left = resolvedBaselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = resolvedTestPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(resolvedBaselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(resolvedTestPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("Normalize CommonExpressionId", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CommonExpressionRef baselineCommonExpressionRef = new CommonExpressionRef(new CommonExpressionId(CommonExpressionId$.MODULE$.$lessinit$greater$default$1(), CommonExpressionId$.MODULE$.$lessinit$greater$default$2()), (DataType)BooleanType$.MODULE$, false);
            CommonExpressionDef baselineCommonExpressionDef = new CommonExpressionDef((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), CommonExpressionDef$.MODULE$.apply$default$2());
            CommonExpressionRef testCommonExpressionRef = new CommonExpressionRef(new CommonExpressionId(CommonExpressionId$.MODULE$.$lessinit$greater$default$1(), CommonExpressionId$.MODULE$.$lessinit$greater$default$2()), (DataType)BooleanType$.MODULE$, false);
            CommonExpressionDef testCommonExpressionDef = new CommonExpressionDef((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), CommonExpressionDef$.MODULE$.apply$default$2());
            LogicalPlan baselinePlanRef = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{baselineCommonExpressionRef}));
            LogicalPlan testPlanRef = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{testCommonExpressionRef}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlanRef;
            LogicalPlan $org_scalatest_assert_macro_right = testPlanRef;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlanRef);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlanRef);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            LogicalPlan baselinePlanDef = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{baselineCommonExpressionDef}));
            LogicalPlan testPlanDef = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{testCommonExpressionDef}));
            LogicalPlan $org_scalatest_assert_macro_left3 = baselinePlanDef;
            LogicalPlan $org_scalatest_assert_macro_right3 = testPlanDef;
            LogicalPlan logicalPlan5 = $org_scalatest_assert_macro_left3;
            LogicalPlan logicalPlan6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", (Object)$org_scalatest_assert_macro_right3, logicalPlan5 == null ? logicalPlan6 != null : !logicalPlan5.equals(logicalPlan6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            LogicalPlan $org_scalatest_assert_macro_left4 = NormalizePlan$.MODULE$.apply(baselinePlanDef);
            LogicalPlan $org_scalatest_assert_macro_right4 = NormalizePlan$.MODULE$.apply(testPlanDef);
            LogicalPlan logicalPlan7 = $org_scalatest_assert_macro_left4;
            LogicalPlan logicalPlan8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(logicalPlan7 != null ? !logicalPlan7.equals(logicalPlan8) : logicalPlan8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("Normalize non-deterministic expressions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Random random = new Random();
            Expression baselineExpression = package.expressions$.MODULE$.rand(random.nextLong());
            Expression testExpression = package.expressions$.MODULE$.rand(random.nextLong());
            LogicalPlan baselinePlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{baselineExpression}));
            LogicalPlan testPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)LocalRelation$.MODULE$.apply((Seq)Nil$.MODULE$)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{testExpression}));
            LogicalPlan $org_scalatest_assert_macro_left = baselinePlan;
            LogicalPlan $org_scalatest_assert_macro_right = testPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            LogicalPlan $org_scalatest_assert_macro_left2 = NormalizePlan$.MODULE$.apply(baselinePlan);
            LogicalPlan $org_scalatest_assert_macro_right2 = NormalizePlan$.MODULE$.apply(testPlan);
            LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left2;
            LogicalPlan logicalPlan4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan3 != null ? !logicalPlan3.equals(logicalPlan4) : logicalPlan4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }, new Position("NormalizePlanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
    }
}

