/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkDateTimeException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SqlApiConf$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Entry;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.dsl.BeWord;
import org.scalatest.matchers.dsl.ContainWord;
import org.scalatest.matchers.dsl.DefinedWord;
import org.scalatest.matchers.dsl.EmptyWord;
import org.scalatest.matchers.dsl.EndWithWord;
import org.scalatest.matchers.dsl.ExistWord;
import org.scalatest.matchers.dsl.FullyMatchWord;
import org.scalatest.matchers.dsl.HaveWord;
import org.scalatest.matchers.dsl.IncludeWord;
import org.scalatest.matchers.dsl.LengthWord;
import org.scalatest.matchers.dsl.MatchPatternWord;
import org.scalatest.matchers.dsl.MatcherFactory1;
import org.scalatest.matchers.dsl.MatcherWords;
import org.scalatest.matchers.dsl.NoExceptionWord;
import org.scalatest.matchers.dsl.NotWord;
import org.scalatest.matchers.dsl.ReadableWord;
import org.scalatest.matchers.dsl.ResultOfATypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAllElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfAllOfApplication;
import org.scalatest.matchers.dsl.ResultOfAnTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfDefinedAt;
import org.scalatest.matchers.dsl.ResultOfGreaterThanComparison;
import org.scalatest.matchers.dsl.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfInOrderApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfLessThanComparison;
import org.scalatest.matchers.dsl.ResultOfLessThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfMessageWordApplication;
import org.scalatest.matchers.dsl.ResultOfNoElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfNoneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOfTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfThrownByApplication;
import org.scalatest.matchers.dsl.SizeWord;
import org.scalatest.matchers.dsl.SortedWord;
import org.scalatest.matchers.dsl.StartWithWord;
import org.scalatest.matchers.dsl.WritableWord;
import org.scalatest.matchers.must.Matchers;
import org.scalatest.matchers.must.Matchers$AtLeastCollected$;
import org.scalatest.matchers.must.Matchers$AtMostCollected$;
import org.scalatest.matchers.must.Matchers$BetweenCollected$;
import org.scalatest.matchers.must.Matchers$ExactlyCollected$;
import org.scalatest.matchers.should.Matchers$;
import org.scalatest.verbs.CompileWord;
import org.scalatest.verbs.MustVerb;
import org.scalatest.verbs.TypeCheckWord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u0005\u000b\u0001]AQ\u0001\f\u0001\u0005\u00025BQ\u0001\r\u0001\u0005\nEBQA\u000f\u0001\u0005\nmBQA\u0015\u0001\u0005\nMCQA\u0019\u0001\u0005\n\rDQ\u0001\u001c\u0001\u0005\u00025Dq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u0011\u0010C\u0004\u0002\n\u0001!I!a\u0003\u0003%\u0011\u000bG/\u001a+j[\u0016,F/\u001b7t'VLG/\u001a\u0006\u0003\u00171\tA!\u001e;jY*\u0011QBD\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0007\u000f'!\tI\"$D\u0001\u0011\u0013\tY\u0002CA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003;\u0011j\u0011A\b\u0006\u0003?\u0001\nA!\\;ti*\u0011\u0011EI\u0001\t[\u0006$8\r[3sg*\u00111\u0005F\u0001\ng\u000e\fG.\u0019;fgRL!!\n\u0010\u0003\u00115\u000bGo\u00195feN\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0007\u0002\u000bAd\u0017M\\:\n\u0005-B#!C*R\u0019\"+G\u000e]3s\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u00020\u00015\t!\"A\u0007eK\u001a\fW\u000f\u001c;[_:,\u0017\nZ\u000b\u0002eA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0005i&lWMC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$A\u0002.p]\u0016LE-\u0001\u0004u_\u0012\u000bG/\u001a\u000b\u0003y\u0015\u00032!\u0010!C\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB(qi&|g\u000e\u0005\u0002>\u0007&\u0011AI\u0010\u0002\u0004\u0013:$\b\"\u0002$\u0004\u0001\u00049\u0015!A:\u0011\u0005!{eBA%N!\tQe(D\u0001L\u0015\tae#\u0001\u0004=e>|GOP\u0005\u0003\u001dz\na\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011aJP\u0001 a\u0016\u0014X.\u001e;f/&$\bn\u00165ji\u0016\u001c\b/Y2f\u0003:$7i\u001c8ue>dGC\u0001+^!\r)&l\u0012\b\u0003-bs!AS,\n\u0003}J!!\u0017 \u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\u0004'\u0016\f(BA-?\u0011\u0015qF\u00011\u0001`\u0003\u00191\u0018\r\\;fgB\u0019Q\bY$\n\u0005\u0005t$A\u0003\u001fsKB,\u0017\r^3e}\u0005YAo\u001c+j[\u0016\u001cH/Y7q)\r!\u0007N\u001b\t\u0004{\u0001+\u0007CA\u001fg\u0013\t9gH\u0001\u0003M_:<\u0007\"B5\u0006\u0001\u00049\u0015aA:ue\")1.\u0002a\u0001e\u00051!p\u001c8f\u0013\u0012\f\u0011\u0002^3tiR\u0013XO\\2\u0015\u000b9\f8/^<\u0011\u0005uz\u0017B\u00019?\u0005\u0011)f.\u001b;\t\u000bI4\u0001\u0019\u0001\"\u0002\u000b1,g/\u001a7\t\u000bQ4\u0001\u0019A$\u0002\u0011\u0015D\b/Z2uK\u0012DQA\u001e\u0004A\u0002\u0015\fq!\u001b8qkR$6\u000bC\u0004l\rA\u0005\t\u0019\u0001\u001a\u0002'Q,7\u000f\u001e+sk:\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003iT#AM>,\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007q\u0014AC1o]>$\u0018\r^5p]&\u0019\u0011q\u0001@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007uKN$H+[7f\t&4g\rF\u0005o\u0003\u001b\t\t\"!\u0006\u0002\u001a!1\u0011q\u0002\u0005A\u0002\u001d\u000bA!\u001e8ji\"1\u00111\u0003\u0005A\u0002\u0015\fQa\u001d;beRDa!a\u0006\t\u0001\u0004)\u0017aA3oI\")A\u000f\u0003a\u0001K\u0002")
public class DateTimeUtilsSuite
extends SparkFunSuite
implements Matchers,
SQLHelper {
    private String sparkHome;
    private Matchers.KeyWord key;
    private Matchers.ValueWord value;
    private Matchers.AWord a;
    private Matchers.AnWord an;
    private Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private Matchers.RegexWord regex;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    private Explicitly.DecidedWord decided;
    private Explicitly.DeterminedWord determined;
    private Explicitly.TheAfterWord after;
    private FullyMatchWord fullyMatch;
    private StartWithWord startWith;
    private EndWithWord endWith;
    private IncludeWord include;
    private HaveWord have;
    private BeWord be;
    private ContainWord contain;
    private NotWord not;
    private LengthWord length;
    private SizeWord size;
    private SortedWord sorted;
    private DefinedWord defined;
    private ExistWord exist;
    private ReadableWord readable;
    private WritableWord writable;
    private EmptyWord empty;
    private CompileWord compile;
    private TypeCheckWord typeCheck;
    private MatchPatternWord matchPattern;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(Iterable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(Iterable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(Iterable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(Iterable<Object> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(Iterable<Object> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(Iterable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(Iterable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(Iterable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, Iterable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyMustWrapper<T> convertToAnyMustWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyMustWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringMustWrapper convertToStringMustWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringMustWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public MustVerb.StringMustWrapperForVerb convertToStringMustWrapperForVerb(String o, Position position) {
        return MustVerb.convertToStringMustWrapperForVerb$((MustVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    private String sparkHome$lzycompute() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected() {
        return this.org$scalatest$matchers$must$Matchers$$AllCollected;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected() {
        return this.org$scalatest$matchers$must$Matchers$$EveryCollected;
    }

    public Matchers$BetweenCollected$ org$scalatest$matchers$must$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$matchers$must$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$matchers$must$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected() {
        return this.org$scalatest$matchers$must$Matchers$$NoCollected;
    }

    public Matchers$ExactlyCollected$ org$scalatest$matchers$must$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper() {
        return this.org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$AllCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$AllCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$EveryCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$EveryCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$NoCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$NoCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$MustMethodHelper_$eq(Matchers.MustMethodHelperClass x$1) {
        this.org$scalatest$matchers$must$Matchers$$MustMethodHelper = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    private ZoneId defaultZoneId() {
        return ZoneId.systemDefault();
    }

    private Option<Object> toDate(String s) {
        return DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)s));
    }

    private Seq<String> permuteWithWhitespaceAndControl(Seq<String> values) {
        return (Seq)values.flatMap((Function1 & Serializable)input -> new .colon.colon(input, (List)new .colon.colon((Object)"\u0003", (List)new .colon.colon((Object)"\u0003", (List)new .colon.colon((Object)" ", (List)new .colon.colon((Object)" ", (List)Nil$.MODULE$))))).permutations().map((Function1 & Serializable)x$3 -> x$3.mkString()));
    }

    private Option<Object> toTimestamp(String str, ZoneId zoneId) {
        return DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)str), zoneId);
    }

    public void testTrunc(int level, String expected, long inputTS, ZoneId zoneId) {
        long truncated = DateTimeUtils$.MODULE$.truncTimestamp(inputTS, level, zoneId);
        Option<Object> expectedTS = this.toTimestamp(expected, this.defaultZoneId());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)truncated));
        long $org_scalatest_assert_macro_right = BoxesRunTime.unboxToLong((Object)expectedTS.get());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
    }

    public ZoneId testTrunc$default$4() {
        return this.defaultZoneId();
    }

    private void testTimeDiff(String unit, long start, long end, long expected) {
        UTF8String unitStr = UTF8String.fromString((String)unit);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeDiff(unitStr, start, end)));
        long $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1457));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeDiff(unitStr, end, start)));
        long $org_scalatest_assert_macro_right2 = -expected;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1458));
    }

    private final void org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void checkStringToTimestamp$1(String originalTime, String expectedParsedTime, TimestampFormatter tf$1) {
        Option parsedTimestampOp = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)originalTime), this.defaultZoneId());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(parsedTimestampOp.isDefined(), "parsedTimestampOp.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"timestamp with nanoseconds was not parsed correctly", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(tf$1.format(BoxesRunTime.unboxToLong((Object)parsedTimestampOp.get())));
        String $org_scalatest_assert_macro_right = expectedParsedTime;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    public static final /* synthetic */ Assertion $anonfun$new$3(DateTimeUtilsSuite $this, long t) {
        Timestamp ts = DateTimeUtils$.MODULE$.toJavaTimestamp(t);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(ts)));
        long $org_scalatest_assert_macro_right = t;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts)));
        Timestamp $org_scalatest_assert_macro_right2 = ts;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }

    private final void checkFromToJavaDate$1(Date d1) {
        Date d2 = DateTimeUtils$.MODULE$.toJavaDate(DateTimeUtils$.MODULE$.fromJavaDate(d1));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(d2.toString());
        String $org_scalatest_assert_macro_right = d1.toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
    }

    private final void checkStringToTimestamp$2(String str, Option expected, ZoneId zid$1) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toTimestamp(str, zid$1));
        Option $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
    }

    public static final /* synthetic */ void $anonfun$new$15(DateTimeUtilsSuite $this, ZoneId zid$1, String s) {
        int x$25 = 2015;
        int x$26 = 3;
        int x$27 = 18;
        ZoneId x$28 = zid$1;
        byte x$29 = DateTimeTestUtils$.MODULE$.date$default$4();
        byte x$30 = DateTimeTestUtils$.MODULE$.date$default$5();
        byte x$31 = DateTimeTestUtils$.MODULE$.date$default$6();
        int x$32 = DateTimeTestUtils$.MODULE$.date$default$7();
        $this.checkStringToTimestamp$2(s, Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, x$29, x$30, x$31, x$32, x$28))), zid$1);
    }

    public static final /* synthetic */ void $anonfun$new$14(DateTimeUtilsSuite $this, ZoneId zid) {
        int x$1 = 1969;
        int x$2 = 12;
        int x$3 = 31;
        int x$4 = 16;
        ZoneId x$5 = zid;
        byte x$6 = DateTimeTestUtils$.MODULE$.date$default$5();
        byte x$7 = DateTimeTestUtils$.MODULE$.date$default$6();
        int x$8 = DateTimeTestUtils$.MODULE$.date$default$7();
        $this.checkStringToTimestamp$2("1969-12-31 16:00:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1969, (byte)12, (byte)31, (byte)16, x$6, x$7, x$8, x$5))), zid);
        boolean x$9 = true;
        boolean x$10 = true;
        boolean x$11 = true;
        boolean x$12 = false;
        ZoneId x$13 = zid;
        byte x$14 = DateTimeTestUtils$.MODULE$.date$default$5();
        byte x$15 = DateTimeTestUtils$.MODULE$.date$default$6();
        int x$16 = DateTimeTestUtils$.MODULE$.date$default$7();
        $this.checkStringToTimestamp$2("0001", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, x$14, x$15, x$16, x$13))), zid);
        int x$17 = 2015;
        int x$18 = 3;
        boolean x$19 = true;
        ZoneId x$20 = zid;
        byte x$21 = DateTimeTestUtils$.MODULE$.date$default$4();
        byte x$22 = DateTimeTestUtils$.MODULE$.date$default$5();
        byte x$23 = DateTimeTestUtils$.MODULE$.date$default$6();
        int x$24 = DateTimeTestUtils$.MODULE$.date$default$7();
        $this.checkStringToTimestamp$2("2015-03", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)1, x$21, x$22, x$23, x$24, x$20))), zid);
        new .colon.colon((Object)"2015-03-18", (List)new .colon.colon((Object)"2015-03-18 ", (List)new .colon.colon((Object)" 2015-03-18", (List)new .colon.colon((Object)" 2015-03-18 ", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)s -> {
            DateTimeUtilsSuite.$anonfun$new$15($this, zid, s);
            return BoxedUnit.UNIT;
        });
        int x$33 = 2015;
        int x$34 = 3;
        int x$35 = 18;
        int x$36 = 12;
        int x$37 = 3;
        int x$38 = 17;
        ZoneId x$39 = zid;
        int x$40 = DateTimeTestUtils$.MODULE$.date$default$7();
        ObjectRef expected = ObjectRef.create((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$40, x$39))));
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17", (Option)expected.elem, zid);
        ZoneId zoneId = DateTimeUtils$.MODULE$.getZoneId("-13:53");
        int x$41 = 2015;
        int x$42 = 3;
        int x$43 = 18;
        int x$44 = 12;
        int x$45 = 3;
        int x$46 = 17;
        ZoneId x$47 = zoneId;
        int x$48 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$48, x$47)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-13:53", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17GMT-13:53", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-1353", (Option)expected.elem, zid);
        int x$49 = 2015;
        int x$50 = 3;
        int x$51 = 18;
        int x$52 = 12;
        int x$53 = 3;
        int x$54 = 17;
        ZoneId x$55 = DateTimeTestUtils$.MODULE$.UTC();
        int x$56 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$56, x$55)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17Z", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17Z", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17UTC", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("-01:00");
        int x$57 = 2015;
        int x$58 = 3;
        int x$59 = 18;
        int x$60 = 12;
        int x$61 = 3;
        int x$62 = 17;
        ZoneId x$63 = zoneId;
        int x$64 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$64, x$63)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-1:0", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-01:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17GMT-01:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-0100", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        int x$65 = 2015;
        int x$66 = 3;
        int x$67 = 18;
        int x$68 = 12;
        int x$69 = 3;
        int x$70 = 17;
        ZoneId x$71 = zoneId;
        int x$72 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$72, x$71)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17 GMT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17+0730", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:03");
        int x$73 = 2015;
        int x$74 = 3;
        int x$75 = 18;
        int x$76 = 12;
        int x$77 = 3;
        int x$78 = 17;
        ZoneId x$79 = zoneId;
        int x$80 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$80, x$79)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17+07:03", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17GMT+07:03", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17+0703", (Option)expected.elem, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123000, zid)));
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17.123", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123", (Option)expected.elem, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 456000, DateTimeTestUtils$.MODULE$.UTC())));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.456Z", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17.456Z", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17.456 UTC", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("-01:00");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123000, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123-1:0", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123-01:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123 GMT-01:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123-0100", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123000, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123 GMT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+0730", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123000, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123GMT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+0730", (Option)expected.elem, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123121, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123121+7:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123121 GMT+0730", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123120, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.12312+7:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.12312 UT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.12312+0730", (Option)expected.elem, zid);
        int x$81 = 18;
        int x$82 = 12;
        int x$83 = 15;
        ZoneId x$84 = zid;
        int x$85 = DateTimeTestUtils$.MODULE$.time$default$4();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.time((byte)18, (byte)12, (byte)15, x$85, x$84)));
        $this.checkStringToTimestamp$2("18:12:15", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.time((byte)18, (byte)12, (byte)15, 123120, zoneId)));
        $this.checkStringToTimestamp$2("T18:12:15.12312+7:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("T18:12:15.12312 UTC+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("T18:12:15.12312+0730", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.time((byte)18, (byte)12, (byte)15, 123120, zoneId)));
        $this.checkStringToTimestamp$2("18:12:15.12312+7:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("18:12:15.12312 GMT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("18:12:15.12312+0730", (Option)expected.elem, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2011, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, 100000, zid)));
        $this.checkStringToTimestamp$2("2011-05-06 07:08:09.1000", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("238", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18 123142", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T123123", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18X", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015/03/18", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015.03.18", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("20150318", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-031-8", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("015-01-18", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03.17-20:0", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03.17-0:70", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03.17-1:0:0", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("1999 08 01", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("1999-08 01", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("1999 08", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("    ", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("+", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("T", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("12::", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-8:", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-8:30:", (Option)None$.MODULE$, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123456, DateTimeTestUtils$.MODULE$.UTC())));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456789+0:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456789 UTC+0", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456789GMT+00:00", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("Europe/Moscow");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123456, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456 Europe/Moscow", (Option)expected.elem, zid);
        int x$86 = 2015;
        int x$87 = 3;
        int x$88 = 18;
        int x$89 = 12;
        int x$90 = 3;
        int x$91 = 17;
        ZoneId x$92 = zid;
        int x$93 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$93, x$92)));
        $this.permuteWithWhitespaceAndControl((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2015-03-18 12:03:17", "2015-03-18T12:03:17"})).foreach((Function1 & Serializable)s -> {
            $this.checkStringToTimestamp$2(s, (Option)expected.elem, zid);
            return BoxedUnit.UNIT;
        });
        $this.permuteWithWhitespaceAndControl((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INVALID_INPUT", "\t", "", "2015-03-18\u000312:03:17", "2015-03-18 12:", "2015-03-18 123"})).foreach((Function1 & Serializable)s -> {
            $this.checkStringToTimestamp$2(s, (Option)None$.MODULE$, zid);
            return BoxedUnit.UNIT;
        });
    }

    private final void checkStringToTimestamp$3(String str, Option expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toTimestamp(str, DateTimeTestUtils$.MODULE$.UTC()));
        Option $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
    }

    public static final /* synthetic */ Assertion $anonfun$new$28(DateTimeUtilsSuite $this, int year) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(DateTimeTestUtils$.MODULE$.days(year, DateTimeTestUtils$.MODULE$.days$default$2(), DateTimeTestUtils$.MODULE$.days$default$3()))));
        int $org_scalatest_assert_macro_right = year;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(DateTimeTestUtils$.MODULE$.days(year, (byte)1, DateTimeTestUtils$.MODULE$.days$default$3()))));
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(DateTimeTestUtils$.MODULE$.days(year, (byte)1, (byte)1))));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        int date = DateTimeTestUtils$.MODULE$.days(year, (byte)12, (byte)31);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(date)));
        int $org_scalatest_assert_macro_right4 = year;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(date)));
        int $org_scalatest_assert_macro_right5 = 12;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(date)));
        int $org_scalatest_assert_macro_right6 = 31;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
    }

    public static final /* synthetic */ void $anonfun$new$35(DateTimeUtilsSuite $this, ZoneId zid) {
        new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)13, (byte)21, (byte)28, (byte)13, 123456, zid)), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)13, (byte)21, (byte)28, (byte)13, 123456, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)31, (byte)0, (byte)0, (byte)0, 123, zid)), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)2, (byte)28, (byte)0, (byte)0, (byte)0, 123, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2020, (byte)2, (byte)29, (byte)1, (byte)2, (byte)3, 4, zid)), (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)2, (byte)28, (byte)1, (byte)2, (byte)3, 4, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, zid)), (Object)BoxesRunTime.boxToInteger((int)24240), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1581, (byte)10, (byte)7, (byte)23, (byte)59, (byte)59, 999, zid)), (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1582, (byte)10, (byte)7, (byte)23, (byte)59, (byte)59, 999, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(9999, (byte)12, (byte)31, (byte)23, (byte)59, (byte)59, 999999, zid)), (Object)BoxesRunTime.boxToInteger((int)-11), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)31, (byte)23, (byte)59, (byte)59, 999999, zid))), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                long timestamp = BoxesRunTime.unboxToLong((Object)tuple3._1());
                int months = BoxesRunTime.unboxToInt((Object)tuple3._2());
                long expected = BoxesRunTime.unboxToLong((Object)tuple3._3());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddMonths(timestamp, months, zid)));
                long $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$42(DateTimeUtilsSuite $this, LongRef date2$1, long date1$1, boolean roundOff) {
        date2$1.elem = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)28, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1$1, date2$1.elem, roundOff, DateTimeTestUtils$.MODULE$.UTC())));
        int $org_scalatest_assert_macro_right = -36;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
        date2$1.elem = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)29, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1$1, date2$1.elem, roundOff, DateTimeTestUtils$.MODULE$.UTC())));
        int $org_scalatest_assert_macro_right2 = -36;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        date2$1.elem = DateTimeTestUtils$.MODULE$.date(1996, (byte)3, (byte)31, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1$1, date2$1.elem, roundOff, DateTimeTestUtils$.MODULE$.UTC())));
        int $org_scalatest_assert_macro_right3 = 11;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
    }

    private final void test$1(String utc, String tz, String expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(utc)), tz)).toString());
        String $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
    }

    private final void test$2(String utc, String tz, String expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.toUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(utc)), tz)).toString());
        String $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
    }

    public static final /* synthetic */ Object $anonfun$new$71(DateTimeUtilsSuite $this, Set skipped$1, ZoneId zid$5, int d) {
        if (!skipped$1.contains((Object)BoxesRunTime.boxToInteger((int)d))) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToDays(DateTimeUtils$.MODULE$.daysToMicros(d, zid$5), zid$5)));
            int $org_scalatest_assert_macro_right = d;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Round trip of " + d + " did not work in tz " + zid$5.getId()), Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$68(DateTimeUtilsSuite $this, scala.collection.immutable.Map skipped_days$1, ZoneId zid) {
        Set skipped = (Set)skipped_days$1.getOrElse((Object)zid.getId(), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        Seq testingData = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-20000, 20000})).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).map((Function1)(JFunction1.mcII.sp & Serializable)x$4 -> (int)(package$.MODULE$.random() * (double)40000 - (double)20000)));
        testingData.foreach((Function1 & Serializable)d -> DateTimeUtilsSuite.$anonfun$new$71($this, skipped, zid, BoxesRunTime.unboxToInt((Object)d)));
    }

    public static final /* synthetic */ void $anonfun$new$85(DateTimeUtilsSuite $this, ZoneId zid) {
        scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1000, 2, 28, 1, 2, 3, 456789000), (Object)LocalDateTime.of(1000, 3, 1, 1, 2, 3, 456789000))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.DAYS.toMicros(1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1582, 10, 4, 23, 59, 59, 999999000), (Object)LocalDateTime.of(1582, 10, 15, 23, 59, 59, 999999000))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.DAYS.toMicros(11L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1883, 11, 20, 0, 0, 0, 123456000), (Object)LocalDateTime.of(1883, 11, 10, 0, 0, 0))), (Object)BoxesRunTime.boxToLong((long)(TimeUnit.DAYS.toMicros(-10L) - 123456L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1900, 1, 1, 0, 0, 0, 1000), (Object)LocalDateTime.of(1899, 12, 31, 23, 59, 59, 999999000))), (Object)BoxesRunTime.boxToInteger((int)-2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1945, 11, 18, 0, 30, 30), (Object)LocalDateTime.of(1945, 11, 18, 1, 30, 30))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.HOURS.toMicros(1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1945, 11, 18, 2, 0, 0), (Object)LocalDateTime.of(1945, 11, 18, 1, 0, 0))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.HOURS.toMicros(-1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1970, 1, 1, 0, 0, 0), (Object)LocalDateTime.of(1970, 1, 1, 0, 0, 0))), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(2020, 2, 29, 0, 0, 0), (Object)LocalDateTime.of(2021, 3, 1, 0, 0, 0))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.DAYS.toMicros(366L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(2021, 3, 14, 1, 0, 0), (Object)LocalDateTime.of(2021, 3, 14, 3, 0, 0))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.HOURS.toMicros(2L)))})).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Object expected = tuple2._2();
                if (tuple22 != null) {
                    LocalDateTime start = (LocalDateTime)tuple22._1();
                    LocalDateTime end = (LocalDateTime)tuple22._2();
                    long startMicros = DateTimeTestUtils$.MODULE$.localDateTimeToMicros(start, zid);
                    long endMicros = DateTimeTestUtils$.MODULE$.localDateTimeToMicros(end, zid);
                    long result = DateTimeUtils$.MODULE$.subtractTimestamps(endMicros, startMicros, zid);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)result));
                    Object $org_scalatest_assert_macro_right = expected;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1018));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$97(DateTimeUtilsSuite $this, long invalidNanos) {
        String msg;
        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0 & Serializable)() -> DateTimeUtils$.MODULE$.nanosToLocalTime(invalidNanos), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1162))).getMessage();
        String $org_scalatest_assert_macro_right = "Invalid value";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1165));
    }

    private final void checkStringToTime$1(String str, Option expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime(UTF8String.fromString((String)str)));
        Option $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1175));
    }

    public static final /* synthetic */ void $anonfun$new$105(DateTimeUtilsSuite $this, String invalidTime) {
        SparkDateTimeException x$226 = (SparkDateTimeException)$this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.stringToTimeAnsi(UTF8String.fromString((String)invalidTime), DateTimeUtils$.MODULE$.stringToTimeAnsi$default$2()), ClassTag$.MODULE$.apply(SparkDateTimeException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1294));
        String x$227 = "CAST_INVALID_INPUT";
        scala.collection.immutable.Map x$228 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)("'" + invalidTime + "'")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"TIME(6)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)"\"spark.sql.ansi.enabled\"")}));
        Option x$229 = $this.checkError$default$3();
        boolean x$230 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$231 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$226, "CAST_INVALID_INPUT", x$229, x$228, x$230, x$231);
    }

    public static final /* synthetic */ void $anonfun$new$124(DateTimeUtilsSuite $this, long zero$1, long nano$1, long maxTime$1, String unit) {
        $this.testTimeDiff(unit, zero$1, zero$1, 0L);
        $this.testTimeDiff(unit, zero$1, nano$1, 0L);
        $this.testTimeDiff(unit, zero$1, nano$1 * 999L, 0L);
        $this.testTimeDiff(unit, nano$1, nano$1, 0L);
        $this.testTimeDiff(unit, nano$1, nano$1 * 999L, 0L);
        $this.testTimeDiff(unit, maxTime$1, maxTime$1, 0L);
        $this.testTimeDiff(unit, maxTime$1, maxTime$1 - 999L, 0L);
    }

    public DateTimeUtilsSuite() {
        Tolerance.$init$((Tolerance)this);
        MustVerb.$init$((MustVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("nanoseconds truncation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TimestampFormatter tf = TimestampFormatter$.MODULE$.getFractionFormatter(ZoneId.systemDefault());
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.123456789", "2015-01-02 00:00:00.123456", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.100000009", "2015-01-02 00:00:00.1", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.000050000", "2015-01-02 00:00:00.00005", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.12005", "2015-01-02 00:00:00.12005", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.100", "2015-01-02 00:00:00.1", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.000456789", "2015-01-02 00:00:00.000456", tf);
            this.checkStringToTimestamp$1("1950-01-02 00:00:00.000456789", "1950-01-02 00:00:00.000456", tf);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("timestamp and us", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            now.setNanos(1000);
            long ns = DateTimeUtils$.MODULE$.fromJavaTimestamp(now);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)(ns % 1000000L)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(ns));
            Timestamp $org_scalatest_assert_macro_right2 = now;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            ((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-111111111111L, -1L, 0L, 1L, 111111111111L}))).foreach((Function1 & Serializable)t -> DateTimeUtilsSuite.$anonfun$new$3(this, BoxesRunTime.unboxToLong((Object)t)));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("us and julian day", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(0L));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int d = tuple2._1$mcI$sp();
            long ns = tuple2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(d, ns);
            int d2 = sp2._1$mcI$sp();
            long ns2 = sp2._2$mcJ$sp();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)d2));
            int $org_scalatest_assert_macro_right = 2440588;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)ns2));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            long $org_scalatest_assert_macro_left3 = RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(DateTimeUtils$.MODULE$.fromJulianDay(d2, ns2));
            long $org_scalatest_assert_macro_right3 = 0L;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            new .colon.colon((Object)Timestamp.valueOf("2015-06-11 10:10:10.100"), (List)new .colon.colon((Object)Timestamp.valueOf("2015-06-11 20:10:10.100"), (List)new .colon.colon((Object)Timestamp.valueOf("1900-06-11 20:10:10.100"), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)t -> {
                long ns;
                Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(DateTimeUtils$.MODULE$.fromJavaTimestamp(t)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int d = tuple2._1$mcI$sp();
                long ns2 = tuple2._2$mcJ$sp();
                Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(d, ns2);
                int d2 = sp2._1$mcI$sp();
                long $org_scalatest_assert_macro_left = ns = sp2._2$mcJ$sp();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
                Timestamp t1 = DateTimeUtils$.MODULE$.toJavaTimestamp(RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(DateTimeUtils$.MODULE$.fromJulianDay(d2, ns)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(t.equals(t1), "t.equals(t1)", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("SPARK-6785: java date conversion before and after epoch", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
            this.checkFromToJavaDate$1(new Date(100L));
            this.checkFromToJavaDate$1(Date.valueOf("1970-01-01"));
            this.checkFromToJavaDate$1(new Date(df1.parse("1970-01-01 00:00:00").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1970-01-01 00:00:00 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1970-01-01 00:00:01").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1970-01-01 00:00:01 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1969-12-31 23:59:59").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1969-12-31 23:59:59 UTC").getTime()));
            this.checkFromToJavaDate$1(Date.valueOf("1969-01-01"));
            this.checkFromToJavaDate$1(new Date(df1.parse("1969-01-01 00:00:00").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1969-01-01 00:00:00 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1969-01-01 00:00:01").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1969-01-01 00:00:01 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1989-11-09 11:59:59").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1989-11-09 19:59:59 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1776-07-04 10:30:00").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1776-07-04 18:30:00 UTC").getTime()));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("SPARK-32559: string to date trim Control Characters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int expected = DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18);
            this.permuteWithWhitespaceAndControl((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2015-03-18", "2015-03-18T123321", " 2015-03-18 123321", "+2015-03-18"})).foreach((Function1 & Serializable)s -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toDate((String)s).get());
                int $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            });
            this.permuteWithWhitespaceAndControl((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INVALID_INPUT", " ", "1999-08-", "2015-03-18\u0003123321", "2015-03-18Q123321"})).foreach((Function1 & Serializable)s -> {
                Option<Object> $org_scalatest_assert_macro_left = this.toDate((String)s);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("string to date", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toDate("2015-01-28").get());
            int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2015, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.toDate("2015").get());
            int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(2015, (byte)1, (byte)1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.toDate("0001").get());
            int $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.days(1, (byte)1, (byte)1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.toDate("2015-03").get());
            int $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            new .colon.colon((Object)"2015-03-18", (List)new .colon.colon((Object)"2015-03-18 ", (List)new .colon.colon((Object)" 2015-03-18", (List)new .colon.colon((Object)" 2015-03-18 ", (List)new .colon.colon((Object)"2015-03-18 123142", (List)new .colon.colon((Object)"2015-03-18T123123", (List)new .colon.colon((Object)"2015-03-18T", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)s -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toDate((String)s).get());
                int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            });
            Option<Object> $org_scalatest_assert_macro_left5 = this.toDate("2015-03-18X");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            Option<Object> $org_scalatest_assert_macro_left6 = this.toDate("2015/03/18");
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            Option<Object> $org_scalatest_assert_macro_left7 = this.toDate("2015.03.18");
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            Option<Object> $org_scalatest_assert_macro_left8 = this.toDate("20150318");
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            Option<Object> $org_scalatest_assert_macro_left9 = this.toDate("2015-031-8");
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            Option<Object> $org_scalatest_assert_macro_left10 = this.toDate("015-03-18");
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            Option<Object> $org_scalatest_assert_macro_left11 = this.toDate("015");
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Option<Object> $org_scalatest_assert_macro_left12 = this.toDate("1999 08 01");
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            Option<Object> $org_scalatest_assert_macro_left13 = this.toDate("1999-08 01");
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left13, "isEmpty", $org_scalatest_assert_macro_left13.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            Option<Object> $org_scalatest_assert_macro_left14 = this.toDate("1999 08");
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left14, "isEmpty", $org_scalatest_assert_macro_left14.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            Option<Object> $org_scalatest_assert_macro_left15 = this.toDate("1999-08-");
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left15, "isEmpty", $org_scalatest_assert_macro_left15.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            Option<Object> $org_scalatest_assert_macro_left16 = this.toDate("");
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left16, "isEmpty", $org_scalatest_assert_macro_left16.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Option<Object> $org_scalatest_assert_macro_left17 = this.toDate("   ");
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left17, "isEmpty", $org_scalatest_assert_macro_left17.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            Option<Object> $org_scalatest_assert_macro_left18 = this.toDate("+");
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left18, "isEmpty", $org_scalatest_assert_macro_left18.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            Option<Object> $org_scalatest_assert_macro_left19 = this.toDate("-");
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left19, "isEmpty", $org_scalatest_assert_macro_left19.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            Option<Object> $org_scalatest_assert_macro_left20 = this.toDate("xxx2015-01-28");
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left20, "isEmpty", $org_scalatest_assert_macro_left20.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Option<Object> $org_scalatest_assert_macro_left21 = this.toDate("--2015-01-28");
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left21, "isEmpty", $org_scalatest_assert_macro_left21.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("SPARK-35780: support full range of date string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toDate("02015-03-18").get());
            int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.toDate("02015").get());
            int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(2015, (byte)1, (byte)1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.toDate("-02015").get());
            int $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.days(-2015, (byte)1, (byte)1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.toDate("999999-1-28").get());
            int $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.days(999999, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(this.toDate("-999999-1-28").get());
            int $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.days(-999999, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(this.toDate("0001-1-28").get());
            int $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.days(1, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.toDate("5881580-7-11").get());
            int $org_scalatest_assert_macro_right7 = DateTimeTestUtils$.MODULE$.days(5881580, (byte)7, (byte)11);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            Option<Object> $org_scalatest_assert_macro_left8 = this.toDate("5881580-7-12");
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(this.toDate("-5877641-6-23").get());
            int $org_scalatest_assert_macro_right8 = DateTimeTestUtils$.MODULE$.days(-5877641, (byte)6, (byte)23);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            Option<Object> $org_scalatest_assert_macro_left10 = this.toDate("-5877641-6-22");
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            Option<Object> $org_scalatest_assert_macro_left11 = this.toDate("4294967297");
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            Option<Object> $org_scalatest_assert_macro_left12 = this.toDate("2021-4294967297-11");
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("string to timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
            DateTimeUtilsSuite.$anonfun$new$14(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("SPARK-35780: support full range of timestamp string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$94 = -1969;
            int x$95 = 12;
            int x$96 = 31;
            int x$97 = 16;
            ZoneId x$98 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$99 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$100 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$101 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("-1969-12-31 16:00:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(-1969, (byte)12, (byte)31, (byte)16, x$99, x$100, x$101, x$98))));
            int x$102 = 2015;
            int x$103 = 3;
            int x$104 = 18;
            int x$105 = 16;
            ZoneId x$106 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$107 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$108 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$109 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("02015-03-18 16:00:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)16, x$107, x$108, x$109, x$106))));
            boolean x$110 = true;
            boolean x$111 = true;
            boolean x$112 = true;
            boolean x$113 = false;
            ZoneId x$114 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$115 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$116 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$117 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("000001", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, x$115, x$116, x$117, x$114))));
            int x$118 = -1;
            boolean x$119 = true;
            boolean x$120 = true;
            boolean x$121 = false;
            ZoneId x$122 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$123 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$124 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$125 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("-000001", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(-1, (byte)1, (byte)1, (byte)0, x$123, x$124, x$125, x$122))));
            int x$126 = 238;
            boolean x$127 = true;
            boolean x$128 = true;
            boolean x$129 = false;
            ZoneId x$130 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$131 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$132 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$133 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("00238", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(238, (byte)1, (byte)1, (byte)0, x$131, x$132, x$133, x$130))));
            int x$134 = 99999;
            int x$135 = 3;
            boolean x$136 = true;
            int x$137 = 12;
            int x$138 = 3;
            int x$139 = 17;
            ZoneId x$140 = DateTimeTestUtils$.MODULE$.UTC();
            int x$141 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("99999-03-01T12:03:17", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(99999, (byte)3, (byte)1, (byte)12, (byte)3, (byte)17, x$141, x$140))));
            this.checkStringToTimestamp$3("+12:12:12", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("-12:12:12", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("    ", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("+", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("294247-01-10T04:00:54.775807Z", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(294247, (byte)1, (byte)10, (byte)4, (byte)0, (byte)54, 775807, DateTimeTestUtils$.MODULE$.UTC()))));
            this.checkStringToTimestamp$3("294247-01-10T04:00:54.775808Z", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("-290308-12-21T19:59:05.224192Z", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(-290308, (byte)12, (byte)21, (byte)19, (byte)59, (byte)5, 224192, DateTimeTestUtils$.MODULE$.UTC()))));
            this.checkStringToTimestamp$3("-290308-12-21T19:59:05.224191Z", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("4294967297", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-4294967297-11", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("4294967297:30:00", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-11-4294967297T12:30:00", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:4294967297:00", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297.123456", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297+07:30", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297UTC", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297+4294967297:30", (Option)None$.MODULE$);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        this.test("SPARK-37326: stringToTimestampWithoutTimeZone with allowTimeZone", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(UTF8String.fromString((String)"2021-11-22 10:54:27 +08:00"), true);
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.of(2021, 11, 22, 10, 54, 27))));
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            Option $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(UTF8String.fromString((String)"2021-11-22 10:54:27 +08:00"), false);
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Option option2 = $org_scalatest_assert_macro_left2;
            None$ none$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.test("SPARK-15379: special invalid date string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option<Object> $org_scalatest_assert_macro_left = this.toDate("2015-02-29 00:00:00");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
            Option<Object> $org_scalatest_assert_macro_left2 = this.toDate("2015-04-31 00:00:00");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
            Option<Object> $org_scalatest_assert_macro_left3 = this.toDate("2015-02-29");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            Option<Object> $org_scalatest_assert_macro_left4 = this.toDate("2015-04-31");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            Option $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-02-29 00:00:00"), this.defaultZoneId());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
            Option $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-31 00:00:00"), this.defaultZoneId());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
            Option<Object> $org_scalatest_assert_macro_left7 = this.toTimestamp("2015-02-29", this.defaultZoneId());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
            Option<Object> $org_scalatest_assert_macro_left8 = this.toTimestamp("2015-04-31", this.defaultZoneId());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        this.test("hours", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)13, (byte)2, (byte)11, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right = 13;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right2 = 20;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            input = DateTimeTestUtils$.MODULE$.date(2015, (byte)12, (byte)8, (byte)2, (byte)7, (byte)9, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right4 = 10;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
            input = DateTimeTestUtils$.MODULE$.date(10, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        this.test("minutes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)13, (byte)2, (byte)11, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeUtils$.MODULE$.getZoneId("Australia/North"))));
            int $org_scalatest_assert_macro_right3 = 32;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
            input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)8, (byte)2, (byte)7, (byte)9, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right4 = 7;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right5 = 7;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeUtils$.MODULE$.getZoneId("Australia/North"))));
            int $org_scalatest_assert_macro_right6 = 37;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            input = DateTimeTestUtils$.MODULE$.date(10, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        this.test("seconds", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)13, (byte)2, (byte)11, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right = 11;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right2 = 11;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
            input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)8, (byte)2, (byte)7, (byte)9, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right3 = 9;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right4 = 9;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
            input = DateTimeTestUtils$.MODULE$.date(10, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        this.test("hours / minutes / seconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Timestamp.valueOf("2015-06-11 10:12:35.789"), (List)new .colon.colon((Object)Timestamp.valueOf("2015-06-11 20:13:40.789"), (List)new .colon.colon((Object)Timestamp.valueOf("1900-06-11 12:14:50.789"), (List)new .colon.colon((Object)Timestamp.valueOf("1700-02-28 12:14:50.123456"), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)t -> {
            long us = DateTimeUtils$.MODULE$.fromJavaTimestamp(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(us));
            Timestamp $org_scalatest_assert_macro_right = t;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
        this.test("get day in year", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18))));
            int $org_scalatest_assert_macro_right = 77;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(DateTimeTestUtils$.MODULE$.days(2012, (byte)3, (byte)18))));
            int $org_scalatest_assert_macro_right2 = 78;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        this.test("day of year calculations for old years", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(DateTimeTestUtils$.MODULE$.days(1582, (byte)3, DateTimeTestUtils$.MODULE$.days$default$3()))));
            int $org_scalatest_assert_macro_right = 60;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1000), 1600).by(10).foreach((Function1 & Serializable)year -> DateTimeUtilsSuite.$anonfun$new$28(this, BoxesRunTime.unboxToInt((Object)year)));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        this.test("get year", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(DateTimeTestUtils$.MODULE$.days(2015, (byte)2, (byte)18))));
            int $org_scalatest_assert_macro_right = 2015;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(DateTimeTestUtils$.MODULE$.days(2012, (byte)2, (byte)18))));
            int $org_scalatest_assert_macro_right2 = 2012;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
        this.test("get quarter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getQuarter(DateTimeTestUtils$.MODULE$.days(2015, (byte)2, (byte)18))));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getQuarter(DateTimeTestUtils$.MODULE$.days(2012, (byte)11, (byte)18))));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        this.test("get month", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18))));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(DateTimeTestUtils$.MODULE$.days(2012, (byte)12, (byte)18))));
            int $org_scalatest_assert_macro_right2 = 12;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
        this.test("get day of month", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18))));
            int $org_scalatest_assert_macro_right = 18;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(DateTimeTestUtils$.MODULE$.days(2012, (byte)12, (byte)24))));
            int $org_scalatest_assert_macro_right2 = 24;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        this.test("date add months", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int input = DateTimeTestUtils$.MODULE$.days(1997, (byte)2, (byte)28);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(input, 36)));
            int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2000, (byte)2, (byte)28);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(input, -13)));
            int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(1996, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        this.test("SPARK-34739: timestamp add months", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            DateTimeUtilsSuite.$anonfun$new$35(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
        this.test("date add interval with day precision", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int input = DateTimeTestUtils$.MODULE$.days(1997, (byte)2, (byte)28);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddInterval(input, new CalendarInterval(36, 0, 0L))));
            int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2000, (byte)2, (byte)28);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddInterval(input, new CalendarInterval(36, 47, 0L))));
            int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(2000, (byte)4, (byte)15);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddInterval(input, new CalendarInterval(-13, 0, 0L))));
            int $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.days(1996, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
            this.checkError((SparkThrowable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> DateTimeUtils$.MODULE$.dateAddInterval(input, new CalendarInterval(36, 47, 1L)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547)), "INVALID_INTERVAL_WITH_MICROSECONDS_ADDITION", this.checkError$default$3(), this.checkError$default$4(), this.checkError$default$5(), this.checkError$default$6());
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
        this.test("timestamp add interval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long ts1 = DateTimeTestUtils$.MODULE$.date(1997, (byte)2, (byte)28, (byte)10, (byte)30, (byte)0, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            long ts2 = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)28, (byte)10, (byte)30, (byte)0, 123000, DateTimeTestUtils$.MODULE$.date$default$8());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts1, 36, 0, 123000L, this.defaultZoneId())));
            long $org_scalatest_assert_macro_right = ts2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
            long ts3 = DateTimeTestUtils$.MODULE$.date(1997, (byte)2, (byte)27, (byte)16, (byte)0, (byte)0, 0, DateTimeTestUtils$.MODULE$.LA());
            long ts4 = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)27, (byte)16, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts5 = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)28, (byte)0, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.UTC());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 36, 0, 123000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right2 = ts4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 36, 0, 123000L, DateTimeTestUtils$.MODULE$.UTC())));
            long $org_scalatest_assert_macro_right3 = ts5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
        this.test("timestamp add days", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long ts1 = DateTimeTestUtils$.MODULE$.date(2019, (byte)3, (byte)9, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts2 = DateTimeTestUtils$.MODULE$.date(2019, (byte)3, (byte)10, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts3 = DateTimeTestUtils$.MODULE$.date(2019, (byte)5, (byte)9, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts4 = DateTimeTestUtils$.MODULE$.date(2019, (byte)5, (byte)10, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts5 = DateTimeTestUtils$.MODULE$.date(2019, (byte)11, (byte)2, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts6 = DateTimeTestUtils$.MODULE$.date(2019, (byte)11, (byte)3, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts1, 0, 0, 82800000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right = ts2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts1, 0, 1, 0L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right2 = ts2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 0, 0, 86400000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right3 = ts4;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 0, 1, 0L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right4 = ts4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts5, 0, 0, 90000000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right5 = ts6;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts5, 0, 1, 0L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right6 = ts6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        this.test("monthsBetween", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long date1 = DateTimeTestUtils$.MODULE$.date(1997, (byte)2, (byte)28, (byte)10, (byte)30, (byte)0, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            LongRef date2 = LongRef.create((long)DateTimeTestUtils$.MODULE$.date(1996, (byte)10, (byte)30, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1, date2.elem, true, DateTimeTestUtils$.MODULE$.UTC())));
            double $org_scalatest_assert_macro_right = 3.94959677;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1, date2.elem, false, DateTimeTestUtils$.MODULE$.UTC())));
            double $org_scalatest_assert_macro_right2 = 3.9495967741935485;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)roundOff -> DateTimeUtilsSuite.$anonfun$new$42(this, date2, date1, BoxesRunTime.unboxToBoolean((Object)roundOff)));
            int x$142 = 2000;
            int x$143 = 2;
            int x$144 = 28;
            int x$145 = 16;
            ZoneId x$146 = DateTimeTestUtils$.MODULE$.LA();
            byte x$147 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$148 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$149 = DateTimeTestUtils$.MODULE$.date$default$7();
            long date3 = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)28, (byte)16, x$147, x$148, x$149, x$146);
            int x$150 = 1997;
            int x$151 = 2;
            int x$152 = 28;
            int x$153 = 16;
            ZoneId x$154 = DateTimeTestUtils$.MODULE$.LA();
            byte x$155 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$156 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$157 = DateTimeTestUtils$.MODULE$.date$default$7();
            long date4 = DateTimeTestUtils$.MODULE$.date(1997, (byte)2, (byte)28, (byte)16, x$155, x$156, x$157, x$154);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date3, date4, true, DateTimeTestUtils$.MODULE$.LA())));
            double $org_scalatest_assert_macro_right3 = 36.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date3, date4, true, DateTimeTestUtils$.MODULE$.UTC())));
            double $org_scalatest_assert_macro_right4 = 35.90322581;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date3, date4, false, DateTimeTestUtils$.MODULE$.UTC())));
            double $org_scalatest_assert_macro_right5 = 35.903225806451616;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
        this.test("from UTC timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)tz -> {
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(tz, (JFunction0.mcV.sp & Serializable)() -> {
                    $this.test$1("2011-12-25 09:00:00.123456", "UTC", "2011-12-25 09:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", DateTimeTestUtils$.MODULE$.JST().getId(), "2011-12-25 18:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", DateTimeTestUtils$.MODULE$.LA().getId(), "2011-12-25 01:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "Asia/Shanghai", "2011-12-25 17:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "-7", "2011-12-25 02:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "+8:00", "2011-12-25 17:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "+8:00:00", "2011-12-25 17:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "+0800", "2011-12-25 17:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "-071020", "2011-12-25 01:49:40.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "-07:10:20", "2011-12-25 01:49:40.123456");
                });
                return BoxedUnit.UNIT;
            });
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (JFunction0.mcV.sp & Serializable)() -> {
                this.test$1("2016-03-13 09:59:59.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-03-13 01:59:59.0");
                this.test$1("2016-03-13 10:00:00.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-03-13 03:00:00.0");
                this.test$1("2016-11-06 08:59:59.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-11-06 01:59:59.0");
                this.test$1("2016-11-06 09:00:00.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-11-06 01:00:00.0");
                this.test$1("2016-11-06 10:00:00.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-11-06 02:00:00.0");
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
        this.test("to UTC timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zid, (JFunction0.mcV.sp & Serializable)() -> {
                    $this.test$2("2011-12-25 09:00:00.123456", "UTC", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 18:00:00.123456", DateTimeTestUtils$.MODULE$.JST().getId(), "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 01:00:00.123456", DateTimeTestUtils$.MODULE$.LA().getId(), "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 17:00:00.123456", "Asia/Shanghai", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 02:00:00.123456", "-7", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 17:00:00.123456", "+8:00", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 17:00:00.123456", "+8:00:00", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 17:00:00.123456", "+0800", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 01:49:40.123456", "-071020", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 01:49:40.123456", "-07:10:20", "2011-12-25 09:00:00.123456");
                });
                return BoxedUnit.UNIT;
            });
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (JFunction0.mcV.sp & Serializable)() -> {
                String tz = DateTimeTestUtils$.MODULE$.LA().getId();
                this.test$2("2016-03-13 01:59:59", tz, "2016-03-13 09:59:59.0");
                this.test$2("2016-03-13 02:00:00", tz, "2016-03-13 10:00:00.0");
                this.test$2("2016-03-13 03:00:00", tz, "2016-03-13 10:00:00.0");
                this.test$2("2016-11-06 00:59:59", tz, "2016-11-06 07:59:59.0");
                this.test$2("2016-11-06 01:00:00", tz, "2016-11-06 09:00:00.0");
                this.test$2("2016-11-06 01:59:59", tz, "2016-11-06 09:59:59.0");
                this.test$2("2016-11-06 02:00:00", tz, "2016-11-06 10:00:00.0");
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
        this.test("trailing characters while converting string to timestamp", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option time;
            UTF8String s = UTF8String.fromString((String)"2019-10-31T10:59:23Z:::");
            Option $org_scalatest_assert_macro_left = time = DateTimeUtils$.MODULE$.stringToTimestamp(s, this.defaultZoneId());
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Option option = $org_scalatest_assert_macro_left;
            None$ none$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
        this.test("SPARK-33404: test truncTimestamp when time zone offset from UTC has a granularity of seconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zid, (JFunction0.mcV.sp & Serializable)() -> {
                Option inputTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"1769-10-17T17:10:02.123456"), $this.defaultZoneId());
                $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MINUTE(), "1769-10-17T17:10:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), "1769-10-17T17:10:02", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MILLISECOND(), "1769-10-17T17:10:02.123", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MICROSECOND(), "1769-10-17T17:10:02.123456", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
            });
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        this.test("truncTimestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option defaultInputTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-05T09:32:05.359123"), this.defaultZoneId());
            Option defaultInputTS1 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-31T20:32:05.359"), this.defaultZoneId());
            Option defaultInputTS2 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-01T02:32:05.359"), this.defaultZoneId());
            Option defaultInputTS3 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-30T02:32:05.359"), this.defaultZoneId());
            Option defaultInputTS4 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-29T02:32:05.359"), this.defaultZoneId());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_YEAR(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), "2015-03-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_DAY(), "2015-03-05T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_HOUR(), "2015-03-05T09:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MINUTE(), "2015-03-05T09:32:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), "2015-03-05T09:32:05", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-02T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS1.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS2.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS3.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-23T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS4.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS1.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-04-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS2.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MICROSECOND(), "2015-03-05T09:32:05.359123", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MILLISECOND(), "2015-03-05T09:32:05.359", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zid, (JFunction0.mcV.sp & Serializable)() -> {
                    Option inputTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-05T09:32:05.359"), $this.defaultZoneId());
                    Option inputTS1 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-31T20:32:05.359"), $this.defaultZoneId());
                    Option inputTS2 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-01T02:32:05.359"), $this.defaultZoneId());
                    Option inputTS3 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-30T02:32:05.359"), $this.defaultZoneId());
                    Option inputTS4 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-29T02:32:05.359"), $this.defaultZoneId());
                    Option inputTS5 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"1999-03-29T01:02:03.456789"), $this.defaultZoneId());
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_YEAR(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), "2015-03-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_DAY(), "2015-03-05T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_HOUR(), "2015-03-05T09:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MINUTE(), "2015-03-05T09:32:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), "2015-03-05T09:32:05", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-02T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS1.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS2.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS3.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-23T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS4.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS1.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-04-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS2.get()), zid);
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
        this.test("SPARK-51554: time truncation using timeTrunc", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long input = DateTimeUtils$.MODULE$.localTimeToNanos(LocalTime.of(1, 2, 3, 400500600));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"HOUR"), input)));
            long $org_scalatest_assert_macro_right = 3600000000000L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"MINUTE"), input)));
            long $org_scalatest_assert_macro_right2 = 3720000000000L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"SECOND"), input)));
            long $org_scalatest_assert_macro_right3 = 3723000000000L;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"MILLISECOND"), input)));
            long $org_scalatest_assert_macro_right4 = 3723400000000L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"MICROSECOND"), input)));
            long $org_scalatest_assert_macro_right5 = 3723400500000L;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 781));
            long midnight = DateTimeUtils$.MODULE$.localTimeToNanos(LocalTime.MIDNIGHT);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"HOUR"), midnight)));
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"MINUTE"), midnight)));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 787));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"SECOND"), midnight)));
            int $org_scalatest_assert_macro_right8 = 0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"MILLISECOND"), midnight)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timeTrunc(UTF8String.fromString((String)"MICROSECOND"), midnight)));
            int $org_scalatest_assert_macro_right10 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
            ((IterableOnceOps)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DAY", "WEEK", "MONTH", "QUARTER", "YEAR", "INVALID", "ABC", "XYZ", "MS", " ", ""})).map((Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1))).foreach((Function1 & Serializable)level -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> {
                DateTimeUtils$.MODULE$.timeTrunc(level, input);
                return DateTimeUtils$.MODULE$.timeTrunc(level, midnight);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795)));
            return (AssertionError)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.timeTrunc(null, input), ClassTag$.MODULE$.apply(AssertionError.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
        this.test("SPARK-35664: microseconds to LocalDateTime", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LocalDateTime $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.microsToLocalDateTime(0L);
            LocalDateTime $org_scalatest_assert_macro_right = LocalDateTime.parse("1970-01-01T00:00:00");
            LocalDateTime localDateTime = $org_scalatest_assert_macro_left;
            LocalDateTime localDateTime2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(localDateTime != null ? !((Object)localDateTime).equals(localDateTime2) : localDateTime2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
            LocalDateTime $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.microsToLocalDateTime(100L);
            LocalDateTime $org_scalatest_assert_macro_right2 = LocalDateTime.parse("1970-01-01T00:00:00.0001");
            LocalDateTime localDateTime3 = $org_scalatest_assert_macro_left2;
            LocalDateTime localDateTime4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(localDateTime3 != null ? !((Object)localDateTime3).equals(localDateTime4) : localDateTime4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
            LocalDateTime $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.microsToLocalDateTime(100000000L);
            LocalDateTime $org_scalatest_assert_macro_right3 = LocalDateTime.parse("1970-01-01T00:01:40");
            LocalDateTime localDateTime5 = $org_scalatest_assert_macro_left3;
            LocalDateTime localDateTime6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(localDateTime5 != null ? !((Object)localDateTime5).equals(localDateTime6) : localDateTime6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
            LocalDateTime $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.microsToLocalDateTime(100000000000L);
            LocalDateTime $org_scalatest_assert_macro_right4 = LocalDateTime.parse("1970-01-02T03:46:40");
            LocalDateTime localDateTime7 = $org_scalatest_assert_macro_left4;
            LocalDateTime localDateTime8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(localDateTime7 != null ? !((Object)localDateTime7).equals(localDateTime8) : localDateTime8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
            LocalDateTime $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.microsToLocalDateTime(253402300799999999L);
            LocalDateTime $org_scalatest_assert_macro_right5 = LocalDateTime.parse("9999-12-31T23:59:59.999999");
            LocalDateTime localDateTime9 = $org_scalatest_assert_macro_left5;
            LocalDateTime localDateTime10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(localDateTime9 != null ? !((Object)localDateTime9).equals(localDateTime10) : localDateTime10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
            LocalDateTime $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.microsToLocalDateTime(Long.MIN_VALUE);
            LocalDateTime $org_scalatest_assert_macro_right6 = LocalDateTime.parse("-290308-12-21T19:59:05.224192");
            LocalDateTime localDateTime11 = $org_scalatest_assert_macro_left6;
            LocalDateTime localDateTime12 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(localDateTime11 != null ? !((Object)localDateTime11).equals(localDateTime12) : localDateTime12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
            LocalDateTime $org_scalatest_assert_macro_left7 = DateTimeUtils$.MODULE$.microsToLocalDateTime(Long.MAX_VALUE);
            LocalDateTime $org_scalatest_assert_macro_right7 = LocalDateTime.parse("+294247-01-10T04:00:54.775807");
            LocalDateTime localDateTime13 = $org_scalatest_assert_macro_left7;
            LocalDateTime localDateTime14 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(localDateTime13 != null ? !((Object)localDateTime13).equals(localDateTime14) : localDateTime14 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
        this.test("SPARK-35664: LocalDateTime to microseconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("1970-01-01T00:00:00"));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
            long $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("1970-01-01T00:00:00.0001"));
            int $org_scalatest_assert_macro_right2 = 100;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 821));
            long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("1970-01-01T00:01:40"));
            int $org_scalatest_assert_macro_right3 = 100000000;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
            long $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("1970-01-02T03:46:40"));
            long $org_scalatest_assert_macro_right4 = 100000000000L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
            long $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("9999-12-31T23:59:59.999999"));
            long $org_scalatest_assert_macro_right5 = 253402300799999999L;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 827));
            long $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("-1000-12-31T23:59:59.999999"));
            long $org_scalatest_assert_macro_right6 = -93692592000000001L;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
            new .colon.colon((Object)LocalDateTime.MIN, (List)new .colon.colon((Object)LocalDateTime.MAX, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)dt -> {
                String msg;
                String $org_scalatest_assert_macro_left = msg = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.localDateTimeToMicros(dt), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832))).getMessage();
                String $org_scalatest_assert_macro_right = "long overflow";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
        this.test("daysToMicros and microsToDays", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$158 = 2015;
            int x$159 = 12;
            int x$160 = 31;
            int x$161 = 16;
            ZoneId x$162 = DateTimeTestUtils$.MODULE$.LA();
            byte x$163 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$164 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$165 = DateTimeTestUtils$.MODULE$.date$default$7();
            long input = DateTimeTestUtils$.MODULE$.date(2015, (byte)12, (byte)31, (byte)16, x$163, x$164, x$165, x$162);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToDays(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right = 16800;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToDays(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right2 = 16801;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            int $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.microsToDays(-86399999L, DateTimeTestUtils$.MODULE$.UTC());
            int $org_scalatest_assert_macro_right3 = -1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
            int x$166 = 2015;
            int x$167 = 12;
            int x$168 = 31;
            ZoneId x$169 = DateTimeTestUtils$.MODULE$.LA();
            byte x$170 = DateTimeTestUtils$.MODULE$.date$default$4();
            byte x$171 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$172 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$173 = DateTimeTestUtils$.MODULE$.date$default$7();
            long expected = DateTimeTestUtils$.MODULE$.date(2015, (byte)12, (byte)31, x$170, x$171, x$172, x$173, x$169);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.daysToMicros(16800, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right4 = expected;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
            int x$174 = 2015;
            int x$175 = 12;
            int x$176 = 31;
            ZoneId x$177 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$178 = DateTimeTestUtils$.MODULE$.date$default$4();
            byte x$179 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$180 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$181 = DateTimeTestUtils$.MODULE$.date$default$7();
            expected = DateTimeTestUtils$.MODULE$.date(2015, (byte)12, (byte)31, x$178, x$179, x$180, x$181, x$177);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.daysToMicros(16800, DateTimeTestUtils$.MODULE$.UTC())));
            long $org_scalatest_assert_macro_right5 = expected;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 849));
            scala.collection.immutable.Map skipped_days = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Kwajalein"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8632, 8633, 8634}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Apia"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15338}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Enderbury"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9130, 9131}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Fakaofo"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15338}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Kiritimati"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9130, 9131}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Kanton"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9130, 9131}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Kwajalein"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8632, 8633, 8634}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateTimeTestUtils$.MODULE$.MIT().getId()), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15338})))}));
            DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
                DateTimeUtilsSuite.$anonfun$new$68(this, skipped_days, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
        this.test("microsToMillis", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(-9223372036844776001L)));
            long $org_scalatest_assert_macro_right = -9223372036844777L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(-157700927876544L)));
            long $org_scalatest_assert_macro_right2 = -157700927877L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876));
        this.test("SPARK-29012: special timestamp values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testSpecialDatetimeValues((Function1 & Serializable)zoneId -> {
            long tolerance = TimeUnit.SECONDS.toMicros(30L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialTimestamp("Epoch", zoneId).get());
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
            long now = DateTimeUtils$.MODULE$.instantToMicros(Instant.now());
            Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestamp("NOW", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 887), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)now), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialTimestamp("now UTC", zoneId));
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 888));
            ZonedDateTime localToday = LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT).atZone((ZoneId)zoneId);
            long yesterday = DateTimeUtils$.MODULE$.instantToMicros(localToday.minusDays(1L).toInstant());
            Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestamp(" Yesterday", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)yesterday), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
            long today = DateTimeUtils$.MODULE$.instantToMicros(localToday.toInstant());
            Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestamp("Today ", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 895), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)today), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
            long tomorrow = DateTimeUtils$.MODULE$.instantToMicros(localToday.plusDays(1L).toInstant());
            return Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestamp(" tomorrow CET ", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 897), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)tomorrow), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
        this.test("SPARK-35979: special timestamp without time zone values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long tolerance = TimeUnit.SECONDS.toMicros(30L);
            this.testSpecialDatetimeValues((Function1 & Serializable)zoneId -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ("Epoch", zoneId).get());
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
                long now = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.now(zoneId));
                Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ("NOW", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 907), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)now), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
                LocalDateTime localToday = LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT);
                long yesterday = DateTimeUtils$.MODULE$.localDateTimeToMicros(localToday.minusDays(1L));
                Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ(" Yesterday", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)yesterday)));
                long today = DateTimeUtils$.MODULE$.localDateTimeToMicros(localToday);
                Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ("Today ", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)today)));
                long tomorrow = DateTimeUtils$.MODULE$.localDateTimeToMicros(localToday.plusDays(1L));
                return Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ(" tomorrow ", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)tomorrow)));
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
        this.test("SPARK-28141: special date values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testSpecialDatetimeValues((Function1 & Serializable)zoneId -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("epoch", zoneId).get());
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 920));
            int today = DateTimeUtils$.MODULE$.localDateToDays(LocalDate.now(zoneId));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("YESTERDAY", zoneId).get());
            int $org_scalatest_assert_macro_right2 = today - 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 922));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate(" Now ", zoneId).get());
            int $org_scalatest_assert_macro_right3 = today;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("now UTC", zoneId));
            None$ $org_scalatest_assert_macro_right4 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 924));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("today", zoneId).get());
            int $org_scalatest_assert_macro_right5 = today;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 925));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("tomorrow CET ", zoneId).get());
            int $org_scalatest_assert_macro_right6 = today + 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 926));
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 918));
        this.test("parsing day of week", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.getDayOfWeekFromString(UTF8String.fromString((String)"THU"));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 931));
            int $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.getDayOfWeekFromString(UTF8String.fromString((String)"MONDAY"));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 932));
            SparkIllegalArgumentException x$182 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> DateTimeUtils$.MODULE$.getDayOfWeekFromString(UTF8String.fromString((String)"xx")), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934))));
            String x$183 = "ILLEGAL_DAY_OF_WEEK";
            scala.collection.immutable.Map x$184 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)"xx")}));
            Option x$185 = this.checkError$default$3();
            boolean x$186 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$187 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$182, "ILLEGAL_DAY_OF_WEEK", x$185, x$184, x$186, x$187);
            SparkIllegalArgumentException x$188 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> DateTimeUtils$.MODULE$.getDayOfWeekFromString(UTF8String.fromString((String)"\"quote")), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 940))));
            String x$189 = "ILLEGAL_DAY_OF_WEEK";
            scala.collection.immutable.Map x$190 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)"\"quote")}));
            Option x$191 = this.checkError$default$3();
            boolean x$192 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$193 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$188, "ILLEGAL_DAY_OF_WEEK", x$191, x$190, x$192, x$193);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 930));
        this.test("SPARK-34761: timestamp add day-time interval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2019, (byte)3, (byte)9, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA()), 86400000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2019, (byte)3, (byte)10, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 949));
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)44, (byte)1, 100000, (ZoneId)zid), 0L, zid)));
                long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)44, (byte)1, 100000, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2021, (byte)1, (byte)19, (byte)0, (byte)0, (byte)0, 0, (ZoneId)zid), -1555200000000L, zid)));
                long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2021, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)44, (byte)1, 999999, (ZoneId)zid), 600000000L, zid)));
                long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)54, (byte)1, 999999, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 963));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)44, (byte)1, 1, (ZoneId)zid), -86400000001L, zid)));
                long $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)17, (byte)19, (byte)44, (byte)1, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 966));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2019, (byte)5, (byte)9, (byte)12, (byte)0, (byte)0, 123456, (ZoneId)zid), 172800000001L, zid)));
                long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.date(2019, (byte)5, (byte)11, (byte)12, (byte)0, (byte)0, 123457, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 969));
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2019, (byte)11, (byte)2, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA()), 86400000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2019, (byte)11, (byte)3, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 974));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
        this.test("SPARK-34903: subtract timestamps", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            DateTimeUtilsSuite.$anonfun$new$85(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 982));
        this.test("SPARK-35679: instantToMicros should be able to return microseconds of Long.MinValue", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(DateTimeUtils$.MODULE$.microsToInstant(Long.MAX_VALUE))));
            long $org_scalatest_assert_macro_right = Long.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(DateTimeUtils$.MODULE$.microsToInstant(Long.MIN_VALUE))));
            long $org_scalatest_assert_macro_right2 = Long.MIN_VALUE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1023));
        this.test("SPARK-37552: convert a timestamp_ntz from a source time zone to target one", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"1970-01-01T00:00:00", (Object)"UTC")), (Object)new Tuple2((Object)"1969-12-31T16:00:00", (Object)"America/Los_Angeles")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-12-05T22:00:00", (Object)"Europe/Moscow")), (Object)new Tuple2((Object)"2021-12-06T00:00:00", (Object)"Asia/Yekaterinburg")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-12-06T00:01:02.123456", (Object)"Asia/Yekaterinburg")), (Object)new Tuple2((Object)"2021-12-05T20:01:02.123456", (Object)"Europe/Brussels")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T09:00:00", (Object)"Europe/Brussels")), (Object)new Tuple2((Object)"2021-11-07T01:00:00", (Object)"America/Los_Angeles")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T10:00:00", (Object)"Europe/Brussels")), (Object)new Tuple2((Object)"2021-11-07T01:00:00", (Object)"America/Los_Angeles")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T11:00:00", (Object)"Europe/Brussels")), (Object)new Tuple2((Object)"2021-11-07T02:00:00", (Object)"America/Los_Angeles")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T00:30:00", (Object)"America/Los_Angeles")), (Object)new Tuple2((Object)"2021-11-07T08:30:00", (Object)"Europe/Brussels")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T01:30:00", (Object)"America/Los_Angeles")), (Object)new Tuple2((Object)"2021-11-07T09:30:00", (Object)"Europe/Brussels")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T02:30:00", (Object)"America/Los_Angeles")), (Object)new Tuple2((Object)"2021-11-07T11:30:00", (Object)"Europe/Brussels"))})).foreach((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String inputTs = (String)tuple22._1();
                    String sourceTz = (String)tuple22._2();
                    if (tuple23 != null) {
                        String expectedTs = (String)tuple23._1();
                        String targetTz = (String)tuple23._2();
                        long micros = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse(inputTs));
                        long result = DateTimeUtils$.MODULE$.convertTimestampNtzToAnotherTz(sourceTz, targetTz, micros);
                        long expectedMicros = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse(expectedTs));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)expectedMicros));
                        long $org_scalatest_assert_macro_right = result;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("The difference is " + (result - expectedMicros) / 3600000000L + " hours"), Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1047));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
        this.test("SPARK-38195: add a quantity of interval units to a timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("MICROSECOND", 1L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 0, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1054));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("MILLISECOND", -1L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1000, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1056));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("SECOND", 0L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1001, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1001, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1058));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("MINUTE", -90L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)0, (byte)1, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)9, (byte)30, (byte)1, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1060));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("HOUR", 24L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)0, (byte)1, 0, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)15, (byte)11, (byte)0, (byte)1, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1062));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("DAY", 1L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)28, (byte)11, (byte)1, (byte)0, 0, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.date(2022, (byte)3, (byte)1, (byte)11, (byte)1, (byte)0, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("DAYOFYEAR", 364L, DateTimeTestUtils$.MODULE$.date(2022, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right7 = DateTimeTestUtils$.MODULE$.date(2022, (byte)12, (byte)31, (byte)0, (byte)0, (byte)0, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("WEEK", 1L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right8 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)21, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1068));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("MONTH", 10L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right9 = DateTimeTestUtils$.MODULE$.date(2022, (byte)12, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1070));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("QUARTER", 1L, DateTimeTestUtils$.MODULE$.date(1900, (byte)2, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right10 = DateTimeTestUtils$.MODULE$.date(1900, (byte)5, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("YEAR", 1L, DateTimeTestUtils$.MODULE$.date(9998, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right11 = DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1074));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("YEAR", -9998L, DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right12 = DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1076));
            });
            SparkIllegalArgumentException x$194 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.timestampAdd("SECS", 1L, DateTimeTestUtils$.MODULE$.date(1969, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, DateTimeUtils$.MODULE$.getZoneId("UTC")), DateTimeUtils$.MODULE$.getZoneId("UTC")), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1081))));
            String x$195 = "INVALID_PARAMETER_VALUE.DATETIME_UNIT";
            scala.collection.immutable.Map x$196 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`TIMESTAMPADD`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`unit`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidValue"), (Object)"'SECS'")}));
            Option x$197 = this.checkError$default$3();
            boolean x$198 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$199 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$194, "INVALID_PARAMETER_VALUE.DATETIME_UNIT", x$197, x$196, x$198, x$199);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1052));
        this.test("SPARK-38284: difference between two timestamps in units", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("MICROSECOND", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 0, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1093));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("MILLISECOND", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1000, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 0, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right2 = -1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1095));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("SECOND", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1001, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1002, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1097));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("MINUTE", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)0, (byte)1, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)9, (byte)30, (byte)1, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right4 = -90;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1102));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("HOUR", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)0, (byte)1, 0, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)15, (byte)11, (byte)0, (byte)1, 2, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right5 = 24;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1107));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("DAY", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)28, (byte)11, (byte)1, (byte)0, 0, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)3, (byte)1, (byte)11, (byte)1, (byte)0, 0, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1112));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("WEEK", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)21, (byte)11, (byte)42, (byte)59, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right7 = 0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1117));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("MONTH", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)12, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right8 = 10;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1119));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("QUARTER", DateTimeTestUtils$.MODULE$.date(1900, (byte)2, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(1900, (byte)5, (byte)1, (byte)2, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right9 = 1;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1121));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("YEAR", DateTimeTestUtils$.MODULE$.date(9998, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, 2, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right10 = 1;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1123));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("YEAR", DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right11 = -9998;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1128));
            });
            SparkIllegalArgumentException x$200 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.timestampDiff("SECS", DateTimeTestUtils$.MODULE$.date(1969, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, DateTimeUtils$.MODULE$.getZoneId("UTC")), DateTimeTestUtils$.MODULE$.date(2022, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, DateTimeUtils$.MODULE$.getZoneId("UTC")), DateTimeUtils$.MODULE$.getZoneId("UTC")), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1136))));
            String x$201 = "INVALID_PARAMETER_VALUE.DATETIME_UNIT";
            scala.collection.immutable.Map x$202 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`TIMESTAMPDIFF`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`unit`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidValue"), (Object)"'SECS'")}));
            Option x$203 = this.checkError$default$3();
            boolean x$204 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$205 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$200, "INVALID_PARAMETER_VALUE.DATETIME_UNIT", x$203, x$202, x$204, x$205);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1091));
        this.test("localTimeToNanos and nanosToLocalTime", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String msg;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.nanosToLocalTime(0L));
            LocalTime $org_scalatest_assert_macro_right = LocalTime.of(0, 0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1151));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localTimeToNanos(LocalTime.of(0, 0))));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1152));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localTimeToNanos(DateTimeUtils$.MODULE$.nanosToLocalTime(123456789123L))));
            long $org_scalatest_assert_macro_right3 = 123456789123L;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1154));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localTimeToNanos(LocalTime.parse("23:59:59.999999999"))));
            long $org_scalatest_assert_macro_right4 = 86399999999999L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1156));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(DateTimeUtils$.MODULE$.nanosToLocalTime(86399999999999L));
            LocalTime $org_scalatest_assert_macro_right5 = LocalTime.of(23, 59, 59, 999999999);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1158));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-1L, 86400000000000L})).foreach((Function1 & Serializable)invalidNanos -> DateTimeUtilsSuite.$anonfun$new$97(this, BoxesRunTime.unboxToLong((Object)invalidNanos)));
            String $org_scalatest_assert_macro_left6 = msg = ((Throwable)this.intercept((Function0 & Serializable)() -> DateTimeUtils$.MODULE$.nanosToLocalTime(Long.MAX_VALUE), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1167))).getMessage();
            String $org_scalatest_assert_macro_right6 = "Invalid value";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1170));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1150));
        this.test("stringToTime", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkStringToTime$1("00:00", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(DateTimeTestUtils$.MODULE$.localTime$default$1(), DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("00:00:00", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(DateTimeTestUtils$.MODULE$.localTime$default$1(), DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            int x$206 = 100000;
            byte x$207 = DateTimeTestUtils$.MODULE$.localTime$default$1();
            byte x$208 = DateTimeTestUtils$.MODULE$.localTime$default$2();
            byte x$209 = DateTimeTestUtils$.MODULE$.localTime$default$3();
            this.checkStringToTime$1("00:00:00.1", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(x$207, x$208, x$209, 100000))));
            int x$210 = 59;
            int x$211 = 10000;
            byte x$212 = DateTimeTestUtils$.MODULE$.localTime$default$1();
            byte x$213 = DateTimeTestUtils$.MODULE$.localTime$default$2();
            this.checkStringToTime$1("00:00:59.01", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(x$212, x$213, (byte)59, 10000))));
            int x$214 = 59;
            int x$215 = 1000;
            byte x$216 = DateTimeTestUtils$.MODULE$.localTime$default$1();
            byte x$217 = DateTimeTestUtils$.MODULE$.localTime$default$3();
            this.checkStringToTime$1("00:59:00.001", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(x$216, (byte)59, x$217, 1000))));
            int x$218 = 23;
            int x$219 = 100;
            byte x$220 = DateTimeTestUtils$.MODULE$.localTime$default$2();
            byte x$221 = DateTimeTestUtils$.MODULE$.localTime$default$3();
            this.checkStringToTime$1("23:00:00.0001", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)23, x$220, x$221, 100))));
            int x$222 = 23;
            int x$223 = 59;
            int x$224 = 10;
            byte x$225 = DateTimeTestUtils$.MODULE$.localTime$default$3();
            this.checkStringToTime$1("23:59:00.00001", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, x$225, 10))));
            this.checkStringToTime$1("23:59:59.000001", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 1))));
            this.checkStringToTime$1("23:59:59.999999", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999))));
            this.checkStringToTime$1("1:2:3.0", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)2, (byte)3, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("T1:02:3.04", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)2, (byte)3, 40000))));
            this.checkStringToTime$1("00:00 ", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(DateTimeTestUtils$.MODULE$.localTime$default$1(), DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1(" 00:00", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(DateTimeTestUtils$.MODULE$.localTime$default$1(), DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1(" 00:00 ", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(DateTimeTestUtils$.MODULE$.localTime$default$1(), DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("1:2:3.0 ", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)2, (byte)3, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1(" 1:2:3.0", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)2, (byte)3, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1(" 1:2:3.0 ", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)2, (byte)3, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            new .colon.colon((Object)"24:00:00", (List)new .colon.colon((Object)"25:00:00", (List)new .colon.colon((Object)"-1:00:00", (List)new .colon.colon((Object)"23:60:00", (List)new .colon.colon((Object)"23:00:60", (List)new .colon.colon((Object)"99:99:99", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)invalidTime -> {
                this.checkStringToTime$1(invalidTime, (Option)None$.MODULE$);
                return BoxedUnit.UNIT;
            });
            this.checkStringToTime$1("12:00:00 AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)0, (byte)0, 0))));
            this.checkStringToTime$1("12:30:45 AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)30, (byte)45, 0))));
            this.checkStringToTime$1("12:59:59.999 AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)59, (byte)59, 999000))));
            this.checkStringToTime$1("12:59:59.999999 AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)59, (byte)59, 999999))));
            this.checkStringToTime$1("1:00:00 AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("11:59:59 AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)11, (byte)59, (byte)59, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("5:30:15.123456 AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)5, (byte)30, (byte)15, 123456))));
            this.checkStringToTime$1("12:00:00 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("12:30:45 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)30, (byte)45, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("12:59:59.999 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)59, (byte)59, 999000))));
            this.checkStringToTime$1("12:59:59.999999 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)59, (byte)59, 999999))));
            this.checkStringToTime$1("1:00:00 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)13, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("11:59:59 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("6:45:30.987654 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)18, (byte)45, (byte)30, 987654))));
            this.checkStringToTime$1("11:59:59.999 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999000))));
            this.checkStringToTime$1("11:59:59.999999 PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999))));
            this.checkStringToTime$1("12:00:00AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("12:00:00PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("3:30:45AM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)3, (byte)30, (byte)45, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("9:15:20PM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)21, (byte)15, (byte)20, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("10:30:00Am ", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)10, (byte)30, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("10:30:00 am", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)10, (byte)30, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("2:45:30 Pm", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)14, (byte)45, (byte)30, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("2:45:30pm ", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)14, (byte)45, (byte)30, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("7:00:00aM", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)7, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            this.checkStringToTime$1("8:00:00Pm", (Option)new Some((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)20, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()))));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0:00:00 AM", "0:00:00 PM", "13:00:00 AM", "13:00:00 PM", "24:00:00 AM", "24:00:00 PM", "12:60:00 AM", "12:60:00 PM", "12:00:60 AM", "12:00:60 PM", "99:99:99 AM", "99:99:99 PM"})).foreach((Function1 & Serializable)invalidTime -> {
                this.checkStringToTime$1(invalidTime, (Option)None$.MODULE$);
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)"2025-03-09 00:00:00", (List)new .colon.colon((Object)"00", (List)new .colon.colon((Object)"00:01:02 UTC", (List)new .colon.colon((Object)"XYZ", (List)new .colon.colon((Object)"ABCD", (List)new .colon.colon((Object)" ", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)invalidTime -> {
                this.checkStringToTime$1(invalidTime, (Option)None$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
        this.test("stringToTimeAnsi", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"2025-03-09T00:00:00", (List)new .colon.colon((Object)"012", (List)new .colon.colon((Object)"00:01:02Z", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)invalidTime -> {
            DateTimeUtilsSuite.$anonfun$new$105(this, invalidTime);
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1291));
        this.test("timeToMicros", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int hour = 13;
            int min = 2;
            int sec = 23;
            int micros = 1234;
            Decimal secAndMicros = Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal((double)((float)sec + (float)micros / 1000000.0f)), 16, 6);
            long nanoSecsTime = DateTimeUtils$.MODULE$.makeTime(hour, min, secAndMicros);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)nanoSecsTime));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.localTime((byte)hour, (byte)min, (byte)sec, micros);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1315));
            SparkDateTimeException x$232 = (SparkDateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.makeTime(-1, min, secAndMicros), ClassTag$.MODULE$.apply(SparkDateTimeException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1319));
            String x$233 = "DATETIME_FIELD_OUT_OF_BOUNDS.WITHOUT_SUGGESTION";
            scala.collection.immutable.Map x$234 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rangeMessage"), (Object)"Invalid value for HourOfDay (valid values 0 - 23): -1")}));
            Option x$235 = this.checkError$default$3();
            boolean x$236 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$237 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$232, "DATETIME_FIELD_OUT_OF_BOUNDS.WITHOUT_SUGGESTION", x$235, x$234, x$236, x$237);
            SparkDateTimeException x$238 = (SparkDateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.makeTime(hour, -1, secAndMicros), ClassTag$.MODULE$.apply(SparkDateTimeException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1327));
            String x$239 = "DATETIME_FIELD_OUT_OF_BOUNDS.WITHOUT_SUGGESTION";
            scala.collection.immutable.Map x$240 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rangeMessage"), (Object)"Invalid value for MinuteOfHour (valid values 0 - 59): -1")}));
            Option x$241 = this.checkError$default$3();
            boolean x$242 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$243 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$238, "DATETIME_FIELD_OUT_OF_BOUNDS.WITHOUT_SUGGESTION", x$241, x$240, x$242, x$243);
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{60.0, 9.999999999999998E9, -9.99999999999999E8, 4.294967297999999E9})).foreach((Function1)(JFunction1.mcVD.sp & Serializable)invalidSecond -> {
                SparkDateTimeException x$244 = (SparkDateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.makeTime(hour, min, Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(invalidSecond), 16, 6)), ClassTag$.MODULE$.apply(SparkDateTimeException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1343));
                String x$245 = "DATETIME_FIELD_OUT_OF_BOUNDS.WITHOUT_SUGGESTION";
                scala.collection.immutable.Map x$246 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rangeMessage"), (Object)("Invalid value for SecondOfMinute (valid values 0 - 59): " + (long)invalidSecond))}));
                Option x$247 = this.checkError$default$3();
                boolean x$248 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$249 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$244, "DATETIME_FIELD_OUT_OF_BOUNDS.WITHOUT_SUGGESTION", x$247, x$246, x$248, x$249);
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1306));
        this.test("SPARK-51415: makeTimestamp with days, nanos, and zoneId", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)new Tuple2((Object)DateTimeTestUtils$.MODULE$.MIT(), (Object)BoxesRunTime.boxToLong((long)-34200000000L)), (List)new .colon.colon((Object)new Tuple2((Object)DateTimeTestUtils$.MODULE$.PST(), (Object)BoxesRunTime.boxToLong((long)-28800000000L)), (List)new .colon.colon((Object)new Tuple2((Object)DateTimeTestUtils$.MODULE$.UTC(), (Object)BoxesRunTime.boxToLong((long)0L)), (List)new .colon.colon((Object)new Tuple2((Object)DateTimeTestUtils$.MODULE$.CET(), (Object)BoxesRunTime.boxToLong((long)3600000000L)), (List)new .colon.colon((Object)new Tuple2((Object)DateTimeTestUtils$.MODULE$.JST(), (Object)BoxesRunTime.boxToLong((long)32400000000L)), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                ZoneId zoneId = (ZoneId)tuple2._1();
                long microsOffset = tuple2._2$mcJ$sp();
                if (zoneId != null) {
                    ZoneId zoneId2 = zoneId;
                    if (true) {
                        String msg;
                        long l = microsOffset;
                        long $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.makeTimestamp(0, 0L, zoneId2);
                        long $org_scalatest_assert_macro_right = 0L - l;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1360));
                        long $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.makeTimestamp(0, DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, DateTimeTestUtils$.MODULE$.localTime$default$4()), zoneId2) * 1000L;
                        long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, DateTimeTestUtils$.MODULE$.localTime$default$4()) - l * 1000L;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1362));
                        long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.makeTimestamp(-1, 0L, zoneId2);
                        long $org_scalatest_assert_macro_right3 = -86400000000L - l;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1364));
                        long $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.makeTimestamp(-1, DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999), zoneId2);
                        long $org_scalatest_assert_macro_right4 = -1L - l;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1366));
                        long $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.makeTimestamp(DateTimeTestUtils$.MODULE$.days(9999, (byte)12, (byte)31), DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999), zoneId2);
                        long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.date(9999, (byte)12, (byte)31, (byte)23, (byte)59, (byte)59, 999999, DateTimeTestUtils$.MODULE$.date$default$8()) - l;
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1368));
                        long $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.makeTimestamp(DateTimeTestUtils$.MODULE$.days(1, (byte)1, (byte)1), DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()), zoneId2);
                        long $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()) - l;
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1370));
                        String $org_scalatest_assert_macro_left7 = msg = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.makeTimestamp(0, -1L, zoneId2), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1372))).getMessage();
                        String $org_scalatest_assert_macro_right7 = "Invalid value";
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1375));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1352));
        this.test("makeTimestampNTZ", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String msg;
            long $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.makeTimestampNTZ(0, 0L);
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1380));
            long $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.makeTimestampNTZ(0, DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, DateTimeTestUtils$.MODULE$.localTime$default$4())) * 1000L;
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1381));
            long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.makeTimestampNTZ(-1, 0L);
            long $org_scalatest_assert_macro_right3 = -86400000000L;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1382));
            long $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.makeTimestampNTZ(-1, DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999));
            int $org_scalatest_assert_macro_right4 = -1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1383));
            long $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.makeTimestampNTZ(DateTimeTestUtils$.MODULE$.days(9999, (byte)12, (byte)31), DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999));
            long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.date(9999, (byte)12, (byte)31, (byte)23, (byte)59, (byte)59, 999999, DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1384));
            long $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.makeTimestampNTZ(DateTimeTestUtils$.MODULE$.days(1, (byte)1, (byte)1), DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$4()));
            long $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1386));
            String $org_scalatest_assert_macro_left7 = msg = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.makeTimestampNTZ(0, -1L), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1387))).getMessage();
            String $org_scalatest_assert_macro_right7 = "Invalid value";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1390));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1379));
        this.test("instant to nanos of day", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.instantToNanosOfDay(Instant.parse("1970-01-01T00:00:01.001002003Z"), "UTC");
            int $org_scalatest_assert_macro_right = 1001002003;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1394));
            long $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.instantToNanosOfDay(Instant.parse("0001-01-01T23:59:59.999999Z"), "UTC");
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1396));
            long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.instantToNanosOfDay(Instant.parse("2025-07-02T19:24:12Z"), ZoneId.of("America/Los_Angeles"));
            long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)24, (byte)12, DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1398));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1393));
        this.test("truncate time to precision", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.truncateTimeToPrecision(1234L, 0);
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403));
            long $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.truncateTimeToPrecision(1000L, 6);
            int $org_scalatest_assert_macro_right2 = 1000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1404));
            long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.truncateTimeToPrecision(DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)0, (byte)0, 999999), 6);
            int $org_scalatest_assert_macro_right3 = 999999000;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1405));
            long $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.truncateTimeToPrecision(DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)0, (byte)0, 999999), 5);
            int $org_scalatest_assert_macro_right4 = 999990000;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1406));
            long $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.truncateTimeToPrecision(DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 123000), 2);
            long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 120000);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1407));
            long $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.truncateTimeToPrecision(DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 987654), 1);
            long $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 900000);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1409));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
        this.test("add day-time interval to time", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.timeAddInterval(0L, 0, 0L, DayTimeIntervalType$.MODULE$.SECOND(), 6);
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.localTime(DateTimeTestUtils$.MODULE$.localTime$default$1(), DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1414));
            long $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.timeAddInterval(0L, 6, 86399999999L, DayTimeIntervalType$.MODULE$.SECOND(), 6);
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1415));
            long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.timeAddInterval(DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 999999), 0, -86399999999L, DayTimeIntervalType$.MODULE$.SECOND(), 6);
            long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)0, DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1417));
            long $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.timeAddInterval(DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)30, (byte)43, 123400), 4, 600000000L, DayTimeIntervalType$.MODULE$.SECOND(), 6);
            long $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)40, (byte)43, 123400);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1419));
            long $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.timeAddInterval(DateTimeTestUtils$.MODULE$.localTime((byte)19, (byte)31, (byte)45, 123450), 5, 6L, DayTimeIntervalType$.MODULE$.SECOND(), 6);
            long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.localTime((byte)19, (byte)31, (byte)45, 123456);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1421));
            long $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.timeAddInterval(DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)2, (byte)3, 1), 6, 3600000000L, DayTimeIntervalType$.MODULE$.HOUR(), 6);
            long $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.localTime((byte)2, (byte)2, (byte)3, 1);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1423));
            SparkArithmeticException x$250 = (SparkArithmeticException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.timeAddInterval(1L, 6, 86400000000L, DayTimeIntervalType$.MODULE$.SECOND(), 6), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1427));
            String x$251 = "DATETIME_OVERFLOW";
            scala.collection.immutable.Map x$252 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"add INTERVAL '86400' SECOND to the time value TIME '00:00:00.000000001'")}));
            Option x$253 = this.checkError$default$3();
            boolean x$254 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$255 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$250, "DATETIME_OVERFLOW", x$253, x$252, x$254, x$255);
            SparkArithmeticException x$256 = (SparkArithmeticException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.timeAddInterval(0L, 0, -1L, DayTimeIntervalType$.MODULE$.SECOND(), 6), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1435));
            String x$257 = "DATETIME_OVERFLOW";
            scala.collection.immutable.Map x$258 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"add INTERVAL '-00.000001' SECOND to the time value TIME '00:00:00'")}));
            Option x$259 = this.checkError$default$3();
            boolean x$260 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$261 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$256, "DATETIME_OVERFLOW", x$259, x$258, x$260, x$261);
            SparkArithmeticException x$262 = (SparkArithmeticException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.timeAddInterval(0L, 0, Long.MAX_VALUE, DayTimeIntervalType$.MODULE$.SECOND(), 6), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1443));
            String x$263 = "ARITHMETIC_OVERFLOW";
            scala.collection.immutable.Map x$264 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)"long overflow"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alternative"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)DataTypeErrors$.MODULE$.toSQLConf(SqlApiConf$.MODULE$.ANSI_ENABLED_KEY()))}));
            Option x$265 = this.checkError$default$3();
            boolean x$266 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$267 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$262, "ARITHMETIC_OVERFLOW", x$265, x$264, x$266, x$267);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1413));
        this.test("SPARK-51555: time difference calculation using timeDiff", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long zero = 0L;
            long nano = zero + 1L;
            long micro = 1000L * nano;
            long milli = 1000L * micro;
            long sec = 1000L * milli;
            long min = 60L * sec;
            long hour = 60L * min;
            long day = 24L * hour;
            long maxTime = day - nano;
            .colon.colon supportedUnits = new .colon.colon((Object)"HOUR", (List)new .colon.colon((Object)"MINUTE", (List)new .colon.colon((Object)"SECOND", (List)new .colon.colon((Object)"MILLISECOND", (List)new .colon.colon((Object)"MICROSECOND", (List)Nil$.MODULE$)))));
            supportedUnits.foreach((Function1 & Serializable)unit -> {
                DateTimeUtilsSuite.$anonfun$new$124(this, zero, nano, maxTime, unit);
                return BoxedUnit.UNIT;
            });
            this.testTimeDiff("HOUR", hour, hour, 0L);
            this.testTimeDiff("MINUTE", min, min, 0L);
            this.testTimeDiff("SECOND", sec, sec, 0L);
            this.testTimeDiff("MILLISECOND", milli, milli, 0L);
            this.testTimeDiff("MICROSECOND", micro, micro, 0L);
            this.testTimeDiff("HOUR", zero, hour, 1L);
            this.testTimeDiff("MINUTE", zero, min, 1L);
            this.testTimeDiff("SECOND", zero, sec, 1L);
            this.testTimeDiff("MILLISECOND", zero, milli, 1L);
            this.testTimeDiff("MICROSECOND", zero, micro, 1L);
            this.testTimeDiff("HOUR", zero, maxTime, 23L);
            this.testTimeDiff("MINUTE", zero, maxTime, 1439L);
            this.testTimeDiff("SECOND", zero, maxTime, 86399L);
            this.testTimeDiff("MILLISECOND", zero, maxTime, 86399999L);
            this.testTimeDiff("MICROSECOND", zero, maxTime, 86399999999L);
            long start = 10L * hour + 53L * min + 45L * sec + 123L * milli + 456L * micro;
            long end = 11L * hour + 54L * min + 46L * sec + 654L * milli + 321L * micro;
            this.testTimeDiff("HOUR", start, end, 1L);
            this.testTimeDiff("MINUTE", start, end, 61L);
            this.testTimeDiff("SECOND", start, end, 3661L);
            this.testTimeDiff("MILLISECOND", start, end, 3661530L);
            this.testTimeDiff("MICROSECOND", start, end, 3661530865L);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1461));
        this.test("subtract times", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalTime.MIDNIGHT, (Object)LocalTime.MIDNIGHT)), (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalTime.MAX, (Object)LocalTime.MIN)), (Object)BoxesRunTime.boxToLong((long)(TimeUnit.DAYS.toMicros(1L) - 1L))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalTime.MIN, (Object)LocalTime.MAX)), (Object)BoxesRunTime.boxToLong((long)(-(TimeUnit.DAYS.toMicros(1L) - 1L)))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalTime.of(12, 0, 0, 999999000), (Object)LocalTime.of(0, 0, 0, 999999000))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.HOURS.toMicros(12L))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalTime.of(0, 0, 0, 1000), (Object)LocalTime.of(0, 0, 0, 999999000))), (Object)BoxesRunTime.boxToInteger((int)-999998)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalTime.of(0, 0, 0, 123456789), (Object)LocalTime.of(0, 0, 0, 123))), (Object)BoxesRunTime.boxToInteger((int)123456)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalTime.of(20, 30, 45, 321000), (Object)LocalTime.of(10, 20, 15, 123000))), (Object)BoxesRunTime.boxToLong((long)((DateTimeTestUtils$.MODULE$.localTime((byte)20, (byte)30, (byte)45, 321) - DateTimeTestUtils$.MODULE$.localTime((byte)10, (byte)20, (byte)15, 123)) / 1000L))), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Object expected = tuple2._2();
                if (tuple22 != null) {
                    LocalTime end = (LocalTime)tuple22._1();
                    LocalTime start = (LocalTime)tuple22._2();
                    long endNanos = DateTimeUtils$.MODULE$.localTimeToNanos(end);
                    long startNanos = DateTimeUtils$.MODULE$.localTimeToNanos(start);
                    long result = DateTimeUtils$.MODULE$.subtractTimes(endNanos, startNanos);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)result));
                    Object $org_scalatest_assert_macro_right = expected;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1525));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1510));
        Statics.releaseFence();
    }
}

