/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.File;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.ZoneId;
import org.apache.spark.SparkDateTimeException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.package$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.DefaultTimeFormatter;
import org.apache.spark.sql.catalyst.util.FractionTimeFormatter;
import org.apache.spark.sql.catalyst.util.TimeFormatter;
import org.apache.spark.sql.catalyst.util.TimeFormatter$;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005}1AAA\u0002\u0001!!)1\u0004\u0001C\u00019\t\u0011B+[7f\r>\u0014X.\u0019;uKJ\u001cV/\u001b;f\u0015\t!Q!\u0001\u0003vi&d'B\u0001\u0004\b\u0003!\u0019\u0017\r^1msN$(B\u0001\u0005\n\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0015-\tQa\u001d9be.T!\u0001D\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0011aA8sO\u000e\u00011c\u0001\u0001\u0012+A\u0011!cE\u0007\u0002\u0013%\u0011A#\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005YIR\"A\f\u000b\u0005a)\u0011!\u00029mC:\u001c\u0018B\u0001\u000e\u0018\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0007\u0001")
public class TimeFormatterSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        TimeFormatterSuite timeFormatterSuite = this;
        synchronized (timeFormatterSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private final void assertError$1(String str, String expectedMsg) {
        DateTimeException e = (DateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> TimeFormatter$.MODULE$.apply("HH:mm:ss", true).parse(str), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = expectedMsg;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
    }

    private final void assertError$2(long micros, String expectedMsg) {
        DateTimeException e = (DateTimeException)this.intercept((Function0 & Serializable)() -> TimeFormatter$.MODULE$.apply(false).format(micros), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = expectedMsg;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public static final /* synthetic */ void $anonfun$new$10(TimeFormatterSuite $this, String invalidPattern) {
        SparkRuntimeException x$1 = (SparkRuntimeException)$this.intercept((Function0 & Serializable)() -> TimeFormatter$.MODULE$.apply(invalidPattern), ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        String x$2 = "INVALID_DATETIME_PATTERN.WITH_SUGGESTION";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)("'" + invalidPattern + "'")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())}));
        Option x$4 = $this.checkError$default$3();
        boolean x$5 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$1, "INVALID_DATETIME_PATTERN.WITH_SUGGESTION", x$4, x$3, x$5, x$6);
    }

    public static final /* synthetic */ Assertion $anonfun$new$14(TimeFormatterSuite $this, TimeFormatter formatter$1, TimeFormatter parser$1, long nanos) {
        String str = formatter$1.format(nanos);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)parser$1.parse(str)));
        long $org_scalatest_assert_macro_right = nanos;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("nanos = " + nanos), Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(formatter$1.format(DateTimeUtils$.MODULE$.nanosToLocalTime(nanos)));
        String $org_scalatest_assert_macro_right2 = str;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }

    public TimeFormatterSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("time parsing", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"12", (Object)"HH")), (Object)BoxesRunTime.boxToLong((long)43200000000000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"01:02", (Object)"HH:mm")), (Object)BoxesRunTime.boxToLong((long)3720000000000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"10:20", (Object)"HH:mm")), (Object)BoxesRunTime.boxToLong((long)37200000000000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"00:00:00", (Object)"HH:mm:ss")), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"01:02:03", (Object)"HH:mm:ss")), (Object)BoxesRunTime.boxToLong((long)3723000000000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"23:59:59", (Object)"HH:mm:ss")), (Object)BoxesRunTime.boxToLong((long)86399000000000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"00:00:00.000000", (Object)"HH:mm:ss.SSSSSS")), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"12:34:56.789012", (Object)"HH:mm:ss.SSSSSS")), (Object)BoxesRunTime.boxToLong((long)45296789012000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"23:59:59.000000", (Object)"HH:mm:ss.SSSSSS")), (Object)BoxesRunTime.boxToLong((long)86399000000000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"23:59:59.999999", (Object)"HH:mm:ss.SSSSSS")), (Object)BoxesRunTime.boxToLong((long)86399999999000L))})).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                long expectedMicros = tuple2._2$mcJ$sp();
                if (tuple22 != null) {
                    String inputStr = (String)tuple22._1();
                    String pattern = (String)tuple22._2();
                    TimeFormatter formatter = TimeFormatter$.MODULE$.apply(pattern, true);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)formatter.parse(inputStr)));
                    long $org_scalatest_assert_macro_right = expectedMicros;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("time strings do not match to the pattern", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertError$1("11.12.13", "Text '11.12.13' could not be parsed");
            this.assertError$1("25:00:00", "Text '25:00:00' could not be parsed: Invalid value");
        }, new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("time formatting", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)43200000000000L), (Object)"HH")), (Object)"12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3720000000000L), (Object)"HH:mm")), (Object)"01:02"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)37200000000000L), (Object)"HH:mm")), (Object)"10:20"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)"HH:mm:ss")), (Object)"00:00:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3723000000000L), (Object)"HH:mm:ss")), (Object)"01:02:03"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)86399000000000L), (Object)"HH:mm:ss")), (Object)"23:59:59"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)"HH:mm:ss.SSSSSS")), (Object)"00:00:00.000000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)45296789012000L), (Object)"HH:mm:ss.SSSSSS")), (Object)"12:34:56.789012"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)86399000000000L), (Object)"HH:mm:ss.SSSSSS")), (Object)"23:59:59.000000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)86399999999000L), (Object)"HH:mm:ss.SSSSSS")), (Object)"23:59:59.999999")})).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                String expectedStr = (String)tuple2._2();
                if (tuple22 != null) {
                    long micros = tuple22._1$mcJ$sp();
                    String pattern = (String)tuple22._2();
                    TimeFormatter formatter = TimeFormatter$.MODULE$.apply(pattern);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(formatter.format(micros));
                    String $org_scalatest_assert_macro_right = expectedStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("micros are out of supported range", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertError$2(-1000L, "Invalid value for NanoOfDay (valid values 0 - 86399999999999): -1000");
            this.assertError$2(90000000000000L, "Invalid value for NanoOfDay (valid values 0 - 86399999999999): 90000000000000");
        }, new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("invalid pattern", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"hHH:mmm:s", (List)new .colon.colon((Object)"kkk", (List)new .colon.colon((Object)"GGGGGG", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)invalidPattern -> {
            TimeFormatterSuite.$anonfun$new$10(this, invalidPattern);
            return BoxedUnit.UNIT;
        }), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("round trip with the default pattern: format -> parse", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq data = (Seq)scala.package$.MODULE$.Seq().tabulate(10, (Function1)(JFunction1.mcJI.sp & Serializable)x$1 -> Random$.MODULE$.between(0L, 86400000000L) * 1000L);
            String pattern = "HH:mm:ss.SSSSSS";
            Tuple2 tuple2 = new Tuple2((Object)TimeFormatter$.MODULE$.apply(pattern, false), (Object)TimeFormatter$.MODULE$.apply(pattern, true));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TimeFormatter formatter = (TimeFormatter)tuple2._1();
            TimeFormatter parser = (TimeFormatter)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)formatter, (Object)parser);
            TimeFormatter formatter2 = (TimeFormatter)tuple22._1();
            TimeFormatter parser2 = (TimeFormatter)tuple22._2();
            data.foreach((Function1 & Serializable)nanos -> TimeFormatterSuite.$anonfun$new$14(this, formatter2, parser2, BoxesRunTime.unboxToLong((Object)nanos)));
        }, new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("format fraction of second", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FractionTimeFormatter formatter = new FractionTimeFormatter();
            new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"00:00:00"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"00:00:00.000001"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1000)), (Object)"00:00:00.001"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)900000)), (Object)"00:00:00.9"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1000000)), (Object)"00:00:01"), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    int micros = tuple2._1$mcI$sp();
                    String tsStr = (String)tuple2._2();
                    long nanos = (long)micros * 1000L;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(formatter.format(nanos));
                    String $org_scalatest_assert_macro_right = tsStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(formatter.format(DateTimeUtils$.MODULE$.nanosToLocalTime(nanos)));
                    String $org_scalatest_assert_macro_right2 = tsStr;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("missing am/pm field", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"HH", (List)new .colon.colon((Object)"hh", (List)new .colon.colon((Object)"KK", (List)new .colon.colon((Object)"kk", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)hour -> {
            TimeFormatter formatter = TimeFormatter$.MODULE$.apply(hour + ":mm:ss", true);
            long micros = formatter.parse("11:30:01");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.localTime((byte)11, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("missing hour field", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimeFormatter f1 = TimeFormatter$.MODULE$.apply("mm:ss a", true);
            long t1 = f1.parse("30:01 PM");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t1));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.localTime((byte)12, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            long t2 = f1.parse("30:01 AM");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t2));
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            TimeFormatter f2 = TimeFormatter$.MODULE$.apply("mm:ss", true);
            long t3 = f2.parse("30:01");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t3));
            long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.localTime((byte)0, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            TimeFormatter f3 = TimeFormatter$.MODULE$.apply("a", true);
            long t4 = f3.parse("PM");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t4));
            long $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.localTime((byte)12, DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            long t5 = f3.parse("AM");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t5));
            long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.localTime(DateTimeTestUtils$.MODULE$.localTime$default$1(), DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("default parsing w/o pattern", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DefaultTimeFormatter formatter = new DefaultTimeFormatter(DateFormatter$.MODULE$.defaultLocale(), true);
            boolean x$7 = true;
            byte x$8 = DateTimeTestUtils$.MODULE$.localTime$default$1();
            byte x$9 = DateTimeTestUtils$.MODULE$.localTime$default$2();
            byte x$10 = DateTimeTestUtils$.MODULE$.localTime$default$3();
            new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"00:00:00"), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(DateTimeTestUtils$.MODULE$.localTime$default$1(), DateTimeTestUtils$.MODULE$.localTime$default$2(), DateTimeTestUtils$.MODULE$.localTime$default$3(), DateTimeTestUtils$.MODULE$.localTime$default$4()))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"00:00:00.000001"), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime(x$8, x$9, x$10, 1))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"01:02:03"), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)2, (byte)3, DateTimeTestUtils$.MODULE$.localTime$default$4()))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1:2:3.999999"), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)1, (byte)2, (byte)3, 999999))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"23:59:59.1"), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.localTime((byte)23, (byte)59, (byte)59, 100000))), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    String inputStr = (String)tuple2._1();
                    long micros = tuple2._2$mcJ$sp();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)formatter.parse(inputStr)));
                    long $org_scalatest_assert_macro_right = micros;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
                }
                throw new MatchError((Object)tuple2);
            });
            SparkDateTimeException x$11 = (SparkDateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("x123"), ClassTag$.MODULE$.apply(SparkDateTimeException.class), new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            String x$12 = "CAST_INVALID_INPUT";
            Map x$13 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)"'x123'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"TIME(6)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)"\"spark.sql.ansi.enabled\"")}));
            Option x$14 = this.checkError$default$3();
            boolean x$15 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$16 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$11, "CAST_INVALID_INPUT", x$14, x$13, x$15, x$16);
        }, new Position("TimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
    }
}

