/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.DatetimeFormatterSuite;
import org.apache.spark.sql.catalyst.util.DefaultTimestampFormatter;
import org.apache.spark.sql.catalyst.util.Iso8601TimestampFormatter;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.LegacyFastTimestampFormatter;
import org.apache.spark.sql.catalyst.util.LegacySimpleTimestampFormatter;
import org.apache.spark.sql.catalyst.util.LegacySimpleTimestampFormatter$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Entry;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.dsl.BeWord;
import org.scalatest.matchers.dsl.ContainWord;
import org.scalatest.matchers.dsl.DefinedWord;
import org.scalatest.matchers.dsl.EmptyWord;
import org.scalatest.matchers.dsl.EndWithWord;
import org.scalatest.matchers.dsl.ExistWord;
import org.scalatest.matchers.dsl.FullyMatchWord;
import org.scalatest.matchers.dsl.HaveWord;
import org.scalatest.matchers.dsl.IncludeWord;
import org.scalatest.matchers.dsl.LengthWord;
import org.scalatest.matchers.dsl.MatchPatternWord;
import org.scalatest.matchers.dsl.MatcherFactory1;
import org.scalatest.matchers.dsl.MatcherWords;
import org.scalatest.matchers.dsl.NoExceptionWord;
import org.scalatest.matchers.dsl.NotWord;
import org.scalatest.matchers.dsl.ReadableWord;
import org.scalatest.matchers.dsl.ResultOfATypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAllElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfAllOfApplication;
import org.scalatest.matchers.dsl.ResultOfAnTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfDefinedAt;
import org.scalatest.matchers.dsl.ResultOfGreaterThanComparison;
import org.scalatest.matchers.dsl.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfInOrderApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfLessThanComparison;
import org.scalatest.matchers.dsl.ResultOfLessThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfMessageWordApplication;
import org.scalatest.matchers.dsl.ResultOfNoElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfNoneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOfTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfThrownByApplication;
import org.scalatest.matchers.dsl.SizeWord;
import org.scalatest.matchers.dsl.SortedWord;
import org.scalatest.matchers.dsl.StartWithWord;
import org.scalatest.matchers.dsl.WritableWord;
import org.scalatest.matchers.must.Matchers;
import org.scalatest.matchers.must.Matchers$AtLeastCollected$;
import org.scalatest.matchers.must.Matchers$AtMostCollected$;
import org.scalatest.matchers.must.Matchers$BetweenCollected$;
import org.scalatest.matchers.must.Matchers$ExactlyCollected$;
import org.scalatest.verbs.CompileWord;
import org.scalatest.verbs.MustVerb;
import org.scalatest.verbs.TypeCheckWord;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005i2A\u0001B\u0003\u0001%!)1\u0004\u0001C\u00019!)a\u0004\u0001C!?!)\u0001\b\u0001C)s\t9B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s'VLG/\u001a\u0006\u0003\r\u001d\tA!\u001e;jY*\u0011\u0001\"C\u0001\tG\u0006$\u0018\r\\=ti*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\f\u0011\u0005Q)R\"A\u0006\n\u0005YY!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001935\tQ!\u0003\u0002\u001b\u000b\t1B)\u0019;fi&lWMR8s[\u0006$H/\u001a:Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011\u0001\u0004A\u0001\u0017G\",7m\u001b$pe6\fG\u000f^3s\u0007J,\u0017\r^5p]R\u0019\u0001EJ\u001a\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006O\t\u0001\r\u0001K\u0001\ba\u0006$H/\u001a:o!\tI\u0003G\u0004\u0002+]A\u00111FI\u0007\u0002Y)\u0011Q&E\u0001\u0007yI|w\u000e\u001e \n\u0005=\u0012\u0013A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\u0012\t\u000bQ\u0012\u0001\u0019A\u001b\u0002\u0013%\u001c\b+\u0019:tS:<\u0007CA\u00117\u0013\t9$EA\u0004C_>dW-\u00198\u0002!U\u001cX\rR1uK\u001a{'/\\1ui\u0016\u0014X#A\u001b")
public class TimestampFormatterSuite
extends SparkFunSuite
implements DatetimeFormatterSuite {
    private Matchers.KeyWord key;
    private Matchers.ValueWord value;
    private Matchers.AWord a;
    private Matchers.AnWord an;
    private Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private Matchers.RegexWord regex;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    private Explicitly.DecidedWord decided;
    private Explicitly.DeterminedWord determined;
    private Explicitly.TheAfterWord after;
    private FullyMatchWord fullyMatch;
    private StartWithWord startWith;
    private EndWithWord endWith;
    private IncludeWord include;
    private HaveWord have;
    private BeWord be;
    private ContainWord contain;
    private NotWord not;
    private LengthWord length;
    private SizeWord size;
    private SortedWord sorted;
    private DefinedWord defined;
    private ExistWord exist;
    private ReadableWord readable;
    private WritableWord writable;
    private EmptyWord empty;
    private CompileWord compile;
    private TypeCheckWord typeCheck;
    private MatchPatternWord matchPattern;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(Iterable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(Iterable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(Iterable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(Iterable<Object> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(Iterable<Object> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(Iterable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(Iterable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(Iterable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, Iterable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyMustWrapper<T> convertToAnyMustWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyMustWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringMustWrapper convertToStringMustWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringMustWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public MustVerb.StringMustWrapperForVerb convertToStringMustWrapperForVerb(String o, Position position) {
        return MustVerb.convertToStringMustWrapperForVerb$((MustVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected() {
        return this.org$scalatest$matchers$must$Matchers$$AllCollected;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected() {
        return this.org$scalatest$matchers$must$Matchers$$EveryCollected;
    }

    public Matchers$BetweenCollected$ org$scalatest$matchers$must$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$matchers$must$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$matchers$must$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected() {
        return this.org$scalatest$matchers$must$Matchers$$NoCollected;
    }

    public Matchers$ExactlyCollected$ org$scalatest$matchers$must$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper() {
        return this.org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$AllCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$AllCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$EveryCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$EveryCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$NoCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$NoCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$MustMethodHelper_$eq(Matchers.MustMethodHelperClass x$1) {
        this.org$scalatest$matchers$must$Matchers$$MustMethodHelper = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    private String sparkHome$lzycompute() {
        TimestampFormatterSuite timestampFormatterSuite = this;
        synchronized (timestampFormatterSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    @Override
    public void checkFormatterCreation(String pattern, boolean isParsing) {
        TimestampFormatter$.MODULE$.apply(pattern, DateTimeTestUtils$.MODULE$.UTC(), isParsing);
    }

    @Override
    public boolean useDateFormatter() {
        return false;
    }

    private final void org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1() {
        TimestampFormatterSuite timestampFormatterSuite = this;
        synchronized (timestampFormatterSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1() {
        TimestampFormatterSuite timestampFormatterSuite = this;
        synchronized (timestampFormatterSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1() {
        TimestampFormatterSuite timestampFormatterSuite = this;
        synchronized (timestampFormatterSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1() {
        TimestampFormatterSuite timestampFormatterSuite = this;
        synchronized (timestampFormatterSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$5(TimestampFormatterSuite $this, long microsSinceEpoch$1, scala.collection.immutable.Map expectedTimestamp$1, String zoneId) {
        new .colon.colon((Object)TimestampFormatter$.MODULE$.apply("yyyy-MM-dd HH:mm:ss.SSSSSS", DateTimeUtils$.MODULE$.getZoneId(zoneId), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false), (List)new .colon.colon((Object)TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(zoneId)), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)formatter -> {
            String timestamp = formatter.format(microsSinceEpoch$1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(timestamp);
            String $org_scalatest_assert_macro_right = (String)expectedTimestamp$1.apply((Object)zoneId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(formatter.format(DateTimeUtils$.MODULE$.microsToInstant(microsSinceEpoch$1)));
            String $org_scalatest_assert_macro_right2 = (String)expectedTimestamp$1.apply((Object)zoneId);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(formatter.format(DateTimeUtils$.MODULE$.toJavaTimestamp(microsSinceEpoch$1)));
            String $org_scalatest_assert_macro_right3 = (String)expectedTimestamp$1.apply((Object)zoneId);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        });
    }

    public static final /* synthetic */ void $anonfun$new$8(TimestampFormatterSuite $this, String pattern) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-58710115316212000L, -18926315945345679L, -9463427405253013L, -244000001L, 0L, 99628200102030L, 1543749753123456L, 2177456523456789L, 11858049903010203L})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)micros -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zoneId -> {
            String timestamp = TimestampFormatter$.MODULE$.apply(pattern, zoneId, false).format(micros);
            long parsed = TimestampFormatter$.MODULE$.apply(pattern, zoneId, true).parse(timestamp);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
            long $org_scalatest_assert_macro_right = parsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$12(TimestampFormatterSuite $this, String timestamp) {
        DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zoneId -> {
            String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS";
            long micros = TimestampFormatter$.MODULE$.apply(pattern, zoneId, true).parse(timestamp);
            String formatted = TimestampFormatter$.MODULE$.apply(pattern, zoneId, false).format(micros);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(timestamp);
            String $org_scalatest_assert_macro_right = formatted;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        });
    }

    private final void check$1(String pattern, String input, String reference, ZoneId zoneId$2) {
        TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply(pattern, zoneId$2, true);
        long expected = BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)reference), zoneId$2).get());
        long actual = formatter.parse(input);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)actual));
        long $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
    }

    private final void check$2(String pattern, String input, String expected, ZoneId zoneId$3) {
        TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply(pattern, zoneId$3, false);
        long timestamp = BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)input), zoneId$3).get());
        String actual = formatter.format(timestamp);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
        String $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
    }

    public static final /* synthetic */ void $anonfun$new$23(TimestampFormatterSuite $this, ZoneId zoneId) {
        $this.check$2("yyyy-MM-dd HH:mm:ss.SSSSSSS", "2019-10-14T09:39:07.123456", "2019-10-14 09:39:07.1234560", zoneId);
        $this.check$2("yyyy-MM-dd HH:mm:ss.SSSSSS", "1960-01-01T09:39:07.123456", "1960-01-01 09:39:07.123456", zoneId);
        $this.check$2("yyyy-MM-dd HH:mm:ss.SSSSS", "0001-10-14T09:39:07.1", "0001-10-14 09:39:07.10000", zoneId);
        $this.check$2("yyyy-MM-dd HH:mm:ss.SSSS", "9999-12-31T23:59:59.999", "9999-12-31 23:59:59.9990", zoneId);
        $this.check$2("yyyy-MM-dd HH:mm:ss.SSS", "1970-01-01T00:00:00.0101", "1970-01-01 00:00:00.010", zoneId);
        $this.check$2("yyyy-MM-dd HH:mm:ss.SS", "2019-10-14T09:39:07.09", "2019-10-14 09:39:07.09", zoneId);
        $this.check$2("yyyy-MM-dd HH:mm:ss.S", "2019-10-14T09:39:07.2", "2019-10-14 09:39:07.2", zoneId);
        $this.check$2("yyyy-MM-dd HH:mm:ss.S", "2019-10-14T09:39:07", "2019-10-14 09:39:07.0", zoneId);
        $this.check$2("yyyy-MM-dd HH:mm:ss", "2019-10-14T09:39:07.123456", "2019-10-14 09:39:07", zoneId);
    }

    private final void assertParsingError$1(Function0 f) {
        Exception exception = (Exception)this.intercept(f, ClassTag$.MODULE$.apply(Exception.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        if (exception instanceof SparkUpgradeException) {
            SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)exception;
            Throwable $org_scalatest_assert_macro_left = sparkUpgradeException.getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.time.DateTimeException", $org_scalatest_assert_macro_left instanceof DateTimeException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            return;
        }
        Exception $org_scalatest_assert_macro_left = exception;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.time.DateTimeException", $org_scalatest_assert_macro_left instanceof DateTimeException, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
    }

    private static final TimestampFormatter createFormatter$1(String pattern) {
        return TimestampFormatter$.MODULE$.apply(pattern, DateTimeTestUtils$.MODULE$.UTC(), LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT(), true);
    }

    public TimestampFormatterSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        Tolerance.$init$((Tolerance)this);
        MustVerb.$init$((MustVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        DatetimeFormatterSuite.$init$(this);
        this.test("parsing timestamps using time zones", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)"EXCEPTION")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String localDate = "2018-12-02T10:11:12.001234";
            scala.collection.immutable.Map expectedMicros = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UTC"), (Object)BoxesRunTime.boxToLong((long)1543745472001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateTimeTestUtils$.MODULE$.PST().getId()), (Object)BoxesRunTime.boxToLong((long)1543774272001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateTimeTestUtils$.MODULE$.CET().getId()), (Object)BoxesRunTime.boxToLong((long)1543741872001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Africa/Dakar"), (Object)BoxesRunTime.boxToLong((long)1543745472001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"America/Los_Angeles"), (Object)BoxesRunTime.boxToLong((long)1543774272001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Asia/Urumqi"), (Object)BoxesRunTime.boxToLong((long)1543723872001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Asia/Hong_Kong"), (Object)BoxesRunTime.boxToLong((long)1543716672001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Europe/Brussels"), (Object)BoxesRunTime.boxToLong((long)1543741872001234L))}));
            DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable)zoneId -> {
                TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", DateTimeUtils$.MODULE$.getZoneId(zoneId), true);
                long microsSinceEpoch = formatter.parse(localDate);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)microsSinceEpoch));
                long $org_scalatest_assert_macro_right = BoxesRunTime.unboxToLong((Object)expectedMicros.apply(zoneId));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            });
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("format timestamps using time zones", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long microsSinceEpoch = 1543745472001234L;
            scala.collection.immutable.Map expectedTimestamp = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UTC"), (Object)"2018-12-02 10:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateTimeTestUtils$.MODULE$.PST().getId()), (Object)"2018-12-02 02:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateTimeTestUtils$.MODULE$.CET().getId()), (Object)"2018-12-02 11:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Africa/Dakar"), (Object)"2018-12-02 10:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"America/Los_Angeles"), (Object)"2018-12-02 02:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Asia/Urumqi"), (Object)"2018-12-02 16:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Asia/Hong_Kong"), (Object)"2018-12-02 18:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Europe/Brussels"), (Object)"2018-12-02 11:11:12.001234")}));
            DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable)zoneId -> {
                TimestampFormatterSuite.$anonfun$new$5(this, microsSinceEpoch, expectedTimestamp, zoneId);
                return BoxedUnit.UNIT;
            });
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("roundtrip micros -> timestamp -> micros using timezones", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"yyyy-MM-dd'T'HH:mm:ss.SSSSSS", (List)new .colon.colon((Object)"yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXXXX", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)pattern -> {
            TimestampFormatterSuite.$anonfun$new$8(this, pattern);
            return BoxedUnit.UNIT;
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("roundtrip timestamp -> micros -> timestamp using timezones", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0109-07-20T18:38:03.788000", "1370-04-01T10:00:54.654321", "1670-02-11T14:09:54.746987", "1969-12-31T23:55:55.999999", "1970-01-01T00:00:00.000000", "1973-02-27T02:30:00.102030", "2018-12-02T11:22:33.123456", "2039-01-01T01:02:03.456789", "2345-10-07T22:45:03.010203"})).foreach((Function1 & Serializable)timestamp -> {
            TimestampFormatterSuite.$anonfun$new$12(this, timestamp);
            return BoxedUnit.UNIT;
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("case insensitive parsing of am and pm", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy MMM dd hh:mm:ss a", DateTimeTestUtils$.MODULE$.UTC(), false);
            long micros = formatter.parse("2009 Mar 20 11:30:01 am");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2009, (byte)3, (byte)20, (byte)11, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("format fraction of second", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeTestUtils$.MODULE$.UTC());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-999999)), (Object)"1969-12-31 23:59:59.000001"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-999900)), (Object)"1969-12-31 23:59:59.0001"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-1)), (Object)"1969-12-31 23:59:59.999999"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"1970-01-01 00:00:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"1970-01-01 00:00:00.000001"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1000)), (Object)"1970-01-01 00:00:00.001"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)900000)), (Object)"1970-01-01 00:00:00.9"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1000000)), (Object)"1970-01-01 00:00:01")})).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int micros = tuple2._1$mcI$sp();
                    String tsStr = (String)tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(formatter.format((long)micros));
                    String $org_scalatest_assert_macro_right = tsStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(formatter.format(DateTimeUtils$.MODULE$.microsToInstant((long)micros)));
                    String $org_scalatest_assert_macro_right2 = tsStr;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                    return (Assertion)DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (Function0 & Serializable)() -> {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(formatter.format(DateTimeUtils$.MODULE$.toJavaTimestamp((long)micros)));
                        String $org_scalatest_assert_macro_right = tsStr;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("formatting negative years with default pattern", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Instant instant = LocalDateTime.of(-99, 1, 1, 0, 0, 0).atZone(DateTimeTestUtils$.MODULE$.UTC()).toInstant();
            long micros = DateTimeUtils$.MODULE$.instantToMicros(instant);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TimestampFormatter$.MODULE$.apply(DateTimeTestUtils$.MODULE$.UTC()).format(micros));
            String $org_scalatest_assert_macro_right = "-0099-01-01 00:00:00";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(TimestampFormatter$.MODULE$.apply(DateTimeTestUtils$.MODULE$.UTC()).format(instant));
            String $org_scalatest_assert_macro_right2 = "-0099-01-01 00:00:00";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            return (Assertion)DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (Function0 & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TimestampFormatter$.MODULE$.apply("yyyy-MM-dd HH:mm:SS G", DateTimeTestUtils$.MODULE$.UTC(), false).format(DateTimeUtils$.MODULE$.toJavaTimestamp(micros)));
                String $org_scalatest_assert_macro_right = "0100-01-01 00:00:00 BC";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            });
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("parsing timestamp strings with various seconds fractions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zoneId -> {
            this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSXXX", "2019-10-14T09:39:07.3220000Z", "2019-10-14T09:39:07.322Z", (ZoneId)zoneId);
            this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", "2019-10-14T09:39:07.322000", "2019-10-14T09:39:07.322", (ZoneId)zoneId);
            this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSSSSX", "2019-10-14T09:39:07.123456Z", "2019-10-14T09:39:07.123456Z", (ZoneId)zoneId);
            this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSSSSX", "2019-10-14T09:39:07.000010Z", "2019-10-14T09:39:07.00001Z", (ZoneId)zoneId);
            this.check$1("yyyy HH:mm:ss.SSSSS", "1970 01:02:03.00004", "1970-01-01 01:02:03.00004", (ZoneId)zoneId);
            this.check$1("yyyy HH:mm:ss.SSSS", "2019 00:00:07.0100", "2019-01-01 00:00:07.0100", (ZoneId)zoneId);
            this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSX", "2019-10-14T09:39:07.322Z", "2019-10-14T09:39:07.322Z", (ZoneId)zoneId);
            this.check$1("yyyy-MM-dd'T'HH:mm:ss.SS", "2019-10-14T09:39:07.10", "2019-10-14T09:39:07.1", (ZoneId)zoneId);
            this.check$1("yyyy-MM-dd'T'HH:mm:ss.S", "2019-10-14T09:39:07.1", "2019-10-14T09:39:07.1", (ZoneId)zoneId);
            try {
                TimestampFormatter$.MODULE$.apply("yyyy/MM/dd HH_mm_ss.SSSSSS", zoneId, true).parse("2019/11/14 20#25#30.123456");
                throw this.fail("Expected to throw an exception for the invalid input", new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            }
            catch (DateTimeParseException e) {
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "could not be parsed";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            }
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("formatting timestamp strings up to microsecond precision", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zoneId -> {
            TimestampFormatterSuite.$anonfun$new$23(this, zoneId);
            return BoxedUnit.UNIT;
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("SPARK-30958: parse timestamp with negative year", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimestampFormatter formatter1 = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd HH:mm:ss", DateTimeTestUtils$.MODULE$.UTC(), true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)formatter1.parse("-1234-02-22 02:22:22")));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(-1234, (byte)2, (byte)22, (byte)2, (byte)22, (byte)22, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            TimestampFormatter formatter2 = TimestampFormatter$.MODULE$.apply("G yyyy-MM-dd HH:mm:ss", DateTimeTestUtils$.MODULE$.UTC(), true);
            this.assertParsingError$1((Function0)(JFunction0.mcV.sp & Serializable)() -> formatter2.parse("BC -1234-02-22 02:22:22"));
            this.assertParsingError$1((Function0)(JFunction0.mcV.sp & Serializable)() -> formatter2.parse("AC 0000-02-22 02:22:22"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)formatter2.parse("BC 1234-02-22 02:22:22")));
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(-1233, (byte)2, (byte)22, (byte)2, (byte)22, (byte)22, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)formatter2.parse("AD 1234-02-22 02:22:22")));
            long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.date(1234, (byte)2, (byte)22, (byte)2, (byte)22, (byte)22, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        this.test("SPARK-31557: rebasing in legacy formatters/parsers", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)LegacyBehaviorPolicy$.MODULE$.LEGACY().toString())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zoneId -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)zoneId.getId())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zoneId, (JFunction0.mcV.sp & Serializable)() -> this.withClue("zoneId = " + zoneId.getId(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Seq formatters = (Seq)((SeqOps)LegacyDateFormats$.MODULE$.values().toSeq().map((Function1 & Serializable)legacyFormat -> TimestampFormatter$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern(), zoneId, TimestampFormatter$.MODULE$.defaultLocale(), legacyFormat, false))).$colon$plus((Object)TimestampFormatter$.MODULE$.getFractionFormatter(zoneId));
                formatters.foreach((Function1 & Serializable)formatter -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(DateTimeUtils$.MODULE$.microsToInstant(formatter.parse("1000-01-01 01:02:03")).atZone(zoneId).toLocalDateTime());
                    LocalDateTime $org_scalatest_assert_macro_right = LocalDateTime.of(1000, 1, 1, 1, 2, 3);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(formatter.format(LocalDateTime.of(1000, 1, 1, 1, 2, 3).atZone(zoneId).toInstant()));
                    String $org_scalatest_assert_macro_right2 = "1000-01-01 01:02:03";
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(formatter.format(DateTimeUtils$.MODULE$.instantToMicros(LocalDateTime.of(1000, 1, 1, 1, 2, 3).atZone(zoneId).toInstant())));
                    String $org_scalatest_assert_macro_right3 = "1000-01-01 01:02:03";
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(formatter.format(Timestamp.valueOf("1000-01-01 01:02:03")));
                    String $org_scalatest_assert_macro_right4 = "1000-01-01 01:02:03";
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
                });
            })));
            return BoxedUnit.UNIT;
        })), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("SPARK-49065: rebasing in legacy formatters/parsers with non-default time zone", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ZoneId defaultTimeZone = DateTimeTestUtils$.MODULE$.LA();
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)LegacyBehaviorPolicy$.MODULE$.LEGACY().toString())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zoneId -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)defaultTimeZone.getId())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(defaultTimeZone, (JFunction0.mcV.sp & Serializable)() -> this.withClue("zoneId = " + zoneId.getId(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Seq formatters = (Seq)((SeqOps)LegacyDateFormats$.MODULE$.values().toSeq().map((Function1 & Serializable)legacyFormat -> TimestampFormatter$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern(), zoneId, TimestampFormatter$.MODULE$.defaultLocale(), legacyFormat, false))).$colon$plus((Object)TimestampFormatter$.MODULE$.getFractionFormatter(zoneId));
                    formatters.foreach((Function1 & Serializable)formatter -> {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(DateTimeUtils$.MODULE$.microsToInstant(formatter.parse("1000-01-01 01:02:03")).atZone(zoneId).toLocalDateTime());
                        LocalDateTime $org_scalatest_assert_macro_right = LocalDateTime.of(1000, 1, 1, 1, 2, 3);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(formatter.format(LocalDateTime.of(1000, 1, 1, 1, 2, 3).atZone(zoneId).toInstant()));
                        String $org_scalatest_assert_macro_right2 = "1000-01-01 01:02:03";
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(formatter.format(DateTimeUtils$.MODULE$.instantToMicros(LocalDateTime.of(1000, 1, 1, 1, 2, 3).atZone(zoneId).toInstant())));
                        String $org_scalatest_assert_macro_right3 = "1000-01-01 01:02:03";
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
                    });
                })));
                return BoxedUnit.UNIT;
            }));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        this.test("parsing hour with various patterns", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.withClue("HH", (Function0 & Serializable)() -> {
                TimestampFormatter formatter = TimestampFormatterSuite.createFormatter$1("yyyy-MM-dd HH");
                long micros1 = formatter.parse("2009-12-12 00");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros1));
                long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2009, (byte)12, (byte)12, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
                long micros2 = formatter.parse("2009-12-12 15");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros2));
                long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2009, (byte)12, (byte)12, (byte)15, DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
                return (DateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("2009-12-12 24"), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            });
            this.withClue("kk", (Function0 & Serializable)() -> {
                TimestampFormatter formatter = TimestampFormatterSuite.createFormatter$1("yyyy-MM-dd kk");
                this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("2009-12-12 00"), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
                long micros1 = formatter.parse("2009-12-12 15");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros1));
                long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2009, (byte)12, (byte)12, (byte)15, DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
                long micros2 = formatter.parse("2009-12-12 24");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros2));
                long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2009, (byte)12, (byte)12, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            });
            this.withClue("KK", (Function0 & Serializable)() -> {
                TimestampFormatter formatter = TimestampFormatterSuite.createFormatter$1("yyyy-MM-dd KK a");
                long micros1 = formatter.parse("2009-12-12 00 am");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros1));
                long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2009, (byte)12, (byte)12, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
                this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("2009-12-12 12 am"), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
                long micros3 = formatter.parse("2009-12-12 00 pm");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros3));
                long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2009, (byte)12, (byte)12, (byte)12, DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
                return (DateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("2009-12-12 12 pm"), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            });
            return (Assertion)this.withClue("hh", (Function0 & Serializable)() -> {
                TimestampFormatter formatter = TimestampFormatterSuite.createFormatter$1("yyyy-MM-dd hh a");
                this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("2009-12-12 00 am"), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
                long micros1 = formatter.parse("2009-12-12 12 am");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros1));
                long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2009, (byte)12, (byte)12, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
                this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("2009-12-12 00 pm"), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
                long micros2 = formatter.parse("2009-12-12 12 pm");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros2));
                long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2009, (byte)12, (byte)12, (byte)12, DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            });
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("missing date fields", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("HH:mm:ss", DateTimeTestUtils$.MODULE$.UTC(), true);
            long micros = formatter.parse("11:30:01");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(1970, (byte)1, (byte)1, (byte)11, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        this.test("missing year field with invalid date", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("MM-dd", DateTimeTestUtils$.MODULE$.UTC(), LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT(), true);
            return (DateTimeException)DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (Function0 & Serializable)() -> (DateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("02-29"), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406)));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        this.test("missing am/pm field", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"HH", (List)new .colon.colon((Object)"hh", (List)new .colon.colon((Object)"KK", (List)new .colon.colon((Object)"kk", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)hour -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy " + hour + ":mm:ss", DateTimeTestUtils$.MODULE$.UTC(), true);
            long micros = formatter.parse("2009 11:30:01");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2009, (byte)1, (byte)1, (byte)11, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("missing time fields", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy HH", DateTimeTestUtils$.MODULE$.UTC(), true);
            long micros = formatter.parse("2009 11");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2009, (byte)1, (byte)1, (byte)11, DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        this.test("missing hour field", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimestampFormatter f1 = TimestampFormatter$.MODULE$.apply("mm:ss a", DateTimeTestUtils$.MODULE$.UTC(), true);
            long t1 = f1.parse("30:01 PM");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t1));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(1970, (byte)1, (byte)1, (byte)12, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
            long t2 = f1.parse("30:01 AM");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t2));
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(1970, (byte)1, (byte)1, (byte)0, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
            TimestampFormatter f2 = TimestampFormatter$.MODULE$.apply("mm:ss", DateTimeTestUtils$.MODULE$.UTC(), true);
            long t3 = f2.parse("30:01");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t3));
            long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.date(1970, (byte)1, (byte)1, (byte)0, (byte)30, (byte)1, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
            TimestampFormatter f3 = TimestampFormatter$.MODULE$.apply("a", DateTimeTestUtils$.MODULE$.UTC(), true);
            long t4 = f3.parse("PM");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t4));
            long $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.date(1970, (byte)1, (byte)1, (byte)12, DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            long t5 = f3.parse("AM");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t5));
            long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.date(1970, DateTimeTestUtils$.MODULE$.date$default$2(), DateTimeTestUtils$.MODULE$.date$default$3(), DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        this.test("check result differences for datetime formatting", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("DD", DateTimeTestUtils$.MODULE$.UTC(), false);
            String $org_scalatest_assert_macro_left = formatter.format(DateTimeTestUtils$.MODULE$.date(1970, (byte)1, (byte)3, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            String $org_scalatest_assert_macro_right = "03";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
            String $org_scalatest_assert_macro_left2 = formatter.format(DateTimeTestUtils$.MODULE$.date(1970, (byte)4, (byte)9, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            String $org_scalatest_assert_macro_right2 = "99";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            String $org_scalatest_assert_macro_left3 = formatter.format(DateTimeTestUtils$.MODULE$.date(1970, (byte)4, (byte)10, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            String $org_scalatest_assert_macro_right3 = "100";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("SPARK-32424: avoid silent data change when timestamp overflows", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("y", DateTimeTestUtils$.MODULE$.UTC(), true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)formatter.parse("294247")));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(294247, DateTimeTestUtils$.MODULE$.date$default$2(), DateTimeTestUtils$.MODULE$.date$default$3(), DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)formatter.parse("-290307")));
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(-290307, DateTimeTestUtils$.MODULE$.date$default$2(), DateTimeTestUtils$.MODULE$.date$default$3(), DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
            ArithmeticException e1 = (ArithmeticException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("294248"), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(e1.getMessage());
            String $org_scalatest_assert_macro_right3 = "long overflow";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            ArithmeticException e2 = (ArithmeticException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("-290308"), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(e2.getMessage());
            String $org_scalatest_assert_macro_right4 = "long overflow";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
        this.test("SPARK-36418: default parsing w/o pattern", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zoneId -> {
            String errMsg;
            DefaultTimestampFormatter formatter = new DefaultTimestampFormatter(zoneId, DateFormatter$.MODULE$.defaultLocale(), LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT(), true);
            new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-0042-3-4"), (Object)LocalDateTime.of(-42, 3, 4, 0, 0, 0)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1000"), (Object)LocalDateTime.of(1000, 1, 1, 0, 0, 0)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1582-10-4"), (Object)LocalDateTime.of(1582, 10, 4, 0, 0, 0)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1583-1-1 "), (Object)LocalDateTime.of(1583, 1, 1, 0, 0, 0)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1970-01-1 01:02:3"), (Object)LocalDateTime.of(1970, 1, 1, 1, 2, 3)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"2021-8-12T18:31:50"), (Object)LocalDateTime.of(2021, 8, 12, 18, 31, 50)), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String inputStr = (String)tuple2._1();
                    LocalDateTime ldt = (LocalDateTime)tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)formatter.parse(inputStr)));
                    long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.localDateTimeToMicros(ldt, (ZoneId)zoneId);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
                }
                throw new MatchError((Object)tuple2);
            });
            String $org_scalatest_assert_macro_left = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parse("x123"), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474))).getMessage();
            String $org_scalatest_assert_macro_right = "The value 'x123' of the type \"STRING\" cannot be cast to \"TIMESTAMP\"";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        this.test("SPARK-39193: support returning optional parse results in the default formatter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DefaultTimestampFormatter formatter = new DefaultTimestampFormatter(DateTimeTestUtils$.MODULE$.LA(), DateFormatter$.MODULE$.defaultLocale(), LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT(), true);
            Option $org_scalatest_assert_macro_left = formatter.parseOptional("2021-01-01T00:00:00");
            long $org_scalatest_assert_macro_right = 1609488000000000L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
            Option $org_scalatest_assert_macro_left2 = formatter.parseWithoutTimeZoneOptional("2021-01-01T00:00:00", false);
            long $org_scalatest_assert_macro_right2 = 1609459200000000L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
            Option $org_scalatest_assert_macro_left3 = formatter.parseOptional("abc");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
            Option $org_scalatest_assert_macro_left4 = formatter.parseWithoutTimeZoneOptional("abc", false);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        this.test("SPARK-39280: support returning optional parse results in the iso8601 formatter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String x$1 = "yyyy-MM-dd HH:mm:ss.SSSS";
            Locale x$2 = DateFormatter$.MODULE$.defaultLocale();
            Enumeration.Value x$3 = LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT();
            boolean x$4 = true;
            ZoneId x$5 = DateTimeTestUtils$.MODULE$.LA();
            Iso8601TimestampFormatter formatter = new Iso8601TimestampFormatter("yyyy-MM-dd HH:mm:ss.SSSS", x$5, x$2, x$3, true);
            Option $org_scalatest_assert_macro_left = formatter.parseOptional("9999-12-31 23:59:59.9990");
            long $org_scalatest_assert_macro_right = 253402329599999000L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            Option $org_scalatest_assert_macro_left2 = formatter.parseWithoutTimeZoneOptional("9999-12-31 23:59:59.9990", false);
            long $org_scalatest_assert_macro_right2 = 253402300799999000L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
            Option $org_scalatest_assert_macro_left3 = formatter.parseOptional("abc");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
            Option $org_scalatest_assert_macro_left4 = formatter.parseWithoutTimeZoneOptional("abc", false);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
            Option $org_scalatest_assert_macro_left5 = formatter.parseOptional("2012-00-65 23:59:59.9990");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
            Option $org_scalatest_assert_macro_left6 = formatter.parseWithoutTimeZoneOptional("2012-00-65 23:59:59.9990", false);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        this.test("SPARK-39281: support returning optional parse results in the legacy formatter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String x$6 = "yyyy-MM-dd HH:mm:ss.SSSS";
            Locale x$7 = DateFormatter$.MODULE$.defaultLocale();
            ZoneId x$8 = DateTimeTestUtils$.MODULE$.UTC();
            LegacyFastTimestampFormatter fastFormatter = new LegacyFastTimestampFormatter("yyyy-MM-dd HH:mm:ss.SSSS", x$8, x$7);
            String x$9 = "yyyy-MM-dd HH:mm:ss.SSSS";
            Locale x$10 = DateFormatter$.MODULE$.defaultLocale();
            ZoneId x$11 = DateTimeTestUtils$.MODULE$.UTC();
            boolean x$12 = LegacySimpleTimestampFormatter$.MODULE$.$lessinit$greater$default$4();
            LegacySimpleTimestampFormatter simpleFormatter = new LegacySimpleTimestampFormatter("yyyy-MM-dd HH:mm:ss.SSSS", x$11, x$10, x$12);
            Option $org_scalatest_assert_macro_left = fastFormatter.parseOptional("2023-12-31 23:59:59.9990");
            long $org_scalatest_assert_macro_right = 1704067199999000L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
            Option $org_scalatest_assert_macro_left2 = fastFormatter.parseOptional("abc");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            Option $org_scalatest_assert_macro_left3 = fastFormatter.parseOptional("23012150952");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
            Option $org_scalatest_assert_macro_left4 = simpleFormatter.parseOptional("2023-12-31 23:59:59.9990");
            long $org_scalatest_assert_macro_right2 = 1704067208990000L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left4.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            Option $org_scalatest_assert_macro_left5 = simpleFormatter.parseOptional("abc");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
            Option $org_scalatest_assert_macro_left6 = simpleFormatter.parseOptional("23012150952");
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        this.test("SPARK-45424: do not return optional parse results when only prefix match", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String x$13 = "yyyy-MM-dd HH:mm:ss";
            Locale x$14 = DateFormatter$.MODULE$.defaultLocale();
            Enumeration.Value x$15 = LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT();
            boolean x$16 = true;
            ZoneId x$17 = DateTimeTestUtils$.MODULE$.LA();
            Iso8601TimestampFormatter formatter = new Iso8601TimestampFormatter("yyyy-MM-dd HH:mm:ss", x$17, x$14, x$15, true);
            Option $org_scalatest_assert_macro_left = formatter.parseOptional("9999-12-31 23:59:59.999");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
            Option $org_scalatest_assert_macro_left2 = formatter.parseWithoutTimeZoneOptional("9999-12-31 23:59:59.999", true);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        this.test("fail to parse string as TimestampNTZ with invalid format", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ZoneId zoneId = ZoneId.systemDefault();
            Locale locale = Locale.getDefault();
            DefaultTimestampFormatter formatter = new DefaultTimestampFormatter(zoneId, locale, LegacyDateFormats$.MODULE$.LENIENT_SIMPLE_DATE_FORMAT(), true);
            String invalidTimestampStr = "2021-13-01T25:61:61";
            SparkException x$18 = (SparkException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> formatter.parseWithoutTimeZone(invalidTimestampStr, false), ClassTag$.MODULE$.apply(SparkException.class), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
            String x$19 = "INTERNAL_ERROR";
            scala.collection.immutable.Map x$20 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)"Cannot parse field value '2021-13-01T25:61:61' for pattern 'yyyy-MM-dd HH:mm:ss' as the target spark data type \"TIMESTAMP_NTZ\".")}));
            Option x$21 = this.checkError$default$3();
            boolean x$22 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$23 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$18, "INTERNAL_ERROR", x$21, x$20, x$22, x$23);
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        Statics.releaseFence();
    }
}

