/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.connector.catalog.BufferedRows;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001\u0002\n\u0014\t\u0001B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015!\u0007\u0001\"\u0003f\u0011\u001dA\u0007\u00011A\u0005\n%DqA\u001c\u0001A\u0002\u0013%q\u000e\u0003\u0004v\u0001\u0001\u0006KA\u001b\u0005\u0006m\u0002!\te\u001e\u0005\u0006w\u0002!\t\u0005 \u0005\u0006{\u0002!\tE \u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003\u0013\u0003A\u0011BAF\u0005I\u0011UO\u001a4fe\u0016$'k\\<t%\u0016\fG-\u001a:\u000b\u0005Q)\u0012aB2bi\u0006dwn\u001a\u0006\u0003-]\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005aI\u0012aA:rY*\u0011!dG\u0001\u0006gB\f'o\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\t\u0013\u0006\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!A.\u00198h\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\r=\u0013'.Z2u!\rQSfL\u0007\u0002W)\u0011A&F\u0001\u0005e\u0016\fG-\u0003\u0002/W\ty\u0001+\u0019:uSRLwN\u001c*fC\u0012,'\u000f\u0005\u00021g5\t\u0011G\u0003\u00023/\u0005A1-\u0019;bYf\u001cH/\u0003\u00025c\tY\u0011J\u001c;fe:\fGNU8x\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u00028q5\t1#\u0003\u0002:'\ta!)\u001e4gKJ,GMU8xg\u0006\u0019R.\u001a;bI\u0006$\u0018mQ8mk6tg*Y7fgB\u0019AHR%\u000f\u0005u\u001aeB\u0001 B\u001b\u0005y$B\u0001! \u0003\u0019a$o\\8u}%\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u000b\u00069\u0001/Y2lC\u001e,'\"\u0001\"\n\u0005\u001dC%aA*fc*\u0011A)\u0012\t\u0003\u0015:s!a\u0013'\u0011\u0005y*\u0015BA'F\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055+\u0015A\u00058p]6+G/\u00193bi\u0006\u001cu\u000e\\;n]N\u00042\u0001\u0010$T!\t!v+D\u0001V\u0015\t1v#A\u0003usB,7/\u0003\u0002Y+\nY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003-!\u0018M\u00197f'\u000eDW-\\1\u0011\u0005Q[\u0016B\u0001/V\u0005)\u0019FO];diRK\b/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b}\u0003\u0017MY2\u0011\u0005]\u0002\u0001\"B\u001b\u0006\u0001\u00041\u0004\"\u0002\u001e\u0006\u0001\u0004Y\u0004\"B)\u0006\u0001\u0004\u0011\u0006\"B-\u0006\u0001\u0004Q\u0016aC1eI6+G/\u00193bi\u0006$\"a\f4\t\u000b\u001d4\u0001\u0019A\u0018\u0002\u0007I|w/A\u0003j]\u0012,\u00070F\u0001k!\tYG.D\u0001F\u0013\tiWIA\u0002J]R\f\u0011\"\u001b8eKb|F%Z9\u0015\u0005A\u001c\bCA6r\u0013\t\u0011XI\u0001\u0003V]&$\bb\u0002;\t\u0003\u0003\u0005\rA[\u0001\u0004q\u0012\n\u0014AB5oI\u0016D\b%\u0001\u0003oKb$H#\u0001=\u0011\u0005-L\u0018B\u0001>F\u0005\u001d\u0011un\u001c7fC:\f1aZ3u)\u0005y\u0013!B2m_N,G#\u00019\u0002#\u0015DHO]1di\u001aKW\r\u001c3WC2,X\r\u0006\u0006\u0002\u0004\u0005%\u0011QBA\t\u0003+\u00012a[A\u0003\u0013\r\t9!\u0012\u0002\u0004\u0003:L\bBBA\u0006\u001b\u0001\u00071+A\u0003gS\u0016dG\r\u0003\u0004\u0002\u00105\u0001\rAW\u0001\u000be\u0016\fGmU2iK6\f\u0007BBA\n\u001b\u0001\u0007!,A\u0006xe&$XmU2iK6\f\u0007\"B4\u000e\u0001\u0004y\u0013!E3yiJ\f7\r^!se\u0006Lh+\u00197vKRA\u00111DA\u0014\u0003W\t)\u0004\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t#M\u0001\u0005kRLG.\u0003\u0003\u0002&\u0005}!!C!se\u0006LH)\u0019;b\u0011\u001d\tIC\u0004a\u0001\u00037\t\u0011\"\u0019:sCf$\u0015\r^1\t\u000f\u00055b\u00021\u0001\u00020\u0005A!/Z1e)f\u0004X\rE\u0002U\u0003cI1!a\rV\u0005!!\u0015\r^1UsB,\u0007bBA\u001c\u001d\u0001\u0007\u0011qF\u0001\noJLG/\u001a+za\u0016\fq\"\u001a=ue\u0006\u001cG/T1q-\u0006dW/\u001a\u000b\r\u0003{\t\u0019%a\u0012\u0002L\u0005=\u00131\u000b\t\u0005\u0003;\ty$\u0003\u0003\u0002B\u0005}!aB'ba\u0012\u000bG/\u0019\u0005\b\u0003\u000bz\u0001\u0019AA\u001f\u0003\u001di\u0017\r\u001d#bi\u0006Dq!!\u0013\u0010\u0001\u0004\ty#A\u0006sK\u0006$7*Z=UsB,\u0007bBA'\u001f\u0001\u0007\u0011qF\u0001\u000ee\u0016\fGMV1mk\u0016$\u0016\u0010]3\t\u000f\u0005Es\u00021\u0001\u00020\u0005aqO]5uK.+\u0017\u0010V=qK\"9\u0011QK\bA\u0002\u0005=\u0012AD<sSR,g+\u00197vKRK\b/Z\u0001\u0012Kb$(/Y2u\u0007>dG.Z2uS>tG\u0003CA.\u0003\u007f\n))a\"1\t\u0005u\u0013q\r\t\u0006W\u0006}\u00131M\u0005\u0004\u0003C*%!B!se\u0006L\b\u0003BA3\u0003Ob\u0001\u0001B\u0006\u0002jA\t\t\u0011!A\u0003\u0002\u0005-$AA02#\u0011\ti'a\u0001\u0013\u0011\u0005=\u00141OA\u000e\u0003{1a!!\u001d\u0001\u0001\u00055$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003BA;\u0003wj!!a\u001e\u000b\u0007\u0005e\u0014'A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA?\u0003o\u0012!cR3oKJL7-\u00138uKJt\u0017\r\u001c*po\"9\u0011\u0011\u0011\tA\u0002\u0005\r\u0015\u0001C3mK6,g\u000e^:\u0011\u000b-\fy&a\u0001\t\u000f\u00055\u0002\u00031\u0001\u00020!9\u0011q\u0007\tA\u0002\u0005=\u0012aC2bgR,E.Z7f]R$\u0002\"a\u0001\u0002\u000e\u0006E\u0015Q\u0013\u0005\b\u0003\u001f\u000b\u0002\u0019AA\u0002\u0003\u0011)G.Z7\t\u000f\u0005M\u0015\u00031\u0001\u00020\u00051Ao\u001c+za\u0016Dq!a&\u0012\u0001\u0004\ty#\u0001\u0005ge>lG+\u001f9f\u0001")
public class BufferedRowsReader
implements PartitionReader<InternalRow> {
    private final BufferedRows partition;
    private final Seq<String> metadataColumnNames;
    private final Seq<StructField> nonMetadataColumns;
    private final StructType tableSchema;
    private int index;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private InternalRow addMetadata(InternalRow row) {
        GenericInternalRow metadataRow = new GenericInternalRow((Object[])((IterableOnceOps)this.metadataColumnNames.map((Function1 & Serializable)x0$1 -> {
            String string = x0$1;
            switch (string == null ? 0 : string.hashCode()) {
                case 100346066: {
                    if (!"index".equals(string)) break;
                    return BoxesRunTime.boxToInteger((int)this.index());
                }
                case 1006243179: {
                    if (!"_partition".equals(string)) break;
                    return UTF8String.fromString((String)$this.partition.keyString());
                }
            }
            throw new MatchError((Object)string);
        })).toArray(ClassTag$.MODULE$.Any()));
        return new JoinedRow(row, (InternalRow)metadataRow);
    }

    private int index() {
        return this.index;
    }

    private void index_$eq(int x$1) {
        this.index = x$1;
    }

    public boolean next() {
        this.index_$eq(this.index() + 1);
        return this.index() < this.partition.rows().length();
    }

    public InternalRow get() {
        InternalRow originalRow = (InternalRow)this.partition.rows().apply(this.index());
        Object[] values = new Object[this.nonMetadataColumns.length()];
        ((IterableOnceOps)this.nonMetadataColumns.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            BufferedRowsReader.$anonfun$get$1(this, values, originalRow, x0$1);
            return BoxedUnit.UNIT;
        });
        return this.addMetadata((InternalRow)new GenericInternalRow(values));
    }

    public void close() {
    }

    private Object extractFieldValue(StructField field, StructType readSchema, StructType writeSchema, InternalRow row) {
        Option readIndexOpt;
        Option writeIndexOpt = writeSchema.getFieldIndex(field.name());
        Tuple2 tuple2 = new Tuple2((Object)writeIndexOpt, (Object)(readIndexOpt = readSchema.getFieldIndex(field.name())));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                int writeIndex = BoxesRunTime.unboxToInt((Object)some.value());
                if (option2 instanceof Some) {
                    if (writeIndex >= row.numFields()) {
                        return ResolveDefaultColumns$.MODULE$.getExistenceDefaultValue(field);
                    }
                    DataType dataType = field.dataType();
                    if (dataType instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        StructField[] fields = structType.fields();
                        if (row.isNullAt(writeIndex)) {
                            return null;
                        }
                        InternalRow childRow = (InternalRow)row.toSeq(writeSchema).apply(writeIndex);
                        StructType childWriteSchema = (StructType)writeSchema.fields()[writeIndex].dataType();
                        StructType childReadSchema = (StructType)readSchema.fields()[writeIndex].dataType();
                        Object[] resultValue = new Object[fields.length];
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])fields))), (Function1 & Serializable)x0$1 -> {
                            BufferedRowsReader.$anonfun$extractFieldValue$1(this, childReadSchema, childWriteSchema, childRow, resultValue, x0$1);
                            return BoxedUnit.UNIT;
                        });
                        return new GenericInternalRow(resultValue);
                    }
                    if (dataType instanceof MapType) {
                        MapType mapType = (MapType)dataType;
                        DataType keyType = mapType.keyType();
                        DataType valueType = mapType.valueType();
                        MapType writeMapType = (MapType)writeSchema.fields()[writeIndex].dataType();
                        MapData mapData = row.getMap(writeIndex);
                        if (mapData == null) {
                            return null;
                        }
                        return this.extractMapValue(mapData, keyType, valueType, writeMapType.keyType(), writeMapType.valueType());
                    }
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType elementType = arrayType.elementType();
                        ArrayData arrayData = row.getArray(writeIndex);
                        if (arrayData == null) {
                            return null;
                        }
                        ArrayType writeType = (ArrayType)writeSchema.fields()[writeIndex].dataType();
                        return this.extractArrayValue(arrayData, elementType, writeType.elementType());
                    }
                    return row.get(writeIndex, dataType);
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                return ResolveDefaultColumns$.MODULE$.getExistenceDefaultValue(field);
            }
        }
        throw new RuntimeException("Failed, field is not found in both read and write schema.");
    }

    private ArrayData extractArrayValue(ArrayData arrayData, DataType readType, DataType writeType) {
        Object[] elements = (Object[])arrayData.toArray(writeType, ClassTag$.MODULE$.Any());
        Object convertedElements = this.extractCollection(elements, readType, writeType);
        return new GenericArrayData(convertedElements);
    }

    private MapData extractMapValue(MapData mapData, DataType readKeyType, DataType readValueType, DataType writeKeyType, DataType writeValueType) {
        Object[] keys = (Object[])mapData.keyArray().toArray(writeKeyType, ClassTag$.MODULE$.Any());
        Object[] values = (Object[])mapData.valueArray().toArray(writeValueType, ClassTag$.MODULE$.Any());
        Object convertedKeys = this.extractCollection(keys, readKeyType, writeKeyType);
        Object convertedValues = this.extractCollection(values, readValueType, writeValueType);
        return ArrayBasedMapData$.MODULE$.apply(convertedKeys, convertedValues);
    }

    private Object extractCollection(Object[] elements, DataType readType, DataType writeType) {
        Tuple2 tuple2 = new Tuple2((Object)readType, (Object)writeType);
        if (tuple2 != null) {
            DataType readSt = (DataType)tuple2._1();
            DataType writeSt = (DataType)tuple2._2();
            if (readSt instanceof StructType) {
                StructType structType = (StructType)readSt;
                if (writeSt instanceof StructType) {
                    StructType structType2 = (StructType)writeSt;
                    return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)elements), (Function1 & Serializable)elem -> {
                        if (elem == null) {
                            return null;
                        }
                        InternalRow elemRow = (InternalRow)elem;
                        Object[] result = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> this.extractFieldValue((StructField)f, structType, structType2, elemRow), ClassTag$.MODULE$.Any());
                        return new GenericInternalRow(result);
                    }, ClassTag$.MODULE$.apply(GenericInternalRow.class));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType readAType = arrayType.elementType();
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType writeAType = arrayType2.elementType();
                    return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)elements), (Function1 & Serializable)elem -> {
                        if (elem == null) {
                            return null;
                        }
                        return this.extractArrayValue((ArrayData)elem, readAType, writeAType);
                    }, ClassTag$.MODULE$.apply(ArrayData.class));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType rKeyType = mapType.keyType();
                DataType rValueType = mapType.valueType();
                if (dataType3 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType3;
                    DataType wKeyType = mapType2.keyType();
                    DataType wValueType = mapType2.valueType();
                    return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)elements), (Function1 & Serializable)elem -> {
                        if (elem == null) {
                            return null;
                        }
                        return this.extractMapValue((MapData)elem, rKeyType, rValueType, wKeyType, wValueType);
                    }, ClassTag$.MODULE$.apply(MapData.class));
                }
            }
        }
        if (tuple2 != null) {
            DataType readType2 = (DataType)tuple2._1();
            DataType writeType2 = (DataType)tuple2._2();
            if (readType2 instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)readType2;
                if (writeType2 instanceof AtomicType) {
                    AtomicType atomicType2 = (AtomicType)writeType2;
                    AtomicType atomicType3 = atomicType;
                    AtomicType atomicType4 = atomicType2;
                    if (atomicType3 == null ? atomicType4 != null : !atomicType3.equals(atomicType4)) {
                        return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)elements), (Function1 & Serializable)elem -> {
                            if (elem == null) {
                                return null;
                            }
                            return this.castElement(elem, (DataType)atomicType, (DataType)atomicType2);
                        }, ClassTag$.MODULE$.Any());
                    }
                }
            }
        }
        if (tuple2 != null) {
            return elements;
        }
        throw new MatchError((Object)tuple2);
    }

    private Object castElement(Object elem, DataType toType, DataType fromType) {
        return new Cast((Expression)new Literal(elem, fromType), toType, (Option)None$.MODULE$, EvalMode$.MODULE$.TRY()).eval(null);
    }

    public static final /* synthetic */ void $anonfun$get$1(BufferedRowsReader $this, Object[] values$1, InternalRow originalRow$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField col = (StructField)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            values$1[idx] = $this.extractFieldValue(col, $this.tableSchema, $this.partition.schema(), originalRow$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$extractFieldValue$1(BufferedRowsReader $this, StructType childReadSchema$1, StructType childWriteSchema$1, InternalRow childRow$1, Object[] resultValue$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object childValue;
            StructField childField = (StructField)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            resultValue$1[idx] = childValue = $this.extractFieldValue(childField, childReadSchema$1, childWriteSchema$1, childRow$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public BufferedRowsReader(BufferedRows partition, Seq<String> metadataColumnNames, Seq<StructField> nonMetadataColumns, StructType tableSchema) {
        this.partition = partition;
        this.metadataColumnNames = metadataColumnNames;
        this.nonMetadataColumns = nonMetadataColumns;
        this.tableSchema = tableSchema;
        this.index = -1;
    }
}

