/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.constraints.Check;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.catalog.constraints.ForeignKey;
import org.apache.spark.sql.connector.catalog.constraints.PrimaryKey;
import org.apache.spark.sql.connector.catalog.constraints.Unique;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\ty1i\u001c8tiJ\f\u0017N\u001c;Tk&$XM\u0003\u0002\u0005\u000b\u000591-\u0019;bY><'B\u0001\u0004\b\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\t\u0013\u0005\u00191/\u001d7\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001#A\u0011!cE\u0007\u0002\u0013%\u0011A#\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0019\u0001")
public class ConstraintSuite
extends SparkFunSuite {
    public ConstraintSuite() {
        this.test("CHECK constraint toDDL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Check con1 = ((Check.Builder)((Check.Builder)((Check.Builder)Constraint.check((String)"con1").predicateSql("id > 10").enforced(true)).validationStatus(Constraint.ValidationStatus.VALID)).rely(true)).build();
            String $org_scalatest_assert_macro_left = con1.toDDL();
            String $org_scalatest_assert_macro_right = "CONSTRAINT con1 CHECK (id > 10) ENFORCED RELY";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left2 = con1.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right2 = Constraint.ValidationStatus.VALID;
            Constraint.ValidationStatus validationStatus = $org_scalatest_assert_macro_left2;
            Constraint.ValidationStatus validationStatus2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(validationStatus != null ? !validationStatus.equals(validationStatus2) : validationStatus2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            Check con2 = ((Check.Builder)((Check.Builder)((Check.Builder)Constraint.check((String)"con2").predicate(new Predicate("=", (Expression[])((Object[])new Expression[]{new FieldReference((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b.c", (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$)))), new LiteralValue((Object)BoxesRunTime.boxToInteger((int)1), (DataType)IntegerType$.MODULE$)}))).enforced(false)).validationStatus(Constraint.ValidationStatus.VALID)).rely(true)).build();
            String $org_scalatest_assert_macro_left3 = con2.toDDL();
            String $org_scalatest_assert_macro_right3 = "CONSTRAINT con2 CHECK (a.`b.c`.d = 1) NOT ENFORCED RELY";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left4 = con2.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right4 = Constraint.ValidationStatus.VALID;
            Constraint.ValidationStatus validationStatus3 = $org_scalatest_assert_macro_left4;
            Constraint.ValidationStatus validationStatus4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(validationStatus3 != null ? !validationStatus3.equals(validationStatus4) : validationStatus4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            Check con3 = ((Check.Builder)((Check.Builder)((Check.Builder)Constraint.check((String)"con3").predicateSql("a.b.c <=> 1").predicate(new Predicate("<=>", (Expression[])((Object[])new Expression[]{new FieldReference((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$)))), new LiteralValue((Object)BoxesRunTime.boxToInteger((int)1), (DataType)IntegerType$.MODULE$)}))).enforced(false)).validationStatus(Constraint.ValidationStatus.INVALID)).rely(false)).build();
            String $org_scalatest_assert_macro_left5 = con3.toDDL();
            String $org_scalatest_assert_macro_right5 = "CONSTRAINT con3 CHECK (a.b.c <=> 1) NOT ENFORCED NORELY";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left6 = con3.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right6 = Constraint.ValidationStatus.INVALID;
            Constraint.ValidationStatus validationStatus5 = $org_scalatest_assert_macro_left6;
            Constraint.ValidationStatus validationStatus6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(validationStatus5 != null ? !validationStatus5.equals(validationStatus6) : validationStatus6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            Check con4 = Constraint.check((String)"con4").predicateSql("a = 1").build();
            String $org_scalatest_assert_macro_left7 = con4.toDDL();
            String $org_scalatest_assert_macro_right7 = "CONSTRAINT con4 CHECK (a = 1) ENFORCED NORELY";
            String string7 = $org_scalatest_assert_macro_left7;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left8 = con4.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right8 = Constraint.ValidationStatus.UNVALIDATED;
            Constraint.ValidationStatus validationStatus7 = $org_scalatest_assert_macro_left8;
            Constraint.ValidationStatus validationStatus8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(validationStatus7 != null ? !validationStatus7.equals(validationStatus8) : validationStatus8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }, new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("UNIQUE constraint toDDL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Unique con1 = ((Unique.Builder)((Unique.Builder)((Unique.Builder)Constraint.unique((String)"con1", (NamedReference[])((NamedReference[])((Object[])new NamedReference[]{new FieldReference((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$)))), new FieldReference((Seq)new .colon.colon((Object)"d", (List)Nil$.MODULE$))}))).enforced(false)).validationStatus(Constraint.ValidationStatus.UNVALIDATED)).rely(true)).build();
            String $org_scalatest_assert_macro_left = con1.toDDL();
            String $org_scalatest_assert_macro_right = "CONSTRAINT con1 UNIQUE (a.b.c, d) NOT ENFORCED RELY";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left2 = con1.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right2 = Constraint.ValidationStatus.UNVALIDATED;
            Constraint.ValidationStatus validationStatus = $org_scalatest_assert_macro_left2;
            Constraint.ValidationStatus validationStatus2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(validationStatus != null ? !validationStatus.equals(validationStatus2) : validationStatus2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            Unique con2 = ((Unique.Builder)((Unique.Builder)((Unique.Builder)Constraint.unique((String)"con2", (NamedReference[])((NamedReference[])((Object[])new NamedReference[]{new FieldReference((Seq)new .colon.colon((Object)"a.b", (List)new .colon.colon((Object)"x", (List)new .colon.colon((Object)"y", (List)Nil$.MODULE$)))), new FieldReference((Seq)new .colon.colon((Object)"d", (List)Nil$.MODULE$))}))).enforced(false)).validationStatus(Constraint.ValidationStatus.VALID)).rely(true)).build();
            String $org_scalatest_assert_macro_left3 = con2.toDDL();
            String $org_scalatest_assert_macro_right3 = "CONSTRAINT con2 UNIQUE (`a.b`.x.y, d) NOT ENFORCED RELY";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left4 = con2.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right4 = Constraint.ValidationStatus.VALID;
            Constraint.ValidationStatus validationStatus3 = $org_scalatest_assert_macro_left4;
            Constraint.ValidationStatus validationStatus4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(validationStatus3 != null ? !validationStatus3.equals(validationStatus4) : validationStatus4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        }, new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("PRIMARY KEY constraint toDDL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PrimaryKey pk1 = ((PrimaryKey.Builder)((PrimaryKey.Builder)((PrimaryKey.Builder)Constraint.primaryKey((String)"pk1", (NamedReference[])((NamedReference[])((Object[])new NamedReference[]{new FieldReference((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$)))), new FieldReference((Seq)new .colon.colon((Object)"d", (List)Nil$.MODULE$))}))).enforced(true)).validationStatus(Constraint.ValidationStatus.VALID)).rely(true)).build();
            String $org_scalatest_assert_macro_left = pk1.toDDL();
            String $org_scalatest_assert_macro_right = "CONSTRAINT pk1 PRIMARY KEY (a.b.c, d) ENFORCED RELY";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left2 = pk1.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right2 = Constraint.ValidationStatus.VALID;
            Constraint.ValidationStatus validationStatus = $org_scalatest_assert_macro_left2;
            Constraint.ValidationStatus validationStatus2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(validationStatus != null ? !validationStatus.equals(validationStatus2) : validationStatus2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            PrimaryKey pk2 = ((PrimaryKey.Builder)((PrimaryKey.Builder)((PrimaryKey.Builder)Constraint.primaryKey((String)"pk2", (NamedReference[])((NamedReference[])((Object[])new NamedReference[]{new FieldReference((Seq)new .colon.colon((Object)"x.y", (List)new .colon.colon((Object)"z", (List)Nil$.MODULE$))), new FieldReference((Seq)new .colon.colon((Object)"id", (List)Nil$.MODULE$))}))).enforced(false)).validationStatus(Constraint.ValidationStatus.INVALID)).rely(false)).build();
            String $org_scalatest_assert_macro_left3 = pk2.toDDL();
            String $org_scalatest_assert_macro_right3 = "CONSTRAINT pk2 PRIMARY KEY (`x.y`.z, id) NOT ENFORCED NORELY";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left4 = pk2.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right4 = Constraint.ValidationStatus.INVALID;
            Constraint.ValidationStatus validationStatus3 = $org_scalatest_assert_macro_left4;
            Constraint.ValidationStatus validationStatus4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(validationStatus3 != null ? !validationStatus3.equals(validationStatus4) : validationStatus4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("FOREIGN KEY constraint toDDL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ForeignKey fk1 = ((ForeignKey.Builder)((ForeignKey.Builder)((ForeignKey.Builder)Constraint.foreignKey((String)"fk1", (NamedReference[])((NamedReference[])((Object[])new NamedReference[]{new FieldReference((Seq)new .colon.colon((Object)"col1", (List)Nil$.MODULE$)), new FieldReference((Seq)new .colon.colon((Object)"col2", (List)Nil$.MODULE$))})), (Identifier)Identifier.of((String[])((String[])((Object[])new String[]{"schema"})), (String)"table"), (NamedReference[])((NamedReference[])((Object[])new NamedReference[]{new FieldReference((Seq)new .colon.colon((Object)"ref_col1", (List)Nil$.MODULE$)), new FieldReference((Seq)new .colon.colon((Object)"ref_col2", (List)Nil$.MODULE$))}))).enforced(true)).validationStatus(Constraint.ValidationStatus.VALID)).rely(true)).build();
            String $org_scalatest_assert_macro_left = fk1.toDDL();
            String $org_scalatest_assert_macro_right = "CONSTRAINT fk1 FOREIGN KEY (col1, col2) REFERENCES schema.table (ref_col1, ref_col2) ENFORCED RELY";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left2 = fk1.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right2 = Constraint.ValidationStatus.VALID;
            Constraint.ValidationStatus validationStatus = $org_scalatest_assert_macro_left2;
            Constraint.ValidationStatus validationStatus2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(validationStatus != null ? !validationStatus.equals(validationStatus2) : validationStatus2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            ForeignKey fk2 = ((ForeignKey.Builder)((ForeignKey.Builder)((ForeignKey.Builder)Constraint.foreignKey((String)"fk2", (NamedReference[])((NamedReference[])((Object[])new NamedReference[]{new FieldReference((Seq)new .colon.colon((Object)"x.y", (List)new .colon.colon((Object)"z", (List)Nil$.MODULE$)))})), (Identifier)Identifier.of((String[])((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), (String)"other_table"), (NamedReference[])((NamedReference[])((Object[])new NamedReference[]{new FieldReference((Seq)new .colon.colon((Object)"other_id", (List)Nil$.MODULE$))}))).enforced(false)).validationStatus(Constraint.ValidationStatus.INVALID)).rely(false)).build();
            String $org_scalatest_assert_macro_left3 = fk2.toDDL();
            String $org_scalatest_assert_macro_right3 = "CONSTRAINT fk2 FOREIGN KEY (`x.y`.z) REFERENCES other_table (other_id) NOT ENFORCED NORELY";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            Constraint.ValidationStatus $org_scalatest_assert_macro_left4 = fk2.validationStatus();
            Constraint.ValidationStatus $org_scalatest_assert_macro_right4 = Constraint.ValidationStatus.INVALID;
            Constraint.ValidationStatus validationStatus3 = $org_scalatest_assert_macro_left4;
            Constraint.ValidationStatus validationStatus4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(validationStatus3 != null ? !validationStatus3.equals(validationStatus4) : validationStatus4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("ConstraintSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
    }
}

