/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryAtomicPartitionTable;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.TableInfo;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Q3A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C!7!)!\u0004\u0001C!\u001b\ni\u0012J\\'f[>\u0014\u0018\u0010U1si&$\u0018n\u001c8UC\ndWmQ1uC2|wM\u0003\u0002\u0007\u000f\u000591-\u0019;bY><'B\u0001\u0005\n\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u000b%\u0011a#\u0002\u0002\u0015\u0013:lU-\\8ssR\u000b'\r\\3DCR\fGn\\4\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000b\u0001\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u000bqyBe\f\u001d\u0011\u0005Qi\u0012B\u0001\u0010\u0006\u0005\u0015!\u0016M\u00197f\u0011\u0015\u0001#\u00011\u0001\"\u0003\u0015IG-\u001a8u!\t!\"%\u0003\u0002$\u000b\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000b\u0015\u0012\u0001\u0019\u0001\u0014\u0002\u000f\r|G.^7ogB\u0019qE\u000b\u0017\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012Q!\u0011:sCf\u0004\"\u0001F\u0017\n\u00059*!AB\"pYVlg\u000eC\u00031\u0005\u0001\u0007\u0011'\u0001\u0006qCJ$\u0018\u000e^5p]N\u00042a\n\u00163!\t\u0019d'D\u00015\u0015\t)t!A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA\u001c5\u0005%!&/\u00198tM>\u0014X\u000eC\u0003:\u0005\u0001\u0007!(\u0001\u0006qe>\u0004XM\u001d;jKN\u0004Ba\u000f!C\u00056\tAH\u0003\u0002>}\u0005!Q\u000f^5m\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001f\u0003\u00075\u000b\u0007\u000f\u0005\u0002D\u0015:\u0011A\t\u0013\t\u0003\u000b\"j\u0011A\u0012\u0006\u0003\u000fF\ta\u0001\u0010:p_Rt\u0014BA%)\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%CCc\u0001\u000fO\u001f\")\u0001e\u0001a\u0001C!)\u0001k\u0001a\u0001#\u0006IA/\u00192mK&sgm\u001c\t\u0003)IK!aU\u0003\u0003\u0013Q\u000b'\r\\3J]\u001a|\u0007")
public class InMemoryPartitionTableCatalog
extends InMemoryTableCatalog {
    @Override
    public Table createTable(Identifier ident, Column[] columns, Transform[] partitions, java.util.Map<String, String> properties) {
        if (this.tables().containsKey(ident)) {
            throw new TableAlreadyExistsException(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier());
        }
        InMemoryTableCatalog$.MODULE$.maybeSimulateFailedTableCreation(properties);
        Column[] finalCols = properties.containsKey("dropExistsDefault") ? (Column[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)c -> {
            if (c.defaultValue().getValue() == null) {
                return c;
            }
            return Column.create((String)c.name(), (DataType)c.dataType(), (boolean)c.nullable(), (String)c.comment(), (ColumnDefaultValue)new ColumnDefaultValue(c.defaultValue().getSql(), c.defaultValue().getExpression(), null), (String)c.metadataInJSON());
        }, ClassTag$.MODULE$.apply(Column.class)) : columns;
        StructType schema = CatalogV2Util$.MODULE$.v2ColumnsToStructType(finalCols);
        InMemoryAtomicPartitionTable table = new InMemoryAtomicPartitionTable(this.name() + "." + CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted(), schema, partitions, properties);
        this.tables().put(ident, (Table)table);
        this.namespaces().putIfAbsent((List<String>)Predef$.MODULE$.wrapRefArray((Object[])ident.namespace()).toList(), (Map<String, String>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return table;
    }

    @Override
    public Table createTable(Identifier ident, TableInfo tableInfo) {
        return this.createTable(ident, tableInfo.columns(), tableInfo.partitions(), (java.util.Map<String, String>)tableInfo.properties());
    }

    @Override
    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }

    @Override
    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }
}

