/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryRowLevelOperationTable;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.TableInfo;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]2A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C!7!)\u0011\u0006\u0001C!U\t)\u0013J\\'f[>\u0014\u0018PU8x\u0019\u00164X\r\\(qKJ\fG/[8o)\u0006\u0014G.Z\"bi\u0006dwn\u001a\u0006\u0003\r\u001d\tqaY1uC2|wM\u0003\u0002\t\u0013\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0001\"\u0001F\u000b\u000e\u0003\u0015I!AF\u0003\u0003)%sW*Z7pef$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0015\u0001\u0005Y1M]3bi\u0016$\u0016M\u00197f)\rar\u0004\n\t\u0003)uI!AH\u0003\u0003\u000bQ\u000b'\r\\3\t\u000b\u0001\u0012\u0001\u0019A\u0011\u0002\u000b%$WM\u001c;\u0011\u0005Q\u0011\u0013BA\u0012\u0006\u0005)IE-\u001a8uS\u001aLWM\u001d\u0005\u0006K\t\u0001\rAJ\u0001\ni\u0006\u0014G.Z%oM>\u0004\"\u0001F\u0014\n\u0005!*!!\u0003+bE2,\u0017J\u001c4p\u0003)\tG\u000e^3s)\u0006\u0014G.\u001a\u000b\u00049-b\u0003\"\u0002\u0011\u0004\u0001\u0004\t\u0003\"B\u0017\u0004\u0001\u0004q\u0013aB2iC:<Wm\u001d\t\u0004_I\"T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002\u0015k%\u0011a'\u0002\u0002\f)\u0006\u0014G.Z\"iC:<W\r")
public class InMemoryRowLevelOperationTableCatalog
extends InMemoryTableCatalog {
    @Override
    public Table createTable(Identifier ident, TableInfo tableInfo) {
        if (this.tables().containsKey(ident)) {
            throw new TableAlreadyExistsException(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier());
        }
        InMemoryTableCatalog$.MODULE$.maybeSimulateFailedTableCreation(tableInfo.properties());
        String tableName = this.name() + "." + CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted();
        StructType schema = CatalogV2Util$.MODULE$.v2ColumnsToStructType(tableInfo.columns());
        InMemoryRowLevelOperationTable table = new InMemoryRowLevelOperationTable(tableName, schema, tableInfo.partitions(), tableInfo.properties(), tableInfo.constraints());
        this.tables().put(ident, (Table)table);
        this.namespaces().putIfAbsent((List<String>)Predef$.MODULE$.wrapRefArray((Object[])ident.namespace()).toList(), (Map<String, String>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return table;
    }

    @Override
    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        InMemoryRowLevelOperationTable table = (InMemoryRowLevelOperationTable)this.loadTable(ident);
        java.util.Map properties = CatalogV2Util$.MODULE$.applyPropertiesChanges(table.properties(), changes);
        StructType schema = CatalogV2Util$.MODULE$.applySchemaChanges(table.schema(), changes, (Option)new Some((Object)"in-memory"), "ALTER TABLE");
        Transform[] partitioning = CatalogV2Util$.MODULE$.applyClusterByChanges(table.partitioning(), schema, changes);
        Constraint[] constraints = CatalogV2Util$.MODULE$.collectConstraintChanges((Table)table, changes);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))) {
            throw new IllegalArgumentException("Cannot drop all fields");
        }
        InMemoryRowLevelOperationTable newTable = new InMemoryRowLevelOperationTable(table.name(), schema, partitioning, properties, constraints);
        newTable.alterTableWithData(table.data(), schema);
        this.tables().put(ident, (Table)newTable);
        return newTable;
    }

    @Override
    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }

    @Override
    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }
}

