/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.catalyst.util.StringConcat;
import org.apache.spark.sql.catalyst.util.StringConcat$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.json4s.AsJsonInput$;
import org.json4s.jackson.JsonMethods$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\u000b\u0017\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0003,\u0011\u0019!\u0004\u0001)A\u0005Y!)Q\u0007\u0001C\u0001m!)q\b\u0001C\u0001\u0001\"9!\t\u0001b\u0001\n\u0003\u0019\u0005BB$\u0001A\u0003%A\tC\u0004I\u0001\t\u0007I\u0011A%\t\r5\u0003\u0001\u0015!\u0003K\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00151\u0007\u0001\"\u0001h\u0011\u001di\u0007!%A\u0005\u00029DQ!\u001f\u0001\u0005\u0002iD\u0001\"!\u0001\u0001#\u0003%\tA\u001c\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u00055!\u0015\r^1UsB,7+^5uK*\u0011q\u0003G\u0001\u0006if\u0004Xm\u001d\u0006\u00033i\t1a]9m\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003iI!!\n\u000e\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\ta#\u0001\u000bV\u001d&\u001bu\nR#`\u0007>cE*\u0011+J\u001f:{\u0016\nR\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t\u0019\u0011J\u001c;\u0002+Us\u0015jQ(E\u000b~\u001bu\n\u0014'B)&{ejX%EA\u00059R\u000b\u0016$9?2\u001b\u0015iU#`\u0007>cE*\u0011+J\u001f:{\u0016\nR\u0001\u0019+R3\u0005h\u0018'D\u0003N+ulQ(M\u0019\u0006#\u0016j\u0014(`\u0013\u0012\u0003\u0013!F2iK\u000e\\G)\u0019;b)f\u0004XM\u0012:p[*\u001bxN\u001c\u000b\u0003oi\u0002\"!\f\u001d\n\u0005er#\u0001B+oSRDQa\u000f\u0004A\u0002q\n\u0001\u0002Z1uCRK\b/\u001a\t\u0003SuJ!A\u0010\f\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAc\u00195fG.$\u0015\r^1UsB,gI]8n\t\u0012cECA\u001cB\u0011\u0015Yt\u00011\u0001=\u0003!iW\r^1eCR\fW#\u0001#\u0011\u0005%*\u0015B\u0001$\u0017\u0005!iU\r^1eCR\f\u0017!C7fi\u0006$\u0017\r^1!\u0003)\u0019HO];diRK\b/Z\u000b\u0002\u0015B\u0011\u0011fS\u0005\u0003\u0019Z\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003-\u0019HO];diRK\b/\u001a\u0011\u0002!\rDWmY6EK\u001a\fW\u000f\u001c;TSj,GcA\u001cQ#\")1\b\u0004a\u0001y!)!\u000b\u0004a\u0001Y\u0005\u0019R\r\u001f9fGR,G\rR3gCVdGoU5{K\u000613\r[3dW\u0016\u000bX/\u00197t\u0013\u001etwN]3D_6\u0004\u0018\r^5cY\u0016tU\u000f\u001c7bE&d\u0017\u000e^=\u0015\t]*v+\u0017\u0005\u0006-6\u0001\r\u0001P\u0001\u0005MJ|W\u000eC\u0003Y\u001b\u0001\u0007A(\u0001\u0002u_\")!,\u0004a\u00017\u0006AQ\r\u001f9fGR,G\r\u0005\u0002.9&\u0011QL\f\u0002\b\u0005>|G.Z1o\u0003I\u0019\u0007.Z2l\u0007\u0006$\u0018\r\\8h'R\u0014\u0018N\\4\u0015\u0005]\u0002\u0007\"B1\u000f\u0001\u0004a\u0014A\u00013u\u00031\u0019'/Z1uKN#(/^2u)\tQE\rC\u0003f\u001f\u0001\u0007A&A\u0001o\u0003]\u0019\u0007.Z2l\u000bF,\u0018\r\\:TiJ,8\r^;sC2d\u0017\u0010F\u00038Q&T7\u000eC\u0003W!\u0001\u0007A\bC\u0003Y!\u0001\u0007A\bC\u0003[!\u0001\u00071\fC\u0004m!A\u0005\t\u0019A.\u0002#%<gn\u001c:f\u001dVdG.\u00192jY&$\u00180A\u0011dQ\u0016\u001c7.R9vC2\u001c8\u000b\u001e:vGR,(/\u00197ms\u0012\"WMZ1vYR$C'F\u0001pU\tY\u0006oK\u0001r!\t\u0011x/D\u0001t\u0015\t!X/A\u0005v]\u000eDWmY6fI*\u0011aOL\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001=t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001eG\",7m[#rk\u0006d7o\u0015;sk\u000e$XO]1mYf\u0014\u0015PT1nKR)qg\u001f?~}\")aK\u0005a\u0001y!)\u0001L\u0005a\u0001y!)!L\u0005a\u00017\"9qP\u0005I\u0001\u0002\u0004Y\u0016!D2bg\u0016\u001cVM\\:ji&4X-A\u0014dQ\u0016\u001c7.R9vC2\u001c8\u000b\u001e:vGR,(/\u00197ms\nKh*Y7fI\u0011,g-Y;mi\u0012\"\u0014\u0001J2iK\u000e\\W)];bYNLuM\\8sK\u000e{W\u000e]1uS\ndWmQ8mY\u0006$\u0018n\u001c8\u0015\u000f]\n9!!\u0003\u0002\f!)a\u000b\u0006a\u0001y!)\u0001\f\u0006a\u0001y!)!\f\u0006a\u00017\u0002")
public class DataTypeSuite
extends SparkFunSuite {
    private final int UNICODE_COLLATION_ID = CollationFactory.collationNameToId((String)"UNICODE");
    private final int UTF8_LCASE_COLLATION_ID = CollationFactory.collationNameToId((String)"UTF8_LCASE");
    private final Metadata metadata;
    private final StructType structType;

    private int UNICODE_COLLATION_ID() {
        return this.UNICODE_COLLATION_ID;
    }

    private int UTF8_LCASE_COLLATION_ID() {
        return this.UTF8_LCASE_COLLATION_ID;
    }

    public void checkDataTypeFromJson(DataType dataType) {
        this.test("from Json - " + dataType, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataType$.MODULE$.fromJson(dataType.json()));
            DataType $org_scalatest_assert_macro_right = dataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }

    public void checkDataTypeFromDDL(DataType dataType) {
        this.test("from DDL - " + dataType, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType parsed = StructType$.MODULE$.fromDDL("a " + dataType.sql());
            StructType expected = new StructType().add("a", dataType);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DataTypeUtils$.MODULE$.sameType((DataType)parsed, (DataType)expected), "org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(parsed, expected)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public StructType structType() {
        return this.structType;
    }

    public void checkDefaultSize(DataType dataType, int expectedDefaultSize) {
        this.test("Check the default size of " + dataType, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dataType.defaultSize()));
            int $org_scalatest_assert_macro_right = expectedDefaultSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
    }

    public void checkEqualsIgnoreCompatibleNullability(DataType from, DataType to, boolean expected) {
        String testName = "equalsIgnoreCompatibleNullability: (from: " + from + ", to: " + to + ")";
        this.test(testName, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsIgnoreCompatibleNullability(from, to)));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
    }

    public void checkCatalogString(DataType dt) {
        this.test("catalogString: " + dt, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DataType dt2 = CatalystSqlParser$.MODULE$.parseDataType(dt.catalogString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dt);
            DataType $org_scalatest_assert_macro_right = dt2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
    }

    public StructType createStruct(int n) {
        return new StructType((StructField[])Array$.MODULE$.tabulate(n, (Function1 & Serializable)i -> DataTypeSuite.$anonfun$createStruct$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(StructField.class)));
    }

    public void checkEqualsStructurally(DataType from, DataType to, boolean expected, boolean ignoreNullability) {
        String testName = "equalsStructurally: (from: " + from + ", to: " + to + ", ignoreNullability: " + ignoreNullability + ")";
        this.test(testName, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsStructurally(from, to, ignoreNullability)));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
    }

    public boolean checkEqualsStructurally$default$4() {
        return false;
    }

    public void checkEqualsStructurallyByName(DataType from, DataType to, boolean expected, boolean caseSensitive) {
        String testName = "SPARK-36918: equalsStructurallyByName: (from: " + from + ", to: " + to + ", caseSensitive: " + caseSensitive + ")";
        Function2 resolver = caseSensitive ? package$.MODULE$.caseSensitiveResolution() : package$.MODULE$.caseInsensitiveResolution();
        this.test(testName, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsStructurallyByName(from, to, resolver)));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
    }

    public boolean checkEqualsStructurallyByName$default$4() {
        return false;
    }

    public void checkEqualsIgnoreCompatibleCollation(DataType from, DataType to, boolean expected) {
        String testName = "equalsIgnoreCompatibleCollation: (from: " + from + ", to: " + to + ")";
        this.test(testName, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsIgnoreCompatibleCollation(from, to, DataType$.MODULE$.equalsIgnoreCompatibleCollation$default$3())));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 833));
    }

    public static final /* synthetic */ boolean $anonfun$new$17(DataType x$1) {
        return x$1 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$18(DataType x$2) {
        return x$2 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$19(DataType x$3) {
        return x$3 instanceof IntegerType;
    }

    public static final /* synthetic */ boolean $anonfun$new$20(DataType x$4) {
        return x$4 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$21(DataType x$5) {
        return x$5 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$22(DataType x$6) {
        return x$6 instanceof StringType;
    }

    public static final /* synthetic */ boolean $anonfun$new$23(DataType x$7) {
        return x$7 instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$new$24(DataType x$8) {
        return x$8 instanceof IntegerType;
    }

    public static final /* synthetic */ boolean $anonfun$new$25(DataType x$9) {
        return x$9 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$26(DataType x$10) {
        return x$10 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$27(DataType x$11) {
        return x$11 instanceof StringType;
    }

    public static final /* synthetic */ boolean $anonfun$new$28(DataType x$12) {
        return x$12 instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$new$29(DataType x$13) {
        return x$13 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$new$30(DataType x$14) {
        return x$14 instanceof IntegerType;
    }

    public static final /* synthetic */ StructField $anonfun$createStruct$1(int i) {
        return new StructField("col" + i, (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Assertion $anonfun$new$61(int p) {
        String $org_scalatest_assert_macro_left = new TimeType(p).sql();
        String $org_scalatest_assert_macro_right = "TIME(" + p + ")";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1392));
    }

    public static final /* synthetic */ Assertion $anonfun$new$65(int n) {
        DataType $org_scalatest_assert_macro_left = DataType$.MODULE$.fromJson("\"time(" + n + ")\"");
        TimeType $org_scalatest_assert_macro_right = new TimeType(n);
        DataType dataType = $org_scalatest_assert_macro_left;
        TimeType timeType = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(timeType) : timeType != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1412));
        StructType expectedStructType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("t", (DataType)new TimeType(n), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        DataType $org_scalatest_assert_macro_left2 = DataType$.MODULE$.fromDDL("t time(" + n + ")");
        StructType $org_scalatest_assert_macro_right2 = expectedStructType;
        DataType dataType2 = $org_scalatest_assert_macro_left2;
        StructType structType = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(structType) : structType != null), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1414));
    }

    public DataTypeSuite() {
        this.test("construct an ArrayType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArrayType array = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayType((DataType)StringType$.MODULE$, true));
            ArrayType $org_scalatest_assert_macro_right = array;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("construct an MapType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MapType map = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, true));
            MapType $org_scalatest_assert_macro_right = map;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("construct with add", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add("a", (DataType)IntegerType$.MODULE$, true).add("b", (DataType)LongType$.MODULE$, false).add("c", (DataType)StringType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("construct with add from StructField", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())).add(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("construct with add from StructField with comments", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add("a", "int", true, "test1").add("b", (DataType)StringType$.MODULE$, true, "test3").add(new StructField("c", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("test4")).add(new StructField("d", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_left = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()).withComment("test1");
            StructField $org_scalatest_assert_macro_right = struct.apply("a");
            StructField structField = $org_scalatest_assert_macro_left;
            StructField structField2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structField != null ? !structField.equals(structField2) : structField2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            StructField $org_scalatest_assert_macro_left2 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()).withComment("test3");
            StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
            StructField structField3 = $org_scalatest_assert_macro_left2;
            StructField structField4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structField3 != null ? !structField3.equals(structField4) : structField4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            StructField $org_scalatest_assert_macro_left3 = new StructField("c", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("test4");
            StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
            StructField structField5 = $org_scalatest_assert_macro_left3;
            StructField structField6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(structField5 != null ? !structField5.equals(structField6) : structField6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            StructField $org_scalatest_assert_macro_left4 = new StructField("d", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField $org_scalatest_assert_macro_right4 = struct.apply("d");
            StructField structField7 = $org_scalatest_assert_macro_left4;
            StructField structField8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structField7 != null ? !structField7.equals(structField8) : structField8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Option $org_scalatest_assert_macro_left5 = struct.apply("c").getComment();
            Option $org_scalatest_assert_macro_right5 = Option$.MODULE$.apply((Object)"test4");
            Option option = $org_scalatest_assert_macro_left5;
            Option option2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Option $org_scalatest_assert_macro_left6 = struct.apply("d").getComment();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("construct with String DataType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("a");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("extract fields from a StructType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField4 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            this.intercept((Function0 & Serializable)() -> struct.apply("e"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            StructField structField5 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField6 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructType expectedStruct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(expectedStruct);
            StructType $org_scalatest_assert_macro_right2 = struct.apply((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d"})));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            return (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> struct.apply((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d", "e", "f"}))), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113))));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("extract field index from a StructType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("a")));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("b")));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            return (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> struct.fieldIndex("non_existent"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126))));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("fieldsMap returns map of name to StructField", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            Map mapped = StructType$.MODULE$.fieldsMap(struct.fields(), StructType$.MODULE$.fieldsMap$default$2());
            scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mapped);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("fieldNames and names returns field names", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(struct.fieldNames());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(struct.names());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("merge where right contains type conflict", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType left = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            StructField structField3 = new StructField("b", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3));
            SparkException x$1 = (SparkException)this.intercept((Function0 & Serializable)() -> left.merge(right, left.merge$default$2()), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            String x$2 = "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"FLOAT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BIGINT\"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE", x$4, x$3, x$5, x$6);
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("existsRecursively", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$17(x$1))), "struct.existsRecursively(((x$1: org.apache.spark.sql.types.DataType) => x$1.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$18(x$2))), "struct.existsRecursively(((x$2: org.apache.spark.sql.types.DataType) => x$2.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$19(x$3))), "struct.existsRecursively(((x$3: org.apache.spark.sql.types.DataType) => x$3.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            MapType mapType = MapType$.MODULE$.apply((DataType)struct, (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$20(x$4))), "mapType.existsRecursively(((x$4: org.apache.spark.sql.types.DataType) => x$4.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$21(x$5))), "mapType.existsRecursively(((x$5: org.apache.spark.sql.types.DataType) => x$5.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$22(x$6))), "mapType.existsRecursively(((x$6: org.apache.spark.sql.types.DataType) => x$6.isInstanceOf[org.apache.spark.sql.types.StringType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$23(x$7))), "mapType.existsRecursively(((x$7: org.apache.spark.sql.types.DataType) => x$7.isInstanceOf[org.apache.spark.sql.types.MapType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$24(x$8))), "mapType.existsRecursively(((x$8: org.apache.spark.sql.types.DataType) => x$8.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)mapType);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$25(x$9))), "arrayType.existsRecursively(((x$9: org.apache.spark.sql.types.DataType) => x$9.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$26(x$10))), "arrayType.existsRecursively(((x$10: org.apache.spark.sql.types.DataType) => x$10.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$27(x$11))), "arrayType.existsRecursively(((x$11: org.apache.spark.sql.types.DataType) => x$11.isInstanceOf[org.apache.spark.sql.types.StringType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$28(x$12))), "arrayType.existsRecursively(((x$12: org.apache.spark.sql.types.DataType) => x$12.isInstanceOf[org.apache.spark.sql.types.MapType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$29(x$13))), "arrayType.existsRecursively(((x$13: org.apache.spark.sql.types.DataType) => x$13.isInstanceOf[org.apache.spark.sql.types.ArrayType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$30(x$14))), "arrayType.existsRecursively(((x$14: org.apache.spark.sql.types.DataType) => x$14.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("SPARK-36224: Backwards compatibility test for NullType.json", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DataType $org_scalatest_assert_macro_left = DataType$.MODULE$.fromJson("\"null\"");
            NullType$ $org_scalatest_assert_macro_right = NullType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            NullType$ nullType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("SPARK-42723: Parse timestamp_ltz as TimestampType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DataType $org_scalatest_assert_macro_left = DataType$.MODULE$.fromJson("\"timestamp_ltz\"");
            TimestampType$ $org_scalatest_assert_macro_right = TimestampType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            StructType expectedStructType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            DataType $org_scalatest_assert_macro_left2 = DataType$.MODULE$.fromDDL("ts timestamp_ltz");
            StructType $org_scalatest_assert_macro_right2 = expectedStructType;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            StructType structType = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(structType) : structType != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.checkDataTypeFromJson((DataType)NullType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)NullType$.MODULE$);
        this.checkDataTypeFromJson((DataType)BooleanType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)BooleanType$.MODULE$);
        this.checkDataTypeFromJson((DataType)ByteType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)ByteType$.MODULE$);
        this.checkDataTypeFromJson((DataType)ShortType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)ShortType$.MODULE$);
        this.checkDataTypeFromJson((DataType)IntegerType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)IntegerType$.MODULE$);
        this.checkDataTypeFromJson((DataType)LongType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)LongType$.MODULE$);
        this.checkDataTypeFromJson((DataType)FloatType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)FloatType$.MODULE$);
        this.checkDataTypeFromJson((DataType)DoubleType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)DoubleType$.MODULE$);
        this.checkDataTypeFromJson((DataType)new DecimalType(10, 5));
        this.checkDataTypeFromDDL((DataType)new DecimalType(10, 5));
        this.checkDataTypeFromJson((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeFromDDL((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeFromJson((DataType)DateType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)DateType$.MODULE$);
        this.checkDataTypeFromJson((DataType)TimestampType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)TimestampType$.MODULE$);
        this.checkDataTypeFromJson((DataType)TimestampNTZType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)TimestampNTZType$.MODULE$);
        this.checkDataTypeFromJson((DataType)StringType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)StringType$.MODULE$);
        this.checkDataTypeFromJson((DataType)BinaryType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)BinaryType$.MODULE$);
        this.checkDataTypeFromJson((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeFromDDL((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeFromJson((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeFromDDL((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeFromJson((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeFromDDL((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeFromJson((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.checkDataTypeFromDDL((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.checkDataTypeFromJson((DataType)new CharType(1));
        this.checkDataTypeFromDDL((DataType)new CharType(1));
        this.checkDataTypeFromJson((DataType)new VarcharType(10));
        this.checkDataTypeFromDDL((DataType)new VarcharType(11));
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dataType -> {
            this.checkDataTypeFromJson(dataType);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dataType -> {
            this.checkDataTypeFromJson(dataType);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dataType -> {
            this.checkDataTypeFromDDL(dataType);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dataType -> {
            this.checkDataTypeFromDDL(dataType);
            return BoxedUnit.UNIT;
        });
        this.metadata = new MetadataBuilder().putString("name", "age").build();
        this.structType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)DoubleType$.MODULE$, false, this.metadata()), (List)Nil$.MODULE$))));
        this.checkDataTypeFromJson((DataType)this.structType());
        this.checkDataTypeFromDDL((DataType)this.structType());
        this.test("fromJson throws an exception when given type string is invalid", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String message;
            SparkIllegalArgumentException x$7 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("\"abcd\""), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300))));
            String x$8 = "INVALID_JSON_DATA_TYPE";
            scala.collection.immutable.Map x$9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidType"), (Object)"abcd")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "INVALID_JSON_DATA_TYPE", x$10, x$9, x$11, x$12);
            SparkIllegalArgumentException x$13 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("{\"abcd\":\"a\"}"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307))));
            String x$14 = "INVALID_JSON_DATA_TYPE";
            scala.collection.immutable.Map x$15 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidType"), (Object)"{\"abcd\":\"a\"}")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "INVALID_JSON_DATA_TYPE", x$16, x$15, x$17, x$18);
            SparkIllegalArgumentException x$19 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("{\"fields\": [{\"a\":123}], \"type\": \"struct\"}"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314))));
            String x$20 = "INVALID_JSON_DATA_TYPE";
            scala.collection.immutable.Map x$21 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidType"), (Object)"{\"a\":123}")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "INVALID_JSON_DATA_TYPE", x$22, x$21, x$23, x$24);
            String $org_scalatest_assert_macro_left = message = ((JsonParseException)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("abcd"), ClassTag$.MODULE$.apply(JsonParseException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321))).getMessage();
            String $org_scalatest_assert_macro_right = "Unrecognized token 'abcd'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("Deserialized and serialized schema without nullable or metadata in", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String schema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"type\": \"struct\",\n        |    \"fields\": [\n        |        {\n        |            \"name\": \"c1\",\n        |            \"type\": \"string\"\n        |        }\n        |    ]\n        |}\n        |"));
            DataType dt = DataType$.MODULE$.fromJson(schema);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(dt.simpleString().equals("struct<c1:string>"), "dt.simpleString.equals(\"struct<c1:string>\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(dt.json().equals(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\"type\":\"struct\",\"fields\":[{\"name\":\"c1\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}\n        |")).trim()), "dt.json.equals(scala.Predef.augmentString(\"\\n        |{\\\"type\\\":\\\"struct\\\",\\\"fields\\\":[{\\\"name\\\":\\\"c1\\\",\\\"type\\\":\\\"string\\\",\\\"nullable\\\":true,\\\"metadata\\\":{}}]}\\n        |\").stripMargin.trim())", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.checkDefaultSize((DataType)NullType$.MODULE$, 1);
        this.checkDefaultSize((DataType)BooleanType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ByteType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ShortType$.MODULE$, 2);
        this.checkDefaultSize((DataType)IntegerType$.MODULE$, 4);
        this.checkDefaultSize((DataType)LongType$.MODULE$, 8);
        this.checkDefaultSize((DataType)FloatType$.MODULE$, 4);
        this.checkDefaultSize((DataType)DoubleType$.MODULE$, 8);
        this.checkDefaultSize((DataType)new DecimalType(10, 5), 8);
        this.checkDefaultSize((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), 16);
        this.checkDefaultSize((DataType)DateType$.MODULE$, 4);
        this.checkDefaultSize((DataType)TimestampType$.MODULE$, 8);
        this.checkDefaultSize((DataType)TimestampNTZType$.MODULE$, 8);
        this.checkDefaultSize((DataType)StringType$.MODULE$, 20);
        this.checkDefaultSize((DataType)new CharType(20), 20);
        this.checkDefaultSize((DataType)new VarcharType(20), 20);
        this.checkDefaultSize((DataType)BinaryType$.MODULE$, 100);
        this.checkDefaultSize((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), 8);
        this.checkDefaultSize((DataType)new ArrayType((DataType)StringType$.MODULE$, false), 20);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), 24);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false), 12);
        this.checkDefaultSize((DataType)this.structType(), 20);
        this.checkDefaultSize((DataType)new CharType(5), 5);
        this.checkDefaultSize((DataType)new CharType(100), 100);
        this.checkDefaultSize((DataType)new VarcharType(5), 5);
        this.checkDefaultSize((DataType)new VarcharType(10), 10);
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)x$15 -> {
            this.checkDefaultSize((DataType)x$15, 4);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)x$16 -> {
            this.checkDefaultSize((DataType)x$16, 8);
            return BoxedUnit.UNIT;
        });
        this.checkDefaultSize((DataType)new TimeType(TimeType$.MODULE$.MIN_PRECISION()), 8);
        this.checkDefaultSize((DataType)new TimeType(TimeType$.MODULE$.MAX_PRECISION()), 8);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)new CharType(5), false), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)new VarcharType(5), false), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)new CharType(5), (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)new VarcharType(5), (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true);
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2)), true);
        StructField structField3 = new StructField("a", (DataType)new CharType(5), true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4)), false);
        StructField structField5 = new StructField("a", (DataType)new VarcharType(5), true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6)), false);
        StructField structField7 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField8)), true);
        StructField structField9 = new StructField("a", (DataType)new CharType(5), false, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField9)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField10)), false);
        StructField structField11 = new StructField("a", (DataType)new VarcharType(5), false, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField11)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12)), false);
        StructField structField13 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField14 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField13)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField14)), true);
        StructField structField15 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField16 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField15)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField16)), false);
        StructField structField17 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField18 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField19 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField20 = new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField18).$colon$colon((Object)structField17)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField20).$colon$colon((Object)structField19)), false);
        this.checkCatalogString((DataType)NullType$.MODULE$);
        this.checkCatalogString((DataType)BooleanType$.MODULE$);
        this.checkCatalogString((DataType)ByteType$.MODULE$);
        this.checkCatalogString((DataType)ShortType$.MODULE$);
        this.checkCatalogString((DataType)IntegerType$.MODULE$);
        this.checkCatalogString((DataType)LongType$.MODULE$);
        this.checkCatalogString((DataType)FloatType$.MODULE$);
        this.checkCatalogString((DataType)DoubleType$.MODULE$);
        this.checkCatalogString((DataType)new DecimalType(10, 5));
        this.checkCatalogString((DataType)BinaryType$.MODULE$);
        this.checkCatalogString((DataType)StringType$.MODULE$);
        this.checkCatalogString((DataType)new CharType(5));
        this.checkCatalogString((DataType)new VarcharType(10));
        this.checkCatalogString((DataType)DateType$.MODULE$);
        this.checkCatalogString((DataType)TimestampType$.MODULE$);
        this.checkCatalogString((DataType)this.createStruct(4));
        this.checkCatalogString((DataType)this.createStruct(40));
        this.checkCatalogString((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        this.checkCatalogString((DataType)ArrayType$.MODULE$.apply((DataType)this.createStruct(40)));
        this.checkCatalogString((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
        this.checkCatalogString((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)this.createStruct(40)));
        this.checkEqualsStructurally((DataType)BooleanType$.MODULE$, (DataType)BooleanType$.MODULE$, true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)IntegerType$.MODULE$, (DataType)LongType$.MODULE$, false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new CharType(5), (DataType)new CharType(5), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new CharType(5), (DataType)new CharType(10), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new CharType(5), (DataType)new VarcharType(5), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new VarcharType(5), (DataType)new VarcharType(5), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new VarcharType(5), (DataType)new VarcharType(10), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new VarcharType(5), (DataType)new CharType(5), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new CharType(5), true), (DataType)new ArrayType((DataType)new CharType(5), true), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new CharType(5), true), (DataType)new ArrayType((DataType)new CharType(5), false), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new VarcharType(5), true), (DataType)new ArrayType((DataType)new VarcharType(5), true), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new VarcharType(5), true), (DataType)new ArrayType((DataType)new VarcharType(5), false), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$, false), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)new CharType(5)), (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)new VarcharType(5)), (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$, false)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$, false)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, true);
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$, false).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, true);
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)new CharType(5))), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)new VarcharType(5))), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), false, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, true);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), true, true);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)new CharType(5), true), true), (DataType)new ArrayType((DataType)new ArrayType((DataType)StringType$.MODULE$, true), true), false, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)new VarcharType(5), true), true), (DataType)new ArrayType((DataType)new ArrayType((DataType)StringType$.MODULE$, true), true), false, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), false, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)new CharType(5), true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)StringType$.MODULE$, true), true), false, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)new VarcharType(5), true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)StringType$.MODULE$, true), true), false, false);
        this.checkEqualsStructurallyByName((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)BooleanType$.MODULE$, (DataType)BooleanType$.MODULE$, true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)BooleanType$.MODULE$, (DataType)IntegerType$.MODULE$, true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)IntegerType$.MODULE$, (DataType)LongType$.MODULE$, true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)StringType$.MODULE$, (DataType)new CharType(5), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)StringType$.MODULE$, (DataType)new VarcharType(5), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new CharType(5), (DataType)StringType$.MODULE$, true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new VarcharType(5), (DataType)StringType$.MODULE$, true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f1", (DataType)LongType$.MODULE$).add("f2", (DataType)StringType$.MODULE$), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f1", (DataType)new CharType(5)).add("f2", (DataType)StringType$.MODULE$), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)LongType$.MODULE$).add("f1", (DataType)StringType$.MODULE$), false, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)new VarcharType(5)), (DataType)new StructType().add("f2", (DataType)LongType$.MODULE$).add("f1", (DataType)StringType$.MODULE$), false, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f1", (DataType)LongType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)BooleanType$.MODULE$)), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f1", (DataType)LongType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)new VarcharType(5))), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f", (DataType)new StructType().add("f2", (DataType)BooleanType$.MODULE$)).add("f1", (DataType)LongType$.MODULE$), false, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f", (DataType)new StructType().add("f2", (DataType)new CharType(5))).add("f1", (DataType)LongType$.MODULE$), false, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("F1", (DataType)LongType$.MODULE$).add("F2", (DataType)StringType$.MODULE$), true, false);
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("F1", (DataType)LongType$.MODULE$).add("F2", (DataType)new CharType(5)), true, false);
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("F1", (DataType)LongType$.MODULE$).add("F2", (DataType)StringType$.MODULE$), false, true);
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("F1", (DataType)LongType$.MODULE$).add("F2", (DataType)new VarcharType(5)), false, true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)IntegerType$.MODULE$, (DataType)BooleanType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)IntegerType$.MODULE$, (DataType)new CharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)IntegerType$.MODULE$, (DataType)new VarcharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)BooleanType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)BooleanType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)BooleanType$.MODULE$, (DataType)StringType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)BooleanType$.MODULE$, (DataType)new CharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)BooleanType$.MODULE$, (DataType)new VarcharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$, (DataType)new CharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$, (DataType)new VarcharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new CharType(5), (DataType)IntegerType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new CharType(5), (DataType)BooleanType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new CharType(5), (DataType)StringType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new CharType(5), (DataType)new CharType(5), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new CharType(5), (DataType)new CharType(10), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new CharType(5), (DataType)new VarcharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new VarcharType(5), (DataType)IntegerType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new VarcharType(5), (DataType)BooleanType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new VarcharType(5), (DataType)StringType$.MODULE$, false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new VarcharType(5), (DataType)new CharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new VarcharType(5), (DataType)new VarcharType(5), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new VarcharType(5), (DataType)new VarcharType(10), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)StringType$.MODULE$.apply("UTF8_BINARY"), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)new CharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new CharType(5), (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)new VarcharType(5), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new VarcharType(5), (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"))), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"))), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new VarcharType(5))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"))), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new VarcharType(5))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$.apply("UTF8_LCASE")), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)StringType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)StringType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)StringType$.MODULE$), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)StringType$.MODULE$), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)StringType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)new VarcharType(5), (DataType)StringType$.MODULE$), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)new VarcharType(5), (DataType)StringType$.MODULE$), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"))), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"))), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)new VarcharType(5))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"))), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)ArrayType$.MODULE$.apply((DataType)new VarcharType(5))), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), (DataType)IntegerType$.MODULE$), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), (DataType)IntegerType$.MODULE$), true);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5)), (DataType)IntegerType$.MODULE$), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5)), (DataType)IntegerType$.MODULE$), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new VarcharType(5)), (DataType)IntegerType$.MODULE$), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new VarcharType(5)), (DataType)IntegerType$.MODULE$), false);
        StructField structField21 = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField22 = new StructField("a", (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField21)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField22)), true);
        StructField structField23 = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField24 = new StructField("a", (DataType)new CharType(5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField23)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField24)), false);
        StructField structField25 = new StructField("a", (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField26 = new StructField("a", (DataType)new CharType(5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField25)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField26)), false);
        StructField structField27 = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField28 = new StructField("a", (DataType)new VarcharType(5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField27)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField28)), false);
        StructField structField29 = new StructField("a", (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField30 = new StructField("a", (DataType)new VarcharType(5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField29)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField30)), false);
        StructField structField31 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField32 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField31)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField32)), true);
        StructField structField33 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField34 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField33)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField34)), false);
        StructField structField35 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField36 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField35)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField36)), false);
        StructField structField37 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField38 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)new VarcharType(5)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField37)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField38)), false);
        StructField structField39 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField40 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)new VarcharType(5)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField39)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField40)), false);
        StructField structField41 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField42 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField41)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField42)), true);
        StructField structField43 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField44 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField43)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField44)), false);
        StructField structField45 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField46 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField45)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField46)), false);
        StructField structField47 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField48 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)new VarcharType(5), (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField47)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField48)), false);
        StructField structField49 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField50 = new StructField("a", (DataType)MapType$.MODULE$.apply((DataType)new VarcharType(5), (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField49)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField50)), false);
        StructField structField51 = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField52 = new StructField("b", (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField51)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField52)), false);
        StructField structField53 = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField54 = new StructField("b", (DataType)new CharType(5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField53)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField54)), false);
        StructField structField55 = new StructField("a", (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField56 = new StructField("b", (DataType)new CharType(5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField55)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField56)), false);
        StructField structField57 = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField58 = new StructField("b", (DataType)new VarcharType(5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField57)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField58)), false);
        StructField structField59 = new StructField("a", (DataType)StringType$.MODULE$.apply("UTF8_LCASE"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField60 = new StructField("b", (DataType)new VarcharType(5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField59)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField60)), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new ArrayType((DataType)StringType$.MODULE$, true), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new ArrayType((DataType)StringType$.MODULE$, true), (DataType)new ArrayType((DataType)StringType$.MODULE$.apply("UTF8_LCASE"), false), false);
        this.checkEqualsIgnoreCompatibleCollation((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false), false);
        StructField structField61 = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField62 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleCollation((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField61)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField62)), false);
        this.test("SPARK-25031: MapType should produce current formatted string for complex types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType keyType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
            StructType valueType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("c", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
            StringConcat stringConcat = new StringConcat(StringConcat$.MODULE$.$lessinit$greater$default$1());
            MapType qual$1 = MapType$.MODULE$.apply((DataType)keyType, (DataType)valueType);
            String x$25 = "";
            StringConcat x$26 = stringConcat;
            int x$27 = qual$1.buildFormattedString$default$3();
            qual$1.buildFormattedString("", x$26, x$27);
            String result = stringConcat.toString();
            String expected = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-- key: struct\n        |    |-- a: integer (nullable = true)\n        |    |-- b: integer (nullable = true)\n        |-- value: struct (valueContainsNull = true)\n        |    |-- c: integer (nullable = true)\n        |    |-- d: integer (nullable = true)\n        |"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            String $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1145));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1122));
        this.test("schema with collation should not change during ser/de", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StringType standaloneString = StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID());
            ArrayType standaloneArray = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()));
            MapType standaloneMap = MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), (DataType)StringType$.MODULE$.apply(this.UTF8_LCASE_COLLATION_ID()));
            ArrayType standaloneNested = ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UTF8_LCASE_COLLATION_ID()))));
            StructField structField = new StructField("c1", (DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType simpleStruct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            StructField structField2 = new StructField("nested", (DataType)simpleStruct, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType nestedStruct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2));
            StructField structField3 = new StructField("c1", (DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField4 = new StructField("C1", (DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType caseInsensitiveNames = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3));
            StructField structField5 = new StructField("c1.*23?", (DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType specialCharsInName = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5));
            StructField structField6 = new StructField("arrayField", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID())), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType arrayInSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6));
            StructField structField7 = new StructField("mapField", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), (DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID())), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType mapInSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7));
            StructField structField8 = new StructField("name.key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField9 = new StructField("name", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), (DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID())), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType mapWithKeyInNameInSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField9).$colon$colon((Object)structField8));
            StructField structField10 = new StructField("arrInMap", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType arrayInMapInNestedSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField10));
            StructField structField11 = new StructField("nestedArrayInMap", (DataType)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION_ID()))))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType nestedArrayInMap = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField11));
            StructType schemaWithMultipleFields = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])simpleStruct.fields()), (Object)nestedStruct.fields(), ClassTag$.MODULE$.apply(StructField.class))), (Object)arrayInSchema.fields(), ClassTag$.MODULE$.apply(StructField.class))), (Object)mapInSchema.fields(), ClassTag$.MODULE$.apply(StructField.class))), (IterableOnce)mapWithKeyInNameInSchema, ClassTag$.MODULE$.apply(StructField.class))), (Object)arrayInMapInNestedSchema.fields(), ClassTag$.MODULE$.apply(StructField.class))), (Object)nestedArrayInMap.fields(), ClassTag$.MODULE$.apply(StructField.class)));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{standaloneString, standaloneArray, standaloneMap, standaloneNested, simpleStruct, caseInsensitiveNames, specialCharsInName, nestedStruct, arrayInSchema, mapInSchema, mapWithKeyInNameInSchema, nestedArrayInMap, arrayInMapInNestedSchema, schemaWithMultipleFields})).foreach((Function1 & Serializable)schema -> {
                String json = schema.json();
                DataType parsed = DataType$.MODULE$.fromJson(json);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(parsed);
                DataType $org_scalatest_assert_macro_right = schema;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1207));
            });
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1148));
        this.test("non string field has collation metadata", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String json = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"c1\",\n         |      \"type\": \"integer\",\n         |      \"nullable\": true,\n         |      \"metadata\": {\n         |        \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |          \"c1\": \"icu.UNICODE\"\n         |        }\n         |      }\n         |    }\n         |  ]\n         |}\n         |"));
            SparkIllegalArgumentException x$28 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson(json), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1232))));
            String x$29 = "INVALID_JSON_DATA_TYPE_FOR_COLLATIONS";
            scala.collection.immutable.Map x$30 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jsonType"), (Object)"integer")}));
            Option x$31 = this.checkError$default$3();
            boolean x$32 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$33 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$28, "INVALID_JSON_DATA_TYPE_FOR_COLLATIONS", x$31, x$30, x$32, x$33);
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1211));
        this.test("non string field in map key has collation metadata", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String json = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"mapField\",\n         |      \"type\": {\n         |        \"type\": \"map\",\n         |        \"keyType\": \"string\",\n         |        \"valueType\": \"integer\",\n         |        \"valueContainsNull\": true\n         |      },\n         |      \"nullable\": true,\n         |      \"metadata\": {\n         |        \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |          \"mapField.value\": \"icu.UNICODE\"\n         |        }\n         |      }\n         |    }\n         |  ]\n         |}\n         |"));
            SparkIllegalArgumentException x$34 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson(json), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1266))));
            String x$35 = "INVALID_JSON_DATA_TYPE_FOR_COLLATIONS";
            scala.collection.immutable.Map x$36 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jsonType"), (Object)"integer")}));
            Option x$37 = this.checkError$default$3();
            boolean x$38 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$39 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$34, "INVALID_JSON_DATA_TYPE_FOR_COLLATIONS", x$37, x$36, x$38, x$39);
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1240));
        this.test("map field has collation metadata", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String json = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"mapField\",\n         |      \"type\": {\n         |        \"type\": \"map\",\n         |        \"keyType\": \"string\",\n         |        \"valueType\": \"integer\",\n         |        \"valueContainsNull\": true\n         |      },\n         |      \"nullable\": true,\n         |      \"metadata\": {\n         |        \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |          \"mapField\": \"icu.UNICODE\"\n         |        }\n         |      }\n         |    }\n         |  ]\n         |}\n         |"));
            SparkIllegalArgumentException x$40 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson(json), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1300))));
            String x$41 = "INVALID_JSON_DATA_TYPE_FOR_COLLATIONS";
            scala.collection.immutable.Map x$42 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jsonType"), (Object)"map")}));
            Option x$43 = this.checkError$default$3();
            boolean x$44 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$45 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$40, "INVALID_JSON_DATA_TYPE_FOR_COLLATIONS", x$43, x$42, x$44, x$45);
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1274));
        this.test("non existing collation provider", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String json = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"c1\",\n         |      \"type\": \"string\",\n         |      \"nullable\": true,\n         |      \"metadata\": {\n         |        \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |          \"c1\": \"badProvider.UNICODE\"\n         |        }\n         |      }\n         |    }\n         |  ]\n         |}\n         |"));
            SparkException x$46 = (SparkException)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson(json), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1329));
            String x$47 = "COLLATION_INVALID_PROVIDER";
            scala.collection.immutable.Map x$48 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"badProvider"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"supportedProviders"), (Object)"spark, icu")}));
            Option x$49 = this.checkError$default$3();
            boolean x$50 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$51 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$46, "COLLATION_INVALID_PROVIDER", x$49, x$48, x$50, x$51);
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1308));
        this.test("parse array type with collation metadata", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int unicodeCollationId = CollationFactory.collationNameToId((String)"UNICODE");
            String arrayJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"array\",\n         |  \"elementType\": \"string\",\n         |  \"containsNull\": true\n         |}\n         |"));
            scala.collection.immutable.Map collationsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"element"), (Object)"UNICODE")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataType$.MODULE$.parseDataType(JsonMethods$.MODULE$.parse((Object)arrayJson, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())));
            ArrayType $org_scalatest_assert_macro_right = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1351));
            DataType parsedWithCollations = DataType$.MODULE$.parseDataType(JsonMethods$.MODULE$.parse((Object)arrayJson, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()), "", collationsMap);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(parsedWithCollations);
            ArrayType $org_scalatest_assert_macro_right2 = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(unicodeCollationId));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1355));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1337));
        this.test("parse map type with collation metadata", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int unicodeCollationId = CollationFactory.collationNameToId((String)"UNICODE");
            String mapJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"map\",\n         |  \"keyType\": \"string\",\n         |  \"valueType\": \"string\",\n         |  \"valueContainsNull\": true\n         |}\n         |"));
            scala.collection.immutable.Map collationsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)"UNICODE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"UNICODE")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataType$.MODULE$.parseDataType(JsonMethods$.MODULE$.parse((Object)mapJson, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())));
            MapType $org_scalatest_assert_macro_right = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1373));
            DataType parsedWithCollations = DataType$.MODULE$.parseDataType(JsonMethods$.MODULE$.parse((Object)mapJson, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()), "", collationsMap);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(parsedWithCollations);
            MapType $org_scalatest_assert_macro_right2 = MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(unicodeCollationId), (DataType)StringType$.MODULE$.apply(unicodeCollationId));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1377));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1358));
        this.test("SPARK-48680: Add CharType and VarcharType to DataTypes JAVA API", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataTypes.createCharType((int)1));
            CharType $org_scalatest_assert_macro_right = new CharType(1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1382));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DataTypes.createVarcharType((int)100));
            VarcharType $org_scalatest_assert_macro_right2 = new VarcharType(100);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1383));
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> DataTypes.createVarcharType((int)-1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1384));
            String $org_scalatest_assert_macro_left3 = exception.getMessage();
            String $org_scalatest_assert_macro_right3 = "The length of varchar type cannot be negative.";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1387));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1381));
        this.test("precisions of the TIME data type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(TimeType$.MODULE$.MIN_PRECISION()), TimeType$.MODULE$.MAX_PRECISION()).foreach((Function1 & Serializable)p -> DataTypeSuite.$anonfun$new$61(BoxesRunTime.unboxToInt((Object)p)));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{Integer.MIN_VALUE, TimeType$.MODULE$.MIN_PRECISION() - 1, TimeType$.MODULE$.MAX_PRECISION() + 1, Integer.MAX_VALUE})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)p -> {
                SparkException x$52 = (SparkException)this.intercept((Function0 & Serializable)() -> new TimeType(p), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1401));
                String x$53 = "UNSUPPORTED_TIME_PRECISION";
                scala.collection.immutable.Map x$54 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)Integer.toString(p))}));
                Option x$55 = this.checkError$default$3();
                boolean x$56 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$57 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$52, "UNSUPPORTED_TIME_PRECISION", x$55, x$54, x$56, x$57);
            });
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1390));
        this.test("Parse time(n) as TimeType(n)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable)n -> DataTypeSuite.$anonfun$new$65(BoxesRunTime.unboxToInt((Object)n)));
            SparkIllegalArgumentException x$58 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("\"time(9)\""), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1418))));
            String x$59 = "INVALID_JSON_DATA_TYPE";
            scala.collection.immutable.Map x$60 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidType"), (Object)"time(9)")}));
            Option x$61 = this.checkError$default$3();
            boolean x$62 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$63 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$58, "INVALID_JSON_DATA_TYPE", x$61, x$60, x$62, x$63);
            ParseException x$64 = (ParseException)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromDDL("t time(-1)"), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1424));
            String x$65 = "PARSE_SYNTAX_ERROR";
            scala.collection.immutable.Map x$66 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'time'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$67 = this.checkError$default$3();
            boolean x$68 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$69 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$64, "PARSE_SYNTAX_ERROR", x$67, x$66, x$68, x$69);
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1410));
    }
}

