/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Pmod$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns the positive value of `expr1` mod `expr2`.", examples="\n    Examples:\n      > SELECT _FUNC_(10, 3);\n       1\n      > SELECT _FUNC_(-10, 3);\n       2\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\tUf\u0001\u0002\u00192\u0001zB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003X\u0011!i\u0006A!f\u0001\n\u0003q\u0006\u0002C4\u0001\u0005#\u0005\u000b\u0011B0\t\u000b!\u0004A\u0011A5\t\u000b!\u0004A\u0011\u00018\t\u000bE\u0004A\u0011\t:\t\u000bm\u0004A\u0011\t?\t\u000bu\u0004A\u0011\t@\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!1\u0011Q\u0003\u0001\u0005BqDq!a\u0006\u0001\t\u0003\nI\u0002\u0003\u0006\u00028\u0001A)\u0019!C\u0005\u0003sA!\"a\u0012\u0001\u0011\u000b\u0007I\u0011BA%\u0011\u001d\t\t\u0006\u0001C#\u0003'Bq!!\u0019\u0001\t\u0003\n\u0019\u0007C\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\f\"9\u0011q\u0010\u0001\u0005\n\u0005]\u0005bBA@\u0001\u0011%\u00111\u0015\u0005\b\u0003\u007f\u0002A\u0011BAX\u0011\u001d\ty\b\u0001C\u0005\u0003wCq!a \u0001\t\u0013\t9\rC\u00037\u0001\u0011\u0005C\u0010C\u0004\u0002T\u0002!\t&!6\t\u0013\u0005}\u0007!!A\u0005\u0002\u0005\u0005\b\"CAu\u0001E\u0005I\u0011AAv\u0011%\u0011\t\u0001AI\u0001\n\u0003\tY\u000fC\u0005\u0003\u0004\u0001\t\n\u0011\"\u0001\u0003\u0006!I!\u0011\u0002\u0001\u0002\u0002\u0013\u0005#1\u0002\u0005\n\u00057\u0001\u0011\u0011!C\u0001\u0005;A\u0011Ba\b\u0001\u0003\u0003%\tA!\t\t\u0013\t\u001d\u0002!!A\u0005B\t%\u0002\"\u0003B\u001c\u0001\u0005\u0005I\u0011\u0001B\u001d\u0011%\u0011i\u0004AA\u0001\n\u0003\u0012y\u0004C\u0005\u0003D\u0001\t\t\u0011\"\u0011\u0003F\u001dI!\u0011N\u0019\u0002\u0002#\u0005!1\u000e\u0004\taE\n\t\u0011#\u0001\u0003n!1\u0001\u000e\u000bC\u0001\u0005\u000bC\u0001\"\u001d\u0015\u0002\u0002\u0013\u0015#q\u0011\u0005\n\u0005\u0013C\u0013\u0011!CA\u0005\u0017C\u0011Ba%)#\u0003%\tA!\u0002\t\u0013\tU\u0005&!A\u0005\u0002\n]\u0005\"\u0003BUQE\u0005I\u0011\u0001B\u0003\u0011%\u0011Y\u000bKA\u0001\n\u0013\u0011iK\u0001\u0003Q[>$'B\u0001\u001a4\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005Q*\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005Y:\u0014aA:rY*\u0011\u0001(O\u0001\u0006gB\f'o\u001b\u0006\u0003um\na!\u00199bG\",'\"\u0001\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001y4)\u0013\t\u0003\u0001\u0006k\u0011!M\u0005\u0003\u0005F\u0012\u0001CQ5oCJL\u0018I]5uQ6,G/[2\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000fA\u0013x\u000eZ;diB\u0011!J\u0015\b\u0003\u0017Bs!\u0001T(\u000e\u00035S!AT\u001f\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0015BA)F\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0015+\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005E+\u0015\u0001\u00027fMR,\u0012a\u0016\t\u0003\u0001bK!!W\u0019\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\tKZ\fG.T8eKV\tq\f\u0005\u0002aG:\u0011\u0001)Y\u0005\u0003EF\n\u0001\"\u0012<bY6{G-Z\u0005\u0003I\u0016\u0014QAV1mk\u0016L!AZ#\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\nKZ\fG.T8eK\u0002\na\u0001P5oSRtD\u0003\u00026lY6\u0004\"\u0001\u0011\u0001\t\u000bU;\u0001\u0019A,\t\u000bm;\u0001\u0019A,\t\u000fu;\u0001\u0013!a\u0001?R\u0019!n\u001c9\t\u000bUC\u0001\u0019A,\t\u000bmC\u0001\u0019A,\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u001d\t\u0003ibt!!\u001e<\u0011\u00051+\u0015BA<F\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005],\u0015AB:z[\n|G.F\u0001t\u0003%Ig\u000e];u)f\u0004X-F\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003k\u0005)A/\u001f9fg&!\u0011\u0011BA\u0002\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\t\ty\u0001E\u0002E\u0003#I1!a\u0005F\u0005\u001d\u0011un\u001c7fC:\fQ\u0002Z3dS6\fG.T3uQ>$\u0017!\u0005:fgVdG\u000fR3dS6\fG\u000eV=qKRQ\u00111DA\u0011\u0003W\ty#a\r\u0011\t\u0005\u0005\u0011QD\u0005\u0005\u0003?\t\u0019AA\u0006EK\u000eLW.\u00197UsB,\u0007bBA\u0012\u001d\u0001\u0007\u0011QE\u0001\u0003aF\u00022\u0001RA\u0014\u0013\r\tI#\u0012\u0002\u0004\u0013:$\bbBA\u0017\u001d\u0001\u0007\u0011QE\u0001\u0003gFBq!!\r\u000f\u0001\u0004\t)#\u0001\u0002qe!9\u0011Q\u0007\bA\u0002\u0005\u0015\u0012AA:3\u0003\u0019I7OW3s_V\u0011\u00111\b\t\b\t\u0006u\u0012\u0011IA\b\u0013\r\ty$\u0012\u0002\n\rVt7\r^5p]F\u00022\u0001RA\"\u0013\r\t)%\u0012\u0002\u0004\u0003:L\u0018\u0001\u00039n_\u00124UO\\2\u0016\u0005\u0005-\u0003#\u0003#\u0002N\u0005\u0005\u0013\u0011IA!\u0013\r\ty%\u0012\u0002\n\rVt7\r^5p]J\nA!\u001a<bYR!\u0011\u0011IA+\u0011%\t9&\u0005I\u0001\u0002\u0004\tI&A\u0003j]B,H\u000f\u0005\u0003\u0002\\\u0005uS\"A\u001a\n\u0007\u0005}3GA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t)'!\u001d\u0002|A!\u0011qMA7\u001b\t\tIGC\u0002\u0002lE\nqaY8eK\u001e,g.\u0003\u0003\u0002p\u0005%$\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005M$\u00031\u0001\u0002v\u0005\u00191\r\u001e=\u0011\t\u0005\u001d\u0014qO\u0005\u0005\u0003s\nIG\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005u$\u00031\u0001\u0002f\u0005\u0011QM^\u0001\u0005a6|G\r\u0006\u0004\u0002&\u0005\r\u0015q\u0011\u0005\b\u0003\u000b\u001b\u0002\u0019AA\u0013\u0003\u0005\t\u0007bBAE'\u0001\u0007\u0011QE\u0001\u0002]R1\u0011QRAJ\u0003+\u00032\u0001RAH\u0013\r\t\t*\u0012\u0002\u0005\u0019>tw\rC\u0004\u0002\u0006R\u0001\r!!$\t\u000f\u0005%E\u00031\u0001\u0002\u000eR1\u0011\u0011TAP\u0003C\u00032\u0001RAN\u0013\r\ti*\u0012\u0002\u0005\u0005f$X\rC\u0004\u0002\u0006V\u0001\r!!'\t\u000f\u0005%U\u00031\u0001\u0002\u001aR1\u0011QUAV\u0003[\u00032\u0001RAT\u0013\r\tI+\u0012\u0002\u0007\t>,(\r\\3\t\u000f\u0005\u0015e\u00031\u0001\u0002&\"9\u0011\u0011\u0012\fA\u0002\u0005\u0015FCBAY\u0003o\u000bI\fE\u0002E\u0003gK1!!.F\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\t)i\u0006a\u0001\u0003cCq!!#\u0018\u0001\u0004\t\t\f\u0006\u0004\u0002>\u0006\r\u0017Q\u0019\t\u0004\t\u0006}\u0016bAAa\u000b\n)a\t\\8bi\"9\u0011Q\u0011\rA\u0002\u0005u\u0006bBAE1\u0001\u0007\u0011Q\u0018\u000b\u0007\u0003\u0013\fy-!5\u0011\t\u0005\u0005\u00111Z\u0005\u0005\u0003\u001b\f\u0019AA\u0004EK\u000eLW.\u00197\t\u000f\u0005\u0015\u0015\u00041\u0001\u0002J\"9\u0011\u0011R\rA\u0002\u0005%\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015Q\u0017q[An\u0011\u0019\tIn\u0007a\u0001/\u00069a.Z<MK\u001a$\bBBAo7\u0001\u0007q+\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000f)\f\u0019/!:\u0002h\"9Q\u000b\bI\u0001\u0002\u00049\u0006bB.\u001d!\u0003\u0005\ra\u0016\u0005\b;r\u0001\n\u00111\u0001`\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!<+\u0007]\u000byo\u000b\u0002\u0002rB!\u00111_A\u007f\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018!C;oG\",7m[3e\u0015\r\tY0R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0000\u0003k\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\b)\u001aq,a<\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011i\u0001\u0005\u0003\u0003\u0010\teQB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\t1\fgn\u001a\u0006\u0003\u0005/\tAA[1wC&\u0019\u0011P!\u0005\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0003\u0012\u0019\u0003C\u0005\u0003&\t\n\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u000b\u0011\r\t5\"1GA!\u001b\t\u0011yCC\u0002\u00032\u0015\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Da\f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001f\u0011Y\u0004C\u0005\u0003&\u0011\n\t\u00111\u0001\u0002B\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011iA!\u0011\t\u0013\t\u0015R%!AA\u0002\u0005\u0015\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0010\t\u001d\u0003\"\u0003B\u0013M\u0005\u0005\t\u0019AA!QM\u0001!1\nB)\u0005'\u00129F!\u0017\u0003^\t}#1\rB3!\r\u0001%QJ\u0005\u0004\u0005\u001f\n$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005+\n\u0011j\u0018$V\u001d\u000e{\u0006&\u001a=qeFb\u0003%\u001a=qeJJ\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005]8tSRLg/\u001a\u0011wC2,X\rI8gA\u0001,\u0007\u0010\u001d:2A\u0002jw\u000e\u001a\u0011aKb\u0004(O\r1/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B.\u0003\u0001T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0019-AMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\n\u0004\u0007\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002#G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t'A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0003h\u0005QQ.\u0019;i?\u001a,hnY:\u0002\tAkw\u000e\u001a\t\u0003\u0001\"\u001aR\u0001\u000bB8\u0005w\u0002\u0002B!\u001d\u0003x];vL[\u0007\u0003\u0005gR1A!\u001eF\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u001f\u0003t\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\tu$1Q\u0007\u0003\u0005\u007fRAA!!\u0003\u0016\u0005\u0011\u0011n\\\u0005\u0004'\n}DC\u0001B6)\t\u0011i!A\u0003baBd\u0017\u0010F\u0004k\u0005\u001b\u0013yI!%\t\u000bU[\u0003\u0019A,\t\u000bm[\u0003\u0019A,\t\u000fu[\u0003\u0013!a\u0001?\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\te%Q\u0015\t\u0006\t\nm%qT\u0005\u0004\u0005;+%AB(qi&|g\u000e\u0005\u0004E\u0005C;vkX\u0005\u0004\u0005G+%A\u0002+va2,7\u0007\u0003\u0005\u0003(6\n\t\u00111\u0001k\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t=\u0006\u0003\u0002B\b\u0005cKAAa-\u0003\u0012\t1qJ\u00196fGR\u0004")
public class Pmod
extends BinaryArithmetic {
    private Function1<Object, Object> isZero;
    private Function2<Object, Object, Object> pmodFunc;
    private final Expression left;
    private final Expression right;
    private final Enumeration.Value evalMode;
    private volatile byte bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$3() {
        return Pmod$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Enumeration.Value>> unapply(Pmod x$0) {
        return Pmod$.MODULE$.unapply(x$0);
    }

    public static Enumeration.Value apply$default$3() {
        return Pmod$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Enumeration.Value>, Pmod> tupled() {
        return Pmod$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Enumeration.Value, Pmod>>> curried() {
        return Pmod$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    @Override
    public String toString() {
        return "pmod(" + this.left() + ", " + this.right() + ")";
    }

    @Override
    public String symbol() {
        return "pmod";
    }

    @Override
    public AbstractDataType inputType() {
        return NumericType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String decimalMethod() {
        return "remainder";
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int resultScale = package$.MODULE$.max(s1, s2);
        int resultPrecision = package$.MODULE$.min(p1 - s1, p2 - s2) + resultScale;
        if (this.allowPrecisionLoss()) {
            return DecimalType$.MODULE$.adjustPrecisionScale(resultPrecision, resultScale);
        }
        return DecimalType$.MODULE$.bounded(resultPrecision, resultScale);
    }

    private Function1<Object, Object> isZero$lzycompute() {
        Pmod pmod = this;
        synchronized (pmod) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType = this.right().dataType();
                this.isZero = dataType instanceof DecimalType ? (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Pmod.$anonfun$isZero$3(x)) : (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Pmod.$anonfun$isZero$4(x));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.isZero;
    }

    private Function1<Object, Object> isZero() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.isZero$lzycompute();
        }
        return this.isZero;
    }

    private Function2<Object, Object, Object> pmodFunc$lzycompute() {
        Pmod pmod = this;
        synchronized (pmod) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DecimalType decimalType;
                Option option;
                Function2 & Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof IntegerType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToInteger((int)this.pmod(BoxesRunTime.unboxToInt((Object)l), BoxesRunTime.unboxToInt((Object)r)));
                } else if (dataType instanceof LongType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToLong((long)this.pmod(BoxesRunTime.unboxToLong((Object)l), BoxesRunTime.unboxToLong((Object)r)));
                } else if (dataType instanceof ShortType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToShort((short)this.pmod(BoxesRunTime.unboxToShort((Object)l), BoxesRunTime.unboxToShort((Object)r)));
                } else if (dataType instanceof ByteType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToByte((byte)this.pmod(BoxesRunTime.unboxToByte((Object)l), BoxesRunTime.unboxToByte((Object)r)));
                } else if (dataType instanceof FloatType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToFloat((float)this.pmod(BoxesRunTime.unboxToFloat((Object)l), BoxesRunTime.unboxToFloat((Object)r)));
                } else if (dataType instanceof DoubleType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToDouble((double)this.pmod(BoxesRunTime.unboxToDouble((Object)l), BoxesRunTime.unboxToDouble((Object)r)));
                } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = (Function2 & Serializable)(l, r) -> this.checkDecimalOverflow(this.pmod((Decimal)l, (Decimal)r), precision, scale);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.pmodFunc = intersect;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.pmodFunc;
    }

    private Function2<Object, Object, Object> pmodFunc() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.pmodFunc$lzycompute();
        }
        return this.pmodFunc;
    }

    @Override
    public final Object eval(InternalRow input) {
        Object input2 = this.right().eval(input);
        if (input2 == null || !this.failOnError() && BoxesRunTime.unboxToBoolean((Object)this.isZero().apply(input2))) {
            return null;
        }
        Object input1 = this.left().eval(input);
        if (input1 == null) {
            return null;
        }
        if (BoxesRunTime.unboxToBoolean((Object)this.isZero().apply(input2))) {
            throw QueryExecutionErrors$.MODULE$.remainderByZeroError(this.getContextOrNull());
        }
        return this.pmodFunc().apply(input1, input2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String result;
        DecimalType decimalType;
        Option option;
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String isZero = this.dataType() instanceof DecimalType ? eval2.value() + ".isZero()" : eval2.value() + " == 0";
        String remainder = ctx.freshName("remainder");
        String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            String decimalAdd = "$plus";
            v0 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + javaType + " " + remainder + " = " + eval1.value() + "." + this.decimalMethod() + "(" + eval2.value() + ");\n           |if (" + remainder + ".compare(new org.apache.spark.sql.types.Decimal().set(0)) < 0) {\n           |  " + ev.value() + "=(" + remainder + "." + decimalAdd + "(" + eval2.value() + "))." + this.decimalMethod() + "(" + eval2.value() + ");\n           |} else {\n           |  " + ev.value() + "=" + remainder + ";\n           |}\n           |" + ev.value() + " = " + ev.value() + ".toPrecision(\n           |  " + precision + ", " + scale + ", Decimal.ROUND_HALF_UP(), " + !this.failOnError() + ", " + errorContext + ");\n           |" + ev.isNull() + " = " + ev.value() + " == null;\n           |"));
        } else {
            v0 = result = (ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType)) ? "\n          " + javaType + " " + remainder + " = (" + javaType + ")(" + eval1.value() + " % " + eval2.value() + ");\n          if (" + remainder + " < 0) {\n            " + ev.value() + "=(" + javaType + ")((" + remainder + " + " + eval2.value() + ") % " + eval2.value() + ");\n          } else {\n            " + ev.value() + "=" + remainder + ";\n          }\n        " : "\n          " + javaType + " " + remainder + " = " + eval1.value() + " % " + eval2.value() + ";\n          if (" + remainder + " < 0) {\n            " + ev.value() + "=(" + remainder + " + " + eval2.value() + ") % " + eval2.value() + ";\n          } else {\n            " + ev.value() + "=" + remainder + ";\n          }\n        ";
        }
        if (!this.left().nullable() && !this.right().nullable()) {
            String divByZero = this.failOnError() ? "throw QueryExecutionErrors.remainderByZeroError(" + errorContext + ");" : ev.isNull() + " = true;";
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        boolean ", " = false;\n        ", " ", " = ", ";\n        if (", ") {\n          ", "\n        } else {\n          ", "\n          ", "\n        }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), isZero, divByZero, eval1.code(), result})), ev.copy$default$2(), ev.copy$default$3());
        }
        Object nullOnErrorCondition = this.failOnError() ? "" : " || " + isZero;
        String failOnErrorBranch = this.failOnError() ? "if (" + isZero + ") throw QueryExecutionErrors.remainderByZeroError(" + errorContext + ");" : "";
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        boolean ", " = false;\n        ", " ", " = ", ";\n        if (", "", ") {\n          ", " = true;\n        } else {\n          ", "\n          if (", ") {\n            ", " = true;\n          } else {\n            ", "\n            ", "\n          }\n        }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), eval2.isNull(), nullOnErrorCondition, ev.isNull(), eval1.code(), eval1.isNull(), ev.isNull(), failOnErrorBranch, result})), ev.copy$default$2(), ev.copy$default$3());
    }

    private int pmod(int a, int n) {
        int r = a % n;
        if (r < 0) {
            return (r + n) % n;
        }
        return r;
    }

    private long pmod(long a, long n) {
        long r = a % n;
        if (r < 0L) {
            return (r + n) % n;
        }
        return r;
    }

    private byte pmod(byte a, byte n) {
        int r = a % n;
        if (r < 0) {
            return (byte)((r + n) % n);
        }
        return (byte)r;
    }

    private double pmod(double a, double n) {
        double r = a % n;
        if (r < 0.0) {
            return (r + n) % n;
        }
        return r;
    }

    private short pmod(short a, short n) {
        int r = a % n;
        if (r < 0) {
            return (short)((r + n) % n);
        }
        return (short)r;
    }

    private float pmod(float a, float n) {
        float r = a % n;
        if (r < 0.0f) {
            return (r + n) % n;
        }
        return r;
    }

    private Decimal pmod(Decimal a, Decimal n) {
        Decimal r = a.$percent(n);
        if (r != null && r.compare(Decimal$.MODULE$.ZERO()) < 0) {
            return r.$plus(n).$percent(n);
        }
        return r;
    }

    @Override
    public String sql() {
        return this.prettyName() + "(" + this.left().sql() + ", " + this.right().sql() + ")";
    }

    @Override
    public Pmod withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Pmod copy(Expression left, Expression right, Enumeration.Value evalMode) {
        return new Pmod(left, right, evalMode);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Enumeration.Value copy$default$3() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "Pmod";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalMode();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Pmod;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "evalMode";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Pmod)) return false;
        boolean bl = true;
        if (!bl) return false;
        Pmod pmod = (Pmod)x$1;
        Expression expression = this.left();
        Expression expression2 = pmod.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = pmod.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = pmod.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!pmod.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isZero$3(Object x) {
        return ((Decimal)x).isZero();
    }

    public static final /* synthetic */ boolean $anonfun$isZero$4(Object x) {
        return BoxesRunTime.equals((Object)x, (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public Pmod(Expression left, Expression right, Enumeration.Value evalMode) {
        this.left = left;
        this.right = right;
        this.evalMode = evalMode;
    }

    public Pmod(Expression left, Expression right) {
        this(left, right, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

