/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAccumulate$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, maxItemsTracked) - Accumulates items into a sketch.\n      `maxItemsTracked` An optional positive INTEGER literal with upper limit of 1000000. If maxItemsTracked is not specified, it defaults to 10000.\n  ", examples="\n    Examples:\n      > SELECT approx_top_k_estimate(_FUNC_(expr)) FROM VALUES (0), (0), (1), (1), (2), (3), (4), (4) AS tab(expr);\n       [{\"item\":0,\"count\":2},{\"item\":4,\"count\":2},{\"item\":1,\"count\":2},{\"item\":2,\"count\":1},{\"item\":3,\"count\":1}]\n\n      > SELECT approx_top_k_estimate(_FUNC_(expr, 100), 2) FROM VALUES 'a', 'b', 'c', 'c', 'c', 'c', 'd', 'd' AS tab(expr);\n       [{\"item\":\"c\",\"count\":4},{\"item\":\"d\",\"count\":2}]\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\tuf\u0001\u0002\u001c8\u0001\u001aC\u0001\"\u001e\u0001\u0003\u0016\u0004%\tA\u001e\u0005\to\u0002\u0011\t\u0012)A\u0005G\"A\u0001\u0010\u0001BK\u0002\u0013\u0005a\u000f\u0003\u0005z\u0001\tE\t\u0015!\u0003d\u0011!Q\bA!f\u0001\n\u0003Y\b\u0002C@\u0001\u0005#\u0005\u000b\u0011\u0002?\t\u0013\u0005\u0005\u0001A!f\u0001\n\u0003Y\b\"CA\u0002\u0001\tE\t\u0015!\u0003}\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0002\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u0006\u0001!\t!a\u0007\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\"!Q\u0011Q\u0005\u0001\t\u0006\u0004%I!a\n\t\u0013\u0005U\u0002\u0001#b\u0001\n\u0013Y\bBBA\u001c\u0001\u0011\u0005c\u000f\u0003\u0004\u0002:\u0001!\tE\u001e\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!a\u0017\u0001\t\u0003\n9\u0003C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t)\n\u0001C!\u0003/Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005M\u0006\u0001\"\u0015\u00026\"9\u0011q\u0018\u0001\u0005B\u0005\u0005\u0007bBAe\u0001\u0011\u0005\u00131\u001a\u0005\n\u0003;\u0004\u0011\u0011!C\u0001\u0003?D\u0011\"!;\u0001#\u0003%\t!a;\t\u0013\t\u0005\u0001!%A\u0005\u0002\u0005-\b\"\u0003B\u0002\u0001E\u0005I\u0011\u0001B\u0003\u0011%\u0011I\u0001AI\u0001\n\u0003\u0011)\u0001C\u0005\u0003\f\u0001\t\t\u0011\"\u0011\u0003\u000e!A!Q\u0004\u0001\u0002\u0002\u0013\u00051\u0010C\u0005\u0003 \u0001\t\t\u0011\"\u0001\u0003\"!I!q\u0005\u0001\u0002\u0002\u0013\u0005#\u0011\u0006\u0005\n\u0005o\u0001\u0011\u0011!C\u0001\u0005sA\u0011B!\u0010\u0001\u0003\u0003%\tEa\u0010\t\u0013\t\r\u0003!!A\u0005B\t\u0015s!\u0003B5o\u0005\u0005\t\u0012\u0001B6\r!1t'!A\t\u0002\t5\u0004bBA\u0003Y\u0011\u0005!Q\u0011\u0005\n\u0005\u000fc\u0013\u0011!C#\u0005\u0013C\u0011Ba#-\u0003\u0003%\tI!$\t\u0013\t]E&%A\u0005\u0002\t\u0015\u0001\"\u0003BMYE\u0005I\u0011\u0001B\u0003\u0011%\u0011Y\nLA\u0001\n\u0003\u0013i\nC\u0005\u000302\n\n\u0011\"\u0001\u0003\u0006!I!\u0011\u0017\u0017\u0012\u0002\u0013\u0005!Q\u0001\u0005\n\u0005gc\u0013\u0011!C\u0005\u0005k\u0013A#\u00119qe>DHk\u001c9L\u0003\u000e\u001cW/\\;mCR,'B\u0001\u001d:\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002;w\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taT(\u0001\u0005dCR\fG._:u\u0015\tqt(A\u0002tc2T!\u0001Q!\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001b\u0015AB1qC\u000eDWMC\u0001E\u0003\ry'oZ\u0002\u0001'\u0019\u0001q)W/gSB\u0019\u0001*S&\u000e\u0003]J!AS\u001c\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\rE\u0002M#Nk\u0011!\u0014\u0006\u0003\u001d>\u000b1B\u001a:fcV,gnY5fg*\u0011\u0001+Q\u0001\rI\u0006$\u0018m]6fi\u000eDWm]\u0005\u0003%6\u00131\"\u0013;f[N\u001c6.\u001a;dQB\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n\u0019\u0011I\\=\u0011\u0005i[V\"A\u001d\n\u0005qK$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0007y\u000b7-D\u0001`\u0015\t\u00017(A\u0003ue\u0016,7/\u0003\u0002c?\nQ!)\u001b8befd\u0015n[3\u0011\u0005i#\u0017BA3:\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003)\u001eL!\u0001[+\u0003\u000fA\u0013x\u000eZ;diB\u0011!N\u001d\b\u0003WBt!\u0001\\8\u000e\u00035T!A\\#\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0016BA9V\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001d;\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005E,\u0016\u0001B3yaJ,\u0012aY\u0001\u0006Kb\u0004(\u000fI\u0001\u0010[\u0006D\u0018\n^3ngR\u0013\u0018mY6fI\u0006\u0001R.\u0019=Ji\u0016l7\u000f\u0016:bG.,G\rI\u0001\u0017[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiV\tA\u0010\u0005\u0002U{&\u0011a0\u0016\u0002\u0004\u0013:$\u0018aF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003QIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006)\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006\u0002\n\u0005-\u0011QBA\b\u0003#\u0001\"\u0001\u0013\u0001\t\u000bUL\u0001\u0019A2\t\u000baL\u0001\u0019A2\t\u000fiL\u0001\u0013!a\u0001y\"A\u0011\u0011A\u0005\u0011\u0002\u0003\u0007A\u0010\u0006\u0004\u0002\n\u0005U\u0011\u0011\u0004\u0005\u0007\u0003/Q\u0001\u0019A2\u0002\u000b\rD\u0017\u000e\u001c3\t\u000baT\u0001\u0019A2\u0015\r\u0005%\u0011QDA\u0010\u0011\u0019\t9b\u0003a\u0001G\")\u0001p\u0003a\u0001yR!\u0011\u0011BA\u0012\u0011\u0019\t9\u0002\u0004a\u0001G\u0006a\u0011\u000e^3n\t\u0006$\u0018\rV=qKV\u0011\u0011\u0011\u0006\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF\u001f\u0002\u000bQL\b/Z:\n\t\u0005M\u0012Q\u0006\u0002\t\t\u0006$\u0018\rV=qK\u0006\u0011R.\u0019=Ji\u0016l7\u000f\u0016:bG.,GMV1m\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002@A)!.!\u0011\u0002F%\u0019\u00111\t;\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002,\u0005\u001d\u0013\u0002BA%\u0003[\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U3(\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tI&a\u0015\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0001\u0002Z1uCRK\b/Z\u0001\u0018GJ,\u0017\r^3BO\u001e\u0014XmZ1uS>t')\u001e4gKJ$\u0012aS\u0001\u0007kB$\u0017\r^3\u0015\u000b-\u000b)'!\u001b\t\r\u0005\u001dT\u00031\u0001L\u0003\u0019\u0011WO\u001a4fe\"9\u00111N\u000bA\u0002\u00055\u0014!B5oaV$\b\u0003BA8\u0003cj\u0011aO\u0005\u0004\u0003gZ$aC%oi\u0016\u0014h.\u00197S_^\fQ!\\3sO\u0016$RaSA=\u0003wBa!a\u001a\u0017\u0001\u0004Y\u0005BBA6-\u0001\u00071*\u0001\u0003fm\u0006dGcA*\u0002\u0002\"1\u0011qM\fA\u0002-\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005\u001d\u00151\u0013\t\u0006)\u0006%\u0015QR\u0005\u0004\u0003\u0017+&!B!se\u0006L\bc\u0001+\u0002\u0010&\u0019\u0011\u0011S+\u0003\t\tKH/\u001a\u0005\u0007\u0003OB\u0002\u0019A&\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\u0017\u0006e\u0005bBAN3\u0001\u0007\u0011qQ\u0001\u000egR|'/Y4f\r>\u0014X.\u0019;\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!!)\u0002(B\u0019\u0001*a)\n\u0007\u0005\u0015vGA\nJ[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0003\u0004\u0002*j\u0001\r\u0001`\u0001\u001a]\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0005\u0003C\u000by\u000b\u0003\u0004\u00022n\u0001\r\u0001`\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b\r\f9,a/\t\r\u0005eF\u00041\u0001d\u0003\u001dqWm\u001e'fMRDa!!0\u001d\u0001\u0004\u0019\u0017\u0001\u00038foJKw\r\u001b;\u0002\u00119,H\u000e\\1cY\u0016,\"!a1\u0011\u0007Q\u000b)-C\u0002\u0002HV\u0013qAQ8pY\u0016\fg.\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!4\u0011\t\u0005=\u0017q\u001b\b\u0005\u0003#\f\u0019\u000e\u0005\u0002m+&\u0019\u0011Q[+\u0002\rA\u0013X\rZ3g\u0013\u0011\tI.a7\u0003\rM#(/\u001b8h\u0015\r\t).V\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002\n\u0005\u0005\u00181]As\u0003ODq!^\u0010\u0011\u0002\u0003\u00071\rC\u0004y?A\u0005\t\u0019A2\t\u000fi|\u0002\u0013!a\u0001y\"A\u0011\u0011A\u0010\u0011\u0002\u0003\u0007A0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055(fA2\u0002p.\u0012\u0011\u0011\u001f\t\u0005\u0003g\fi0\u0004\u0002\u0002v*!\u0011q_A}\u0003%)hn\u00195fG.,GMC\u0002\u0002|V\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty0!>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0001\u0016\u0004y\u0006=\u0018AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t=\u0001\u0003\u0002B\t\u00057i!Aa\u0005\u000b\t\tU!qC\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u001a\u0005!!.\u0019<b\u0013\u0011\tINa\u0005\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191Ka\t\t\u0011\t\u0015b%!AA\u0002q\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0016!\u0015\u0011iCa\rT\u001b\t\u0011yCC\u0002\u00032U\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Da\f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0007\u0014Y\u0004\u0003\u0005\u0003&!\n\t\u00111\u0001T\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t=!\u0011\t\u0005\t\u0005KI\u0013\u0011!a\u0001y\u00061Q-];bYN$B!a1\u0003H!A!Q\u0005\u0016\u0002\u0002\u0003\u00071\u000bK\n\u0001\u0005\u0017\u0012\tFa\u0015\u0003X\te#Q\fB0\u0005G\u0012)\u0007E\u0002[\u0005\u001bJ1Aa\u0014:\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0016\u0002\u0003wS\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(\u000f\f\u0011nCbLE/Z7t)J\f7m[3eS\u0001j\u0003%Q2dk6,H.\u0019;fg\u0002JG/Z7tA%tGo\u001c\u0011bAM\\W\r^2i])\u0001\u0003\u0005\t\u0011!A\u0001l\u0017\r_%uK6\u001cHK]1dW\u0016$\u0007\rI!oA=\u0004H/[8oC2\u0004\u0003o\\:ji&4X\rI%O)\u0016;UI\u0015\u0011mSR,'/\u00197!o&$\b\u000eI;qa\u0016\u0014\b\u0005\\5nSR\u0004sN\u001a\u00112aA\u0002\u0004\u0007\r\u0019/A%3\u0007%\\1y\u0013R,Wn\u001d+sC\u000e\\W\r\u001a\u0011jg\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI2\u0002\u0013\u000e\u001e\u0011eK\u001a\fW\u000f\u001c;tAQ|\u0007%\r\u00191aAr#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u0017\u0002\u0007/R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u00199qe>Dx\f^8q?.|Vm\u001d;j[\u0006$X\rK0G+:\u001bu\fK3yaJL\u0013\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003\u0006M\u0015-A!\u0002\u0014\u0006\f\u0011)c%b\u0003\u0005K\u0019*Y\u0001B#'\u000b\u0017!QMJC\u0006\t\u00155S1\u0002\u0003\u0006N\u0015!\u0003N\u0003C/\u00192)Kb\u0004(/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7n\u0014\u0013\u000e^3nEi\u0002DFI2pk:$(E\u000f\u001a~Ym\u0014\u0013\u000e^3nEi\"DFI2pk:$(E\u000f\u001a~Ym\u0014\u0013\u000e^3nEi\nDFI2pk:$(E\u000f\u001a~Ym\u0014\u0013\u000e^3nEi\u0012DFI2pk:$(EO\u0019~Ym\u0014\u0013\u000e^3nEi\u001aDFI2pk:$(EO\u0019~;*Q\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u00199qe>Dx\f^8q?.|Vm\u001d;j[\u0006$X\rK0G+:\u001bu\fK3yaJd\u0003%\r\u00191S1\u0002#'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006eJ1(Y\u0001:#m\n\u0017!O\r<C\u0006I\u0014dO1\u0002seY\u0014-A\u001d\u001aw\u0005\f\u0011(I\u001eb\u0003e\n3(A\u0005\u001b\u0006\u0005^1cQ\u0015D\bO]\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u001b;f[\nR$e\u0019\u0012-E\r|WO\u001c;#uQjHf\u001f\u0012ji\u0016l'E\u000f\u0012eE1\u00123m\\;oi\nR$'`/\u000bA\u0001\nQa\u001a:pkB\f#A!\u0019\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B4\u0003\u0015!d&\r\u00181\u0003Q\t\u0005\u000f\u001d:pqR{\u0007oS!dGVlW\u000f\\1uKB\u0011\u0001\nL\n\u0006Y\t=$1\u0010\t\u000b\u0005c\u00129hY2}y\u0006%QB\u0001B:\u0015\r\u0011)(V\u0001\beVtG/[7f\u0013\u0011\u0011IHa\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003~\t\rUB\u0001B@\u0015\u0011\u0011\tIa\u0006\u0002\u0005%|\u0017bA:\u0003\u0000Q\u0011!1N\u0001\ti>\u001cFO]5oOR\u0011!qB\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003\u0013\u0011yI!%\u0003\u0014\nU\u0005\"B;0\u0001\u0004\u0019\u0007\"\u0002=0\u0001\u0004\u0019\u0007b\u0002>0!\u0003\u0005\r\u0001 \u0005\t\u0003\u0003y\u0003\u0013!a\u0001y\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BAa(\u0003,B)AK!)\u0003&&\u0019!1U+\u0003\r=\u0003H/[8o!\u001d!&qU2dyrL1A!+V\u0005\u0019!V\u000f\u001d7fi!I!Q\u0016\u001a\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005o\u0003BA!\u0005\u0003:&!!1\u0018B\n\u0005\u0019y%M[3di\u0002")
public class ApproxTopKAccumulate
extends TypedImperativeAggregate<ItemsSketch<Object>>
implements ImplicitCastInputTypes,
BinaryLike<Expression>,
Serializable {
    private DataType itemDataType;
    private int maxItemsTrackedVal;
    private final Expression expr;
    private final Expression maxItemsTracked;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$4() {
        return ApproxTopKAccumulate$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return ApproxTopKAccumulate$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(ApproxTopKAccumulate x$0) {
        return ApproxTopKAccumulate$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return ApproxTopKAccumulate$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return ApproxTopKAccumulate$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, ApproxTopKAccumulate> tupled() {
        return ApproxTopKAccumulate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, ApproxTopKAccumulate>>>> curried() {
        return ApproxTopKAccumulate$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproxTopKAccumulate approxTopKAccumulate = this;
        synchronized (approxTopKAccumulate) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression expr() {
        return this.expr;
    }

    public Expression maxItemsTracked() {
        return this.maxItemsTracked;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType itemDataType$lzycompute() {
        ApproxTopKAccumulate approxTopKAccumulate = this;
        synchronized (approxTopKAccumulate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.itemDataType = this.expr().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.itemDataType;
    }

    private DataType itemDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.itemDataType$lzycompute();
        }
        return this.itemDataType;
    }

    /*
     * WARNING - void declaration
     */
    private int maxItemsTrackedVal$lzycompute() {
        ApproxTopKAccumulate approxTopKAccumulate = this;
        synchronized (approxTopKAccumulate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                ApproxTopK$.MODULE$.checkExpressionNotNull(this.maxItemsTracked(), "maxItemsTracked");
                int maxItemsTrackedVal = BoxesRunTime.unboxToInt((Object)this.maxItemsTracked().eval(this.maxItemsTracked().eval$default$1()));
                ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTrackedVal);
                this.maxItemsTrackedVal = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.maxItemsTrackedVal;
    }

    private int maxItemsTrackedVal() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.maxItemsTrackedVal$lzycompute();
        }
        return this.maxItemsTrackedVal;
    }

    @Override
    public Expression left() {
        return this.expr();
    }

    @Override
    public Expression right() {
        return this.maxItemsTracked();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!ApproxTopK$.MODULE$.isDataTypeSupported(this.itemDataType())) {
            return new TypeCheckResult.TypeCheckFailure(this.itemDataType().typeName() + " columns are not supported");
        }
        if (!this.maxItemsTracked().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("Number of items tracked must be a constant literal");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return ApproxTopK$.MODULE$.getSketchStateDataType(this.itemDataType());
    }

    @Override
    public ItemsSketch<Object> createAggregationBuffer() {
        int maxMapSize = ApproxTopK$.MODULE$.calMaxMapSize(this.maxItemsTrackedVal());
        return ApproxTopK$.MODULE$.createAggregationBuffer(this.expr(), maxMapSize);
    }

    @Override
    public ItemsSketch<Object> update(ItemsSketch<Object> buffer, InternalRow input) {
        return ApproxTopK$.MODULE$.updateSketchBuffer(this.expr(), buffer, input);
    }

    @Override
    public ItemsSketch<Object> merge(ItemsSketch<Object> buffer, ItemsSketch<Object> input) {
        return buffer.merge(input);
    }

    @Override
    public Object eval(ItemsSketch<Object> buffer) {
        byte[] sketchBytes = this.serialize(buffer);
        return InternalRow$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sketchBytes, null, BoxesRunTime.boxToInteger((int)this.maxItemsTrackedVal())}));
    }

    @Override
    public byte[] serialize(ItemsSketch<Object> buffer) {
        return buffer.toByteArray(ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ItemsSketch<Object> deserialize(byte[] storageFormat) {
        return ItemsSketch.getInstance((Memory)Memory.wrap((byte[])storageFormat), ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "approx_top_k_accumulate");
    }

    public ApproxTopKAccumulate copy(Expression expr, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproxTopKAccumulate(expr, maxItemsTracked, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Expression copy$default$2() {
        return this.maxItemsTracked();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproxTopKAccumulate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return this.maxItemsTracked();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproxTopKAccumulate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "maxItemsTracked";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproxTopKAccumulate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproxTopKAccumulate approxTopKAccumulate = (ApproxTopKAccumulate)x$1;
        if (this.mutableAggBufferOffset() != approxTopKAccumulate.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approxTopKAccumulate.inputAggBufferOffset()) return false;
        Expression expression = this.expr();
        Expression expression2 = approxTopKAccumulate.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.maxItemsTracked();
        Expression expression4 = approxTopKAccumulate.maxItemsTracked();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!approxTopKAccumulate.canEqual(this)) return false;
        return true;
    }

    public ApproxTopKAccumulate(Expression expr, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.expr = expr;
        this.maxItemsTracked = maxItemsTracked;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
    }

    public ApproxTopKAccumulate(Expression child, Expression maxItemsTracked) {
        this(child, maxItemsTracked, 0, 0);
    }

    public ApproxTopKAccumulate(Expression child, int maxItemsTracked) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)maxItemsTracked)), 0, 0);
    }

    public ApproxTopKAccumulate(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }
}

