/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectList$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a list of non-unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2,1]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001B\u0014)\u0001^B\u0001b\u0019\u0001\u0003\u0016\u0004%\t\u0001\u001a\u0005\tK\u0002\u0011\t\u0012)A\u0005!\"Aa\r\u0001BK\u0002\u0013\u0005q\r\u0003\u0005l\u0001\tE\t\u0015!\u0003i\u0011!a\u0007A!f\u0001\n\u00039\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011\u00025\t\u000b9\u0004A\u0011A8\t\u000b9\u0004A\u0011\u0001;\t\u0011Y\u0004\u0001R1A\u0005B]DQA \u0001\u0005B}Dq!!\u0002\u0001\t\u0003\n9\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003w\u0001A\u0011KA\u001f\u0011%\t\u0019\u0005AA\u0001\n\u0003\t)\u0005C\u0005\u0002N\u0001\t\n\u0011\"\u0001\u0002P!I\u0011Q\r\u0001\u0012\u0002\u0013\u0005\u0011q\r\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003OB\u0011\"!\u001c\u0001\u0003\u0003%\t%a\u001c\t\u0011\u0005}\u0004!!A\u0005\u0002\u001dD\u0011\"!!\u0001\u0003\u0003%\t!a!\t\u0013\u0005%\u0005!!A\u0005B\u0005-\u0005\"CAK\u0001\u0005\u0005I\u0011AAL\u0011%\t\t\u000bAA\u0001\n\u0003\n\u0019\u000bC\u0005\u0002(\u0002\t\t\u0011\"\u0011\u0002*\u001eI\u00111\u001b\u0015\u0002\u0002#\u0005\u0011Q\u001b\u0004\tO!\n\t\u0011#\u0001\u0002X\"1a.\bC\u0001\u0003_D\u0011\"!=\u001e\u0003\u0003%)%a=\t\u0013\u0005UX$!A\u0005\u0002\u0006]\b\"CA\u0000;E\u0005I\u0011AA4\u0011%\u0011\t!HI\u0001\n\u0003\t9\u0007C\u0005\u0003\u0004u\t\t\u0011\"!\u0003\u0006!I!qC\u000f\u0012\u0002\u0013\u0005\u0011q\r\u0005\n\u00053i\u0012\u0013!C\u0001\u0003OB\u0011Ba\u0007\u001e\u0003\u0003%IA!\b\u0003\u0017\r{G\u000e\\3di2K7\u000f\u001e\u0006\u0003S)\n\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005-b\u0013aC3yaJ,7o]5p]NT!!\f\u0018\u0002\u0011\r\fG/\u00197zgRT!a\f\u0019\u0002\u0007M\fHN\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001dK)^\u00032!\u000f\u001e=\u001b\u0005A\u0013BA\u001e)\u0005\u001d\u0019u\u000e\u001c7fGR\u00042!\u0010#G\u001b\u0005q$BA A\u0003\u001diW\u000f^1cY\u0016T!!\u0011\"\u0002\u0015\r|G\u000e\\3di&|gNC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)eHA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA$I\u001b\u0005\u0011\u0015BA%C\u0005\r\te.\u001f\t\u0004\u0017:\u0003V\"\u0001'\u000b\u00055c\u0013!\u0002;sK\u0016\u001c\u0018BA(M\u0005%)f.\u0019:z\u0019&\\W\r\u0005\u0002R%6\t!&\u0003\u0002TU\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u001d+\u0016B\u0001,C\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u00171\u000f\u0005esfB\u0001.^\u001b\u0005Y&B\u0001/7\u0003\u0019a$o\\8u}%\t1)\u0003\u0002`\u0005\u00069\u0001/Y2lC\u001e,\u0017BA1c\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ty&)A\u0003dQ&dG-F\u0001Q\u0003\u0019\u0019\u0007.\u001b7eA\u00051R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/F\u0001i!\t9\u0015.\u0003\u0002k\u0005\n\u0019\u0011J\u001c;\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013\u0001F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002\rqJg.\u001b;?)\u0011\u0001\u0018O]:\u0011\u0005e\u0002\u0001\"B2\b\u0001\u0004\u0001\u0006b\u00024\b!\u0003\u0005\r\u0001\u001b\u0005\bY\u001e\u0001\n\u00111\u0001i)\t\u0001X\u000fC\u0003d\u0011\u0001\u0007\u0001+A\tck\u001a4WM]#mK6,g\u000e\u001e+za\u0016,\u0012\u0001\u001f\t\u0003srl\u0011A\u001f\u0006\u0003w:\nQ\u0001^=qKNL!! >\u0003\u0011\u0011\u000bG/\u0019+za\u0016\facY8om\u0016\u0014H\u000fV8Ck\u001a4WM]#mK6,g\u000e\u001e\u000b\u0004\r\u0006\u0005\u0001BBA\u0002\u0015\u0001\u0007a)A\u0003wC2,X-A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\tI!a\u0004\u0011\u0007e\nY!C\u0002\u0002\u000e!\u00121#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016Da!!\u0005\f\u0001\u0004A\u0017!\u00078fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BA\u0005\u0003/Aa!!\u0007\r\u0001\u0004A\u0017a\u00068fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001=\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003G\u0001B!!\n\u0002.9!\u0011qEA\u0015!\tQ&)C\u0002\u0002,\t\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0018\u0003c\u0011aa\u0015;sS:<'bAA\u0016\u0005\u0006!QM^1m)\r1\u0015q\u0007\u0005\u0007\u0003sy\u0001\u0019\u0001\u001f\u0002\r\t,hMZ3s\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019\u0001/a\u0010\t\r\u0005\u0005\u0003\u00031\u0001Q\u0003!qWm^\"iS2$\u0017\u0001B2paf$r\u0001]A$\u0003\u0013\nY\u0005C\u0004d#A\u0005\t\u0019\u0001)\t\u000f\u0019\f\u0002\u0013!a\u0001Q\"9A.\u0005I\u0001\u0002\u0004A\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#R3\u0001UA*W\t\t)\u0006\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA0\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003SR3\u0001[A*\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\nA\u0001\\1oO*\u0011\u00111P\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\u0005U\u0014\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\r\u0006\u0015\u0005\u0002CAD/\u0005\u0005\t\u0019\u00015\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\tE\u0003\u0002\u0010\u0006Ee)D\u0001A\u0013\r\t\u0019\n\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u001a\u0006}\u0005cA$\u0002\u001c&\u0019\u0011Q\u0014\"\u0003\u000f\t{w\u000e\\3b]\"A\u0011qQ\r\u0002\u0002\u0003\u0007a)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA9\u0003KC\u0001\"a\"\u001b\u0003\u0003\u0005\r\u0001[\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u00151\u0016\u0005\t\u0003\u000f[\u0012\u0011!a\u0001\r\":\u0002!a,\u00026\u0006]\u00161XA_\u0003\u0003\f\u0019-a2\u0002J\u00065\u0017q\u001a\t\u0004#\u0006E\u0016bAAZU\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA]\u0003\t{f)\u0016(D?\"*\u0007\u0010\u001d:*A5\u00023i\u001c7mK\u000e$8\u000fI1oI\u0002\u0012X\r^;s]N\u0004\u0013\r\t7jgR\u0004sN\u001a\u0011o_:lSO\\5rk\u0016\u0004S\r\\3nK:$8OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qX\u0001c\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\\\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00152S1\u0002\u0003FM\u0015-A!\n\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-e1\nTL\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005\u0015\u0017!a\u0013\u000bA\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004\u0013n\u001d\u0011o_:lC-\u001a;fe6Lg.[:uS\u000e\u0004#-Z2bkN,\u0007\u0005\u001e5fA=\u0014H-\u001a:!_\u001a\u00043m\u001c7mK\u000e$X\r\u001a\u0011sKN,H\u000e^:!I\u0016\u0004XM\u001c3t\u0015\u0001\u0002\u0003\u0005I8oAQDW\rI8sI\u0016\u0014\be\u001c4!i\",\u0007E]8xg\u0002:\b.[2iA5\f\u0017\u0010\t2fA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\rI1gi\u0016\u0014\b%\u0019\u0011tQV4g\r\\3/\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAf\u0003%\twmZ0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002R\u0006)!G\f\u0019/a\u0005Y1i\u001c7mK\u000e$H*[:u!\tITdE\u0003\u001e\u00033\f)\u000f\u0005\u0005\u0002\\\u0006\u0005\b\u000b\u001b5q\u001b\t\tiNC\u0002\u0002`\n\u000bqA];oi&lW-\u0003\u0003\u0002d\u0006u'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u0011q]Aw\u001b\t\tIO\u0003\u0003\u0002l\u0006e\u0014AA5p\u0013\r\t\u0017\u0011\u001e\u000b\u0003\u0003+\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003c\nQ!\u00199qYf$r\u0001]A}\u0003w\fi\u0010C\u0003dA\u0001\u0007\u0001\u000bC\u0004gAA\u0005\t\u0019\u00015\t\u000f1\u0004\u0003\u0013!a\u0001Q\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BAa\u0002\u0003\u0014A)qI!\u0003\u0003\u000e%\u0019!1\u0002\"\u0003\r=\u0003H/[8o!\u00199%q\u0002)iQ&\u0019!\u0011\u0003\"\u0003\rQ+\b\u000f\\34\u0011!\u0011)bIA\u0001\u0002\u0004\u0001\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0010!\u0011\t\u0019H!\t\n\t\t\r\u0012Q\u000f\u0002\u0007\u001f\nTWm\u0019;")
public class CollectList
extends Collect<ArrayBuffer<Object>>
implements UnaryLike<Expression>,
Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$3() {
        return CollectList$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectList x$0) {
        return CollectList$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return CollectList$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectList$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectList> tupled() {
        return CollectList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectList>>> curried() {
        return CollectList$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        CollectList collectList = this;
        synchronized (collectList) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectList collectList = this;
        synchronized (collectList) {
            if (!this.bitmap$0) {
                this.bufferElementType = this.child().dataType();
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        if (!this.bitmap$0) {
            return this.bufferElementType$lzycompute();
        }
        return this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        return InternalRow$.MODULE$.copyValue(value);
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public ArrayBuffer<Object> createAggregationBuffer() {
        return ArrayBuffer$.MODULE$.empty();
    }

    @Override
    public String prettyName() {
        return "collect_list";
    }

    @Override
    public Object eval(ArrayBuffer<Object> buffer) {
        return new GenericArrayData((Object[])buffer.toArray(ClassTag$.MODULE$.Any()));
    }

    @Override
    public CollectList withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public CollectList copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectList(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectList";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectList;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectList)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectList collectList = (CollectList)x$1;
        if (this.mutableAggBufferOffset() != collectList.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectList.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = collectList.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!collectList.canEqual(this)) return false;
        return true;
    }

    public CollectList(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        UnaryLike.$init$(this);
    }

    public CollectList(Expression child) {
        this(child, 0, 0);
    }
}

