/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal;

import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.spark.internal.Logging$;
import org.apache.spark.internal.MDC;
import org.slf4j.Logger;

public class SparkLogger {
    private static final MessageFactory MESSAGE_FACTORY = ParameterizedMessageFactory.INSTANCE;
    private final Logger slf4jLogger;

    SparkLogger(Logger slf4jLogger) {
        this.slf4jLogger = slf4jLogger;
    }

    public boolean isErrorEnabled() {
        return this.slf4jLogger.isErrorEnabled();
    }

    public void error(String msg) {
        this.slf4jLogger.error(msg);
    }

    public void error(String msg, Throwable throwable) {
        this.slf4jLogger.error(msg, throwable);
    }

    public void error(String msg, MDC ... mdcs) {
        if (mdcs == null || mdcs.length == 0) {
            this.slf4jLogger.error(msg);
        } else if (this.slf4jLogger.isErrorEnabled()) {
            this.withLogContext(msg, mdcs, null, mt -> this.slf4jLogger.error(mt.message));
        }
    }

    public void error(String msg, Throwable throwable, MDC ... mdcs) {
        if (mdcs == null || mdcs.length == 0) {
            this.slf4jLogger.error(msg, throwable);
        } else if (this.slf4jLogger.isErrorEnabled()) {
            this.withLogContext(msg, mdcs, throwable, mt -> this.slf4jLogger.error(mt.message, mt.throwable));
        }
    }

    public boolean isWarnEnabled() {
        return this.slf4jLogger.isWarnEnabled();
    }

    public void warn(String msg) {
        this.slf4jLogger.warn(msg);
    }

    public void warn(String msg, Throwable throwable) {
        this.slf4jLogger.warn(msg, throwable);
    }

    public void warn(String msg, MDC ... mdcs) {
        if (mdcs == null || mdcs.length == 0) {
            this.slf4jLogger.warn(msg);
        } else if (this.slf4jLogger.isWarnEnabled()) {
            this.withLogContext(msg, mdcs, null, mt -> this.slf4jLogger.warn(mt.message));
        }
    }

    public void warn(String msg, Throwable throwable, MDC ... mdcs) {
        if (mdcs == null || mdcs.length == 0) {
            this.slf4jLogger.warn(msg);
        } else if (this.slf4jLogger.isWarnEnabled()) {
            this.withLogContext(msg, mdcs, throwable, mt -> this.slf4jLogger.warn(mt.message, mt.throwable));
        }
    }

    public boolean isInfoEnabled() {
        return this.slf4jLogger.isInfoEnabled();
    }

    public void info(String msg) {
        this.slf4jLogger.info(msg);
    }

    public void info(String msg, Throwable throwable) {
        this.slf4jLogger.info(msg, throwable);
    }

    public void info(String msg, MDC ... mdcs) {
        if (mdcs == null || mdcs.length == 0) {
            this.slf4jLogger.info(msg);
        } else if (this.slf4jLogger.isInfoEnabled()) {
            this.withLogContext(msg, mdcs, null, mt -> this.slf4jLogger.info(mt.message));
        }
    }

    public void info(String msg, Throwable throwable, MDC ... mdcs) {
        if (mdcs == null || mdcs.length == 0) {
            this.slf4jLogger.info(msg);
        } else if (this.slf4jLogger.isInfoEnabled()) {
            this.withLogContext(msg, mdcs, throwable, mt -> this.slf4jLogger.info(mt.message, mt.throwable));
        }
    }

    public boolean isDebugEnabled() {
        return this.slf4jLogger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.slf4jLogger.debug(msg);
    }

    public void debug(String format, Object arg) {
        this.slf4jLogger.debug(format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.slf4jLogger.debug(format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.slf4jLogger.debug(format, arguments);
    }

    public void debug(String msg, Throwable throwable) {
        this.slf4jLogger.debug(msg, throwable);
    }

    public boolean isTraceEnabled() {
        return this.slf4jLogger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.slf4jLogger.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.slf4jLogger.trace(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.slf4jLogger.trace(format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.slf4jLogger.trace(format, arguments);
    }

    public void trace(String msg, Throwable throwable) {
        this.slf4jLogger.trace(msg, throwable);
    }

    private void withLogContext(String pattern, MDC[] mdcs, Throwable throwable, Consumer<MessageThrowable> func) {
        HashMap<String, String> context = new HashMap<String, String>();
        Object[] args = new Object[mdcs.length];
        for (int index = 0; index < mdcs.length; ++index) {
            String value;
            MDC mdc = mdcs[index];
            String string = value = mdc.value() != null ? mdc.value().toString() : null;
            if (Logging$.MODULE$.isStructuredLoggingEnabled()) {
                context.put(mdc.key().name(), value);
            }
            args[index] = value;
        }
        MessageThrowable messageThrowable = MessageThrowable.of(MESSAGE_FACTORY.newMessage(pattern, args).getFormattedMessage(), throwable);
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.putAll(context);){
            func.accept(messageThrowable);
        }
    }

    public Logger getSlf4jLogger() {
        return this.slf4jLogger;
    }

    private record MessageThrowable(String message, Throwable throwable) {
        static MessageThrowable of(String message, Throwable throwable) {
            return new MessageThrowable(message, throwable);
        }
    }
}

