/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.spark.util.MavenUtils;
import org.apache.spark.util.MavenUtils$;
import org.apache.spark.util.SparkFileUtils$;
import org.apache.spark.util.SparkStreamUtils$;
import org.apache.spark.util.SparkTestUtils;
import org.apache.spark.util.SparkTestUtils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class IvyTestUtils$ {
    public static final IvyTestUtils$ MODULE$ = new IvyTestUtils$();

    public File pathFromCoordinate(MavenUtils.MavenCoordinate artifact, File prefix, String ext, boolean useIvyLayout) {
        String groupDirs = artifact.groupId().replace(".", File.separator);
        String artifactDirs = artifact.artifactId();
        String artifactPath = !useIvyLayout ? new .colon.colon((Object)groupDirs, (List)new .colon.colon((Object)artifactDirs, (List)new .colon.colon((Object)artifact.version(), (List)Nil$.MODULE$))).mkString(File.separator) : new .colon.colon((Object)artifact.groupId(), (List)new .colon.colon((Object)artifactDirs, (List)new .colon.colon((Object)artifact.version(), (List)new .colon.colon((Object)(ext + "s"), (List)Nil$.MODULE$)))).mkString(File.separator);
        return new File(prefix, artifactPath);
    }

    public String artifactName(MavenUtils.MavenCoordinate artifact, boolean useIvyLayout, String ext) {
        if (!useIvyLayout) {
            return artifact.artifactId() + "-" + artifact.version() + ext;
        }
        return artifact.artifactId() + ext;
    }

    public String artifactName$default$3() {
        return ".jar";
    }

    private String getBaseGroupDirectory(MavenUtils.MavenCoordinate artifact, boolean useIvyLayout) {
        if (!useIvyLayout) {
            return artifact.groupId().replace(".", File.separator);
        }
        return artifact.groupId();
    }

    public File writeFile(File dir, String fileName, String contents) {
        File outputFile = new File(dir, fileName);
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        outputStream.write((byte[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.charArrayOps(contents.toCharArray()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToByte((byte)IvyTestUtils$.$anonfun$writeFile$1(BoxesRunTime.unboxToChar((Object)x$1))), (ClassTag)ClassTag$.MODULE$.Byte()));
        outputStream.close();
        return outputFile;
    }

    private File createPythonFile(File dir) {
        String contents = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("def myfunc(x):\n        |   return x + 1\n      "));
        return this.writeFile(dir, "mylib.py", contents);
    }

    private Seq<Tuple2<String, File>> createRFiles(File dir, String className, String packageName) {
        File rFilesDir = new File(dir, "R" + File.separator + "pkg");
        new File(rFilesDir, "R").mkdirs();
        String contents = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("myfunc <- function(x) {\n        |  SparkR:::callJStatic(\"" + packageName + "." + className + "\", \"myFunc\", x)\n        |}\n      "));
        File source = this.writeFile(new File(rFilesDir, "R"), "mylib.R", contents);
        String description = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Package: sparkPackageTest\n        |Type: Package\n        |Title: Test for building an R package\n        |Version: 0.1\n        |Date: 2015-07-08\n        |Author: Burak Yavuz\n        |Imports: methods, SparkR\n        |Depends: R (>= 3.1), methods, SparkR\n        |Suggests: testthat\n        |Description: Test for building an R package within a jar\n        |License: Apache License (== 2.0)\n        |Collate: 'mylib.R'\n      "));
        File descFile = this.writeFile(rFilesDir, "DESCRIPTION", description);
        String namespace = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("import(SparkR)\n        |export(\"myfunc\")\n      "));
        File nameFile = this.writeFile(rFilesDir, "NAMESPACE", namespace);
        return new .colon.colon((Object)new Tuple2((Object)"R/pkg/R/mylib.R", (Object)source), (List)new .colon.colon((Object)new Tuple2((Object)"R/pkg/DESCRIPTION", (Object)descFile), (List)new .colon.colon((Object)new Tuple2((Object)"R/pkg/NAMESPACE", (Object)nameFile), (List)Nil$.MODULE$)));
    }

    private File createJavaClass(File dir, String className, String packageName) {
        String contents = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("package " + packageName + ";\n        |\n        |import java.lang.Integer;\n        |\n        |public class " + className + " implements java.io.Serializable {\n        | public static Integer myFunc(Integer x) {\n        |   return x + 1;\n        | }\n        |}\n      "));
        SparkTestUtils.JavaSourceFromString sourceFile = new SparkTestUtils.JavaSourceFromString((SparkTestUtils)SparkTestUtils$.MODULE$, new File(dir, className).toURI().getPath(), contents);
        return SparkTestUtils$.MODULE$.createCompiledClass(className, dir, sourceFile, (Seq)package$.MODULE$.Seq().empty());
    }

    private File createDescriptor(File tempPath, MavenUtils.MavenCoordinate artifact, Option<Seq<MavenUtils.MavenCoordinate>> dependencies, boolean useIvyLayout) {
        if (useIvyLayout) {
            File ivyXmlPath = this.pathFromCoordinate(artifact, tempPath, "ivy", true);
            ivyXmlPath.mkdirs();
            return this.createIvyDescriptor(ivyXmlPath, artifact, dependencies);
        }
        File pomPath = this.pathFromCoordinate(artifact, tempPath, "pom", useIvyLayout);
        pomPath.mkdirs();
        return this.createPom(pomPath, artifact, dependencies);
    }

    private String pomArtifactWriter(MavenUtils.MavenCoordinate artifact, int tabCount) {
        String result = "\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), tabCount) + "<groupId>" + artifact.groupId() + "</groupId>";
        result = result + "\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), tabCount) + "<artifactId>" + artifact.artifactId() + "</artifactId>";
        result = result + "\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), tabCount) + "<version>" + artifact.version() + "</version>";
        return result;
    }

    private int pomArtifactWriter$default$2() {
        return 1;
    }

    private File createPom(File dir, MavenUtils.MavenCoordinate artifact, Option<Seq<MavenUtils.MavenCoordinate>> dependencies) {
        Object content = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                    |<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                    |<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n                    |       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n                    |       xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0\n                    |       http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n                    |   <modelVersion>4.0.0</modelVersion>\n                  ")).trim();
        content = (String)content + this.pomArtifactWriter(artifact, this.pomArtifactWriter$default$2());
        content = (String)content + dependencies.map((Function1 & Serializable)deps -> {
            String inside = ((IterableOnceOps)deps.map((Function1 & Serializable)dep -> "\t<dependency>" + MODULE$.pomArtifactWriter((MavenUtils.MavenCoordinate)dep, 3) + "\n\t</dependency>")).mkString("\n");
            return "\n  <dependencies>\n" + inside + "\n  </dependencies>";
        }).getOrElse((Function0 & Serializable)() -> "");
        content = (String)content + "\n</project>";
        return this.writeFile(dir, this.artifactName(artifact, false, ".pom"), ((String)content).trim());
    }

    private String ivyArtifactWriter(MavenUtils.MavenCoordinate artifact) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<dependency org=\"" + artifact.groupId() + "\" name=\"" + artifact.artifactId() + "\"\n       |            rev=\"" + artifact.version() + "\" force=\"true\"\n       |            conf=\"compile->compile(*),master(*);runtime->runtime(*)\"/>"));
    }

    private File createIvyDescriptor(File dir, MavenUtils.MavenCoordinate artifact, Option<Seq<MavenUtils.MavenCoordinate>> dependencies) {
        Object content = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n        |<ivy-module version=\"2.0\" xmlns:m=\"http://ant.apache.org/ivy/maven\">\n        |  <info organisation=\"" + artifact.groupId() + "\"\n        |        module=\"" + artifact.artifactId() + "\"\n        |        revision=\"" + artifact.version() + "\"\n        |        status=\"release\" publication=\"20150405222456\" />\n        |  <configurations>\n        |    <conf name=\"default\" visibility=\"public\" description=\"\" extends=\"runtime,master\"/>\n        |    <conf name=\"compile\" visibility=\"public\" description=\"\"/>\n        |    <conf name=\"master\" visibility=\"public\" description=\"\"/>\n        |    <conf name=\"runtime\" visibility=\"public\" description=\"\" extends=\"compile\"/>\n        |    <conf name=\"pom\" visibility=\"public\" description=\"\"/>\n        |  </configurations>\n        |  <publications>\n        |     <artifact name=\"" + this.artifactName(artifact, true, "") + "\" type=\"jar\" ext=\"jar\"\n        |               conf=\"master\"/>\n        |  </publications>\n      ")).trim();
        content = (String)content + dependencies.map((Function1 & Serializable)deps -> {
            String inside = ((IterableOnceOps)deps.map((Function1 & Serializable)artifact -> MODULE$.ivyArtifactWriter((MavenUtils.MavenCoordinate)artifact))).mkString("\n");
            return "\n  <dependencies>\n" + inside + "\n  </dependencies>";
        }).getOrElse((Function0 & Serializable)() -> "");
        content = (String)content + "\n</ivy-module>";
        return this.writeFile(dir, "ivy.xml", ((String)content).trim());
    }

    public File packJar(File dir, MavenUtils.MavenCoordinate artifact, Seq<Tuple2<String, File>> files, boolean useIvyLayout, boolean withR, Option<Manifest> withManifest) {
        File jarFile = new File(dir, this.artifactName(artifact, useIvyLayout, this.artifactName$default$3()));
        FileOutputStream jarFileStream = new FileOutputStream(jarFile);
        Manifest manifest = (Manifest)withManifest.getOrElse((Function0 & Serializable)() -> {
            if (withR) {
                Manifest mani = new Manifest();
                Attributes attr = mani.getMainAttributes();
                attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                attr.put(new Attributes.Name("Spark-HasRPackage"), "true");
                return mani;
            }
            return null;
        });
        JarOutputStream jarStream = manifest != null ? new JarOutputStream((OutputStream)jarFileStream, manifest) : new JarOutputStream(jarFileStream);
        files.foreach((Function1 & Serializable)file -> {
            IvyTestUtils$.$anonfun$packJar$2(jarStream, file);
            return BoxedUnit.UNIT;
        });
        jarStream.close();
        jarFileStream.close();
        return jarFile;
    }

    public Option<Manifest> packJar$default$6() {
        return None$.MODULE$;
    }

    private File createLocalRepository(MavenUtils.MavenCoordinate artifact, Option<Seq<MavenUtils.MavenCoordinate>> dependencies, Option<File> tempDir, boolean useIvyLayout, boolean withPython, boolean withR) {
        File tempPath = (File)tempDir.getOrElse((Function0 & Serializable)() -> SparkFileUtils$.MODULE$.createTempDir());
        tempPath.mkdirs();
        File root = new File(tempPath, Integer.toString(tempPath.hashCode()));
        root.mkdirs();
        try {
            File jarPath = this.pathFromCoordinate(artifact, tempPath, "jar", useIvyLayout);
            jarPath.mkdirs();
            String className = "MyLib";
            File javaClass = this.createJavaClass(root, className, artifact.groupId());
            Tuple2 javaFile = new Tuple2((Object)(artifact.groupId().replace(".", "/") + "/" + javaClass.getName()), (Object)javaClass);
            ArrayBuffer allFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{javaFile}));
            if (withPython) {
                File pythonFile = this.createPythonFile(root);
                v0 = allFiles.$plus$eq((Object)new Tuple2((Object)pythonFile.getName(), (Object)pythonFile));
            } else {
                v0 = BoxedUnit.UNIT;
            }
            if (withR) {
                Seq<Tuple2<String, File>> rFiles = this.createRFiles(root, className, artifact.groupId());
                v1 = allFiles.appendAll(rFiles);
            } else {
                v1 = BoxedUnit.UNIT;
            }
            File jarFile = this.packJar(jarPath, artifact, (Seq<Tuple2<String, File>>)allFiles.toSeq(), useIvyLayout, withR, this.packJar$default$6());
            Predef$.MODULE$.assert(jarFile.exists(), (Function0 & Serializable)() -> "Problem creating Jar file");
            File descriptor = this.createDescriptor(tempPath, artifact, dependencies, useIvyLayout);
            Predef$.MODULE$.assert(descriptor.exists(), (Function0 & Serializable)() -> "Problem creating Pom file");
        }
        finally {
            FileUtils.deleteDirectory((File)root);
        }
        return tempPath;
    }

    private Option<Seq<MavenUtils.MavenCoordinate>> createLocalRepository$default$2() {
        return None$.MODULE$;
    }

    private Option<File> createLocalRepository$default$3() {
        return None$.MODULE$;
    }

    private boolean createLocalRepository$default$4() {
        return false;
    }

    private boolean createLocalRepository$default$5() {
        return false;
    }

    private boolean createLocalRepository$default$6() {
        return false;
    }

    public File createLocalRepositoryForTests(MavenUtils.MavenCoordinate artifact, Option<String> dependencies, Option<File> rootDir, boolean useIvyLayout, boolean withPython, boolean withR) {
        Option deps = dependencies.map((Function1 & Serializable)coordinates -> MavenUtils$.MODULE$.extractMavenCoordinates(coordinates));
        File mainRepo = this.createLocalRepository(artifact, (Option<Seq<MavenUtils.MavenCoordinate>>)deps, rootDir, useIvyLayout, withPython, withR);
        deps.foreach((Function1 & Serializable)seq -> {
            seq.foreach((Function1 & Serializable)dep -> IvyTestUtils$.MODULE$.createLocalRepository((MavenUtils.MavenCoordinate)dep, (Option<Seq<MavenUtils.MavenCoordinate>>)None$.MODULE$, (Option<File>)new Some((Object)mainRepo$1), useIvyLayout$1, false, IvyTestUtils$.MODULE$.createLocalRepository$default$6()));
            return BoxedUnit.UNIT;
        });
        return mainRepo;
    }

    public boolean createLocalRepositoryForTests$default$4() {
        return false;
    }

    public boolean createLocalRepositoryForTests$default$5() {
        return false;
    }

    public boolean createLocalRepositoryForTests$default$6() {
        return false;
    }

    public void withRepository(MavenUtils.MavenCoordinate artifact, Option<String> dependencies, Option<File> rootDir, boolean useIvyLayout, boolean withPython, boolean withR, IvySettings ivySettings, Function1<String, BoxedUnit> f) {
        Option deps = dependencies.map((Function1 & Serializable)coordinates -> MavenUtils$.MODULE$.extractMavenCoordinates(coordinates));
        this.purgeLocalIvyCache(artifact, (Option<Seq<MavenUtils.MavenCoordinate>>)deps, ivySettings);
        File repo = this.createLocalRepositoryForTests(artifact, dependencies, rootDir, useIvyLayout, withPython, withR);
        try {
            f.apply((Object)repo.toURI().toString());
        }
        finally {
            if (repo.toString().contains(".m2") || repo.toString().contains(".ivy2") || repo.toString().contains(".ivy2.5.2")) {
                String groupDir = this.getBaseGroupDirectory(artifact, useIvyLayout);
                FileUtils.deleteDirectory((File)new File(repo, groupDir + File.separator + artifact.artifactId()));
                deps.foreach((Function1 & Serializable)x$2 -> {
                    x$2.foreach((Function1 & Serializable)dep -> {
                        IvyTestUtils$.$anonfun$withRepository$3(repo$1, useIvyLayout$2, dep);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
            } else {
                FileUtils.deleteDirectory((File)repo);
            }
            this.purgeLocalIvyCache(artifact, (Option<Seq<MavenUtils.MavenCoordinate>>)deps, ivySettings);
        }
    }

    public boolean withRepository$default$4() {
        return false;
    }

    public boolean withRepository$default$5() {
        return false;
    }

    public boolean withRepository$default$6() {
        return false;
    }

    public IvySettings withRepository$default$7() {
        return this.defaultIvySettings();
    }

    private void purgeLocalIvyCache(MavenUtils.MavenCoordinate artifact, Option<Seq<MavenUtils.MavenCoordinate>> dependencies, IvySettings ivySettings) {
        FileUtils.deleteDirectory((File)new File(ivySettings.getDefaultCache(), artifact.groupId()));
        dependencies.foreach((Function1 & Serializable)x$3 -> {
            x$3.foreach((Function1 & Serializable)dep -> {
                IvyTestUtils$.$anonfun$purgeLocalIvyCache$2(ivySettings$1, dep);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private IvySettings defaultIvySettings() {
        IvySettings settings = new IvySettings();
        MavenUtils$.MODULE$.processIvyPathArg(settings, (Option)None$.MODULE$);
        return settings;
    }

    public static final /* synthetic */ byte $anonfun$writeFile$1(char x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ void $anonfun$packJar$2(JarOutputStream jarStream$1, Tuple2 file) {
        JarEntry jarEntry = new JarEntry((String)file._1());
        jarStream$1.putNextEntry(jarEntry);
        FileInputStream in = new FileInputStream((File)file._2());
        SparkStreamUtils$.MODULE$.copyStream((InputStream)in, (OutputStream)jarStream$1, SparkStreamUtils$.MODULE$.copyStream$default$3(), SparkStreamUtils$.MODULE$.copyStream$default$4());
        in.close();
    }

    public static final /* synthetic */ void $anonfun$withRepository$3(File repo$1, boolean useIvyLayout$2, MavenUtils.MavenCoordinate dep) {
        FileUtils.deleteDirectory((File)new File(repo$1, MODULE$.getBaseGroupDirectory(dep, useIvyLayout$2)));
    }

    public static final /* synthetic */ void $anonfun$purgeLocalIvyCache$2(IvySettings ivySettings$1, MavenUtils.MavenCoordinate dep) {
        FileUtils.deleteDirectory((File)new File(ivySettings$1.getDefaultCache(), dep.groupId()));
    }

    private IvyTestUtils$() {
    }
}

