/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import org.apache.logging.log4j.Level;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.util.SparkLoggerSuiteBase;

public class PatternSparkLoggerSuite
extends SparkLoggerSuiteBase {
    private static final SparkLogger LOGGER = SparkLoggerFactory.getLogger(PatternSparkLoggerSuite.class);

    private String toRegexPattern(Level level, String msg) {
        return msg.replace("<level>", level.toString()).replace("<className>", this.className());
    }

    @Override
    SparkLogger logger() {
        return LOGGER;
    }

    @Override
    String className() {
        return PatternSparkLoggerSuite.class.getSimpleName();
    }

    @Override
    String logFilePath() {
        return "target/pattern.log";
    }

    @Override
    String expectedPatternForBasicMsg(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: This is a log message\n");
    }

    @Override
    String expectedPatternForBasicMsgWithEscapeChar(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: This is a log message\\nThis is a new line \\t other msg\\n");
    }

    @Override
    String expectedPatternForBasicMsgWithException(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: This is a log message\n[\\s\\S]*");
    }

    @Override
    String expectedPatternForMsgWithMDC(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: Lost executor 1.\n");
    }

    @Override
    String expectedPatternForMsgWithMDCs(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: Lost executor 1, reason: the shuffle data is too large\n");
    }

    @Override
    String expectedPatternForMsgWithMDCsAndException(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: Lost executor 1, reason: the shuffle data is too large\n[\\s\\S]*");
    }

    @Override
    String expectedPatternForMsgWithMDCValueIsNull(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: Lost executor null.\n");
    }

    @Override
    String expectedPatternForScalaCustomLogKey(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: Scala custom log message.\n");
    }

    @Override
    String expectedPatternForJavaCustomLogKey(Level level) {
        return this.toRegexPattern(level, ".*<level> <className>: Java custom log message.\n");
    }
}

