/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.util.CustomLogKeys$CUSTOM_LOG_KEY$;
import org.apache.spark.util.JavaCustomLogKeys;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class SparkLoggerSuiteBase {
    private final String basicMsg = "This is a log message";
    private final String basicMsgWithEscapeChar = "This is a log message\nThis is a new line \t other msg";
    private final MDC executorIDMDC = MDC.of((LogKey)LogKeys.EXECUTOR_ID$.MODULE$, (Object)"1");
    private final String msgWithMDC = "Lost executor {}.";
    private final MDC[] mdcs = new MDC[]{MDC.of((LogKey)LogKeys.EXECUTOR_ID$.MODULE$, (Object)"1"), MDC.of((LogKey)LogKeys.REASON$.MODULE$, (Object)"the shuffle data is too large")};
    private final String msgWithMDCs = "Lost executor {}, reason: {}";
    private final MDC[] emptyMDCs = new MDC[0];
    private final MDC executorIDMDCValueIsNull = MDC.of((LogKey)LogKeys.EXECUTOR_ID$.MODULE$, null);
    private final MDC scalaCustomLogMDC = MDC.of((LogKey)CustomLogKeys$CUSTOM_LOG_KEY$.MODULE$, (Object)"Scala custom log message.");
    private final MDC javaCustomLogMDC = MDC.of((LogKey)JavaCustomLogKeys.CUSTOM_LOG_KEY, (Object)"Java custom log message.");

    abstract SparkLogger logger();

    abstract String className();

    abstract String logFilePath();

    private File logFile() throws IOException {
        String pwd = new File(".").getCanonicalPath();
        return new File(pwd + File.separator + this.logFilePath());
    }

    private String captureLogOutput(Runnable func) throws IOException {
        String content = "";
        if (this.logFile().exists()) {
            content = Files.readString(this.logFile().toPath());
        }
        func.run();
        String newContent = Files.readString(this.logFile().toPath());
        return newContent.substring(content.length());
    }

    private void checkLogOutput(Level level, Runnable func, ExpectedResult result) {
        try {
            Assertions.assertTrue((boolean)this.captureLogOutput(func).matches(result.apply(level)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    abstract String expectedPatternForBasicMsg(Level var1);

    abstract String expectedPatternForBasicMsgWithEscapeChar(Level var1);

    abstract String expectedPatternForBasicMsgWithException(Level var1);

    abstract String expectedPatternForMsgWithMDC(Level var1);

    abstract String expectedPatternForMsgWithMDCs(Level var1);

    abstract String expectedPatternForMsgWithMDCsAndException(Level var1);

    String expectedPatternForMsgWithEmptyMDCsAndException(Level level) {
        return this.expectedPatternForBasicMsgWithException(level);
    }

    abstract String expectedPatternForMsgWithMDCValueIsNull(Level var1);

    abstract String expectedPatternForScalaCustomLogKey(Level var1);

    abstract String expectedPatternForJavaCustomLogKey(Level var1);

    @Test
    public void testBasicMsg() {
        Runnable errorFn = () -> this.logger().error("This is a log message");
        Runnable warnFn = () -> this.logger().warn("This is a log message");
        Runnable infoFn = () -> this.logger().info("This is a log message");
        Runnable debugFn = () -> this.logger().debug("This is a log message");
        Runnable traceFn = () -> this.logger().trace("This is a log message");
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn), Pair.of((Object)Level.DEBUG, (Object)debugFn), Pair.of((Object)Level.TRACE, (Object)traceFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForBasicMsg));
    }

    @Test
    public void testBasicMsgWithEscapeChar() {
        Runnable errorFn = () -> this.logger().error("This is a log message\nThis is a new line \t other msg");
        Runnable warnFn = () -> this.logger().warn("This is a log message\nThis is a new line \t other msg");
        Runnable infoFn = () -> this.logger().info("This is a log message\nThis is a new line \t other msg");
        Runnable debugFn = () -> this.logger().debug("This is a log message\nThis is a new line \t other msg");
        Runnable traceFn = () -> this.logger().trace("This is a log message\nThis is a new line \t other msg");
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn), Pair.of((Object)Level.DEBUG, (Object)debugFn), Pair.of((Object)Level.TRACE, (Object)traceFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForBasicMsgWithEscapeChar));
    }

    @Test
    public void testBasicLoggerWithException() {
        RuntimeException exception = new RuntimeException("OOM");
        Runnable errorFn = () -> this.logger().error("This is a log message", exception);
        Runnable warnFn = () -> this.logger().warn("This is a log message", exception);
        Runnable infoFn = () -> this.logger().info("This is a log message", exception);
        Runnable debugFn = () -> this.logger().debug("This is a log message", exception);
        Runnable traceFn = () -> this.logger().trace("This is a log message", exception);
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn), Pair.of((Object)Level.DEBUG, (Object)debugFn), Pair.of((Object)Level.TRACE, (Object)traceFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForBasicMsgWithException));
    }

    @Test
    public void testLoggerWithMDC() {
        Runnable errorFn = () -> this.logger().error("Lost executor {}.", new MDC[]{this.executorIDMDC});
        Runnable warnFn = () -> this.logger().warn("Lost executor {}.", new MDC[]{this.executorIDMDC});
        Runnable infoFn = () -> this.logger().info("Lost executor {}.", new MDC[]{this.executorIDMDC});
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForMsgWithMDC));
    }

    @Test
    public void testLoggerWithMDCs() {
        Runnable errorFn = () -> this.logger().error("Lost executor {}, reason: {}", this.mdcs);
        Runnable warnFn = () -> this.logger().warn("Lost executor {}, reason: {}", this.mdcs);
        Runnable infoFn = () -> this.logger().info("Lost executor {}, reason: {}", this.mdcs);
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForMsgWithMDCs));
    }

    @Test
    public void testLoggerWithEmptyMDCsAndException() {
        RuntimeException exception = new RuntimeException("OOM");
        Runnable errorFn = () -> this.logger().error("This is a log message", exception, this.emptyMDCs);
        Runnable warnFn = () -> this.logger().warn("This is a log message", exception, this.emptyMDCs);
        Runnable infoFn = () -> this.logger().info("This is a log message", exception, this.emptyMDCs);
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForMsgWithEmptyMDCsAndException));
    }

    @Test
    public void testLoggerWithMDCsAndException() {
        RuntimeException exception = new RuntimeException("OOM");
        Runnable errorFn = () -> this.logger().error("Lost executor {}, reason: {}", exception, this.mdcs);
        Runnable warnFn = () -> this.logger().warn("Lost executor {}, reason: {}", exception, this.mdcs);
        Runnable infoFn = () -> this.logger().info("Lost executor {}, reason: {}", exception, this.mdcs);
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForMsgWithMDCsAndException));
    }

    @Test
    public void testLoggerWithMDCValueIsNull() {
        Runnable errorFn = () -> this.logger().error("Lost executor {}.", new MDC[]{this.executorIDMDCValueIsNull});
        Runnable warnFn = () -> this.logger().warn("Lost executor {}.", new MDC[]{this.executorIDMDCValueIsNull});
        Runnable infoFn = () -> this.logger().info("Lost executor {}.", new MDC[]{this.executorIDMDCValueIsNull});
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForMsgWithMDCValueIsNull));
    }

    @Test
    public void testLoggerWithScalaCustomLogKey() {
        Runnable errorFn = () -> this.logger().error("{}", new MDC[]{this.scalaCustomLogMDC});
        Runnable warnFn = () -> this.logger().warn("{}", new MDC[]{this.scalaCustomLogMDC});
        Runnable infoFn = () -> this.logger().info("{}", new MDC[]{this.scalaCustomLogMDC});
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForScalaCustomLogKey));
    }

    @Test
    public void testLoggerWithJavaCustomLogKey() {
        Runnable errorFn = () -> this.logger().error("{}", new MDC[]{this.javaCustomLogMDC});
        Runnable warnFn = () -> this.logger().warn("{}", new MDC[]{this.javaCustomLogMDC});
        Runnable infoFn = () -> this.logger().info("{}", new MDC[]{this.javaCustomLogMDC});
        List.of(Pair.of((Object)Level.ERROR, (Object)errorFn), Pair.of((Object)Level.WARN, (Object)warnFn), Pair.of((Object)Level.INFO, (Object)infoFn)).forEach(pair -> this.checkLogOutput((Level)pair.getLeft(), (Runnable)pair.getRight(), this::expectedPatternForJavaCustomLogKey));
    }

    @FunctionalInterface
    private static interface ExpectedResult {
        public String apply(Level var1) throws IOException;
    }
}

