/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.Level;
import org.apache.spark.internal.Logging$;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.util.SparkLoggerSuiteBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public class StructuredSparkLoggerSuite
extends SparkLoggerSuiteBase {
    private static final SparkLogger LOGGER = SparkLoggerFactory.getLogger(StructuredSparkLoggerSuite.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @BeforeAll
    public static void setup() {
        Logging$.MODULE$.enableStructuredLogging();
    }

    @AfterAll
    public static void teardown() {
        Logging$.MODULE$.disableStructuredLogging();
    }

    private String compactAndToRegexPattern(Level level, String json) {
        try {
            return JSON_MAPPER.readTree(json).toString().replace("<level>", level.toString()).replace("<className>", this.className()).replace("<timestamp>", "[^\"]+").replace("\"<stacktrace>\"", ".*").replace("{", "\\{") + "\n";
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    SparkLogger logger() {
        return LOGGER;
    }

    @Override
    String className() {
        return StructuredSparkLoggerSuite.class.getSimpleName();
    }

    @Override
    String logFilePath() {
        return "target/structured.log";
    }

    @Override
    String expectedPatternForBasicMsg(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"This is a log message\",\n  \"logger\": \"<className>\"\n}");
    }

    @Override
    String expectedPatternForBasicMsgWithEscapeChar(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"This is a log message\\\\nThis is a new line \\\\t other msg\",\n  \"logger\": \"<className>\"\n}");
    }

    @Override
    String expectedPatternForBasicMsgWithException(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"This is a log message\",\n  \"exception\": {\n    \"class\": \"java.lang.RuntimeException\",\n    \"msg\": \"OOM\",\n    \"stacktrace\": \"<stacktrace>\"\n  },\n  \"logger\": \"<className>\"\n}");
    }

    @Override
    String expectedPatternForMsgWithMDC(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"Lost executor 1.\",\n  \"context\": {\n    \"executor_id\": \"1\"\n  },\n  \"logger\": \"<className>\"\n}");
    }

    @Override
    String expectedPatternForMsgWithMDCs(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"Lost executor 1, reason: the shuffle data is too large\",\n  \"context\": {\n    \"executor_id\": \"1\",\n    \"reason\": \"the shuffle data is too large\"\n  },\n  \"logger\": \"<className>\"\n}");
    }

    @Override
    String expectedPatternForMsgWithMDCsAndException(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"Lost executor 1, reason: the shuffle data is too large\",\n  \"context\": {\n    \"executor_id\": \"1\",\n    \"reason\": \"the shuffle data is too large\"\n  },\n  \"exception\": {\n    \"class\": \"java.lang.RuntimeException\",\n    \"msg\": \"OOM\",\n    \"stacktrace\": \"<stacktrace>\"\n  },\n  \"logger\": \"<className>\"\n}");
    }

    @Override
    String expectedPatternForMsgWithMDCValueIsNull(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"Lost executor null.\",\n  \"context\": {\n    \"executor_id\": null\n  },\n  \"logger\": \"<className>\"\n}");
    }

    @Override
    String expectedPatternForScalaCustomLogKey(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"Scala custom log message.\",\n  \"context\": {\n    \"custom_log_key\": \"Scala custom log message.\"\n  },\n  \"logger\": \"<className>\"\n}");
    }

    @Override
    String expectedPatternForJavaCustomLogKey(Level level) {
        return this.compactAndToRegexPattern(level, "{\n  \"ts\": \"<timestamp>\",\n  \"level\": \"<level>\",\n  \"msg\": \"Java custom log message.\",\n  \"context\": {\n    \"custom_log_key\": \"Java custom log message.\"\n  },\n  \"logger\": \"<className>\"\n}");
    }
}

