/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractServerImplBuilder;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExamplePluginCommand;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.WriteOperation;
import org.apache.spark.connect.proto.WriteOperationV2;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.CreateTableWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.test.ConnectFunSuite;
import org.apache.spark.util.SparkSerDeUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0004\t\u00013!)A\u0006\u0001C\u0001[!I\u0001\u0007\u0001a\u0001\u0002\u0004%I!\r\u0005\nu\u0001\u0001\r\u00111A\u0005\nmB\u0011\u0002\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001a\t\u0013\u0015\u0003\u0001\u0019!a\u0001\n\u00131\u0005\"C(\u0001\u0001\u0004\u0005\r\u0011\"\u0003Q\u0011%\u0011\u0006\u00011A\u0001B\u0003&q\tC\u0005T\u0001\u0001\u0007\t\u0019!C\u0005)\"I\u0001\f\u0001a\u0001\u0002\u0004%I!\u0017\u0005\n7\u0002\u0001\r\u0011!Q!\nUCQ\u0001\u0018\u0001\u0005\nuCQA\u0018\u0001\u0005\n}CQ\u0001\u0019\u0001\u0005B}CQ!\u0019\u0001\u0005B}\u0013!c\u00117jK:$H)\u0019;bg\u0016$8+^5uK*\u0011\u0011CE\u0001\u0004gFd'BA\n\u0015\u0003\u0015\u0019\b/\u0019:l\u0015\t)b#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0007\u0012)!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0005gk:\u001cX/\u001b;f\u0015\tyb#A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011\u0005\b\u0002\f\u0003:Lh)\u001e8Tk&$X\r\u0005\u0002$M5\tAE\u0003\u0002&!\u0005!A/Z:u\u0013\t9CEA\bD_:tWm\u0019;Gk:\u001cV/\u001b;f!\tI#&D\u0001\u001f\u0013\tYcD\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0017A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001\u0011\u0003\u0019\u0019XM\u001d<feV\t!\u0007\u0005\u00024q5\tAG\u0003\u00026m\u0005!qM\u001d9d\u0015\u00059\u0014AA5p\u0013\tIDG\u0001\u0004TKJ4XM]\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHC\u0001\u001fC!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0011)f.\u001b;\t\u000f\r\u001b\u0011\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\u0002\u000fM,'O^3sA\u000591/\u001a:wS\u000e,W#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015AB2mS\u0016tGO\u0003\u0002M!\u000591m\u001c8oK\u000e$\u0018B\u0001(J\u0005a!U/\\7z'B\f'o[\"p]:,7\r^*feZL7-Z\u0001\fg\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0002=#\"91IBA\u0001\u0002\u00049\u0015\u0001C:feZL7-\u001a\u0011\u0002\u0005M\u001cX#A+\u0011\u0005=2\u0016BA,\u0011\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019\u00198o\u0018\u0013fcR\u0011AH\u0017\u0005\b\u0007&\t\t\u00111\u0001V\u0003\r\u00198\u000fI\u0001\u0010]\u0016<8\u000b]1sWN+7o]5p]R\tQ+\u0001\tti\u0006\u0014H\u000fR;n[f\u001cVM\u001d<feR\tA(\u0001\u0006cK\u001a|'/Z#bG\"\f\u0011\"\u00194uKJ,\u0015m\u00195")
public class ClientDatasetSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private Server server;
    private DummySparkConnectService service;
    private SparkSession ss;
    private Path baseResourcePath;
    private Path commonResourcePath;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private SparkSession ss() {
        return this.ss;
    }

    private void ss_$eq(SparkSession x$1) {
        this.ss = x$1;
    }

    private SparkSession newSparkSession() {
        SparkConnectClient client = SparkConnectClient$.MODULE$.apply(((AbstractManagedChannelImplBuilder)InProcessChannelBuilder.forName((String)this.getClass().getName()).directExecutor()).build());
        return new SparkSession(client, SparkSession$.MODULE$.cleaner(), new AtomicLong());
    }

    private void startDummyServer() {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((AbstractServerImplBuilder)InProcessServerBuilder.forName((String)this.getClass().getName()).addService((BindableService)this.service())).build());
        this.server().start();
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.startDummyServer();
        this.ss_$eq(this.newSparkSession());
    }

    public void afterEach() {
        block0: {
            if (this.server() == null) break block0;
            this.server().shutdownNow();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "ClientDatasetSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(Relation.Builder x$4) {
    }

    public static final /* synthetic */ void $anonfun$new$4(Relation.Builder x$5) {
    }

    public static final /* synthetic */ void $anonfun$new$6(Relation.Builder x$6) {
    }

    public static final /* synthetic */ void $anonfun$new$8(Relation.Builder x$7) {
    }

    public ClientDatasetSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.test("write", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable)x$4 -> {
                ClientDatasetSuite.$anonfun$new$2(x$4);
                return BoxedUnit.UNIT;
            }).limit(10);
            WriteOperation.Builder builder = WriteOperation.newBuilder();
            builder.setInput(df.plan().getRoot()).setPath("my/test/path").setMode(WriteOperation.SaveMode.SAVE_MODE_ERROR_IF_EXISTS).setSource("parquet").addSortColumnNames("col1").addPartitioningColumns("col99").setBucketBy(WriteOperation.BucketBy.newBuilder().setNumBuckets(2).addBucketColumnNames("col1").addBucketColumnNames("col2"));
            Plan expectedPlan = Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperation(builder)).build();
            df.write().sortBy("col1", (Seq)Nil$.MODULE$).partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col99"})).bucketBy(2, "col1", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"})).parquet("my/test/path");
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("write jdbc", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable)x$5 -> {
                ClientDatasetSuite.$anonfun$new$4(x$5);
                return BoxedUnit.UNIT;
            }).limit(10);
            WriteOperation.Builder builder = WriteOperation.newBuilder();
            builder.setInput(df.plan().getRoot()).setMode(WriteOperation.SaveMode.SAVE_MODE_ERROR_IF_EXISTS).setSource("jdbc").putOptions("a", "b").putOptions("1", "2").putOptions("url", "url").putOptions("dbtable", "table");
            Plan expectedPlan = Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperation(builder)).build();
            Properties connectionProperties = new Properties();
            connectionProperties.put("a", "b");
            connectionProperties.put("1", "2");
            df.write().jdbc("url", "table", connectionProperties);
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("write V2", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable)x$6 -> {
                ClientDatasetSuite.$anonfun$new$6(x$6);
                return BoxedUnit.UNIT;
            }).limit(10);
            WriteOperationV2.Builder builder = WriteOperationV2.newBuilder();
            builder.setInput(df.plan().getRoot()).setTableName("t1").addPartitioningColumns(functions$.MODULE$.col("col99").expr()).setProvider("json").putTableProperties("key", "value").putOptions("key2", "value2").setMode(WriteOperationV2.Mode.MODE_CREATE_OR_REPLACE);
            Plan expectedPlan = Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperationV2(builder)).build();
            ((CreateTableWriter)df.writeTo("t1").partitionedBy(functions$.MODULE$.col("col99"), (Seq)Nil$.MODULE$).using("json").tableProperty("key", "value").options((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"value2")})))).createOrReplace();
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("Pivot", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable)x$7 -> {
                ClientDatasetSuite.$anonfun$new$8(x$7);
                return BoxedUnit.UNIT;
            });
            return (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> df.groupBy((Seq)Nil$.MODULE$).pivot(Column$.MODULE$.apply("c"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("col")}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("command extension", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExamplePluginCommand extension = ExamplePluginCommand.newBuilder().setCustomField("abc").build();
            Command command = Command.newBuilder().setExtension(Any.pack((Message)extension)).build();
            Plan expectedPlan = Plan.newBuilder().setCommand(command).build();
            this.ss().execute(Any.pack((Message)extension));
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("serialize as null", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = this.newSparkSession();
            Dataset ds = session.range(10L);
            byte[] bytes = SparkSerDeUtils$.MODULE$.serialize((Object)ds);
            Dataset $org_scalatest_assert_macro_left = (Dataset)SparkSerDeUtils$.MODULE$.deserialize(bytes);
            Object $org_scalatest_assert_macro_right = null;
            Dataset dataset = $org_scalatest_assert_macro_left;
            Object var7_6 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(dataset != null ? !dataset.equals(var7_6) : var7_6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        Statics.releaseFence();
    }
}

