/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.test;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.spark.SparkBuildInfo$;
import org.apache.spark.util.SparkFileUtils$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public final class IntegrationTestUtils$ {
    public static final IntegrationTestUtils$ MODULE$ = new IntegrationTestUtils$();
    private static String scalaVersion;
    private static String scalaDir;
    private static String sparkHome;
    private static String connectClientHomeDir;
    private static String connectClientTestClassDir;
    private static boolean isSparkHiveJarAvailable;
    private static final String DEBUG_SC_JVM_CLIENT;
    private static final String DEBUG_SC_JVM_CLIENT_ENV;
    private static final boolean isDebug;
    private static volatile byte bitmap$0;

    static {
        DEBUG_SC_JVM_CLIENT = "spark.debug.sc.jvm.client";
        DEBUG_SC_JVM_CLIENT_ENV = "SPARK_DEBUG_SC_JVM_CLIENT";
        isDebug = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(System.getProperty(MODULE$.DEBUG_SC_JVM_CLIENT(), "false"))) || Option$.MODULE$.apply((Object)System.getenv(MODULE$.DEBUG_SC_JVM_CLIENT_ENV())).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$1))));
    }

    private String DEBUG_SC_JVM_CLIENT() {
        return DEBUG_SC_JVM_CLIENT;
    }

    private String DEBUG_SC_JVM_CLIENT_ENV() {
        return DEBUG_SC_JVM_CLIENT_ENV;
    }

    public boolean isDebug() {
        return isDebug;
    }

    private String scalaVersion$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                String string;
                Object object;
                String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(Properties$.MODULE$.versionNumberString()), '.');
                if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) >= 0) {
                    String major = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String minor = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    string = new StringBuilder(1).append(major).append(".").append(minor).toString();
                } else {
                    string = Properties$.MODULE$.versionNumberString();
                }
                scalaVersion = string;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return scalaVersion;
    }

    public String scalaVersion() {
        return (byte)(bitmap$0 & 1) == 0 ? this.scalaVersion$lzycompute() : scalaVersion;
    }

    private String scalaDir$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                scalaDir = new StringBuilder(6).append("scala-").append(this.scalaVersion()).toString();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return scalaDir;
    }

    public String scalaDir() {
        return (byte)(bitmap$0 & 2) == 0 ? this.scalaDir$lzycompute() : scalaDir;
    }

    private String sparkHome$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                if (!scala.sys.package$.MODULE$.props().contains("spark.test.home") && !scala.sys.package$.MODULE$.env().contains((Object)"SPARK_HOME")) {
                    throw Assertions$.MODULE$.fail("spark.test.home or SPARK_HOME is not set.", new Position("IntegrationTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
                }
                sparkHome = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"spark.test.home", (Function0 & Serializable)() -> (String)scala.sys.package$.MODULE$.env().apply((Object)"SPARK_HOME"));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        return (byte)(bitmap$0 & 4) == 0 ? this.sparkHome$lzycompute() : sparkHome;
    }

    private String connectClientHomeDir$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                connectClientHomeDir = new StringBuilder(29).append(this.sparkHome()).append("/connector/connect/client/jvm").toString();
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return connectClientHomeDir;
    }

    public String connectClientHomeDir() {
        return (byte)(bitmap$0 & 8) == 0 ? this.connectClientHomeDir$lzycompute() : connectClientHomeDir;
    }

    private String connectClientTestClassDir$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                connectClientTestClassDir = new StringBuilder(21).append(this.connectClientHomeDir()).append("/target/").append(this.scalaDir()).append("/test-classes").toString();
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return connectClientTestClassDir;
    }

    public String connectClientTestClassDir() {
        return (byte)(bitmap$0 & 0x10) == 0 ? this.connectClientTestClassDir$lzycompute() : connectClientTestClassDir;
    }

    public Seq<String> debugConfigs() {
        String log4j2 = new StringBuilder(37).append(this.connectClientHomeDir()).append("/src/test/resources/log4j2.properties").toString();
        return this.isDebug() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--conf", new StringBuilder(52).append("spark.driver.extraJavaOptions=-Dlog4j.configuration=").append(log4j2).toString()})) : (Seq)package$.MODULE$.Seq().empty();
    }

    public void debug(String msg) {
        block0: {
            if (!this.isDebug()) break block0;
            Predef$.MODULE$.println((Object)msg);
        }
    }

    public void debug(Throwable error) {
        block0: {
            if (!this.isDebug()) break block0;
            error.printStackTrace();
        }
    }

    private boolean isSparkHiveJarAvailable$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                String filePath = new StringBuilder(0).append(new StringBuilder(23).append(this.sparkHome()).append("/assembly/target/").append(this.scalaDir()).append("/jars/").toString()).append(new StringBuilder(16).append("spark-hive_").append(this.scalaVersion()).append("-").append(SparkBuildInfo$.MODULE$.spark_version()).append(".jar").toString()).toString();
                isSparkHiveJarAvailable = Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return isSparkHiveJarAvailable;
    }

    public boolean isSparkHiveJarAvailable() {
        return (byte)(bitmap$0 & 0x20) == 0 ? this.isSparkHiveJarAvailable$lzycompute() : isSparkHiveJarAvailable;
    }

    public void cleanUpHiveClassesDirIfNeeded() {
        IntegrationTestUtils$.delete$1(new File(new StringBuilder(25).append(this.sparkHome()).append("/sql/hive/target/").append(this.scalaDir()).append("/classes").toString()));
        IntegrationTestUtils$.delete$1(new File(new StringBuilder(30).append(this.sparkHome()).append("/sql/hive/target/").append(this.scalaDir()).append("/test-classes").toString()));
    }

    public File findJar(String path, String sbtName, String mvnName, boolean test) {
        File jar = (File)this.tryFindJar(path, sbtName, mvnName, test).getOrElse((Function0 & Serializable)() -> {
            String suffix = test ? "-tests.jar" : ".jar";
            String sbtFileName = new StringBuilder(4).append(sbtName).append("(.*)").append(suffix).toString();
            String mvnFileName = new StringBuilder(4).append(mvnName).append("(.*)").append(SparkBuildInfo$.MODULE$.spark_version()).append(suffix).toString();
            throw new RuntimeException(new StringBuilder(0).append(new StringBuilder(29).append("Failed to find the jar: ").append(sbtFileName).append(" or ").append(mvnFileName).append(" ").toString()).append(new StringBuilder(58).append("inside folder: ").append(MODULE$.getTargetFilePath(path)).append(". This file can be generated by similar to ").toString()).append("the following command: build/sbt package|assembly").toString());
        });
        this.debug(new StringBuilder(11).append("Using jar: ").append(jar.getCanonicalPath()).toString());
        return jar;
    }

    public boolean findJar$default$4() {
        return false;
    }

    public Option<File> tryFindJar(String path, String sbtName, String mvnName, boolean test) {
        File targetDir = this.getTargetFilePath(path).toFile();
        Predef$.MODULE$.assert(targetDir.exists(), (Function0 & Serializable)() -> new StringBuilder(129).append(new StringBuilder(38).append("Fail to locate the target folder: '").append(targetDir.getCanonicalPath()).append("'. ").toString()).append(new StringBuilder(15).append("SPARK_HOME='").append(new File(MODULE$.sparkHome()).getCanonicalPath()).append("'. ").toString()).append("Make sure the spark project jars has been built (e.g. using build/sbt package)").append("and the env variable `SPARK_HOME` is set correctly.").toString());
        String suffix = test ? "-tests.jar" : ".jar";
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])this.recursiveListFiles(targetDir)), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IntegrationTestUtils$.$anonfun$tryFindJar$2(sbtName, suffix, mvnName, f)));
    }

    public boolean tryFindJar$default$4() {
        return false;
    }

    private Path getTargetFilePath(String path) {
        return Paths.get(this.sparkHome(), path, "target").toAbsolutePath();
    }

    private File[] recursiveListFiles(File f2) {
        File[] these = f2.listFiles();
        return (File[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])these), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])these), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory()))), (Function1 & Serializable)f -> MODULE$.recursiveListFiles((File)f), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class)), ClassTag$.MODULE$.apply(File.class));
    }

    private static final void delete$1(File f) {
        block0: {
            if (!f.exists()) break block0;
            SparkFileUtils$.MODULE$.deleteRecursively(f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$tryFindJar$2(String sbtName$2, String suffix$1, String mvnName$2, File f) {
        String string = f.getParentFile().getName();
        String string2 = MODULE$.scalaDir();
        if (!(string != null ? !string.equals(string2) : string2 != null) && f.getName().startsWith(sbtName$2)) {
            if (f.getName().endsWith(suffix$1)) return true;
        }
        if (!f.getParent().endsWith("target")) return false;
        if (!f.getName().startsWith(mvnName$2)) return false;
        if (!f.getName().endsWith(new StringBuilder(0).append(SparkBuildInfo$.MODULE$.spark_version()).append(suffix$1).toString())) return false;
        return true;
    }

    private IntegrationTestUtils$() {
    }
}

