/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractServerImplBuilder;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.sql.connect.client.ArtifactManager;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.CustomSparkConnectStub;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.test.ConnectFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001B\u0014)\u0001UBQ\u0001\u0013\u0001\u0005\u0002%C\u0011\"\u000b\u0001A\u0002\u0003\u0007I\u0011\u0002'\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0013\t\u0006\"\u0003.\u0001\u0001\u0004\u0005\t\u0015)\u0003N\u0011%Y\u0006\u00011AA\u0002\u0013%A\fC\u0005a\u0001\u0001\u0007\t\u0019!C\u0005C\"I1\r\u0001a\u0001\u0002\u0003\u0006K!\u0018\u0005\nI\u0002\u0001\r\u00111A\u0005\n\u0015D\u0011B\u001c\u0001A\u0002\u0003\u0007I\u0011B8\t\u0013E\u0004\u0001\u0019!A!B\u00131\u0007\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0003t\u0011%9\b\u00011AA\u0002\u0013%\u0001\u0010C\u0005{\u0001\u0001\u0007\t\u0011)Q\u0005i\"I1\u0010\u0001a\u0001\u0002\u0004%I\u0001 \u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0001\u0003\u0006\u0002\b\u0001\u0001\r\u0011!Q!\nuD1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\f!Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011-\t\t\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u0004\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013%\u0011Q\u0005\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0003C\u0006\u00024\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0002bCA\u001b\u0001\u0001\u0007\t\u0019!C\u0005\u0003oA1\"a\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002B!Y\u0011Q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001d\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!a\u0013\u0001\t\u0013\tI\u0005C\u0004\u0002N\u0001!\t%!\u0013\t\u000f\u0005=\u0003\u0001\"\u0011\u0002J!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002V!9\u0011Q\f\u0001\u0005\u0012\u0005}\u0003bBA;\u0001\u0011E\u0011q\f\u0005\b\u0003o\u0002A\u0011BA=\u0011\u001d\ti\n\u0001C\u0005\u0003?Cq!a0\u0001\t\u0013\t\t\rC\u0004\u0002X\u0002!I!!7\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\ni\u0011I\u001d;jM\u0006\u001cGoU;ji\u0016T!!\u000b\u0016\u0002\r\rd\u0017.\u001a8u\u0015\tYC&A\u0004d_:tWm\u0019;\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011d\b\u0012\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\n\u0001BZ;ogVLG/\u001a\u0006\u0003wI\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005uB$aC!os\u001a+hnU;ji\u0016\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0017\u0002\tQ,7\u000f^\u0005\u0003\u0007\u0002\u0013qbQ8o]\u0016\u001cGOR;o'VLG/\u001a\t\u0003\u000b\u001ak\u0011AO\u0005\u0003\u000fj\u0012!CQ3g_J,\u0017I\u001c3BMR,'/R1dQ\u00061A(\u001b8jiz\"\u0012A\u0013\t\u0003\u0017\u0002i\u0011\u0001K\u000b\u0002\u001bB\u00111JT\u0005\u0003\u001f\"\u0012!c\u00159be.\u001cuN\u001c8fGR\u001cE.[3oi\u0006Q1\r\\5f]R|F%Z9\u0015\u0005IC\u0006CA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&\u0001B+oSRDq!W\u0002\u0002\u0002\u0003\u0007Q*A\u0002yIE\nqa\u00197jK:$\b%A\u0004tKJ4\u0018nY3\u0016\u0003u\u0003\"a\u00130\n\u0005}C#\u0001\u0007#v[6L8\u000b]1sW\u000e{gN\\3diN+'O^5dK\u0006Y1/\u001a:wS\u000e,w\fJ3r)\t\u0011&\rC\u0004Z\r\u0005\u0005\t\u0019A/\u0002\u0011M,'O^5dK\u0002\naa]3sm\u0016\u0014X#\u00014\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001B4sa\u000eT\u0011a[\u0001\u0003S>L!!\u001c5\u0003\rM+'O^3s\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0003%BDq!W\u0005\u0002\u0002\u0003\u0007a-A\u0004tKJ4XM\u001d\u0011\u0002\u001f\u0005\u0014H/\u001b4bGRl\u0015M\\1hKJ,\u0012\u0001\u001e\t\u0003\u0017VL!A\u001e\u0015\u0003\u001f\u0005\u0013H/\u001b4bGRl\u0015M\\1hKJ\f1#\u0019:uS\u001a\f7\r^'b]\u0006<WM]0%KF$\"AU=\t\u000fec\u0011\u0011!a\u0001i\u0006\u0001\u0012M\u001d;jM\u0006\u001cG/T1oC\u001e,'\u000fI\u0001\bG\"\fgN\\3m+\u0005i\bCA4\u007f\u0013\ty\bN\u0001\bNC:\fw-\u001a3DQ\u0006tg.\u001a7\u0002\u0017\rD\u0017M\u001c8fY~#S-\u001d\u000b\u0004%\u0006\u0015\u0001bB-\u0010\u0003\u0003\u0005\r!`\u0001\tG\"\fgN\\3mA\u0005Y!/\u001a;ssB{G.[2z+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005UabA&\u0002\u0012%\u0019\u00111\u0003\u0015\u0002!\u001d\u0013\bo\u0019*fiJL\b*\u00198eY\u0016\u0014\u0018\u0002BA\f\u00033\u00111BU3uef\u0004v\u000e\\5ds*\u0019\u00111\u0003\u0015\u0002\u001fI,GO]=Q_2L7-_0%KF$2AUA\u0010\u0011!I&#!AA\u0002\u00055\u0011\u0001\u0004:fiJL\bk\u001c7jGf\u0004\u0013!\u00022tiV\u0014WCAA\u0014!\rY\u0015\u0011F\u0005\u0004\u0003WA#AH\"vgR|Wn\u00159be.\u001cuN\u001c8fGR\u0014En\\2lS:<7\u000b^;c\u0003%\u00117\u000f^;c?\u0012*\u0017\u000fF\u0002S\u0003cA\u0001\"W\u000b\u0002\u0002\u0003\u0007\u0011qE\u0001\u0007EN$XO\u0019\u0011\u0002\tM$XOY\u000b\u0003\u0003s\u00012aSA\u001e\u0013\r\ti\u0004\u000b\u0002\u0017\u0007V\u001cHo\\7Ta\u0006\u00148nQ8o]\u0016\u001cGo\u0015;vE\u0006A1\u000f^;c?\u0012*\u0017\u000fF\u0002S\u0003\u0007B\u0001\"\u0017\r\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0006gR,(\rI\u0001\u0011gR\f'\u000f\u001e#v[6L8+\u001a:wKJ$\u0012AU\u0001\u0016GJ,\u0017\r^3BeRLg-Y2u\u001b\u0006t\u0017mZ3s\u0003)\u0011WMZ8sK\u0016\u000b7\r[\u0001\nC\u001a$XM]#bG\"\f!b\u0011%V\u001d.{6+\u0013.F+\t\t)\u0006E\u0002T\u0003/J1!!\u0017U\u0005\rIe\u000e^\u0001\f\u0007\"+fjS0T\u0013j+\u0005%\u0001\tbeRLg-Y2u\r&dW\rU1uQV\u0011\u0011\u0011\r\t\u0005\u0003G\n\t(\u0004\u0002\u0002f)!\u0011qMA5\u0003\u00111\u0017\u000e\\3\u000b\t\u0005-\u0014QN\u0001\u0004]&|'BAA8\u0003\u0011Q\u0017M^1\n\t\u0005M\u0014Q\r\u0002\u0005!\u0006$\b.A\bbeRLg-Y2u\u0007J\u001c\u0007+\u0019;i\u000319W\r^\"sGZ\u000bG.^3t)\u0011\tY(!'\u0011\r\u0005u\u0014QRAJ\u001d\u0011\ty(!#\u000f\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"5\u0003\u0019a$o\\8u}%\tQ+C\u0002\u0002\fR\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0010\u0006E%aA*fc*\u0019\u00111\u0012+\u0011\u0007M\u000b)*C\u0002\u0002\u0018R\u0013A\u0001T8oO\"9\u00111\u0014\u0012A\u0002\u0005\u0005\u0014\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0002-\u0005\u001c8/\u001a:u\r&dW\rR1uC\u0016\u000bX/\u00197jif$RAUAQ\u0003wCq!a)$\u0001\u0004\t)+A\u0007beRLg-Y2u\u0007\",hn\u001b\t\u0005\u0003O\u000b)L\u0004\u0003\u0002*\u0006EVBAAV\u0015\u0011\ti+a,\u0002\u000bA\u0014x\u000e^8\u000b\u0005-r\u0013\u0002BAZ\u0003W\u000b1#\u00113e\u0003J$\u0018NZ1diN\u0014V-];fgRLA!a.\u0002:\ni\u0011I\u001d;jM\u0006\u001cGo\u00115v].TA!a-\u0002,\"9\u0011QX\u0012A\u0002\u0005\u0005\u0014!\u00037pG\u0006d\u0007+\u0019;i\u0003]\u0019\u0018N\\4mK\u000eCWO\\6BeRLg-Y2u)\u0016\u001cH\u000fF\u0002S\u0003\u0007Dq!!2%\u0001\u0004\t9-\u0001\u0003qCRD\u0007\u0003BAe\u0003#tA!a3\u0002NB\u0019\u0011\u0011\u0011+\n\u0007\u0005=G+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\f)N\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001f$\u0016!\u0004:fC\u0012tU\r\u001f;DQVt7\u000e\u0006\u0003\u0002\\\u0006=\b\u0003BAo\u0003Wl!!a8\u000b\t\u0005\u0005\u00181]\u0001\taJ|Go\u001c2vM*!\u0011Q]At\u0003\u00199wn\\4mK*\u0011\u0011\u0011^\u0001\u0004G>l\u0017\u0002BAw\u0003?\u0014!BQ=uKN#(/\u001b8h\u0011\u001d\t\t0\na\u0001\u0003g\f!!\u001b8\u0011\t\u0005U\u0018\u0011`\u0007\u0003\u0003oT1a[A7\u0013\u0011\tY0a>\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0016G\",7m[\"ik:\\7\u000fR1uC\u0006sGm\u0011:d)\u0015\u0011&\u0011\u0001B\u0002\u0011\u001d\tYJ\na\u0001\u0003CBqA!\u0002'\u0001\u0004\u00119!\u0001\u0004dQVt7n\u001d\t\u0007\u0003{\ni)!*")
public class ArtifactSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private SparkConnectClient client;
    private DummySparkConnectService service;
    private Server server;
    private ArtifactManager artifactManager;
    private ManagedChannel channel;
    private GrpcRetryHandler.RetryPolicy retryPolicy;
    private CustomSparkConnectBlockingStub bstub;
    private CustomSparkConnectStub stub;
    private final int CHUNK_SIZE;
    private Path baseResourcePath;
    private Path commonResourcePath;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private SparkConnectClient client() {
        return this.client;
    }

    private void client_$eq(SparkConnectClient x$1) {
        this.client = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private ArtifactManager artifactManager() {
        return this.artifactManager;
    }

    private void artifactManager_$eq(ArtifactManager x$1) {
        this.artifactManager = x$1;
    }

    private ManagedChannel channel() {
        return this.channel;
    }

    private void channel_$eq(ManagedChannel x$1) {
        this.channel = x$1;
    }

    private GrpcRetryHandler.RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    private void retryPolicy_$eq(GrpcRetryHandler.RetryPolicy x$1) {
        this.retryPolicy = x$1;
    }

    private CustomSparkConnectBlockingStub bstub() {
        return this.bstub;
    }

    private void bstub_$eq(CustomSparkConnectBlockingStub x$1) {
        this.bstub = x$1;
    }

    private CustomSparkConnectStub stub() {
        return this.stub;
    }

    private void stub_$eq(CustomSparkConnectStub x$1) {
        this.stub = x$1;
    }

    private void startDummyServer() {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((AbstractServerImplBuilder)InProcessServerBuilder.forName((String)this.getClass().getName()).addService((BindableService)this.service())).build());
        this.server().start();
    }

    private void createArtifactManager() {
        this.channel_$eq(((AbstractManagedChannelImplBuilder)InProcessChannelBuilder.forName((String)this.getClass().getName()).directExecutor()).build());
        this.retryPolicy_$eq(new GrpcRetryHandler.RetryPolicy(GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$1(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$7()));
        this.bstub_$eq(new CustomSparkConnectBlockingStub(this.channel(), this.retryPolicy()));
        this.stub_$eq(new CustomSparkConnectStub(this.channel(), this.retryPolicy()));
        this.artifactManager_$eq(new ArtifactManager(new SparkConnectClient.Configuration(SparkConnectClient.Configuration$.MODULE$.apply$default$1(), SparkConnectClient.Configuration$.MODULE$.apply$default$2(), SparkConnectClient.Configuration$.MODULE$.apply$default$3(), SparkConnectClient.Configuration$.MODULE$.apply$default$4(), SparkConnectClient.Configuration$.MODULE$.apply$default$5(), SparkConnectClient.Configuration$.MODULE$.apply$default$6(), SparkConnectClient.Configuration$.MODULE$.apply$default$7(), SparkConnectClient.Configuration$.MODULE$.apply$default$8(), SparkConnectClient.Configuration$.MODULE$.apply$default$9(), SparkConnectClient.Configuration$.MODULE$.apply$default$10(), SparkConnectClient.Configuration$.MODULE$.apply$default$11(), SparkConnectClient.Configuration$.MODULE$.apply$default$12()), "", this.bstub(), this.stub()));
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.startDummyServer();
        this.createArtifactManager();
        this.client_$eq(null);
    }

    public void afterEach() {
        block2: {
            BoxedUnit boxedUnit;
            if (this.server() != null) {
                this.server().shutdownNow();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "ArtifactSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Object object = this.channel() != null ? this.channel().shutdownNow() : BoxedUnit.UNIT;
            if (this.client() == null) break block2;
            this.client().shutdown();
        }
    }

    private int CHUNK_SIZE() {
        return this.CHUNK_SIZE;
    }

    public Path artifactFilePath() {
        return this.commonResourcePath().resolve("artifact-tests");
    }

    public Path artifactCrcPath() {
        return this.artifactFilePath().resolve("crc");
    }

    private Seq<Object> getCrcValues(Path filePath) {
        String fileName = ((Object)filePath.getFileName()).toString();
        String crcFileName = new StringBuilder(4).append((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fileName), '.')))).append(".txt").toString();
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.artifactCrcPath().resolve(crcFileName))).asScala()).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9))))).toSeq();
    }

    private void assertFileDataEquality(AddArtifactsRequest.ArtifactChunk artifactChunk, Path localPath) {
        ByteString localData = ByteString.readFrom((InputStream)Files.newInputStream(localPath, new OpenOption[0]));
        long expectedCrc = BoxesRunTime.unboxToLong((Object)this.getCrcValues(localPath).head());
        ByteString $org_scalatest_assert_macro_left = artifactChunk.getData();
        ByteString $org_scalatest_assert_macro_right = localData;
        ByteString byteString = $org_scalatest_assert_macro_left;
        ByteString byteString2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        long $org_scalatest_assert_macro_left2 = artifactChunk.getCrc();
        long $org_scalatest_assert_macro_right2 = expectedCrc;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }

    private void singleChunkArtifactTest(String path) {
        this.test(new StringBuilder(24).append("Single Chunk Artifact - ").append(path).toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String string;
            String string2;
            Seq<AddArtifactsRequest> receivedRequests;
            Path artifactPath = this.artifactFilePath().resolve(path);
            this.artifactManager().addArtifact(((Object)artifactPath).toString());
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            AddArtifactsRequest request = (AddArtifactsRequest)receivedRequests.head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(request.hasBatch(), "request.hasBatch()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            AddArtifactsRequest.Batch batch = request.getBatch();
            List $org_scalatest_assert_macro_left2 = batch.getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            AddArtifactsRequest.SingleChunkArtifact singleChunkArtifact = batch.getArtifacts(0);
            String string3 = ((Object)artifactPath.getFileName()).toString();
            switch (string3 == null ? 0 : string3.hashCode()) {
                default: 
            }
            if (string3.endsWith(".jar")) {
                string2 = "jars";
            } else if (string3.endsWith(".class")) {
                string2 = "classes";
            } else {
                throw new MatchError((Object)string3);
            }
            String namePrefix = string = string2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(singleChunkArtifact.getName().equals(new StringBuilder(1).append(namePrefix).append("/").append(path).toString()), "singleChunkArtifact.getName().equals(namePrefix.+(\"/\").+(path))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            this.assertFileDataEquality(singleChunkArtifact.getData(), artifactPath);
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }

    private ByteString readNextChunk(InputStream in) {
        byte[] buf = new byte[this.CHUNK_SIZE()];
        int bytesRead = 0;
        int count = 0;
        while (count != -1 && bytesRead < this.CHUNK_SIZE()) {
            count = in.read(buf, bytesRead, this.CHUNK_SIZE() - bytesRead);
            if (count == -1) continue;
            bytesRead += count;
        }
        return bytesRead == 0 ? ByteString.empty() : ByteString.copyFrom((byte[])buf, (int)0, (int)bytesRead);
    }

    private void checkChunksDataAndCrc(Path filePath, Seq<AddArtifactsRequest.ArtifactChunk> chunks) {
        InputStream in = Files.newInputStream(filePath, new OpenOption[0]);
        Seq<Object> crcs = this.getCrcValues(filePath);
        ((IterableOnceOps)chunks.zip(crcs)).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactSuite.$anonfun$checkChunksDataAndCrc$1(this, in, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$checkChunksDataAndCrc$1(ArtifactSuite $this, InputStream in$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AddArtifactsRequest.ArtifactChunk chunk = (AddArtifactsRequest.ArtifactChunk)tuple2._1();
        long expectedCrc = tuple2._2$mcJ$sp();
        ByteString expectedData = $this.readNextChunk(in$1);
        ByteString byteString = chunk.getData();
        ByteString byteString2 = expectedData;
        boolean bl = !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null) && chunk.getCrc() == expectedCrc;
        return bl;
    }

    public ArtifactSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.CHUNK_SIZE = 32768;
        this.singleChunkArtifactTest("smallClassFile.class");
        this.singleChunkArtifactTest("smallJar.jar");
        this.test("Chunked Artifact - junitLargeJar.jar", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path artifactPath = this.artifactFilePath().resolve("junitLargeJar.jar");
            this.artifactManager().addArtifact(((Object)artifactPath).toString());
            int expectedChunks = (384581 + (this.CHUNK_SIZE() - 1)) / this.CHUNK_SIZE();
            Seq<AddArtifactsRequest> receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_left = 384581;
            long $org_scalatest_assert_macro_right = Files.size(artifactPath);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), (long)$org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left2 = receivedRequests;
            int $org_scalatest_assert_macro_right2 = expectedChunks;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((AddArtifactsRequest)receivedRequests.head()).hasBeginChunk(), "receivedRequests.head.hasBeginChunk()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            AddArtifactsRequest.BeginChunkedArtifact beginChunkRequest = ((AddArtifactsRequest)receivedRequests.head()).getBeginChunk();
            String $org_scalatest_assert_macro_left3 = beginChunkRequest.getName();
            String $org_scalatest_assert_macro_right3 = "jars/junitLargeJar.jar";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            long $org_scalatest_assert_macro_left4 = beginChunkRequest.getTotalBytes();
            int $org_scalatest_assert_macro_right4 = 384581;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            long $org_scalatest_assert_macro_left5 = beginChunkRequest.getNumChunks();
            int $org_scalatest_assert_macro_right5 = expectedChunks;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            Seq dataChunks = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AddArtifactsRequest.ArtifactChunk[]{beginChunkRequest.getInitialChunk()})).$plus$plus((IterableOnce)((IterableOps)receivedRequests.drop(1)).map((Function1 & Serializable)x$10 -> x$10.getChunk()));
            this.checkChunksDataAndCrc(artifactPath, (Seq<AddArtifactsRequest.ArtifactChunk>)dataChunks);
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("Batched SingleChunkArtifacts", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq<AddArtifactsRequest> receivedRequests;
            URI file1 = this.artifactFilePath().resolve("smallClassFile.class").toUri();
            URI file2 = this.artifactFilePath().resolve("smallJar.jar").toUri();
            this.artifactManager().addArtifacts((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new URI[]{file1, file2})));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            AddArtifactsRequest request = (AddArtifactsRequest)receivedRequests.head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(request.hasBatch(), "request.hasBatch()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            AddArtifactsRequest.Batch batch = request.getBatch();
            List $org_scalatest_assert_macro_left2 = batch.getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            List artifacts = batch.getArtifactsList();
            String $org_scalatest_assert_macro_left3 = ((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(0)).getName();
            String $org_scalatest_assert_macro_right3 = "classes/smallClassFile.class";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            String $org_scalatest_assert_macro_left4 = ((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(1)).getName();
            String $org_scalatest_assert_macro_right4 = "jars/smallJar.jar";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(0)).getData(), Paths.get(file1));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(1)).getData(), Paths.get(file2));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("Mix of SingleChunkArtifact and chunked artifact", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            List firstReqBatch;
            Seq<AddArtifactsRequest> receivedRequests;
            URI file1 = this.artifactFilePath().resolve("smallClassFile.class").toUri();
            URI file2 = this.artifactFilePath().resolve("junitLargeJar.jar").toUri();
            URI file3 = this.artifactFilePath().resolve("smallClassFileDup.class").toUri();
            URI file4 = this.artifactFilePath().resolve("smallJar.jar").toUri();
            this.artifactManager().addArtifacts((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new URI[]{file1, file2, file3, file4})));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 14;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            List $org_scalatest_assert_macro_left2 = firstReqBatch = ((AddArtifactsRequest)receivedRequests.head()).getBatch().getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            String $org_scalatest_assert_macro_left3 = ((AddArtifactsRequest.SingleChunkArtifact)firstReqBatch.get(0)).getName();
            String $org_scalatest_assert_macro_right3 = "classes/smallClassFile.class";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)firstReqBatch.get(0)).getData(), Paths.get(file1));
            AddArtifactsRequest secondReq = (AddArtifactsRequest)receivedRequests.apply(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(secondReq.hasBeginChunk(), "secondReq.hasBeginChunk()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            AddArtifactsRequest.BeginChunkedArtifact beginChunkRequest = secondReq.getBeginChunk();
            String $org_scalatest_assert_macro_left4 = beginChunkRequest.getName();
            String $org_scalatest_assert_macro_right4 = "jars/junitLargeJar.jar";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            long $org_scalatest_assert_macro_left5 = beginChunkRequest.getTotalBytes();
            int $org_scalatest_assert_macro_right5 = 384581;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            long $org_scalatest_assert_macro_left6 = beginChunkRequest.getNumChunks();
            int $org_scalatest_assert_macro_right6 = 12;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == (long)$org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            Seq dataChunks = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AddArtifactsRequest.ArtifactChunk[]{beginChunkRequest.getInitialChunk()})).$plus$plus((IterableOnce)((IterableOps)((IterableOps)receivedRequests.drop(2)).dropRight(1)).map((Function1 & Serializable)x$11 -> x$11.getChunk()));
            this.checkChunksDataAndCrc(Paths.get(file2), (Seq<AddArtifactsRequest.ArtifactChunk>)dataChunks);
            AddArtifactsRequest.Batch lastBatch = ((AddArtifactsRequest)receivedRequests.last()).getBatch();
            int $org_scalatest_assert_macro_left7 = lastBatch.getArtifactsCount();
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            List remainingArtifacts = lastBatch.getArtifactsList();
            String $org_scalatest_assert_macro_left8 = ((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(0)).getName();
            String $org_scalatest_assert_macro_right8 = "classes/smallClassFileDup.class";
            String string5 = $org_scalatest_assert_macro_left8;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            String $org_scalatest_assert_macro_left9 = ((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(1)).getName();
            String $org_scalatest_assert_macro_right9 = "jars/smallJar.jar";
            String string7 = $org_scalatest_assert_macro_left9;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(0)).getData(), Paths.get(file3));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(1)).getData(), Paths.get(file4));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("cache an artifact and check its presence", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<AddArtifactsRequest> receivedRequests;
            String s = "Hello, World!";
            byte[] blob = s.getBytes("UTF-8");
            String expectedHash = DigestUtils.sha256Hex((byte[])blob);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.artifactManager().isCachedArtifact(expectedHash)));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            String actualHash = this.artifactManager().cacheArtifact(blob);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(actualHash);
            String $org_scalatest_assert_macro_right2 = expectedHash;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.artifactManager().isCachedArtifact(expectedHash)));
            boolean $org_scalatest_assert_macro_right3 = true;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left4 = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        Statics.releaseFence();
    }
}

