/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.spark.SparkException;
import org.apache.spark.connect.proto.CachedRemoteRelation;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.sql.connect.test.RemoteSparkSession;
import org.apache.spark.sql.connect.test.SQLHelper;
import org.apache.spark.sql.connect.test.SQLHelper$testImplicits$;
import org.apache.spark.storage.StorageLevel$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.exceptions.TestFailedDueToTimeoutException;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005a3A!\u0002\u0004\u0001#!)a\u0005\u0001C\u0001O!)!\u0006\u0001C\u0005W!)!\t\u0001C\u0005\u0007\")\u0011\u000b\u0001C\u0005%\ny1\t[3dWB|\u0017N\u001c;Tk&$XM\u0003\u0002\b\u0011\u000591m\u001c8oK\u000e$(BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011#\u0002\u0001\u00135\u0001\u001a\u0003CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003!1WO\\:vSR,'BA\f\u000f\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u001a)\tY\u0011I\\=Gk:\u001cV/\u001b;f!\tYb$D\u0001\u001d\u0015\tib!\u0001\u0003uKN$\u0018BA\u0010\u001d\u0005=\u0019uN\u001c8fGR4UO\\*vSR,\u0007CA\u000e\"\u0013\t\u0011CD\u0001\nSK6|G/Z*qCJ\\7+Z:tS>t\u0007CA\u000e%\u0013\t)CDA\u0005T#2CU\r\u001c9fe\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AB\u0001\u000eG\u0006\u0004H/\u001e:f'R$w*\u001e;\u0015\u00051J\u0004CA\u00177\u001d\tqC\u0007\u0005\u00020e5\t\u0001G\u0003\u00022!\u00051AH]8pizR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\na\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011QG\r\u0005\u0007u\t!\t\u0019A\u001e\u0002\u000b\tdwnY6\u0011\u0007qjt(D\u00013\u0013\tq$G\u0001\u0005=Eft\u0017-\\3?!\ta\u0004)\u0003\u0002Be\t!QK\\5u\u00039\u0019\u0007.Z2l\rJ\fw-\\3oiN$2a\u0010#G\u0011\u0015)5\u00011\u0001-\u0003\u0019\u0011Xm];mi\")qi\u0001a\u0001\u0011\u0006\u0001bM]1h[\u0016tGo\u001d+p\u0007\",7m\u001b\t\u0004\u0013:ccB\u0001&M\u001d\ty3*C\u00014\u0013\ti%'A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0003&aA*fc*\u0011QJM\u0001\u0013i\u0016\u001cHoQ1qiV\u0014X\rZ*uI>+H\u000fF\u0002@'RCaA\u000f\u0003\u0005\u0002\u0004Y\u0004\"B$\u0005\u0001\u0004)\u0006c\u0001\u001fWY%\u0011qK\r\u0002\u000byI,\u0007/Z1uK\u0012t\u0004")
public class CheckpointSuite
extends AnyFunSuite
implements ConnectFunSuite,
RemoteSparkSession,
SQLHelper {
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLHelper$testImplicits$ testImplicits$module;
    private SparkSession spark;
    private int serverPort;
    private boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile byte bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLHelper.withTempDatabase$(this, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLHelper.withTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLHelper.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLHelper.withView$(this, viewNames, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$ignore(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.ignore$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void beforeAll() {
        RemoteSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        RemoteSparkSession.afterAll$(this);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        RemoteSparkSession.test$(this, testName, testTags, testFun, pos);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        CheckpointSuite checkpointSuite = this;
        synchronized (checkpointSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sql = SQLHelper.sql$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sql$lzycompute();
        }
        return this.sql;
    }

    @Override
    public SQLHelper$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private int serverPort$lzycompute() {
        CheckpointSuite checkpointSuite = this;
        synchronized (checkpointSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.serverPort = RemoteSparkSession.serverPort$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.serverPort;
    }

    @Override
    public int serverPort() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.serverPort$lzycompute();
        }
        return this.serverPort;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private String captureStdOut(Function0<BoxedUnit> block) {
        PrintStream currentOut = Console$.MODULE$.out();
        ByteArrayOutputStream capturedOut = new ByteArrayOutputStream();
        PrintStream newOut = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)currentOut, (OutputStream)capturedOut));
        Console$.MODULE$.withOut(newOut, block);
        return capturedOut.toString();
    }

    private void checkFragments(String result, Seq<String> fragmentsToCheck) {
        fragmentsToCheck.foreach((Function1 & Serializable)fragment -> {
            String $org_scalatest_assert_macro_left = result;
            String $org_scalatest_assert_macro_right = fragment;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        });
    }

    private void testCapturedStdOut(Function0<BoxedUnit> block, Seq<String> fragmentsToCheck) {
        this.checkFragments(this.captureStdOut(block), fragmentsToCheck);
    }

    private final void testImplicits$lzycompute$1() {
        CheckpointSuite checkpointSuite = this;
        synchronized (checkpointSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLHelper$testImplicits$(this);
            }
        }
    }

    private final void condition$1(AgnosticEncoder encoder$2, String dfId$2) {
        SparkException ex = (SparkException)this.intercept((Function0 & Serializable)() -> (Long[])this.spark().newDataset(encoder$2, (Function1 & Serializable)builder -> {
            builder.setCachedRemoteRelation(CachedRemoteRelation.newBuilder().setRelationId(dfId$2).build());
            return BoxedUnit.UNIT;
        }).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        String $org_scalatest_assert_macro_left = ex.getMessage();
        String $org_scalatest_assert_macro_right = "No DataFrame with id " + dfId$2 + " is found";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }

    public CheckpointSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        RemoteSparkSession.$init$(this);
        SQLHelper.$init$(this);
        this.test("localCheckpoint", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = this.spark().range(100L).localCheckpoint();
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> df.explain(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExistingRDD"}));
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("localCheckpoint with StorageLevel", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Dataset df = this.spark().range(100L).localCheckpoint(true, StorageLevel$.MODULE$.DISK_ONLY());
            return (Long[])df.collect();
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("localCheckpoint gc", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Dataset df = this.spark().range(100L).localCheckpoint(true);
            AgnosticEncoder encoder = df.agnosticEncoder();
            String dfId = df.plan().getRoot().getCachedRemoteRelation().getRelationId();
            this.spark().cleaner().doCleanupCachedRemoteRelation(dfId);
            SparkException ex = (SparkException)this.intercept((Function0 & Serializable)() -> (Long[])this.spark().newDataset(encoder, (Function1 & Serializable)builder -> {
                builder.setCachedRemoteRelation(CachedRemoteRelation.newBuilder().setRelationId(dfId).build());
                return BoxedUnit.UNIT;
            }).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "No DataFrame with id " + dfId + " is found";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.ignore("localCheckpoint gc derived DataFrame", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df1 = this.spark().range(100L).localCheckpoint(true);
            Dataset derived = df1.repartition(10);
            AgnosticEncoder encoder = df1.agnosticEncoder();
            String dfId = df1.plan().getRoot().getCachedRemoteRelation().getRelationId();
            df1 = null;
            System.gc();
            Thread.sleep(3000L);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.condition$1(encoder, dfId), Retrying$.MODULE$.retryingNatureOfT(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115)), ClassTag$.MODULE$.apply(TestFailedDueToTimeoutException.class), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            derived = null;
            System.gc();
            Thread.sleep(3000L);
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.condition$1(encoder, dfId), Retrying$.MODULE$.retryingNatureOfT(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        Statics.releaseFence();
    }
}

