/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import io.grpc.BindableService;
import io.grpc.ForwardingChannelBuilder2;
import io.grpc.ForwardingServerBuilder;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.WriteOperation;
import org.apache.spark.connect.proto.WriteOperationV2;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.SparkSerDeUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0004\t\u00017!)a\u0006\u0001C\u0001_!I!\u0007\u0001a\u0001\u0002\u0004%Ia\r\u0005\ny\u0001\u0001\r\u00111A\u0005\nuB\u0011B\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001b\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0013A\u0005\"C(\u0001\u0001\u0004\u0005\r\u0011\"\u0003Q\u0011%\u0011\u0006\u00011A\u0001B\u0003&\u0011\nC\u0005T\u0001\u0001\u0007\t\u0019!C\u0005)\"I\u0001\f\u0001a\u0001\u0002\u0004%I!\u0017\u0005\n7\u0002\u0001\r\u0011!Q!\nUCQ\u0001\u0018\u0001\u0005\nuCQA\u0018\u0001\u0005\n}CQ\u0001\u0019\u0001\u0005B}CQ!\u0019\u0001\u0005B}\u0013!c\u00117jK:$H)\u0019;bg\u0016$8+^5uK*\u0011\u0011CE\u0001\bG>tg.Z2u\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0004\n\u0016\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001\u00034v]N,\u0018\u000e^3\u000b\u0005\u0005B\u0012!C:dC2\fG/Z:u\u0013\t\u0019cDA\u0006B]f4UO\\*vSR,\u0007CA\u0013)\u001b\u00051#BA\u0014\u0011\u0003\u0011!Xm\u001d;\n\u0005%2#aD\"p]:,7\r\u001e$v]N+\u0018\u000e^3\u0011\u0005-bS\"\u0001\u0011\n\u00055\u0002#A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\t\u0002\rM,'O^3s+\u0005!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u00119'\u000f]2\u000b\u0003e\n!![8\n\u0005m2$AB*feZ,'/\u0001\u0006tKJ4XM]0%KF$\"A\u0010#\u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\tUs\u0017\u000e\u001e\u0005\b\u000b\u000e\t\t\u00111\u00015\u0003\rAH%M\u0001\bg\u0016\u0014h/\u001a:!\u0003\u001d\u0019XM\u001d<jG\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019B\taa\u00197jK:$\u0018B\u0001(L\u0005a!U/\\7z'B\f'o[\"p]:,7\r^*feZL7-Z\u0001\fg\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0002?#\"9QIBA\u0001\u0002\u0004I\u0015\u0001C:feZL7-\u001a\u0011\u0002\u0005M\u001cX#A+\u0011\u0005E2\u0016BA,\u0011\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019\u00198o\u0018\u0013fcR\u0011aH\u0017\u0005\b\u000b&\t\t\u00111\u0001V\u0003\r\u00198\u000fI\u0001\u0010]\u0016<8\u000b]1sWN+7o]5p]R\tQ+\u0001\tti\u0006\u0014H\u000fR;n[f\u001cVM\u001d<feR\ta(\u0001\u0006cK\u001a|'/Z#bG\"\f\u0011\"\u00194uKJ,\u0015m\u00195")
public class ClientDatasetSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private Server server;
    private DummySparkConnectService service;
    private SparkSession ss;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private SparkSession ss() {
        return this.ss;
    }

    private void ss_$eq(SparkSession x$1) {
        this.ss = x$1;
    }

    private SparkSession newSparkSession() {
        SparkConnectClient client = SparkConnectClient$.MODULE$.apply(((ForwardingChannelBuilder2)InProcessChannelBuilder.forName((String)this.getClass().getName()).directExecutor()).build());
        return new SparkSession(client, new AtomicLong());
    }

    private void startDummyServer() {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((ForwardingServerBuilder)InProcessServerBuilder.forName((String)this.getClass().getName()).addService((BindableService)this.service())).build());
        this.server().start();
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.startDummyServer();
        this.ss_$eq(this.newSparkSession());
    }

    public void afterEach() {
        if (this.server() != null) {
            this.server().shutdownNow();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "ClientDatasetSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(Relation.Builder x$4) {
    }

    private static final Plan toPlan$1(WriteOperation.Builder builder) {
        return Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperation(builder)).build();
    }

    public static final /* synthetic */ void $anonfun$new$4(Relation.Builder x$5) {
    }

    public static final /* synthetic */ void $anonfun$new$6(Relation.Builder x$6) {
    }

    public static final /* synthetic */ void $anonfun$new$8(Relation.Builder x$7) {
    }

    public ClientDatasetSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.test("write", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable)x$4 -> {
                ClientDatasetSuite.$anonfun$new$2(x$4);
                return BoxedUnit.UNIT;
            }).limit(10);
            WriteOperation.Builder builder = WriteOperation.newBuilder().setInput(df.plan().getRoot()).setPath("my/test/path").setMode(WriteOperation.SaveMode.SAVE_MODE_ERROR_IF_EXISTS).setSource("parquet");
            Plan partitionedPlan = ClientDatasetSuite.toPlan$1(((WriteOperation.Builder)builder.clone()).addSortColumnNames("col1").addPartitioningColumns("col99").setBucketBy(WriteOperation.BucketBy.newBuilder().setNumBuckets(2).addBucketColumnNames("col1").addBucketColumnNames("col2")));
            df.write().sortBy("col1", (Seq)Nil$.MODULE$).partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col99"})).bucketBy(2, "col1", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2"})).parquet("my/test/path");
            Plan actualPartionedPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPartionedPlan.equals((Object)partitionedPlan), "actualPartionedPlan.equals(partitionedPlan)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            Plan clusteredPlan = ClientDatasetSuite.toPlan$1(((WriteOperation.Builder)builder.clone()).addClusteringColumns("col3"));
            df.write().clusterBy("col3", (Seq)Nil$.MODULE$).parquet("my/test/path");
            Plan actualClusteredPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(actualClusteredPlan.equals((Object)clusteredPlan), "actualClusteredPlan.equals(clusteredPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("write jdbc", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable)x$5 -> {
                ClientDatasetSuite.$anonfun$new$4(x$5);
                return BoxedUnit.UNIT;
            }).limit(10);
            WriteOperation.Builder builder = WriteOperation.newBuilder();
            builder.setInput(df.plan().getRoot()).setMode(WriteOperation.SaveMode.SAVE_MODE_ERROR_IF_EXISTS).setSource("jdbc").putOptions("a", "b").putOptions("1", "2").putOptions("url", "url").putOptions("dbtable", "table");
            Plan expectedPlan = Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperation(builder)).build();
            Properties connectionProperties = new Properties();
            connectionProperties.put("a", "b");
            connectionProperties.put("1", "2");
            df.write().jdbc("url", "table", connectionProperties);
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("write V2", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable)x$6 -> {
                ClientDatasetSuite.$anonfun$new$6(x$6);
                return BoxedUnit.UNIT;
            }).limit(10);
            Column partCol = functions$.MODULE$.col("col99");
            WriteOperationV2.Builder builder = WriteOperationV2.newBuilder();
            builder.setInput(df.plan().getRoot()).setTableName("t1").addPartitioningColumns(this.toExpr(partCol)).setProvider("json").addClusteringColumns("col3").putTableProperties("key", "value").putOptions("key2", "value2").setMode(WriteOperationV2.Mode.MODE_CREATE_OR_REPLACE);
            Plan expectedPlan = Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperationV2(builder)).build();
            df.writeTo("t1").partitionedBy(partCol, (Seq)Nil$.MODULE$).clusterBy("col3", (Seq)Nil$.MODULE$).using("json").tableProperty("key", "value").options((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"value2")}))).createOrReplace();
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("Pivot", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable)x$7 -> {
                ClientDatasetSuite.$anonfun$new$8(x$7);
                return BoxedUnit.UNIT;
            });
            return (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> df.groupBy((Seq)Nil$.MODULE$).pivot(Column$.MODULE$.apply("c"), (Seq)new .colon.colon((Object)Column$.MODULE$.apply("col"), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("serialize as null", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = this.newSparkSession();
            Dataset ds = session.range(10L);
            byte[] bytes = SparkSerDeUtils$.MODULE$.serialize((Object)ds);
            Dataset $org_scalatest_assert_macro_left = (Dataset)SparkSerDeUtils$.MODULE$.deserialize(bytes);
            Object $org_scalatest_assert_macro_right = null;
            Dataset dataset = $org_scalatest_assert_macro_left;
            Object var7_6 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(dataset != null ? !dataset.equals(var7_6) : var7_6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        }, new Position("ClientDatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }
}

