/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Function0;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005a3Aa\u0003\u0007\u0001/!)a\u0005\u0001C\u0001O!)!\u0006\u0001C\u0005W!9\u0001\n\u0001b\u0001\n\u0013I\u0005B\u0002&\u0001A\u0003%A\tC\u0004L\u0001\t\u0007I\u0011B%\t\r1\u0003\u0001\u0015!\u0003E\u0011\u001di\u0005A1A\u0005\n%CaA\u0014\u0001!\u0002\u0013!\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B)\u0003#\u0019+hn\u0019;j_:$Vm\u001d;Tk&$XM\u0003\u0002\u000e\u001d\u000591m\u001c8oK\u000e$(BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011c\u0001\u0001\u0019AA\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\tMVt7/^5uK*\u0011Q\u0004F\u0001\ng\u000e\fG.\u0019;fgRL!a\b\u000e\u0003\u0017\u0005s\u0017PR;o'VLG/\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003G1\tA\u0001^3ti&\u0011QE\t\u0002\u0010\u0007>tg.Z2u\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011\u0001D\u0001\u000bi\u0016\u001cH/R9vC2\u001cHc\u0001\u00173\u007fA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t!QK\\5u\u0011\u0015\u0019$\u00011\u00015\u0003\u0011q\u0017-\\3\u0011\u0005UbdB\u0001\u001c;!\t9d&D\u00019\u0015\tId#\u0001\u0004=e>|GOP\u0005\u0003w9\na\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111H\f\u0005\u0006\u0001\n\u0001\r!Q\u0001\bG>dW/\u001c8t!\ri#\tR\u0005\u0003\u0007:\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\t)e)D\u0001\u000f\u0013\t9eB\u0001\u0004D_2,XN\\\u0001\u0002CV\tA)\u0001\u0002bA\u0005\t!-\u0001\u0002cA\u0005\t1-\u0001\u0002dA\u000511o\u00195f[\u0006,\u0012!\u0015\t\u0003%Vk\u0011a\u0015\u0006\u0003):\tQ\u0001^=qKNL!AV*\u0003\u0015M#(/^2u)f\u0004X-A\u0004tG\",W.\u0019\u0011")
public class FunctionTestSuite
extends AnyFunSuite
implements ConnectFunSuite {
    private final Column a;
    private final Column b;
    private final Column c;
    private final StructType schema;

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private void testEquals(String name, Seq<Column> columns) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq unique;
            Seq $org_scalatest_assert_macro_left = columns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            Seq $org_scalatest_assert_macro_left2 = unique = (Seq)columns.distinct();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
    }

    private Column a() {
        return this.a;
    }

    private Column b() {
        return this.b;
    }

    private Column c() {
        return this.c;
    }

    private StructType schema() {
        return this.schema;
    }

    public FunctionTestSuite() {
        ConnectFunSuite.$init$(this);
        this.a = functions$.MODULE$.col("a");
        this.b = functions$.MODULE$.col("b");
        this.c = functions$.MODULE$.col("c");
        this.schema = new StructType().add("key", "long").add("value", "string");
        this.testEquals("col/column", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), functions$.MODULE$.column("a")}));
        this.testEquals("asc/asc_nulls_first", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.asc("a"), functions$.MODULE$.asc_nulls_first("a")}));
        this.testEquals("desc/desc_nulls_last", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc("a"), functions$.MODULE$.desc_nulls_last("a")}));
        this.testEquals("approx_count_distinct", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.approxCountDistinct(this.a()), functions$.MODULE$.approxCountDistinct("a"), functions$.MODULE$.approx_count_distinct("a"), functions$.MODULE$.approx_count_distinct(this.a())}));
        this.testEquals("approx_count_distinct rsd", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.approxCountDistinct(this.a(), 0.1), functions$.MODULE$.approxCountDistinct("a", 0.1), functions$.MODULE$.approx_count_distinct("a", 0.1), functions$.MODULE$.approx_count_distinct(this.a(), 0.1)}));
        this.testEquals("avg/mean", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.avg("a"), functions$.MODULE$.avg(this.a()), functions$.MODULE$.mean(this.a()), functions$.MODULE$.mean("a")}));
        this.testEquals("collect_list", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.collect_list("a"), functions$.MODULE$.collect_list(this.a())}));
        this.testEquals("collect_set", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.collect_set("a"), functions$.MODULE$.collect_set(this.a())}));
        this.testEquals("corr", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.corr("a", "b"), functions$.MODULE$.corr(this.a(), this.b())}));
        this.testEquals("count_distinct", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.countDistinct(this.a(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.b(), this.c()})), functions$.MODULE$.countDistinct("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"})), functions$.MODULE$.count_distinct(this.a(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.b(), this.c()}))}));
        this.testEquals("covar_pop", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.covar_pop(this.a(), this.b()), functions$.MODULE$.covar_pop("a", "b")}));
        this.testEquals("covar_samp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.covar_samp(this.a(), this.b()), functions$.MODULE$.covar_samp("a", "b")}));
        this.testEquals("first", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.first("a"), functions$.MODULE$.first(this.a()), functions$.MODULE$.first("a", false), functions$.MODULE$.first(this.a(), false)}));
        this.testEquals("grouping", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.grouping("a"), functions$.MODULE$.grouping(this.a())}));
        this.testEquals("grouping_id", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.grouping_id("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), functions$.MODULE$.grouping_id((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.b()}))}));
        this.testEquals("kurtosis", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.kurtosis("a"), functions$.MODULE$.kurtosis(this.a())}));
        this.testEquals("last", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.last("a"), functions$.MODULE$.last(this.a()), functions$.MODULE$.last("a", false), functions$.MODULE$.last(this.a(), false)}));
        this.testEquals("max", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max("a"), functions$.MODULE$.max(this.a())}));
        this.testEquals("min", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.min("a"), functions$.MODULE$.min(this.a())}));
        this.testEquals("skewness", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.skewness("a"), functions$.MODULE$.skewness(this.a())}));
        this.testEquals("stddev", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.stddev("a"), functions$.MODULE$.stddev(this.a())}));
        this.testEquals("stddev_samp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.stddev_samp("a"), functions$.MODULE$.stddev_samp(this.a())}));
        this.testEquals("stddev_pop", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.stddev_pop("a"), functions$.MODULE$.stddev_pop(this.a())}));
        this.testEquals("sum", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("a"), functions$.MODULE$.sum(this.a())}));
        this.testEquals("sum_distinct", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sumDistinct("a"), functions$.MODULE$.sumDistinct(this.a()), functions$.MODULE$.sum_distinct(this.a())}));
        this.testEquals("variance", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.variance("a"), functions$.MODULE$.variance(this.a())}));
        this.testEquals("var_samp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.var_samp("a"), functions$.MODULE$.var_samp(this.a())}));
        this.testEquals("var_pop", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.var_pop("a"), functions$.MODULE$.var_pop(this.a())}));
        this.testEquals("array", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.b(), this.c()})), functions$.MODULE$.array("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))}));
        this.testEquals("monotonicallyIncreasingId", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.monotonicallyIncreasingId(), functions$.MODULE$.monotonically_increasing_id()}));
        this.testEquals("sqrt", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sqrt("a"), functions$.MODULE$.sqrt(this.a())}));
        this.testEquals("struct", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.c(), this.b()})), functions$.MODULE$.struct("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c", "b"}))}));
        this.testEquals("bitwise_not", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.bitwiseNOT(this.a()), functions$.MODULE$.bitwise_not(this.a())}));
        this.testEquals("acos", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.acos("a"), functions$.MODULE$.acos(this.a())}));
        this.testEquals("acosh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.acosh("a"), functions$.MODULE$.acosh(this.a())}));
        this.testEquals("asin", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.asin("a"), functions$.MODULE$.asin(this.a())}));
        this.testEquals("asinh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.asinh("a"), functions$.MODULE$.asinh(this.a())}));
        this.testEquals("atan", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.atan("a"), functions$.MODULE$.atan(this.a())}));
        this.testEquals("atan2", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.atan2(this.a(), this.b()), functions$.MODULE$.atan2(this.a(), "b"), functions$.MODULE$.atan2("a", this.b()), functions$.MODULE$.atan2("a", "b")}));
        this.testEquals("atanh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.atanh("a"), functions$.MODULE$.atanh(this.a())}));
        this.testEquals("bin", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.bin("a"), functions$.MODULE$.bin(this.a())}));
        this.testEquals("cbrt", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.cbrt("a"), functions$.MODULE$.cbrt(this.a())}));
        this.testEquals("ceil", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.ceil(this.a()), functions$.MODULE$.ceil("a")}));
        this.testEquals("cos", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.cos("a"), functions$.MODULE$.cos(this.a())}));
        this.testEquals("cosh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.cosh("a"), functions$.MODULE$.cosh(this.a())}));
        this.testEquals("exp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.exp("a"), functions$.MODULE$.exp(this.a())}));
        this.testEquals("expm1", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expm1("a"), functions$.MODULE$.expm1(this.a())}));
        this.testEquals("floor", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.floor(this.a()), functions$.MODULE$.floor("a")}));
        this.testEquals("greatest", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.greatest((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.b(), this.c()})), functions$.MODULE$.greatest("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))}));
        this.testEquals("hypot", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hypot(this.a(), this.b()), functions$.MODULE$.hypot("a", this.b()), functions$.MODULE$.hypot(this.a(), "b"), functions$.MODULE$.hypot("a", "b")}));
        this.testEquals("hypot right fixed", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hypot(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)3.0)), this.a()), functions$.MODULE$.hypot(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)3.0)), "a"), functions$.MODULE$.hypot(3.0, this.a()), functions$.MODULE$.hypot(3.0, "a")}));
        this.testEquals("hypot left fixed", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hypot(this.a(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)4.0))), functions$.MODULE$.hypot(this.a(), 4.0), functions$.MODULE$.hypot("a", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)4.0))), functions$.MODULE$.hypot("a", 4.0)}));
        this.testEquals("least", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.least((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.b(), this.c()})), functions$.MODULE$.least("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))}));
        this.testEquals("log", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.log("a"), functions$.MODULE$.log(this.a())}));
        this.testEquals("log base", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.log(2.0, "a"), functions$.MODULE$.log(2.0, this.a())}));
        this.testEquals("log10", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.log10("a"), functions$.MODULE$.log10(this.a())}));
        this.testEquals("log1p", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.log1p("a"), functions$.MODULE$.log1p(this.a())}));
        this.testEquals("log2", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.log2("a"), functions$.MODULE$.log2(this.a())}));
        this.testEquals("pow", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.pow(this.a(), this.b()), functions$.MODULE$.pow(this.a(), "b"), functions$.MODULE$.pow("a", this.b()), functions$.MODULE$.pow("a", "b")}));
        this.testEquals("pow left fixed", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.pow(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)7.0)), this.b()), functions$.MODULE$.pow(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)7.0)), "b"), functions$.MODULE$.pow(7.0, this.b()), functions$.MODULE$.pow(7.0, "b")}));
        this.testEquals("pow right fixed", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.pow(this.a(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)9.0))), functions$.MODULE$.pow(this.a(), 9.0), functions$.MODULE$.pow("a", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)9.0))), functions$.MODULE$.pow("a", 9.0)}));
        this.testEquals("rint", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.rint(this.a()), functions$.MODULE$.rint("a")}));
        this.testEquals("round", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.round(this.a()), functions$.MODULE$.round(this.a(), 0)}));
        this.testEquals("bround", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.bround(this.a()), functions$.MODULE$.bround(this.a(), 0)}));
        this.testEquals("shiftleft", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.shiftLeft(this.a(), 2), functions$.MODULE$.shiftleft(this.a(), 2)}));
        this.testEquals("shiftright", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.shiftRight(this.a(), 3), functions$.MODULE$.shiftright(this.a(), 3)}));
        this.testEquals("shiftrightunsigned", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.shiftRightUnsigned(this.a(), 3), functions$.MODULE$.shiftrightunsigned(this.a(), 3)}));
        this.testEquals("signum", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.signum("a"), functions$.MODULE$.signum(this.a())}));
        this.testEquals("sin", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sin("a"), functions$.MODULE$.sin(this.a())}));
        this.testEquals("sinh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sinh("a"), functions$.MODULE$.sinh(this.a())}));
        this.testEquals("tan", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.tan("a"), functions$.MODULE$.tan(this.a())}));
        this.testEquals("tanh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.tanh("a"), functions$.MODULE$.tanh(this.a())}));
        this.testEquals("degrees", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.toDegrees(this.a()), functions$.MODULE$.toDegrees("a"), functions$.MODULE$.degrees(this.a()), functions$.MODULE$.degrees("a")}));
        this.testEquals("radians", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.toRadians(this.a()), functions$.MODULE$.toRadians("a"), functions$.MODULE$.radians(this.a()), functions$.MODULE$.radians("a")}));
        this.testEquals("regexp_replace", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.regexp_replace(this.a(), functions$.MODULE$.lit((Object)"foo"), functions$.MODULE$.lit((Object)"bar")), functions$.MODULE$.regexp_replace(this.a(), "foo", "bar")}));
        this.testEquals("add_months", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.add_months(this.a(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))), functions$.MODULE$.add_months(this.a(), 1)}));
        this.testEquals("date_add", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.date_add(this.a(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))), functions$.MODULE$.date_add(this.a(), 2)}));
        this.testEquals("date_sub", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.date_sub(this.a(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))), functions$.MODULE$.date_sub(this.a(), 2)}));
        this.testEquals("next_day", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.next_day(this.a(), functions$.MODULE$.lit((Object)"Mon")), functions$.MODULE$.next_day(this.a(), functions$.MODULE$.lit((Object)"Mon"))}));
        this.testEquals("unix_timestamp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.unix_timestamp(), functions$.MODULE$.unix_timestamp(functions$.MODULE$.current_timestamp())}));
        this.testEquals("from_utc_timestamp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_utc_timestamp(this.a(), "GMT"), functions$.MODULE$.from_utc_timestamp(this.a(), functions$.MODULE$.lit((Object)"GMT"))}));
        this.testEquals("to_utc_timestamp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_utc_timestamp(this.a(), "GMT"), functions$.MODULE$.to_utc_timestamp(this.a(), functions$.MODULE$.lit((Object)"GMT"))}));
        this.testEquals("window", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.window(this.a(), "10 seconds", "10 seconds", "0 second"), functions$.MODULE$.window(this.a(), "10 seconds", "10 seconds"), functions$.MODULE$.window(this.a(), "10 seconds")}));
        this.testEquals("session_window", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.session_window(this.a(), "1 second"), functions$.MODULE$.session_window(this.a(), functions$.MODULE$.lit((Object)"1 second"))}));
        this.testEquals("slice", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.slice(this.a(), 1, 2), functions$.MODULE$.slice(this.a(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)))}));
        this.testEquals("bucket", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.bucket(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)3)), this.a()), functions$.MODULE$.bucket(3, this.a())}));
        this.testEquals("lag", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lag(this.a(), 1), functions$.MODULE$.lag("a", 1), functions$.MODULE$.lag(this.a(), 1, null), functions$.MODULE$.lag("a", 1, null), functions$.MODULE$.lag(this.a(), 1, null, false)}));
        this.testEquals("lead", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lead(this.a(), 2), functions$.MODULE$.lead("a", 2), functions$.MODULE$.lead(this.a(), 2, null), functions$.MODULE$.lead("a", 2, null), functions$.MODULE$.lead(this.a(), 2, null, false)}));
        this.testEquals("from_json with sql schema", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_json(this.a(), (DataType)this.schema()), functions$.MODULE$.from_json(this.a(), this.schema()), functions$.MODULE$.from_json(this.a(), (DataType)this.schema(), Predef$.MODULE$.Map().empty()), functions$.MODULE$.from_json(this.a(), (DataType)this.schema(), Collections.emptyMap()), functions$.MODULE$.from_json(this.a(), this.schema(), Predef$.MODULE$.Map().empty()), functions$.MODULE$.from_json(this.a(), this.schema(), Collections.emptyMap())}));
        this.testEquals("from_json with json schema", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_json(this.a(), functions$.MODULE$.lit((Object)this.schema().json())), functions$.MODULE$.from_json(this.a(), this.schema().json(), Predef$.MODULE$.Map().empty()), functions$.MODULE$.from_json(this.a(), this.schema().json(), Collections.emptyMap()), functions$.MODULE$.from_json(this.a(), functions$.MODULE$.lit((Object)this.schema().json()), Collections.emptyMap())}));
        this.testEquals("schema_of_json", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.schema_of_json(functions$.MODULE$.lit((Object)"x,y")), functions$.MODULE$.schema_of_json("x,y")}));
        this.testEquals("to_json", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_json(this.a()), functions$.MODULE$.to_json(this.a(), Collections.emptyMap()), functions$.MODULE$.to_json(this.a(), Predef$.MODULE$.Map().empty())}));
        this.testEquals("sort_array", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sort_array(this.a()), functions$.MODULE$.sort_array(this.a(), true)}));
        this.testEquals("from_csv", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_csv(this.a(), functions$.MODULE$.lit((Object)this.schema().toDDL()), Collections.emptyMap()), functions$.MODULE$.from_csv(this.a(), this.schema(), Predef$.MODULE$.Map().empty())}));
        this.testEquals("schema_of_csv", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.schema_of_csv(functions$.MODULE$.lit((Object)"x,y")), functions$.MODULE$.schema_of_csv("x,y"), functions$.MODULE$.schema_of_csv(functions$.MODULE$.lit((Object)"x,y"), Collections.emptyMap())}));
        this.testEquals("to_csv", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_csv(this.a()), functions$.MODULE$.to_csv(this.a(), Collections.emptyMap())}));
        this.testEquals("from_xml with sql schema", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_xml(this.a(), this.schema()), functions$.MODULE$.from_xml(this.a(), this.schema(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava()), functions$.MODULE$.from_xml(this.a(), this.schema(), Collections.emptyMap())}));
        this.testEquals("from_xml with json schema", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_xml(this.a(), functions$.MODULE$.lit((Object)this.schema().json())), functions$.MODULE$.from_xml(this.a(), this.schema().json(), Collections.emptyMap()), functions$.MODULE$.from_xml(this.a(), this.schema().json(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava()), functions$.MODULE$.from_xml(this.a(), functions$.MODULE$.lit((Object)this.schema().json()), Collections.emptyMap())}));
        this.testEquals("schema_of_xml", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.schema_of_xml(functions$.MODULE$.lit((Object)"<p><a>1.0</a><b>test</b></p>")), functions$.MODULE$.schema_of_xml("<p><a>1.0</a><b>test</b></p>"), functions$.MODULE$.schema_of_xml(functions$.MODULE$.lit((Object)"<p><a>1.0</a><b>test</b></p>"), Collections.emptyMap())}));
        this.testEquals("to_xml", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_xml(this.a()), functions$.MODULE$.to_xml(this.a(), Collections.emptyMap())}));
        this.testEquals("from_avro", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.avro.functions$.MODULE$.from_avro(this.a(), "{\"type\": \"int\", \"name\": \"id\"}"), org.apache.spark.sql.avro.functions$.MODULE$.from_avro(this.a(), "{\"type\": \"int\", \"name\": \"id\"}", Collections.emptyMap())}));
        this.testEquals("call_udf", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.callUDF("bob", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))})), functions$.MODULE$.call_udf("bob", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))}))}));
        this.test("assert_true no message", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression e = this.toExpr(functions$.MODULE$.assert_true(this.a()));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(e.hasUnresolvedFunction(), "e.hasUnresolvedFunction()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            Expression.UnresolvedFunction fn = e.getUnresolvedFunction();
            String $org_scalatest_assert_macro_left = fn.getFunctionName();
            String $org_scalatest_assert_macro_right = "assert_true";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            int $org_scalatest_assert_macro_left2 = fn.getArgumentsCount();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            Expression $org_scalatest_assert_macro_left3 = fn.getArguments(0);
            Expression $org_scalatest_assert_macro_right3 = this.toExpr(this.a());
            Expression expression = $org_scalatest_assert_macro_left3;
            Expression expression2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(expression != null ? !expression.equals(expression2) : expression2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        }, new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.test("json_tuple zero args", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> functions$.MODULE$.json_tuple(this.a(), (Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267)), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("rand no seed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression e = this.toExpr(functions$.MODULE$.rand());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(e.hasUnresolvedFunction(), "e.hasUnresolvedFunction()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            Expression.UnresolvedFunction fn = e.getUnresolvedFunction();
            String $org_scalatest_assert_macro_left = fn.getFunctionName();
            String $org_scalatest_assert_macro_right = "rand";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            int $org_scalatest_assert_macro_left2 = fn.getArgumentsCount();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }, new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.test("randn no seed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression e = this.toExpr(functions$.MODULE$.randn());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(e.hasUnresolvedFunction(), "e.hasUnresolvedFunction()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            Expression.UnresolvedFunction fn = e.getUnresolvedFunction();
            String $org_scalatest_assert_macro_left = fn.getFunctionName();
            String $org_scalatest_assert_macro_right = "randn";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            int $org_scalatest_assert_macro_left2 = fn.getArgumentsCount();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        }, new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
    }
}

