/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.typesafe.tools.mima.core.DirectMissingMethodProblem;
import com.typesafe.tools.mima.core.IncompatibleSignatureProblem;
import com.typesafe.tools.mima.core.MissingClassProblem;
import com.typesafe.tools.mima.core.MissingTypesProblem;
import com.typesafe.tools.mima.core.Problem;
import com.typesafe.tools.mima.core.ProblemFilters$;
import com.typesafe.tools.mima.lib.MiMaLib;
import com.typesafe.tools.mima.lib.MiMaLib$;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.spark.SparkBuildInfo$;
import org.apache.spark.sql.connect.client.CheckConnectJvmClientCompatibility;
import org.apache.spark.sql.connect.test.IntegrationTestUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CheckConnectJvmClientCompatibility$ {
    public static final CheckConnectJvmClientCompatibility$ MODULE$ = new CheckConnectJvmClientCompatibility$();
    private static String sparkHome;
    private static final File sqlJar;
    private static final File clientJar;
    private static volatile boolean bitmap$0;

    static {
        Path path = Paths.get(MODULE$.sparkHome(), "sql", "core", "target", "scala-" + IntegrationTestUtils$.MODULE$.scalaVersion(), "spark-sql_" + IntegrationTestUtils$.MODULE$.scalaVersion() + "-" + SparkBuildInfo$.MODULE$.spark_version() + ".jar");
        Predef$.MODULE$.assert(Files.exists(path, new LinkOption[0]), (Function0 & Serializable)() -> path + " does not exist");
        sqlJar = path.toFile();
        Path path2 = Paths.get(MODULE$.sparkHome(), "sql", "connect", "client", "jvm", "target", "scala-" + IntegrationTestUtils$.MODULE$.scalaVersion(), "spark-connect-client-jvm_" + IntegrationTestUtils$.MODULE$.scalaVersion() + "-" + SparkBuildInfo$.MODULE$.spark_version() + ".jar");
        Predef$.MODULE$.assert(Files.exists(path2, new LinkOption[0]), (Function0 & Serializable)() -> path2 + " does not exist");
        clientJar = path2.toFile();
    }

    private String sparkHome$lzycompute() {
        CheckConnectJvmClientCompatibility$ checkConnectJvmClientCompatibility$ = this;
        synchronized (checkConnectJvmClientCompatibility$) {
            if (!bitmap$0) {
                if (!scala.sys.package$.MODULE$.env().contains((Object)"SPARK_HOME")) {
                    throw new IllegalArgumentException("SPARK_HOME is not set.");
                }
                sparkHome = (String)scala.sys.package$.MODULE$.env().apply((Object)"SPARK_HOME");
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    private String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    private File sqlJar() {
        return sqlJar;
    }

    private File clientJar() {
        return clientJar;
    }

    public void main(String[] args) {
        try (Writer resultWriter = null;){
            try {
                resultWriter = Files.newBufferedWriter(Paths.get(this.sparkHome() + "/.connect-mima-check-result", new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                List<Problem> problemsWithSqlModule = this.checkMiMaCompatibilityWithSqlModule(this.clientJar(), this.sqlJar());
                this.appendMimaCheckErrorMessageIfNeeded(resultWriter, problemsWithSqlModule, this.clientJar(), this.sqlJar(), "Sql", this.appendMimaCheckErrorMessageIfNeeded$default$6());
                List<Problem> problemsWithClientModule = this.checkMiMaCompatibilityWithReversedSqlModule(this.clientJar(), this.sqlJar());
                this.appendMimaCheckErrorMessageIfNeeded(resultWriter, problemsWithClientModule, this.clientJar(), this.sqlJar(), "ReversedSql", "Sql");
                File avroJar = IntegrationTestUtils$.MODULE$.findJar("connector/avro", "spark-avro", "spark-avro", IntegrationTestUtils$.MODULE$.findJar$default$4());
                List<Problem> problemsWithAvroModule = this.checkMiMaCompatibilityWithAvroModule(this.clientJar(), avroJar);
                this.appendMimaCheckErrorMessageIfNeeded(resultWriter, problemsWithAvroModule, this.clientJar(), avroJar, "Avro", this.appendMimaCheckErrorMessageIfNeeded$default$6());
                File protobufJar = IntegrationTestUtils$.MODULE$.findJar("connector/protobuf", "spark-protobuf-assembly", "spark-protobuf", IntegrationTestUtils$.MODULE$.findJar$default$4());
                List<Problem> problemsWithProtobufModule = this.checkMiMaCompatibilityWithProtobufModule(this.clientJar(), protobufJar);
                this.appendMimaCheckErrorMessageIfNeeded(resultWriter, problemsWithProtobufModule, this.clientJar(), protobufJar, "Protobuf", this.appendMimaCheckErrorMessageIfNeeded$default$6());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)e.getMessage());
                resultWriter.write("ERROR: " + e.getMessage() + "\n");
            }
        }
    }

    private List<Problem> checkMiMaCompatibilityWithAvroModule(File clientJar, File avroJar) {
        .colon.colon includedRules = new .colon.colon((Object)new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.avro.functions.*"), (List)Nil$.MODULE$);
        Seq excludeRules = (Seq)package$.MODULE$.Seq().empty();
        return this.checkMiMaCompatibility(clientJar, avroJar, (Seq<CheckConnectJvmClientCompatibility.IncludeByName>)includedRules, (Seq<Function1<Problem, Object>>)excludeRules);
    }

    private List<Problem> checkMiMaCompatibilityWithProtobufModule(File clientJar, File protobufJar) {
        .colon.colon includedRules = new .colon.colon((Object)new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.protobuf.functions.*"), (List)Nil$.MODULE$);
        Seq excludeRules = (Seq)package$.MODULE$.Seq().empty();
        return this.checkMiMaCompatibility(clientJar, protobufJar, (Seq<CheckConnectJvmClientCompatibility.IncludeByName>)includedRules, (Seq<Function1<Problem, Object>>)excludeRules);
    }

    private List<Problem> checkMiMaCompatibilityWithSqlModule(File clientJar, File sqlJar) {
        .colon.colon includedRules = new .colon.colon((Object)new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.*"), (List)Nil$.MODULE$);
        Seq excludeRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.avro.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.api.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.catalyst.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.columnar.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.connector.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.classic.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.execution.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.internal.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.jdbc.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.scripting.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.sources.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.ui.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.test.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.util.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.*.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.ExperimentalMethods", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSessionExtensions", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSessionExtensionsProvider", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.ExtendedExplainGenerator", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDTFRegistration", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataSourceRegistration", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.TableArg", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.artifact.ArtifactStateForCleanup", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.artifact.ArtifactStateForCleanup$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameNaFunctions.fillValue", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.selectUntyped", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RelationalGroupedDataset$*", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.baseRelationToDataFrame", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.canUseSession", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.DataStreamWriter$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.DataStreamWriter.SOURCE*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.TestGroupState", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.TestGroupState$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.artifact.ArtifactManager", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.artifact.ArtifactManager$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.artifact.ArtifactManager$SparkContextResourceType$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.expression", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.toRichColumn", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration.register", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration.log*", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration.LogStringContext", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration.withLogContext", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration.isTraceEnabled", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration.initializeForcefully", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration.initializeLogIfNecessary", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration.initializeLogIfNecessary$default$2", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameReader.validateSingleVariantColumn", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameReader.validateJsonSchema", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameReader.validateXmlSchema", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.DataStreamReader.validateJsonSchema", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.DataStreamReader.validateXmlSchema", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class))}));
        return this.checkMiMaCompatibility(clientJar, sqlJar, (Seq<CheckConnectJvmClientCompatibility.IncludeByName>)includedRules, (Seq<Function1<Problem, Object>>)excludeRules);
    }

    private List<Problem> checkMiMaCompatibilityWithReversedSqlModule(File clientJar, File sqlJar) {
        .colon.colon includedRules = new .colon.colon((Object)new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.*"), (List)Nil$.MODULE$);
        Seq excludeRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.application.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.connect.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.internal.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.*.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameStatFunctions$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.KeyValueGroupedDatasetImpl", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.KeyValueGroupedDatasetImpl$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.RichColumn", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession$RichColumn", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.plan", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.collectResult", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.newDataFrame", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.newDataset", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.execute", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.registerClassFinder", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.baseRelationToDataFrame", ClassTag$.MODULE$.apply(IncompatibleSignatureProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.client", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.build", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.interceptor", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLContext$ListTableRow", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLContext$ListTableRow$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLImplicits.session", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.RemoteStreamingQuery", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.RemoteStreamingQuery$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListenerBus", ClassTag$.MODULE$.apply(MissingClassProblem.class))}));
        return this.checkMiMaCompatibility(sqlJar, clientJar, (Seq<CheckConnectJvmClientCompatibility.IncludeByName>)includedRules, (Seq<Function1<Problem, Object>>)excludeRules);
    }

    private List<Problem> checkMiMaCompatibility(File newJar, File oldJar, Seq<CheckConnectJvmClientCompatibility.IncludeByName> includedRules, Seq<Function1<Problem, Object>> excludeRules) {
        MiMaLib mima = new MiMaLib((Seq)new .colon.colon((Object)newJar, (List)new .colon.colon((Object)oldJar, (List)Nil$.MODULE$)), MiMaLib$.MODULE$.$lessinit$greater$default$2());
        List allProblems = mima.collectProblems(oldJar, newJar, package$.MODULE$.List().empty());
        Set effectiveExcludeRules = (Set)Set$.MODULE$.empty();
        List problems = allProblems.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)includedRules.exists((Function1 & Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)rule.apply(p))))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)excludeRules.forall((Function1 & Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)CheckConnectJvmClientCompatibility$.$anonfun$checkMiMaCompatibility$4(p, effectiveExcludeRules$1, rule)))));
        ((IterableOnceOps)excludeRules.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)effectiveExcludeRules.contains((Object)elem)))).foreach((Function1 & Serializable)rule -> {
            Predef$.MODULE$.println((Object)("Warning: " + rule + " did not filter out any problems."));
            return BoxedUnit.UNIT;
        });
        return problems;
    }

    private void appendMimaCheckErrorMessageIfNeeded(Writer resultWriter, List<Problem> problems, File clientModule, File targetModule, String targetName, String description) {
        if (problems.nonEmpty()) {
            resultWriter.write("ERROR: Comparing Client jar: " + clientModule + " and " + targetName + " jar: " + targetModule + " \n");
            resultWriter.write("problems with " + targetName + " module: \n");
            List problemDescriptions = problems.map((Function1 & Serializable)p -> p.getClass().getSimpleName() + ": " + p.description().apply((Object)description));
            resultWriter.write(problemDescriptions.mkString("\n"));
            resultWriter.write("\n\n");
            resultWriter.write("Exceptions to binary compatibility can be added in 'CheckConnectJvmClientCompatibility#checkMiMaCompatibilityWith" + targetName + "Module':\n");
            resultWriter.write(((IterableOnceOps)problems.flatMap((Function1 & Serializable)x$1 -> x$1.howToFilter()).distinct()).mkString(",\n"));
            resultWriter.write("\n\n");
            return;
        }
    }

    private String appendMimaCheckErrorMessageIfNeeded$default$6() {
        return "client";
    }

    public static final /* synthetic */ boolean $anonfun$checkMiMaCompatibility$4(Problem p$2, Set effectiveExcludeRules$1, Function1 rule) {
        boolean passedRule = BoxesRunTime.unboxToBoolean((Object)rule.apply((Object)p$2));
        Object object = !passedRule ? effectiveExcludeRules$1.$plus$eq((Object)rule) : BoxedUnit.UNIT;
        return passedRule;
    }

    private CheckConnectJvmClientCompatibility$() {
    }
}

