/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Artifact;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.connect.client.REPLClassDirMonitor;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.util.SparkFileUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005I2A\u0001B\u0003\u0001%!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003BB\u0019\u0001A\u0003%qE\u0001\tDY\u0006\u001c8OR5oI\u0016\u00148+^5uK*\u0011aaB\u0001\u0007G2LWM\u001c;\u000b\u0005!I\u0011aB2p]:,7\r\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001MY\u0002C\u0001\u000b\u001a\u001b\u0005)\"B\u0001\f\u0018\u0003!1WO\\:vSR,'B\u0001\r\u0010\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u001b+\tY\u0011I\\=Gk:\u001cV/\u001b;f!\tar$D\u0001\u001e\u0015\tqr!\u0001\u0003uKN$\u0018B\u0001\u0011\u001e\u0005=\u0019uN\u001c8fGR4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u0006\u0003E\u0019G.Y:t%\u0016\u001cx.\u001e:dKB\u000bG\u000f[\u000b\u0002OA\u0011\u0001fL\u0007\u0002S)\u0011!fK\u0001\u0005M&dWM\u0003\u0002-[\u0005\u0019a.[8\u000b\u00039\nAA[1wC&\u0011\u0001'\u000b\u0002\u0005!\u0006$\b.\u0001\ndY\u0006\u001c8OU3t_V\u00148-\u001a)bi\"\u0004\u0003")
public class ClassFinderSuite
extends AnyFunSuite
implements ConnectFunSuite {
    private final Path classResourcePath;

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private Path classResourcePath() {
        return this.classResourcePath;
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Path classPath$1, Artifact x$1) {
        Path path = x$1.path();
        Path path2 = Paths.get("classes", new String[0]).resolve(classPath$1);
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    private static final void checkClasses$1(REPLClassDirMonitor monitor, Seq additionalClasses, Seq requiredClasses$1) {
        Seq expectedClassFiles = (Seq)((IterableOps)requiredClasses$1.$plus$plus((IterableOnce)additionalClasses)).map((Function1 & Serializable)name -> Paths.get(name, new String[0]));
        Seq foundArtifacts = monitor.findClasses().toSeq();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(expectedClassFiles.forall((Function1 & Serializable)classPath -> BoxesRunTime.boxToBoolean((boolean)foundArtifacts.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClassFinderSuite.$anonfun$new$5(classPath, x$1))))), "expectedClassFiles.forall(((classPath: java.nio.file.Path) => foundArtifacts.exists(((x$1: org.apache.spark.sql.Artifact) => x$1.path.==(java.nio.file.Paths.get(\"classes\").resolve(classPath))))))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassFinderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
    }

    private static final Seq checkClasses$default$2$1() {
        return Nil$.MODULE$;
    }

    public ClassFinderSuite() {
        ConnectFunSuite.$init$(this);
        this.classResourcePath = this.commonResourcePath().resolve("artifact-tests");
        this.test("REPLClassDirMonitor functionality test", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon requiredClasses = new .colon.colon((Object)"Hello.class", (List)new .colon.colon((Object)"smallClassFile.class", (List)new .colon.colon((Object)"smallClassFileDup.class", (List)Nil$.MODULE$)));
            requiredClasses.foreach((Function1 & Serializable)className -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.classResourcePath().resolve((String)className).toFile().exists(), "ClassFinderSuite.this.classResourcePath.resolve(className).toFile().exists()", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassFinderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
            });
            Path copyDir = SparkFileUtils$.MODULE$.createTempDir().toPath();
            FileUtils.copyDirectory((File)this.classResourcePath().toFile(), (File)copyDir.toFile());
            REPLClassDirMonitor monitor = new REPLClassDirMonitor(((Object)copyDir.toAbsolutePath()).toString());
            ClassFinderSuite.checkClasses$1(monitor, ClassFinderSuite.checkClasses$default$2$1(), (Seq)requiredClasses);
            File subDir = SparkFileUtils$.MODULE$.createTempDir(((Object)copyDir.toAbsolutePath()).toString(), SparkFileUtils$.MODULE$.createTempDir$default$2());
            Path classToCopy = copyDir.resolve("Hello.class");
            Path copyLocation = subDir.toPath().resolve("HelloDup.class");
            FileUtils.copyFile((File)classToCopy.toFile(), (File)copyLocation.toFile());
            ClassFinderSuite.checkClasses$1(monitor, (Seq)new .colon.colon((Object)(subDir.getName() + "/HelloDup.class"), (List)Nil$.MODULE$), (Seq)requiredClasses);
        }, new Position("ClassFinderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }
}

