/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.test;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.spark.SparkBuildInfo$;
import org.apache.spark.util.SparkFileUtils$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class IntegrationTestUtils$ {
    public static final IntegrationTestUtils$ MODULE$ = new IntegrationTestUtils$();
    private static String scalaVersion;
    private static String scalaDir;
    private static String sparkHome;
    private static String connectClientHomeDir;
    private static String connectClientTestClassDir;
    private static boolean isSparkHiveJarAvailable;
    private static boolean isAssemblyJarsDirExists;
    private static final String DEBUG_SC_JVM_CLIENT;
    private static final String DEBUG_SC_JVM_CLIENT_ENV;
    private static final boolean isDebug;
    private static volatile byte bitmap$0;

    static {
        DEBUG_SC_JVM_CLIENT = "spark.debug.sc.jvm.client";
        DEBUG_SC_JVM_CLIENT_ENV = "SPARK_DEBUG_SC_JVM_CLIENT";
        isDebug = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(System.getProperty(MODULE$.DEBUG_SC_JVM_CLIENT(), "false"))) || Option$.MODULE$.apply((Object)System.getenv(MODULE$.DEBUG_SC_JVM_CLIENT_ENV())).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$1))));
    }

    private String DEBUG_SC_JVM_CLIENT() {
        return DEBUG_SC_JVM_CLIENT;
    }

    private String DEBUG_SC_JVM_CLIENT_ENV() {
        return DEBUG_SC_JVM_CLIENT_ENV;
    }

    public boolean isDebug() {
        return isDebug;
    }

    private String scalaVersion$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                Object object;
                Object object2;
                String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(Properties$.MODULE$.versionNumberString()), '.');
                if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) >= 0) {
                    String major = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                    String minor = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                    object = major + "." + minor;
                } else {
                    object = Properties$.MODULE$.versionNumberString();
                }
                scalaVersion = object;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return scalaVersion;
    }

    public String scalaVersion() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.scalaVersion$lzycompute();
        }
        return scalaVersion;
    }

    private String scalaDir$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                scalaDir = "scala-" + this.scalaVersion();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return scalaDir;
    }

    public String scalaDir() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.scalaDir$lzycompute();
        }
        return scalaDir;
    }

    private String sparkHome$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                if (!scala.sys.package$.MODULE$.props().contains("spark.test.home") && !scala.sys.package$.MODULE$.env().contains((Object)"SPARK_HOME")) {
                    throw Assertions$.MODULE$.fail("spark.test.home or SPARK_HOME is not set.", new Position("IntegrationTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
                }
                sparkHome = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"spark.test.home", (Function0 & Serializable)() -> (String)scala.sys.package$.MODULE$.env().apply((Object)"SPARK_HOME"));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    private String connectClientHomeDir$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                connectClientHomeDir = this.sparkHome() + "/sql/connect/client/jvm";
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return connectClientHomeDir;
    }

    public String connectClientHomeDir() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.connectClientHomeDir$lzycompute();
        }
        return connectClientHomeDir;
    }

    private String connectClientTestClassDir$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                connectClientTestClassDir = this.connectClientHomeDir() + "/target/" + this.scalaDir() + "/test-classes";
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return connectClientTestClassDir;
    }

    public String connectClientTestClassDir() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.connectClientTestClassDir$lzycompute();
        }
        return connectClientTestClassDir;
    }

    public Seq<String> debugConfigs() {
        String log4j2 = this.connectClientHomeDir() + "/src/test/resources/log4j2.properties";
        if (this.isDebug()) {
            return new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)("spark.driver.extraJavaOptions=-Dlog4j.configurationFile=" + log4j2), (List)Nil$.MODULE$));
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public void debug(String msg) {
        if (this.isDebug()) {
            Predef$.MODULE$.println((Object)msg);
            return;
        }
    }

    public void debug(Throwable error) {
        if (this.isDebug()) {
            error.printStackTrace();
            return;
        }
    }

    private boolean isSparkHiveJarAvailable$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                String filePath = this.sparkHome() + "/assembly/target/" + this.scalaDir() + "/jars/spark-hive_" + this.scalaVersion() + "-" + SparkBuildInfo$.MODULE$.spark_version() + ".jar";
                isSparkHiveJarAvailable = Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return isSparkHiveJarAvailable;
    }

    public boolean isSparkHiveJarAvailable() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.isSparkHiveJarAvailable$lzycompute();
        }
        return isSparkHiveJarAvailable;
    }

    private boolean isAssemblyJarsDirExists$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(bitmap$0 & 0x40) == 0) {
                String filePath = this.sparkHome() + "/assembly/target/" + this.scalaDir() + "/jars/";
                isAssemblyJarsDirExists = Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
                bitmap$0 = (byte)(bitmap$0 | 0x40);
            }
        }
        return isAssemblyJarsDirExists;
    }

    public boolean isAssemblyJarsDirExists() {
        if ((byte)(bitmap$0 & 0x40) == 0) {
            return this.isAssemblyJarsDirExists$lzycompute();
        }
        return isAssemblyJarsDirExists;
    }

    public void cleanUpHiveClassesDirIfNeeded() {
        IntegrationTestUtils$.delete$1(new File(this.sparkHome() + "/sql/hive/target/" + this.scalaDir() + "/classes"));
        IntegrationTestUtils$.delete$1(new File(this.sparkHome() + "/sql/hive/target/" + this.scalaDir() + "/test-classes"));
    }

    public File findJar(String path, String sbtName, String mvnName, boolean test) {
        File jar = (File)this.tryFindJar(path, sbtName, mvnName, test).getOrElse((Function0 & Serializable)() -> {
            String suffix = test ? "-tests.jar" : ".jar";
            String sbtFileName = sbtName + "(.*)" + suffix;
            String mvnFileName = mvnName + "(.*)" + SparkBuildInfo$.MODULE$.spark_version() + suffix;
            throw new RuntimeException("Failed to find the jar: " + sbtFileName + " or " + mvnFileName + " inside folder: " + MODULE$.getTargetFilePath(path) + ". This file can be generated by similar to the following command: build/sbt package|assembly");
        });
        this.debug("Using jar: " + jar.getCanonicalPath());
        return jar;
    }

    public boolean findJar$default$4() {
        return false;
    }

    public Option<File> tryFindJar(String path, String sbtName, String mvnName, boolean test) {
        File targetDir = this.getTargetFilePath(path).toFile();
        Predef$.MODULE$.assert(targetDir.exists(), (Function0 & Serializable)() -> "Fail to locate the target folder: '" + targetDir.getCanonicalPath() + "'. SPARK_HOME='" + new File(MODULE$.sparkHome()).getCanonicalPath() + "'. Make sure the spark project jars has been built (e.g. using build/sbt package)and the env variable `SPARK_HOME` is set correctly.");
        String suffix = test ? "-tests.jar" : ".jar";
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])this.recursiveListFiles(targetDir)), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IntegrationTestUtils$.$anonfun$tryFindJar$2(sbtName, suffix, mvnName, f)));
    }

    public boolean tryFindJar$default$4() {
        return false;
    }

    private Path getTargetFilePath(String path) {
        return Paths.get(this.sparkHome(), path, "target").toAbsolutePath();
    }

    private File[] recursiveListFiles(File f2) {
        File[] these = f2.listFiles();
        return (File[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])these), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])these), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory()))), (Function1 & Serializable)f -> MODULE$.recursiveListFiles((File)f), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class)), ClassTag$.MODULE$.apply(File.class));
    }

    private static final void delete$1(File f) {
        if (f.exists()) {
            SparkFileUtils$.MODULE$.deleteRecursively(f);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$tryFindJar$2(String sbtName$2, String suffix$1, String mvnName$2, File f) {
        String string = f.getParentFile().getName();
        String string2 = MODULE$.scalaDir();
        if (!(string != null ? !string.equals(string2) : string2 != null) && f.getName().startsWith(sbtName$2)) {
            if (f.getName().endsWith(suffix$1)) return true;
        }
        if (!f.getParent().endsWith("target")) return false;
        if (!f.getName().startsWith(mvnName$2)) return false;
        if (!f.getName().endsWith(SparkBuildInfo$.MODULE$.spark_version() + suffix$1)) return false;
        return true;
    }

    private IntegrationTestUtils$() {
    }
}

