/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.application;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.application.ConnectRepl$;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.sql.connect.test.IntegrationTestUtils$;
import org.apache.spark.sql.connect.test.RemoteSparkSession;
import org.apache.spark.tags.AmmoniteTest;
import org.apache.spark.util.IvyTestUtils$;
import org.apache.spark.util.MavenUtils;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

@AmmoniteTest
@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\u000f\u001f\u0001%BQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013%a\t\u0003\u0004R\u0001\u0001\u0006Ia\u0012\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019Q\u0006\u0001)A\u0005)\"I1\f\u0001a\u0001\u0002\u0004%I\u0001\u0018\u0005\nG\u0002\u0001\r\u00111A\u0005\n\u0011D\u0011B\u001b\u0001A\u0002\u0003\u0005\u000b\u0015B/\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0013a\u0007\"\u0003<\u0001\u0001\u0004\u0005\r\u0011\"\u0003x\u0011%I\b\u00011A\u0001B\u0003&Q\u000eC\u0005{\u0001\u0001\u0007\t\u0019!C\u0005Y\"I1\u0010\u0001a\u0001\u0002\u0004%I\u0001 \u0005\n}\u0002\u0001\r\u0011!Q!\n5D!b \u0001A\u0002\u0003\u0007I\u0011BA\u0001\u0011-\tI\u0001\u0001a\u0001\u0002\u0004%I!a\u0003\t\u0017\u0005=\u0001\u00011A\u0001B\u0003&\u00111\u0001\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"a\u0007\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0005\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!!\u0012\u0001\t\u0003\n\u0019\u0005C\u0004\u0002H\u0001!\t%a\u0011\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0002\r%\u0016\u0004H.\u0012\u001aF'VLG/\u001a\u0006\u0003?\u0001\n1\"\u00199qY&\u001c\u0017\r^5p]*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M)\u0001A\u000b\u001a;{A\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\tMVt7/^5uK*\u0011qFJ\u0001\ng\u000e\fG.\u0019;fgRL!!\r\u0017\u0003\u0017\u0005s\u0017PR;o'VLG/\u001a\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA\u0001^3ti*\u0011q\u0007I\u0001\bG>tg.Z2u\u0013\tIDGA\bD_:tWm\u0019;Gk:\u001cV/\u001b;f!\t\u00194(\u0003\u0002=i\t\u0011\"+Z7pi\u0016\u001c\u0006/\u0019:l'\u0016\u001c8/[8o!\tqt(D\u0001/\u0013\t\u0001eF\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0017A\u0002\u001fj]&$h\bF\u0001D!\t!\u0005!D\u0001\u001f\u0003=)\u00070Z2vi>\u00148+\u001a:wS\u000e,W#A$\u0011\u0005!{U\"A%\u000b\u0005)[\u0015AC2p]\u000e,(O]3oi*\u0011A*T\u0001\u0005kRLGNC\u0001O\u0003\u0011Q\u0017M^1\n\u0005AK%aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002!\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013a\u0004+J\u001b\u0016{U\u000bV0T\u000b\u000e{e\nR*\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u00131!\u00138u\u0003A!\u0016*T#P+R{6+R\"P\u001d\u0012\u001b\u0006%\u0001\u0007uKN$8+^5uK>+H/F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001W*\u0001\u0002j_&\u0011!m\u0018\u0002\u0012!&\u0004X\rZ(viB,Ho\u0015;sK\u0006l\u0017\u0001\u0005;fgR\u001cV/\u001b;f\u001fV$x\fJ3r)\t)\u0007\u000e\u0005\u0002VM&\u0011qM\u0016\u0002\u0005+:LG\u000fC\u0004j\u000f\u0005\u0005\t\u0019A/\u0002\u0007a$\u0013'A\u0007uKN$8+^5uK>+H\u000fI\u0001\fC6lwN\\5uK>+H/F\u0001n!\tqG/D\u0001p\u0015\t\u0001\u0018/\u0001\u0004pkR\u0004X\u000f\u001e\u0006\u0003AJT!a\u001d\u0013\u0002\u000f\r|W.\\8og&\u0011Qo\u001c\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0003=\tW.\\8oSR,w*\u001e;`I\u0015\fHCA3y\u0011\u001dI'\"!AA\u00025\fA\"Y7n_:LG/Z(vi\u0002\n1\"\u001a:s_J\u001cFO]3b[\u0006yQM\u001d:peN#(/Z1n?\u0012*\u0017\u000f\u0006\u0002f{\"9\u0011.DA\u0001\u0002\u0004i\u0017\u0001D3se>\u00148\u000b\u001e:fC6\u0004\u0013AC1n[>t\u0017\u000e^3J]V\u0011\u00111\u0001\t\u0004=\u0006\u0015\u0011bAA\u0004?\n\u0001\u0002+\u001b9fI&s\u0007/\u001e;TiJ,\u0017-\\\u0001\u000fC6lwN\\5uK&sw\fJ3r)\r)\u0017Q\u0002\u0005\tSB\t\t\u00111\u0001\u0002\u0004\u0005Y\u0011-\\7p]&$X-\u00138!\u0003%\u0019X-\\1qQ>\u0014X-\u0006\u0002\u0002\u0016A\u0019\u0001*a\u0006\n\u0007\u0005e\u0011JA\u0005TK6\f\u0007\u000f[8sK\u0006Q1/Z7ba\"|'/\u001a\u0011\u0002\u0019M\u001c\u0017\r\\1WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003cqA!!\n\u0002.A\u0019\u0011q\u0005,\u000e\u0005\u0005%\"bAA\u0016Q\u00051AH]8pizJ1!a\fW\u0003\u0019\u0001&/\u001a3fM&!\u00111GA\u001b\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0006,\u0002\u001bM\u001c\u0017\r\\1WKJ\u001c\u0018n\u001c8!\u000399W\r^\"mK\u0006t7\u000b\u001e:j]\u001e$B!!\t\u0002>!1\u0011q\b\fA\u00025\f1a\\;u\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001f\u0003!\tg\r^3s\u00032d\u0017!C1gi\u0016\u0014X)Y2i\u0003I\u0011XO\\\"p[6\fg\u000eZ:J]NCW\r\u001c7\u0015\t\u0005\u0005\u0012Q\n\u0005\b\u0003\u001fR\u0002\u0019AA\u0011\u0003\u0015Ig\u000e];u\u0003\u0005\u0012XO\\\"p[6\fg\u000eZ:Vg&twmU5oO2,7)\u001a7m\u0013:\u001c\u0006.\u001a7m)\u0011\t\t#!\u0016\t\u000f\u0005=3\u00041\u0001\u0002\"\u0005q\u0011m]:feR\u001cuN\u001c;bS:\u001cH#B3\u0002\\\u0005}\u0003bBA/9\u0001\u0007\u0011\u0011E\u0001\b[\u0016\u001c8/Y4f\u0011\u0019\u0001H\u00041\u0001\u0002\"!\u001a\u0001!a\u0019\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001b#\u0003\u0011!\u0018mZ:\n\t\u00055\u0014q\r\u0002\r\u00036lwN\\5uKR+7\u000f\u001e")
public class ReplE2ESuite
extends AnyFunSuite
implements ConnectFunSuite,
RemoteSparkSession,
BeforeAndAfterEach {
    private final ExecutorService executorService;
    private final int TIMEOUT_SECONDS;
    private PipedOutputStream testSuiteOut;
    private ByteArrayOutputStream org$apache$spark$sql$application$ReplE2ESuite$$ammoniteOut;
    private ByteArrayOutputStream org$apache$spark$sql$application$ReplE2ESuite$$errorStream;
    private PipedInputStream org$apache$spark$sql$application$ReplE2ESuite$$ammoniteIn;
    private final Semaphore org$apache$spark$sql$application$ReplE2ESuite$$semaphore;
    private final String scalaVersion;
    private SparkSession spark;
    private int serverPort;
    private boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile boolean bitmap$0;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$ignore(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.ignore$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        RemoteSparkSession.test$(this, testName, testTags, testFun, pos);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private int serverPort$lzycompute() {
        ReplE2ESuite replE2ESuite = this;
        synchronized (replE2ESuite) {
            if (!this.bitmap$0) {
                this.serverPort = RemoteSparkSession.serverPort$(this);
                this.bitmap$0 = true;
            }
        }
        return this.serverPort;
    }

    @Override
    public int serverPort() {
        if (!this.bitmap$0) {
            return this.serverPort$lzycompute();
        }
        return this.serverPort;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private ExecutorService executorService() {
        return this.executorService;
    }

    private int TIMEOUT_SECONDS() {
        return this.TIMEOUT_SECONDS;
    }

    private PipedOutputStream testSuiteOut() {
        return this.testSuiteOut;
    }

    private void testSuiteOut_$eq(PipedOutputStream x$1) {
        this.testSuiteOut = x$1;
    }

    public ByteArrayOutputStream org$apache$spark$sql$application$ReplE2ESuite$$ammoniteOut() {
        return this.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteOut;
    }

    private void ammoniteOut_$eq(ByteArrayOutputStream x$1) {
        this.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteOut = x$1;
    }

    public ByteArrayOutputStream org$apache$spark$sql$application$ReplE2ESuite$$errorStream() {
        return this.org$apache$spark$sql$application$ReplE2ESuite$$errorStream;
    }

    private void errorStream_$eq(ByteArrayOutputStream x$1) {
        this.org$apache$spark$sql$application$ReplE2ESuite$$errorStream = x$1;
    }

    public PipedInputStream org$apache$spark$sql$application$ReplE2ESuite$$ammoniteIn() {
        return this.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteIn;
    }

    private void ammoniteIn_$eq(PipedInputStream x$1) {
        this.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteIn = x$1;
    }

    public Semaphore org$apache$spark$sql$application$ReplE2ESuite$$semaphore() {
        return this.org$apache$spark$sql$application$ReplE2ESuite$$semaphore;
    }

    private String scalaVersion() {
        return this.scalaVersion;
    }

    private String getCleanString(ByteArrayOutputStream out) {
        return out.toString("UTF-8").replaceAll("\u001b\\[[\\d;]*[^\\d;]", "");
    }

    @Override
    public void beforeAll() {
        RemoteSparkSession.beforeAll$(this);
        this.ammoniteOut_$eq(new ByteArrayOutputStream());
        this.testSuiteOut_$eq(new PipedOutputStream());
        this.ammoniteIn_$eq(new PipedInputStream(this.testSuiteOut()));
        this.errorStream_$eq(new ByteArrayOutputStream());
        String[] args = (String[])((Object[])new String[]{"--port", Integer.toString(this.serverPort())});
        Runnable task = new Runnable(this, args){
            private final /* synthetic */ ReplE2ESuite $outer;
            private final String[] args$1;

            public void run() {
                System.setProperty("spark.sql.abc", "abc");
                ConnectRepl$.MODULE$.doMain(this.args$1, (Option)new Some((Object)this.$outer.org$apache$spark$sql$application$ReplE2ESuite$$semaphore()), (InputStream)this.$outer.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteIn(), (OutputStream)this.$outer.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteOut(), (OutputStream)this.$outer.org$apache$spark$sql$application$ReplE2ESuite$$errorStream());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.args$1 = args$1;
            }
        };
        this.executorService().submit(task);
    }

    @Override
    public void afterAll() {
        this.executorService().shutdownNow();
        RemoteSparkSession.afterAll$(this);
    }

    public void afterEach() {
        this.org$apache$spark$sql$application$ReplE2ESuite$$semaphore().drainPermits();
    }

    public String runCommandsInShell(String input) {
        this.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteOut().reset();
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(input)));
        String paddedInput = input + '\n' + "semaphore.release()\n";
        this.testSuiteOut().write(paddedInput.getBytes());
        this.testSuiteOut().flush();
        if (!this.org$apache$spark$sql$application$ReplE2ESuite$$semaphore().tryAcquire(this.TIMEOUT_SECONDS(), TimeUnit.SECONDS)) {
            String failOut = this.getCleanString(this.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteOut());
            String errOut = this.getCleanString(this.org$apache$spark$sql$application$ReplE2ESuite$$errorStream());
            String errorString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |REPL Timed out while running command: " + input + "\n          |Console output: " + failOut + "\n          |Error output: " + errOut + "\n          |"));
            throw new RuntimeException(errorString);
        }
        return this.getCleanString(this.org$apache$spark$sql$application$ReplE2ESuite$$ammoniteOut());
    }

    public String runCommandsUsingSingleCellInShell(String input) {
        return this.runCommandsInShell("{\n" + input + "\n}");
    }

    public void assertContains(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Ammonite output did not contain '" + message + "':\n" + output + "\nError Output: " + this.getCleanString(this.org$apache$spark$sql$application$ReplE2ESuite$$errorStream())), Prettifier$.MODULE$.default(), new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
    }

    public static final /* synthetic */ void $anonfun$new$8(ReplE2ESuite $this, String repo) {
        String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |// this import will fail\n           |import my.great.lib.MyLib\n           |\n           |// making library available in the REPL to compile UDF\n           |import coursierapi.{Credentials, MavenRepository}\n           |interp.repositories() ++= Seq(MavenRepository.of(\"" + repo + "\"))\n           |import $ivy.`my.great.lib:mylib:0.1`\n           |\n           |val func = udf((a: Int) => {\n           |  import my.great.lib.MyLib\n           |  MyLib.myFunc(a)\n           |})\n           |\n           |// add library to the Executor\n           |spark.addArtifact(\"ivy://my.great.lib:mylib:0.1?repos=" + repo + "\")\n           |\n           |spark.range(5).select(func(col(\"id\"))).as[Int].collect()\n           |"));
        String output = $this.runCommandsInShell(input);
        $this.assertContains("not found: value my", $this.getCleanString($this.org$apache$spark$sql$application$ReplE2ESuite$$errorStream()));
        $this.assertContains("Array[Int] = Array(1, 2, 3, 4, 5)", output);
    }

    public ReplE2ESuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        RemoteSparkSession.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.executorService = Executors.newSingleThreadExecutor();
        this.TIMEOUT_SECONDS = 30;
        this.org$apache$spark$sql$application$ReplE2ESuite$$semaphore = new Semaphore(0);
        this.scalaVersion = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])Properties$.MODULE$.versionNumberString().split("\\.")), 2)).mkString(".");
        this.test("Simple query", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |spark.sql(\"select 1\").collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[org.apache.spark.sql.Row] = Array([1])", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("UDF containing 'def'", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class A(x: Int) { def get = x * 5 + 19 }\n        |def dummyUdf(x: Int): Int = new A(x).get\n        |val myUdf = udf(dummyUdf _)\n        |spark.range(5).select(myUdf(col(\"id\"))).as[Int].collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[Int] = Array(19, 24, 29, 34, 39)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("UDF containing in-place lambda", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class A(x: Int) { def get = x * 42 + 5 }\n        |val myUdf = udf((x: Int) => new A(x).get)\n        |spark.range(5).select(myUdf(col(\"id\"))).as[Int].collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[Int] = Array(5, 47, 89, 131, 173)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("Updating UDF properties", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class A(x: Int) { def get = x * 7 }\n        |val myUdf = udf((x: Int) => new A(x).get)\n        |val modifiedUdf = myUdf.withName(\"myUdf\").asNondeterministic()\n        |spark.range(5).select(modifiedUdf(col(\"id\"))).as[Int].collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[Int] = Array(0, 7, 14, 21, 28)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("SPARK-43198: Filter does not throw ammonite-related class initialization exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |spark.range(10).filter(n => n % 2 == 0).collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[java.lang.Long] = Array(0L, 2L, 4L, 6L, 8L)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("Client-side JAR", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String sparkHome = IntegrationTestUtils$.MODULE$.sparkHome();
            File testJar = Paths.get(sparkHome + "/sql/connect/client/jvm/src/test/resources/TestHelloV2_" + this.scalaVersion() + ".jar", new String[0]).toFile();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testJar.exists(), "testJar.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"Missing TestHelloV2 jar!", Prettifier$.MODULE$.default(), new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |import java.nio.file.Paths\n        |def classLoadingTest(x: Int): Int = {\n        |  val classloader =\n        |    Option(Thread.currentThread().getContextClassLoader).getOrElse(getClass.getClassLoader)\n        |  val cls = Class.forName(\"com.example.Hello$\", true, classloader)\n        |  val module = cls.getField(\"MODULE$\").get(null)\n        |  cls.getMethod(\"test\").invoke(module).asInstanceOf[Int]\n        |}\n        |val classLoaderUdf = udf(classLoadingTest _)\n        |\n        |val jarPath = Paths.get(\"" + testJar.toString() + "\").toUri\n        |spark.addArtifact(jarPath)\n        |\n        |spark.range(5).select(classLoaderUdf(col(\"id\"))).as[Int].collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[Int] = Array(2, 2, 2, 2, 2)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("External JAR", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MavenUtils.MavenCoordinate main = new MavenUtils.MavenCoordinate("my.great.lib", "mylib", "0.1");
            IvyTestUtils$.MODULE$.withRepository(main, (Option)None$.MODULE$, (Option)None$.MODULE$, IvyTestUtils$.MODULE$.withRepository$default$4(), IvyTestUtils$.MODULE$.withRepository$default$5(), IvyTestUtils$.MODULE$.withRepository$default$6(), IvyTestUtils$.MODULE$.withRepository$default$7(), (Function1 & Serializable)repo -> {
                ReplE2ESuite.$anonfun$new$8(this, repo);
                return BoxedUnit.UNIT;
            });
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("Java UDF", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.sql.api.java._\n        |import org.apache.spark.sql.types.LongType\n        |\n        |val javaUdf = udf(new UDF1[Long, Long] {\n        |  override def call(num: Long): Long = num * num + 25L\n        |}, LongType).asNondeterministic()\n        |spark.range(5).select(javaUdf(col(\"id\"))).as[Long].collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[Long] = Array(25L, 26L, 29L, 34L, 41L)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("Java UDF Registration", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.sql.api.java._\n        |import org.apache.spark.sql.types.LongType\n        |\n        |spark.udf.register(\"javaUdf\", new UDF1[Long, Long] {\n        |  override def call(num: Long): Long = num * num * num + 250L\n        |}, LongType)\n        |spark.sql(\"select javaUdf(id) from range(5)\").as[Long].collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[Long] = Array(250L, 251L, 258L, 277L, 314L)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("UDF Registration", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class A(x: Int) { def get = x * 100 }\n        |val myUdf = udf((x: Int) => new A(x).get)\n        |spark.udf.register(\"dummyUdf\", myUdf)\n        |spark.sql(\"select dummyUdf(id) from range(5)\").as[Long].collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[Long] = Array(0L, 100L, 200L, 300L, 400L)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("UDF closure registration", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class A(x: Int) { def get = x * 15 }\n        |spark.udf.register(\"directUdf\", (x: Int) => new A(x).get)\n        |spark.sql(\"select directUdf(id) from range(5)\").as[Long].collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[Long] = Array(0L, 15L, 30L, 45L, 60L)", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("call_udf", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |val df = Seq((\"id1\", 1), (\"id2\", 4), (\"id3\", 5)).toDF(\"id\", \"value\")\n        |spark.udf.register(\"simpleUDF\", (v: Int) => v * v)\n        |df.select($\"id\", call_udf(\"simpleUDF\", $\"value\")).collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[org.apache.spark.sql.Row] = Array([id1,1], [id2,16], [id3,25])", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        this.test("call_function", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |val df = Seq((\"id1\", 1), (\"id2\", 4), (\"id3\", 5)).toDF(\"id\", \"value\")\n        |spark.udf.register(\"simpleUDF\", (v: Int) => v * v)\n        |df.select($\"id\", call_function(\"simpleUDF\", $\"value\")).collect()\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("Array[org.apache.spark.sql.Row] = Array([id1,1], [id2,16], [id3,25])", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        this.test("Single Cell Compilation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class C1(value: Int)\n        |case class C2(value: Int)\n        |val h1 = classOf[C1].getDeclaringClass\n        |val h2 = classOf[C2].getDeclaringClass\n        |val same = h1 == h2\n        |"));
            this.assertContains("same: Boolean = false", this.runCommandsInShell(input));
            this.assertContains("same: Boolean = true", this.runCommandsUsingSingleCellInShell(input));
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        this.test("Local relation containing REPL generated class", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class MyTestClass(value: Int)\n        |val data = (0 to 10).map(MyTestClass)\n        |spark.createDataset(data).map(mtc => mtc.value).select(sum($\"value\")).as[Long].head\n        |"));
            String expected = "Long = 55L";
            this.assertContains(expected, this.runCommandsInShell(input));
            this.assertContains(expected, this.runCommandsUsingSingleCellInShell(input));
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        this.test("Collect REPL generated class", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class MyTestClass(value: Int)\n        |spark.range(4).\n        |  filter($\"id\" % 2 === 1).\n        |  select($\"id\".cast(\"int\").as(\"value\")).\n        |  as[MyTestClass].\n        |  collect().\n        |  map(mtc => s\"MyTestClass(${mtc.value})\").\n        |  mkString(\"[\", \", \", \"]\")\n          "));
            String expected = "String = \"[MyTestClass(1), MyTestClass(3)]\"";
            this.assertContains(expected, this.runCommandsInShell(input));
            this.assertContains(expected, this.runCommandsUsingSingleCellInShell(input));
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        this.test("REPL class in encoder", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class MyTestClass(value: Int)\n        |spark.range(3).\n        |  select(col(\"id\").cast(\"int\").as(\"value\")).\n        |  as[MyTestClass].\n        |  map(mtc => mtc.value).\n        |  collect()\n      "));
            String expected = "Array[Int] = Array(0, 1, 2)";
            this.assertContains(expected, this.runCommandsInShell(input));
            this.assertContains(expected, this.runCommandsUsingSingleCellInShell(input));
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("REPL class in UDF", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class MyTestClass(value: Int)\n        |spark.range(2).\n        |  map(i => MyTestClass(i.toInt)).\n        |  collect().\n        |  map(mtc => s\"MyTestClass(${mtc.value})\").\n        |  mkString(\"[\", \", \", \"]\")\n      "));
            String expected = "String = \"[MyTestClass(0), MyTestClass(1)]\"";
            this.assertContains(expected, this.runCommandsInShell(input));
            this.assertContains(expected, this.runCommandsUsingSingleCellInShell(input));
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("streaming works with REPL generated code", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |val add1 = udf((i: Long) => i + 1)\n        |val query = {\n        |  spark.readStream\n        |      .format(\"rate\")\n        |      .option(\"rowsPerSecond\", \"10\")\n        |      .option(\"numPartitions\", \"1\")\n        |      .load()\n        |      .withColumn(\"value\", add1($\"value\"))\n        |      .writeStream\n        |      .format(\"memory\")\n        |      .queryName(\"my_sink\")\n        |      .start()\n        |}\n        |var progress = query.lastProgress\n        |while (query.isActive && (progress == null || progress.numInputRows == 0)) {\n        |  query.awaitTermination(100)\n        |  progress = query.lastProgress\n        |}\n        |val noException = query.exception.isEmpty\n        |query.stop()\n        |"));
            String output = this.runCommandsInShell(input);
            this.assertContains("noException: Boolean = true", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        this.test("broadcast works with REPL generated code", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |val add1 = udf((i: Long) => i + 1)\n        |val tableA = spark.range(2).alias(\"a\")\n        |val tableB = broadcast(spark.range(2).select(add1(col(\"id\")).alias(\"id\"))).alias(\"b\")\n        |tableA.join(tableB).\n        |  where(col(\"a.id\")===col(\"b.id\")).\n        |  select(col(\"a.id\").alias(\"a_id\"), col(\"b.id\").alias(\"b_id\")).\n        |  collect().\n        |  mkString(\"[\", \", \", \"]\")\n        |"));
            String output = this.runCommandsInShell(input);
            this.assertContains("String = \"[[1,1]]\"", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        this.test("closure cleaner", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class NonSerializable(val id: Int = -1) { }\n        |\n        |{\n        |  val x = 100\n        |  val y = new NonSerializable\n        |}\n        |\n        |val t = 200\n        |\n        |{\n        |  def foo(): Int = { x }\n        |  def bar(): Int = { y.id }\n        |  val z = new NonSerializable\n        |}\n        |\n        |{\n        |  val myLambda = (a: Int) => a + t + foo()\n        |  val myUdf = udf(myLambda)\n        |}\n        |\n        |spark.range(0, 10).\n        |  withColumn(\"result\", myUdf(col(\"id\"))).\n        |  agg(sum(\"result\")).\n        |  collect()(0)(0).asInstanceOf[Long]\n        |"));
            String output = this.runCommandsInShell(input);
            this.assertContains(": Long = 3045", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("closure cleaner with function", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class NonSerializable(val id: Int = -1) { }\n        |\n        |{\n        |  val x = 100\n        |  val y = new NonSerializable\n        |}\n        |\n        |{\n        |  def foo(): Int = { x }\n        |  def bar(): Int = { y.id }\n        |  val z = new NonSerializable\n        |}\n        |\n        |def example() = {\n        |  val myLambda = (a: Int) => a + foo()\n        |  val myUdf = udf(myLambda)\n        |  spark.range(0, 10).\n        |    withColumn(\"result\", myUdf(col(\"id\"))).\n        |    agg(sum(\"result\")).\n        |    collect()(0)(0).asInstanceOf[Long]\n        |}\n        |\n        |example()\n        |"));
            String output = this.runCommandsInShell(input);
            this.assertContains(": Long = 1045", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        this.test("closure cleaner nested", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class NonSerializable(val id: Int = -1) { }\n        |\n        |{\n        |  val x = 100\n        |  val y = new NonSerializable\n        |}\n        |\n        |{\n        |  def foo(): Int = { x }\n        |  def bar(): Int = { y.id }\n        |  val z = new NonSerializable\n        |}\n        |\n        |val example = () => {\n        |  val nested = () => {\n        |    val myLambda = (a: Int) => a + foo()\n        |    val myUdf = udf(myLambda)\n        |    spark.range(0, 10).\n        |      withColumn(\"result\", myUdf(col(\"id\"))).\n        |      agg(sum(\"result\")).\n        |      collect()(0)(0).asInstanceOf[Long]\n        |  }\n        |  nested()\n        |}\n        |example()\n        |"));
            String output = this.runCommandsInShell(input);
            this.assertContains(": Long = 1045", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        this.test("closure cleaner with enclosing lambdas", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class NonSerializable(val id: Int = -1) { }\n        |\n        |{\n        |  val x = 100\n        |  val y = new NonSerializable\n        |}\n        |\n        |val z = new NonSerializable\n        |\n        |spark.range(0, 10).\n        |// for this call UdfUtils will create a new lambda and this lambda becomes enclosing\n        |  map(i => i + x).\n        |  agg(sum(\"value\")).\n        |  collect()(0)(0).asInstanceOf[Long]\n        |"));
            String output = this.runCommandsInShell(input);
            this.assertContains(": Long = 1045", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
        this.test("closure cleaner cleans capturing class", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class NonSerializable(val id: Int = -1) { }\n        |\n        |{\n        |  val x = 100\n        |  val y = new NonSerializable\n        |}\n        |\n        |class Test extends Serializable {\n        |  // capturing class is cmd$Helper$Test\n        |  val myUdf = udf((i: Int) => i + x)\n        |  val z = new NonSerializable\n        |  val res = spark.range(0, 10).\n        |    withColumn(\"result\", myUdf(col(\"id\"))).\n        |    agg(sum(\"result\")).\n        |    collect()(0)(0).asInstanceOf[Long]\n        |}\n        |(new Test()).res\n        |"));
            String output = this.runCommandsInShell(input);
            this.assertContains(": Long = 1045", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        this.test("Simple configuration set in startup", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String input = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |spark.conf.get(\"spark.sql.abc\")\n      "));
            String output = this.runCommandsInShell(input);
            this.assertContains("abc", output);
        }, new Position("ReplE2ESuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
        Statics.releaseFence();
    }
}

