/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkException;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalog.CatalogMetadata;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.connect.CatalogSuite$;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.sql.connect.test.RemoteSparkSession;
import org.apache.spark.sql.connect.test.SQLHelper;
import org.apache.spark.sql.connect.test.SQLHelper$testImplicits$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u001d2AAA\u0002\u0001\u001d!)1\u0005\u0001C\u0001I\ta1)\u0019;bY><7+^5uK*\u0011A!B\u0001\bG>tg.Z2u\u0015\t1q!A\u0002tc2T!\u0001C\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Y\u0011AB1qC\u000eDWMC\u0001\r\u0003\ry'oZ\u0002\u0001'\u0015\u0001qbF\u000f!!\t\u0001R#D\u0001\u0012\u0015\t\u00112#\u0001\u0005gk:\u001cX/\u001b;f\u0015\t!2\"A\u0005tG\u0006d\u0017\r^3ti&\u0011a#\u0005\u0002\f\u0003:Lh)\u001e8Tk&$X\r\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0007\u0005!A/Z:u\u0013\ta\u0012DA\bD_:tWm\u0019;Gk:\u001cV/\u001b;f!\tAb$\u0003\u0002 3\t\u0011\"+Z7pi\u0016\u001c\u0006/\u0019:l'\u0016\u001c8/[8o!\tA\u0012%\u0003\u0002#3\tI1+\u0015'IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003\r\u0001")
public class CatalogSuite
extends AnyFunSuite
implements ConnectFunSuite,
RemoteSparkSession,
SQLHelper {
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLHelper$testImplicits$ testImplicits$module;
    private SparkSession spark;
    private int serverPort;
    private boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile byte bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLHelper.withTempDatabase$(this, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLHelper.withTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLHelper.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLHelper.withView$(this, viewNames, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$ignore(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.ignore$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void beforeAll() {
        RemoteSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        RemoteSparkSession.afterAll$(this);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        RemoteSparkSession.test$(this, testName, testTags, testFun, pos);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        CatalogSuite catalogSuite = this;
        synchronized (catalogSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sql = SQLHelper.sql$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sql$lzycompute();
        }
        return this.sql;
    }

    @Override
    public SQLHelper$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private int serverPort$lzycompute() {
        CatalogSuite catalogSuite = this;
        synchronized (catalogSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.serverPort = RemoteSparkSession.serverPort$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.serverPort;
    }

    @Override
    public int serverPort() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.serverPort$lzycompute();
        }
        return this.serverPort;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        CatalogSuite catalogSuite = this;
        synchronized (catalogSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLHelper$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(CatalogSuite $this, String currentDb$1, String db) {
        try {
            String message;
            Database[] databasesWithPattern;
            Database[] dbs;
            $this.spark().catalog().setCurrentDatabase(db);
            String $org_scalatest_assert_macro_left = $this.spark().catalog().currentDatabase();
            String $org_scalatest_assert_macro_right = db;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            Database[] $org_scalatest_assert_macro_left2 = dbs = (Database[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listDatabases().collect()), (Function1 & Serializable)x$1 -> x$1.name(), (Ordering)Ordering.String$.MODULE$);
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])dbs), (Function1 & Serializable)x$2 -> x$2.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{db, currentDb$1})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Database](dbs).map[String](((x$2: org.apache.spark.sql.catalog.Database) => x$2.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](db, currentDb)((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])dbs), (Function1 & Serializable)x$3 -> x$3.catalog(), ClassTag$.MODULE$.apply(String.class))))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog"})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Database](dbs).map[String](((x$3: org.apache.spark.sql.catalog.Database) => x$3.catalog))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).distinct).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"spark_catalog\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            Database[] $org_scalatest_assert_macro_left3 = databasesWithPattern = (Database[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listDatabases("def*").collect()), (Function1 & Serializable)x$4 -> x$4.name(), (Ordering)Ordering.String$.MODULE$);
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])databasesWithPattern), (Function1 & Serializable)x$5 -> x$5.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{currentDb$1})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Database](databasesWithPattern).map[String](((x$5: org.apache.spark.sql.catalog.Database) => x$5.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](currentDb)((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            Database[] $org_scalatest_assert_macro_left4 = databasesWithPattern = (Database[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listDatabases("def2*").collect()), (Function1 & Serializable)x$6 -> x$6.name(), (Ordering)Ordering.String$.MODULE$);
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            Database database = $this.spark().catalog().getDatabase(db);
            String $org_scalatest_assert_macro_left5 = database.name();
            String $org_scalatest_assert_macro_right5 = db;
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            String $org_scalatest_assert_macro_left6 = message = ((AnalysisException)$this.intercept((Function0 & Serializable)() -> $this.spark().catalog().getDatabase("notExists"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50))).getMessage();
            String $org_scalatest_assert_macro_right6 = "SCHEMA_NOT_FOUND";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().databaseExists(db), "CatalogSuite.this.spark.catalog.databaseExists(db)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().databaseExists("notExists"), "CatalogSuite.this.spark.catalog.databaseExists(\"notExists\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }
        catch (Throwable throwable) {
            $this.spark().catalog().setCurrentDatabase(currentDb$1);
            String $org_scalatest_assert_macro_left = $this.spark().catalog().currentDatabase();
            String $org_scalatest_assert_macro_right = currentDb$1;
            String string = $org_scalatest_assert_macro_left;
            String string5 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string5) : string5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            throw throwable;
        }
        $this.spark().catalog().setCurrentDatabase(currentDb$1);
        String $org_scalatest_assert_macro_left = $this.spark().catalog().currentDatabase();
        String $org_scalatest_assert_macro_right = currentDb$1;
        String string = $org_scalatest_assert_macro_left;
        String string6 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
    }

    public static final /* synthetic */ void $anonfun$new$19(CatalogSuite $this, SparkSession session$1, String orcTableName$1, File table2Dir) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_connect_CatalogSuite$$typecreator18$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_connect_CatalogSuite$$typecreator18$1(CatalogSuite $outer) {
            }
        }
        Dataset df2 = session$1.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Alice", (List)new .colon.colon((Object)"Nico", (List)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Alice", (List)Nil$.MODULE$))))).zipWithIndex(), session$1.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_CatalogSuite$$typecreator18$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}));
        df2.write().orc(table2Dir.getPath());
        $this.spark().catalog().createTable(orcTableName$1, table2Dir.getPath(), "orc").collect();
        Table orcTable = $this.spark().catalog().getTable(orcTableName$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(orcTable.isTemporary(), "orcTable.isTemporary", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        String $org_scalatest_assert_macro_left = orcTable.name();
        String $org_scalatest_assert_macro_right = orcTableName$1;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        String $org_scalatest_assert_macro_left2 = orcTable.tableType();
        String $org_scalatest_assert_macro_right2 = "EXTERNAL";
        String string3 = $org_scalatest_assert_macro_left2;
        String string4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        Set $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listColumns(orcTableName$1).collect()), (Function1 & Serializable)x$10 -> x$10.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}));
        Set set = $org_scalatest_assert_macro_left3;
        Set set2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }

    public static final /* synthetic */ void $anonfun$new$17(CatalogSuite $this, String parquetTableName$1, String orcTableName$1, String jsonTableName$1, File table1Dir) {
        SparkSession session = $this.spark();
        Dataset df1 = session.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Alice", (List)new .colon.colon((Object)"Nico", (List)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Alice", (List)Nil$.MODULE$))))), session.implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}));
        df1.write().parquet(table1Dir.getPath());
        $this.spark().catalog().createTable(parquetTableName$1, table1Dir.getPath()).collect();
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{orcTableName$1, jsonTableName$1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)table2Dir -> {
                CatalogSuite.$anonfun$new$19($this, session, orcTableName$1, table2Dir);
                return BoxedUnit.UNIT;
            });
            StructType schema = new StructType().add("id", (DataType)LongType$.MODULE$).add("a", (DataType)DoubleType$.MODULE$);
            $this.spark().catalog().createTable(jsonTableName$1, "json", schema, Predef$.MODULE$.Map().empty()).collect();
            Table jsonTable = $this.spark().catalog().getTable("default", jsonTableName$1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(jsonTable.isTemporary(), "jsonTable.isTemporary", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            String $org_scalatest_assert_macro_left = jsonTable.name();
            String $org_scalatest_assert_macro_right = jsonTableName$1;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            String $org_scalatest_assert_macro_left2 = jsonTable.tableType();
            String $org_scalatest_assert_macro_right2 = "MANAGED";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().tableExists(jsonTableName$1), "CatalogSuite.this.spark.catalog.tableExists(jsonTableName)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Set $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listTables().collect()), (Function1 & Serializable)x$11 -> x$11.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName$1, orcTableName$1, jsonTableName$1}));
            Set set = $org_scalatest_assert_macro_left3;
            Set set2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Set $org_scalatest_assert_macro_left4 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listTables($this.spark().catalog().currentDatabase(), "par*").collect()), (Function1 & Serializable)x$12 -> x$12.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName$1}));
            Set set3 = $org_scalatest_assert_macro_left4;
            Set set4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            Object $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listTables($this.spark().catalog().currentDatabase(), "txt*").collect());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left5), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().tableExists(parquetTableName$1), "CatalogSuite.this.spark.catalog.tableExists(parquetTableName)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().tableExists(orcTableName$1), "CatalogSuite.this.spark.catalog.tableExists(orcTableName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().tableExists(jsonTableName$1), "CatalogSuite.this.spark.catalog.tableExists(jsonTableName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        Set $org_scalatest_assert_macro_left = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listTables().collect()), (Function1 & Serializable)x$13 -> x$13.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName$1}));
        Set set = $org_scalatest_assert_macro_left;
        Set set2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }

    public static final /* synthetic */ void $anonfun$new$27(CatalogSuite $this, String parquetTableName$2, File table1Dir) {
        SparkSession session = $this.spark();
        Dataset df1 = session.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Alice", (List)new .colon.colon((Object)"Nico", (List)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Alice", (List)Nil$.MODULE$))))), session.implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}));
        df1.write().parquet(table1Dir.getPath());
        $this.spark().catalog().createTable(parquetTableName$2, table1Dir.getPath()).collect();
        $this.spark().catalog().cacheTable(parquetTableName$2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(parquetTableName$2), "CatalogSuite.this.spark.catalog.isCached(parquetTableName)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        $this.spark().catalog().uncacheTable(parquetTableName$2);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(parquetTableName$2), "CatalogSuite.this.spark.catalog.isCached(parquetTableName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        $this.spark().catalog().cacheTable(parquetTableName$2, StorageLevel$.MODULE$.MEMORY_ONLY());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(parquetTableName$2), "CatalogSuite.this.spark.catalog.isCached(parquetTableName)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        $this.spark().catalog().clearCache();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(parquetTableName$2), "CatalogSuite.this.spark.catalog.isCached(parquetTableName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
    }

    public static final /* synthetic */ boolean $anonfun$new$33(Function f) {
        String string = f.name();
        String string2 = "to_date";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$36(CatalogSuite $this, String tableName$1, File dir) {
        $this.spark().range(5L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as fieldOne", "id as partCol"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol"})).mode("overwrite").save(dir.getAbsolutePath());
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |create table " + tableName$1 + " (fieldOne long, partCol int)\n             |using parquet\n             |options (path \"" + dir.toURI() + "\")\n             |partitioned by (partCol)")));
        $this.spark().sql("show partitions " + tableName$1).count();
        long $org_scalatest_assert_macro_left = $this.spark().sql("select * from " + tableName$1).count();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        $this.spark().catalog().recoverPartitions(tableName$1);
        long $org_scalatest_assert_macro_left2 = $this.spark().sql("select * from " + tableName$1).count();
        int $org_scalatest_assert_macro_right2 = 5;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
    }

    public static final /* synthetic */ void $anonfun$new$38(CatalogSuite $this, File dir) {
        String tableName = "spark_catalog.default.my_table";
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               | CREATE TABLE " + tableName + "(col STRING) USING TEXT\n               | LOCATION '" + dir.getAbsolutePath() + "'\n               |")));
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + tableName + " SELECT 'abc'")));
                $this.spark().catalog().cacheTable(tableName);
                Row[] $org_scalatest_assert_macro_left = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
                FileUtils.deleteDirectory((File)dir);
                Row[] $org_scalatest_assert_macro_left2 = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
                $this.spark().catalog().refreshTable(tableName);
                Row[] $org_scalatest_assert_macro_left3 = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            }
            finally {
                $this.spark().catalog().clearCache();
            }
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(CatalogSuite $this, File dir) {
        String tableName = "spark_catalog.default.my_table";
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               | CREATE TABLE " + tableName + "(col STRING) USING TEXT\n               | LOCATION '" + dir.getAbsolutePath() + "'\n               |")));
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + tableName + " SELECT 'abc'")));
                $this.spark().catalog().cacheTable(tableName);
                Row[] $org_scalatest_assert_macro_left = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
                ((File)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])new File(dir.getAbsolutePath()).listFiles(new FilenameFilter(null){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".txt");
                    }
                })))).delete();
                Row[] $org_scalatest_assert_macro_left2 = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
                $this.spark().catalog().refreshByPath(dir.getAbsolutePath());
                Row[] $org_scalatest_assert_macro_left3 = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            }
            finally {
                $this.spark().catalog().clearCache();
            }
        });
    }

    public CatalogSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        RemoteSparkSession.$init$(this);
        SQLHelper.$init$(this);
        this.test("Database APIs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String currentDb;
            String $org_scalatest_assert_macro_left = currentDb = this.spark().catalog().currentDatabase();
            String $org_scalatest_assert_macro_right = "default";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable)db -> {
                CatalogSuite.$anonfun$new$2(this, currentDb, db);
                return BoxedUnit.UNIT;
            });
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("CatalogMetadata APIs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Assertion assertion;
            String currentCatalog;
            String $org_scalatest_assert_macro_left = currentCatalog = this.spark().catalog().currentCatalog();
            String $org_scalatest_assert_macro_right = "spark_catalog";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            try {
                CatalogMetadata[] catalogsWithPattern;
                CatalogMetadata[] catalogsAfterChange;
                CatalogMetadata[] catalogs;
                CatalogMetadata[] $org_scalatest_assert_macro_left2 = catalogs = (CatalogMetadata[])this.spark().catalog().listCatalogs().collect();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])catalogs), (Function1 & Serializable)x$7 -> x$7.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog"})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.CatalogMetadata](catalogs).map[String](((x$7: org.apache.spark.sql.catalog.CatalogMetadata) => x$7.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"spark_catalog\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
                SparkException exception = (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().catalog().setCurrentCatalog("notExists"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
                String $org_scalatest_assert_macro_left3 = exception.getCondition();
                String $org_scalatest_assert_macro_right3 = "CATALOG_NOT_FOUND";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                this.spark().catalog().setCurrentCatalog("testcat");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().currentCatalog().equals("testcat"), "CatalogSuite.this.spark.catalog.currentCatalog().equals(\"testcat\")", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                CatalogMetadata[] $org_scalatest_assert_macro_left4 = catalogsAfterChange = (CatalogMetadata[])this.spark().catalog().listCatalogs().collect();
                int $org_scalatest_assert_macro_right4 = 2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                Set $org_scalatest_assert_macro_left5 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])catalogsAfterChange), (Function1 & Serializable)x$8 -> x$8.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
                Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "spark_catalog"}));
                Set set = $org_scalatest_assert_macro_left5;
                Set set2 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
                CatalogMetadata[] $org_scalatest_assert_macro_left6 = catalogsWithPattern = (CatalogMetadata[])this.spark().catalog().listCatalogs("spark*").collect();
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])catalogsWithPattern), (Function1 & Serializable)x$9 -> x$9.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog"})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.CatalogMetadata](catalogsWithPattern).map[String](((x$9: org.apache.spark.sql.catalog.CatalogMetadata) => x$9.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"spark_catalog\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                CatalogMetadata[] $org_scalatest_assert_macro_left7 = catalogsWithPattern = (CatalogMetadata[])this.spark().catalog().listCatalogs("hive*").collect();
                int $org_scalatest_assert_macro_right7 = 0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            }
            catch (Throwable throwable) {
                this.spark().catalog().setCurrentCatalog(currentCatalog);
                String $org_scalatest_assert_macro_left8 = this.spark().catalog().currentCatalog();
                String $org_scalatest_assert_macro_right8 = "spark_catalog";
                String string5 = $org_scalatest_assert_macro_left8;
                String string6 = $org_scalatest_assert_macro_right8;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                throw throwable;
            }
            this.spark().catalog().setCurrentCatalog(currentCatalog);
            String $org_scalatest_assert_macro_left9 = this.spark().catalog().currentCatalog();
            String $org_scalatest_assert_macro_right9 = "spark_catalog";
            String string7 = $org_scalatest_assert_macro_left9;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            return assertion;
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("Table APIs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String message;
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.spark().catalog().listTables().collect());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            String parquetTableName = "parquet_table";
            String orcTableName = "orc_table";
            String jsonTableName = "json_table";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)table1Dir -> {
                CatalogSuite.$anonfun$new$17(this, parquetTableName, orcTableName, jsonTableName, table1Dir);
                return BoxedUnit.UNIT;
            }));
            String $org_scalatest_assert_macro_left2 = message = ((AnalysisException)this.intercept((Function0 & Serializable)() -> this.spark().catalog().getTable(parquetTableName), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145))).getMessage();
            String $org_scalatest_assert_macro_right = "TABLE_OR_VIEW_NOT_FOUND";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])this.spark().catalog().listTables().collect());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("Cache Table APIs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String parquetTableName = "parquet_table";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)table1Dir -> {
                CatalogSuite.$anonfun$new$27(this, parquetTableName, table1Dir);
                return BoxedUnit.UNIT;
            }));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("TempView APIs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Assertion assertion;
            String viewName = "view1";
            String globalViewName = "g_view1";
            try {
                this.spark().range(100L).createTempView(viewName);
                Table view = this.spark().catalog().getTable(viewName);
                String $org_scalatest_assert_macro_left = view.name();
                String $org_scalatest_assert_macro_right = viewName;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(view.isTemporary(), "view.isTemporary", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
                String $org_scalatest_assert_macro_left2 = view.tableType();
                String $org_scalatest_assert_macro_right2 = "TEMPORARY";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
                this.spark().range(100L).createGlobalTempView(globalViewName);
                Table globalView = this.spark().catalog().getTable("global_temp." + globalViewName);
                String $org_scalatest_assert_macro_left3 = globalView.name();
                String $org_scalatest_assert_macro_right3 = globalViewName;
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(globalView.isTemporary(), "globalView.isTemporary", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                String $org_scalatest_assert_macro_left4 = globalView.tableType();
                String $org_scalatest_assert_macro_right4 = "TEMPORARY";
                String string7 = $org_scalatest_assert_macro_left4;
                String string8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            }
            finally {
                this.spark().catalog().dropTempView(viewName);
                this.spark().catalog().dropGlobalTempView(globalViewName);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().tableExists(viewName), "CatalogSuite.this.spark.catalog.tableExists(viewName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().tableExists(globalViewName), "CatalogSuite.this.spark.catalog.tableExists(globalViewName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            }
            return assertion;
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("Function API", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String message;
            String dbName = this.spark().catalog().currentDatabase();
            Function[] functions1 = (Function[])this.spark().catalog().listFunctions().collect();
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])functions1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            Function[] functions2 = (Function[])this.spark().catalog().listFunctions(dbName).collect();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])functions1), (Function1 & Serializable)x$14 -> x$14.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])functions2), (Function1 & Serializable)x$15 -> x$15.name(), ClassTag$.MODULE$.apply(String.class)))), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Function](functions1).map[String](((x$14: org.apache.spark.sql.catalog.Function) => x$14.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Function](functions2).map[String](((x$15: org.apache.spark.sql.catalog.Function) => x$15.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            String absFunctionName = "abs";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().functionExists(absFunctionName), "CatalogSuite.this.spark.catalog.functionExists(absFunctionName)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            String $org_scalatest_assert_macro_left2 = this.spark().catalog().getFunction(absFunctionName).name();
            String $org_scalatest_assert_macro_right = absFunctionName;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            String notExistsFunction = "notExists";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().functionExists(notExistsFunction), "CatalogSuite.this.spark.catalog.functionExists(notExistsFunction)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            String $org_scalatest_assert_macro_left3 = message = ((AnalysisException)this.intercept((Function0 & Serializable)() -> this.spark().catalog().getFunction(notExistsFunction), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211))).getMessage();
            String $org_scalatest_assert_macro_right2 = "UNRESOLVED_ROUTINE";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            Function[] functionsWithPattern1 = (Function[])this.spark().catalog().listFunctions(dbName, "to*").collect();
            Object $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])functionsWithPattern1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left4), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])functionsWithPattern1), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CatalogSuite.$anonfun$new$33(f))), "scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Function](functionsWithPattern1).exists(((f: org.apache.spark.sql.catalog.Function) => f.name.==(\"to_date\")))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            Function[] functionsWithPattern2 = (Function[])this.spark().catalog().listFunctions(dbName, "*not_existing_func*").collect();
            Object $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])functionsWithPattern2);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left5), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("recoverPartitions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "test";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                CatalogSuite.$anonfun$new$36(this, tableName, dir);
                return BoxedUnit.UNIT;
            }));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("refreshTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            CatalogSuite.$anonfun$new$38(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("refreshByPath", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            CatalogSuite.$anonfun$new$41(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        Statics.releaseFence();
    }
}

