/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import org.apache.spark.SparkException;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.SparkSession$;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.util.SparkSerDeUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u001d3A!\u0003\u0006\u0001+!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0013I\u0003BB\u001c\u0001A\u0003%!\u0006C\u00049\u0001\t\u0007I\u0011B\u0015\t\re\u0002\u0001\u0015!\u0003+\u0011\u001dQ\u0004A1A\u0005\n%Baa\u000f\u0001!\u0002\u0013Q\u0003\"\u0002\u001f\u0001\t\u0013i$!E*qCJ\\7+Z:tS>t7+^5uK*\u00111\u0002D\u0001\bG>tg.Z2u\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\r\u0001aC\b\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t\u0001BZ;ogVLG/\u001a\u0006\u00037I\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005uA\"aC!os\u001a+hnU;ji\u0016\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0006\u0002\tQ,7\u000f^\u0005\u0003G\u0001\u0012qbQ8o]\u0016\u001cGOR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u0003)\t\u0011cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\42+\u0005Q\u0003CA\u00165\u001d\ta#\u0007\u0005\u0002.a5\taF\u0003\u00020)\u00051AH]8pizR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\na\u0001\u0015:fI\u00164\u0017BA\u001b7\u0005\u0019\u0019FO]5oO*\u00111\u0007M\u0001\u0013G>tg.Z2uS>t7\u000b\u001e:j]\u001e\f\u0004%A\td_:tWm\u0019;j_:\u001cFO]5oOJ\n!cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\43A\u0005\t2m\u001c8oK\u000e$\u0018n\u001c8TiJLgnZ\u001a\u0002%\r|gN\\3di&|gn\u0015;sS:<7\u0007I\u0001\rG2|7/Z*fgNLwN\u001c\u000b\u0003}\t\u0003\"a\u0010!\u000e\u0003AJ!!\u0011\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0007\"\u0001\r\u0001R\u0001\bg\u0016\u001c8/[8o!\t9S)\u0003\u0002G\u0015\ta1\u000b]1sWN+7o]5p]\u0002")
public class SparkSessionSuite
extends AnyFunSuite
implements ConnectFunSuite {
    private final String connectionString1;
    private final String connectionString2;
    private final String connectionString3;

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private String connectionString1() {
        return this.connectionString1;
    }

    private String connectionString2() {
        return this.connectionString2;
    }

    private String connectionString3() {
        return this.connectionString3;
    }

    private void closeSession(org.apache.spark.sql.connect.SparkSession session) {
        session.releaseSessionOnClose_$eq(false);
        session.close();
    }

    public static final /* synthetic */ boolean $anonfun$new$11(Function1 block$1, Phaser phaser$1) {
        boolean bl;
        try {
            block$1.apply((Object)phaser$1);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                phaser$1.forceTermination();
                throw throwable2;
            }
            throw throwable;
        }
        return bl;
    }

    private static final Future execute$1(Function1 block, ExecutorService executor$1, Phaser phaser$1) {
        return executor$1.submit(() -> BoxesRunTime.boxToBoolean((boolean)SparkSessionSuite.$anonfun$new$11(block, phaser$1)));
    }

    public static final /* synthetic */ void $anonfun$new$12(SparkSessionSuite $this, org.apache.spark.sql.connect.SparkSession session1$1, org.apache.spark.sql.connect.SparkSession session2$1, Phaser phaser) {
        phaser.arriveAndAwaitAdvance();
        Option $org_scalatest_assert_macro_left = SparkSession$.MODULE$.getDefaultSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right = session1$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        Option $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.getActiveSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right2 = session2$1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        phaser.arriveAndAwaitAdvance();
        phaser.arriveAndAwaitAdvance();
        Option $org_scalatest_assert_macro_left3 = SparkSession$.MODULE$.getDefaultSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right3 = session1$1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        Option $org_scalatest_assert_macro_left4 = SparkSession$.MODULE$.getActiveSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right4 = session2$1;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        phaser.arriveAndAwaitAdvance();
        $this.closeSession(session1$1);
        phaser.arriveAndAwaitAdvance();
        Option $org_scalatest_assert_macro_left5 = SparkSession$.MODULE$.getDefaultSession();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        Option $org_scalatest_assert_macro_left6 = SparkSession$.MODULE$.getActiveSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right5 = session2$1;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        phaser.arriveAndAwaitAdvance();
        SparkSession$.MODULE$.clearActiveSession();
        phaser.arriveAndAwaitAdvance();
        Option $org_scalatest_assert_macro_left7 = SparkSession$.MODULE$.getDefaultSession();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        Option $org_scalatest_assert_macro_left8 = SparkSession$.MODULE$.getActiveSession();
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        phaser.arriveAndAwaitAdvance();
    }

    public static final /* synthetic */ void $anonfun$new$13(SparkSessionSuite $this, org.apache.spark.sql.connect.SparkSession session1$1, org.apache.spark.sql.connect.SparkSession session2$1, Phaser phaser) {
        phaser.arriveAndAwaitAdvance();
        Option $org_scalatest_assert_macro_left = SparkSession$.MODULE$.getDefaultSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right = session1$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        Option $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.getActiveSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right2 = session2$1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        phaser.arriveAndAwaitAdvance();
        SparkSession$.MODULE$.clearActiveSession();
        org.apache.spark.sql.connect.SparkSession internalSession = SparkSession$.MODULE$.builder().remote($this.connectionString3()).getOrCreate();
        phaser.arriveAndAwaitAdvance();
        Option $org_scalatest_assert_macro_left3 = SparkSession$.MODULE$.getDefaultSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right3 = session1$1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        Option $org_scalatest_assert_macro_left4 = SparkSession$.MODULE$.getActiveSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right4 = internalSession;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        phaser.arriveAndAwaitAdvance();
        phaser.arriveAndAwaitAdvance();
        Option $org_scalatest_assert_macro_left5 = SparkSession$.MODULE$.getDefaultSession();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        Option $org_scalatest_assert_macro_left6 = SparkSession$.MODULE$.getActiveSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right5 = internalSession;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        phaser.arriveAndAwaitAdvance();
        phaser.arriveAndAwaitAdvance();
        Option $org_scalatest_assert_macro_left7 = SparkSession$.MODULE$.getDefaultSession();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        Option $org_scalatest_assert_macro_left8 = SparkSession$.MODULE$.getActiveSession();
        org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right6 = internalSession;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left8.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        phaser.arriveAndAwaitAdvance();
        $this.closeSession(internalSession);
        Option $org_scalatest_assert_macro_left9 = SparkSession$.MODULE$.getActiveSession();
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
    }

    public SparkSessionSuite() {
        ConnectFunSuite.$init$(this);
        this.connectionString1 = "sc://test.it:17845";
        this.connectionString2 = "sc://test.me:14099";
        this.connectionString3 = "sc://doit:16845";
        this.test("default", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            org.apache.spark.sql.connect.SparkSession session = SparkSession$.MODULE$.builder().getOrCreate();
            String $org_scalatest_assert_macro_left = session.client().configuration().host();
            String $org_scalatest_assert_macro_right = "localhost";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            int $org_scalatest_assert_macro_left2 = session.client().configuration().port();
            int $org_scalatest_assert_macro_right2 = 15002;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            this.closeSession(session);
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("remote", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            org.apache.spark.sql.connect.SparkSession session = SparkSession$.MODULE$.builder().remote(this.connectionString2()).getOrCreate();
            String $org_scalatest_assert_macro_left = session.client().configuration().host();
            String $org_scalatest_assert_macro_right = "test.me";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            int $org_scalatest_assert_macro_left2 = session.client().configuration().port();
            int $org_scalatest_assert_macro_right2 = 14099;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            this.closeSession(session);
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("getOrCreate", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            org.apache.spark.sql.connect.SparkSession session1 = SparkSession$.MODULE$.builder().remote(this.connectionString1()).getOrCreate();
            org.apache.spark.sql.connect.SparkSession session2 = SparkSession$.MODULE$.builder().remote(this.connectionString1()).getOrCreate();
            try {
                org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_left = session1;
                org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right = session2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            }
            finally {
                this.closeSession(session1);
                this.closeSession(session2);
            }
            return assertion;
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("create", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            org.apache.spark.sql.connect.SparkSession session1 = SparkSession$.MODULE$.builder().remote(this.connectionString1()).create();
            org.apache.spark.sql.connect.SparkSession session2 = SparkSession$.MODULE$.builder().remote(this.connectionString1()).create();
            try {
                org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_left = session1;
                org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right = session2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "ne", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                SparkConnectClient.Configuration $org_scalatest_assert_macro_left2 = session1.client().configuration();
                SparkConnectClient.Configuration $org_scalatest_assert_macro_right2 = session2.client().configuration();
                SparkConnectClient.Configuration configuration = $org_scalatest_assert_macro_left2;
                SparkConnectClient.Configuration configuration2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(configuration != null ? !configuration.equals(configuration2) : configuration2 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            }
            finally {
                this.closeSession(session1);
                this.closeSession(session2);
            }
            return assertion;
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("newSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            org.apache.spark.sql.connect.SparkSession session1 = SparkSession$.MODULE$.builder().remote(this.connectionString3()).create();
            org.apache.spark.sql.connect.SparkSession session2 = session1.newSession();
            try {
                org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_left = session1;
                org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right = session2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "ne", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                SparkConnectClient.Configuration $org_scalatest_assert_macro_left2 = session1.client().configuration();
                SparkConnectClient.Configuration $org_scalatest_assert_macro_right2 = session2.client().configuration();
                SparkConnectClient.Configuration configuration = $org_scalatest_assert_macro_left2;
                SparkConnectClient.Configuration configuration2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(configuration != null ? !configuration.equals(configuration2) : configuration2 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            }
            finally {
                this.closeSession(session1);
                this.closeSession(session2);
            }
            return assertion;
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("Custom Interceptor", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            org.apache.spark.sql.connect.SparkSession session = SparkSession$.MODULE$.builder().interceptor(new ClientInterceptor(null){

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                    throw new RuntimeException("Blocked");
                }
            }).create();
            this.assertThrows((Function0)(JFunction0.mcJ.sp & Serializable)() -> session.range(10L).count(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            this.closeSession(session);
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Default/Active session", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession$.MODULE$.clearDefaultSession();
            SparkSession$.MODULE$.clearActiveSession();
            Option $org_scalatest_assert_macro_left = SparkSession$.MODULE$.getDefaultSession();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Option $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.getActiveSession();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            this.intercept((Function0 & Serializable)() -> SparkSession$.MODULE$.active(), ClassTag$.MODULE$.apply(SparkException.class), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            org.apache.spark.sql.connect.SparkSession session1 = SparkSession$.MODULE$.builder().remote(this.connectionString1()).getOrCreate();
            Option $org_scalatest_assert_macro_left3 = SparkSession$.MODULE$.getDefaultSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right = session1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            Option $org_scalatest_assert_macro_left4 = SparkSession$.MODULE$.getActiveSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right2 = session1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_left5 = SparkSession$.MODULE$.active();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right3 = session1;
            org.apache.spark.sql.connect.SparkSession sparkSession = $org_scalatest_assert_macro_left5;
            org.apache.spark.sql.connect.SparkSession sparkSession2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            org.apache.spark.sql.connect.SparkSession session2 = SparkSession$.MODULE$.builder().remote(this.connectionString2()).create();
            Option $org_scalatest_assert_macro_left6 = SparkSession$.MODULE$.getDefaultSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right4 = session1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            Option $org_scalatest_assert_macro_left7 = SparkSession$.MODULE$.getActiveSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right5 = session1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            SparkSession$.MODULE$.setActiveSession((SparkSession)session2);
            Option $org_scalatest_assert_macro_left8 = SparkSession$.MODULE$.getDefaultSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right6 = session1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left8.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            Option $org_scalatest_assert_macro_left9 = SparkSession$.MODULE$.getActiveSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right7 = session2;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left9.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            SparkSession$.MODULE$.clearDefaultSession();
            Option $org_scalatest_assert_macro_left10 = SparkSession$.MODULE$.getDefaultSession();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            SparkSession$.MODULE$.clearActiveSession();
            Option $org_scalatest_assert_macro_left11 = SparkSession$.MODULE$.getDefaultSession();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            SparkSession$.MODULE$.setActiveSession((SparkSession)session1);
            SparkSession$.MODULE$.setDefaultSession((SparkSession)session2);
            Option $org_scalatest_assert_macro_left12 = SparkSession$.MODULE$.getDefaultSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right8 = session2;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left12.contains((Object)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Option $org_scalatest_assert_macro_left13 = SparkSession$.MODULE$.getActiveSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right9 = session1;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left13.contains((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            this.closeSession(session1);
            Option $org_scalatest_assert_macro_left14 = SparkSession$.MODULE$.getDefaultSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right10 = session2;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Option $org_scalatest_assert_macro_left15 = SparkSession$.MODULE$.getActiveSession();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left15, "isEmpty", $org_scalatest_assert_macro_left15.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            this.closeSession(session2);
            Option $org_scalatest_assert_macro_left16 = SparkSession$.MODULE$.getDefaultSession();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left16, "isEmpty", $org_scalatest_assert_macro_left16.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Option $org_scalatest_assert_macro_left17 = SparkSession$.MODULE$.getActiveSession();
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left17, "isEmpty", $org_scalatest_assert_macro_left17.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("active session in multiple threads", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SparkSession$.MODULE$.clearDefaultSession();
            SparkSession$.MODULE$.clearActiveSession();
            org.apache.spark.sql.connect.SparkSession session1 = SparkSession$.MODULE$.builder().remote(this.connectionString1()).create();
            org.apache.spark.sql.connect.SparkSession session2 = SparkSession$.MODULE$.builder().remote(this.connectionString1()).create();
            SparkSession$.MODULE$.setActiveSession((SparkSession)session2);
            Option $org_scalatest_assert_macro_left = SparkSession$.MODULE$.getDefaultSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right = session1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            Option $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.getActiveSession();
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right2 = session2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            Phaser phaser2 = new Phaser(2);
            ExecutorService executor = Executors.newFixedThreadPool(2);
            try {
                Future script1 = SparkSessionSuite.execute$1((Function1 & Serializable)phaser -> {
                    SparkSessionSuite.$anonfun$new$12(this, session1, session2, phaser);
                    return BoxedUnit.UNIT;
                }, executor, phaser2);
                Future script2 = SparkSessionSuite.execute$1((Function1 & Serializable)phaser -> {
                    SparkSessionSuite.$anonfun$new$13(this, session1, session2, phaser);
                    return BoxedUnit.UNIT;
                }, executor, phaser2);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean(script1.get()), "script1.get()", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean(script2.get()), "script2.get()", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
                Option $org_scalatest_assert_macro_left3 = SparkSession$.MODULE$.getActiveSession();
                org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_right3 = session2;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
                this.closeSession(session2);
                Option $org_scalatest_assert_macro_left4 = SparkSession$.MODULE$.getActiveSession();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            }
            finally {
                executor.shutdown();
            }
            return assertion;
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("deprecated methods", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            org.apache.spark.sql.connect.SparkSession session = SparkSession$.MODULE$.builder().master("yayay").appName("bob").enableHiveSupport().create();
            this.closeSession(session);
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("serialize as null", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            org.apache.spark.sql.connect.SparkSession session = SparkSession$.MODULE$.builder().create();
            byte[] bytes = SparkSerDeUtils$.MODULE$.serialize((Object)session);
            org.apache.spark.sql.connect.SparkSession $org_scalatest_assert_macro_left = (org.apache.spark.sql.connect.SparkSession)SparkSerDeUtils$.MODULE$.deserialize(bytes);
            Object $org_scalatest_assert_macro_right = null;
            org.apache.spark.sql.connect.SparkSession sparkSession = $org_scalatest_assert_macro_left;
            Object var5_4 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(sparkSession != null ? !sparkSession.equals(var5_4) : var5_4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        }, new Position("SparkSessionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
    }
}

