/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.ForwardingChannelBuilder2;
import io.grpc.ForwardingServerBuilder;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Artifact;
import org.apache.spark.sql.Artifact$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.connect.client.ArtifactManager;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.CustomSparkConnectStub;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.RetryPolicy$;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectStubState;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.util.IvyTestUtils$;
import org.apache.spark.util.MavenUtils;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\u0014)\u0001UBQ\u0001\u0013\u0001\u0005\u0002%C\u0011\"\u000b\u0001A\u0002\u0003\u0007I\u0011\u0002'\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0013\t\u0006\"\u0003.\u0001\u0001\u0004\u0005\t\u0015)\u0003N\u0011%Y\u0006\u00011AA\u0002\u0013%A\fC\u0005a\u0001\u0001\u0007\t\u0019!C\u0005C\"I1\r\u0001a\u0001\u0002\u0003\u0006K!\u0018\u0005\nI\u0002\u0001\r\u00111A\u0005\n\u0015D\u0011B\u001c\u0001A\u0002\u0003\u0007I\u0011B8\t\u0013E\u0004\u0001\u0019!A!B\u00131\u0007\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0003t\u0011%9\b\u00011AA\u0002\u0013%\u0001\u0010C\u0005{\u0001\u0001\u0007\t\u0011)Q\u0005i\"I1\u0010\u0001a\u0001\u0002\u0004%I\u0001 \u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0001\u0003\u0006\u0002\b\u0001\u0001\r\u0011!Q!\nuD1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\f!Y\u00111\u0003\u0001A\u0002\u0003\u0007I\u0011BA\u000b\u0011-\tI\u0002\u0001a\u0001\u0002\u0003\u0006K!!\u0004\t\u0017\u0005m\u0001\u00011AA\u0002\u0013%\u0011Q\u0004\u0005\f\u0003K\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0003C\u0006\u0002,\u0001\u0001\r\u0011!Q!\n\u0005}\u0001bCA\u0017\u0001\u0001\u0007\t\u0019!C\u0005\u0003_A1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002:!Y\u0011Q\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0019\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!a\u0011\u0001\t\u0013\t\t\u0005C\u0004\u0002F\u0001!\t%!\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002B!I\u0011\u0011\n\u0001C\u0002\u0013%\u00111\n\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002N!9\u0011Q\u000b\u0001\u0005\u0012\u0005]\u0003bBA7\u0001\u0011E\u0011q\u000b\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!a.\u0001\t\u0013\tI\fC\u0004\u0002P\u0002!I!!5\t\u000f\u0005U\b\u0001\"\u0003\u0002x\ni\u0011I\u001d;jM\u0006\u001cGoU;ji\u0016T!!\u000b\u0016\u0002\r\rd\u0017.\u001a8u\u0015\tYC&A\u0004d_:tWm\u0019;\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011d\b\u0012\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\n\u0001BZ;ogVLG/\u001a\u0006\u0003wI\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005uB$aC!os\u001a+hnU;ji\u0016\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0016\u0002\tQ,7\u000f^\u0005\u0003\u0007\u0002\u0013qbQ8o]\u0016\u001cGOR;o'VLG/\u001a\t\u0003\u000b\u001ak\u0011AO\u0005\u0003\u000fj\u0012!CQ3g_J,\u0017I\u001c3BMR,'/R1dQ\u00061A(\u001b8jiz\"\u0012A\u0013\t\u0003\u0017\u0002i\u0011\u0001K\u000b\u0002\u001bB\u00111JT\u0005\u0003\u001f\"\u0012!c\u00159be.\u001cuN\u001c8fGR\u001cE.[3oi\u0006Q1\r\\5f]R|F%Z9\u0015\u0005IC\u0006CA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&\u0001B+oSRDq!W\u0002\u0002\u0002\u0003\u0007Q*A\u0002yIE\nqa\u00197jK:$\b%A\u0004tKJ4\u0018nY3\u0016\u0003u\u0003\"a\u00130\n\u0005}C#\u0001\u0007#v[6L8\u000b]1sW\u000e{gN\\3diN+'O^5dK\u0006Y1/\u001a:wS\u000e,w\fJ3r)\t\u0011&\rC\u0004Z\r\u0005\u0005\t\u0019A/\u0002\u0011M,'O^5dK\u0002\naa]3sm\u0016\u0014X#\u00014\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001B4sa\u000eT\u0011a[\u0001\u0003S>L!!\u001c5\u0003\rM+'O^3s\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0003%BDq!W\u0005\u0002\u0002\u0003\u0007a-A\u0004tKJ4XM\u001d\u0011\u0002\u001f\u0005\u0014H/\u001b4bGRl\u0015M\\1hKJ,\u0012\u0001\u001e\t\u0003\u0017VL!A\u001e\u0015\u0003\u001f\u0005\u0013H/\u001b4bGRl\u0015M\\1hKJ\f1#\u0019:uS\u001a\f7\r^'b]\u0006<WM]0%KF$\"AU=\t\u000fec\u0011\u0011!a\u0001i\u0006\u0001\u0012M\u001d;jM\u0006\u001cG/T1oC\u001e,'\u000fI\u0001\bG\"\fgN\\3m+\u0005i\bCA4\u007f\u0013\ty\bN\u0001\bNC:\fw-\u001a3DQ\u0006tg.\u001a7\u0002\u0017\rD\u0017M\u001c8fY~#S-\u001d\u000b\u0004%\u0006\u0015\u0001bB-\u0010\u0003\u0003\u0005\r!`\u0001\tG\"\fgN\\3mA\u0005)!m\u001d;vEV\u0011\u0011Q\u0002\t\u0004\u0017\u0006=\u0011bAA\tQ\tq2)^:u_6\u001c\u0006/\u0019:l\u0007>tg.Z2u\u00052|7m[5oON#XOY\u0001\nEN$XOY0%KF$2AUA\f\u0011!I&#!AA\u0002\u00055\u0011A\u00022tiV\u0014\u0007%\u0001\u0003tiV\u0014WCAA\u0010!\rY\u0015\u0011E\u0005\u0004\u0003GA#AF\"vgR|Wn\u00159be.\u001cuN\u001c8fGR\u001cF/\u001e2\u0002\u0011M$XOY0%KF$2AUA\u0015\u0011!IV#!AA\u0002\u0005}\u0011!B:uk\n\u0004\u0013!B:uCR,WCAA\u0019!\rY\u00151G\u0005\u0004\u0003kA#!F*qCJ\\7i\u001c8oK\u000e$8\u000b^;c'R\fG/Z\u0001\ngR\fG/Z0%KF$2AUA\u001e\u0011!I\u0006$!AA\u0002\u0005E\u0012AB:uCR,\u0007%\u0001\tti\u0006\u0014H\u000fR;n[f\u001cVM\u001d<feR\t!+A\u000bde\u0016\fG/Z!si&4\u0017m\u0019;NC:\fw-\u001a:\u0002\u0015\t,gm\u001c:f\u000b\u0006\u001c\u0007.A\u0005bMR,'/R1dQ\u0006Q1\tS+O\u0017~\u001b\u0016JW#\u0016\u0005\u00055\u0003cA*\u0002P%\u0019\u0011\u0011\u000b+\u0003\u0007%sG/A\u0006D\u0011Vs5jX*J5\u0016\u0003\u0013\u0001E1si&4\u0017m\u0019;GS2,\u0007+\u0019;i+\t\tI\u0006\u0005\u0003\u0002\\\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\t\u0019LG.\u001a\u0006\u0005\u0003G\n)'A\u0002oS>T!!a\u001a\u0002\t)\fg/Y\u0005\u0005\u0003W\niF\u0001\u0003QCRD\u0017aD1si&4\u0017m\u0019;De\u000e\u0004\u0016\r\u001e5\u0002\u0019\u001d,Go\u0011:d-\u0006dW/Z:\u0015\t\u0005M\u0014\u0011\u0013\t\u0007\u0003k\n))a#\u000f\t\u0005]\u0014\u0011\u0011\b\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011Q\u0010\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0016bAAB)\u00069\u0001/Y2lC\u001e,\u0017\u0002BAD\u0003\u0013\u00131aU3r\u0015\r\t\u0019\t\u0016\t\u0004'\u00065\u0015bAAH)\n!Aj\u001c8h\u0011\u001d\t\u0019J\ta\u0001\u00033\n\u0001BZ5mKB\u000bG\u000f[\u0001\u0017CN\u001cXM\u001d;GS2,G)\u0019;b\u000bF,\u0018\r\\5usR)!+!'\u00024\"9\u00111T\u0012A\u0002\u0005u\u0015!D1si&4\u0017m\u0019;DQVt7\u000e\u0005\u0003\u0002 \u00065f\u0002BAQ\u0003Sk!!a)\u000b\t\u0005\u0015\u0016qU\u0001\u0006aJ|Go\u001c\u0006\u0003W9JA!a+\u0002$\u0006\u0019\u0012\t\u001a3BeRLg-Y2ugJ+\u0017/^3ti&!\u0011qVAY\u00055\t%\u000f^5gC\u000e$8\t[;oW*!\u00111VAR\u0011\u001d\t)l\ta\u0001\u00033\n\u0011\u0002\\8dC2\u0004\u0016\r\u001e5\u0002/MLgn\u001a7f\u0007\",hn[!si&4\u0017m\u0019;UKN$Hc\u0001*\u0002<\"9\u0011Q\u0018\u0013A\u0002\u0005}\u0016\u0001\u00029bi\"\u0004B!!1\u0002J:!\u00111YAc!\r\tI\bV\u0005\u0004\u0003\u000f$\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002L\u00065'AB*ue&twMC\u0002\u0002HR\u000bQB]3bI:+\u0007\u0010^\"ik:\\G\u0003BAj\u0003O\u0004B!!6\u0002d6\u0011\u0011q\u001b\u0006\u0005\u00033\fY.\u0001\u0005qe>$xNY;g\u0015\u0011\ti.a8\u0002\r\u001d|wn\u001a7f\u0015\t\t\t/A\u0002d_6LA!!:\u0002X\nQ!)\u001f;f'R\u0014\u0018N\\4\t\u000f\u0005%X\u00051\u0001\u0002l\u0006\u0011\u0011N\u001c\t\u0005\u0003[\f\t0\u0004\u0002\u0002p*\u00191.!\u001a\n\t\u0005M\u0018q\u001e\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\u000bdQ\u0016\u001c7n\u00115v].\u001cH)\u0019;b\u0003:$7I]2\u0015\u000bI\u000bI0a?\t\u000f\u0005Me\u00051\u0001\u0002Z!9\u0011Q \u0014A\u0002\u0005}\u0018AB2ik:\\7\u000f\u0005\u0004\u0002v\u0005\u0015\u0015Q\u0014")
public class ArtifactSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private SparkConnectClient client;
    private DummySparkConnectService service;
    private Server server;
    private ArtifactManager artifactManager;
    private ManagedChannel channel;
    private CustomSparkConnectBlockingStub bstub;
    private CustomSparkConnectStub stub;
    private SparkConnectStubState state;
    private final int CHUNK_SIZE;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private SparkConnectClient client() {
        return this.client;
    }

    private void client_$eq(SparkConnectClient x$1) {
        this.client = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private ArtifactManager artifactManager() {
        return this.artifactManager;
    }

    private void artifactManager_$eq(ArtifactManager x$1) {
        this.artifactManager = x$1;
    }

    private ManagedChannel channel() {
        return this.channel;
    }

    private void channel_$eq(ManagedChannel x$1) {
        this.channel = x$1;
    }

    private CustomSparkConnectBlockingStub bstub() {
        return this.bstub;
    }

    private void bstub_$eq(CustomSparkConnectBlockingStub x$1) {
        this.bstub = x$1;
    }

    private CustomSparkConnectStub stub() {
        return this.stub;
    }

    private void stub_$eq(CustomSparkConnectStub x$1) {
        this.stub = x$1;
    }

    private SparkConnectStubState state() {
        return this.state;
    }

    private void state_$eq(SparkConnectStubState x$1) {
        this.state = x$1;
    }

    private void startDummyServer() {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((ForwardingServerBuilder)InProcessServerBuilder.forName((String)this.getClass().getName()).addService((BindableService)this.service())).build());
        this.server().start();
    }

    private void createArtifactManager() {
        this.channel_$eq(((ForwardingChannelBuilder2)InProcessChannelBuilder.forName((String)this.getClass().getName()).directExecutor()).build());
        this.state_$eq(new SparkConnectStubState(this.channel(), RetryPolicy$.MODULE$.defaultPolicies()));
        this.bstub_$eq(new CustomSparkConnectBlockingStub(this.channel(), this.state()));
        this.stub_$eq(new CustomSparkConnectStub(this.channel(), this.state()));
        this.artifactManager_$eq(new ArtifactManager(new SparkConnectClient.Configuration(SparkConnectClient.Configuration$.MODULE$.apply$default$1(), SparkConnectClient.Configuration$.MODULE$.apply$default$2(), SparkConnectClient.Configuration$.MODULE$.apply$default$3(), SparkConnectClient.Configuration$.MODULE$.apply$default$4(), SparkConnectClient.Configuration$.MODULE$.apply$default$5(), SparkConnectClient.Configuration$.MODULE$.apply$default$6(), SparkConnectClient.Configuration$.MODULE$.apply$default$7(), SparkConnectClient.Configuration$.MODULE$.apply$default$8(), SparkConnectClient.Configuration$.MODULE$.apply$default$9(), SparkConnectClient.Configuration$.MODULE$.apply$default$10(), SparkConnectClient.Configuration$.MODULE$.apply$default$11(), SparkConnectClient.Configuration$.MODULE$.apply$default$12(), SparkConnectClient.Configuration$.MODULE$.apply$default$13(), SparkConnectClient.Configuration$.MODULE$.apply$default$14()), "", this.bstub(), this.stub()));
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.startDummyServer();
        this.createArtifactManager();
        this.client_$eq(null);
    }

    public void afterEach() {
        if (this.server() != null) {
            this.server().shutdownNow();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "ArtifactSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        Object object = this.channel() != null ? this.channel().shutdownNow() : BoxedUnit.UNIT;
        if (this.client() != null) {
            this.client().shutdown();
            return;
        }
    }

    private int CHUNK_SIZE() {
        return this.CHUNK_SIZE;
    }

    public Path artifactFilePath() {
        return this.commonResourcePath().resolve("artifact-tests");
    }

    public Path artifactCrcPath() {
        return this.artifactFilePath().resolve("crc");
    }

    private Seq<Object> getCrcValues(Path filePath) {
        String fileName = ((Object)filePath.getFileName()).toString();
        String crcFileName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fileName), '.'))) + ".txt";
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.artifactCrcPath().resolve(crcFileName))).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9))))).toSeq();
    }

    private void assertFileDataEquality(AddArtifactsRequest.ArtifactChunk artifactChunk, Path localPath) {
        ByteString localData = ByteString.readFrom((InputStream)Files.newInputStream(localPath, new OpenOption[0]));
        long expectedCrc = BoxesRunTime.unboxToLong((Object)this.getCrcValues(localPath).head());
        ByteString $org_scalatest_assert_macro_left = artifactChunk.getData();
        ByteString $org_scalatest_assert_macro_right = localData;
        ByteString byteString = $org_scalatest_assert_macro_left;
        ByteString byteString2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        long $org_scalatest_assert_macro_left2 = artifactChunk.getCrc();
        long $org_scalatest_assert_macro_right2 = expectedCrc;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }

    private void singleChunkArtifactTest(String path) {
        this.test("Single Chunk Artifact - " + path, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String string;
            Seq<AddArtifactsRequest> receivedRequests;
            Path artifactPath = this.artifactFilePath().resolve(path);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(artifactPath.toFile().exists(), "artifactPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            this.artifactManager().addArtifact(((Object)artifactPath).toString());
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            AddArtifactsRequest request = (AddArtifactsRequest)receivedRequests.head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(request.hasBatch(), "request.hasBatch()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            AddArtifactsRequest.Batch batch = request.getBatch();
            java.util.List $org_scalatest_assert_macro_left2 = batch.getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            AddArtifactsRequest.SingleChunkArtifact singleChunkArtifact = batch.getArtifacts(0);
            String string2 = ((Object)artifactPath.getFileName()).toString();
            switch (string2 == null ? 0 : string2.hashCode()) {
                default: 
            }
            if (string2.endsWith(".jar")) {
                string = "jars";
            } else if (string2.endsWith(".class")) {
                string = "classes";
            } else {
                throw new MatchError((Object)string2);
            }
            String namePrefix = string;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(singleChunkArtifact.getName().equals(namePrefix + "/" + path), "singleChunkArtifact.getName().equals(namePrefix.+(\"/\").+(path))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            this.assertFileDataEquality(singleChunkArtifact.getData(), artifactPath);
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
    }

    private ByteString readNextChunk(InputStream in) {
        byte[] buf = new byte[this.CHUNK_SIZE()];
        int bytesRead = 0;
        int count = 0;
        while (count != -1 && bytesRead < this.CHUNK_SIZE()) {
            count = in.read(buf, bytesRead, this.CHUNK_SIZE() - bytesRead);
            if (count == -1) continue;
            bytesRead += count;
        }
        if (bytesRead == 0) {
            return ByteString.empty();
        }
        return ByteString.copyFrom((byte[])buf, (int)0, (int)bytesRead);
    }

    private void checkChunksDataAndCrc(Path filePath, Seq<AddArtifactsRequest.ArtifactChunk> chunks) {
        InputStream in = Files.newInputStream(filePath, new OpenOption[0]);
        Seq<Object> crcs = this.getCrcValues(filePath);
        ((IterableOnceOps)chunks.zip(crcs)).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactSuite.$anonfun$checkChunksDataAndCrc$1(this, in, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$checkChunksDataAndCrc$1(ArtifactSuite $this, InputStream in$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AddArtifactsRequest.ArtifactChunk chunk = (AddArtifactsRequest.ArtifactChunk)tuple2._1();
            long expectedCrc = tuple2._2$mcJ$sp();
            ByteString expectedData = $this.readNextChunk(in$1);
            ByteString byteString = chunk.getData();
            ByteString byteString2 = expectedData;
            return !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null) && chunk.getCrc() == expectedCrc;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Artifact x$12) {
        return ((Object)x$12.path()).toString().contains("jars/my.artifactsuite.lib_mylib-0.1.jar");
    }

    public static final /* synthetic */ boolean $anonfun$new$10(Artifact x$13) {
        return ((Object)x$13.path()).toString().contains("jars/my.artifactsuite.dep_mydep-0.5.jar");
    }

    public static final /* synthetic */ void $anonfun$new$8(String repo) {
        Seq artifacts = Artifact$.MODULE$.newIvyArtifacts(URI.create("ivy://my.artifactsuite.lib:mylib:0.1?repos=" + repo));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(artifacts.exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ArtifactSuite.$anonfun$new$9(x$12))), "artifacts.exists(((x$12: org.apache.spark.sql.Artifact) => x$12.path.toString().contains(\"jars/my.artifactsuite.lib_mylib-0.1.jar\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(artifacts.exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ArtifactSuite.$anonfun$new$10(x$13))), "artifacts.exists(((x$13: org.apache.spark.sql.Artifact) => x$13.path.toString().contains(\"jars/my.artifactsuite.dep_mydep-0.5.jar\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
    }

    public ArtifactSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.CHUNK_SIZE = 32768;
        this.singleChunkArtifactTest("smallClassFile.class");
        this.singleChunkArtifactTest("smallJar.jar");
        this.test("Chunked Artifact - junitLargeJar.jar", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path artifactPath = this.artifactFilePath().resolve("junitLargeJar.jar");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(artifactPath.toFile().exists(), "artifactPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            this.artifactManager().addArtifact(((Object)artifactPath).toString());
            int expectedChunks = (384581 + (this.CHUNK_SIZE() - 1)) / this.CHUNK_SIZE();
            Seq<AddArtifactsRequest> receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_left = 384581;
            long $org_scalatest_assert_macro_right = Files.size(artifactPath);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), (long)$org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left2 = receivedRequests;
            int $org_scalatest_assert_macro_right2 = expectedChunks;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((AddArtifactsRequest)receivedRequests.head()).hasBeginChunk(), "receivedRequests.head.hasBeginChunk()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            AddArtifactsRequest.BeginChunkedArtifact beginChunkRequest = ((AddArtifactsRequest)receivedRequests.head()).getBeginChunk();
            String $org_scalatest_assert_macro_left3 = beginChunkRequest.getName();
            String $org_scalatest_assert_macro_right3 = "jars/junitLargeJar.jar";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            long $org_scalatest_assert_macro_left4 = beginChunkRequest.getTotalBytes();
            int $org_scalatest_assert_macro_right4 = 384581;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            long $org_scalatest_assert_macro_left5 = beginChunkRequest.getNumChunks();
            int $org_scalatest_assert_macro_right5 = expectedChunks;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            Seq dataChunks = (Seq)new .colon.colon((Object)beginChunkRequest.getInitialChunk(), (List)Nil$.MODULE$).$plus$plus((IterableOnce)((IterableOps)receivedRequests.drop(1)).map((Function1 & Serializable)x$10 -> x$10.getChunk()));
            this.checkChunksDataAndCrc(artifactPath, (Seq<AddArtifactsRequest.ArtifactChunk>)dataChunks);
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("Batched SingleChunkArtifacts", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq<AddArtifactsRequest> receivedRequests;
            Path path1 = this.artifactFilePath().resolve("smallClassFile.class");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(path1.toFile().exists(), "path1.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            URI file1 = path1.toUri();
            Path path2 = this.artifactFilePath().resolve("smallJar.jar");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(path2.toFile().exists(), "path2.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            URI file2 = path2.toUri();
            this.artifactManager().addArtifacts((Seq)new .colon.colon((Object)file1, (List)new .colon.colon((Object)file2, (List)Nil$.MODULE$)));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            AddArtifactsRequest request = (AddArtifactsRequest)receivedRequests.head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(request.hasBatch(), "request.hasBatch()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            AddArtifactsRequest.Batch batch = request.getBatch();
            java.util.List $org_scalatest_assert_macro_left2 = batch.getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            java.util.List artifacts = batch.getArtifactsList();
            String $org_scalatest_assert_macro_left3 = ((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(0)).getName();
            String $org_scalatest_assert_macro_right3 = "classes/smallClassFile.class";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            String $org_scalatest_assert_macro_left4 = ((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(1)).getName();
            String $org_scalatest_assert_macro_right4 = "jars/smallJar.jar";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(0)).getData(), Paths.get(file1));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(1)).getData(), Paths.get(file2));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("Mix of SingleChunkArtifact and chunked artifact", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            java.util.List firstReqBatch;
            Seq<AddArtifactsRequest> receivedRequests;
            Path path1 = this.artifactFilePath().resolve("smallClassFile.class");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(path1.toFile().exists(), "path1.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            URI file1 = path1.toUri();
            Path path2 = this.artifactFilePath().resolve("junitLargeJar.jar");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(path2.toFile().exists(), "path2.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            URI file2 = path2.toUri();
            Path path3 = this.artifactFilePath().resolve("smallClassFileDup.class");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(path3.toFile().exists(), "path3.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            URI file3 = path3.toUri();
            Path path4 = this.artifactFilePath().resolve("smallJar.jar");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(path4.toFile().exists(), "path4.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            URI file4 = path4.toUri();
            this.artifactManager().addArtifacts((Seq)new .colon.colon((Object)file1, (List)new .colon.colon((Object)file2, (List)new .colon.colon((Object)file3, (List)new .colon.colon((Object)file4, (List)Nil$.MODULE$)))));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 14;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            java.util.List $org_scalatest_assert_macro_left2 = firstReqBatch = ((AddArtifactsRequest)receivedRequests.head()).getBatch().getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            String $org_scalatest_assert_macro_left3 = ((AddArtifactsRequest.SingleChunkArtifact)firstReqBatch.get(0)).getName();
            String $org_scalatest_assert_macro_right3 = "classes/smallClassFile.class";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)firstReqBatch.get(0)).getData(), Paths.get(file1));
            AddArtifactsRequest secondReq = (AddArtifactsRequest)receivedRequests.apply(1);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(secondReq.hasBeginChunk(), "secondReq.hasBeginChunk()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            AddArtifactsRequest.BeginChunkedArtifact beginChunkRequest = secondReq.getBeginChunk();
            String $org_scalatest_assert_macro_left4 = beginChunkRequest.getName();
            String $org_scalatest_assert_macro_right4 = "jars/junitLargeJar.jar";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            long $org_scalatest_assert_macro_left5 = beginChunkRequest.getTotalBytes();
            int $org_scalatest_assert_macro_right5 = 384581;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            long $org_scalatest_assert_macro_left6 = beginChunkRequest.getNumChunks();
            int $org_scalatest_assert_macro_right6 = 12;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == (long)$org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            Seq dataChunks = (Seq)new .colon.colon((Object)beginChunkRequest.getInitialChunk(), (List)Nil$.MODULE$).$plus$plus((IterableOnce)((IterableOps)((IterableOps)receivedRequests.drop(2)).dropRight(1)).map((Function1 & Serializable)x$11 -> x$11.getChunk()));
            this.checkChunksDataAndCrc(Paths.get(file2), (Seq<AddArtifactsRequest.ArtifactChunk>)dataChunks);
            AddArtifactsRequest.Batch lastBatch = ((AddArtifactsRequest)receivedRequests.last()).getBatch();
            int $org_scalatest_assert_macro_left7 = lastBatch.getArtifactsCount();
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            java.util.List remainingArtifacts = lastBatch.getArtifactsList();
            String $org_scalatest_assert_macro_left8 = ((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(0)).getName();
            String $org_scalatest_assert_macro_right8 = "classes/smallClassFileDup.class";
            String string5 = $org_scalatest_assert_macro_left8;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            String $org_scalatest_assert_macro_left9 = ((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(1)).getName();
            String $org_scalatest_assert_macro_right9 = "jars/smallJar.jar";
            String string7 = $org_scalatest_assert_macro_left9;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(0)).getData(), Paths.get(file3));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(1)).getData(), Paths.get(file4));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("cache an artifact and check its presence", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<AddArtifactsRequest> receivedRequests;
            String s = "Hello, World!";
            byte[] blob = s.getBytes("UTF-8");
            String expectedHash = DigestUtils.sha256Hex((byte[])blob);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.artifactManager().isCachedArtifact(expectedHash)));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            String actualHash = this.artifactManager().cacheArtifact(blob);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(actualHash);
            String $org_scalatest_assert_macro_right2 = expectedHash;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.artifactManager().isCachedArtifact(expectedHash)));
            boolean $org_scalatest_assert_macro_right3 = true;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left4 = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        this.test("resolve ivy", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MavenUtils.MavenCoordinate main = new MavenUtils.MavenCoordinate("my.artifactsuite.lib", "mylib", "0.1");
            String dep = "my.artifactsuite.dep:mydep:0.5";
            IvyTestUtils$.MODULE$.withRepository(main, (Option)new Some((Object)dep), (Option)None$.MODULE$, IvyTestUtils$.MODULE$.withRepository$default$4(), IvyTestUtils$.MODULE$.withRepository$default$5(), IvyTestUtils$.MODULE$.withRepository$default$6(), IvyTestUtils$.MODULE$.withRepository$default$7(), (Function1 & Serializable)repo -> {
                ArtifactSuite.$anonfun$new$8(repo);
                return BoxedUnit.UNIT;
            });
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        this.test("artifact with custom target", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq<AddArtifactsRequest> receivedRequests;
            Path artifactPath = this.artifactFilePath().resolve("smallClassFile.class");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(artifactPath.toFile().exists(), "artifactPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            String target = "sub/package/smallClassFile.class";
            this.artifactManager().addArtifact(((Object)artifactPath).toString(), target);
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            AddArtifactsRequest request = (AddArtifactsRequest)receivedRequests.head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(request.hasBatch(), "request.hasBatch()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            AddArtifactsRequest.Batch batch = request.getBatch();
            java.util.List $org_scalatest_assert_macro_left2 = batch.getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            AddArtifactsRequest.SingleChunkArtifact singleChunkArtifact = batch.getArtifacts(0);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(singleChunkArtifact.getName().equals("classes/" + target), "singleChunkArtifact.getName().equals(\"classes/\".+(target))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            this.assertFileDataEquality(singleChunkArtifact.getData(), artifactPath);
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        this.test("in-memory artifact with custom target", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<AddArtifactsRequest> receivedRequests;
            Path artifactPath = this.artifactFilePath().resolve("smallClassFile.class");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(artifactPath.toFile().exists(), "artifactPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            byte[] artifactBytes = Files.readAllBytes(artifactPath);
            String target = "sub/package/smallClassFile.class";
            this.artifactManager().addArtifact(artifactBytes, target);
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            AddArtifactsRequest request = (AddArtifactsRequest)receivedRequests.head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(request.hasBatch(), "request.hasBatch()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            AddArtifactsRequest.Batch batch = request.getBatch();
            java.util.List $org_scalatest_assert_macro_left2 = batch.getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            AddArtifactsRequest.SingleChunkArtifact singleChunkArtifact = batch.getArtifacts(0);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(singleChunkArtifact.getName().equals("classes/" + target), "singleChunkArtifact.getName().equals(\"classes/\".+(target))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            ByteString $org_scalatest_assert_macro_left3 = singleChunkArtifact.getData().getData();
            ByteString $org_scalatest_assert_macro_right3 = ByteString.copyFrom((byte[])artifactBytes);
            ByteString byteString = $org_scalatest_assert_macro_left3;
            ByteString byteString2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("When both source and target paths are given, extension conditions are checked on target path", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Path artifactPath = this.artifactFilePath().resolve("smallClassFile.class");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(artifactPath.toFile().exists(), "artifactPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
            return this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.artifactManager().addArtifact(((Object)artifactPath).toString(), "dummy.extension"), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
    }
}

