/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingServerBuilder;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.AddArtifactsResponse;
import org.apache.spark.connect.proto.AnalyzePlanRequest;
import org.apache.spark.connect.proto.AnalyzePlanResponse;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.SQL;
import org.apache.spark.connect.proto.SparkConnectServiceGrpc;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.SparkSession$;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator$;
import org.apache.spark.sql.connect.client.GrpcExceptionConverter;
import org.apache.spark.sql.connect.client.GrpcExceptionConverter$;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.apache.spark.sql.connect.client.RetriesExceeded;
import org.apache.spark.sql.connect.client.RetryPolicy;
import org.apache.spark.sql.connect.client.RetryPolicy$;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.SparkConnectClientSuite$DummyFn$;
import org.apache.spark.sql.connect.client.SparkConnectClientSuite$TestPackURI$;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Futures$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rea\u0001B\"E\u0001ECQ\u0001\u001a\u0001\u0005\u0002\u0015D\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u00025\t\u00131\u0004\u0001\u0019!a\u0001\n\u0013i\u0007\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011%9\b\u00011AA\u0002\u0013%\u0001\u0010C\u0005}\u0001\u0001\u0007\t\u0019!C\u0005{\"Iq\u0010\u0001a\u0001\u0002\u0003\u0006K!\u001f\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0001C\u0006\u0002\u0016\u0001\u0001\r\u00111A\u0005\n\u0005]\u0001bCA\u000e\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bAq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005=\u0002\u0001\"\u0011\u0002.!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002\"CA#\u0001E\u0005I\u0011BA$\u0011\u001d\ti\u0006\u0001C\u0005\u0003?2a!a%\u0001\t\u0006U\u0005BCA[#\tU\r\u0011\"\u0001\u00028\"Q\u0011\u0011X\t\u0003\u0012\u0003\u0006I!! \t\u0015\u0005m\u0016C!f\u0001\n\u0003\ti\f\u0003\u0006\u0002FF\u0011\t\u0012)A\u0005\u0003\u007fC!\"a2\u0012\u0005+\u0007I\u0011AAe\u0011)\ti-\u0005B\tB\u0003%\u00111\u001a\u0005\u0007IF!\t!a4\t\u0013\u0005m\u0017#!A\u0005\u0002\u0005u\u0007\"CAs#E\u0005I\u0011AAt\u0011%\tY/EI\u0001\n\u0003\ti\u000fC\u0005\u0002rF\t\n\u0011\"\u0001\u0002t\"I\u0011q_\t\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0005\u0013\t\u0012\u0011!C\u0001\u0005\u0017A\u0011B!\u0004\u0012\u0003\u0003%\tAa\u0004\t\u0013\te\u0011#!A\u0005B\tm\u0001\"\u0003B\u0015#\u0005\u0005I\u0011\u0001B\u0016\u0011%\u0011y#EA\u0001\n\u0003\u0012\t\u0004C\u0005\u00036E\t\t\u0011\"\u0011\u00038!I!\u0011H\t\u0002\u0002\u0013\u0005#1\b\u0005\n\u0005{\t\u0012\u0011!C!\u0005\u007f9\u0011Ba\u0011\u0001\u0003\u0003EIA!\u0012\u0007\u0013\u0005M\u0005!!A\t\n\t\u001d\u0003B\u00023(\t\u0003\u0011i\u0006C\u0005\u0003:\u001d\n\t\u0011\"\u0012\u0003<!I!qL\u0014\u0002\u0002\u0013\u0005%\u0011\r\u0005\n\u0005S:\u0013\u0013!C\u0001\u0003gD\u0011Ba\u001b(\u0003\u0003%\tI!\u001c\t\u0013\t}t%%A\u0005\u0002\u0005M\b\"\u0003BA\u0001\t\u0007I\u0011\u0002BB\u0011!\u0011\t\n\u0001Q\u0001\n\t\u0015\u0005b\u0002BJ\u0001\u0011%!Q\u0013\u0004\u0007\u00057\u0003AA!(\t\u0015\t}\u0015G!A%\u0002\u0013\u0011\t\u000b\u0003\u0006\u0003*F\u0012\t\u0011)A\u0005\u0003KAa\u0001Z\u0019\u0005\u0002\t-\u0006\"\u0003BZc\u0001\u0007I\u0011\u0001B\u0006\u0011%\u0011),\ra\u0001\n\u0003\u00119\f\u0003\u0005\u0003<F\u0002\u000b\u0015BA\u0013\u0011\u001d\u0011i,\rC\u0001\u0005o9\u0011Ba0\u0001\u0003\u0003EIA!1\u0007\u0013\tm\u0005!!A\t\n\t\r\u0007B\u00023;\t\u0003\u0011)\rC\u0005\u0003Hj\n\n\u0011\"\u0001\u0002H!9!\u0011\u001a\u0001\u0005\u0002\t-\u0007b\u0002Bq\u0001\u0011%!1\u001d\u0005\n\u0005o\u0004!\u0019!C\u0005\u0003sD\u0001B!?\u0001A\u0003%\u00111 \u0005\b\u0005w\u0004A\u0011\u0002B\u007f\u0011\u001d\u0019)\u0001\u0001C\u0005\u0007\u000f\u0011qc\u00159be.\u001cuN\u001c8fGR\u001cE.[3oiN+\u0018\u000e^3\u000b\u0005\u00153\u0015AB2mS\u0016tGO\u0003\u0002H\u0011\u000691m\u001c8oK\u000e$(BA%K\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00172\u000bQa\u001d9be.T!!\u0014(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0015aA8sO\u000e\u00011\u0003\u0002\u0001S5\u0002\u0004\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u0011\u0019,hn];ji\u0016T!a\u0016(\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA-U\u0005-\te.\u001f$v]N+\u0018\u000e^3\u0011\u0005msV\"\u0001/\u000b\u0005u3\u0015\u0001\u0002;fgRL!a\u0018/\u0003\u001f\r{gN\\3di\u001a+hnU;ji\u0016\u0004\"!\u00192\u000e\u0003YK!a\u0019,\u0003%\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0016\u000b7\r[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0004\"a\u001a\u0001\u000e\u0003\u0011+\u0012!\u001b\t\u0003O*L!a\u001b#\u0003%M\u0003\u0018M]6D_:tWm\u0019;DY&,g\u000e^\u0001\u000bG2LWM\u001c;`I\u0015\fHC\u00018u!\ty'/D\u0001q\u0015\u0005\t\u0018!B:dC2\f\u0017BA:q\u0005\u0011)f.\u001b;\t\u000fU\u001c\u0011\u0011!a\u0001S\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\rd\u0017.\u001a8uA\u000591/\u001a:wS\u000e,W#A=\u0011\u0005\u001dT\u0018BA>E\u0005a!U/\\7z'B\f'o[\"p]:,7\r^*feZL7-Z\u0001\fg\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0002o}\"9QOBA\u0001\u0002\u0004I\u0018\u0001C:feZL7-\u001a\u0011\u0002\rM,'O^3s+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t\u001d\u0014\bo\u0019\u0006\u0003\u0003\u001f\t!![8\n\t\u0005M\u0011\u0011\u0002\u0002\u0007'\u0016\u0014h/\u001a:\u0002\u0015M,'O^3s?\u0012*\u0017\u000fF\u0002o\u00033A\u0001\"^\u0005\u0002\u0002\u0003\u0007\u0011QA\u0001\bg\u0016\u0014h/\u001a:!\u0003A\u0019H/\u0019:u\tVlW._*feZ,'\u000fF\u0002o\u0003CAq!a\t\f\u0001\u0004\t)#\u0001\u0003q_J$\bcA8\u0002(%\u0019\u0011\u0011\u00069\u0003\u0007%sG/\u0001\u0006cK\u001a|'/Z#bG\"$\u0012A\\\u0001\nC\u001a$XM]#bG\"\fA\u0003^3ti\u000ec\u0017.\u001a8u\u0007>tg.Z2uS>tG\u0003BA\u001b\u0003\u0003\"2A\\A\u001c\u0011\u001d\tID\u0004a\u0001\u0003w\tQb\u00197jK:$()^5mI\u0016\u0014\bCB8\u0002>\u0005\u0015\u0012.C\u0002\u0002@A\u0014\u0011BR;oGRLwN\\\u0019\t\u0013\u0005\rc\u0002%AA\u0002\u0005\u0015\u0012AC:feZ,'\u000fU8si\u0006qB/Z:u\u00072LWM\u001c;D_:tWm\u0019;j_:$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0013RC!!\n\u0002L-\u0012\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003%)hn\u00195fG.,GMC\u0002\u0002XA\f!\"\u00198o_R\fG/[8o\u0013\u0011\tY&!\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0005xSRDWI\u001c<t)\u0011\t\t'!\u001c\u0015\u00079\f\u0019\u0007\u0003\u0005\u0002fA!\t\u0019AA4\u0003\u00051\u0007\u0003B8\u0002j9L1!a\u001bq\u0005!a$-\u001f8b[\u0016t\u0004bBA8!\u0001\u0007\u0011\u0011O\u0001\u0006a\u0006L'o\u001d\t\u0006_\u0006M\u0014qO\u0005\u0004\u0003k\u0002(A\u0003\u001fsKB,\u0017\r^3e}A9q.!\u001f\u0002~\u0005u\u0014bAA>a\n1A+\u001e9mKJ\u0002B!a \u0002\u000e:!\u0011\u0011QAE!\r\t\u0019\t]\u0007\u0003\u0003\u000bS1!a\"Q\u0003\u0019a$o\\8u}%\u0019\u00111\u00129\u0002\rA\u0013X\rZ3g\u0013\u0011\ty)!%\u0003\rM#(/\u001b8h\u0015\r\tY\t\u001d\u0002\f)\u0016\u001cH\u000fU1dWV\u0013\u0016jE\u0004\u0012\u0003/\u000bi*a)\u0011\u0007=\fI*C\u0002\u0002\u001cB\u0014a!\u00118z%\u00164\u0007cA8\u0002 &\u0019\u0011\u0011\u00159\u0003\u000fA\u0013x\u000eZ;diB!\u0011QUAX\u001d\u0011\t9+a+\u000f\t\u0005\r\u0015\u0011V\u0005\u0002c&\u0019\u0011Q\u00169\u0002\u000fA\f7m[1hK&!\u0011\u0011WAZ\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\ti\u000b]\u0001\u0011G>tg.Z2uS>t7\u000b\u001e:j]\u001e,\"!! \u0002#\r|gN\\3di&|gn\u0015;sS:<\u0007%A\u0005jg\u000e{'O]3diV\u0011\u0011q\u0018\t\u0004_\u0006\u0005\u0017bAAba\n9!i\\8mK\u0006t\u0017AC5t\u0007>\u0014(/Z2uA\u0005YQ\r\u001f;sC\u000eCWmY6t+\t\tY\rE\u0003p\u0003{Ig.\u0001\u0007fqR\u0014\u0018m\u00115fG.\u001c\b\u0005\u0006\u0005\u0002R\u0006U\u0017q[Am!\r\t\u0019.E\u0007\u0002\u0001!9\u0011Q\u0017\rA\u0002\u0005u\u0004bBA^1\u0001\u0007\u0011q\u0018\u0005\n\u0003\u000fD\u0002\u0013!a\u0001\u0003\u0017\fAaY8qsRA\u0011\u0011[Ap\u0003C\f\u0019\u000fC\u0005\u00026f\u0001\n\u00111\u0001\u0002~!I\u00111X\r\u0011\u0002\u0003\u0007\u0011q\u0018\u0005\n\u0003\u000fL\u0002\u0013!a\u0001\u0003\u0017\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002j*\"\u0011QPA&\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a<+\t\u0005}\u00161J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t)P\u000b\u0003\u0002L\u0006-\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002|B!\u0011Q B\u0004\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011\u0001\u00027b]\u001eT!A!\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\u000by0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002&\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\t\u0005/\u00012a\u001cB\n\u0013\r\u0011)\u0002\u001d\u0002\u0004\u0003:L\b\u0002C; \u0003\u0003\u0005\r!!\n\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\b\u0011\r\t}!Q\u0005B\t\u001b\t\u0011\tCC\u0002\u0003$A\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119C!\t\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u007f\u0013i\u0003\u0003\u0005vC\u0005\u0005\t\u0019\u0001B\t\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m(1\u0007\u0005\tk\n\n\t\u00111\u0001\u0002&\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002&\u0005AAo\\*ue&tw\r\u0006\u0002\u0002|\u00061Q-];bYN$B!a0\u0003B!AQ/JA\u0001\u0002\u0004\u0011\t\"A\u0006UKN$\b+Y2l+JK\u0005cAAjOM)qE!\u0013\u0003VAa!1\nB)\u0003{\ny,a3\u0002R6\u0011!Q\n\u0006\u0004\u0005\u001f\u0002\u0018a\u0002:v]RLW.Z\u0005\u0005\u0005'\u0012iEA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BAa\u0016\u0003\\5\u0011!\u0011\f\u0006\u0005\u0003\u001f\u0011\u0019!\u0003\u0003\u00022\neCC\u0001B#\u0003\u0015\t\u0007\u000f\u001d7z)!\t\tNa\u0019\u0003f\t\u001d\u0004bBA[U\u0001\u0007\u0011Q\u0010\u0005\b\u0003wS\u0003\u0019AA`\u0011%\t9M\u000bI\u0001\u0002\u0004\tY-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BAa\u001c\u0003|A)qN!\u001d\u0003v%\u0019!1\u000f9\u0003\r=\u0003H/[8o!%y'qOA?\u0003\u007f\u000bY-C\u0002\u0003zA\u0014a\u0001V;qY\u0016\u001c\u0004\"\u0003B?Y\u0005\u0005\t\u0019AAi\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\tU\u0013\u0016j]\u000b\u0003\u0005\u000b\u0003bAa\"\u0003\u000e\u0006EWB\u0001BE\u0015\u0011\u0011YI!\t\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002BH\u0005\u0013\u00131aU3r\u0003\u0015)&+S:!\u00035\u0019\u0007.Z2l)\u0016\u001cH\u000fU1dWR\u0019aNa&\t\u000f\te\u0005\u00071\u0001\u0002R\u0006AA/Z:u!\u0006\u001c7NA\u0004Ek6l\u0017P\u00128\u0014\u0007E\n9*A\u0001f!\u0015y\u0017\u0011\u000eBR!\u0011\t)K!*\n\t\t\u001d\u00161\u0017\u0002\n)\"\u0014xn^1cY\u0016\f\u0001B\\;n\r\u0006LGn\u001d\u000b\u0007\u0005[\u0013yK!-\u0011\u0007\u0005M\u0017\u0007\u0003\u0005\u0003 R\"\t\u0019\u0001BQ\u0011%\u0011I\u000b\u000eI\u0001\u0002\u0004\t)#A\u0004d_VtG/\u001a:\u0002\u0017\r|WO\u001c;fe~#S-\u001d\u000b\u0004]\ne\u0006\u0002C;7\u0003\u0003\u0005\r!!\n\u0002\u0011\r|WO\u001c;fe\u0002\n!A\u001a8\u0002\u000f\u0011+X.\\=G]B\u0019\u00111\u001b\u001e\u0014\u0007i\n9\n\u0006\u0002\u0003B\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nq\u0003^3tiB{G.[2z'B,7-\u001b4jG\u0016\u0013(o\u001c:\u0015\r\t5'1\u001bBl!\r9'qZ\u0005\u0004\u0005#$%a\u0003*fiJL\bk\u001c7jGfDqA!6>\u0001\u0004\t)#\u0001\u0006nCb\u0014V\r\u001e:jKNDqA!7>\u0001\u0004\u0011Y.\u0001\u0004ti\u0006$Xo\u001d\t\u0005\u0003\u000f\u0011i.\u0003\u0003\u0003`\u0006%!AB*uCR,8/A\u0005ck&dG\r\u00157b]R!!Q\u001dBz!\u0011\u00119Oa<\u000e\u0005\t%(\u0002\u0002Bv\u0005[\fQ\u0001\u001d:pi>T!a\u0012&\n\t\tE(\u0011\u001e\u0002\u0005!2\fg\u000eC\u0004\u0003vz\u0002\r!! \u0002\u000bE,XM]=\u0002\u0019%se+\u0011'J\t~Cuj\u0015+\u0002\u001b%se+\u0011'J\t~Cuj\u0015+!\u0003u\u0019'/Z1uKVs'/Z:pYZ\f'\r\\3I_N$8\t[1o]\u0016dWC\u0001B\u0000!\u0011\t9a!\u0001\n\t\r\r\u0011\u0011\u0002\u0002\u000f\u001b\u0006t\u0017mZ3e\u0007\"\fgN\\3m\u0003e\t7o]3si\u000e{g\u000e^1j]N,f.\u0019<bS2\f'\r\\3\u0015\t\r%1Q\u0003\t\u0005\u0007\u0017\u0019yAD\u0002b\u0007\u001bI1!!,W\u0013\u0011\u0019\tba\u0005\u0003\u0013\u0005\u001b8/\u001a:uS>t'bAAW-\"91q\u0003\"A\u0002\t\r\u0016!\u0001;")
public class SparkConnectClientSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private volatile SparkConnectClientSuite$TestPackURI$ TestPackURI$module;
    private volatile SparkConnectClientSuite$DummyFn$ DummyFn$module;
    private SparkConnectClient client;
    private DummySparkConnectService service;
    private Server server;
    private final Seq<TestPackURI> URIs;
    private final String INVALID_HOST;

    public /* synthetic */ org.scalatest.Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public org.scalatest.Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private SparkConnectClientSuite$TestPackURI$ TestPackURI() {
        if (this.TestPackURI$module == null) {
            this.TestPackURI$lzycompute$1();
        }
        return this.TestPackURI$module;
    }

    private SparkConnectClientSuite$DummyFn$ DummyFn() {
        if (this.DummyFn$module == null) {
            this.DummyFn$lzycompute$1();
        }
        return this.DummyFn$module;
    }

    private SparkConnectClient client() {
        return this.client;
    }

    private void client_$eq(SparkConnectClient x$1) {
        this.client = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private void startDummyServer(int port) {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((ForwardingServerBuilder)NettyServerBuilder.forPort((int)port).addService((BindableService)this.service())).build());
        this.server().start();
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.client_$eq(null);
        this.server_$eq(null);
        this.service_$eq(null);
    }

    public void afterEach() {
        if (this.server() != null) {
            this.server().shutdownNow();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "SparkConnectClientSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        if (this.client() != null) {
            this.client().shutdown();
            return;
        }
    }

    private void testClientConnection(int serverPort, Function1<Object, SparkConnectClient> clientBuilder) {
        this.startDummyServer(serverPort);
        this.client_$eq((SparkConnectClient)clientBuilder.apply((Object)BoxesRunTime.boxToInteger((int)this.server().getPort())));
        AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().setSessionId("abc123").build();
        AnalyzePlanResponse response = this.client().analyze(request);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(response.getSessionId());
        String $org_scalatest_assert_macro_right = "abc123";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    private int testClientConnection$default$1() {
        return 0;
    }

    private void withEnvs(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        Map<String, String> readonlyEnv = System.getenv();
        Field field = readonlyEnv.getClass().getDeclaredField("m");
        field.setAccessible(true);
        Map modifiableEnv = (Map)field.get(readonlyEnv);
        try {
            pairs.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$withEnvs$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
                Tuple2 tuple2 = x$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(modifiableEnv.containsKey(k), "modifiableEnv.containsKey(k)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
                    return modifiableEnv.put(k, v);
                }
                throw new MatchError((Object)tuple2);
            });
            f.apply$mcV$sp();
        }
        finally {
            pairs.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$withEnvs$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$5 -> {
                Tuple2 tuple2 = x$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    return (String)modifiableEnv.remove(k);
                }
                throw new MatchError((Object)tuple2);
            });
        }
    }

    private Seq<TestPackURI> URIs() {
        return this.URIs;
    }

    private void checkTestPack(TestPackURI testPack) {
        SparkConnectClient client = SparkConnectClient$.MODULE$.builder().connectionString(testPack.connectionString()).build();
        testPack.extraChecks().apply((Object)client);
    }

    public RetryPolicy testPolicySpecificError(int maxRetries, Status status) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)maxRetries));
        String x$2 = "Policy for " + status.getCode();
        Function1 & Serializable x$3 = (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$testPolicySpecificError$1(status, x0$1));
        FiniteDuration x$4 = RetryPolicy$.MODULE$.apply$default$2();
        Option x$5 = RetryPolicy$.MODULE$.apply$default$3();
        double x$6 = RetryPolicy$.MODULE$.apply$default$4();
        FiniteDuration x$7 = RetryPolicy$.MODULE$.apply$default$5();
        FiniteDuration x$8 = RetryPolicy$.MODULE$.apply$default$6();
        return new RetryPolicy((Option)x$1, x$4, x$5, x$6, x$7, x$8, (Function1)x$3, x$2);
    }

    private Plan buildPlan(String query) {
        return Plan.newBuilder().setRoot(Relation.newBuilder().setSql(SQL.newBuilder().setQuery(query)).build()).build();
    }

    private String INVALID_HOST() {
        return this.INVALID_HOST;
    }

    private ManagedChannel createUnresolvableHostChannel() {
        String x$1 = this.INVALID_HOST();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        int x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$4();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        scala.collection.immutable.Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        Seq x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        int x$13 = SparkConnectClient.Configuration$.MODULE$.apply$default$13();
        int x$14 = SparkConnectClient.Configuration$.MODULE$.apply$default$14();
        return new SparkConnectClient.Configuration(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14).createChannel();
    }

    private Assertion assertContainsUnavailable(Throwable t) {
        String $org_scalatest_assert_macro_left = t.getMessage();
        String $org_scalatest_assert_macro_right = "UNAVAILABLE: Unable to resolve host " + this.INVALID_HOST();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
    }

    private final void TestPackURI$lzycompute$1() {
        SparkConnectClientSuite sparkConnectClientSuite = this;
        synchronized (sparkConnectClientSuite) {
            if (this.TestPackURI$module == null) {
                this.TestPackURI$module = new SparkConnectClientSuite$TestPackURI$(this);
            }
        }
    }

    private final void DummyFn$lzycompute$1() {
        SparkConnectClientSuite sparkConnectClientSuite = this;
        synchronized (sparkConnectClientSuite) {
            if (this.DummyFn$module == null) {
                this.DummyFn$module = new SparkConnectClientSuite$DummyFn$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$withEnvs$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$withEnvs$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ SparkConnectClient $anonfun$new$4(int testPort) {
        return SparkConnectClient$.MODULE$.builder().port(testPort).build();
    }

    public static final /* synthetic */ SparkConnectClient $anonfun$new$6(int testPort) {
        return SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + testPort).build();
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Throwable x$6) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$20(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$new$21(Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            return name.startsWith("org.apache.spark");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$24(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$new$25(Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            return !name.startsWith("org.apache.spark");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$URIs$3(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.configuration().host();
        String $org_scalatest_assert_macro_right = "localhost";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        int $org_scalatest_assert_macro_left2 = client.configuration().port();
        int $org_scalatest_assert_macro_right2 = 1234;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        String $org_scalatest_assert_macro_left3 = client.sessionId();
        Object $org_scalatest_assert_macro_right3 = null;
        String string3 = $org_scalatest_assert_macro_left3;
        Object var11_10 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, string3 == null ? var11_10 != null : !string3.equals(var11_10), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        UUID $org_scalatest_assert_macro_left4 = UUID.fromString(client.sessionId());
        Object $org_scalatest_assert_macro_right4 = null;
        UUID uUID = $org_scalatest_assert_macro_left4;
        Object var15_14 = null;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", null, uUID == null ? var15_14 != null : !((Object)uUID).equals(var15_14), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
    }

    public static final /* synthetic */ void $anonfun$URIs$4(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.configuration().host();
        String $org_scalatest_assert_macro_right = "localhost";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        int $org_scalatest_assert_macro_left2 = client.configuration().port();
        int $org_scalatest_assert_macro_right2 = ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
    }

    public static final /* synthetic */ void $anonfun$URIs$5(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userId();
        String $org_scalatest_assert_macro_right = "a94";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
    }

    public static final /* synthetic */ void $anonfun$URIs$6(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userAgent();
        String $org_scalatest_assert_macro_right = "a945";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
    }

    public static final /* synthetic */ void $anonfun$URIs$7(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userAgent();
        String $org_scalatest_assert_macro_right = "spark/";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        String $org_scalatest_assert_macro_left2 = client.userAgent();
        String $org_scalatest_assert_macro_right2 = "scala/";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        String $org_scalatest_assert_macro_left3 = client.userAgent();
        String $org_scalatest_assert_macro_right3 = "jvm/";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        String $org_scalatest_assert_macro_left4 = client.userAgent();
        String $org_scalatest_assert_macro_right4 = "os/";
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
    }

    public static final /* synthetic */ void $anonfun$URIs$8(SparkConnectClient client) {
        int $org_scalatest_assert_macro_left = client.configuration().grpcMaxMessageSize();
        int $org_scalatest_assert_macro_right = 1860;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
    }

    private static final void sleep$1(long t, LongRef totalSleepMs$1) {
        totalSleepMs$1.elem += t;
    }

    public static final /* synthetic */ Assertion $anonfun$new$32(SparkConnectClientSuite $this, int x$13) {
        int n = x$13;
        LongRef totalSleepMs = LongRef.create((long)0L);
        DummyFn dummyFn = new DummyFn($this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.UNAVAILABLE), 100);
        GrpcRetryHandler retryHandler = new GrpcRetryHandler(RetryPolicy$.MODULE$.defaultPolicies(), (Function1)(JFunction1.mcVJ.sp & Serializable)t -> SparkConnectClientSuite.sleep$1(t, totalSleepMs));
        $this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(RetriesExceeded.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        long $org_scalatest_assert_macro_left = totalSleepMs.elem;
        int $org_scalatest_assert_macro_right = 600000;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
    }

    public static final /* synthetic */ boolean $anonfun$new$48(Throwable x$16) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$53(Throwable x$17) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPolicySpecificError$1(Status status$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            Status.Code code = statusRuntimeException.getStatus().getCode();
            Status.Code code2 = status$1.getCode();
            return !(code != null ? !code.equals(code2) : code2 != null);
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$70(ExecutePlanResponse x$21) {
    }

    public static final /* synthetic */ void $anonfun$new$72(ExecutePlanResponse x$22) {
    }

    public SparkConnectClientSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.test("SPARK-51391: Use 'user.name' by default", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.client_$eq(SparkConnectClient$.MODULE$.builder().build());
            String $org_scalatest_assert_macro_left = this.client().userId();
            String $org_scalatest_assert_macro_right = System.getProperty("user.name");
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("Placeholder test: Create SparkConnectClient", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.client_$eq(SparkConnectClient$.MODULE$.builder().userId("abc123").build());
            String $org_scalatest_assert_macro_left = this.client().userId();
            String $org_scalatest_assert_macro_right = "abc123";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("Test connection", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testClientConnection(this.testClientConnection$default$1(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)testPort -> SparkConnectClientSuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)testPort))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("Test connection string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testClientConnection(this.testClientConnection$default$1(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)testPort -> SparkConnectClientSuite.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)testPort))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("Test encryption", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
            Function1 & Serializable x$2 = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$8(x$6));
            String x$3 = "TestPolicy";
            FiniteDuration x$4 = RetryPolicy$.MODULE$.apply$default$2();
            Option x$5 = RetryPolicy$.MODULE$.apply$default$3();
            double x$62 = RetryPolicy$.MODULE$.apply$default$4();
            FiniteDuration x$7 = RetryPolicy$.MODULE$.apply$default$5();
            FiniteDuration x$8 = RetryPolicy$.MODULE$.apply$default$6();
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort() + "/;use_ssl=true").retryPolicy(new RetryPolicy((Option)x$1, x$4, x$5, x$62, x$7, x$8, (Function1)x$2, "TestPolicy")).build());
            AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().setSessionId("abc123").build();
            return this.assertThrows((Function0 & Serializable)() -> this.client().analyze(request), ClassTag$.MODULE$.apply(SparkException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("SparkSession create with SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)("sc://localhost:" + this.server().getPort()))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().create();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                SparkSession session2 = SparkSession$.MODULE$.builder().create();
                SparkSession $org_scalatest_assert_macro_left2 = session;
                SparkSession $org_scalatest_assert_macro_right2 = session2;
                SparkSession sparkSession = $org_scalatest_assert_macro_left2;
                SparkSession sparkSession2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("SparkSession getOrCreate with SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)("sc://localhost:" + this.server().getPort()))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().getOrCreate();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                SparkSession session2 = SparkSession$.MODULE$.builder().getOrCreate();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session);
                SparkSession $org_scalatest_assert_macro_right2 = session2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("Builder.remote takes precedence over SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            String incorrectUrl = "sc://localhost:" + (this.server().getPort() + 1);
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)incorrectUrl)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().remote("sc://localhost:" + this.server().getPort()).getOrCreate();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("SparkSession initialisation with connection string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).build());
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).create();
            Dataset df = session.range(10L);
            df.analyze();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
            Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("Custom Interceptor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).interceptor(new ClientInterceptor(null){

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                    throw new RuntimeException("Blocked");
                }
            }).build());
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).create();
            return this.assertThrows((Function0)(JFunction0.mcJ.sp & Serializable)() -> session.range(10L).count(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("error framework parameters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.collection.immutable.Map errors = GrpcExceptionConverter$.MODULE$.errorFactory();
            errors.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$20(check$ifrefutable$3))).withFilter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$21(x$7))).foreach((Function1 & Serializable)x$8 -> {
                Tuple2 tuple2 = x$8;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Function1 constructor = (Function1)tuple2._2();
                    return (Assertion)this.withClue(name, (Function0 & Serializable)() -> {
                        GrpcExceptionConverter.ErrorParams testParams = new GrpcExceptionConverter.ErrorParams("", (Option)None$.MODULE$, (Option)new Some((Object)"DUPLICATE_KEY"), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keyColumn"), (Object)"`abc`")})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)));
                        Throwable error = (Throwable)constructor.apply((Object)testParams);
                        String $org_scalatest_assert_macro_left = error.getMessage();
                        String $org_scalatest_assert_macro_right = testParams.message();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
                        Throwable $org_scalatest_assert_macro_left2 = error.getCause();
                        Object $org_scalatest_assert_macro_right2 = null;
                        Throwable throwable = $org_scalatest_assert_macro_left2;
                        Object var9_8 = null;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(throwable != null ? !throwable.equals(var9_8) : var9_8 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
                        String $org_scalatest_assert_macro_left3 = ((SparkThrowable)error).getCondition();
                        String $org_scalatest_assert_macro_right3 = (String)testParams.errorClass().get();
                        String string = $org_scalatest_assert_macro_left3;
                        String string2 = $org_scalatest_assert_macro_right3;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
                        scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = CollectionConverters$.MODULE$.MapHasAsScala(((SparkThrowable)error).getMessageParameters()).asScala();
                        scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = testParams.messageParameters();
                        scala.collection.mutable.Map map = $org_scalatest_assert_macro_left4;
                        scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right4;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
                        Object $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])((SparkThrowable)error).getQueryContext());
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left5), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left5), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
                    });
                }
                throw new MatchError((Object)tuple2);
            });
            errors.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$24(check$ifrefutable$4))).withFilter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$25(x$9))).foreach((Function1 & Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Function1 constructor = (Function1)tuple2._2();
                    return (Assertion)this.withClue(name, (Function0 & Serializable)() -> {
                        GrpcExceptionConverter.ErrorParams testParams = new GrpcExceptionConverter.ErrorParams("Found duplicate keys `abc`", (Option)None$.MODULE$, (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)));
                        Throwable error = (Throwable)constructor.apply((Object)testParams);
                        String $org_scalatest_assert_macro_left = error.getMessage();
                        String $org_scalatest_assert_macro_right = testParams.message();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                        Throwable $org_scalatest_assert_macro_left2 = error.getCause();
                        Object $org_scalatest_assert_macro_right2 = null;
                        Throwable throwable = $org_scalatest_assert_macro_left2;
                        Object var9_8 = null;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(throwable != null ? !throwable.equals(var9_8) : var9_8 != null), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.URIs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestPackURI[]{new TestPackURI(this, "sc://host", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://localhost/", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            this.testClientConnection(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)x$12 -> client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://localhost:1234/", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$3(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://localhost/;", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$4(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://host:123", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;user_id=a94", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$5(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://host:123/;user_agent=a945", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$6(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "scc://host:12", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "http://host", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc:/host:1234/path", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host/path", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host/;parm1;param2", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123;user_id=a94", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc:///user_id=123", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:-4", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://:123/", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=true", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;session_id=", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;session_id=abcdefgh", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;session_id=" + UUID.randomUUID().toString(), true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=true;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken;use_ssl=true", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=false;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken;use_ssl=false", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;param1=value1;param2=value2", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://SPARK-45486", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$7(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://SPARK-47694:123/;grpc_max_message_size=1860", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$8(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://SPARK-47694:123/;grpc_max_message_size=abc", false, this.TestPackURI().apply$default$3())}));
        this.URIs().foreach((Function1 & Serializable)testPack -> {
            this.test("Check URI: " + testPack.connectionString() + ", isCorrect: " + testPack.isCorrect(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                if (!testPack.isCorrect()) {
                    return $this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.checkTestPack(testPack), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
                }
                $this.checkTestPack(testPack);
                return BoxedUnit.UNIT;
            }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-44721: Retries run for a minimum period", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable)x$13 -> SparkConnectClientSuite.$anonfun$new$32(this, BoxesRunTime.unboxToInt((Object)x$13))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        this.test("SPARK-44275: retry actually retries", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int result;
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            Seq retryPolicies = RetryPolicy$.MODULE$.defaultPolicies();
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicies, (Function1)(JFunction1.mcVJ.sp & Serializable)x$14 -> {});
            int $org_scalatest_assert_macro_left = result = BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn()));
            int $org_scalatest_assert_macro_right = 42;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            int $org_scalatest_assert_macro_left2 = dummyFn.counter();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("SPARK-44275: default retryException retries only on UNAVAILABLE", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.ABORTED), this.DummyFn().$lessinit$greater$default$2());
            Seq retryPolicies = RetryPolicy$.MODULE$.defaultPolicies();
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicies, (Function1)(JFunction1.mcVJ.sp & Serializable)x$15 -> {});
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("SPARK-44275: retry uses canRetry to filter exceptions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            Function1 & Serializable x$9 = (Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$48(x$16));
            String x$10 = "TestPolicy";
            Option x$11 = RetryPolicy$.MODULE$.apply$default$1();
            FiniteDuration x$12 = RetryPolicy$.MODULE$.apply$default$2();
            Option x$13 = RetryPolicy$.MODULE$.apply$default$3();
            double x$14 = RetryPolicy$.MODULE$.apply$default$4();
            FiniteDuration x$15 = RetryPolicy$.MODULE$.apply$default$5();
            FiniteDuration x$162 = RetryPolicy$.MODULE$.apply$default$6();
            RetryPolicy retryPolicy = new RetryPolicy(x$11, x$12, x$13, x$14, x$15, x$162, (Function1)x$9, "TestPolicy");
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicy);
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        this.test("SPARK-44275: retry does not exceed maxRetries", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            Function1 & Serializable x$172 = (Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$53(x$17));
            Some x$182 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            String x$19 = "TestPolicy";
            FiniteDuration x$20 = RetryPolicy$.MODULE$.apply$default$2();
            Option x$21 = RetryPolicy$.MODULE$.apply$default$3();
            double x$22 = RetryPolicy$.MODULE$.apply$default$4();
            FiniteDuration x$23 = RetryPolicy$.MODULE$.apply$default$5();
            FiniteDuration x$24 = RetryPolicy$.MODULE$.apply$default$6();
            RetryPolicy retryPolicy = new RetryPolicy((Option)x$182, x$20, x$21, x$22, x$23, x$24, (Function1)x$172, "TestPolicy");
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicy, (Function1)(JFunction1.mcVJ.sp & Serializable)x$18 -> {});
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(RetriesExceeded.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        this.test("Test multiple policies", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            RetryPolicy policy1 = this.testPolicySpecificError(2, Status.UNAVAILABLE);
            RetryPolicy policy2 = this.testPolicySpecificError(4, Status.INTERNAL);
            Iterator errors = ((StrictOptimizedLinearSeqOps)package$.MODULE$.List().fill(2, (Function0 & Serializable)() -> Status.UNAVAILABLE).$plus$plus((IterableOnce)package$.MODULE$.List().fill(4, (Function0 & Serializable)() -> Status.INTERNAL))).iterator();
            new GrpcRetryHandler((Seq)new .colon.colon((Object)policy1, (List)new .colon.colon((Object)policy2, (List)Nil$.MODULE$)), (Function1)(JFunction1.mcVJ.sp & Serializable)x$19 -> {}).retry((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Option e = errors.nextOption();
                if (e.isDefined()) {
                    throw ((Status)e.get()).asRuntimeException();
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(errors.hasNext(), "errors.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        this.test("Test multiple policies exceed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            RetryPolicy policy1 = this.testPolicySpecificError(2, Status.INTERNAL);
            RetryPolicy policy2 = this.testPolicySpecificError(4, Status.INTERNAL);
            Iterator errors = ((StrictOptimizedLinearSeqOps)package$.MODULE$.List().fill(10, (Function0 & Serializable)() -> Status.INTERNAL)).iterator();
            IntRef countAttempted = IntRef.create((int)0);
            this.assertThrows((Function0 & Serializable)() -> new GrpcRetryHandler((Seq)new .colon.colon((Object)policy1, (List)new .colon.colon((Object)policy2, (List)Nil$.MODULE$)), (Function1)(JFunction1.mcVJ.sp & Serializable)x$20 -> {}).retry((Function0 & Serializable)() -> {
                ++countAttempted$1.elem;
                Option e = errors.nextOption();
                if (e.isDefined()) {
                    throw ((Status)e.get()).asRuntimeException();
                }
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(RetriesExceeded.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
            int $org_scalatest_assert_macro_left = countAttempted.elem;
            int $org_scalatest_assert_macro_right = 7;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        this.test("ArtifactManager retries errors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IntRef attempt = IntRef.create((int)0);
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).interceptor(new ClientInterceptor(null, attempt){
                private final IntRef attempt$1;

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                    ++this.attempt$1.elem;
                    if (this.attempt$1.elem <= 3) {
                        throw Status.UNAVAILABLE.withDescription("").asRuntimeException();
                    }
                    return channel.newCall(methodDescriptor, callOptions);
                }
                {
                    this.attempt$1 = attempt$1;
                }
            }).build());
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).create();
            Path artifactFilePath = this.commonResourcePath().resolve("artifact-tests");
            Path path = artifactFilePath.resolve("smallClassFile.class");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(path.toFile().exists(), "path.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
            session.addArtifact(((Object)path).toString());
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        this.test("SPARK-45871: Client execute iterator.toSeq consumes the reattachable iterator", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).enableReattachableExecute().build());
            Plan plan = this.buildPlan("select * from range(10000000)");
            CloseableIterator iter = this.client().execute(plan);
            ExecutePlanResponseReattachableIterator reattachableIter = ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator((Iterator)iter);
            iter.toSeq();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        this.test("SPARK-45871: Client execute iterator.foreach consumes the reattachable iterator", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).enableReattachableExecute().build());
            Plan plan = this.buildPlan("select * from range(10000000)");
            CloseableIterator iter = this.client().execute(plan);
            ExecutePlanResponseReattachableIterator reattachableIter = ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator((Iterator)iter);
            iter.foreach((Function1 & Serializable)x$21 -> {
                SparkConnectClientSuite.$anonfun$new$70(x$21);
                return BoxedUnit.UNIT;
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
        this.test("SPARK-48056: Client execute gets INVALID_HANDLE.SESSION_NOT_FOUND and proceeds", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).enableReattachableExecute().build());
            this.service().errorToThrowOnExecute_$eq((Option<Throwable>)new Some((Object)new StatusRuntimeException(Status.INTERNAL.withDescription("INVALID_HANDLE.SESSION_NOT_FOUND"))));
            Plan plan = this.buildPlan("select * from range(1)");
            CloseableIterator iter = this.client().execute(plan);
            ExecutePlanResponseReattachableIterator reattachableIter = ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator((Iterator)iter);
            reattachableIter.foreach((Function1 & Serializable)x$22 -> {
                SparkConnectClientSuite.$anonfun$new$72(x$22);
                return BoxedUnit.UNIT;
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
        this.INVALID_HOST = "host.invalid";
        this.test("GRPC stub unary call throws error immediately", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ManagedChannel channel = this.createUnresolvableHostChannel();
            SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub = SparkConnectServiceGrpc.newBlockingStub((Channel)channel);
            AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().build();
            StatusRuntimeException ex = (StatusRuntimeException)this.intercept((Function0 & Serializable)() -> stub.analyzePlan(request), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
            return this.assertContainsUnavailable((Throwable)ex);
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        this.test("GRPC stub server streaming call throws error on first next() / hasNext()", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ManagedChannel channel = this.createUnresolvableHostChannel();
            SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub = SparkConnectServiceGrpc.newBlockingStub((Channel)channel);
            ExecutePlanRequest request = ExecutePlanRequest.newBuilder().build();
            java.util.Iterator iter = stub.executePlan(request);
            StatusRuntimeException ex = (StatusRuntimeException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> iter.hasNext(), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
            return this.assertContainsUnavailable((Throwable)ex);
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        this.test("GRPC stub client streaming call throws error on first client request sent", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ManagedChannel channel = this.createUnresolvableHostChannel();
            SparkConnectServiceGrpc.SparkConnectServiceStub stub = SparkConnectServiceGrpc.newStub((Channel)channel);
            ObjectRef onNextResponse = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef onErrorThrowable = ObjectRef.create((Object)None$.MODULE$);
            BooleanRef onCompletedCalled = BooleanRef.create((boolean)false);
            StreamObserver<AddArtifactsResponse> responseObserver = new StreamObserver<AddArtifactsResponse>(null, onNextResponse, onErrorThrowable, onCompletedCalled){
                private final ObjectRef onNextResponse$1;
                private final ObjectRef onErrorThrowable$1;
                private final BooleanRef onCompletedCalled$1;

                public void onNext(AddArtifactsResponse value) {
                    this.onNextResponse$1.elem = new Some((Object)value);
                }

                public void onError(Throwable t) {
                    this.onErrorThrowable$1.elem = new Some((Object)t);
                }

                public void onCompleted() {
                    this.onCompletedCalled$1.elem = false;
                }
                {
                    this.onNextResponse$1 = onNextResponse$1;
                    this.onErrorThrowable$1 = onErrorThrowable$1;
                    this.onCompletedCalled$1 = onCompletedCalled$1;
                }
            };
            StreamObserver observer = stub.addArtifacts((StreamObserver)responseObserver);
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                Option $org_scalatest_assert_macro_left = (Option)onNextResponse$1.elem;
                None$ $org_scalatest_assert_macro_right = None$.MODULE$;
                Option option = $org_scalatest_assert_macro_left;
                None$ none$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((Option)onErrorThrowable$1.elem).isDefined(), "onErrorThrowable.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
                this.assertContainsUnavailable((Throwable)((Option)onErrorThrowable$1.elem).get());
                boolean $org_scalatest_assert_macro_left2 = onCompletedCalled$1.elem;
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
            observer.onNext((Object)AddArtifactsRequest.newBuilder().build());
            observer.onCompleted();
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
    }

    private class DummyFn {
        private final Function0<Throwable> e;
        private final int numFails;
        private int counter;
        public final /* synthetic */ SparkConnectClientSuite $outer;

        public int counter() {
            return this.counter;
        }

        public void counter_$eq(int x$1) {
            this.counter = x$1;
        }

        public int fn() {
            if (this.counter() < this.numFails) {
                this.counter_$eq(this.counter() + 1);
                throw (Throwable)this.e.apply();
            }
            return 42;
        }

        public /* synthetic */ SparkConnectClientSuite org$apache$spark$sql$connect$client$SparkConnectClientSuite$DummyFn$$$outer() {
            return this.$outer;
        }

        public DummyFn(SparkConnectClientSuite $outer, Function0<Throwable> e, int numFails) {
            this.e = e;
            this.numFails = numFails;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.counter = 0;
        }
    }

    private class TestPackURI
    implements Product,
    Serializable {
        private final String connectionString;
        private final boolean isCorrect;
        private final Function1<SparkConnectClient, BoxedUnit> extraChecks;
        public final /* synthetic */ SparkConnectClientSuite $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String connectionString() {
            return this.connectionString;
        }

        public boolean isCorrect() {
            return this.isCorrect;
        }

        public Function1<SparkConnectClient, BoxedUnit> extraChecks() {
            return this.extraChecks;
        }

        public TestPackURI copy(String connectionString, boolean isCorrect, Function1<SparkConnectClient, BoxedUnit> extraChecks) {
            return new TestPackURI(this.org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer(), connectionString, isCorrect, extraChecks);
        }

        public String copy$default$1() {
            return this.connectionString();
        }

        public boolean copy$default$2() {
            return this.isCorrect();
        }

        public Function1<SparkConnectClient, BoxedUnit> copy$default$3() {
            return this.extraChecks();
        }

        public String productPrefix() {
            return "TestPackURI";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.connectionString();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isCorrect());
                }
                case 2: {
                    return this.extraChecks();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestPackURI;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "connectionString";
                }
                case 1: {
                    return "isCorrect";
                }
                case 2: {
                    return "extraChecks";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.connectionString()));
            n = Statics.mix((int)n, (int)(this.isCorrect() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.extraChecks()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestPackURI)) return false;
            if (((TestPackURI)object).org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer() != this.org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestPackURI testPackURI = (TestPackURI)x$1;
            if (this.isCorrect() != testPackURI.isCorrect()) return false;
            String string = this.connectionString();
            String string2 = testPackURI.connectionString();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Function1<SparkConnectClient, BoxedUnit> function1 = this.extraChecks();
            Function1<SparkConnectClient, BoxedUnit> function12 = testPackURI.extraChecks();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!testPackURI.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ SparkConnectClientSuite org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer() {
            return this.$outer;
        }

        public TestPackURI(SparkConnectClientSuite $outer, String connectionString, boolean isCorrect, Function1<SparkConnectClient, BoxedUnit> extraChecks) {
            this.connectionString = connectionString;
            this.isCorrect = isCorrect;
            this.extraChecks = extraChecks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

