/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.streaming;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.StreamingQuery;
import org.apache.spark.sql.connect.streaming.ClientStreamingQuerySuite$;
import org.apache.spark.sql.connect.streaming.ClientStreamingQuerySuite$EventCollector$;
import org.apache.spark.sql.connect.streaming.TestForeachWriter;
import org.apache.spark.sql.connect.test.IntegrationTestUtils$;
import org.apache.spark.sql.connect.test.QueryTest;
import org.apache.spark.sql.connect.test.RemoteSparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Futures$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.SpanSugar$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\u0014)\u0001UBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004V\u0001\u0001\u0006Ia\u0013\u0005\u0006-\u0002!Ia\u0016\u0004\u0006e\u0002\t\ta\u001d\u0005\u0006\u000b\u0016!\t\u0001\u001e\u0005\u0006M\u00161\tb\u001e\u0005\u0006q\u0016!\t\"\u001f\u0005\b\u00037)A\u0011CA\u000f\u0011\u001d\t9#\u0002C\t\u0003S1a!a\r\u0001\u0001\u0005U\u0002BB#\f\t\u0003\t9\u0004C\u0003g\u0017\u0011Es\u000fC\u0004\u0002<-!\t%!\u0010\t\u000f\u0005\u00053\u0002\"\u0011\u0002D!9\u0011qI\u0006\u0005B\u0005%cABA'\u0001\u0001\ty\u0005\u0003\u0004F#\u0011\u0005\u0011\u0011\u000b\u0005\u0006MF!\tf\u001e\u0005\b\u0003w\tB\u0011IA+\u0011\u001d\t\t%\u0005C!\u00033Bq!!\u0018\u0012\t\u0003\ny\u0006C\u0004\u0002HE!\t%!\u001b\u0007\r\u00055\u0004\u0001AA8\u0011\u0019)\u0005\u0004\"\u0001\u0002r!I\u0011Q\u000f\rA\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u0017C\u0002\u0019!C\u0001\u0003\u001bC\u0001\"a%\u0019A\u0003&\u0011\u0011\u0010\u0005\n\u0003+C\u0002\u0019!C\u0001\u0003oB\u0011\"a&\u0019\u0001\u0004%\t!!'\t\u0011\u0005u\u0005\u0004)Q\u0005\u0003sB\u0011\"a(\u0019\u0001\u0004%\t!a\u001e\t\u0013\u0005\u0005\u0006\u00041A\u0005\u0002\u0005\r\u0006\u0002CAT1\u0001\u0006K!!\u001f\t\u000f\u0005m\u0002\u0004\"\u0011\u0002*\"9\u0011\u0011\t\r\u0005B\u00055\u0006bBA/1\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003\u000fBB\u0011IA[\u0005e\u0019E.[3oiN#(/Z1nS:<\u0017+^3ssN+\u0018\u000e^3\u000b\u0005%R\u0013!C:ue\u0016\fW.\u001b8h\u0015\tYC&A\u0004d_:tWm\u0019;\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011Dh\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0003s)\nA\u0001^3ti&\u00111\b\u000f\u0002\n#V,'/\u001f+fgR\u0004\"aN\u001f\n\u0005yB$A\u0005*f[>$Xm\u00159be.\u001cVm]:j_:\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0018\u0002\u0011%tG/\u001a:oC2L!\u0001R!\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003\u0011\u0002i\u0011\u0001K\u0001\ri\u0016\u001cH\u000fR1uCB\u000bG\u000f[\u000b\u0002\u0017B\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\u0005M&dWM\u0003\u0002Q#\u0006\u0019a.[8\u000b\u0003I\u000bAA[1wC&\u0011A+\u0014\u0002\u0005!\u0006$\b.A\u0007uKN$H)\u0019;b!\u0006$\b\u000eI\u0001\u001bi\u0016\u001cHo\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\u000b\u00041z+\u0007CA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS&\u0001B+oSRDQa\u0018\u0003A\u0002\u0001\f\u0001\u0002\\5ti\u0016tWM\u001d\t\u0003C\u000el\u0011A\u0019\u0006\u0003S1J!\u0001\u001a2\u0003-M#(/Z1nS:<\u0017+^3ss2K7\u000f^3oKJDQA\u001a\u0003A\u0002\u001d\fA\u0002^1cY\u0016\u0004vn\u001d;gSb\u0004\"\u0001[8\u000f\u0005%l\u0007C\u00016[\u001b\u0005Y'B\u000175\u0003\u0019a$o\\8u}%\u0011aNW\u0001\u0007!J,G-\u001a4\n\u0005A\f(AB*ue&twM\u0003\u0002o5\nqQI^3oi\u000e{G\u000e\\3di>\u00148CA\u0003a)\u0005)\bC\u0001<\u0006\u001b\u0005\u0001Q#A4\u0002)!\fg\u000e\u001a7f\u001f:\fV/\u001a:z'R\f'\u000f^3e)\tA&\u0010C\u0003|\u0011\u0001\u0007A0A\u0003fm\u0016tG\u000fE\u0002~\u0003+q1A`A\t\u001d\ry\u0018q\u0002\b\u0005\u0003\u0003\tiA\u0004\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u0013q1A[A\u0004\u0013\u0005\u0019\u0014BA\u00193\u0013\ty\u0003'\u0003\u0002.]%\u0011\u0011\u0006L\u0005\u0004\u0003'\u0011\u0017AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\n\t\u0005]\u0011\u0011\u0004\u0002\u0012#V,'/_*uCJ$X\rZ#wK:$(bAA\nE\u0006)\u0002.\u00198eY\u0016|e.U;fef\u0004&o\\4sKN\u001cHc\u0001-\u0002 !110\u0003a\u0001\u0003C\u00012!`A\u0012\u0013\u0011\t)#!\u0007\u0003%E+XM]=Qe><'/Z:t\u000bZ,g\u000e^\u0001\u0018Q\u0006tG\r\\3P]F+XM]=UKJl\u0017N\\1uK\u0012$2\u0001WA\u0016\u0011\u0019Y(\u00021\u0001\u0002.A\u0019Q0a\f\n\t\u0005E\u0012\u0011\u0004\u0002\u0015#V,'/\u001f+fe6Lg.\u0019;fI\u00163XM\u001c;\u0003!\u00153XM\u001c;D_2dWm\u0019;peZ\u000b4CA\u0006v)\t\tI\u0004\u0005\u0002w\u0017\u0005qqN\\)vKJL8\u000b^1si\u0016$Gc\u0001-\u0002@!)1P\u0004a\u0001y\u0006yqN\\)vKJL\bK]8he\u0016\u001c8\u000fF\u0002Y\u0003\u000bBaa_\bA\u0002\u0005\u0005\u0012!E8o#V,'/\u001f+fe6Lg.\u0019;fIR\u0019\u0001,a\u0013\t\rm\u0004\u0002\u0019AA\u0017\u0005A)e/\u001a8u\u0007>dG.Z2u_J4&g\u0005\u0002\u0012kR\u0011\u00111\u000b\t\u0003mF!2\u0001WA,\u0011\u0015YH\u00031\u0001})\rA\u00161\f\u0005\u0007wV\u0001\r!!\t\u0002\u0017=t\u0017+^3ss&#G.\u001a\u000b\u00041\u0006\u0005\u0004BB>\u0017\u0001\u0004\t\u0019\u0007E\u0002~\u0003KJA!a\u001a\u0002\u001a\tq\u0011+^3ss&#G.Z#wK:$Hc\u0001-\u0002l!11p\u0006a\u0001\u0003[\u0011!\"T=MSN$XM\\3s'\tA\u0002\r\u0006\u0002\u0002tA\u0011a\u000fG\u0001\u0006gR\f'\u000f^\u000b\u0003\u0003s\u0002R!a\u001f\u0002\u0006\u001etA!! \u0002\u0002:\u0019!.a \n\u0003mK1!a![\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\"\u0002\n\n\u00191+Z9\u000b\u0007\u0005\r%,A\u0005ti\u0006\u0014Ho\u0018\u0013fcR\u0019\u0001,a$\t\u0013\u0005E5$!AA\u0002\u0005e\u0014a\u0001=%c\u000511\u000f^1si\u0002\n\u0001\u0002\u001d:pOJ,7o]\u0001\raJ|wM]3tg~#S-\u001d\u000b\u00041\u0006m\u0005\"CAI=\u0005\u0005\t\u0019AA=\u0003%\u0001(o\\4sKN\u001c\b%A\u0005uKJl\u0017N\\1uK\u0006iA/\u001a:nS:\fG/Z0%KF$2\u0001WAS\u0011%\t\t*IA\u0001\u0002\u0004\tI(\u0001\u0006uKJl\u0017N\\1uK\u0002\"2\u0001WAV\u0011\u0015Y8\u00051\u0001})\rA\u0016q\u0016\u0005\u0007w\u0012\u0002\r!!\t\u0015\u0007a\u000b\u0019\f\u0003\u0004|K\u0001\u0007\u00111\r\u000b\u00041\u0006]\u0006BB>'\u0001\u0004\ti\u0003")
public class ClientStreamingQuerySuite
extends QueryTest
implements RemoteSparkSession,
Logging {
    private final Path testDataPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkSession spark;
    private int serverPort;
    private boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$ignore(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.ignore$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void beforeAll() {
        RemoteSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        RemoteSparkSession.afterAll$(this);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        RemoteSparkSession.test$(this, testName, testTags, testFun, pos);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private int serverPort$lzycompute() {
        ClientStreamingQuerySuite clientStreamingQuerySuite = this;
        synchronized (clientStreamingQuerySuite) {
            if (!this.bitmap$0) {
                this.serverPort = RemoteSparkSession.serverPort$(this);
                this.bitmap$0 = true;
            }
        }
        return this.serverPort;
    }

    @Override
    public int serverPort() {
        if (!this.bitmap$0) {
            return this.serverPort$lzycompute();
        }
        return this.serverPort;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private Path testDataPath() {
        return this.testDataPath;
    }

    private void testStreamingQueryListener(StreamingQueryListener listener, String tablePostfix) {
        StreamingQueryListener[] listeners;
        StreamingQueryListener[] $org_scalatest_assert_macro_left = this.spark().streams().listListeners();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        this.spark().streams().addListener(listener);
        StreamingQuery q = this.spark().readStream().format("rate").load().writeStream().format("console").start();
        try {
            q.processAllAvailable();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.isActive(), "q.isActive", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
                org.apache.spark.sql.connect.Dataset $org_scalatest_assert_macro_left = this.spark().table("listener_start_events" + tablePostfix).toDF();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
                org.apache.spark.sql.connect.Dataset $org_scalatest_assert_macro_left2 = this.spark().table("listener_progress_events" + tablePostfix).toDF();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        }
        finally {
            q.stop();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).seconds()), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(q.isActive(), "q.isActive", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
                org.apache.spark.sql.connect.Dataset $org_scalatest_assert_macro_left = this.spark().table("listener_terminated_events" + tablePostfix).toDF();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
            this.spark().sql("DROP TABLE IF EXISTS listener_start_events" + tablePostfix);
            this.spark().sql("DROP TABLE IF EXISTS listener_progress_events" + tablePostfix);
            this.spark().sql("DROP TABLE IF EXISTS listener_terminated_events" + tablePostfix);
        }
        StreamingQueryListener[] $org_scalatest_assert_macro_left2 = listeners = this.spark().streams().listListeners();
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
        EventCollectorV2 listener1 = new EventCollectorV2(this);
        this.spark().streams().addListener((StreamingQueryListener)listener1);
        StreamingQueryListener[] $org_scalatest_assert_macro_left3 = this.spark().streams().listListeners();
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
        this.spark().streams().removeListener((StreamingQueryListener)listener1);
        StreamingQueryListener[] $org_scalatest_assert_macro_left4 = this.spark().streams().listListeners();
        int $org_scalatest_assert_macro_right4 = 1;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        this.spark().streams().addListener(listener);
        StreamingQueryListener[] $org_scalatest_assert_macro_left5 = this.spark().streams().listListeners();
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        this.spark().streams().removeListener(listener);
        StreamingQueryListener[] $org_scalatest_assert_macro_left6 = this.spark().streams().listListeners();
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        this.spark().streams().removeListener(listener);
        StreamingQueryListener[] $org_scalatest_assert_macro_left7 = this.spark().streams().listListeners();
        int $org_scalatest_assert_macro_right7 = 0;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
    }

    public static final /* synthetic */ void $anonfun$new$7(ClientStreamingQuerySuite $this, File ckpt) {
        StreamingQuery q1 = $this.spark().readStream().format("rate").load().writeStream().option("checkpointLocation", ckpt.getCanonicalPath()).toTable("my_table");
        StreamingQuery q2 = $this.spark().readStream().table("my_table").writeStream().format("memory").queryName("my_sink").start();
        try {
            q1.processAllAvailable();
            q2.processAllAvailable();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                long $org_scalatest_assert_macro_left = $this.spark().table("my_sink").count();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        finally {
            q1.stop();
            q2.stop();
            $this.spark().sql("DROP TABLE my_table");
        }
    }

    public static final /* synthetic */ void $anonfun$new$10(ClientStreamingQuerySuite $this, File ckpt) {
        StreamingQuery q = $this.spark().readStream().format("csv").option("sep", ";").option("header", "true").option("path", ((Object)$this.testDataPath().resolve("csv")).toString()).schema(new StructType((StructField[])((Object[])new StructField[]{new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("age", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("job", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).load().writeStream().option("checkpointLocation", ckpt.getCanonicalPath()).format("memory").queryName("my_sink_csv").trigger(Trigger.AvailableNow()).start();
        try {
            q.processAllAvailable();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                long $org_scalatest_assert_macro_left = $this.spark().table("my_sink_csv").count();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }
        finally {
            q.stop();
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$15(File x$1) {
        return !x$1.getName().startsWith("_");
    }

    public static final /* synthetic */ void $anonfun$new$13(ClientStreamingQuerySuite $this, File path) {
        String checkpointPath = path.getCanonicalPath() + "/_checkpoint";
        String outputPath = path.getCanonicalPath() + "/out";
        StreamingQuery q = $this.spark().readStream().format("text").load(((Object)$this.testDataPath().resolve("txt")).toString()).withColumn("age", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).writeStream().option("checkpointLocation", checkpointPath).format("parquet").partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"age"})).outputMode("append").option("path", outputPath).start();
        try {
            q.processAllAvailable();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                File file = new File(outputPath);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClientStreamingQuerySuite.$anonfun$new$15(x$1))), "scala.Predef.refArrayOps[java.io.File](file.listFiles()).exists(((x$1: java.io.File) => x$1.getName().startsWith(\"_\").unary_!))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        }
        finally {
            q.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$23(ClientStreamingQuerySuite $this, File ckpt) {
        StreamingQuery q1 = $this.spark().readStream().format("rate").load().writeStream().clusterBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).option("checkpointLocation", ckpt.getCanonicalPath()).toTable("my_table");
        try {
            q1.processAllAvailable();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                $this.checkAnswer((Function0<org.apache.spark.sql.connect.Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().sql("DESCRIBE my_table"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"timestamp", "timestamp", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"value", "bigint", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# Clustering Information", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# col_name", "data_type", "comment"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"value", "bigint", null})), (List)Nil$.MODULE$))))));
                long $org_scalatest_assert_macro_left = $this.spark().table("my_sink").count();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        }
        finally {
            q1.stop();
            $this.spark().sql("DROP TABLE my_table");
        }
    }

    public static final /* synthetic */ void $anonfun$new$45(String viewName$1, Dataset df, long batchId) {
        long count = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)row -> BoxesRunTime.boxToLong((long)row.getLong(1)), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientStreamingQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator6$1(ClientStreamingQuerySuite $outer) {
            }
        }
        df.sparkSession().createDataFrame((Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(batchId, count), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator6$1(null))).createOrReplaceGlobalTempView(viewName$1);
    }

    public static final /* synthetic */ long $anonfun$new$54(Long v) {
        return BoxesRunTime.unboxToLong((Object)v);
    }

    public static final /* synthetic */ void $anonfun$new$53(String viewName$2, Dataset ds, long batchId) {
        long count = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ds.collect()), (Function1 & Serializable)v -> BoxesRunTime.boxToLong((long)ClientStreamingQuerySuite.$anonfun$new$54(v)), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientStreamingQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator11$1(ClientStreamingQuerySuite $outer) {
            }
        }
        ds.sparkSession().createDataFrame((Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(batchId, count), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator11$1(null))).createOrReplaceGlobalTempView(viewName$2);
    }

    public ClientStreamingQuerySuite() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        RemoteSparkSession.$init$(this);
        Logging.$init$((Logging)this);
        this.testDataPath = Paths.get(IntegrationTestUtils$.MODULE$.sparkHome(), "sql", "connect", "common", "src", "test", "resources", "query-tests", "test-data", "streaming");
        this.test("Streaming API with windowed aggregate query", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.shuffle.partitions"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            org.apache.spark.sql.connect.Dataset readDF = this.spark().readStream().format("rate").option("rowsPerSecond", "10").option("numPartitions", "1").load();
            String $org_scalatest_assert_macro_left = readDF.schema().toDDL();
            String $org_scalatest_assert_macro_right = "timestamp TIMESTAMP,value BIGINT";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            org.apache.spark.sql.connect.Dataset countsDF = readDF.withWatermark("timestamp", "10 seconds").groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.window(functions$.MODULE$.col("timestamp"), "5 seconds")})).count().selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window.start as timestamp", "count as num_events"}));
            String $org_scalatest_assert_macro_left2 = countsDF.schema().toDDL();
            String $org_scalatest_assert_macro_right2 = "timestamp TIMESTAMP,num_events BIGINT NOT NULL";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            String queryName = "sparkConnectStreamingQuery";
            StreamingQuery query = countsDF.writeStream().format("memory").queryName(queryName).trigger(Trigger.ProcessingTime((String)"1 second")).start();
            try {
                StreamingQueryProgress lastProgress;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(query.status().isDataAvailable(), "query.status.isDataAvailable", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
                    Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])query.recentProgress());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
                StreamingQueryProgress $org_scalatest_assert_macro_left3 = lastProgress = query.lastProgress();
                Object $org_scalatest_assert_macro_right3 = null;
                StreamingQueryProgress streamingQueryProgress = $org_scalatest_assert_macro_left3;
                Object var18_17 = null;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, streamingQueryProgress == null ? var18_17 != null : !streamingQueryProgress.equals(var18_17), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
                String $org_scalatest_assert_macro_left4 = lastProgress.name();
                String $org_scalatest_assert_macro_right4 = queryName;
                String string5 = $org_scalatest_assert_macro_left4;
                String string6 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
                Map $org_scalatest_assert_macro_left5 = lastProgress.durationMs();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
                Map $org_scalatest_assert_macro_left6 = lastProgress.eventTime();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
                Object $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])lastProgress.stateOperators());
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left7), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
                Set $org_scalatest_assert_macro_left8 = CollectionConverters$.MODULE$.SetHasAsScala(((StateOperatorProgress)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])lastProgress.stateOperators()))).customMetrics().keySet()).asScala();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right5 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"loadedMapCacheHitCount", "loadedMapCacheMissCount", "stateOnCurrentVersionSizeBytes"}));
                Set set = $org_scalatest_assert_macro_left8;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right5, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
                Object $org_scalatest_assert_macro_left9 = Predef$.MODULE$.refArrayOps((Object[])lastProgress.sources());
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left9), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left9), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                String $org_scalatest_assert_macro_left10 = lastProgress.sink().description();
                String $org_scalatest_assert_macro_right6 = "MemorySink";
                String string7 = $org_scalatest_assert_macro_left10;
                String string8 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                Map $org_scalatest_assert_macro_left11 = lastProgress.observedMetrics();
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> {
                    UUID $org_scalatest_assert_macro_left = p.id();
                    UUID $org_scalatest_assert_macro_right = lastProgress.id();
                    UUID uUID = $org_scalatest_assert_macro_left;
                    UUID uUID2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                    UUID $org_scalatest_assert_macro_left2 = p.runId();
                    UUID $org_scalatest_assert_macro_right2 = lastProgress.runId();
                    UUID uUID3 = $org_scalatest_assert_macro_left2;
                    UUID uUID4 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(uUID3 != null ? !((Object)uUID3).equals(uUID4) : uUID4 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
                    String $org_scalatest_assert_macro_left3 = p.name();
                    String $org_scalatest_assert_macro_right3 = lastProgress.name();
                    String string = $org_scalatest_assert_macro_left3;
                    String string2 = $org_scalatest_assert_macro_right3;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
                });
                query.explain();
            }
            finally {
                query.stop();
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                Object $org_scalatest_assert_macro_left12 = Predef$.MODULE$.refArrayOps((Object[])query.recentProgress());
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left12), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left12), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            }
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("Streaming table API", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.shuffle.partitions"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("DROP TABLE IF EXISTS my_table").collect();
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)ckpt -> {
                ClientStreamingQuerySuite.$anonfun$new$7(this, ckpt);
                return BoxedUnit.UNIT;
            });
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("stream read options with csv source and Trigger.AvailableNow", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)ckpt -> {
            ClientStreamingQuerySuite.$anonfun$new$10(this, ckpt);
            return BoxedUnit.UNIT;
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("stream save options with txt source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            ClientStreamingQuerySuite.$anonfun$new$13(this, path);
            return BoxedUnit.UNIT;
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("streaming with temp view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Object object;
            this.spark().sql("CREATE TABLE input_table (value string) USING parquet");
            this.spark().sql("INSERT INTO input_table VALUES ('a'), ('b'), ('c')");
            org.apache.spark.sql.connect.Dataset df = this.spark().readStream().table("input_table");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.isStreaming(), "df.isStreaming", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            df.createOrReplaceTempView("test_view");
            org.apache.spark.sql.connect.Dataset viewDf = this.spark().sql("SELECT * FROM test_view");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(viewDf.isStreaming(), "viewDf.isStreaming", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            StreamingQuery q = viewDf.writeStream().format("memory").queryName("test_view_sink").start();
            try {
                q.processAllAvailable();
                object = Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                    long $org_scalatest_assert_macro_left = this.spark().table("test_view_sink").count();
                    int $org_scalatest_assert_macro_right = 3;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            }
            finally {
                q.stop();
                this.spark().sql("DROP VIEW IF EXISTS test_view");
                this.spark().sql("DROP TABLE IF EXISTS input_table");
            }
            return object;
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("awaitTermination", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.shuffle.partitions"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            StreamingQuery q = this.spark().readStream().format("rate").load().writeStream().format("memory").queryName("test").start();
            long start = System.nanoTime();
            boolean terminated = q.awaitTermination(500L);
            long end = System.nanoTime();
            double $org_scalatest_assert_macro_left = (double)(end - start) / 1000000.0;
            int $org_scalatest_assert_macro_right = 500;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(terminated, "terminated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            q.stop();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute()), (Function0)(JFunction0.mcV.sp & Serializable)() -> q.awaitTermination(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("clusterBy", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.shuffle.partitions"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("DROP TABLE IF EXISTS my_table").collect();
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)ckpt -> {
                ClientStreamingQuerySuite.$anonfun$new$23(this, ckpt);
                return BoxedUnit.UNIT;
            });
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("throw exception in streaming", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Assertion assertion;
            try {
                SparkSession session = this.spark();
                UserDefinedFunction checkForTwo = functions$.MODULE$.udf((Function1)(JFunction1.mcII.sp & Serializable)value -> {
                    if (value == 2) {
                        throw new RuntimeException("Number 2 encountered!");
                    }
                    return value;
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
                StreamingQuery query = this.spark().readStream().format("rate").option("rowsPerSecond", "1").load().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{checkForTwo.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{session.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)})).as("checkedValue")})).writeStream().outputMode("append").format("console").start();
                StreamingQueryException exception = (StreamingQueryException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> query.awaitTermination(), ClassTag$.MODULE$.apply(StreamingQueryException.class), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
                String $org_scalatest_assert_macro_left = exception.getCondition();
                Object $org_scalatest_assert_macro_right = null;
                String string = $org_scalatest_assert_macro_left;
                Object var8_7 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, string == null ? var8_7 != null : !string.equals(var8_7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
                String $org_scalatest_assert_macro_left2 = (String)exception.getMessageParameters().get("id");
                String $org_scalatest_assert_macro_right2 = query.id().toString();
                String string2 = $org_scalatest_assert_macro_left2;
                String string3 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string2 != null ? !string2.equals(string3) : string3 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
                String $org_scalatest_assert_macro_left3 = (String)exception.getMessageParameters().get("runId");
                String $org_scalatest_assert_macro_right3 = query.runId().toString();
                String string4 = $org_scalatest_assert_macro_left3;
                String string5 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string4 != null ? !string4.equals(string5) : string5 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
                Throwable $org_scalatest_assert_macro_left4 = exception.getCause();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.SparkException", $org_scalatest_assert_macro_left4 instanceof SparkException, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
                Throwable $org_scalatest_assert_macro_left5 = exception.getCause().getCause();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.SparkException", $org_scalatest_assert_macro_left5 instanceof SparkException, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
                String $org_scalatest_assert_macro_left6 = exception.getCause().getCause().getMessage();
                String $org_scalatest_assert_macro_right4 = "java.lang.RuntimeException: Number 2 encountered!";
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
            }
            finally {
                this.spark().streams().resetTerminated();
            }
            return assertion;
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        this.test("throw exception in streaming, check with StreamingQueryManager", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SparkSession session = this.spark();
            UserDefinedFunction checkForTwo = functions$.MODULE$.udf((Function1)(JFunction1.mcII.sp & Serializable)value -> {
                if (value == 2) {
                    throw new RuntimeException("Number 2 encountered!");
                }
                return value;
            }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
            StreamingQuery query = this.spark().readStream().format("rate").option("rowsPerSecond", "1").load().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{checkForTwo.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{session.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)})).as("checkedValue")})).writeStream().outputMode("append").format("console").start();
            StreamingQueryException exception = (StreamingQueryException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().streams().awaitAnyTermination(), ClassTag$.MODULE$.apply(StreamingQueryException.class), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
            String $org_scalatest_assert_macro_left = exception.getCondition();
            Object $org_scalatest_assert_macro_right = null;
            String string = $org_scalatest_assert_macro_left;
            Object var8_7 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, string == null ? var8_7 != null : !string.equals(var8_7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
            String $org_scalatest_assert_macro_left2 = (String)exception.getMessageParameters().get("id");
            String $org_scalatest_assert_macro_right2 = query.id().toString();
            String string2 = $org_scalatest_assert_macro_left2;
            String string3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string2 != null ? !string2.equals(string3) : string3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
            String $org_scalatest_assert_macro_left3 = (String)exception.getMessageParameters().get("runId");
            String $org_scalatest_assert_macro_right3 = query.runId().toString();
            String string4 = $org_scalatest_assert_macro_left3;
            String string5 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string4 != null ? !string4.equals(string5) : string5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
            Throwable $org_scalatest_assert_macro_left4 = exception.getCause();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.SparkException", $org_scalatest_assert_macro_left4 instanceof SparkException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            Throwable $org_scalatest_assert_macro_left5 = exception.getCause().getCause();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.SparkException", $org_scalatest_assert_macro_left5 instanceof SparkException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            String $org_scalatest_assert_macro_left6 = exception.getCause().getCause().getMessage();
            String $org_scalatest_assert_macro_right4 = "java.lang.RuntimeException: Number 2 encountered!";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        this.test("foreach Row", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TestForeachWriter writer = new TestForeachWriter();
            org.apache.spark.sql.connect.Dataset df = this.spark().readStream().format("rate").option("rowsPerSecond", "10").load();
            StreamingQuery query = df.writeStream().foreach(writer).outputMode("update").start();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            Option $org_scalatest_assert_macro_left = query.exception();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            query.stop();
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        this.test("foreach Int", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            TestForeachWriter writer = new TestForeachWriter();
            org.apache.spark.sql.connect.Dataset df = this.spark().readStream().format("rate").option("rowsPerSecond", "10").load();
            StreamingQuery query = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(value AS INT)"})).as(session.implicits().newIntEncoder()).writeStream().foreach(writer).outputMode("update").start();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
            Option $org_scalatest_assert_macro_left = query.exception();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            query.stop();
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        this.test("foreach Custom class", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            TestForeachWriter writer = new TestForeachWriter();
            org.apache.spark.sql.connect.Dataset df = this.spark().readStream().format("rate").option("rowsPerSecond", "10").load();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientStreamingQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.connect.streaming.TestClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator5$1(ClientStreamingQuerySuite $outer) {
                }
            }
            StreamingQuery query = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(value AS INT)"})).as(session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator5$1(null)))).writeStream().foreach(writer).outputMode("update").start();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
            Option $org_scalatest_assert_macro_left = query.exception();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            query.stop();
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        this.test("streaming query manager", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool bool;
            Bool bool2;
            Bool bool3;
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.spark().streams().active());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
            StreamingQuery q = this.spark().readStream().format("rate").load().writeStream().format("console").start();
            String $org_scalatest_assert_macro_left2 = q.name();
            Object $org_scalatest_assert_macro_right = null;
            String string = $org_scalatest_assert_macro_left2;
            Object var7_6 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string != null ? !string.equals(var7_6) : var7_6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
            StreamingQuery q1 = this.spark().streams().get(q.id());
            StreamingQuery q2 = this.spark().streams().active()[0];
            UUID $org_scalatest_assert_macro_left3 = q.id();
            UUID $org_scalatest_assert_macro_right2 = q1.id();
            UUID uUID = $org_scalatest_assert_macro_left3;
            UUID uUID2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                UUID $org_scalatest_assert_macro_left5 = q.id();
                UUID $org_scalatest_assert_macro_right3 = q2.id();
                UUID uUID3 = $org_scalatest_assert_macro_left5;
                UUID uUID4 = $org_scalatest_assert_macro_right3;
                bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(uUID3 != null ? !((Object)uUID3).equals(uUID4) : uUID4 != null), Prettifier$.MODULE$.default());
            } else {
                bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right4 = bool3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
            UUID $org_scalatest_assert_macro_left6 = q.runId();
            UUID $org_scalatest_assert_macro_right5 = q1.runId();
            UUID uUID5 = $org_scalatest_assert_macro_left6;
            UUID uUID6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(uUID5 != null ? !((Object)uUID5).equals(uUID6) : uUID6 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left7.value()) {
                UUID $org_scalatest_assert_macro_left8 = q.runId();
                UUID $org_scalatest_assert_macro_right6 = q2.runId();
                UUID uUID7 = $org_scalatest_assert_macro_left8;
                UUID uUID8 = $org_scalatest_assert_macro_right6;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(uUID7 != null ? !((Object)uUID7).equals(uUID8) : uUID8 != null), Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right7 = bool2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
            String $org_scalatest_assert_macro_left9 = q1.name();
            Object $org_scalatest_assert_macro_right8 = null;
            String string2 = $org_scalatest_assert_macro_left9;
            Object var32_30 = null;
            Bool $org_scalatest_assert_macro_left10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", null, !(string2 != null ? !string2.equals(var32_30) : var32_30 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left10.value()) {
                String $org_scalatest_assert_macro_left11 = q2.name();
                Object $org_scalatest_assert_macro_right9 = null;
                String string3 = $org_scalatest_assert_macro_left11;
                Object var36_34 = null;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", null, !(string3 != null ? !string3.equals(var36_34) : var36_34 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right10 = bool;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "&&", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
            this.spark().streams().resetTerminated();
            long start = System.nanoTime();
            boolean terminated = this.spark().streams().awaitAnyTermination(2600L);
            long end = System.nanoTime();
            long $org_scalatest_assert_macro_left12 = end - start;
            long $org_scalatest_assert_macro_right11 = TimeUnit.MILLISECONDS.toNanos(2000L);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), ">=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12 >= $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(terminated, "terminated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
            q.stop();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(q1.isActive(), "q1.isActive", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
            StreamingQuery $org_scalatest_assert_macro_left13 = this.spark().streams().get(q.id());
            Object $org_scalatest_assert_macro_right12 = null;
            StreamingQuery streamingQuery = $org_scalatest_assert_macro_left13;
            Object var52_47 = null;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", null, !(streamingQuery != null ? !streamingQuery.equals(var52_47) : var52_47 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        this.test("streaming query listener", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.testStreamingQueryListener(new EventCollectorV1(this), "_v1");
            this.testStreamingQueryListener(new EventCollectorV2(this), "_v2");
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        this.test("listener events", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Object object;
            MyListener listener = new MyListener();
            this.spark().streams().addListener((StreamingQueryListener)listener);
            StreamingQuery q = this.spark().readStream().format("rate").load().writeStream().format("console").start();
            try {
                q.processAllAvailable();
                object = Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.isActive(), "q.isActive", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
                    Seq<String> $org_scalatest_assert_macro_left = listener.start();
                    int $org_scalatest_assert_macro_right = 1;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
                    Seq<String> $org_scalatest_assert_macro_left2 = listener.progress();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            }
            finally {
                q.stop();
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).seconds()), (Function0 & Serializable)() -> {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(q.isActive(), "q.isActive", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
                    Seq<String> $org_scalatest_assert_macro_left = listener.terminate();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
                }, Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
            }
            return object;
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        this.test("foreachBatch with DataFrame", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String viewName = "test_view";
            String tableName = "global_temp." + viewName;
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                StreamingQuery q = this.spark().readStream().format("rate").option("rowsPerSecond", "10").option("numPartitions", "1").load().writeStream().foreachBatch((Function2 & Serializable)(df, batchId) -> {
                    ClientStreamingQuerySuite.$anonfun$new$45(viewName, df, BoxesRunTime.unboxToLong((Object)batchId));
                    return BoxedUnit.UNIT;
                }).start();
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                    StreamingQueryProgress $org_scalatest_assert_macro_left = q.lastProgress();
                    Object $org_scalatest_assert_macro_right = null;
                    StreamingQueryProgress streamingQueryProgress = $org_scalatest_assert_macro_left;
                    Object var4_3 = null;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingQueryProgress == null ? var4_3 != null : !streamingQueryProgress.equals(var4_3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Failed to make progress", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
                    long $org_scalatest_assert_macro_left2 = q.lastProgress().numInputRows();
                    int $org_scalatest_assert_macro_right2 = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Seq rows = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql("select * from " + tableName).collect()));
                    int $org_scalatest_assert_macro_left = rows.size();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
                    long $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)rows.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getLong(1)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    int $org_scalatest_assert_macro_right2 = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Rows in " + tableName + ": " + rows);
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
                q.stop();
            });
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        this.test("foreachBatch with Dataset[java.lang.Long]", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String viewName = "test_view";
            String tableName = "global_temp." + viewName;
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = this.spark();
                StreamingQuery q = this.spark().readStream().format("rate").option("rowsPerSecond", "10").option("numPartitions", "1").load().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{session.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)})).as(session.implicits().newBoxedLongEncoder()).writeStream().foreachBatch((Function2 & Serializable)(ds, batchId) -> {
                    ClientStreamingQuerySuite.$anonfun$new$53(viewName, ds, BoxesRunTime.unboxToLong((Object)batchId));
                    return BoxedUnit.UNIT;
                }).start();
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                    StreamingQueryProgress $org_scalatest_assert_macro_left = q.lastProgress();
                    Object $org_scalatest_assert_macro_right = null;
                    StreamingQueryProgress streamingQueryProgress = $org_scalatest_assert_macro_left;
                    Object var4_3 = null;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingQueryProgress == null ? var4_3 != null : !streamingQueryProgress.equals(var4_3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Failed to make progress", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
                    long $org_scalatest_assert_macro_left2 = q.lastProgress().numInputRows();
                    int $org_scalatest_assert_macro_right2 = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Seq rows = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql("select * from " + tableName).collect()));
                    int $org_scalatest_assert_macro_left = rows.size();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
                    long $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)rows.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getLong(1)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    int $org_scalatest_assert_macro_right2 = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Rows in " + tableName + ": " + rows);
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
                q.stop();
            });
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
        this.test("foreachBatch with Dataset[TestClass]", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            String viewName = "test_view";
            String tableName = "global_temp." + viewName;
            org.apache.spark.sql.connect.Dataset df = this.spark().readStream().format("rate").option("rowsPerSecond", "10").load();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientStreamingQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.connect.streaming.TestClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator16$1(ClientStreamingQuerySuite $outer) {
                }
            }
            StreamingQuery q = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(value AS INT)"})).as(session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$$typecreator16$1(null)))).writeStream().foreachBatch((Function2 & Serializable)(ds, batchId) -> {
                count = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ds.collect()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.value()), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                return BoxedUnit.UNIT;
            }).start();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.isActive(), "q.isActive", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
                Option $org_scalatest_assert_macro_left = q.exception();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
            q.stop();
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
        Statics.releaseFence();
    }

    public abstract class EventCollector
    extends StreamingQueryListener {
        public abstract String tablePostfix();

        public void handleOnQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EventCollector.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$1(EventCollector $outer) {
                }
            }
            org.apache.spark.sql.connect.Dataset df = this.org$apache$spark$sql$connect$streaming$ClientStreamingQuerySuite$EventCollector$$$outer().spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)event.json(), (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$1(null)));
            df.write().mode("append").saveAsTable("listener_start_events" + this.tablePostfix());
        }

        public void handleOnQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EventCollector.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$2(EventCollector $outer) {
                }
            }
            org.apache.spark.sql.connect.Dataset df = this.org$apache$spark$sql$connect$streaming$ClientStreamingQuerySuite$EventCollector$$$outer().spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)event.json(), (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$2(null)));
            df.write().mode("append").saveAsTable("listener_progress_events" + this.tablePostfix());
        }

        public void handleOnQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EventCollector.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$3(EventCollector $outer) {
                }
            }
            org.apache.spark.sql.connect.Dataset df = this.org$apache$spark$sql$connect$streaming$ClientStreamingQuerySuite$EventCollector$$$outer().spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)event.json(), (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_streaming_ClientStreamingQuerySuite$EventCollector$$typecreator1$3(null)));
            df.write().mode("append").saveAsTable("listener_terminated_events" + this.tablePostfix());
        }

        public /* synthetic */ ClientStreamingQuerySuite org$apache$spark$sql$connect$streaming$ClientStreamingQuerySuite$EventCollector$$$outer() {
            return ClientStreamingQuerySuite.this;
        }

        public EventCollector() {
            if (ClientStreamingQuerySuite.this == null) {
                throw null;
            }
        }
    }

    public class EventCollectorV1
    extends EventCollector {
        @Override
        public String tablePostfix() {
            return "_v1";
        }

        public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
            this.handleOnQueryStarted(event);
        }

        public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
            this.handleOnQueryProgress(event);
        }

        public void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
            this.handleOnQueryTerminated(event);
        }

        public /* synthetic */ ClientStreamingQuerySuite org$apache$spark$sql$connect$streaming$ClientStreamingQuerySuite$EventCollectorV1$$$outer() {
            return this.$outer;
        }

        public EventCollectorV1(ClientStreamingQuerySuite $outer) {
        }
    }

    public class EventCollectorV2
    extends EventCollector {
        @Override
        public String tablePostfix() {
            return "_v2";
        }

        public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
            this.handleOnQueryStarted(event);
        }

        public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
            this.handleOnQueryProgress(event);
        }

        public void onQueryIdle(StreamingQueryListener.QueryIdleEvent event) {
        }

        public void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
            this.handleOnQueryTerminated(event);
        }

        public /* synthetic */ ClientStreamingQuerySuite org$apache$spark$sql$connect$streaming$ClientStreamingQuerySuite$EventCollectorV2$$$outer() {
            return this.$outer;
        }

        public EventCollectorV2(ClientStreamingQuerySuite $outer) {
        }
    }

    public class MyListener
    extends StreamingQueryListener {
        private Seq<String> start;
        private Seq<String> progress;
        private Seq<String> terminate;

        public Seq<String> start() {
            return this.start;
        }

        public void start_$eq(Seq<String> x$1) {
            this.start = x$1;
        }

        public Seq<String> progress() {
            return this.progress;
        }

        public void progress_$eq(Seq<String> x$1) {
            this.progress = x$1;
        }

        public Seq<String> terminate() {
            return this.terminate;
        }

        public void terminate_$eq(Seq<String> x$1) {
            this.terminate = x$1;
        }

        public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
            this.start_$eq((Seq<String>)((Seq)this.start().$colon$plus((Object)event.json())));
        }

        public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
            this.progress_$eq((Seq<String>)((Seq)this.progress().$colon$plus((Object)event.json())));
        }

        public void onQueryIdle(StreamingQueryListener.QueryIdleEvent event) {
        }

        public void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
            this.terminate_$eq((Seq<String>)((Seq)this.terminate().$colon$plus((Object)event.json())));
        }

        public /* synthetic */ ClientStreamingQuerySuite org$apache$spark$sql$connect$streaming$ClientStreamingQuerySuite$MyListener$$$outer() {
            return ClientStreamingQuerySuite.this;
        }

        public MyListener() {
            if (ClientStreamingQuerySuite.this == null) {
                throw null;
            }
            this.start = (Seq)scala.package$.MODULE$.Seq().empty();
            this.progress = (Seq)scala.package$.MODULE$.Seq().empty();
            this.terminate = (Seq)scala.package$.MODULE$.Seq().empty();
        }
    }
}

