/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Random;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.connect.ClientDataFrameStatSuite$;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.apache.spark.sql.connect.test.RemoteSparkSession;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.CountMinSketch;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.matchers.must.Matchers$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005a3A\u0001B\u0003\u0001!!)!\u0005\u0001C\u0001G!)a\u0005\u0001C\u0005O!)1\b\u0001C\u0005y\tA2\t\\5f]R$\u0015\r^1Ge\u0006lWm\u0015;biN+\u0018\u000e^3\u000b\u0005\u00199\u0011aB2p]:,7\r\u001e\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0005\u0001EIr\u0004\u0005\u0002\u0013/5\t1C\u0003\u0002\u0015+\u0005Aa-\u001e8tk&$XM\u0003\u0002\u0017\u001b\u0005I1oY1mCR,7\u000f^\u0005\u00031M\u00111\"\u00118z\rVt7+^5uKB\u0011!$H\u0007\u00027)\u0011A$B\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001f7\ty1i\u001c8oK\u000e$h)\u001e8Tk&$X\r\u0005\u0002\u001bA%\u0011\u0011e\u0007\u0002\u0013%\u0016lw\u000e^3Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002\u000b\u0005AAo\u001c'fiR,'\u000f\u0006\u0002)kA\u0011\u0011F\r\b\u0003UA\u0002\"a\u000b\u0018\u000e\u00031R!!L\b\u0002\rq\u0012xn\u001c;?\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Er\u0003\"\u0002\u001c\u0003\u0001\u00049\u0014!A5\u0011\u0005aJT\"\u0001\u0018\n\u0005ir#aA%oi\u0006\u00012\r[3dW\ncwn\\7GS2$XM\u001d\u000b\u0005{\u0001s\u0005\u000b\u0005\u00029}%\u0011qH\f\u0002\u0005+:LG\u000fC\u0003B\u0007\u0001\u0007!)\u0001\u0003eCR\f\u0007cA\"I\u0017:\u0011AI\u0012\b\u0003W\u0015K\u0011aL\u0005\u0003\u000f:\nq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\n\u00191+Z9\u000b\u0005\u001ds\u0003C\u0001\u001dM\u0013\tieFA\u0002B]fDQaT\u0002A\u0002\t\u000b\u0001C\\8u\u0007>tG/Y5o-\u0006dW/Z:\t\u000bE\u001b\u0001\u0019\u0001*\u0002\u0005\u00114\u0007CA*V\u001d\t)C+\u0003\u0002H\u000b%\u0011ak\u0016\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!aR\u0003")
public class ClientDataFrameStatSuite
extends AnyFunSuite
implements ConnectFunSuite,
RemoteSparkSession {
    private SparkSession spark;
    private int serverPort;
    private boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$test$RemoteSparkSession$$super$ignore(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.ignore$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void beforeAll() {
        RemoteSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        RemoteSparkSession.afterAll$(this);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        RemoteSparkSession.test$(this, testName, testTags, testFun, pos);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private int serverPort$lzycompute() {
        ClientDataFrameStatSuite clientDataFrameStatSuite = this;
        synchronized (clientDataFrameStatSuite) {
            if (!this.bitmap$0) {
                this.serverPort = RemoteSparkSession.serverPort$(this);
                this.bitmap$0 = true;
            }
        }
        return this.serverPort;
    }

    @Override
    public int serverPort() {
        if (!this.bitmap$0) {
            return this.serverPort$lzycompute();
        }
        return this.serverPort;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private String toLetter(int i) {
        return Character.toString((char)(i + 97));
    }

    private void checkBloomFilter(Seq<Object> data, Seq<Object> notContainValues, Dataset<Row> df) {
        BloomFilter filter1 = df.stat().bloomFilter("id", 1000L, 0.03);
        double $org_scalatest_assert_macro_left = filter1.expectedFpp() - 0.03;
        double $org_scalatest_assert_macro_right = 0.001;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(data.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter1.mightContain(x$1))), "data.forall(((x$1: Object) => filter1.mightContain(x$1)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(notContainValues.forall((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)ClientDataFrameStatSuite.$anonfun$checkBloomFilter$2(filter1, n))), "notContainValues.forall(((n: Any) => filter1.mightContain(n).unary_!))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        BloomFilter filter2 = df.stat().bloomFilter("id", 1000L, 320L);
        long $org_scalatest_assert_macro_left2 = filter2.bitSize();
        int $org_scalatest_assert_macro_right2 = 320;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(data.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter2.mightContain(x$1))), "data.forall(((x$1: Object) => filter2.mightContain(x$1)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(notContainValues.forall((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)ClientDataFrameStatSuite.$anonfun$checkBloomFilter$4(filter2, n))), "notContainValues.forall(((n: Any) => filter2.mightContain(n).unary_!))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$2(int i) {
        return new Tuple2.mcID.sp(i, 2.0 * (double)i);
    }

    public static final /* synthetic */ Assertion $anonfun$new$3(Dataset df$1, double q1$1, double q2$1, int n$1, double epsilon) {
        Object object;
        double ms2;
        double ms1;
        double errorDouble;
        double errorSingle;
        block8: {
            double[][] dArray;
            block7: {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                double[] dArray2 = df$1.stat().approxQuantile("singles", new double[]{q1$1}, epsilon);
                if (dArray2 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object7 = Array$.MODULE$.unapplySeq((Object)dArray2)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object7)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object7), 1) != 0) {
                    throw new MatchError((Object)dArray2);
                }
                double single1 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object7), 0));
                double single12 = single1;
                double[] dArray3 = df$1.stat().approxQuantile("doubles", new double[]{q2$1}, epsilon);
                if (dArray3 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object6 = Array$.MODULE$.unapplySeq((Object)dArray3)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object6)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object6), 1) != 0) {
                    throw new MatchError((Object)dArray3);
                }
                double double2 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object6), 0));
                double double22 = double2;
                double[] dArray4 = df$1.stat().approxQuantile("doubles", new double[]{q1$1, q2$1}, epsilon);
                if (dArray4 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object5 = Array$.MODULE$.unapplySeq((Object)dArray4)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object5)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object5), 2) != 0) {
                    throw new MatchError((Object)dArray4);
                }
                double d1 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object5), 0));
                double d2 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object5), 1));
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d1, d2);
                double d12 = sp2._1$mcD$sp();
                double d22 = sp2._2$mcD$sp();
                double[] dArray5 = df$1.stat().approxQuantile("singles", new double[]{q1$1, q2$1}, epsilon);
                if (dArray5 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object4 = Array$.MODULE$.unapplySeq((Object)dArray5)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object4)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object4), 2) != 0) {
                    throw new MatchError((Object)dArray5);
                }
                double s1 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object4), 0));
                double s2 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object4), 1));
                Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(s1, s2);
                double s12 = sp3._1$mcD$sp();
                double s22 = sp3._2$mcD$sp();
                errorSingle = (double)1000 * epsilon;
                errorDouble = 2.0 * errorSingle;
                double $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(single12 - q1$1 * (double)n$1);
                double $org_scalatest_assert_macro_right = errorSingle;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
                double $org_scalatest_assert_macro_left2 = scala.math.package$.MODULE$.abs(double22 - (double)2 * q2$1 * (double)n$1);
                double $org_scalatest_assert_macro_right2 = errorDouble;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
                double $org_scalatest_assert_macro_left3 = scala.math.package$.MODULE$.abs(s12 - q1$1 * (double)n$1);
                double $org_scalatest_assert_macro_right3 = errorSingle;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
                double $org_scalatest_assert_macro_left4 = scala.math.package$.MODULE$.abs(s22 - q2$1 * (double)n$1);
                double $org_scalatest_assert_macro_right4 = errorSingle;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 <= $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
                double $org_scalatest_assert_macro_left5 = scala.math.package$.MODULE$.abs(d12 - (double)2 * q1$1 * (double)n$1);
                double $org_scalatest_assert_macro_right5 = errorDouble;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 <= $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
                double $org_scalatest_assert_macro_left6 = scala.math.package$.MODULE$.abs(d22 - (double)2 * q2$1 * (double)n$1);
                double $org_scalatest_assert_macro_right6 = errorDouble;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 <= $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
                dArray = df$1.stat().approxQuantile((String[])((Object[])new String[]{"singles", "doubles"}), new double[]{q1$1, q2$1}, epsilon);
                if (dArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object3 = Array$.MODULE$.unapplySeq((Object)dArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 2) != 0) break block7;
                double[] dArray6 = (double[])Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 0);
                double[] dArray7 = (double[])Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 1);
                if (dArray6 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)dArray6)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) != 0) break block7;
                ms1 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0));
                ms2 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1));
                if (dArray7 != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)dArray7)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) break block8;
            }
            throw new MatchError((Object)dArray);
        }
        double md1 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
        double md2 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)ms1), (Object)BoxesRunTime.boxToDouble((double)ms2), (Object)BoxesRunTime.boxToDouble((double)md1), (Object)BoxesRunTime.boxToDouble((double)md2));
        double ms12 = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double ms22 = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double md12 = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double md22 = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        double $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(ms12 - q1$1 * (double)n$1);
        double $org_scalatest_assert_macro_right = errorSingle;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        double $org_scalatest_assert_macro_left7 = scala.math.package$.MODULE$.abs(ms22 - q2$1 * (double)n$1);
        double $org_scalatest_assert_macro_right7 = errorSingle;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 <= $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        double $org_scalatest_assert_macro_left8 = scala.math.package$.MODULE$.abs(md12 - (double)2 * q1$1 * (double)n$1);
        double $org_scalatest_assert_macro_right8 = errorDouble;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 <= $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        double $org_scalatest_assert_macro_left9 = scala.math.package$.MODULE$.abs(md22 - (double)2 * q2$1 * (double)n$1);
        double $org_scalatest_assert_macro_right9 = errorDouble;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 <= $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$7(ClientDataFrameStatSuite $this, int i) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToDouble((double)(2.0 * (double)i)), (Object)$this.toLetter(i));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$9(int i) {
        return new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(i % 3), (Object)scala.package$.MODULE$.BigDecimal().apply(i % 2));
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$11(int i) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(2 * i)), (Object)BoxesRunTime.boxToDouble((double)((double)i * -1.0)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$12(int x) {
        return new Tuple2.mcID.sp(x, (double)(x * x - 2 * x) + 3.5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$14(Random rng$1, int x$4) {
        return new Tuple2.mcII.sp(rng$1.nextInt(5), rng$1.nextInt(10));
    }

    public static final /* synthetic */ Assertion $anonfun$new$19(ClientDataFrameStatSuite $this, String[] columnNames$1, Row row$1, Map expected$1, int i$1, int col) {
        int j = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(columnNames$1[col]));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)row$1.getLong(col)));
        long $org_scalatest_assert_macro_right = BoxesRunTime.unboxToInt((Object)expected$1.getOrElse((Object)new Tuple2.mcII.sp(i$1, j), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }

    public static final /* synthetic */ void $anonfun$new$18(ClientDataFrameStatSuite $this, String[] columnNames$1, Map expected$1, Row row) {
        int i = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(row.getString(0)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), columnNames$1.length).foreach((Function1 & Serializable)col -> ClientDataFrameStatSuite.$anonfun$new$19($this, columnNames$1, row, expected$1, i, BoxesRunTime.unboxToInt((Object)col)));
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$22(ClientDataFrameStatSuite $this, int i) {
        if (i % 3 == 0) {
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)$this.toLetter(1), (Object)BoxesRunTime.boxToDouble((double)-1.0));
        }
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)$this.toLetter(i), (Object)BoxesRunTime.boxToDouble((double)((double)i * -1.0)));
    }

    public static final /* synthetic */ short $anonfun$new$30(int x$9) {
        return (short)x$9;
    }

    public static final /* synthetic */ short $anonfun$new$31(int x$10) {
        return (short)x$10;
    }

    public static final /* synthetic */ byte $anonfun$new$33(int x$11) {
        return (byte)x$11;
    }

    public static final /* synthetic */ byte $anonfun$new$34(int x$12) {
        return (byte)x$12;
    }

    public static final /* synthetic */ String $anonfun$new$36(int x$13) {
        return Integer.toString(x$13);
    }

    public static final /* synthetic */ String $anonfun$new$37(int x$14) {
        return Integer.toString(x$14);
    }

    public static final /* synthetic */ boolean $anonfun$checkBloomFilter$2(BloomFilter filter1$1, Object n) {
        return !filter1$1.mightContain(n);
    }

    public static final /* synthetic */ boolean $anonfun$checkBloomFilter$4(BloomFilter filter2$1, Object n) {
        return !filter2$1.mightContain(n);
    }

    public ClientDataFrameStatSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        RemoteSparkSession.$init$(this);
        this.test("approxQuantile", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SparkSession session = this.spark();
            int n = 1000;
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientDataFrameStatSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator10$1(ClientDataFrameStatSuite $outer) {
                }
            }
            Dataset df = session.implicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().tabulate(n + 1, (Function1 & Serializable)i -> ClientDataFrameStatSuite.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)i))), session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"singles", "doubles"}));
            double q1 = 0.5;
            double q2 = 0.8;
            List epsilons = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.1, 0.05, 0.001}));
            epsilons.foreach((Function1 & Serializable)epsilon -> ClientDataFrameStatSuite.$anonfun$new$3(df, q1, q2, n, BoxesRunTime.unboxToDouble((Object)epsilon)));
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> df.stat().approxQuantile((String[])((Object[])new String[]{"singles", "doubles"}), new double[]{q1, q2, -0.1}, BoxesRunTime.unboxToDouble((Object)epsilons.head())), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "percentile should be in the range [0.0, 1.0]";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            IllegalArgumentException e2 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> df.stat().approxQuantile((String[])((Object[])new String[]{"singles", "doubles"}), new double[]{q1, q2}, -1.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Relative Error must be non-negative";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("covariance", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SparkSession session = this.spark();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientDataFrameStatSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator20$1(ClientDataFrameStatSuite $outer) {
                }
            }
            Dataset df = session.implicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().tabulate(10, (Function1 & Serializable)i -> ClientDataFrameStatSuite.$anonfun$new$7(this, BoxesRunTime.unboxToInt((Object)i))), session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"singles", "doubles", "letters"}));
            double results = df.stat().cov("singles", "doubles");
            double $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(results - 18.333333333333332);
            double $org_scalatest_assert_macro_right = 1.0E-12;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            this.intercept((Function0)(JFunction0.mcD.sp & Serializable)() -> df.stat().cov("singles", "letters"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ClientDataFrameStatSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.math.BigDecimal").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.math.BigDecimal").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator30$1(ClientDataFrameStatSuite $outer) {
                }
            }
            Dataset decimalData = session.implicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().tabulate(6, (Function1 & Serializable)i -> ClientDataFrameStatSuite.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)i))), session.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            double decimalRes = decimalData.stat().cov("a", "b");
            double $org_scalatest_assert_macro_left2 = scala.math.package$.MODULE$.abs(decimalRes);
            double $org_scalatest_assert_macro_right2 = 1.0E-12;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("correlation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SparkSession session = this.spark();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientDataFrameStatSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator40$1(ClientDataFrameStatSuite $outer) {
                }
            }
            Dataset df = session.implicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().tabulate(10, (Function1 & Serializable)i -> ClientDataFrameStatSuite.$anonfun$new$11(BoxesRunTime.unboxToInt((Object)i))), session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator40$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
            double corr1 = df.stat().corr("a", "b", "pearson");
            double $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(corr1 - 1.0);
            double $org_scalatest_assert_macro_right = 1.0E-12;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            double corr2 = df.stat().corr("a", "c", "pearson");
            double $org_scalatest_assert_macro_left2 = scala.math.package$.MODULE$.abs(corr2 + 1.0);
            double $org_scalatest_assert_macro_right2 = 1.0E-12;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ClientDataFrameStatSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator50$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator50$1(ClientDataFrameStatSuite $outer) {
                }
            }
            Dataset df2 = session.implicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().tabulate(20, (Function1 & Serializable)x -> ClientDataFrameStatSuite.$anonfun$new$12(BoxesRunTime.unboxToInt((Object)x))), session.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator50$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            double corr3 = df2.stat().corr("a", "b", "pearson");
            double $org_scalatest_assert_macro_left3 = scala.math.package$.MODULE$.abs(corr3 - 0.9572339139475857);
            double $org_scalatest_assert_macro_right3 = 1.0E-12;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("crosstab", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            Random rng = new Random();
            Seq data = (Seq)scala.package$.MODULE$.Seq().tabulate(25, (Function1 & Serializable)x$4 -> ClientDataFrameStatSuite.$anonfun$new$14(rng, BoxesRunTime.unboxToInt((Object)x$4)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientDataFrameStatSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator60$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator60$1(ClientDataFrameStatSuite $outer) {
                }
            }
            Dataset df = session.implicits().localSeqToDatasetHolder(data, session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator60$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            Dataset crosstab = df.stat().crosstab("a", "b");
            String[] columnNames = crosstab.schema().fieldNames();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(columnNames[0]);
            String $org_scalatest_assert_macro_right = "a_b";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            Map expected = (Map)((IterableOps)data.map((Function1 & Serializable)t -> new Tuple2(t, (Object)BoxesRunTime.boxToInteger((int)1)))).groupBy((Function1 & Serializable)x$5 -> (Tuple2)x$5._1()).transform((Function2 & Serializable)(x$6, v) -> BoxesRunTime.boxToInteger((int)v.length()));
            Row[] rows = (Row[])crosstab.collect();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])rows), (Function1 & Serializable)row -> {
                ClientDataFrameStatSuite.$anonfun$new$18(this, columnNames, expected, row);
                return BoxedUnit.UNIT;
            });
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("freqItems", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SparkSession session = this.spark();
            Seq rows = (Seq)scala.package$.MODULE$.Seq().tabulate(1000, (Function1 & Serializable)i -> ClientDataFrameStatSuite.$anonfun$new$22(this, BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClientDataFrameStatSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator70$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator70$1(ClientDataFrameStatSuite $outer) {
                }
            }
            Dataset df = session.implicits().localSeqToDatasetHolder(rows, session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_ClientDataFrameStatSuite$$typecreator70$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numbers", "letters", "negDoubles"}));
            Dataset results = df.stat().freqItems((String[])((Object[])new String[]{"numbers", "letters"}), 0.1);
            Row items = (Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])results.collect()));
            Seq $org_scalatest_assert_macro_left = items.getSeq(0);
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            Seq $org_scalatest_assert_macro_left2 = items.getSeq(1);
            String $org_scalatest_assert_macro_right2 = this.toLetter(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Dataset singleColResults = df.stat().freqItems((String[])((Object[])new String[]{"negDoubles"}), 0.1);
            Row items2 = (Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])singleColResults.collect()));
            Seq $org_scalatest_assert_macro_left3 = items2.getSeq(0);
            double $org_scalatest_assert_macro_right3 = -1.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("sampleBy", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Row[] rows;
            SparkSession session = this.spark();
            Dataset df = session.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Alice", (List)new .colon.colon((Object)"Nico", (List)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Alice", (List)Nil$.MODULE$))))), session.implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}));
            Map fractions = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Alice"), (Object)BoxesRunTime.boxToDouble((double)0.3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Nico"), (Object)BoxesRunTime.boxToDouble((double)1.0))}));
            Dataset sampled = df.stat().sampleBy("name", fractions, 36L);
            Row[] $org_scalatest_assert_macro_left = rows = (Row[])sampled.groupBy("name", (Seq)Nil$.MODULE$).count().orderBy("name", (Seq)Nil$.MODULE$).collect();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            Row row0 = rows[0];
            String $org_scalatest_assert_macro_left2 = row0.getString(0);
            String $org_scalatest_assert_macro_right2 = "Nico";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            long $org_scalatest_assert_macro_left3 = row0.getLong(1);
            long $org_scalatest_assert_macro_right3 = 1L;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("countMinSketch", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Dataset df = this.spark().range(1000L);
            CountMinSketch sketch1 = df.stat().countMinSketch("id", 10, 20, 42);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)sketch1.totalCount()));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sketch1.depth()));
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sketch1.width()));
            int $org_scalatest_assert_macro_right3 = 20;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            CountMinSketch sketch = df.stat().countMinSketch("id", 0.001, 0.99, 42);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)sketch.totalCount()));
            int $org_scalatest_assert_macro_right4 = 1000;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sketch.relativeError()));
            double $org_scalatest_assert_macro_right5 = 0.001;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sketch.confidence()));
            TripleEqualsSupport.Spread $org_scalatest_assert_macro_right6 = Matchers$.MODULE$.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToDouble((double)0.99), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)0.005));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("Bloom filter -- Long Column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            Seq data = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-143, -32, -5, 1, 17, 39, 43, 101, 127, 997})).map((Function1)(JFunction1.mcJI.sp & Serializable)x$7 -> x$7);
            Dataset df = session.implicits().localSeqToDatasetHolder(data, session.implicits().newLongEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Seq negativeValues = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-11, 1021, Short.MAX_VALUE})).map((Function1)(JFunction1.mcJI.sp & Serializable)x$8 -> x$8);
            this.checkBloomFilter((Seq<Object>)data, (Seq<Object>)negativeValues, (Dataset<Row>)df);
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("Bloom filter -- Int Column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            Seq data = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-143, -32, -5, 1, 17, 39, 43, 101, 127, 997}));
            Dataset df = session.implicits().localSeqToDatasetHolder(data, session.implicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Seq negativeValues = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-11, 1021, Short.MAX_VALUE}));
            this.checkBloomFilter((Seq<Object>)data, (Seq<Object>)negativeValues, (Dataset<Row>)df);
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("Bloom filter -- Short Column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            Seq data = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-143, -32, -5, 1, 17, 39, 43, 101, 127, 997})).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToShort((short)ClientDataFrameStatSuite.$anonfun$new$30(BoxesRunTime.unboxToInt((Object)x$9))));
            Dataset df = session.implicits().localSeqToDatasetHolder(data, session.implicits().newShortEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Seq negativeValues = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-11, 1021, Short.MAX_VALUE})).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToShort((short)ClientDataFrameStatSuite.$anonfun$new$31(BoxesRunTime.unboxToInt((Object)x$10))));
            this.checkBloomFilter((Seq<Object>)data, (Seq<Object>)negativeValues, (Dataset<Row>)df);
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("Bloom filter -- Byte Column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            Seq data = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-32, -5, 1, 17, 39, 43, 101, 127})).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToByte((byte)ClientDataFrameStatSuite.$anonfun$new$33(BoxesRunTime.unboxToInt((Object)x$11))));
            Dataset df = session.implicits().localSeqToDatasetHolder(data, session.implicits().newByteEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Seq negativeValues = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-101, 55, 113})).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToByte((byte)ClientDataFrameStatSuite.$anonfun$new$34(BoxesRunTime.unboxToInt((Object)x$12))));
            this.checkBloomFilter((Seq<Object>)data, (Seq<Object>)negativeValues, (Dataset<Row>)df);
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("Bloom filter -- String Column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            Seq data = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-143, -32, -5, 1, 17, 39, 43, 101, 127, 997})).map((Function1 & Serializable)x$13 -> ClientDataFrameStatSuite.$anonfun$new$36(BoxesRunTime.unboxToInt((Object)x$13)));
            Dataset df = session.implicits().localSeqToDatasetHolder(data, session.implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Seq negativeValues = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-11, 1021, Short.MAX_VALUE})).map((Function1 & Serializable)x$14 -> ClientDataFrameStatSuite.$anonfun$new$37(BoxesRunTime.unboxToInt((Object)x$14)));
            this.checkBloomFilter((Seq<Object>)data, (Seq<Object>)negativeValues, (Dataset<Row>)df);
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("Bloom filter -- Wrong dataType Column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String message;
            SparkSession session = this.spark();
            IndexedSeq data = scala.package$.MODULE$.Range().apply(0, 1000).map((Function1)(JFunction1.mcDI.sp & Serializable)x$15 -> x$15);
            String $org_scalatest_assert_macro_left = message = ((AnalysisException)this.intercept((Function0 & Serializable)() -> session.implicits().localSeqToDatasetHolder((Seq)data, session.implicits().newDoubleEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).stat().bloomFilter("id", 1000L, 0.03), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244))).getMessage();
            String $org_scalatest_assert_macro_right = "DATATYPE_MISMATCH.BLOOM_FILTER_WRONG_TYPE";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("Bloom filter test invalid inputs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Dataset df = this.spark().range(1000L).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            AnalysisException error1 = (AnalysisException)this.intercept((Function0 & Serializable)() -> df.stat().bloomFilter("id", -1000L, 100L), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(error1.getCondition());
            String $org_scalatest_assert_macro_right = "DATATYPE_MISMATCH.VALUE_OUT_OF_RANGE";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            AnalysisException error2 = (AnalysisException)this.intercept((Function0 & Serializable)() -> df.stat().bloomFilter("id", 1000L, -100L), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(error2.getCondition());
            String $org_scalatest_assert_macro_right2 = "DATATYPE_MISMATCH.VALUE_OUT_OF_RANGE";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            AnalysisException error3 = (AnalysisException)this.intercept((Function0 & Serializable)() -> df.stat().bloomFilter("id", 1000L, -1.0), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(error3.getCondition());
            String $org_scalatest_assert_macro_right3 = "DATATYPE_MISMATCH.VALUE_OUT_OF_RANGE";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("SPARK-49961: transform type should be consistent", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SparkSession session = this.spark();
            Dataset ds = session.implicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), session.implicits().newIntEncoder()).toDS();
            Function1 & Serializable f = (Function1 & Serializable)d -> d.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(value + 1) value"})).as(session.implicits().newIntEncoder());
            Dataset transformed = (Dataset)ds.transform((Function1)f);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.intArrayOps((int[])transformed.collect()), (Ordering)Ordering.Int$.MODULE$));
            int[] $org_scalatest_assert_macro_right = new int[]{2, 3};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        }, new Position("ClientDataFrameStatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        Statics.releaseFence();
    }
}

