/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.rpc.RetryInfo;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.apache.spark.sql.connect.client.RetryPolicy;
import org.apache.spark.sql.connect.client.RetryPolicy$;
import org.apache.spark.sql.connect.client.SparkConnectClientRetriesSuite$DummyFn$;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u000e\u001c\u0001!BQ!\u0011\u0001\u0005\u0002\t3A!\u0012\u0001\u0005\r\"AQJ\u0001B\u0001J\u0003%a\n\u0003\u0005^\u0005\t\u0005\t\u0015!\u0003_\u0011\u0015\t%\u0001\"\u0001b\u0011\u001d1'\u00011A\u0005\u0002\u001dDq\u0001\u001b\u0002A\u0002\u0013\u0005\u0011\u000e\u0003\u0004p\u0005\u0001\u0006KA\u0018\u0005\u0006a\n!\t!]\u0004\be\u0002\t\t\u0011#\u0003t\r\u001d)\u0005!!A\t\nQDQ!Q\u0006\u0005\u0002UDqA^\u0006\u0012\u0002\u0013\u0005qO\u0002\u0004\u0002\u0006\u0001!\u0011q\u0001\u0005\u0007\u0003:!\t!!\u0003\t\u0013\u00055aB1A\u0005\n\u0005=\u0001\u0002CA\u0014\u001d\u0001\u0006I!!\u0005\t\u000f\u0005%b\u0002\"\u0001\u0002,!9\u0011\u0011\u0007\b\u0005\u0002\u0005M\u0002bBA\u001e\u001d\u0011\u0005\u0011Q\b\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011%\tY\tAI\u0001\n\u0013\ti\tC\u0005\u0002\u0012\u0002\t\n\u0011\"\u0003\u0002\u0014\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBAW\u0001\u0011\u0005\u0011q\u0016\u0002\u001f'B\f'o[\"p]:,7\r^\"mS\u0016tGOU3ue&,7oU;ji\u0016T!\u0001H\u000f\u0002\r\rd\u0017.\u001a8u\u0015\tqr$A\u0004d_:tWm\u0019;\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001I\u0013gN\u001e\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00034v]N,\u0018\u000e^3\u000b\u00059*\u0013!C:dC2\fG/Z:u\u0013\t\u00014FA\u0006B]f4UO\\*vSR,\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u001e\u0003\u0011!Xm\u001d;\n\u0005Y\u001a$aD\"p]:,7\r\u001e$v]N+\u0018\u000e^3\u0011\u0005aJT\"A\u0017\n\u0005ij#A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\u0004\"\u0001P \u000e\u0003uR!AP\u0017\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002A{\tQQI^3oiV\fG\u000e\\=\u0002\rqJg.\u001b;?)\u0005\u0019\u0005C\u0001#\u0001\u001b\u0005Y\"a\u0002#v[6LhI\\\n\u0003\u0005\u001d\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013a!\u00118z%\u00164\u0017!A3\u0011\u0007!{\u0015+\u0003\u0002Q\u0013\nAAHY=oC6,g\b\u0005\u0002S5:\u00111\u000b\u0017\b\u0003)^k\u0011!\u0016\u0006\u0003-\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001&\n\u0005eK\u0015a\u00029bG.\fw-Z\u0005\u00037r\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005eK\u0015\u0001\u00038v[\u001a\u000b\u0017\u000e\\:\u0011\u0005!{\u0016B\u00011J\u0005\rIe\u000e\u001e\u000b\u0004E\u0012,\u0007CA2\u0003\u001b\u0005\u0001\u0001BB'\u0006\t\u0003\u0007a\nC\u0004^\u000bA\u0005\t\u0019\u00010\u0002\u000f\r|WO\u001c;feV\ta,A\u0006d_VtG/\u001a:`I\u0015\fHC\u00016n!\tA5.\u0003\u0002m\u0013\n!QK\\5u\u0011\u001dqw!!AA\u0002y\u000b1\u0001\u001f\u00132\u0003!\u0019w.\u001e8uKJ\u0004\u0013A\u00014o)\u0005q\u0016a\u0002#v[6LhI\u001c\t\u0003G.\u0019\"aC$\u0015\u0003M\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012T#\u0001=+\u0005yK8&\u0001>\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0005v]\u000eDWmY6fI*\u0011q0S\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0002y\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0003!McW-\u001a9US6,GK]1dW\u0016\u00148C\u0001\bH)\t\tY\u0001\u0005\u0002d\u001d\u0005!A-\u0019;b+\t\t\t\u0002\u0005\u0004\u0002\u0014\u0005u\u0011\u0011E\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u00059Q.\u001e;bE2,'bAA\u000e\u0013\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0011Q\u0003\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bc\u0001%\u0002$%\u0019\u0011QE%\u0003\t1{gnZ\u0001\u0006I\u0006$\u0018\rI\u0001\u0006g2,W\r\u001d\u000b\u0004U\u00065\u0002bBA\u0018%\u0001\u0007\u0011\u0011E\u0001\u0002i\u0006)A/[7fgV\u0011\u0011Q\u0007\t\u0006%\u0006]\u0012\u0011E\u0005\u0004\u0003sa&\u0001\u0002'jgR\f!\u0002^8uC2\u001cF.Z3q+\t\t\t#\u0001\u0010de\u0016\fG/\u001a+fgR,\u0005pY3qi&|gnV5uQ\u0012+G/Y5mgRA\u00111IA*\u0003O\nI\b\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\t\u001d\u0014\bo\u0019\u0006\u0003\u0003\u001b\n!![8\n\t\u0005E\u0013q\t\u0002\u0017'R\fG/^:Sk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]\"9\u0011QK\u000bA\u0002\u0005]\u0013aA7tOB!\u0011\u0011LA1\u001d\u0011\tY&!\u0018\u0011\u0005QK\u0015bAA0\u0013\u00061\u0001K]3eK\u001aLA!a\u0019\u0002f\t11\u000b\u001e:j]\u001eT1!a\u0018J\u0011%\tI'\u0006I\u0001\u0002\u0004\tY'\u0001\u0003d_\u0012,\u0007\u0003BA7\u0003grA!!\u0012\u0002p%!\u0011\u0011OA$\u0003\u0019\u0019F/\u0019;vg&!\u0011QOA<\u0005\u0011\u0019u\u000eZ3\u000b\t\u0005E\u0014q\t\u0005\n\u0003w*\u0002\u0013!a\u0001\u0003{\n!B]3uef$U\r\\1z!\u0011\ty(a\"\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003}%KA!!#\u0002\u0002\nqa)\u001b8ji\u0016$UO]1uS>t\u0017\u0001K2sK\u0006$X\rV3ti\u0016C8-\u001a9uS>tw+\u001b;i\t\u0016$\u0018-\u001b7tI\u0011,g-Y;mi\u0012\u0012TCAAHU\r\tY'_\u0001)GJ,\u0017\r^3UKN$X\t_2faRLwN\\,ji\"$U\r^1jYN$C-\u001a4bk2$HeM\u000b\u0003\u0003+S3!! z\u0003y\t7o]3si2{gnZ*fcV,gnY3t\u00032lwn\u001d;FcV\fG\u000eF\u0004k\u00037\u000b)+!+\t\u000f\u0005u\u0005\u00041\u0001\u0002 \u0006)a-\u001b:tiB)!+!)\u0002\"%\u0019\u00111\u0015/\u0003\u0007M+\u0017\u000fC\u0004\u0002(b\u0001\r!a(\u0002\rM,7m\u001c8e\u0011\u001d\tY\u000b\u0007a\u0001\u0003C\tQ\u0001Z3mi\u0006\fq\u0003^3tiB{G.[2z'B,7-\u001b4jG\u0016\u0013(o\u001c:\u0015\r\u0005E\u0016qWA^!\r!\u00151W\u0005\u0004\u0003k[\"a\u0003*fiJL\bk\u001c7jGfDa!!/\u001a\u0001\u0004q\u0016AC7bqJ+GO]5fg\"9\u0011QX\rA\u0002\u0005}\u0016AB:uCR,8\u000f\u0005\u0003\u0002F\u0005\u0005\u0017\u0002BAb\u0003\u000f\u0012aa\u0015;biV\u001c\b")
public class SparkConnectClientRetriesSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach,
Eventually {
    private volatile SparkConnectClientRetriesSuite$DummyFn$ DummyFn$module;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public /* synthetic */ org.scalatest.Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public org.scalatest.Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private SparkConnectClientRetriesSuite$DummyFn$ DummyFn() {
        if (this.DummyFn$module == null) {
            this.DummyFn$lzycompute$1();
        }
        return this.DummyFn$module;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private StatusRuntimeException createTestExceptionWithDetails(String msg, Status.Code code, FiniteDuration retryDelay) {
        long seconds = retryDelay.toSeconds();
        int nanos = (int)retryDelay.$minus(FiniteDuration$.MODULE$.apply(seconds, "s")).toNanos();
        Duration retryDelayMsg = Duration.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(retryDelayMsg).build();
        com.google.rpc.Status status = com.google.rpc.Status.newBuilder().setMessage(msg).setCode(code.value()).addDetails(Any.pack((Message)retryInfo)).build();
        return StatusProto.toStatusRuntimeException((com.google.rpc.Status)status);
    }

    private Status.Code createTestExceptionWithDetails$default$2() {
        return Status.Code.INTERNAL;
    }

    private FiniteDuration createTestExceptionWithDetails$default$3() {
        return FiniteDuration$.MODULE$.apply(0L, "s");
    }

    private void assertLongSequencesAlmostEqual(Seq<Object> first, Seq<Object> second, long delta) {
        Seq<Object> $org_scalatest_assert_macro_left = first;
        int $org_scalatest_assert_macro_right = second.length();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Lists have different lengths.", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        ((IterableOps)first.zip(second)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientRetriesSuite.$anonfun$assertLongSequencesAlmostEqual$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long a = tuple2._1$mcJ$sp();
                long b = tuple2._2$mcJ$sp();
                long $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(a - b);
                long $org_scalatest_assert_macro_right = delta;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Elements " + a + " and " + b + " differ by more than " + delta + "."), Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public RetryPolicy testPolicySpecificError(int maxRetries, Status status) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)maxRetries));
        String x$2 = "Policy for " + status.getCode();
        Function1 & Serializable x$3 = (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientRetriesSuite.$anonfun$testPolicySpecificError$1(status, x0$1));
        FiniteDuration x$4 = RetryPolicy$.MODULE$.apply$default$2();
        Option x$5 = RetryPolicy$.MODULE$.apply$default$3();
        double x$6 = RetryPolicy$.MODULE$.apply$default$4();
        FiniteDuration x$7 = RetryPolicy$.MODULE$.apply$default$5();
        FiniteDuration x$8 = RetryPolicy$.MODULE$.apply$default$6();
        boolean x$9 = RetryPolicy$.MODULE$.apply$default$9();
        Option x$10 = RetryPolicy$.MODULE$.apply$default$10();
        return new RetryPolicy((Option)x$1, x$4, x$5, x$6, x$7, x$8, (Function1)x$3, x$2, x$9, x$10);
    }

    private final void DummyFn$lzycompute$1() {
        SparkConnectClientRetriesSuite sparkConnectClientRetriesSuite = this;
        synchronized (sparkConnectClientRetriesSuite) {
            if (this.DummyFn$module == null) {
                this.DummyFn$module = new SparkConnectClientRetriesSuite$DummyFn$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        SparkConnectClientRetriesSuite sparkConnectClientRetriesSuite = this;
        synchronized (sparkConnectClientRetriesSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertLongSequencesAlmostEqual$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ Assertion $anonfun$new$2(SparkConnectClientRetriesSuite $this, int x$2) {
        int n = x$2;
        SleepTimeTracker st = $this.new SleepTimeTracker();
        DummyFn dummyFn = new DummyFn($this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.UNAVAILABLE), 100);
        GrpcRetryHandler retryHandler = new GrpcRetryHandler(RetryPolicy$.MODULE$.defaultPolicies(), (Function1)(JFunction1.mcVJ.sp & Serializable)t -> st.sleep(t));
        $this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        long $org_scalatest_assert_macro_left = st.totalSleep();
        int $org_scalatest_assert_macro_right = 600000;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    public static final /* synthetic */ boolean $anonfun$new$18(Throwable x$5) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$23(Throwable x$6) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPolicySpecificError$1(Status status$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            Status.Code code = statusRuntimeException.getStatus().getCode();
            Status.Code code2 = status$1.getCode();
            return !(code != null ? !code.equals(code2) : code2 != null);
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$42(RetryPolicy x$11) {
        String string = x$11.name();
        String string2 = "DefaultPolicy";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$48(RetryPolicy x$12) {
        String string = x$12.name();
        String string2 = "DefaultPolicy";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Assertion $anonfun$new$49(RetryPolicy policy$1, long t) {
        long $org_scalatest_assert_macro_left = t;
        long $org_scalatest_assert_macro_right = ((FiniteDuration)policy$1.maxBackoff().get()).toMillis() + policy$1.jitter().toMillis();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
    }

    public static final /* synthetic */ boolean $anonfun$new$56(RetryPolicy x$13) {
        String string = x$13.name();
        String string2 = "DefaultPolicy";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$63(RetryPolicy x$14) {
        String string = x$14.name();
        String string2 = "DefaultPolicy";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SparkConnectClientRetriesSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        this.test("SPARK-44721: Retries run for a minimum period", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable)x$2 -> SparkConnectClientRetriesSuite.$anonfun$new$2(this, BoxesRunTime.unboxToInt((Object)x$2))), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("SPARK-44275: retry actually retries", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int result;
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            Seq retryPolicies = RetryPolicy$.MODULE$.defaultPolicies();
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicies, (Function1)(JFunction1.mcVJ.sp & Serializable)x$3 -> {});
            int $org_scalatest_assert_macro_left = result = BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn()));
            int $org_scalatest_assert_macro_right = 42;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            int $org_scalatest_assert_macro_left2 = dummyFn.counter();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("SPARK-44275: default retryException retries only on UNAVAILABLE", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.ABORTED), this.DummyFn().$lessinit$greater$default$2());
            Seq retryPolicies = RetryPolicy$.MODULE$.defaultPolicies();
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicies, (Function1)(JFunction1.mcVJ.sp & Serializable)x$4 -> {});
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("SPARK-44275: retry uses canRetry to filter exceptions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            Function1 & Serializable x$1 = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientRetriesSuite.$anonfun$new$18(x$5));
            String x$2 = "TestPolicy";
            Option x$3 = RetryPolicy$.MODULE$.apply$default$1();
            FiniteDuration x$4 = RetryPolicy$.MODULE$.apply$default$2();
            Option x$52 = RetryPolicy$.MODULE$.apply$default$3();
            double x$6 = RetryPolicy$.MODULE$.apply$default$4();
            FiniteDuration x$7 = RetryPolicy$.MODULE$.apply$default$5();
            FiniteDuration x$8 = RetryPolicy$.MODULE$.apply$default$6();
            boolean x$9 = RetryPolicy$.MODULE$.apply$default$9();
            Option x$10 = RetryPolicy$.MODULE$.apply$default$10();
            RetryPolicy retryPolicy = new RetryPolicy(x$3, x$4, x$52, x$6, x$7, x$8, (Function1)x$1, "TestPolicy", x$9, x$10);
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicy);
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("SPARK-44275: retry does not exceed maxRetries", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            Function1 & Serializable x$11 = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientRetriesSuite.$anonfun$new$23(x$6));
            Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            String x$13 = "TestPolicy";
            FiniteDuration x$14 = RetryPolicy$.MODULE$.apply$default$2();
            Option x$15 = RetryPolicy$.MODULE$.apply$default$3();
            double x$16 = RetryPolicy$.MODULE$.apply$default$4();
            FiniteDuration x$17 = RetryPolicy$.MODULE$.apply$default$5();
            FiniteDuration x$18 = RetryPolicy$.MODULE$.apply$default$6();
            boolean x$19 = RetryPolicy$.MODULE$.apply$default$9();
            Option x$20 = RetryPolicy$.MODULE$.apply$default$10();
            RetryPolicy retryPolicy = new RetryPolicy((Option)x$12, x$14, x$15, x$16, x$17, x$18, (Function1)x$11, "TestPolicy", x$19, x$20);
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicy, (Function1)(JFunction1.mcVJ.sp & Serializable)x$7 -> {});
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("Test multiple policies", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            RetryPolicy policy1 = this.testPolicySpecificError(2, Status.UNAVAILABLE);
            RetryPolicy policy2 = this.testPolicySpecificError(4, Status.INTERNAL);
            Iterator errors = ((StrictOptimizedLinearSeqOps)package$.MODULE$.List().fill(2, (Function0 & Serializable)() -> Status.UNAVAILABLE).$plus$plus((IterableOnce)package$.MODULE$.List().fill(4, (Function0 & Serializable)() -> Status.INTERNAL))).iterator();
            new GrpcRetryHandler((Seq)new .colon.colon((Object)policy1, (List)new .colon.colon((Object)policy2, (List)Nil$.MODULE$)), (Function1)(JFunction1.mcVJ.sp & Serializable)x$8 -> {}).retry((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Option e = errors.nextOption();
                if (e.isDefined()) {
                    throw ((Status)e.get()).asRuntimeException();
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(errors.hasNext(), "errors.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("Test multiple policies exceed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            RetryPolicy policy1 = this.testPolicySpecificError(2, Status.INTERNAL);
            RetryPolicy policy2 = this.testPolicySpecificError(4, Status.INTERNAL);
            Iterator errors = ((StrictOptimizedLinearSeqOps)package$.MODULE$.List().fill(10, (Function0 & Serializable)() -> Status.INTERNAL)).iterator();
            IntRef countAttempted = IntRef.create((int)0);
            this.assertThrows((Function0 & Serializable)() -> new GrpcRetryHandler((Seq)new .colon.colon((Object)policy1, (List)new .colon.colon((Object)policy2, (List)Nil$.MODULE$)), (Function1)(JFunction1.mcVJ.sp & Serializable)x$9 -> {}).retry((Function0 & Serializable)() -> {
                ++countAttempted$1.elem;
                Option e = errors.nextOption();
                if (e.isDefined()) {
                    throw ((Status)e.get()).asRuntimeException();
                }
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            int $org_scalatest_assert_macro_left = countAttempted.elem;
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("DefaultPolicy retries exceptions with RetryInfo", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> this.createTestExceptionWithDetails("Some error message", this.createTestExceptionWithDetails$default$2(), this.createTestExceptionWithDetails$default$3()), 100);
            Seq retryPolicies = RetryPolicy$.MODULE$.defaultPolicies();
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicies, (Function1)(JFunction1.mcVJ.sp & Serializable)x$10 -> {});
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            RetryPolicy policy = (RetryPolicy)retryPolicies.find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientRetriesSuite.$anonfun$new$42(x$11))).get();
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = BoxesRunTime.unboxToInt((Object)policy.maxRetries().get()) + 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("retry_delay overrides maxBackoff", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SleepTimeTracker st = new SleepTimeTracker();
            FiniteDuration retryDelay = FiniteDuration$.MODULE$.apply(5L, "min");
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> {
                String x$21 = "Some error message";
                FiniteDuration x$22 = retryDelay;
                Status.Code x$23 = this.createTestExceptionWithDetails$default$2();
                return this.createTestExceptionWithDetails("Some error message", x$23, x$22);
            }, 100);
            Seq retryPolicies = RetryPolicy$.MODULE$.defaultPolicies();
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicies, (Function1)(JFunction1.mcVJ.sp & Serializable)t -> st.sleep(t));
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            RetryPolicy policy = (RetryPolicy)retryPolicies.find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientRetriesSuite.$anonfun$new$48(x$12))).get();
            st.times().foreach((Function1 & Serializable)t -> SparkConnectClientRetriesSuite.$anonfun$new$49(policy, BoxesRunTime.unboxToLong((Object)t)));
            List expectedSleeps = (List)package$.MODULE$.List().fill(BoxesRunTime.unboxToInt((Object)policy.maxRetries().get()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> retryDelay.toMillis());
            this.assertLongSequencesAlmostEqual((Seq<Object>)st.times(), (Seq<Object>)expectedSleeps, policy.jitter().toMillis());
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("maxServerRetryDelay limits retry_delay", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SleepTimeTracker st = new SleepTimeTracker();
            FiniteDuration retryDelay = FiniteDuration$.MODULE$.apply(5L, "d");
            DummyFn dummyFn = new DummyFn(this, (Function0<Throwable>)(Function0 & Serializable)() -> {
                String x$24 = "Some error message";
                FiniteDuration x$25 = retryDelay;
                Status.Code x$26 = this.createTestExceptionWithDetails$default$2();
                return this.createTestExceptionWithDetails("Some error message", x$26, x$25);
            }, 100);
            Seq retryPolicies = RetryPolicy$.MODULE$.defaultPolicies();
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicies, (Function1)(JFunction1.mcVJ.sp & Serializable)t -> st.sleep(t));
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            RetryPolicy policy = (RetryPolicy)retryPolicies.find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientRetriesSuite.$anonfun$new$56(x$13))).get();
            List expectedSleeps = (List)package$.MODULE$.List().fill(BoxesRunTime.unboxToInt((Object)policy.maxRetries().get()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> ((FiniteDuration)policy.maxServerRetryDelay().get()).toMillis());
            this.assertLongSequencesAlmostEqual((Seq<Object>)st.times(), (Seq<Object>)expectedSleeps, policy.jitter().toMillis());
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("Policy uses to exponential backoff after retry_delay is unset", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SleepTimeTracker st = new SleepTimeTracker();
            FiniteDuration retryDelay = FiniteDuration$.MODULE$.apply(5L, "min");
            Seq retryPolicies = RetryPolicy$.MODULE$.defaultPolicies();
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicies, (Function1)(JFunction1.mcVJ.sp & Serializable)t -> st.sleep(t));
            Iterator errors = ((StrictOptimizedLinearSeqOps)package$.MODULE$.List().fill(2, (Function0 & Serializable)() -> {
                String x$27 = "Some error message";
                FiniteDuration x$28 = retryDelay;
                Status.Code x$29 = this.createTestExceptionWithDetails$default$2();
                return this.createTestExceptionWithDetails("Some error message", x$29, x$28);
            }).$plus$plus((IterableOnce)package$.MODULE$.List().fill(3, (Function0 & Serializable)() -> this.createTestExceptionWithDetails("Some error message", Status.Code.UNAVAILABLE, this.createTestExceptionWithDetails$default$3())))).iterator();
            retryHandler.retry((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                if (errors.hasNext()) {
                    throw (Throwable)errors.next();
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(errors.hasNext(), "errors.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            RetryPolicy policy = (RetryPolicy)retryPolicies.find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientRetriesSuite.$anonfun$new$63(x$14))).get();
            List expectedSleeps = (List)package$.MODULE$.List().fill(2, (Function0)(JFunction0.mcJ.sp & Serializable)() -> retryDelay.toMillis()).$plus$plus((IterableOnce)package$.MODULE$.List().tabulate(3, (Function1)(JFunction1.mcJI.sp & Serializable)i -> policy.initialBackoff().toMillis() * (long)scala.math.package$.MODULE$.pow(policy.backoffMultiplier(), (double)(i + 2))));
            this.assertLongSequencesAlmostEqual((Seq<Object>)st.times(), (Seq<Object>)expectedSleeps, policy.jitter().toMillis());
        }, new Position("SparkConnectClientRetriesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        Statics.releaseFence();
    }

    private class DummyFn {
        private final Function0<Throwable> e;
        private final int numFails;
        private int counter;
        public final /* synthetic */ SparkConnectClientRetriesSuite $outer;

        public int counter() {
            return this.counter;
        }

        public void counter_$eq(int x$1) {
            this.counter = x$1;
        }

        public int fn() {
            if (this.counter() < this.numFails) {
                this.counter_$eq(this.counter() + 1);
                throw (Throwable)this.e.apply();
            }
            return 42;
        }

        public /* synthetic */ SparkConnectClientRetriesSuite org$apache$spark$sql$connect$client$SparkConnectClientRetriesSuite$DummyFn$$$outer() {
            return this.$outer;
        }

        public DummyFn(SparkConnectClientRetriesSuite $outer, Function0<Throwable> e, int numFails) {
            this.e = e;
            this.numFails = numFails;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.counter = 0;
        }
    }

    private class SleepTimeTracker {
        private final ListBuffer<Object> data;

        private ListBuffer<Object> data() {
            return this.data;
        }

        public void sleep(long t) {
            this.data().append((Object)BoxesRunTime.boxToLong((long)t));
        }

        public List<Object> times() {
            return this.data().toList();
        }

        public long totalSleep() {
            return BoxesRunTime.unboxToLong((Object)this.data().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }

        public /* synthetic */ SparkConnectClientRetriesSuite org$apache$spark$sql$connect$client$SparkConnectClientRetriesSuite$SleepTimeTracker$$$outer() {
            return SparkConnectClientRetriesSuite.this;
        }

        public SleepTimeTracker() {
            if (SparkConnectClientRetriesSuite.this == null) {
                throw null;
            }
            this.data = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }
}

