/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingServerBuilder;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.AddArtifactsResponse;
import org.apache.spark.connect.proto.AnalyzePlanRequest;
import org.apache.spark.connect.proto.AnalyzePlanResponse;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.SQL;
import org.apache.spark.connect.proto.SparkConnectServiceGrpc;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.SparkSession$;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator$;
import org.apache.spark.sql.connect.client.GrpcExceptionConverter;
import org.apache.spark.sql.connect.client.GrpcExceptionConverter$;
import org.apache.spark.sql.connect.client.RetryPolicy;
import org.apache.spark.sql.connect.client.RetryPolicy$;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.SparkConnectClientSuite$TestPackURI$;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.connect.test.ConnectFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Futures$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t}f\u0001\u0002\u001c8\u0001\u0011CQa\u0016\u0001\u0005\u0002aC\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011B.\t\u0013}\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0007\"C5\u0001\u0001\u0004\u0005\t\u0015)\u0003]\u0011%Q\u0007\u00011AA\u0002\u0013%1\u000eC\u0005p\u0001\u0001\u0007\t\u0019!C\u0005a\"I!\u000f\u0001a\u0001\u0002\u0003\u0006K\u0001\u001c\u0005\ng\u0002\u0001\r\u00111A\u0005\nQD\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0002@\t\u0015\u0005\u0005\u0001\u00011A\u0001B\u0003&Q\u000fC\u0004\u0002\u0004\u0001!I!!\u0002\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011Q\u0003\u0001\u0005B\u0005M\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\n\u0003W\u0001\u0011\u0013!C\u0005\u0003[Aq!a\u0011\u0001\t\u0013\t)E\u0002\u0004\u0002z\u0001!\u00151\u0010\u0005\u000b\u00037\u000b\"Q3A\u0005\u0002\u0005u\u0005BCAP#\tE\t\u0015!\u0003\u0002d!Q\u0011\u0011U\t\u0003\u0016\u0004%\t!a)\t\u0015\u0005-\u0016C!E!\u0002\u0013\t)\u000b\u0003\u0006\u0002.F\u0011)\u001a!C\u0001\u0003_C!\"a-\u0012\u0005#\u0005\u000b\u0011BAY\u0011\u00199\u0016\u0003\"\u0001\u00026\"I\u0011\u0011Y\t\u0002\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003\u0017\f\u0012\u0013!C\u0001\u0003\u001bD\u0011\"!5\u0012#\u0003%\t!a5\t\u0013\u0005]\u0017#%A\u0005\u0002\u0005e\u0007\"CAo#\u0005\u0005I\u0011IAp\u0011%\ty/EA\u0001\n\u0003\t\t\u0010C\u0005\u0002tF\t\t\u0011\"\u0001\u0002v\"I\u0011q`\t\u0002\u0002\u0013\u0005#\u0011\u0001\u0005\n\u0005\u001f\t\u0012\u0011!C\u0001\u0005#A\u0011B!\u0006\u0012\u0003\u0003%\tEa\u0006\t\u0013\tm\u0011#!A\u0005B\tu\u0001\"\u0003B\u0010#\u0005\u0005I\u0011\tB\u0011\u0011%\u0011\u0019#EA\u0001\n\u0003\u0012)cB\u0005\u0003*\u0001\t\t\u0011#\u0003\u0003,\u0019I\u0011\u0011\u0010\u0001\u0002\u0002#%!Q\u0006\u0005\u0007/\u001e\"\tAa\u0011\t\u0013\t}q%!A\u0005F\t\u0005\u0002\"\u0003B#O\u0005\u0005I\u0011\u0011B$\u0011%\u0011yeJI\u0001\n\u0003\tI\u000eC\u0005\u0003R\u001d\n\t\u0011\"!\u0003T!I!QM\u0014\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0005O\u0002!\u0019!C\u0005\u0005SB\u0001Ba\u001e\u0001A\u0003%!1\u000e\u0005\b\u0005s\u0002A\u0011\u0002B>\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007C\u0011Ba&\u0001\u0005\u0004%I!a8\t\u0011\te\u0005\u0001)A\u0005\u0003CDqAa'\u0001\t\u0013\u0011i\nC\u0004\u0003&\u0002!IAa*\u0003/M\u0003\u0018M]6D_:tWm\u0019;DY&,g\u000e^*vSR,'B\u0001\u001d:\u0003\u0019\u0019G.[3oi*\u0011!hO\u0001\bG>tg.Z2u\u0015\taT(A\u0002tc2T!AP \u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0002\u0001'\u0011\u0001Q)T*\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001\u00034v]N,\u0018\u000e^3\u000b\u0005)\u000b\u0015!C:dC2\fG/Z:u\u0013\tauIA\u0006B]f4UO\\*vSR,\u0007C\u0001(R\u001b\u0005y%B\u0001):\u0003\u0011!Xm\u001d;\n\u0005I{%aD\"p]:,7\r\u001e$v]N+\u0018\u000e^3\u0011\u0005Q+V\"A%\n\u0005YK%A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\fa\u0001P5oSRtD#A-\u0011\u0005i\u0003Q\"A\u001c\u0016\u0003q\u0003\"AW/\n\u0005y;$AE*qCJ\\7i\u001c8oK\u000e$8\t\\5f]R\f!b\u00197jK:$x\fJ3r)\t\tw\r\u0005\u0002cK6\t1MC\u0001e\u0003\u0015\u00198-\u00197b\u0013\t17M\u0001\u0003V]&$\bb\u00025\u0004\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\n\u0014aB2mS\u0016tG\u000fI\u0001\bg\u0016\u0014h/[2f+\u0005a\u0007C\u0001.n\u0013\tqwG\u0001\rEk6l\u0017p\u00159be.\u001cuN\u001c8fGR\u001cVM\u001d<jG\u0016\f1b]3sm&\u001cWm\u0018\u0013fcR\u0011\u0011-\u001d\u0005\bQ\u001a\t\t\u00111\u0001m\u0003!\u0019XM\u001d<jG\u0016\u0004\u0013AB:feZ,'/F\u0001v!\t180D\u0001x\u0015\tA\u00180\u0001\u0003heB\u001c'\"\u0001>\u0002\u0005%|\u0017B\u0001?x\u0005\u0019\u0019VM\u001d<fe\u0006Q1/\u001a:wKJ|F%Z9\u0015\u0005\u0005|\bb\u00025\n\u0003\u0003\u0005\r!^\u0001\bg\u0016\u0014h/\u001a:!\u0003A\u0019H/\u0019:u\tVlW._*feZ,'\u000fF\u0002b\u0003\u000fAq!!\u0003\f\u0001\u0004\tY!\u0001\u0003q_J$\bc\u00012\u0002\u000e%\u0019\u0011qB2\u0003\u0007%sG/\u0001\u0006cK\u001a|'/Z#bG\"$\u0012!Y\u0001\nC\u001a$XM]#bG\"\fA\u0003^3ti\u000ec\u0017.\u001a8u\u0007>tg.Z2uS>tG\u0003BA\u000e\u0003O!2!YA\u000f\u0011\u001d\tyB\u0004a\u0001\u0003C\tQb\u00197jK:$()^5mI\u0016\u0014\bC\u00022\u0002$\u0005-A,C\u0002\u0002&\r\u0014\u0011BR;oGRLwN\\\u0019\t\u0013\u0005%b\u0002%AA\u0002\u0005-\u0011AC:feZ,'\u000fU8si\u0006qB/Z:u\u00072LWM\u001c;D_:tWm\u0019;j_:$C-\u001a4bk2$H%M\u000b\u0003\u0003_QC!a\u0003\u00022-\u0012\u00111\u0007\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003%)hn\u00195fG.,GMC\u0002\u0002>\r\f!\"\u00198o_R\fG/[8o\u0013\u0011\t\t%a\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0005xSRDWI\u001c<t)\u0011\t9%a\u0015\u0015\u0007\u0005\fI\u0005\u0003\u0005\u0002LA!\t\u0019AA'\u0003\u00051\u0007\u0003\u00022\u0002P\u0005L1!!\u0015d\u0005!a$-\u001f8b[\u0016t\u0004bBA+!\u0001\u0007\u0011qK\u0001\u0006a\u0006L'o\u001d\t\u0006E\u0006e\u0013QL\u0005\u0004\u00037\u001a'A\u0003\u001fsKB,\u0017\r^3e}A9!-a\u0018\u0002d\u0005\r\u0014bAA1G\n1A+\u001e9mKJ\u0002B!!\u001a\u0002t9!\u0011qMA8!\r\tIgY\u0007\u0003\u0003WR1!!\u001cD\u0003\u0019a$o\\8u}%\u0019\u0011\u0011O2\u0002\rA\u0013X\rZ3g\u0013\u0011\t)(a\u001e\u0003\rM#(/\u001b8h\u0015\r\t\th\u0019\u0002\f)\u0016\u001cH\u000fU1dWV\u0013\u0016jE\u0004\u0012\u0003{\n\u0019)!#\u0011\u0007\t\fy(C\u0002\u0002\u0002\u000e\u0014a!\u00118z%\u00164\u0007c\u00012\u0002\u0006&\u0019\u0011qQ2\u0003\u000fA\u0013x\u000eZ;diB!\u00111RAK\u001d\u0011\ti)!%\u000f\t\u0005%\u0014qR\u0005\u0002I&\u0019\u00111S2\u0002\u000fA\f7m[1hK&!\u0011qSAM\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\u0019jY\u0001\u0011G>tg.Z2uS>t7\u000b\u001e:j]\u001e,\"!a\u0019\u0002#\r|gN\\3di&|gn\u0015;sS:<\u0007%A\u0005jg\u000e{'O]3diV\u0011\u0011Q\u0015\t\u0004E\u0006\u001d\u0016bAAUG\n9!i\\8mK\u0006t\u0017AC5t\u0007>\u0014(/Z2uA\u0005YQ\r\u001f;sC\u000eCWmY6t+\t\t\t\fE\u0003c\u0003Ga\u0016-\u0001\u0007fqR\u0014\u0018m\u00115fG.\u001c\b\u0005\u0006\u0005\u00028\u0006m\u0016QXA`!\r\tI,E\u0007\u0002\u0001!9\u00111\u0014\rA\u0002\u0005\r\u0004bBAQ1\u0001\u0007\u0011Q\u0015\u0005\n\u0003[C\u0002\u0013!a\u0001\u0003c\u000bAaY8qsRA\u0011qWAc\u0003\u000f\fI\rC\u0005\u0002\u001cf\u0001\n\u00111\u0001\u0002d!I\u0011\u0011U\r\u0011\u0002\u0003\u0007\u0011Q\u0015\u0005\n\u0003[K\u0002\u0013!a\u0001\u0003c\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002P*\"\u00111MA\u0019\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!6+\t\u0005\u0015\u0016\u0011G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYN\u000b\u0003\u00022\u0006E\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002bB!\u00111]Aw\u001b\t\t)O\u0003\u0003\u0002h\u0006%\u0018\u0001\u00027b]\u001eT!!a;\u0002\t)\fg/Y\u0005\u0005\u0003k\n)/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\f\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA|\u0003{\u00042AYA}\u0013\r\tYp\u0019\u0002\u0004\u0003:L\b\u0002\u00035 \u0003\u0003\u0005\r!a\u0003\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0001\u0011\r\t\u0015!1BA|\u001b\t\u00119AC\u0002\u0003\n\r\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iAa\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003K\u0013\u0019\u0002\u0003\u0005iC\u0005\u0005\t\u0019AA|\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u0005(\u0011\u0004\u0005\tQ\n\n\t\u00111\u0001\u0002\f\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\f\u0005AAo\\*ue&tw\r\u0006\u0002\u0002b\u00061Q-];bYN$B!!*\u0003(!A\u0001.JA\u0001\u0002\u0004\t90A\u0006UKN$\b+Y2l+JK\u0005cAA]OM)qEa\f\u0003<Aa!\u0011\u0007B\u001c\u0003G\n)+!-\u000286\u0011!1\u0007\u0006\u0004\u0005k\u0019\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005s\u0011\u0019DA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BA!\u0010\u0003B5\u0011!q\b\u0006\u0004u\u0006%\u0018\u0002BAL\u0005\u007f!\"Aa\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005]&\u0011\nB&\u0005\u001bBq!a'+\u0001\u0004\t\u0019\u0007C\u0004\u0002\"*\u0002\r!!*\t\u0013\u00055&\u0006%AA\u0002\u0005E\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!Q\u000bB1!\u0015\u0011'q\u000bB.\u0013\r\u0011If\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0013\t\u0014i&a\u0019\u0002&\u0006E\u0016b\u0001B0G\n1A+\u001e9mKNB\u0011Ba\u0019-\u0003\u0003\u0005\r!a.\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u0005+JK5/\u0006\u0002\u0003lA1!Q\u000eB:\u0003ok!Aa\u001c\u000b\t\tE$qA\u0001\nS6lW\u000f^1cY\u0016LAA!\u001e\u0003p\t\u00191+Z9\u0002\u000bU\u0013\u0016j\u001d\u0011\u0002\u001b\rDWmY6UKN$\b+Y2l)\r\t'Q\u0010\u0005\b\u0005\u007f\u0002\u0004\u0019AA\\\u0003!!Xm\u001d;QC\u000e\\\u0017!\u00032vS2$\u0007\u000b\\1o)\u0011\u0011)Ia%\u0011\t\t\u001d%qR\u0007\u0003\u0005\u0013SAAa#\u0003\u000e\u0006)\u0001O]8u_*\u0011!(P\u0005\u0005\u0005#\u0013II\u0001\u0003QY\u0006t\u0007b\u0002BKc\u0001\u0007\u00111M\u0001\u0006cV,'/_\u0001\r\u0013:3\u0016\tT%E?\"{5\u000bV\u0001\u000e\u0013:3\u0016\tT%E?\"{5\u000b\u0016\u0011\u0002;\r\u0014X-\u0019;f+:\u0014Xm]8mm\u0006\u0014G.\u001a%pgR\u001c\u0005.\u00198oK2,\"Aa(\u0011\u0007Y\u0014\t+C\u0002\u0003$^\u0014a\"T1oC\u001e,Gm\u00115b]:,G.A\rbgN,'\u000f^\"p]R\f\u0017N\\:V]\u00064\u0018-\u001b7bE2,G\u0003\u0002BU\u0005k\u0003BAa+\u00030:\u0019AK!,\n\u0007\u0005M\u0015*\u0003\u0003\u00032\nM&!C!tg\u0016\u0014H/[8o\u0015\r\t\u0019*\u0013\u0005\b\u0005o+\u0004\u0019\u0001B]\u0003\u0005!\b\u0003BAF\u0005wKAA!0\u0002\u001a\nIA\u000b\u001b:po\u0006\u0014G.\u001a")
public class SparkConnectClientSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private volatile SparkConnectClientSuite$TestPackURI$ TestPackURI$module;
    private SparkConnectClient client;
    private DummySparkConnectService service;
    private Server server;
    private final Seq<TestPackURI> URIs;
    private final String INVALID_HOST;

    public /* synthetic */ org.scalatest.Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public org.scalatest.Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return ConnectFunSuite.baseResourcePath$(this);
    }

    @Override
    public Path commonResourcePath() {
        return ConnectFunSuite.commonResourcePath$(this);
    }

    @Override
    public Expression toExpr(Column c) {
        return ConnectFunSuite.toExpr$(this, c);
    }

    private SparkConnectClientSuite$TestPackURI$ TestPackURI() {
        if (this.TestPackURI$module == null) {
            this.TestPackURI$lzycompute$1();
        }
        return this.TestPackURI$module;
    }

    private SparkConnectClient client() {
        return this.client;
    }

    private void client_$eq(SparkConnectClient x$1) {
        this.client = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private void startDummyServer(int port) {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((ForwardingServerBuilder)NettyServerBuilder.forPort((int)port).addService((BindableService)this.service())).build());
        this.server().start();
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.client_$eq(null);
        this.server_$eq(null);
        this.service_$eq(null);
    }

    public void afterEach() {
        if (this.server() != null) {
            this.server().shutdownNow();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "SparkConnectClientSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        if (this.client() != null) {
            this.client().shutdown();
            return;
        }
    }

    private void testClientConnection(int serverPort, Function1<Object, SparkConnectClient> clientBuilder) {
        this.startDummyServer(serverPort);
        this.client_$eq((SparkConnectClient)clientBuilder.apply((Object)BoxesRunTime.boxToInteger((int)this.server().getPort())));
        AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().setSessionId("abc123").build();
        AnalyzePlanResponse response = this.client().analyze(request);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(response.getSessionId());
        String $org_scalatest_assert_macro_right = "abc123";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    private int testClientConnection$default$1() {
        return 0;
    }

    private void withEnvs(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        Map<String, String> readonlyEnv = System.getenv();
        Field field = readonlyEnv.getClass().getDeclaredField("m");
        field.setAccessible(true);
        Map modifiableEnv = (Map)field.get(readonlyEnv);
        try {
            pairs.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$withEnvs$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
                Tuple2 tuple2 = x$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(modifiableEnv.containsKey(k), "modifiableEnv.containsKey(k)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
                    return modifiableEnv.put(k, v);
                }
                throw new MatchError((Object)tuple2);
            });
            f.apply$mcV$sp();
        }
        finally {
            pairs.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$withEnvs$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$5 -> {
                Tuple2 tuple2 = x$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    return (String)modifiableEnv.remove(k);
                }
                throw new MatchError((Object)tuple2);
            });
        }
    }

    private Seq<TestPackURI> URIs() {
        return this.URIs;
    }

    private void checkTestPack(TestPackURI testPack) {
        SparkConnectClient client = SparkConnectClient$.MODULE$.builder().connectionString(testPack.connectionString()).build();
        testPack.extraChecks().apply((Object)client);
    }

    private Plan buildPlan(String query) {
        return Plan.newBuilder().setRoot(Relation.newBuilder().setSql(SQL.newBuilder().setQuery(query)).build()).build();
    }

    private String INVALID_HOST() {
        return this.INVALID_HOST;
    }

    private ManagedChannel createUnresolvableHostChannel() {
        String x$1 = this.INVALID_HOST();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        int x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$4();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        scala.collection.immutable.Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        Seq x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        int x$13 = SparkConnectClient.Configuration$.MODULE$.apply$default$13();
        int x$14 = SparkConnectClient.Configuration$.MODULE$.apply$default$14();
        return new SparkConnectClient.Configuration(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14).createChannel();
    }

    private Assertion assertContainsUnavailable(Throwable t) {
        String $org_scalatest_assert_macro_left = t.getMessage();
        String $org_scalatest_assert_macro_right = "UNAVAILABLE: Unable to resolve host " + this.INVALID_HOST();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
    }

    private final void TestPackURI$lzycompute$1() {
        SparkConnectClientSuite sparkConnectClientSuite = this;
        synchronized (sparkConnectClientSuite) {
            if (this.TestPackURI$module == null) {
                this.TestPackURI$module = new SparkConnectClientSuite$TestPackURI$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$withEnvs$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$withEnvs$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ SparkConnectClient $anonfun$new$4(int testPort) {
        return SparkConnectClient$.MODULE$.builder().port(testPort).build();
    }

    public static final /* synthetic */ SparkConnectClient $anonfun$new$6(int testPort) {
        return SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + testPort).build();
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Throwable x$6) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$20(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$new$21(Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            return name.startsWith("org.apache.spark");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$24(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$new$25(Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            return !name.startsWith("org.apache.spark");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$URIs$3(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.configuration().host();
        String $org_scalatest_assert_macro_right = "localhost";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        int $org_scalatest_assert_macro_left2 = client.configuration().port();
        int $org_scalatest_assert_macro_right2 = 1234;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        String $org_scalatest_assert_macro_left3 = client.sessionId();
        Object $org_scalatest_assert_macro_right3 = null;
        String string3 = $org_scalatest_assert_macro_left3;
        Object var11_10 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, string3 == null ? var11_10 != null : !string3.equals(var11_10), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        UUID $org_scalatest_assert_macro_left4 = UUID.fromString(client.sessionId());
        Object $org_scalatest_assert_macro_right4 = null;
        UUID uUID = $org_scalatest_assert_macro_left4;
        Object var15_14 = null;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", null, uUID == null ? var15_14 != null : !((Object)uUID).equals(var15_14), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
    }

    public static final /* synthetic */ void $anonfun$URIs$4(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.configuration().host();
        String $org_scalatest_assert_macro_right = "localhost";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        int $org_scalatest_assert_macro_left2 = client.configuration().port();
        int $org_scalatest_assert_macro_right2 = ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
    }

    public static final /* synthetic */ void $anonfun$URIs$5(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userId();
        String $org_scalatest_assert_macro_right = "a94";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
    }

    public static final /* synthetic */ void $anonfun$URIs$6(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userAgent();
        String $org_scalatest_assert_macro_right = "a945";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
    }

    public static final /* synthetic */ void $anonfun$URIs$7(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userAgent();
        String $org_scalatest_assert_macro_right = "spark/";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        String $org_scalatest_assert_macro_left2 = client.userAgent();
        String $org_scalatest_assert_macro_right2 = "scala/";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        String $org_scalatest_assert_macro_left3 = client.userAgent();
        String $org_scalatest_assert_macro_right3 = "jvm/";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        String $org_scalatest_assert_macro_left4 = client.userAgent();
        String $org_scalatest_assert_macro_right4 = "os/";
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
    }

    public static final /* synthetic */ void $anonfun$URIs$8(SparkConnectClient client) {
        int $org_scalatest_assert_macro_left = client.configuration().grpcMaxMessageSize();
        int $org_scalatest_assert_macro_right = 1860;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
    }

    public static final /* synthetic */ void $anonfun$new$34(ExecutePlanResponse x$13) {
    }

    public static final /* synthetic */ void $anonfun$new$36(ExecutePlanResponse x$14) {
    }

    public SparkConnectClientSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.test("SPARK-51391: Use 'user.name' by default", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.client_$eq(SparkConnectClient$.MODULE$.builder().build());
            String $org_scalatest_assert_macro_left = this.client().userId();
            String $org_scalatest_assert_macro_right = System.getProperty("user.name");
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("Placeholder test: Create SparkConnectClient", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.client_$eq(SparkConnectClient$.MODULE$.builder().userId("abc123").build());
            String $org_scalatest_assert_macro_left = this.client().userId();
            String $org_scalatest_assert_macro_right = "abc123";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("Test connection", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testClientConnection(this.testClientConnection$default$1(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)testPort -> SparkConnectClientSuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)testPort))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("Test connection string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testClientConnection(this.testClientConnection$default$1(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)testPort -> SparkConnectClientSuite.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)testPort))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("Test encryption", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
            Function1 & Serializable x$2 = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$8(x$6));
            String x$3 = "TestPolicy";
            FiniteDuration x$4 = RetryPolicy$.MODULE$.apply$default$2();
            Option x$5 = RetryPolicy$.MODULE$.apply$default$3();
            double x$62 = RetryPolicy$.MODULE$.apply$default$4();
            FiniteDuration x$7 = RetryPolicy$.MODULE$.apply$default$5();
            FiniteDuration x$8 = RetryPolicy$.MODULE$.apply$default$6();
            boolean x$9 = RetryPolicy$.MODULE$.apply$default$9();
            Option x$10 = RetryPolicy$.MODULE$.apply$default$10();
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort() + "/;use_ssl=true").retryPolicy(new RetryPolicy((Option)x$1, x$4, x$5, x$62, x$7, x$8, (Function1)x$2, "TestPolicy", x$9, x$10)).build());
            AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().setSessionId("abc123").build();
            return this.assertThrows((Function0 & Serializable)() -> this.client().analyze(request), ClassTag$.MODULE$.apply(SparkException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("SparkSession create with SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)("sc://localhost:" + this.server().getPort()))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().create();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                SparkSession session2 = SparkSession$.MODULE$.builder().create();
                SparkSession $org_scalatest_assert_macro_left2 = session;
                SparkSession $org_scalatest_assert_macro_right2 = session2;
                SparkSession sparkSession = $org_scalatest_assert_macro_left2;
                SparkSession sparkSession2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("SparkSession getOrCreate with SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)("sc://localhost:" + this.server().getPort()))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().getOrCreate();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                SparkSession session2 = SparkSession$.MODULE$.builder().getOrCreate();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session);
                SparkSession $org_scalatest_assert_macro_right2 = session2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("Builder.remote takes precedence over SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            String incorrectUrl = "sc://localhost:" + (this.server().getPort() + 1);
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)incorrectUrl)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().remote("sc://localhost:" + this.server().getPort()).getOrCreate();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("SparkSession initialisation with connection string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).build());
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).create();
            Dataset df = session.range(10L);
            df.analyze();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
            Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("Custom Interceptor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).interceptor(new ClientInterceptor(null){

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                    throw new RuntimeException("Blocked");
                }
            }).build());
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).create();
            return this.assertThrows((Function0)(JFunction0.mcJ.sp & Serializable)() -> session.range(10L).count(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("error framework parameters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.collection.immutable.Map errors = GrpcExceptionConverter$.MODULE$.errorFactory();
            errors.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$20(check$ifrefutable$3))).withFilter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$21(x$7))).foreach((Function1 & Serializable)x$8 -> {
                Tuple2 tuple2 = x$8;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Function1 constructor = (Function1)tuple2._2();
                    return (Assertion)this.withClue(name, (Function0 & Serializable)() -> {
                        GrpcExceptionConverter.ErrorParams testParams = new GrpcExceptionConverter.ErrorParams("", (Option)None$.MODULE$, (Option)new Some((Object)"DUPLICATE_KEY"), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keyColumn"), (Object)"`abc`")})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)));
                        Throwable error = (Throwable)constructor.apply((Object)testParams);
                        String $org_scalatest_assert_macro_left = error.getMessage();
                        String $org_scalatest_assert_macro_right = testParams.message();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
                        Throwable $org_scalatest_assert_macro_left2 = error.getCause();
                        Object $org_scalatest_assert_macro_right2 = null;
                        Throwable throwable = $org_scalatest_assert_macro_left2;
                        Object var9_8 = null;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(throwable != null ? !throwable.equals(var9_8) : var9_8 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
                        String $org_scalatest_assert_macro_left3 = ((SparkThrowable)error).getCondition();
                        String $org_scalatest_assert_macro_right3 = (String)testParams.errorClass().get();
                        String string = $org_scalatest_assert_macro_left3;
                        String string2 = $org_scalatest_assert_macro_right3;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
                        scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = CollectionConverters$.MODULE$.MapHasAsScala(((SparkThrowable)error).getMessageParameters()).asScala();
                        scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = testParams.messageParameters();
                        scala.collection.mutable.Map map = $org_scalatest_assert_macro_left4;
                        scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right4;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
                        Object $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])((SparkThrowable)error).getQueryContext());
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left5), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left5), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
                    });
                }
                throw new MatchError((Object)tuple2);
            });
            errors.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$24(check$ifrefutable$4))).withFilter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$25(x$9))).foreach((Function1 & Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Function1 constructor = (Function1)tuple2._2();
                    return (Assertion)this.withClue(name, (Function0 & Serializable)() -> {
                        GrpcExceptionConverter.ErrorParams testParams = new GrpcExceptionConverter.ErrorParams("Found duplicate keys `abc`", (Option)None$.MODULE$, (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)));
                        Throwable error = (Throwable)constructor.apply((Object)testParams);
                        String $org_scalatest_assert_macro_left = error.getMessage();
                        String $org_scalatest_assert_macro_right = testParams.message();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                        Throwable $org_scalatest_assert_macro_left2 = error.getCause();
                        Object $org_scalatest_assert_macro_right2 = null;
                        Throwable throwable = $org_scalatest_assert_macro_left2;
                        Object var9_8 = null;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(throwable != null ? !throwable.equals(var9_8) : var9_8 != null), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.URIs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestPackURI[]{new TestPackURI(this, "sc://host", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://localhost/", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            this.testClientConnection(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)x$12 -> client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://localhost:1234/", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$3(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://localhost/;", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$4(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://host:123", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;user_id=a94", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$5(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://host:123/;user_agent=a945", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$6(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "scc://host:12", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "http://host", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc:/host:1234/path", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host/path", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host/;parm1;param2", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123;user_id=a94", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc:///user_id=123", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:-4", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://:123/", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=true", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;session_id=", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;session_id=abcdefgh", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;session_id=" + UUID.randomUUID().toString(), true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=true;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken;use_ssl=true", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=false;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken;use_ssl=false", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;param1=value1;param2=value2", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://SPARK-45486", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$7(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://SPARK-47694:123/;grpc_max_message_size=1860", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$8(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://SPARK-47694:123/;grpc_max_message_size=abc", false, this.TestPackURI().apply$default$3())}));
        this.URIs().foreach((Function1 & Serializable)testPack -> {
            this.test("Check URI: " + testPack.connectionString() + ", isCorrect: " + testPack.isCorrect(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                if (!testPack.isCorrect()) {
                    return $this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.checkTestPack(testPack), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
                }
                $this.checkTestPack(testPack);
                return BoxedUnit.UNIT;
            }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            return BoxedUnit.UNIT;
        });
        this.test("ArtifactManager retries errors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IntRef attempt = IntRef.create((int)0);
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).interceptor(new ClientInterceptor(null, attempt){
                private final IntRef attempt$1;

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                    ++this.attempt$1.elem;
                    if (this.attempt$1.elem <= 3) {
                        throw Status.UNAVAILABLE.withDescription("").asRuntimeException();
                    }
                    return channel.newCall(methodDescriptor, callOptions);
                }
                {
                    this.attempt$1 = attempt$1;
                }
            }).build());
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).create();
            Path artifactFilePath = this.commonResourcePath().resolve("artifact-tests");
            Path path = artifactFilePath.resolve("smallClassFile.class");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(path.toFile().exists(), "path.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            session.addArtifact(((Object)path).toString());
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("SPARK-45871: Client execute iterator.toSeq consumes the reattachable iterator", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).enableReattachableExecute().build());
            Plan plan = this.buildPlan("select * from range(10000000)");
            SparkConnectClient qual$1 = this.client();
            Plan x$11 = plan;
            Option x$12 = qual$1.execute$default$2();
            CloseableIterator iter = qual$1.execute(x$11, x$12);
            ExecutePlanResponseReattachableIterator reattachableIter = ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator((Iterator)iter);
            iter.toSeq();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        this.test("SPARK-45871: Client execute iterator.foreach consumes the reattachable iterator", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).enableReattachableExecute().build());
            Plan plan = this.buildPlan("select * from range(10000000)");
            SparkConnectClient qual$2 = this.client();
            Plan x$132 = plan;
            Option x$14 = qual$2.execute$default$2();
            CloseableIterator iter = qual$2.execute(x$132, x$14);
            ExecutePlanResponseReattachableIterator reattachableIter = ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator((Iterator)iter);
            iter.foreach((Function1 & Serializable)x$13 -> {
                SparkConnectClientSuite.$anonfun$new$34(x$13);
                return BoxedUnit.UNIT;
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        this.test("SPARK-48056: Client execute gets INVALID_HANDLE.SESSION_NOT_FOUND and proceeds", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).enableReattachableExecute().build());
            this.service().errorToThrowOnExecute_$eq((Option<Throwable>)new Some((Object)new StatusRuntimeException(Status.INTERNAL.withDescription("INVALID_HANDLE.SESSION_NOT_FOUND"))));
            Plan plan = this.buildPlan("select * from range(1)");
            SparkConnectClient qual$3 = this.client();
            Plan x$15 = plan;
            Option x$16 = qual$3.execute$default$2();
            CloseableIterator iter = qual$3.execute(x$15, x$16);
            ExecutePlanResponseReattachableIterator reattachableIter = ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator((Iterator)iter);
            reattachableIter.foreach((Function1 & Serializable)x$14 -> {
                SparkConnectClientSuite.$anonfun$new$36(x$14);
                return BoxedUnit.UNIT;
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.INVALID_HOST = "host.invalid";
        this.test("GRPC stub unary call throws error immediately", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ManagedChannel channel = this.createUnresolvableHostChannel();
            SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub = SparkConnectServiceGrpc.newBlockingStub((Channel)channel);
            AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().build();
            StatusRuntimeException ex = (StatusRuntimeException)this.intercept((Function0 & Serializable)() -> stub.analyzePlan(request), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
            return this.assertContainsUnavailable((Throwable)ex);
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        this.test("GRPC stub server streaming call throws error on first next() / hasNext()", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ManagedChannel channel = this.createUnresolvableHostChannel();
            SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub = SparkConnectServiceGrpc.newBlockingStub((Channel)channel);
            ExecutePlanRequest request = ExecutePlanRequest.newBuilder().build();
            java.util.Iterator iter = stub.executePlan(request);
            StatusRuntimeException ex = (StatusRuntimeException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> iter.hasNext(), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
            return this.assertContainsUnavailable((Throwable)ex);
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        this.test("GRPC stub client streaming call throws error on first client request sent", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ManagedChannel channel = this.createUnresolvableHostChannel();
            SparkConnectServiceGrpc.SparkConnectServiceStub stub = SparkConnectServiceGrpc.newStub((Channel)channel);
            ObjectRef onNextResponse = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef onErrorThrowable = ObjectRef.create((Object)None$.MODULE$);
            BooleanRef onCompletedCalled = BooleanRef.create((boolean)false);
            StreamObserver<AddArtifactsResponse> responseObserver = new StreamObserver<AddArtifactsResponse>(null, onNextResponse, onErrorThrowable, onCompletedCalled){
                private final ObjectRef onNextResponse$1;
                private final ObjectRef onErrorThrowable$1;
                private final BooleanRef onCompletedCalled$1;

                public void onNext(AddArtifactsResponse value) {
                    this.onNextResponse$1.elem = new Some((Object)value);
                }

                public void onError(Throwable t) {
                    this.onErrorThrowable$1.elem = new Some((Object)t);
                }

                public void onCompleted() {
                    this.onCompletedCalled$1.elem = false;
                }
                {
                    this.onNextResponse$1 = onNextResponse$1;
                    this.onErrorThrowable$1 = onErrorThrowable$1;
                    this.onCompletedCalled$1 = onCompletedCalled$1;
                }
            };
            StreamObserver observer = stub.addArtifacts((StreamObserver)responseObserver);
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                Option $org_scalatest_assert_macro_left = (Option)onNextResponse$1.elem;
                None$ $org_scalatest_assert_macro_right = None$.MODULE$;
                Option option = $org_scalatest_assert_macro_left;
                None$ none$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((Option)onErrorThrowable$1.elem).isDefined(), "onErrorThrowable.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
                this.assertContainsUnavailable((Throwable)((Option)onErrorThrowable$1.elem).get());
                boolean $org_scalatest_assert_macro_left2 = onCompletedCalled$1.elem;
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
            observer.onNext((Object)AddArtifactsRequest.newBuilder().build());
            observer.onCompleted();
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        this.test("client can set a custom operation id for ExecutePlan requests", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString("sc://localhost:" + this.server().getPort()).enableReattachableExecute().build());
            Plan plan = this.buildPlan("select * from range(10000000)");
            String dummyUUID = "10a4c38e-7e87-40ee-9d6f-60ff0751e63b";
            CloseableIterator iter = this.client().execute(plan, (Option)new Some((Object)dummyUUID));
            ExecutePlanResponseReattachableIterator reattachableIter = ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator((Iterator)iter);
            String $org_scalatest_assert_macro_left = reattachableIter.operationId();
            String $org_scalatest_assert_macro_right = dummyUUID;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
            while (reattachableIter.hasNext()) {
                ExecutePlanResponse resp = reattachableIter.next();
                String $org_scalatest_assert_macro_left2 = resp.getOperationId();
                String $org_scalatest_assert_macro_right2 = dummyUUID;
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            }
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
    }

    private class TestPackURI
    implements Product,
    Serializable {
        private final String connectionString;
        private final boolean isCorrect;
        private final Function1<SparkConnectClient, BoxedUnit> extraChecks;
        public final /* synthetic */ SparkConnectClientSuite $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String connectionString() {
            return this.connectionString;
        }

        public boolean isCorrect() {
            return this.isCorrect;
        }

        public Function1<SparkConnectClient, BoxedUnit> extraChecks() {
            return this.extraChecks;
        }

        public TestPackURI copy(String connectionString, boolean isCorrect, Function1<SparkConnectClient, BoxedUnit> extraChecks) {
            return new TestPackURI(this.org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer(), connectionString, isCorrect, extraChecks);
        }

        public String copy$default$1() {
            return this.connectionString();
        }

        public boolean copy$default$2() {
            return this.isCorrect();
        }

        public Function1<SparkConnectClient, BoxedUnit> copy$default$3() {
            return this.extraChecks();
        }

        public String productPrefix() {
            return "TestPackURI";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.connectionString();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isCorrect());
                }
                case 2: {
                    return this.extraChecks();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestPackURI;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "connectionString";
                }
                case 1: {
                    return "isCorrect";
                }
                case 2: {
                    return "extraChecks";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.connectionString()));
            n = Statics.mix((int)n, (int)(this.isCorrect() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.extraChecks()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestPackURI)) return false;
            if (((TestPackURI)object).org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer() != this.org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestPackURI testPackURI = (TestPackURI)x$1;
            if (this.isCorrect() != testPackURI.isCorrect()) return false;
            String string = this.connectionString();
            String string2 = testPackURI.connectionString();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Function1<SparkConnectClient, BoxedUnit> function1 = this.extraChecks();
            Function1<SparkConnectClient, BoxedUnit> function12 = testPackURI.extraChecks();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!testPackURI.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ SparkConnectClientSuite org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer() {
            return this.$outer;
        }

        public TestPackURI(SparkConnectClientSuite $outer, String connectionString, boolean isCorrect, Function1<SparkConnectClient, BoxedUnit> extraChecks) {
            this.connectionString = connectionString;
            this.isCorrect = isCorrect;
            this.extraChecks = extraChecks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

