/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils$;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.arrow.ArrowEncoderUtils$;
import org.apache.spark.sql.connect.client.arrow.ArrowEncoderUtils$Classes$;
import org.apache.spark.sql.connect.client.arrow.ArrowSerializer;
import org.apache.spark.sql.connect.client.arrow.StructVectors$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class ArrowSerializer$ {
    public static ArrowSerializer$ MODULE$;
    private final MethodHandles.Lookup methodLookup;

    static {
        new ArrowSerializer$();
    }

    public <T> CloseableIterator<byte[]> serialize(Iterator<T> input, AgnosticEncoder<T> enc, BufferAllocator allocator, int maxRecordsPerBatch, long maxBatchSize, String timeZoneId, int batchSizeCheckInterval) {
        Predef$.MODULE$.assert(maxRecordsPerBatch > 0);
        Predef$.MODULE$.assert(maxBatchSize > 0L);
        Predef$.MODULE$.assert(batchSizeCheckInterval > 0);
        return new CloseableIterator<byte[]>(enc, allocator, timeZoneId, batchSizeCheckInterval, maxBatchSize, input, maxRecordsPerBatch){
            private final ArrowSerializer<T> serializer;
            private final ByteArrayOutputStream bytes;
            private boolean hasWrittenFirstBatch;
            private final int batchSizeCheckInterval$1;
            private final long maxBatchSize$1;
            private final Iterator input$1;
            private final int maxRecordsPerBatch$1;

            public java.util.Iterator<byte[]> asJava() {
                return CloseableIterator.asJava$(this);
            }

            public Iterator<byte[]> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<byte[]> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<byte[]> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<byte[], B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<byte[], U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<byte[]> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<byte[]> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<byte[]> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<byte[]> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<byte[], Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<byte[]> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<byte[]> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<byte[]> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<byte[]> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<byte[], Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private ArrowSerializer<T> serializer() {
                return this.serializer;
            }

            private ByteArrayOutputStream bytes() {
                return this.bytes;
            }

            private boolean hasWrittenFirstBatch() {
                return this.hasWrittenFirstBatch;
            }

            private void hasWrittenFirstBatch_$eq(boolean x$1) {
                this.hasWrittenFirstBatch = x$1;
            }

            private boolean sizeOk(int i) {
                if (i > 0 && i % this.batchSizeCheckInterval$1 == 0) {
                    return this.serializer().sizeInBytes() < this.maxBatchSize$1;
                }
                return true;
            }

            public boolean hasNext() {
                return (this.input$1.hasNext() || !this.hasWrittenFirstBatch()) && !this.serializer().isClosed();
            }

            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.serializer().reset();
                this.bytes().reset();
                for (int i = 0; i < this.maxRecordsPerBatch$1 && this.input$1.hasNext() && this.sizeOk(i); ++i) {
                    this.serializer().append(this.input$1.next());
                }
                this.serializer().writeIpcStream(this.bytes());
                this.hasWrittenFirstBatch_$eq(true);
                return this.bytes().toByteArray();
            }

            public void close() {
                this.serializer().close();
            }
            {
                this.batchSizeCheckInterval$1 = batchSizeCheckInterval$1;
                this.maxBatchSize$1 = maxBatchSize$1;
                this.input$1 = input$1;
                this.maxRecordsPerBatch$1 = maxRecordsPerBatch$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                CloseableIterator.$init$(this);
                this.serializer = new ArrowSerializer<T>(enc$1, allocator$1, timeZoneId$1);
                this.bytes = new ByteArrayOutputStream();
                this.hasWrittenFirstBatch = false;
            }
        };
    }

    public <T> ByteString serialize(Iterator<T> input, AgnosticEncoder<T> enc, BufferAllocator allocator, String timeZoneId) {
        ByteString byteString;
        try (ArrowSerializer serializer = new ArrowSerializer(enc, allocator, timeZoneId);){
            input.foreach((Function1 & Serializable & scala.Serializable)record -> {
                serializer.append(record);
                return BoxedUnit.UNIT;
            });
            ByteString.Output output = ByteString.newOutput();
            serializer.writeIpcStream((OutputStream)output);
            byteString = output.toByteString();
        }
        return byteString;
    }

    public <T> int serialize$default$7() {
        return 128;
    }

    public <T> Tuple2<VectorSchemaRoot, ArrowSerializer.Serializer> serializerFor(AgnosticEncoder<T> encoder, BufferAllocator allocator, String timeZoneId) {
        ArrowSerializer.Serializer serializer;
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(encoder.schema(), timeZoneId, true, ArrowUtils$.MODULE$.toArrowSchema$default$4());
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)allocator);
        StructType structType = encoder.schema();
        DataType dataType = encoder.dataType();
        if (structType == null ? dataType != null : !structType.equals(dataType)) {
            Predef$.MODULE$.assert(root.getSchema().getFields().size() == 1);
            serializer = this.serializerFor(encoder, root.getVector(0));
        } else {
            serializer = this.serializerFor(encoder, root);
        }
        ArrowSerializer.Serializer serializer2 = serializer;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)root), (Object)serializer2);
    }

    public <E> ArrowSerializer.Serializer serializerFor(AgnosticEncoder<E> encoder, Object v2) {
        AgnosticEncoder agnosticEncoder;
        Tuple2 tuple2 = new Tuple2(encoder, v2);
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder2 = (AgnosticEncoder)tuple2._1();
            Object v3 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$.equals(agnosticEncoder2) ? true : AgnosticEncoders.BoxedBooleanEncoder$.MODULE$.equals(agnosticEncoder2)) && v3 instanceof BitVector) {
                BitVector bitVector = (BitVector)v3;
                return new ArrowSerializer.FieldSerializer<Object, BitVector>(bitVector){

                    public void set(int index, boolean value) {
                        ((BitVector)this.vector()).setSafe(index, value ? 1 : 0);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder3 = (AgnosticEncoder)tuple2._1();
            Object v4 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveByteEncoder$.MODULE$.equals(agnosticEncoder3) ? true : AgnosticEncoders.BoxedByteEncoder$.MODULE$.equals(agnosticEncoder3)) && v4 instanceof TinyIntVector) {
                TinyIntVector tinyIntVector = (TinyIntVector)v4;
                return new ArrowSerializer.FieldSerializer<Object, TinyIntVector>(tinyIntVector){

                    public void set(int index, byte value) {
                        ((TinyIntVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder4 = (AgnosticEncoder)tuple2._1();
            Object v5 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveShortEncoder$.MODULE$.equals(agnosticEncoder4) ? true : AgnosticEncoders.BoxedShortEncoder$.MODULE$.equals(agnosticEncoder4)) && v5 instanceof SmallIntVector) {
                SmallIntVector smallIntVector = (SmallIntVector)v5;
                return new ArrowSerializer.FieldSerializer<Object, SmallIntVector>(smallIntVector){

                    public void set(int index, short value) {
                        ((SmallIntVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder5 = (AgnosticEncoder)tuple2._1();
            Object v6 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveIntEncoder$.MODULE$.equals(agnosticEncoder5) ? true : AgnosticEncoders.BoxedIntEncoder$.MODULE$.equals(agnosticEncoder5)) && v6 instanceof IntVector) {
                IntVector intVector = (IntVector)v6;
                return new ArrowSerializer.FieldSerializer<Object, IntVector>(intVector){

                    public void set(int index, int value) {
                        ((IntVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder6 = (AgnosticEncoder)tuple2._1();
            Object v7 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveLongEncoder$.MODULE$.equals(agnosticEncoder6) ? true : AgnosticEncoders.BoxedLongEncoder$.MODULE$.equals(agnosticEncoder6)) && v7 instanceof BigIntVector) {
                BigIntVector bigIntVector = (BigIntVector)v7;
                return new ArrowSerializer.FieldSerializer<Object, BigIntVector>(bigIntVector){

                    public void set(int index, long value) {
                        ((BigIntVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder7 = (AgnosticEncoder)tuple2._1();
            Object v8 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$.equals(agnosticEncoder7) ? true : AgnosticEncoders.BoxedFloatEncoder$.MODULE$.equals(agnosticEncoder7)) && v8 instanceof Float4Vector) {
                Float4Vector float4Vector = (Float4Vector)v8;
                return new ArrowSerializer.FieldSerializer<Object, Float4Vector>(float4Vector){

                    public void set(int index, float value) {
                        ((Float4Vector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder8 = (AgnosticEncoder)tuple2._1();
            Object v9 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$.equals(agnosticEncoder8) ? true : AgnosticEncoders.BoxedDoubleEncoder$.MODULE$.equals(agnosticEncoder8)) && v9 instanceof Float8Vector) {
                Float8Vector float8Vector = (Float8Vector)v9;
                return new ArrowSerializer.FieldSerializer<Object, Float8Vector>(float8Vector){

                    public void set(int index, double value) {
                        ((Float8Vector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder9 = (AgnosticEncoder)tuple2._1();
            Object v10 = tuple2._2();
            if (AgnosticEncoders.NullEncoder$.MODULE$.equals(agnosticEncoder9) && v10 instanceof NullVector) {
                NullVector nullVector = (NullVector)v10;
                return new ArrowSerializer.FieldSerializer<BoxedUnit, NullVector>(nullVector){

                    public void set(int index, BoxedUnit value) {
                        ((NullVector)this.vector()).setNull(index);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder10 = (AgnosticEncoder)tuple2._1();
            Object v11 = tuple2._2();
            if (AgnosticEncoders.StringEncoder$.MODULE$.equals(agnosticEncoder10) && v11 instanceof VarCharVector) {
                VarCharVector varCharVector = (VarCharVector)v11;
                return new ArrowSerializer.FieldSerializer<String, VarCharVector>(varCharVector){
                    private final VarCharVector x110$1;

                    public void set(int index, String value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString(this.x110$1, index, value);
                    }
                    {
                        this.x110$1 = x110$1;
                        super(x110$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder11 = (AgnosticEncoder)tuple2._1();
            Object v12 = tuple2._2();
            if (agnosticEncoder11 instanceof AgnosticEncoders.JavaEnumEncoder && v12 instanceof VarCharVector) {
                VarCharVector varCharVector = (VarCharVector)v12;
                return new ArrowSerializer.FieldSerializer<Enum<?>, VarCharVector>(varCharVector){
                    private final VarCharVector x111$1;

                    public void set(int index, Enum<?> value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString(this.x111$1, index, value.name());
                    }
                    {
                        this.x111$1 = x111$1;
                        super(x111$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder12 = (AgnosticEncoder)tuple2._1();
            Object v13 = tuple2._2();
            if (agnosticEncoder12 instanceof AgnosticEncoders.ScalaEnumEncoder && v13 instanceof VarCharVector) {
                VarCharVector varCharVector = (VarCharVector)v13;
                return new ArrowSerializer.FieldSerializer<Enumeration.Value, VarCharVector>(varCharVector){
                    private final VarCharVector x112$1;

                    public void set(int index, Enumeration.Value value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString(this.x112$1, index, value.toString());
                    }
                    {
                        this.x112$1 = x112$1;
                        super(x112$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder13 = (AgnosticEncoder)tuple2._1();
            Object v14 = tuple2._2();
            if (AgnosticEncoders.BinaryEncoder$.MODULE$.equals(agnosticEncoder13) && v14 instanceof VarBinaryVector) {
                VarBinaryVector varBinaryVector = (VarBinaryVector)v14;
                return new ArrowSerializer.FieldSerializer<byte[], VarBinaryVector>(varBinaryVector){

                    public void set(int index, byte[] value) {
                        ((BaseVariableWidthVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder14 = (AgnosticEncoder)tuple2._1();
            Object v15 = tuple2._2();
            if (agnosticEncoder14 instanceof AgnosticEncoders.SparkDecimalEncoder && v15 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v15;
                return new ArrowSerializer.FieldSerializer<Decimal, DecimalVector>(decimalVector){

                    public void set(int index, Decimal value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, value.toJavaBigDecimal());
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder15 = (AgnosticEncoder)tuple2._1();
            Object v16 = tuple2._2();
            if (agnosticEncoder15 instanceof AgnosticEncoders.ScalaDecimalEncoder && v16 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v16;
                return new ArrowSerializer.FieldSerializer<scala.math.BigDecimal, DecimalVector>(decimalVector){

                    public void set(int index, scala.math.BigDecimal value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, value.bigDecimal());
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.JavaDecimalEncoder javaDecimalEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder16 = (AgnosticEncoder)tuple2._1();
            Object v17 = tuple2._2();
            if (agnosticEncoder16 instanceof AgnosticEncoders.JavaDecimalEncoder && !(bl = (javaDecimalEncoder = (AgnosticEncoders.JavaDecimalEncoder)agnosticEncoder16).lenientSerialization()) && v17 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v17;
                return new ArrowSerializer.FieldSerializer<BigDecimal, DecimalVector>(decimalVector){

                    public void set(int index, BigDecimal value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.JavaDecimalEncoder javaDecimalEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder17 = (AgnosticEncoder)tuple2._1();
            Object v18 = tuple2._2();
            if (agnosticEncoder17 instanceof AgnosticEncoders.JavaDecimalEncoder && (bl = (javaDecimalEncoder = (AgnosticEncoders.JavaDecimalEncoder)agnosticEncoder17).lenientSerialization()) && v18 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v18;
                return new ArrowSerializer.FieldSerializer<Object, DecimalVector>(decimalVector){

                    public void set(int index, Object value) {
                        BigDecimal bigDecimal;
                        Object object = value;
                        if (object instanceof BigDecimal) {
                            BigDecimal bigDecimal2;
                            bigDecimal = bigDecimal2 = (BigDecimal)object;
                        } else if (object instanceof scala.math.BigDecimal) {
                            scala.math.BigDecimal bigDecimal3 = (scala.math.BigDecimal)object;
                            bigDecimal = bigDecimal3.bigDecimal();
                        } else if (object instanceof BigInt) {
                            BigInt bigInt = (BigInt)object;
                            bigDecimal = new BigDecimal(bigInt.bigInteger());
                        } else if (object instanceof BigInteger) {
                            BigInteger bigInteger = (BigInteger)object;
                            bigDecimal = new BigDecimal(bigInteger);
                        } else if (object instanceof Decimal) {
                            Decimal decimal = (Decimal)object;
                            bigDecimal = decimal.toJavaBigDecimal();
                        } else {
                            throw new MatchError(object);
                        }
                        BigDecimal decimal = bigDecimal;
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, decimal);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder18 = (AgnosticEncoder)tuple2._1();
            Object v19 = tuple2._2();
            if (AgnosticEncoders.ScalaBigIntEncoder$.MODULE$.equals(agnosticEncoder18) && v19 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v19;
                return new ArrowSerializer.FieldSerializer<BigInt, DecimalVector>(decimalVector){

                    public void set(int index, BigInt value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, new BigDecimal(value.bigInteger()));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder19 = (AgnosticEncoder)tuple2._1();
            Object v20 = tuple2._2();
            if (AgnosticEncoders.JavaBigIntEncoder$.MODULE$.equals(agnosticEncoder19) && v20 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v20;
                return new ArrowSerializer.FieldSerializer<BigInteger, DecimalVector>(decimalVector){

                    public void set(int index, BigInteger value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, new BigDecimal(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder20 = (AgnosticEncoder)tuple2._1();
            Object v21 = tuple2._2();
            if (AgnosticEncoders.DayTimeIntervalEncoder$.MODULE$.equals(agnosticEncoder20) && v21 instanceof DurationVector) {
                DurationVector durationVector = (DurationVector)v21;
                return new ArrowSerializer.FieldSerializer<Duration, DurationVector>(durationVector){

                    public void set(int index, Duration value) {
                        ((DurationVector)this.vector()).setSafe(index, SparkIntervalUtils$.MODULE$.durationToMicros(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder21 = (AgnosticEncoder)tuple2._1();
            Object v22 = tuple2._2();
            if (AgnosticEncoders.YearMonthIntervalEncoder$.MODULE$.equals(agnosticEncoder21) && v22 instanceof IntervalYearVector) {
                IntervalYearVector intervalYearVector = (IntervalYearVector)v22;
                return new ArrowSerializer.FieldSerializer<Period, IntervalYearVector>(intervalYearVector){

                    public void set(int index, Period value) {
                        ((IntervalYearVector)this.vector()).setSafe(index, SparkIntervalUtils$.MODULE$.periodToMonths(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.LocalDateEncoder localDateEncoder;
            boolean bl;
            AgnosticEncoders.DateEncoder dateEncoder;
            boolean bl2;
            AgnosticEncoder agnosticEncoder22 = (AgnosticEncoder)tuple2._1();
            Object v23 = tuple2._2();
            if ((agnosticEncoder22 instanceof AgnosticEncoders.DateEncoder && true == (bl2 = (dateEncoder = (AgnosticEncoders.DateEncoder)agnosticEncoder22).lenientSerialization()) ? true : agnosticEncoder22 instanceof AgnosticEncoders.LocalDateEncoder && true == (bl = (localDateEncoder = (AgnosticEncoders.LocalDateEncoder)agnosticEncoder22).lenientSerialization())) && v23 instanceof DateDayVector) {
                DateDayVector dateDayVector = (DateDayVector)v23;
                return new ArrowSerializer.FieldSerializer<Object, DateDayVector>(dateDayVector){

                    public void set(int index, Object value) {
                        ((DateDayVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.anyToDays(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.DateEncoder dateEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder23 = (AgnosticEncoder)tuple2._1();
            Object v24 = tuple2._2();
            if (agnosticEncoder23 instanceof AgnosticEncoders.DateEncoder && !(bl = (dateEncoder = (AgnosticEncoders.DateEncoder)agnosticEncoder23).lenientSerialization()) && v24 instanceof DateDayVector) {
                DateDayVector dateDayVector = (DateDayVector)v24;
                return new ArrowSerializer.FieldSerializer<Date, DateDayVector>(dateDayVector){

                    public void set(int index, Date value) {
                        ((DateDayVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.fromJavaDate(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.LocalDateEncoder localDateEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder24 = (AgnosticEncoder)tuple2._1();
            Object v25 = tuple2._2();
            if (agnosticEncoder24 instanceof AgnosticEncoders.LocalDateEncoder && !(bl = (localDateEncoder = (AgnosticEncoders.LocalDateEncoder)agnosticEncoder24).lenientSerialization()) && v25 instanceof DateDayVector) {
                DateDayVector dateDayVector = (DateDayVector)v25;
                return new ArrowSerializer.FieldSerializer<LocalDate, DateDayVector>(dateDayVector){

                    public void set(int index, LocalDate value) {
                        ((DateDayVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.localDateToDays(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.InstantEncoder instantEncoder;
            boolean bl;
            AgnosticEncoders.TimestampEncoder timestampEncoder;
            boolean bl3;
            AgnosticEncoder agnosticEncoder25 = (AgnosticEncoder)tuple2._1();
            Object v26 = tuple2._2();
            if ((agnosticEncoder25 instanceof AgnosticEncoders.TimestampEncoder && true == (bl3 = (timestampEncoder = (AgnosticEncoders.TimestampEncoder)agnosticEncoder25).lenientSerialization()) ? true : agnosticEncoder25 instanceof AgnosticEncoders.InstantEncoder && true == (bl = (instantEncoder = (AgnosticEncoders.InstantEncoder)agnosticEncoder25).lenientSerialization())) && v26 instanceof TimeStampMicroTZVector) {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)v26;
                return new ArrowSerializer.FieldSerializer<Object, TimeStampMicroTZVector>(timeStampMicroTZVector){

                    public void set(int index, Object value) {
                        ((TimeStampVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.anyToMicros(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.TimestampEncoder timestampEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder26 = (AgnosticEncoder)tuple2._1();
            Object v27 = tuple2._2();
            if (agnosticEncoder26 instanceof AgnosticEncoders.TimestampEncoder && !(bl = (timestampEncoder = (AgnosticEncoders.TimestampEncoder)agnosticEncoder26).lenientSerialization()) && v27 instanceof TimeStampMicroTZVector) {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)v27;
                return new ArrowSerializer.FieldSerializer<Timestamp, TimeStampMicroTZVector>(timeStampMicroTZVector){

                    public void set(int index, Timestamp value) {
                        ((TimeStampVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.fromJavaTimestamp(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.InstantEncoder instantEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder27 = (AgnosticEncoder)tuple2._1();
            Object v28 = tuple2._2();
            if (agnosticEncoder27 instanceof AgnosticEncoders.InstantEncoder && !(bl = (instantEncoder = (AgnosticEncoders.InstantEncoder)agnosticEncoder27).lenientSerialization()) && v28 instanceof TimeStampMicroTZVector) {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)v28;
                return new ArrowSerializer.FieldSerializer<Instant, TimeStampMicroTZVector>(timeStampMicroTZVector){

                    public void set(int index, Instant value) {
                        ((TimeStampVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.instantToMicros(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder28 = (AgnosticEncoder)tuple2._1();
            Object v29 = tuple2._2();
            if (AgnosticEncoders.LocalDateTimeEncoder$.MODULE$.equals(agnosticEncoder28) && v29 instanceof TimeStampMicroVector) {
                TimeStampMicroVector timeStampMicroVector = (TimeStampMicroVector)v29;
                return new ArrowSerializer.FieldSerializer<LocalDateTime, TimeStampMicroVector>(timeStampMicroVector){

                    public void set(int index, LocalDateTime value) {
                        ((TimeStampVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.localDateTimeToMicros(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder29 = (AgnosticEncoder)tuple2._1();
            Object v30 = tuple2._2();
            if (agnosticEncoder29 instanceof AgnosticEncoders.OptionEncoder) {
                AgnosticEncoders.OptionEncoder optionEncoder = (AgnosticEncoders.OptionEncoder)agnosticEncoder29;
                AgnosticEncoder value = optionEncoder.elementEncoder();
                return new ArrowSerializer.Serializer(value, v30){
                    private final ArrowSerializer.Serializer delegate;

                    public void write(int index, Object value) {
                        Object object = value;
                        if (object instanceof Some) {
                            Some some = (Some)object;
                            Object value2 = some.value();
                            this.delegate.write(index, value2);
                            return;
                        }
                        this.delegate.write(index, null);
                    }
                    {
                        this.delegate = ArrowSerializer$.MODULE$.serializerFor(value$1, v$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder30 = (AgnosticEncoder)tuple2._1();
            Object v31 = tuple2._2();
            if (agnosticEncoder30 instanceof AgnosticEncoders.ArrayEncoder) {
                AgnosticEncoders.ArrayEncoder arrayEncoder = (AgnosticEncoders.ArrayEncoder)agnosticEncoder30;
                AgnosticEncoder element = arrayEncoder.element();
                if (v31 instanceof ListVector) {
                    ListVector listVector = (ListVector)v31;
                    ArrowSerializer.Serializer elementSerializer = this.serializerFor(element, listVector.getDataVector());
                    Function1 & Serializable & scala.Serializable toIterator = (Function1 & Serializable & scala.Serializable)array -> Predef$.MODULE$.genericArrayOps(array).iterator();
                    return new ArrowSerializer.ArraySerializer(listVector, (Function1<Object, Iterator<Object>>)toIterator, elementSerializer);
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder31 = (AgnosticEncoder)tuple2._1();
            Object v32 = tuple2._2();
            if (agnosticEncoder31 instanceof AgnosticEncoders.IterableEncoder) {
                AgnosticEncoders.IterableEncoder iterableEncoder = (AgnosticEncoders.IterableEncoder)agnosticEncoder31;
                ClassTag tag = iterableEncoder.clsTag();
                AgnosticEncoder element = iterableEncoder.element();
                boolean lenient = iterableEncoder.lenientSerialization();
                if (v32 instanceof ListVector) {
                    Function1 & Serializable & scala.Serializable intersect;
                    ListVector listVector = (ListVector)v32;
                    ArrowSerializer.Serializer elementSerializer = this.serializerFor(element, listVector.getDataVector());
                    if (lenient) {
                        intersect = (Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Object object = x0$1;
                            if (object instanceof Iterable) {
                                Iterable iterable = (Iterable)object;
                                return iterable.iterator();
                            }
                            if (object instanceof java.util.List) {
                                java.util.List list = (java.util.List)object;
                                return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(list.iterator()).asScala();
                            }
                            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                                Object object2 = object;
                                return Predef$.MODULE$.genericArrayOps(object2).iterator();
                            }
                            throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(object.getClass());
                        };
                    } else if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.ITERABLE(), tag)) {
                        intersect = (Function1 & Serializable & scala.Serializable)v -> ((Iterable)v).iterator();
                    } else if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.JLIST(), tag)) {
                        intersect = (Function1 & Serializable & scala.Serializable)v -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(((java.util.List)v).iterator()).asScala();
                    } else {
                        throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                    }
                    Function1 & Serializable & scala.Serializable toIterator = intersect;
                    return new ArrowSerializer.ArraySerializer(listVector, (Function1<Object, Iterator<Object>>)toIterator, elementSerializer);
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder32 = (AgnosticEncoder)tuple2._1();
            Object v33 = tuple2._2();
            if (agnosticEncoder32 instanceof AgnosticEncoders.MapEncoder) {
                AgnosticEncoders.MapEncoder mapEncoder = (AgnosticEncoders.MapEncoder)agnosticEncoder32;
                ClassTag tag = mapEncoder.clsTag();
                AgnosticEncoder key = mapEncoder.keyEncoder();
                AgnosticEncoder value = mapEncoder.valueEncoder();
                if (v33 instanceof MapVector) {
                    Function1 & Serializable & scala.Serializable intersect;
                    MapVector mapVector = (MapVector)v33;
                    StructVector structVector = (StructVector)mapVector.getDataVector();
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(Map.class, tag)) {
                        intersect = (Function1 & Serializable & scala.Serializable)v -> ((Map)v).iterator();
                    } else if (ArrowEncoderUtils$.MODULE$.isSubClass(java.util.Map.class, tag)) {
                        intersect = (Function1 & Serializable & scala.Serializable)v -> ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)v).asScala()).iterator();
                    } else {
                        throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                    }
                    Function1 & Serializable & scala.Serializable extractor = intersect;
                    ArrowSerializer.StructFieldSerializer structFieldSerializer = new ArrowSerializer.StructFieldSerializer((Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)v -> MODULE$.extractKey(v), this.serializerFor(key, structVector.getChild("key")));
                    ArrowSerializer.StructFieldSerializer structFieldSerializer2 = new ArrowSerializer.StructFieldSerializer((Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)v -> MODULE$.extractValue(v), this.serializerFor(value, structVector.getChild("value")));
                    ArrowSerializer.StructSerializer structSerializer = new ArrowSerializer.StructSerializer(structVector, (Seq<ArrowSerializer.StructFieldSerializer>)Nil$.MODULE$.$colon$colon((Object)structFieldSerializer2).$colon$colon((Object)structFieldSerializer));
                    return new ArrowSerializer.ArraySerializer((ListVector)mapVector, (Function1<Object, Iterator<Object>>)extractor, structSerializer);
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder33 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder33 instanceof AgnosticEncoders.ProductEncoder) {
                AgnosticEncoders.ProductEncoder productEncoder = (AgnosticEncoders.ProductEncoder)agnosticEncoder33;
                ClassTag tag = productEncoder.clsTag();
                Seq fields = productEncoder.fields();
                Option<Tuple2<StructVector, Seq<FieldVector>>> option = StructVectors$.MODULE$.unapply(object);
                if (!option.isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(Product.class, tag)) {
                        return this.structSerializerFor((Seq<AgnosticEncoders.EncoderField>)fields, struct, (Seq<FieldVector>)vectors, (Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>>)(Function2 & Serializable & scala.Serializable)(x$6, i) -> ArrowSerializer$.$anonfun$serializerFor$9(x$6, BoxesRunTime.unboxToInt((Object)i)));
                    }
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(DefinedByConstructorParams.class, tag)) {
                        return this.structSerializerFor((Seq<AgnosticEncoders.EncoderField>)fields, struct, (Seq<FieldVector>)vectors, (Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>>)(Function2 & Serializable & scala.Serializable)(field, x$7) -> ArrowSerializer$.$anonfun$serializerFor$11(tag, field, BoxesRunTime.unboxToInt((Object)x$7)));
                    }
                    throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder34 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder34 instanceof AgnosticEncoders.RowEncoder) {
                AgnosticEncoders.RowEncoder rowEncoder = (AgnosticEncoders.RowEncoder)agnosticEncoder34;
                Seq fields = rowEncoder.fields();
                Option<Tuple2<StructVector, Seq<FieldVector>>> option = StructVectors$.MODULE$.unapply(object);
                if (!option.isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    return this.structSerializerFor((Seq<AgnosticEncoders.EncoderField>)fields, struct, (Seq<FieldVector>)vectors, (Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>>)(Function2 & Serializable & scala.Serializable)(x$8, i) -> ArrowSerializer$.$anonfun$serializerFor$13(x$8, BoxesRunTime.unboxToInt((Object)i)));
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder35 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder35 instanceof AgnosticEncoders.JavaBeanEncoder) {
                AgnosticEncoders.JavaBeanEncoder javaBeanEncoder = (AgnosticEncoders.JavaBeanEncoder)agnosticEncoder35;
                ClassTag tag = javaBeanEncoder.clsTag();
                Seq fields = javaBeanEncoder.fields();
                Option<Tuple2<StructVector, Seq<FieldVector>>> option = StructVectors$.MODULE$.unapply(object);
                if (!option.isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    return this.structSerializerFor((Seq<AgnosticEncoders.EncoderField>)fields, struct, (Seq<FieldVector>)vectors, (Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>>)(Function2 & Serializable & scala.Serializable)(field, x$9) -> ArrowSerializer$.$anonfun$serializerFor$15(tag, field, BoxesRunTime.unboxToInt((Object)x$9)));
                }
            }
        }
        if (tuple2 != null && (AgnosticEncoders.CalendarIntervalEncoder$.MODULE$.equals(agnosticEncoder = (AgnosticEncoder)tuple2._1()) ? true : agnosticEncoder instanceof AgnosticEncoders.UDTEncoder)) {
            throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(encoder.dataType());
        }
        throw new RuntimeException(new java.lang.StringBuilder(43).append("Unsupported Encoder(").append(encoder).append(")/Vector(").append(v2).append(") combination.").toString());
    }

    private MethodHandles.Lookup methodLookup() {
        return this.methodLookup;
    }

    public void org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString(VarCharVector vector, int index, String string) {
        ByteBuffer bytes = Text.encode((String)string);
        vector.setSafe(index, bytes, 0, bytes.limit());
    }

    public void org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal(DecimalVector vector, int index, BigDecimal decimal) {
        BigDecimal scaledDecimal = vector.getScale() != decimal.scale() ? decimal.setScale(vector.getScale()) : decimal;
        vector.setSafe(index, scaledDecimal);
    }

    private Object extractKey(Object v) {
        Object key = ((Tuple2)v)._1();
        Objects.requireNonNull(key);
        return key;
    }

    private Object extractValue(Object v) {
        return ((Tuple2)v)._2();
    }

    private ArrowSerializer.StructSerializer structSerializerFor(Seq<AgnosticEncoders.EncoderField> fields, StructVector struct, Seq<FieldVector> vectors, Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>> createGetter) {
        Predef$.MODULE$.require(fields.size() == vectors.size());
        Seq serializers = (Seq)((TraversableLike)((IterableLike)fields.zip(vectors, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    AgnosticEncoders.EncoderField field = (AgnosticEncoders.EncoderField)tuple22._1();
                    FieldVector vector = (FieldVector)tuple22._2();
                    ArrowSerializer.Serializer serializer = MODULE$.serializerFor(field.enc(), vector);
                    return new ArrowSerializer.StructFieldSerializer((Function1<Object, Object>)((Function1)createGetter.apply((Object)field, (Object)BoxesRunTime.boxToInteger((int)i))), serializer);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return new ArrowSerializer.StructSerializer(struct, (Seq<ArrowSerializer.StructFieldSerializer>)serializers);
    }

    public static final /* synthetic */ Function1 $anonfun$serializerFor$9(AgnosticEncoders.EncoderField x$6, int i) {
        return (Function1 & Serializable & scala.Serializable)p -> ((Product)p).productElement(i);
    }

    public static final /* synthetic */ Function1 $anonfun$serializerFor$11(ClassTag tag$1, AgnosticEncoders.EncoderField field, int x$7) {
        MethodHandle getter = MODULE$.methodLookup().findVirtual(tag$1.runtimeClass(), field.name(), MethodType.methodType(field.enc().clsTag().runtimeClass()));
        return (Function1 & Serializable & scala.Serializable)o -> getter.invoke(o);
    }

    public static final /* synthetic */ Function1 $anonfun$serializerFor$13(AgnosticEncoders.EncoderField x$8, int i) {
        return (Function1 & Serializable & scala.Serializable)r -> ((Row)r).get(i);
    }

    public static final /* synthetic */ Function1 $anonfun$serializerFor$15(ClassTag tag$2, AgnosticEncoders.EncoderField field, int x$9) {
        MethodHandle getter = MODULE$.methodLookup().findVirtual(tag$2.runtimeClass(), (String)field.readMethod().get(), MethodType.methodType(field.enc().clsTag().runtimeClass()));
        return (Function1 & Serializable & scala.Serializable)o -> getter.invoke(o);
    }

    private ArrowSerializer$() {
        MODULE$ = this;
        this.methodLookup = MethodHandles.lookup();
    }
}

