/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.Serializable;
import java.text.NumberFormat;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ProtoUtils$ {
    public static ProtoUtils$ MODULE$;
    private final NumberFormat format;
    private final int MAX_BYTES_SIZE;
    private final int MAX_STRING_SIZE;
    private final char SPARK_JOB_TAGS_SEP;

    static {
        new ProtoUtils$();
    }

    private NumberFormat format() {
        return this.format;
    }

    private int MAX_BYTES_SIZE() {
        return this.MAX_BYTES_SIZE;
    }

    private int MAX_STRING_SIZE() {
        return this.MAX_STRING_SIZE;
    }

    public Message abbreviate(Message message, int maxStringSize) {
        Message.Builder builder = message.toBuilder();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(message.getAllFields()).asScala()).iterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object string = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (string instanceof String) {
                        String string2 = (String)string;
                        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
                        Descriptors.FieldDescriptor.JavaType javaType2 = Descriptors.FieldDescriptor.JavaType.STRING;
                        if (!(javaType != null ? !javaType.equals(javaType2) : javaType2 != null) && string2 != null) {
                            int size = new StringOps(Predef$.MODULE$.augmentString(string2)).size();
                            if (size > maxStringSize) {
                                return builder.setField(fieldDescriptor, (Object)MODULE$.createString((String)new StringOps(Predef$.MODULE$.augmentString(string2)).take(maxStringSize), size));
                            }
                            return builder.setField(fieldDescriptor, (Object)string2);
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object byteString = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (byteString instanceof ByteString) {
                        ByteString byteString2 = (ByteString)byteString;
                        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
                        Descriptors.FieldDescriptor.JavaType javaType3 = Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
                        if (!(javaType != null ? !javaType.equals(javaType3) : javaType3 != null) && byteString2 != null) {
                            int size = byteString2.size();
                            if (size > maxStringSize) {
                                byte[] prefix = (byte[])Array$.MODULE$.tabulate(maxStringSize, (Function1 & Serializable & scala.Serializable)index -> BoxesRunTime.boxToByte((byte)byteString2.byteAt(BoxesRunTime.unboxToInt((Object)index))), ClassTag$.MODULE$.Byte());
                                return builder.setField(fieldDescriptor, (Object)MODULE$.createByteString(prefix, size));
                            }
                            return builder.setField(fieldDescriptor, (Object)byteString2);
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object byteArray = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (byteArray instanceof byte[]) {
                        byte[] byArray = (byte[])byteArray;
                        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
                        Descriptors.FieldDescriptor.JavaType javaType4 = Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
                        if (!(javaType != null ? !javaType.equals(javaType4) : javaType4 != null) && byArray != null) {
                            int size = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byArray)).size();
                            if (size > MODULE$.MAX_BYTES_SIZE()) {
                                byte[] prefix = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byArray)).take(MODULE$.MAX_BYTES_SIZE());
                                return builder.setField(fieldDescriptor, (Object)MODULE$.createByteString(prefix, size));
                            }
                            return builder.setField(fieldDescriptor, (Object)byArray);
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object msg = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (msg instanceof Message) {
                        Message message = (Message)msg;
                        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
                        Descriptors.FieldDescriptor.JavaType javaType5 = Descriptors.FieldDescriptor.JavaType.MESSAGE;
                        if (!(javaType != null ? !javaType.equals(javaType5) : javaType5 != null) && message != null) {
                            return builder.setField(fieldDescriptor, (Object)MODULE$.abbreviate(message, MODULE$.abbreviate$default$2()));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object value = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (value != null) {
                        Object object = value;
                        return builder.setField(fieldDescriptor, object);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return builder.build();
    }

    public int abbreviate$default$2() {
        return this.MAX_STRING_SIZE();
    }

    private ByteString createByteString(byte[] prefix, int size) {
        return ByteString.copyFrom((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ByteString.copyFrom((byte[])prefix), (List)new .colon.colon((Object)ByteString.copyFromUtf8((String)new StringBuilder(18).append("[truncated(size=").append(this.format().format(size)).append(")]").toString()), (List)Nil$.MODULE$))).asJava()));
    }

    private String createString(String prefix, int size) {
        return new StringBuilder(18).append(prefix).append("[truncated(size=").append(this.format().format(size)).append(")]").toString();
    }

    private char SPARK_JOB_TAGS_SEP() {
        return this.SPARK_JOB_TAGS_SEP;
    }

    public void throwIfInvalidTag(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Spark Connect tag cannot be null.");
        }
        if (new StringOps(Predef$.MODULE$.augmentString(tag)).contains((Object)BoxesRunTime.boxToCharacter((char)this.SPARK_JOB_TAGS_SEP()))) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Spark Connect tag cannot contain '").append(this.SPARK_JOB_TAGS_SEP()).append("'.").toString());
        }
        if (tag.isEmpty()) {
            throw new IllegalArgumentException("Spark Connect tag cannot be an empty string.");
        }
    }

    private ProtoUtils$() {
        MODULE$ = this;
        this.format = NumberFormat.getInstance();
        this.MAX_BYTES_SIZE = 8;
        this.MAX_STRING_SIZE = 1024;
        this.SPARK_JOB_TAGS_SEP = (char)44;
    }
}

