/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.connect.proto;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.spark.connect.proto.Commands;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.ExpressionOrBuilder;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.RelationOrBuilder;
import org.apache.spark.connect.proto.WriteOperationV2OrBuilder;

public final class WriteOperationV2
extends GeneratedMessageV3
implements WriteOperationV2OrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int INPUT_FIELD_NUMBER = 1;
    private Relation input_;
    public static final int TABLE_NAME_FIELD_NUMBER = 2;
    private volatile Object tableName_ = "";
    public static final int PROVIDER_FIELD_NUMBER = 3;
    private volatile Object provider_ = "";
    public static final int PARTITIONING_COLUMNS_FIELD_NUMBER = 4;
    private List<Expression> partitioningColumns_;
    public static final int OPTIONS_FIELD_NUMBER = 5;
    private MapField<String, String> options_;
    public static final int TABLE_PROPERTIES_FIELD_NUMBER = 6;
    private MapField<String, String> tableProperties_;
    public static final int MODE_FIELD_NUMBER = 7;
    private int mode_ = 0;
    public static final int OVERWRITE_CONDITION_FIELD_NUMBER = 8;
    private Expression overwriteCondition_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final WriteOperationV2 DEFAULT_INSTANCE = new WriteOperationV2();
    private static final Parser<WriteOperationV2> PARSER = new AbstractParser<WriteOperationV2>(){

        public WriteOperationV2 parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = WriteOperationV2.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private WriteOperationV2(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private WriteOperationV2() {
        this.tableName_ = "";
        this.provider_ = "";
        this.partitioningColumns_ = Collections.emptyList();
        this.mode_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new WriteOperationV2();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return Commands.internal_static_spark_connect_WriteOperationV2_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 5: {
                return this.internalGetOptions();
            }
            case 6: {
                return this.internalGetTableProperties();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return Commands.internal_static_spark_connect_WriteOperationV2_fieldAccessorTable.ensureFieldAccessorsInitialized(WriteOperationV2.class, Builder.class);
    }

    @Override
    public boolean hasInput() {
        return this.input_ != null;
    }

    @Override
    public Relation getInput() {
        return this.input_ == null ? Relation.getDefaultInstance() : this.input_;
    }

    @Override
    public RelationOrBuilder getInputOrBuilder() {
        return this.input_ == null ? Relation.getDefaultInstance() : this.input_;
    }

    @Override
    public String getTableName() {
        Object ref = this.tableName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.tableName_ = s;
        return s;
    }

    @Override
    public ByteString getTableNameBytes() {
        Object ref = this.tableName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.tableName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasProvider() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getProvider() {
        Object ref = this.provider_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.provider_ = s;
        return s;
    }

    @Override
    public ByteString getProviderBytes() {
        Object ref = this.provider_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.provider_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<Expression> getPartitioningColumnsList() {
        return this.partitioningColumns_;
    }

    @Override
    public List<? extends ExpressionOrBuilder> getPartitioningColumnsOrBuilderList() {
        return this.partitioningColumns_;
    }

    @Override
    public int getPartitioningColumnsCount() {
        return this.partitioningColumns_.size();
    }

    @Override
    public Expression getPartitioningColumns(int index) {
        return this.partitioningColumns_.get(index);
    }

    @Override
    public ExpressionOrBuilder getPartitioningColumnsOrBuilder(int index) {
        return this.partitioningColumns_.get(index);
    }

    private MapField<String, String> internalGetOptions() {
        if (this.options_ == null) {
            return MapField.emptyMapField(OptionsDefaultEntryHolder.defaultEntry);
        }
        return this.options_;
    }

    @Override
    public int getOptionsCount() {
        return this.internalGetOptions().getMap().size();
    }

    @Override
    public boolean containsOptions(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetOptions().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getOptions() {
        return this.getOptionsMap();
    }

    @Override
    public Map<String, String> getOptionsMap() {
        return this.internalGetOptions().getMap();
    }

    @Override
    public String getOptionsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetOptions().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getOptionsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetOptions().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    private MapField<String, String> internalGetTableProperties() {
        if (this.tableProperties_ == null) {
            return MapField.emptyMapField(TablePropertiesDefaultEntryHolder.defaultEntry);
        }
        return this.tableProperties_;
    }

    @Override
    public int getTablePropertiesCount() {
        return this.internalGetTableProperties().getMap().size();
    }

    @Override
    public boolean containsTableProperties(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetTableProperties().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getTableProperties() {
        return this.getTablePropertiesMap();
    }

    @Override
    public Map<String, String> getTablePropertiesMap() {
        return this.internalGetTableProperties().getMap();
    }

    @Override
    public String getTablePropertiesOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetTableProperties().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getTablePropertiesOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetTableProperties().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public int getModeValue() {
        return this.mode_;
    }

    @Override
    public Mode getMode() {
        Mode result = Mode.forNumber(this.mode_);
        return result == null ? Mode.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasOverwriteCondition() {
        return this.overwriteCondition_ != null;
    }

    @Override
    public Expression getOverwriteCondition() {
        return this.overwriteCondition_ == null ? Expression.getDefaultInstance() : this.overwriteCondition_;
    }

    @Override
    public ExpressionOrBuilder getOverwriteConditionOrBuilder() {
        return this.overwriteCondition_ == null ? Expression.getDefaultInstance() : this.overwriteCondition_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.input_ != null) {
            output.writeMessage(1, (MessageLite)this.getInput());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.tableName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.tableName_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.provider_);
        }
        for (int i = 0; i < this.partitioningColumns_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.partitioningColumns_.get(i));
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetOptions(), OptionsDefaultEntryHolder.defaultEntry, (int)5);
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetTableProperties(), TablePropertiesDefaultEntryHolder.defaultEntry, (int)6);
        if (this.mode_ != Mode.MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.mode_);
        }
        if (this.overwriteCondition_ != null) {
            output.writeMessage(8, (MessageLite)this.getOverwriteCondition());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.input_ != null) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getInput());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.tableName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.tableName_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.provider_);
        }
        for (int i = 0; i < this.partitioningColumns_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.partitioningColumns_.get(i)));
        }
        for (Map.Entry entry : this.internalGetOptions().getMap().entrySet()) {
            MapEntry options__ = OptionsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)options__);
        }
        for (Map.Entry entry : this.internalGetTableProperties().getMap().entrySet()) {
            MapEntry tableProperties__ = TablePropertiesDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)tableProperties__);
        }
        if (this.mode_ != Mode.MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.mode_);
        }
        if (this.overwriteCondition_ != null) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getOverwriteCondition());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WriteOperationV2)) {
            return super.equals(obj);
        }
        WriteOperationV2 other = (WriteOperationV2)obj;
        if (this.hasInput() != other.hasInput()) {
            return false;
        }
        if (this.hasInput() && !this.getInput().equals(other.getInput())) {
            return false;
        }
        if (!this.getTableName().equals(other.getTableName())) {
            return false;
        }
        if (this.hasProvider() != other.hasProvider()) {
            return false;
        }
        if (this.hasProvider() && !this.getProvider().equals(other.getProvider())) {
            return false;
        }
        if (!this.getPartitioningColumnsList().equals(other.getPartitioningColumnsList())) {
            return false;
        }
        if (!this.internalGetOptions().equals(other.internalGetOptions())) {
            return false;
        }
        if (!this.internalGetTableProperties().equals(other.internalGetTableProperties())) {
            return false;
        }
        if (this.mode_ != other.mode_) {
            return false;
        }
        if (this.hasOverwriteCondition() != other.hasOverwriteCondition()) {
            return false;
        }
        if (this.hasOverwriteCondition() && !this.getOverwriteCondition().equals(other.getOverwriteCondition())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + WriteOperationV2.getDescriptor().hashCode();
        if (this.hasInput()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getInput().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getTableName().hashCode();
        if (this.hasProvider()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getProvider().hashCode();
        }
        if (this.getPartitioningColumnsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getPartitioningColumnsList().hashCode();
        }
        if (!this.internalGetOptions().getMap().isEmpty()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.internalGetOptions().hashCode();
        }
        if (!this.internalGetTableProperties().getMap().isEmpty()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.internalGetTableProperties().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.mode_;
        if (this.hasOverwriteCondition()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getOverwriteCondition().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static WriteOperationV2 parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (WriteOperationV2)PARSER.parseFrom(data);
    }

    public static WriteOperationV2 parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WriteOperationV2)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WriteOperationV2 parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (WriteOperationV2)PARSER.parseFrom(data);
    }

    public static WriteOperationV2 parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WriteOperationV2)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WriteOperationV2 parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (WriteOperationV2)PARSER.parseFrom(data);
    }

    public static WriteOperationV2 parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WriteOperationV2)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WriteOperationV2 parseFrom(InputStream input) throws IOException {
        return (WriteOperationV2)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static WriteOperationV2 parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WriteOperationV2)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static WriteOperationV2 parseDelimitedFrom(InputStream input) throws IOException {
        return (WriteOperationV2)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static WriteOperationV2 parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WriteOperationV2)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static WriteOperationV2 parseFrom(CodedInputStream input) throws IOException {
        return (WriteOperationV2)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static WriteOperationV2 parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WriteOperationV2)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return WriteOperationV2.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(WriteOperationV2 prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static WriteOperationV2 getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<WriteOperationV2> parser() {
        return PARSER;
    }

    public Parser<WriteOperationV2> getParserForType() {
        return PARSER;
    }

    public WriteOperationV2 getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements WriteOperationV2OrBuilder {
        private int bitField0_;
        private Relation input_;
        private SingleFieldBuilderV3<Relation, Relation.Builder, RelationOrBuilder> inputBuilder_;
        private Object tableName_ = "";
        private Object provider_ = "";
        private List<Expression> partitioningColumns_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Expression, Expression.Builder, ExpressionOrBuilder> partitioningColumnsBuilder_;
        private MapField<String, String> options_;
        private MapField<String, String> tableProperties_;
        private int mode_ = 0;
        private Expression overwriteCondition_;
        private SingleFieldBuilderV3<Expression, Expression.Builder, ExpressionOrBuilder> overwriteConditionBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return Commands.internal_static_spark_connect_WriteOperationV2_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 5: {
                    return this.internalGetOptions();
                }
                case 6: {
                    return this.internalGetTableProperties();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 5: {
                    return this.internalGetMutableOptions();
                }
                case 6: {
                    return this.internalGetMutableTableProperties();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Commands.internal_static_spark_connect_WriteOperationV2_fieldAccessorTable.ensureFieldAccessorsInitialized(WriteOperationV2.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.input_ = null;
            if (this.inputBuilder_ != null) {
                this.inputBuilder_.dispose();
                this.inputBuilder_ = null;
            }
            this.tableName_ = "";
            this.provider_ = "";
            if (this.partitioningColumnsBuilder_ == null) {
                this.partitioningColumns_ = Collections.emptyList();
            } else {
                this.partitioningColumns_ = null;
                this.partitioningColumnsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            this.internalGetMutableOptions().clear();
            this.internalGetMutableTableProperties().clear();
            this.mode_ = 0;
            this.overwriteCondition_ = null;
            if (this.overwriteConditionBuilder_ != null) {
                this.overwriteConditionBuilder_.dispose();
                this.overwriteConditionBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return Commands.internal_static_spark_connect_WriteOperationV2_descriptor;
        }

        public WriteOperationV2 getDefaultInstanceForType() {
            return WriteOperationV2.getDefaultInstance();
        }

        public WriteOperationV2 build() {
            WriteOperationV2 result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public WriteOperationV2 buildPartial() {
            WriteOperationV2 result = new WriteOperationV2(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(WriteOperationV2 result) {
            if (this.partitioningColumnsBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.partitioningColumns_ = Collections.unmodifiableList(this.partitioningColumns_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.partitioningColumns_ = this.partitioningColumns_;
            } else {
                result.partitioningColumns_ = this.partitioningColumnsBuilder_.build();
            }
        }

        private void buildPartial0(WriteOperationV2 result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.input_ = this.inputBuilder_ == null ? this.input_ : (Relation)this.inputBuilder_.build();
            }
            if ((from_bitField0_ & 2) != 0) {
                result.tableName_ = this.tableName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.provider_ = this.provider_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.options_ = this.internalGetOptions();
                result.options_.makeImmutable();
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.tableProperties_ = this.internalGetTableProperties();
                result.tableProperties_.makeImmutable();
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.mode_ = this.mode_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.overwriteCondition_ = this.overwriteConditionBuilder_ == null ? this.overwriteCondition_ : (Expression)this.overwriteConditionBuilder_.build();
            }
            WriteOperationV2 writeOperationV2 = result;
            writeOperationV2.bitField0_ = writeOperationV2.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof WriteOperationV2) {
                return this.mergeFrom((WriteOperationV2)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(WriteOperationV2 other) {
            if (other == WriteOperationV2.getDefaultInstance()) {
                return this;
            }
            if (other.hasInput()) {
                this.mergeInput(other.getInput());
            }
            if (!other.getTableName().isEmpty()) {
                this.tableName_ = other.tableName_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasProvider()) {
                this.provider_ = other.provider_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (this.partitioningColumnsBuilder_ == null) {
                if (!other.partitioningColumns_.isEmpty()) {
                    if (this.partitioningColumns_.isEmpty()) {
                        this.partitioningColumns_ = other.partitioningColumns_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensurePartitioningColumnsIsMutable();
                        this.partitioningColumns_.addAll(other.partitioningColumns_);
                    }
                    this.onChanged();
                }
            } else if (!other.partitioningColumns_.isEmpty()) {
                if (this.partitioningColumnsBuilder_.isEmpty()) {
                    this.partitioningColumnsBuilder_.dispose();
                    this.partitioningColumnsBuilder_ = null;
                    this.partitioningColumns_ = other.partitioningColumns_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.partitioningColumnsBuilder_ = alwaysUseFieldBuilders ? this.getPartitioningColumnsFieldBuilder() : null;
                } else {
                    this.partitioningColumnsBuilder_.addAllMessages((Iterable)other.partitioningColumns_);
                }
            }
            this.internalGetMutableOptions().mergeFrom(other.internalGetOptions());
            this.bitField0_ |= 0x10;
            this.internalGetMutableTableProperties().mergeFrom(other.internalGetTableProperties());
            this.bitField0_ |= 0x20;
            if (other.mode_ != 0) {
                this.setModeValue(other.getModeValue());
            }
            if (other.hasOverwriteCondition()) {
                this.mergeOverwriteCondition(other.getOverwriteCondition());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block16: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block16;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getInputFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block16;
                        }
                        case 18: {
                            this.tableName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block16;
                        }
                        case 26: {
                            this.provider_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block16;
                        }
                        case 34: {
                            Expression m = (Expression)input.readMessage(Expression.parser(), extensionRegistry);
                            if (this.partitioningColumnsBuilder_ == null) {
                                this.ensurePartitioningColumnsIsMutable();
                                this.partitioningColumns_.add(m);
                                continue block16;
                            }
                            this.partitioningColumnsBuilder_.addMessage((AbstractMessage)m);
                            continue block16;
                        }
                        case 42: {
                            MapEntry options__ = (MapEntry)input.readMessage(OptionsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableOptions().getMutableMap().put(options__.getKey(), options__.getValue());
                            this.bitField0_ |= 0x10;
                            continue block16;
                        }
                        case 50: {
                            MapEntry tableProperties__ = (MapEntry)input.readMessage(TablePropertiesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableTableProperties().getMutableMap().put(tableProperties__.getKey(), tableProperties__.getValue());
                            this.bitField0_ |= 0x20;
                            continue block16;
                        }
                        case 56: {
                            this.mode_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block16;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getOverwriteConditionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block16;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasInput() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public Relation getInput() {
            if (this.inputBuilder_ == null) {
                return this.input_ == null ? Relation.getDefaultInstance() : this.input_;
            }
            return (Relation)this.inputBuilder_.getMessage();
        }

        public Builder setInput(Relation value) {
            if (this.inputBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.input_ = value;
            } else {
                this.inputBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setInput(Relation.Builder builderForValue) {
            if (this.inputBuilder_ == null) {
                this.input_ = builderForValue.build();
            } else {
                this.inputBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeInput(Relation value) {
            if (this.inputBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.input_ != null && this.input_ != Relation.getDefaultInstance()) {
                    this.getInputBuilder().mergeFrom(value);
                } else {
                    this.input_ = value;
                }
            } else {
                this.inputBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearInput() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.input_ = null;
            if (this.inputBuilder_ != null) {
                this.inputBuilder_.dispose();
                this.inputBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Relation.Builder getInputBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (Relation.Builder)this.getInputFieldBuilder().getBuilder();
        }

        @Override
        public RelationOrBuilder getInputOrBuilder() {
            if (this.inputBuilder_ != null) {
                return (RelationOrBuilder)this.inputBuilder_.getMessageOrBuilder();
            }
            return this.input_ == null ? Relation.getDefaultInstance() : this.input_;
        }

        private SingleFieldBuilderV3<Relation, Relation.Builder, RelationOrBuilder> getInputFieldBuilder() {
            if (this.inputBuilder_ == null) {
                this.inputBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInput(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.input_ = null;
            }
            return this.inputBuilder_;
        }

        @Override
        public String getTableName() {
            Object ref = this.tableName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.tableName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTableNameBytes() {
            Object ref = this.tableName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.tableName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTableName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.tableName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTableName() {
            this.tableName_ = WriteOperationV2.getDefaultInstance().getTableName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setTableNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WriteOperationV2.checkByteStringIsUtf8((ByteString)value);
            this.tableName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasProvider() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getProvider() {
            Object ref = this.provider_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.provider_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getProviderBytes() {
            Object ref = this.provider_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.provider_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setProvider(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.provider_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearProvider() {
            this.provider_ = WriteOperationV2.getDefaultInstance().getProvider();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setProviderBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WriteOperationV2.checkByteStringIsUtf8((ByteString)value);
            this.provider_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        private void ensurePartitioningColumnsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.partitioningColumns_ = new ArrayList<Expression>(this.partitioningColumns_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<Expression> getPartitioningColumnsList() {
            if (this.partitioningColumnsBuilder_ == null) {
                return Collections.unmodifiableList(this.partitioningColumns_);
            }
            return this.partitioningColumnsBuilder_.getMessageList();
        }

        @Override
        public int getPartitioningColumnsCount() {
            if (this.partitioningColumnsBuilder_ == null) {
                return this.partitioningColumns_.size();
            }
            return this.partitioningColumnsBuilder_.getCount();
        }

        @Override
        public Expression getPartitioningColumns(int index) {
            if (this.partitioningColumnsBuilder_ == null) {
                return this.partitioningColumns_.get(index);
            }
            return (Expression)this.partitioningColumnsBuilder_.getMessage(index);
        }

        public Builder setPartitioningColumns(int index, Expression value) {
            if (this.partitioningColumnsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePartitioningColumnsIsMutable();
                this.partitioningColumns_.set(index, value);
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPartitioningColumns(int index, Expression.Builder builderForValue) {
            if (this.partitioningColumnsBuilder_ == null) {
                this.ensurePartitioningColumnsIsMutable();
                this.partitioningColumns_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPartitioningColumns(Expression value) {
            if (this.partitioningColumnsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePartitioningColumnsIsMutable();
                this.partitioningColumns_.add(value);
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPartitioningColumns(int index, Expression value) {
            if (this.partitioningColumnsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePartitioningColumnsIsMutable();
                this.partitioningColumns_.add(index, value);
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPartitioningColumns(Expression.Builder builderForValue) {
            if (this.partitioningColumnsBuilder_ == null) {
                this.ensurePartitioningColumnsIsMutable();
                this.partitioningColumns_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPartitioningColumns(int index, Expression.Builder builderForValue) {
            if (this.partitioningColumnsBuilder_ == null) {
                this.ensurePartitioningColumnsIsMutable();
                this.partitioningColumns_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPartitioningColumns(Iterable<? extends Expression> values) {
            if (this.partitioningColumnsBuilder_ == null) {
                this.ensurePartitioningColumnsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.partitioningColumns_);
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPartitioningColumns() {
            if (this.partitioningColumnsBuilder_ == null) {
                this.partitioningColumns_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.clear();
            }
            return this;
        }

        public Builder removePartitioningColumns(int index) {
            if (this.partitioningColumnsBuilder_ == null) {
                this.ensurePartitioningColumnsIsMutable();
                this.partitioningColumns_.remove(index);
                this.onChanged();
            } else {
                this.partitioningColumnsBuilder_.remove(index);
            }
            return this;
        }

        public Expression.Builder getPartitioningColumnsBuilder(int index) {
            return (Expression.Builder)this.getPartitioningColumnsFieldBuilder().getBuilder(index);
        }

        @Override
        public ExpressionOrBuilder getPartitioningColumnsOrBuilder(int index) {
            if (this.partitioningColumnsBuilder_ == null) {
                return this.partitioningColumns_.get(index);
            }
            return (ExpressionOrBuilder)this.partitioningColumnsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ExpressionOrBuilder> getPartitioningColumnsOrBuilderList() {
            if (this.partitioningColumnsBuilder_ != null) {
                return this.partitioningColumnsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.partitioningColumns_);
        }

        public Expression.Builder addPartitioningColumnsBuilder() {
            return (Expression.Builder)this.getPartitioningColumnsFieldBuilder().addBuilder((AbstractMessage)Expression.getDefaultInstance());
        }

        public Expression.Builder addPartitioningColumnsBuilder(int index) {
            return (Expression.Builder)this.getPartitioningColumnsFieldBuilder().addBuilder(index, (AbstractMessage)Expression.getDefaultInstance());
        }

        public List<Expression.Builder> getPartitioningColumnsBuilderList() {
            return this.getPartitioningColumnsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Expression, Expression.Builder, ExpressionOrBuilder> getPartitioningColumnsFieldBuilder() {
            if (this.partitioningColumnsBuilder_ == null) {
                this.partitioningColumnsBuilder_ = new RepeatedFieldBuilderV3(this.partitioningColumns_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.partitioningColumns_ = null;
            }
            return this.partitioningColumnsBuilder_;
        }

        private MapField<String, String> internalGetOptions() {
            if (this.options_ == null) {
                return MapField.emptyMapField(OptionsDefaultEntryHolder.defaultEntry);
            }
            return this.options_;
        }

        private MapField<String, String> internalGetMutableOptions() {
            if (this.options_ == null) {
                this.options_ = MapField.newMapField(OptionsDefaultEntryHolder.defaultEntry);
            }
            if (!this.options_.isMutable()) {
                this.options_ = this.options_.copy();
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this.options_;
        }

        @Override
        public int getOptionsCount() {
            return this.internalGetOptions().getMap().size();
        }

        @Override
        public boolean containsOptions(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetOptions().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getOptions() {
            return this.getOptionsMap();
        }

        @Override
        public Map<String, String> getOptionsMap() {
            return this.internalGetOptions().getMap();
        }

        @Override
        public String getOptionsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetOptions().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getOptionsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetOptions().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearOptions() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.internalGetMutableOptions().getMutableMap().clear();
            return this;
        }

        public Builder removeOptions(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableOptions().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableOptions() {
            this.bitField0_ |= 0x10;
            return this.internalGetMutableOptions().getMutableMap();
        }

        public Builder putOptions(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableOptions().getMutableMap().put(key, value);
            this.bitField0_ |= 0x10;
            return this;
        }

        public Builder putAllOptions(Map<String, String> values) {
            this.internalGetMutableOptions().getMutableMap().putAll(values);
            this.bitField0_ |= 0x10;
            return this;
        }

        private MapField<String, String> internalGetTableProperties() {
            if (this.tableProperties_ == null) {
                return MapField.emptyMapField(TablePropertiesDefaultEntryHolder.defaultEntry);
            }
            return this.tableProperties_;
        }

        private MapField<String, String> internalGetMutableTableProperties() {
            if (this.tableProperties_ == null) {
                this.tableProperties_ = MapField.newMapField(TablePropertiesDefaultEntryHolder.defaultEntry);
            }
            if (!this.tableProperties_.isMutable()) {
                this.tableProperties_ = this.tableProperties_.copy();
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this.tableProperties_;
        }

        @Override
        public int getTablePropertiesCount() {
            return this.internalGetTableProperties().getMap().size();
        }

        @Override
        public boolean containsTableProperties(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetTableProperties().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getTableProperties() {
            return this.getTablePropertiesMap();
        }

        @Override
        public Map<String, String> getTablePropertiesMap() {
            return this.internalGetTableProperties().getMap();
        }

        @Override
        public String getTablePropertiesOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetTableProperties().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getTablePropertiesOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetTableProperties().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearTableProperties() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.internalGetMutableTableProperties().getMutableMap().clear();
            return this;
        }

        public Builder removeTableProperties(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableTableProperties().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableTableProperties() {
            this.bitField0_ |= 0x20;
            return this.internalGetMutableTableProperties().getMutableMap();
        }

        public Builder putTableProperties(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableTableProperties().getMutableMap().put(key, value);
            this.bitField0_ |= 0x20;
            return this;
        }

        public Builder putAllTableProperties(Map<String, String> values) {
            this.internalGetMutableTableProperties().getMutableMap().putAll(values);
            this.bitField0_ |= 0x20;
            return this;
        }

        @Override
        public int getModeValue() {
            return this.mode_;
        }

        public Builder setModeValue(int value) {
            this.mode_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public Mode getMode() {
            Mode result = Mode.forNumber(this.mode_);
            return result == null ? Mode.UNRECOGNIZED : result;
        }

        public Builder setMode(Mode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.mode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearMode() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.mode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasOverwriteCondition() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Expression getOverwriteCondition() {
            if (this.overwriteConditionBuilder_ == null) {
                return this.overwriteCondition_ == null ? Expression.getDefaultInstance() : this.overwriteCondition_;
            }
            return (Expression)this.overwriteConditionBuilder_.getMessage();
        }

        public Builder setOverwriteCondition(Expression value) {
            if (this.overwriteConditionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.overwriteCondition_ = value;
            } else {
                this.overwriteConditionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setOverwriteCondition(Expression.Builder builderForValue) {
            if (this.overwriteConditionBuilder_ == null) {
                this.overwriteCondition_ = builderForValue.build();
            } else {
                this.overwriteConditionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeOverwriteCondition(Expression value) {
            if (this.overwriteConditionBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.overwriteCondition_ != null && this.overwriteCondition_ != Expression.getDefaultInstance()) {
                    this.getOverwriteConditionBuilder().mergeFrom(value);
                } else {
                    this.overwriteCondition_ = value;
                }
            } else {
                this.overwriteConditionBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearOverwriteCondition() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.overwriteCondition_ = null;
            if (this.overwriteConditionBuilder_ != null) {
                this.overwriteConditionBuilder_.dispose();
                this.overwriteConditionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Expression.Builder getOverwriteConditionBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Expression.Builder)this.getOverwriteConditionFieldBuilder().getBuilder();
        }

        @Override
        public ExpressionOrBuilder getOverwriteConditionOrBuilder() {
            if (this.overwriteConditionBuilder_ != null) {
                return (ExpressionOrBuilder)this.overwriteConditionBuilder_.getMessageOrBuilder();
            }
            return this.overwriteCondition_ == null ? Expression.getDefaultInstance() : this.overwriteCondition_;
        }

        private SingleFieldBuilderV3<Expression, Expression.Builder, ExpressionOrBuilder> getOverwriteConditionFieldBuilder() {
            if (this.overwriteConditionBuilder_ == null) {
                this.overwriteConditionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getOverwriteCondition(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.overwriteCondition_ = null;
            }
            return this.overwriteConditionBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class TablePropertiesDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)Commands.internal_static_spark_connect_WriteOperationV2_TablePropertiesEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private TablePropertiesDefaultEntryHolder() {
        }
    }

    private static final class OptionsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)Commands.internal_static_spark_connect_WriteOperationV2_OptionsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private OptionsDefaultEntryHolder() {
        }
    }

    public static enum Mode implements ProtocolMessageEnum
    {
        MODE_UNSPECIFIED(0),
        MODE_CREATE(1),
        MODE_OVERWRITE(2),
        MODE_OVERWRITE_PARTITIONS(3),
        MODE_APPEND(4),
        MODE_REPLACE(5),
        MODE_CREATE_OR_REPLACE(6),
        UNRECOGNIZED(-1);

        public static final int MODE_UNSPECIFIED_VALUE = 0;
        public static final int MODE_CREATE_VALUE = 1;
        public static final int MODE_OVERWRITE_VALUE = 2;
        public static final int MODE_OVERWRITE_PARTITIONS_VALUE = 3;
        public static final int MODE_APPEND_VALUE = 4;
        public static final int MODE_REPLACE_VALUE = 5;
        public static final int MODE_CREATE_OR_REPLACE_VALUE = 6;
        private static final Internal.EnumLiteMap<Mode> internalValueMap;
        private static final Mode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Mode valueOf(int value) {
            return Mode.forNumber(value);
        }

        public static Mode forNumber(int value) {
            switch (value) {
                case 0: {
                    return MODE_UNSPECIFIED;
                }
                case 1: {
                    return MODE_CREATE;
                }
                case 2: {
                    return MODE_OVERWRITE;
                }
                case 3: {
                    return MODE_OVERWRITE_PARTITIONS;
                }
                case 4: {
                    return MODE_APPEND;
                }
                case 5: {
                    return MODE_REPLACE;
                }
                case 6: {
                    return MODE_CREATE_OR_REPLACE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Mode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Mode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Mode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)WriteOperationV2.getDescriptor().getEnumTypes().get(0);
        }

        public static Mode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Mode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Mode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Mode>(){

                public Mode findValueByNumber(int number) {
                    return Mode.forNumber(number);
                }
            };
            VALUES = Mode.values();
        }
    }
}

