/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.planner;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LiteralExpressionProtoConverter$ {
    public static LiteralExpressionProtoConverter$ MODULE$;

    static {
        new LiteralExpressionProtoConverter$();
    }

    public Literal toCatalystExpression(Expression.Literal lit) {
        Expression.Literal.LiteralTypeCase literalTypeCase = lit.getLiteralTypeCase();
        if (Expression.Literal.LiteralTypeCase.NULL.equals(literalTypeCase)) {
            return new Literal(null, DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getNull()));
        }
        if (Expression.Literal.LiteralTypeCase.BINARY.equals(literalTypeCase)) {
            return new Literal((Object)lit.getBinary().toByteArray(), (DataType)BinaryType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.BOOLEAN.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToBoolean((boolean)lit.getBoolean()), (DataType)BooleanType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.BYTE.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToByte((byte)((byte)lit.getByte())), (DataType)ByteType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.SHORT.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToShort((short)((short)lit.getShort())), (DataType)ShortType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.INTEGER.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getInteger()), (DataType)IntegerType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.LONG.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToLong((long)lit.getLong()), (DataType)LongType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.FLOAT.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToFloat((float)lit.getFloat()), (DataType)FloatType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.DOUBLE.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToDouble((double)lit.getDouble()), (DataType)DoubleType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.DECIMAL.equals(literalTypeCase)) {
            Decimal decimal = Decimal$.MODULE$.apply(lit.getDecimal().getValue());
            int precision = decimal.precision();
            if (lit.getDecimal().hasPrecision()) {
                precision = package$.MODULE$.max(precision, lit.getDecimal().getPrecision());
            }
            int scale = decimal.scale();
            if (lit.getDecimal().hasScale()) {
                scale = package$.MODULE$.max(scale, lit.getDecimal().getScale());
            }
            return new Literal((Object)decimal, (DataType)new DecimalType(package$.MODULE$.max(precision, scale), scale));
        }
        if (Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase)) {
            return new Literal((Object)UTF8String.fromString((String)lit.getString()), (DataType)StringType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.DATE.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getDate()), (DataType)DateType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.TIMESTAMP.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToLong((long)lit.getTimestamp()), (DataType)TimestampType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.TIMESTAMP_NTZ.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToLong((long)lit.getTimestampNtz()), (DataType)TimestampNTZType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.CALENDAR_INTERVAL.equals(literalTypeCase)) {
            CalendarInterval interval = new CalendarInterval(lit.getCalendarInterval().getMonths(), lit.getCalendarInterval().getDays(), lit.getCalendarInterval().getMicroseconds());
            return new Literal((Object)interval, (DataType)CalendarIntervalType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.YEAR_MONTH_INTERVAL.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getYearMonthInterval()), (DataType)YearMonthIntervalType$.MODULE$.apply());
        }
        if (Expression.Literal.LiteralTypeCase.DAY_TIME_INTERVAL.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToLong((long)lit.getDayTimeInterval()), (DataType)DayTimeIntervalType$.MODULE$.apply());
        }
        if (Expression.Literal.LiteralTypeCase.ARRAY.equals(literalTypeCase)) {
            return Literal$.MODULE$.create(this.toArrayData(lit.getArray()), (DataType)ArrayType$.MODULE$.apply(DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getArray().getElementType())));
        }
        throw new InvalidPlanInput(new StringBuilder(28).append("Unsupported Literal Type: ").append(lit.getLiteralTypeCase().getNumber()).append("(").append(lit.getLiteralTypeCase().name()).append(")").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
    }

    public Object toCatalystValue(Expression.Literal lit) {
        Expression.Literal.LiteralTypeCase literalTypeCase = lit.getLiteralTypeCase();
        if (Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase)) {
            return lit.getString();
        }
        return this.toCatalystExpression(lit).value();
    }

    private Object toArrayData(Expression.Literal.Array array) {
        org.apache.spark.connect.proto.DataType elementType = array.getElementType();
        if (elementType.hasShort()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToShort((short)LiteralExpressionProtoConverter$.$anonfun$toArrayData$1(v)), ClassTag$.MODULE$.Short(), array);
        }
        if (elementType.hasInteger()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)v.getInteger()), ClassTag$.MODULE$.Int(), array);
        }
        if (elementType.hasLong()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToLong((long)v.getLong()), ClassTag$.MODULE$.Long(), array);
        }
        if (elementType.hasDouble()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)v.getDouble()), ClassTag$.MODULE$.Double(), array);
        }
        if (elementType.hasByte()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToByte((byte)LiteralExpressionProtoConverter$.$anonfun$toArrayData$5(v)), ClassTag$.MODULE$.Byte(), array);
        }
        if (elementType.hasFloat()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToFloat((float)v.getFloat()), ClassTag$.MODULE$.Float(), array);
        }
        if (elementType.hasBoolean()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.getBoolean()), ClassTag$.MODULE$.Boolean(), array);
        }
        if (elementType.hasString()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> v.getString(), ClassTag$.MODULE$.apply(String.class), array);
        }
        if (elementType.hasBinary()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> v.getBinary().toByteArray(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), array);
        }
        if (elementType.hasDate()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> DateTimeUtils$.MODULE$.toJavaDate(v.getDate()), ClassTag$.MODULE$.apply(Date.class), array);
        }
        if (elementType.hasTimestamp()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> DateTimeUtils$.MODULE$.toJavaTimestamp(v.getTimestamp()), ClassTag$.MODULE$.apply(Timestamp.class), array);
        }
        if (elementType.hasTimestampNtz()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> DateTimeUtils$.MODULE$.microsToLocalDateTime(v.getTimestampNtz()), ClassTag$.MODULE$.apply(LocalDateTime.class), array);
        }
        if (elementType.hasDayTimeInterval()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> IntervalUtils$.MODULE$.microsToDuration(v.getDayTimeInterval()), ClassTag$.MODULE$.apply(Duration.class), array);
        }
        if (elementType.hasYearMonthInterval()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> IntervalUtils$.MODULE$.monthsToPeriod(v.getYearMonthInterval()), ClassTag$.MODULE$.apply(Period.class), array);
        }
        if (elementType.hasDecimal()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> Decimal$.MODULE$.apply(v.getDecimal().getValue()), ClassTag$.MODULE$.apply(Decimal.class), array);
        }
        if (elementType.hasCalendarInterval()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> {
                Expression.Literal.CalendarInterval interval = v.getCalendarInterval();
                return new CalendarInterval(interval.getMonths(), interval.getDays(), interval.getMicroseconds());
            }, ClassTag$.MODULE$.apply(CalendarInterval.class), array);
        }
        if (elementType.hasArray()) {
            return LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable & scala.Serializable)v -> MODULE$.toArrayData(v.getArray()), ClassTag$.MODULE$.Any(), array);
        }
        throw new InvalidPlanInput(new StringBuilder(27).append("Unsupported Literal Type: ").append(elementType).append(")").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
    }

    private static final Object makeArrayData$1(Function1 converter, ClassTag tag, Expression.Literal.Array array$1) {
        ArrayBuilder builder = ArrayBuilder$.MODULE$.make(tag);
        List<Expression.Literal> elementList = array$1.getElementsList();
        builder.sizeHint(elementList.size());
        Iterator<Expression.Literal> iter = elementList.iterator();
        while (iter.hasNext()) {
            builder.$plus$eq(converter.apply((Object)iter.next()));
        }
        return builder.result();
    }

    public static final /* synthetic */ short $anonfun$toArrayData$1(Expression.Literal v) {
        return (short)v.getShort();
    }

    public static final /* synthetic */ byte $anonfun$toArrayData$5(Expression.Literal v) {
        return (byte)v.getByte();
    }

    private LiteralExpressionProtoConverter$() {
        MODULE$ = this;
    }
}

