/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.services;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.sparkproject.connect.grpc.Context;
import org.sparkproject.connect.grpc.ExperimentalApi;
import org.sparkproject.connect.guava.annotations.VisibleForTesting;
import org.sparkproject.connect.guava.base.Preconditions;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6012")
@ThreadSafe
public final class CallMetricRecorder {
    private static final CallMetricRecorder NOOP = new CallMetricRecorder().disable();
    static final Context.Key<CallMetricRecorder> CONTEXT_KEY = Context.key("org.sparkproject.connect.grpc.services.CallMetricRecorder");
    private final AtomicReference<ConcurrentHashMap<String, Double>> utilizationMetrics = new AtomicReference();
    private final AtomicReference<ConcurrentHashMap<String, Double>> requestCostMetrics = new AtomicReference();
    private double cpuUtilizationMetric = 0.0;
    private double memoryUtilizationMetric = 0.0;
    private volatile boolean disabled;

    public static CallMetricRecorder getCurrent() {
        CallMetricRecorder recorder = CONTEXT_KEY.get();
        return recorder != null ? recorder : NOOP;
    }

    public CallMetricRecorder recordUtilizationMetric(String name, double value) {
        if (this.disabled) {
            return this;
        }
        if (this.utilizationMetrics.get() == null) {
            this.utilizationMetrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.utilizationMetrics.get().put(name, value);
        return this;
    }

    public CallMetricRecorder recordCallMetric(String name, double value) {
        if (this.disabled) {
            return this;
        }
        if (this.requestCostMetrics.get() == null) {
            this.requestCostMetrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.requestCostMetrics.get().put(name, value);
        return this;
    }

    public CallMetricRecorder recordCpuUtilizationMetric(double value) {
        if (this.disabled) {
            return this;
        }
        this.cpuUtilizationMetric = value;
        return this;
    }

    public CallMetricRecorder recordMemoryUtilizationMetric(double value) {
        if (this.disabled) {
            return this;
        }
        this.memoryUtilizationMetric = value;
        return this;
    }

    Map<String, Double> finalizeAndDump() {
        this.disabled = true;
        Map savedMetrics = this.requestCostMetrics.get();
        if (savedMetrics == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(savedMetrics);
    }

    CallMetricReport finalizeAndDump2() {
        Map<String, Double> savedRequestCostMetrics = this.finalizeAndDump();
        Map savedUtilizationMetrics = this.utilizationMetrics.get();
        if (savedUtilizationMetrics == null) {
            savedUtilizationMetrics = Collections.emptyMap();
        }
        return new CallMetricReport(this.cpuUtilizationMetric, this.memoryUtilizationMetric, Collections.unmodifiableMap(savedRequestCostMetrics), Collections.unmodifiableMap(savedUtilizationMetrics));
    }

    @VisibleForTesting
    boolean isDisabled() {
        return this.disabled;
    }

    private CallMetricRecorder disable() {
        this.disabled = true;
        return this;
    }

    public static final class CallMetricReport {
        private double cpuUtilization;
        private double memoryUtilization;
        private Map<String, Double> requestCostMetrics;
        private Map<String, Double> utilizationMetrics;

        CallMetricReport(double cpuUtilization, double memoryUtilization, Map<String, Double> requestCostMetrics, Map<String, Double> utilizationMetrics) {
            this.cpuUtilization = cpuUtilization;
            this.memoryUtilization = memoryUtilization;
            this.requestCostMetrics = Preconditions.checkNotNull(requestCostMetrics, "requestCostMetrics");
            this.utilizationMetrics = Preconditions.checkNotNull(utilizationMetrics, "utilizationMetrics");
        }

        public double getCpuUtilization() {
            return this.cpuUtilization;
        }

        public double getMemoryUtilization() {
            return this.memoryUtilization;
        }

        public Map<String, Double> getRequestCostMetrics() {
            return this.requestCostMetrics;
        }

        public Map<String, Double> getUtilizationMetrics() {
            return this.utilizationMetrics;
        }
    }
}

