/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.NoSuchElementException;
import org.apache.arrow.flatbuf.Message;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowMessage;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageChannelReader;
import org.apache.arrow.vector.ipc.message.MessageResult;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.connect.client.arrow.AbstractMessageIterator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0004\b\u0001;!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0019q\u0004\u0001)A\u0005\u007f!1q\t\u0001Q\u0001\n!C\u0011B\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B(\t\u000fI\u0003!\u0019!C\u0001'\"1A\f\u0001Q\u0001\nQCQ!\u0018\u0001\u0005ByCQA\u0019\u0001\u0005B\rDQa\u001a\u0001\u0005B!DQ\u0001\u001c\u0001\u0005\n5\u0014q\"T3tg\u0006<W-\u0013;fe\u0006$xN\u001d\u0006\u0003\u001fA\tQ!\u0019:s_^T!!\u0005\n\u0002\r\rd\u0017.\u001a8u\u0015\t\u0019B#A\u0004d_:tWm\u0019;\u000b\u0005U1\u0012aA:rY*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u0019j\u0011AD\u0005\u0003O9\u0011q#\u00112tiJ\f7\r^'fgN\fw-Z%uKJ\fGo\u001c:\u0002\u000b%t\u0007/\u001e;\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013AA5p\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\nC2dwnY1u_J\u0004\"aM\u001c\u000e\u0003QR!!\u000e\u001c\u0002\r5,Wn\u001c:z\u0015\ty\u0001$\u0003\u00029i\ty!)\u001e4gKJ\fE\u000e\\8dCR|'/\u0001\u0004=S:LGO\u0010\u000b\u0004wqj\u0004CA\u0013\u0001\u0011\u0015A3\u00011\u0001*\u0011\u0015\t4\u00011\u00013\u0003\tIg\u000e\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006\u0019\u0011\u000e]2\u000b\u0005\u00113\u0014A\u0002<fGR|'/\u0003\u0002G\u0003\nY!+Z1e\u0007\"\fgN\\3m\u0003\u0019\u0011X-\u00193feB\u0011\u0011\nT\u0007\u0002\u0015*\u00111*Q\u0001\b[\u0016\u001c8/Y4f\u0013\ti%J\u0001\u000bNKN\u001c\u0018mZ3DQ\u0006tg.\u001a7SK\u0006$WM]\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0005%\u0003\u0016BA)K\u00055iUm]:bO\u0016\u0014Vm];mi\u000611o\u00195f[\u0006,\u0012\u0001\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA\u0001]8k_*\u0011\u0011lQ\u0001\u0006if\u0004Xm]\u0005\u00037Z\u0013aaU2iK6\f\u0017aB:dQ\u0016l\u0017\rI\u0001\nEf$Xm\u001d*fC\u0012,\u0012a\u0018\t\u0003?\u0001L!!\u0019\u0011\u0003\t1{gnZ\u0001\bQ\u0006\u001ch*\u001a=u+\u0005!\u0007CA\u0010f\u0013\t1\u0007EA\u0004C_>dW-\u00198\u0002\t9,\u0007\u0010\u001e\u000b\u0002SB\u0011\u0011J[\u0005\u0003W*\u0013A\"\u0011:s_^lUm]:bO\u0016\f!BY8es\n+hMZ3s)\tq\u0017\u000f\u0005\u00024_&\u0011\u0001\u000f\u000e\u0002\t\u0003J\u0014xn\u001e\"vM\")a\n\u0004a\u0001\u001f\u0002")
public class MessageIterator
implements AbstractMessageIterator {
    private final BufferAllocator allocator;
    private final ReadChannel in;
    private final MessageChannelReader reader;
    private MessageResult result;
    private final Schema schema;

    public Iterator<ArrowMessage> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<ArrowMessage> take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    public Iterator<ArrowMessage> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<ArrowMessage> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<ArrowMessage> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<ArrowMessage, B> f) {
        return Iterator.map$((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.$plus$plus$((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<ArrowMessage, GenTraversableOnce<B>> f) {
        return Iterator.flatMap$((Iterator)this, f);
    }

    public Iterator<ArrowMessage> filter(Function1<ArrowMessage, Object> p) {
        return Iterator.filter$((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ArrowMessage, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<ArrowMessage> withFilter(Function1<ArrowMessage, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public Iterator<ArrowMessage> filterNot(Function1<ArrowMessage, Object> p) {
        return Iterator.filterNot$((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<ArrowMessage, B> pf) {
        return Iterator.collect$((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, ArrowMessage, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<ArrowMessage, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Iterator<ArrowMessage> takeWhile(Function1<ArrowMessage, Object> p) {
        return Iterator.takeWhile$((Iterator)this, p);
    }

    public Tuple2<Iterator<ArrowMessage>, Iterator<ArrowMessage>> partition(Function1<ArrowMessage, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<ArrowMessage>, Iterator<ArrowMessage>> span(Function1<ArrowMessage, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<ArrowMessage> dropWhile(Function1<ArrowMessage, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<ArrowMessage, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<ArrowMessage, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<ArrowMessage, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<ArrowMessage, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<ArrowMessage, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<ArrowMessage> find(Function1<ArrowMessage, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<ArrowMessage, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<ArrowMessage, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<ArrowMessage> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<ArrowMessage>, Iterator<ArrowMessage>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<ArrowMessage> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<ArrowMessage> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<ArrowMessage> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<ArrowMessage> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<ArrowMessage, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<ArrowMessage, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, ArrowMessage, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<ArrowMessage, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, ArrowMessage, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<ArrowMessage, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, ArrowMessage, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<ArrowMessage, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, ArrowMessage, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<ArrowMessage, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, ArrowMessage, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<ArrowMessage> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<ArrowMessage> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<ArrowMessage> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<ArrowMessage> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<ArrowMessage> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, ArrowMessage, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<ArrowMessage, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public long bytesRead() {
        return this.reader.bytesRead();
    }

    public boolean hasNext() {
        if (this.result == null) {
            this.result = this.reader.readNext();
        }
        return this.result != null;
    }

    public ArrowMessage next() {
        ArrowRecordBatch arrowRecordBatch;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        byte by = this.result.getMessage().headerType();
        switch (by) {
            case 3: {
                arrowRecordBatch = MessageSerializer.deserializeRecordBatch((Message)this.result.getMessage(), (ArrowBuf)this.bodyBuffer(this.result));
                break;
            }
            case 2: {
                arrowRecordBatch = MessageSerializer.deserializeDictionaryBatch((Message)this.result.getMessage(), (ArrowBuf)this.bodyBuffer(this.result));
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        ArrowRecordBatch message = arrowRecordBatch;
        this.result = null;
        return message;
    }

    private ArrowBuf bodyBuffer(MessageResult result) {
        ArrowBuf buffer;
        block0: {
            buffer = result.getBodyBuffer();
            if (buffer != null) break block0;
            buffer = this.allocator.getEmpty();
        }
        return buffer;
    }

    public MessageIterator(InputStream input, BufferAllocator allocator) {
        this.allocator = allocator;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        this.in = new ReadChannel(Channels.newChannel(input));
        this.reader = new MessageChannelReader(this.in, allocator);
        MessageResult result = this.reader.readNext();
        if (result == null) {
            throw new IOException("Unexpected end of input. Missing schema.");
        }
        this.schema = MessageSerializer.deserializeSchema((Message)result.getMessage());
    }
}

