/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.common.ProtoUtils$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.execution.ExecuteGrpcResponseSender;
import org.apache.spark.sql.connect.execution.ExecuteResponseObserver;
import org.apache.spark.sql.connect.execution.ExecuteThreadRunner;
import org.apache.spark.sql.connect.service.ExecuteEventsManager;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.ExecuteJobTag$;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001da!B\u0017/\u0001AR\u0004\u0002C$\u0001\u0005\u000b\u0007I\u0011A%\t\u0011E\u0003!\u0011!Q\u0001\n)C\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\t1\u0002\u0011\t\u0011)A\u0005)\")\u0011\f\u0001C\u00015\"9a\f\u0001b\u0001\n\u0003y\u0006B\u00023\u0001A\u0003%\u0001\rC\u0004f\u0001\t\u0007I\u0011\u00014\t\r=\u0004\u0001\u0015!\u0003h\u0011\u001d\u0001\bA1A\u0005\u0002EDa\u0001 \u0001!\u0002\u0013\u0011\bbB?\u0001\u0005\u0004%\tA \u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003\u0000\u0011%\t9\u0001\u0001b\u0001\n\u0003\tI\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0006\u0011%\t\u0019\u0002\u0001b\u0001\n\u0003\t)\u0002\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\f\u0011%\tY\u0003\u0001b\u0001\n\u0003\ti\u0003\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0018\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001e\u0011%\t\u0019\u0005\u0001b\u0001\n\u0003\t)\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA$\u0011%\ty\u0005\u0001a\u0001\n\u0003\t\t\u0006C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0001\u0002\\!A\u0011q\r\u0001!B\u0013\t\u0019\u0006C\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002R!I\u00111\u000f\u0001A\u0002\u0013%\u0011Q\u000f\u0005\t\u0003s\u0002\u0001\u0015)\u0003\u0002T!I\u00111\u0010\u0001C\u0002\u0013%\u0011Q\u0010\u0005\t\u0003+\u0003\u0001\u0015!\u0003\u0002\u0000!9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005bBAN\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\ti\n\u0001C\u0001\u0003KCq!!,\u0001\t\u0013\ty\u000bC\u0004\u00026\u0002!\t!a.\t\u000f\u0005m\u0007\u0001\"\u0001\u0002\u001a\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0007bBAs\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0003S\u0004A\u0011AAM\u0011\u001d\tY\u000f\u0001C\u0001\u0003[Dq!a=\u0001\t\u0003\t)\u0010C\u0004\u0002~\u0002!\t!a@\u0003\u001b\u0015CXmY;uK\"{G\u000eZ3s\u0015\ty\u0003'A\u0004tKJ4\u0018nY3\u000b\u0005E\u0012\u0014aB2p]:,7\r\u001e\u0006\u0003gQ\n1a]9m\u0015\t)d'A\u0003ta\u0006\u00148N\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<7c\u0001\u0001<\u0003B\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1\u0011I\\=SK\u001a\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u001b\u0002\u0011%tG/\u001a:oC2L!AR\"\u0003\u000f1{wmZ5oO\u00069!/Z9vKN$8\u0001A\u000b\u0002\u0015B\u00111jT\u0007\u0002\u0019*\u0011QJT\u0001\u0006aJ|Go\u001c\u0006\u0003cQJ!\u0001\u0015'\u0003%\u0015CXmY;uKBc\u0017M\u001c*fcV,7\u000f^\u0001\te\u0016\fX/Z:uA\u0005i1/Z:tS>t\u0007j\u001c7eKJ,\u0012\u0001\u0016\t\u0003+Zk\u0011AL\u0005\u0003/:\u0012QbU3tg&|g\u000eS8mI\u0016\u0014\u0018AD:fgNLwN\u001c%pY\u0012,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007mcV\f\u0005\u0002V\u0001!)q)\u0002a\u0001\u0015\")!+\u0002a\u0001)\u000691/Z:tS>tW#\u00011\u0011\u0005\u0005\u0014W\"\u0001\u001a\n\u0005\r\u0014$\u0001D*qCJ\\7+Z:tS>t\u0017\u0001C:fgNLwN\u001c\u0011\u0002\u0017=\u0004XM]1uS>t\u0017\nZ\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005Y\u0006twMC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'AB*ue&tw-\u0001\u0007pa\u0016\u0014\u0018\r^5p]&#\u0007%\u0001\u0004k_\n$\u0016mZ\u000b\u0002eB\u00111O\u001f\b\u0003ib\u0004\"!^\u001f\u000e\u0003YT!a\u001e%\u0002\rq\u0012xn\u001c;?\u0013\tIX(\u0001\u0004Qe\u0016$WMZ\u0005\u0003]nT!!_\u001f\u0002\u000f)|'\rV1hA\u0005\u00012\u000f]1sWN+7o]5p]R\u000bwm]\u000b\u0002\u007fB!1/!\u0001s\u0013\r\t\u0019a\u001f\u0002\u0004'\u0016$\u0018!E:qCJ\\7+Z:tS>tG+Y4tA\u0005a!/Z1ui\u0006\u001c\u0007.\u00192mKV\u0011\u00111\u0002\t\u0004y\u00055\u0011bAA\b{\t9!i\\8mK\u0006t\u0017!\u0004:fCR$\u0018m\u00195bE2,\u0007%\u0001\tsKN\u0004xN\\:f\u001f\n\u001cXM\u001d<feV\u0011\u0011q\u0003\t\u0007\u00033\ty\"a\t\u000e\u0005\u0005m!bAA\u000fa\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0003C\tYBA\fFq\u0016\u001cW\u000f^3SKN\u0004xN\\:f\u001f\n\u001cXM\u001d<feB\u00191*!\n\n\u0007\u0005\u001dBJA\nFq\u0016\u001cW\u000f^3QY\u0006t'+Z:q_:\u001cX-A\tsKN\u0004xN\\:f\u001f\n\u001cXM\u001d<fe\u0002\nQ\"\u001a<f]R\u001cX*\u00198bO\u0016\u0014XCAA\u0018!\r)\u0016\u0011G\u0005\u0004\u0003gq#\u0001F#yK\u000e,H/Z#wK:$8/T1oC\u001e,'/\u0001\bfm\u0016tGo]'b]\u0006<WM\u001d\u0011\u0002\rI,hN\\3s+\t\tY\u0004\u0005\u0003\u0002\u001a\u0005u\u0012\u0002BA \u00037\u00111#\u0012=fGV$X\r\u00165sK\u0006$'+\u001e8oKJ\fqA];o]\u0016\u0014\b%\u0001\u0007de\u0016\fG/[8o)&lW-\u0006\u0002\u0002HA\u0019A(!\u0013\n\u0007\u0005-SH\u0001\u0003M_:<\u0017!D2sK\u0006$\u0018n\u001c8US6,\u0007%A\nmCN$\u0018\t\u001e;bG\",GM\u00159d)&lW-\u0006\u0002\u0002TA)A(!\u0016\u0002H%\u0019\u0011qK\u001f\u0003\r=\u0003H/[8o\u0003]a\u0017m\u001d;BiR\f7\r[3e%B\u001cG+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002^\u0005\r\u0004c\u0001\u001f\u0002`%\u0019\u0011\u0011M\u001f\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003KJ\u0012\u0011!a\u0001\u0003'\n1\u0001\u001f\u00132\u0003Qa\u0017m\u001d;BiR\f7\r[3e%B\u001cG+[7fA!\u001a!$a\u001b\u0011\u0007q\ni'C\u0002\u0002pu\u0012\u0001B^8mCRLG.Z\u0001\u000bG2|7/\u001a3US6,\u0017AD2m_N,G\rV5nK~#S-\u001d\u000b\u0005\u0003;\n9\bC\u0005\u0002fq\t\t\u00111\u0001\u0002T\u0005Y1\r\\8tK\u0012$\u0016.\\3!\u0003M9'\u000f]2SKN\u0004xN\\:f'\u0016tG-\u001a:t+\t\ty\b\u0005\u0004\u0002\u0002\u0006-\u0015qR\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u00069Q.\u001e;bE2,'bAAE{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u00151\u0011\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0004\u0002\u001a\u0005E\u00151E\u0005\u0005\u0003'\u000bYBA\rFq\u0016\u001cW\u000f^3HeB\u001c'+Z:q_:\u001cXmU3oI\u0016\u0014\u0018\u0001F4sa\u000e\u0014Vm\u001d9p]N,7+\u001a8eKJ\u001c\b%A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002^\u0005!!n\\5o\u0003U\u0011XO\\$sa\u000e\u0014Vm\u001d9p]N,7+\u001a8eKJ$B!!\u0018\u0002\"\"9\u00111\u0015\u0012A\u0002\u0005=\u0015A\u0004:fgB|gn]3TK:$WM\u001d\u000b\u0007\u0003;\n9+!+\t\u000f\u0005\r6\u00051\u0001\u0002\u0010\"1\u00111V\u0012A\u0002I\fa\u0003\\1ti\u000e{gn];nK\u0012\u0014Vm\u001d9p]N,\u0017\nZ\u0001\u0016C\u0012$wI\u001d9d%\u0016\u001c\bo\u001c8tKN+g\u000eZ3s)\u0011\ti&!-\t\u000f\u0005MF\u00051\u0001\u0002\u0010\u000611/\u001a8eKJ\f\u0001D]3n_Z,wI\u001d9d%\u0016\u001c\bo\u001c8tKN+g\u000eZ3s+\u0011\tI,a6\u0015\t\u0005u\u00131\u0018\u0005\b\u0003g+\u0003\u0019AA_a\u0011\ty,!2\u0011\r\u0005e\u0011\u0011SAa!\u0011\t\u0019-!2\r\u0001\u0011a\u0011qYA^\u0003\u0003\u0005\tQ!\u0001\u0002J\n\u0019q\fJ\u0019\u0012\t\u0005-\u0017\u0011\u001b\t\u0004y\u00055\u0017bAAh{\t9aj\u001c;iS:<\u0007c\u0001\u001f\u0002T&\u0019\u0011Q[\u001f\u0003\u0007\u0005s\u0017\u0010B\u0004\u0002Z\u0016\u0012\r!!3\u0003\u0003}\u000bq\"\u00194uKJLe.\u001b;jC2\u0014\u0006kQ\u0001\u0017e\u0016dW-Y:f+:$\u0018\u000e\u001c*fgB|gn]3JIR!\u0011QLAq\u0011\u0019\t\u0019o\na\u0001e\u0006Q!/Z:q_:\u001cX-\u00133\u0002\u0013%tG/\u001a:skB$HCAA\u0006\u0003\u0015\u0019Gn\\:f\u0003A!\u0018m\u001a+p'B\f'o\u001b&pER\u000bw\rF\u0002s\u0003_Da!!=+\u0001\u0004\u0011\u0018a\u0001;bO\u0006qq-\u001a;Fq\u0016\u001cW\u000f^3J]\u001a|WCAA|!\r)\u0016\u0011`\u0005\u0004\u0003wt#aC#yK\u000e,H/Z%oM>\f1a[3z+\t\u0011\t\u0001E\u0002V\u0005\u0007I1A!\u0002/\u0005))\u00050Z2vi\u0016\\U-\u001f")
public class ExecuteHolder
implements Logging {
    private final ExecutePlanRequest request;
    private final SessionHolder sessionHolder;
    private final SparkSession session;
    private final String operationId;
    private final String jobTag;
    private final Set<String> sparkSessionTags;
    private final boolean reattachable;
    private final ExecuteResponseObserver<ExecutePlanResponse> responseObserver;
    private final ExecuteEventsManager eventsManager;
    private final ExecuteThreadRunner runner;
    private final long creationTime;
    private volatile Option<Object> lastAttachedRpcTime;
    private Option<Object> closedTime;
    private final ArrayBuffer<ExecuteGrpcResponseSender<ExecutePlanResponse>> grpcResponseSenders;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ExecutePlanRequest request() {
        return this.request;
    }

    public SessionHolder sessionHolder() {
        return this.sessionHolder;
    }

    public SparkSession session() {
        return this.session;
    }

    public String operationId() {
        return this.operationId;
    }

    public String jobTag() {
        return this.jobTag;
    }

    public Set<String> sparkSessionTags() {
        return this.sparkSessionTags;
    }

    public boolean reattachable() {
        return this.reattachable;
    }

    public ExecuteResponseObserver<ExecutePlanResponse> responseObserver() {
        return this.responseObserver;
    }

    public ExecuteEventsManager eventsManager() {
        return this.eventsManager;
    }

    private ExecuteThreadRunner runner() {
        return this.runner;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public Option<Object> lastAttachedRpcTime() {
        return this.lastAttachedRpcTime;
    }

    public void lastAttachedRpcTime_$eq(Option<Object> x$1) {
        this.lastAttachedRpcTime = x$1;
    }

    private Option<Object> closedTime() {
        return this.closedTime;
    }

    private void closedTime_$eq(Option<Object> x$1) {
        this.closedTime = x$1;
    }

    private ArrayBuffer<ExecuteGrpcResponseSender<ExecutePlanResponse>> grpcResponseSenders() {
        return this.grpcResponseSenders;
    }

    public void start() {
        this.runner().start();
    }

    public void join() {
        this.runner().join();
    }

    public void runGrpcResponseSender(ExecuteGrpcResponseSender<ExecutePlanResponse> responseSender) {
        this.addGrpcResponseSender(responseSender);
        responseSender.run(0L);
    }

    public void runGrpcResponseSender(ExecuteGrpcResponseSender<ExecutePlanResponse> responseSender, String lastConsumedResponseId) {
        long lastConsumedIndex = this.responseObserver().getResponseIndexById(lastConsumedResponseId);
        this.addGrpcResponseSender(responseSender);
        responseSender.run(lastConsumedIndex);
    }

    private synchronized void addGrpcResponseSender(ExecuteGrpcResponseSender<ExecutePlanResponse> sender) {
        if (this.closedTime().isEmpty()) {
            this.grpcResponseSenders().$plus$eq(sender);
            this.lastAttachedRpcTime_$eq((Option<Object>)None$.MODULE$);
            return;
        }
        sender.interrupt();
    }

    public synchronized <_> void removeGrpcResponseSender(ExecuteGrpcResponseSender<?> sender) {
        if (this.closedTime().isEmpty()) {
            this.grpcResponseSenders().$minus$eq(sender);
            if (this.grpcResponseSenders().isEmpty()) {
                this.lastAttachedRpcTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
                return;
            }
            return;
        }
    }

    public synchronized void afterInitialRPC() {
        if (this.closedTime().isEmpty()) {
            if (this.grpcResponseSenders().isEmpty()) {
                this.lastAttachedRpcTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
                return;
            }
            return;
        }
    }

    public void releaseUntilResponseId(String responseId) {
        this.responseObserver().removeResponsesUntilId(responseId);
    }

    public boolean interrupt() {
        return this.runner().interrupt();
    }

    public synchronized void close() {
        if (this.closedTime().isEmpty()) {
            this.runner().interrupt();
            this.runner().join();
            this.grpcResponseSenders().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.interrupt();
                return BoxedUnit.UNIT;
            });
            if (this.grpcResponseSenders().nonEmpty()) {
                this.lastAttachedRpcTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
                this.grpcResponseSenders().clear();
            }
            this.responseObserver().removeAll();
            this.eventsManager().postClosed();
            this.closedTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            return;
        }
    }

    public String tagToSparkJobTag(String tag) {
        return new StringBuilder(40).append("SparkConnect_Execute_").append("User_").append(this.sessionHolder().userId()).append("_Session_").append(this.sessionHolder().sessionId()).append("_Tag_").append(tag).toString();
    }

    public synchronized ExecuteInfo getExecuteInfo() {
        return new ExecuteInfo(this.request(), this.sessionHolder().userId(), this.sessionHolder().sessionId(), this.operationId(), this.jobTag(), this.sparkSessionTags(), this.reattachable(), this.eventsManager().status(), this.creationTime(), this.lastAttachedRpcTime(), this.closedTime());
    }

    public ExecuteKey key() {
        return new ExecuteKey(this.sessionHolder().userId(), this.sessionHolder().sessionId(), this.operationId());
    }

    private final /* synthetic */ String liftedTree1$1() {
        String string;
        try {
            string = UUID.fromString(this.request().getOperationId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)this.request().getOperationId())})));
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$reattachable$1(ExecutePlanRequest.RequestOption option) {
        return option.hasReattachOptions() && option.getReattachOptions().getReattachable();
    }

    public ExecuteHolder(ExecutePlanRequest request, SessionHolder sessionHolder) {
        this.request = request;
        this.sessionHolder = sessionHolder;
        Logging.$init$((Logging)this);
        this.session = sessionHolder.session();
        this.operationId = request.hasOperationId() ? this.liftedTree1$1() : UUID.randomUUID().toString();
        this.jobTag = ExecuteJobTag$.MODULE$.apply(sessionHolder.userId(), sessionHolder.sessionId(), this.operationId());
        this.sparkSessionTags = ((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)request.getTagsList()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)tag -> {
            ProtoUtils$.MODULE$.throwIfInvalidTag((String)tag);
            return tag;
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        this.reattachable = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_REATTACHABLE_ENABLED())) && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getRequestOptionsList()).asScala()).exists((Function1 & Serializable & scala.Serializable)option -> BoxesRunTime.boxToBoolean((boolean)ExecuteHolder.$anonfun$reattachable$1(option)));
        this.responseObserver = new ExecuteResponseObserver(this);
        this.eventsManager = new ExecuteEventsManager(this, (Clock)new SystemClock());
        this.runner = new ExecuteThreadRunner(this);
        this.creationTime = System.currentTimeMillis();
        this.lastAttachedRpcTime = None$.MODULE$;
        this.closedTime = None$.MODULE$;
        this.grpcResponseSenders = new ArrayBuffer();
    }
}

