/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.ReattachExecuteRequest;
import org.apache.spark.connect.proto.ReattachOptions;
import org.apache.spark.connect.proto.SparkConnectServiceGrpc;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.WrappedCloseableIterator;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.dsl.package;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Signaler$;
import org.scalatest.concurrent.TimeLimits$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\rda\u0002\u0014(!\u0003\r\tA\r\u0005\u0006{\u0001!\tA\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u001dQ\u0005A1A\u0005\u0002-CQ\u0001\u0016\u0001\u0005ByBQ!\u0016\u0001\u0005ByBQA\u0016\u0001\u0005ByBQa\u0016\u0001\u0005ByBQ\u0001\u0017\u0001\u0005\u0012yBq!\u0017\u0001C\u0002\u0013E!\fC\u0004d\u0001\t\u0007I\u0011\u0003.\t\u000f\u0011\u0004!\u0019!C\tK\"9Q\u0010\u0001b\u0001\n#q\bbBA\u0007\u0001\u0011E\u0011q\u0002\u0005\n\u0003o\u0001\u0011\u0013!C\t\u0003sA\u0011\"a\u0014\u0001#\u0003%\t\"!\u000f\t\u000f\u0005E\u0003\u0001\"\u0005\u0002T!9\u0011q\r\u0001\u0005\u0012\u0005%\u0004bBA8\u0001\u0011E\u0011\u0011\u000f\u0005\u0007\u0003\u001f\u0003A\u0011\u0003 \t\r\u0005E\u0005\u0001\"\u0005?\u0011\u0019\t\u0019\n\u0001C\t}!1\u0011Q\u0013\u0001\u0005\u0012yBq!a&\u0001\t#\tI\nC\u0004\u0002\u001e\u0002!\t\"a(\t\u000f\u0005\r\u0006\u0001\"\u0005\u0002&\"9\u00111\u0017\u0001\u0005\u0012\u0005U\u0006bBAd\u0001\u0011E\u0011\u0011\u001a\u0005\b\u0003G\u0004A\u0011CAs\u0011%\u0011)\u0001AI\u0001\n#\u00119\u0001C\u0004\u0003\f\u0001!\tB!\u0004\t\u000f\t-\u0001\u0001\"\u0005\u0003 !I!q\u0005\u0001\u0012\u0002\u0013E!\u0011\u0006\u0005\u000e\u0005[\u0001\u0001\u0013aA\u0001\u0002\u0013%aHa\f\t\u001d\tE\u0002\u0001%A\u0002\u0002\u0003%IAa\r\u0003P!i!1\u000b\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003?\u0005+BQBa\u0016\u0001!\u0003\r\t\u0011!C\u0005}\te\u0003\"\u0004B0\u0001A\u0005\u0019\u0011!A\u0005\ny\u0012\tG\u0001\fTa\u0006\u00148nQ8o]\u0016\u001cGoU3sm\u0016\u0014H+Z:u\u0015\tA\u0013&A\u0004d_:tWm\u0019;\u000b\u0005)Z\u0013aA:rY*\u0011A&L\u0001\u0006gB\f'o\u001b\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019t\u0007\u0005\u00025k5\t1&\u0003\u00027W\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u0015\u0002\tQ,7\u000f^\u0005\u0003ye\u0012!c\u00155be\u0016$7\u000b]1sWN+7o]5p]\u00061A%\u001b8ji\u0012\"\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0005+:LG/\u0001\u0006tKJ4XM\u001d)peR,\u0012a\u0012\t\u0003\u0001\"K!!S!\u0003\u0007%sG/A\tfm\u0016tG/^1mYf$\u0016.\\3pkR,\u0012\u0001\u0014\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bA\u0001^5nK*\u0011\u0011kL\u0001\ng\u000e\fG.\u0019;fgRL!a\u0015(\u0003\tM\u0003\u0018M\\\u0001\nE\u00164wN]3BY2\f\u0001\"\u00194uKJ\fE\u000e\\\u0001\u000bE\u00164wN]3FC\u000eD\u0017!C1gi\u0016\u0014X)Y2i\u0003I\u0019G.Z1s\u00032dW\t_3dkRLwN\\:\u0002!\u0011,g-Y;miN+7o]5p]&#W#A.\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016\u0001\u00027b]\u001eT\u0011\u0001Y\u0001\u0005U\u00064\u0018-\u0003\u0002c;\n11\u000b\u001e:j]\u001e\fQ\u0002Z3gCVdG/V:fe&#\u0017a\u00013tYV\ta\r\u0005\u0002hu:\u0011\u0001n\u001e\b\u0003SZt!A[;\u000f\u0005-$hB\u00017t\u001d\ti'O\u0004\u0002oc6\tqN\u0003\u0002qc\u00051AH]8pizJ\u0011\u0001M\u0005\u0003]=J!\u0001L\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t!w%\u0003\u0002ys\u00069\u0001/Y2lC\u001e,'B\u00013(\u0013\tYHPA\tN_\u000e\\'+Z7pi\u0016\u001cVm]:j_:T!\u0001_=\u0002\u0017U\u001cXM]\"p]R,\u0007\u0010^\u000b\u0002\u007fB!\u0011\u0011AA\u0005\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!\u00029s_R|'B\u0001\u0015,\u0013\u0011\tY!a\u0001\u0003\u0017U\u001bXM]\"p]R,\u0007\u0010^\u0001\u0018EVLG\u000eZ#yK\u000e,H/\u001a)mC:\u0014V-];fgR$\u0002\"!\u0005\u0002\u0018\u0005\u0005\u00121\u0007\t\u0005\u0003\u0003\t\u0019\"\u0003\u0003\u0002\u0016\u0005\r!AE#yK\u000e,H/\u001a)mC:\u0014V-];fgRDq!!\u0007\u000e\u0001\u0004\tY\"\u0001\u0003qY\u0006t\u0007\u0003BA\u0001\u0003;IA!a\b\u0002\u0004\t!\u0001\u000b\\1o\u0011%\t\u0019#\u0004I\u0001\u0002\u0004\t)#A\u0005tKN\u001c\u0018n\u001c8JIB!\u0011qEA\u0018\u001d\u0011\tI#a\u000b\u0011\u00059\f\u0015bAA\u0017\u0003\u00061\u0001K]3eK\u001aL1AYA\u0019\u0015\r\ti#\u0011\u0005\n\u0003ki\u0001\u0013!a\u0001\u0003K\t1b\u001c9fe\u0006$\u0018n\u001c8JI\u0006\t#-^5mI\u0016CXmY;uKBc\u0017M\u001c*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\b\u0016\u0005\u0003K\tid\u000b\u0002\u0002@A!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013!C;oG\",7m[3e\u0015\r\tI%Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA'\u0003\u0007\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0005\u0012W/\u001b7e\u000bb,7-\u001e;f!2\fgNU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m\u0011W/\u001b7e%\u0016\fG\u000f^1dQ\u0016CXmY;uKJ+\u0017/^3tiR1\u0011QKA.\u0003;\u0002B!!\u0001\u0002X%!\u0011\u0011LA\u0002\u0005Y\u0011V-\u0019;uC\u000eDW\t_3dkR,'+Z9vKN$\bbBA\u001b!\u0001\u0007\u0011Q\u0005\u0005\b\u0003?\u0002\u0002\u0019AA1\u0003)\u0011Xm\u001d9p]N,\u0017\n\u001a\t\u0006\u0001\u0006\r\u0014QE\u0005\u0004\u0003K\n%AB(qi&|g.A\u0005ck&dG\r\u00157b]R!\u00111DA6\u0011\u001d\ti'\u0005a\u0001\u0003K\tQ!];fef\fqcZ3u%\u0016\fG\u000f^1dQ\u0006\u0014G.Z%uKJ\fGo\u001c:\u0015\t\u0005M\u0014q\u0010\t\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011P\u0014\u0002\r\rd\u0017.\u001a8u\u0013\u0011\ti(a\u001e\u0003O\u0015CXmY;uKBc\u0017M\u001c*fgB|gn]3SK\u0006$H/Y2iC\ndW-\u0013;fe\u0006$xN\u001d\u0005\b\u0003\u0003\u0013\u0002\u0019AAB\u00031\u0019H/\u001e2Ji\u0016\u0014\u0018\r^8s!\u0019\t)(!\"\u0002\n&!\u0011qQA<\u0005E\u0019En\\:fC\ndW-\u0013;fe\u0006$xN\u001d\t\u0005\u0003\u0003\tY)\u0003\u0003\u0002\u000e\u0006\r!aE#yK\u000e,H/\u001a)mC:\u0014Vm\u001d9p]N,\u0017AE1tg\u0016\u0014HOT8BGRLg/\u001a*qGN\fA$Y:tKJ$XI^3oiV\fG\u000e\\=O_\u0006\u001bG/\u001b<f%B\u001c7/\u0001\rbgN,'\u000f\u001e(p\u0003\u000e$\u0018N^3Fq\u0016\u001cW\u000f^5p]N\f!%Y:tKJ$XI^3oiV\fG\u000e\\=O_\u0006\u001bG/\u001b<f\u000bb,7-\u001e;j_:\u001c\u0018aF1tg\u0016\u0014H/\u0012=fGV$\u0018n\u001c8SK2,\u0017m]3e)\ry\u00141\u0014\u0005\b\u0003k9\u0002\u0019AA\u0013\u0003\u0005\n7o]3si\u00163XM\u001c;vC2d\u00170\u0012=fGV$\u0018n\u001c8SK2,\u0017m]3e)\ry\u0014\u0011\u0015\u0005\b\u0003kA\u0002\u0019AA\u0013\u0003I9W\r^#yK\u000e,H/[8o\u0011>dG-\u001a:\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003_k!!a+\u000b\u0007\u00055v%A\u0004tKJ4\u0018nY3\n\t\u0005E\u00161\u0016\u0002\u000e\u000bb,7-\u001e;f\u0011>dG-\u001a:\u0002\u0015]LG\u000f[\"mS\u0016tG\u000fF\u0002@\u0003oCq!!/\u001b\u0001\u0004\tY,A\u0001g!\u0019\u0001\u0015QXAa\u007f%\u0019\u0011qX!\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA;\u0003\u0007LA!!2\u0002x\t\u00112\u000b]1sW\u000e{gN\\3di\u000ec\u0017.\u001a8u\u0003M9\u0018\u000e\u001e5SC^\u0014En\\2lS:<7\u000b^;c)\ry\u00141\u001a\u0005\b\u0003s[\u0002\u0019AAg!\u0019\u0001\u0015QXAh\u007fA!\u0011\u0011[Ao\u001d\u0011\t\u0019.!7\u000f\t\u0005U\u0017q[\u0007\u0003\u0003\u000fIA!!\u0002\u0002\b%!\u00111\\A\u0002\u0003]\u0019\u0006/\u0019:l\u0007>tg.Z2u'\u0016\u0014h/[2f\u000fJ\u00048-\u0003\u0003\u0002`\u0006\u0005(aH*qCJ\\7i\u001c8oK\u000e$8+\u001a:wS\u000e,'\t\\8dW&twm\u0015;vE*!\u00111\\A\u0002\u0003Y9\u0018\u000e\u001e5DkN$x.\u001c\"m_\u000e\\\u0017N\\4TiV\u0014G\u0003BAt\u0003g$2aPAu\u0011\u001d\tI\f\ba\u0001\u0003W\u0004b\u0001QA_\u0003[|\u0004\u0003BA;\u0003_LA!!=\u0002x\tq2)^:u_6\u001c\u0006/\u0019:l\u0007>tg.Z2u\u00052|7m[5oON#XO\u0019\u0005\n\u0003kd\u0002\u0013!a\u0001\u0003o\f1B]3uef\u0004v\u000e\\5dsB!\u0011\u0011`A\u0000\u001d\u0011\t)(a?\n\t\u0005u\u0018qO\u0001\u0011\u000fJ\u00048MU3uefD\u0015M\u001c3mKJLAA!\u0001\u0003\u0004\tY!+\u001a;ssB{G.[2z\u0015\u0011\ti0a\u001e\u0002A]LG\u000f[\"vgR|WN\u00117pG.LgnZ*uk\n$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0013QC!a>\u0002>\u0005A!/\u001e8Rk\u0016\u0014\u0018\u0010F\u0004@\u0005\u001f\u0011\tB!\u0006\t\u000f\u0005ea\u00041\u0001\u0002\u001c!1!1\u0003\u0010A\u00021\u000bA\"];fef$\u0016.\\3pkRDqAa\u0006\u001f\u0001\u0004\u0011I\"A\u0005ji\u0016\u00148\u000b\\3faB\u0019\u0001Ia\u0007\n\u0007\tu\u0011I\u0001\u0003M_:<GcB \u0003\"\t\r\"Q\u0005\u0005\b\u0003[z\u0002\u0019AA\u0013\u0011\u0019\u0011\u0019b\ba\u0001\u0019\"I!qC\u0010\u0011\u0002\u0003\u0007!\u0011D\u0001\u0013eVt\u0017+^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u0003,)\"!\u0011DA\u001f\u0003=\u0019X\u000f]3sI\t,gm\u001c:f\u00032d\u0017B\u0001+<\u0003]\u0019X\u000f]3sI]LG\u000f[*qCJ\\WI\u001c<D_:47\u000f\u0006\u0003\u00036\t}BcA \u00038!A\u0011\u0011\u0018\u0012\u0005\u0002\u0004\u0011I\u0004\u0005\u0003A\u0005wy\u0014b\u0001B\u001f\u0003\nAAHY=oC6,g\bC\u0004\u0003B\t\u0002\rAa\u0011\u0002\u000bA\f\u0017N]:\u0011\u000b\u0001\u0013)E!\u0013\n\u0007\t\u001d\u0013I\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002r\u0001\u0011B&\u0003K\t)#C\u0002\u0003N\u0005\u0013a\u0001V;qY\u0016\u0014\u0014b\u0001B)k\u0005\tr/\u001b;i'B\f'o[#om\u000e{gNZ:\u0002\u001dM,\b/\u001a:%C\u001a$XM]!mY&\u0011QkO\u0001\u0011gV\u0004XM\u001d\u0013cK\u001a|'/Z#bG\"L1A\u0016B.\u0013\r\u0011i&\u000f\u0002\u0017'\"\f'/\u001a3Ta\u0006\u00148nU3tg&|gNQ1tK\u0006y1/\u001e9fe\u0012\ng\r^3s\u000b\u0006\u001c\u0007.C\u0002X\u00057\u0002")
public interface SparkConnectServerTest
extends SharedSparkSession {
    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$serverPort_$eq(int var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$eventuallyTimeout_$eq(Span var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultSessionId_$eq(String var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultUserId_$eq(String var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$dsl_$eq(package.MockRemoteSession var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$userContext_$eq(UserContext var1);

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeAll();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$withSparkEnvConfs(Seq var1, Function0 var2);

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterAll();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeEach();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterEach();

    public int serverPort();

    public Span eventuallyTimeout();

    public static /* synthetic */ void beforeAll$(SparkConnectServerTest $this) {
        $this.beforeAll();
    }

    default public void beforeAll() {
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeAll();
        SparkConnectService$.MODULE$.executionManager().shutdown();
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$withSparkEnvConfs((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT().key(), (Object)Integer.toString(this.serverPort()))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SparkConnectService$.MODULE$.start(this.spark().sparkContext()));
        SparkSession serverSession = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(this.defaultUserId(), this.defaultSessionId()).session();
        serverSession.udf().register("sleep", (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)ms -> {
            Thread.sleep(ms);
            return ms;
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
    }

    public static /* synthetic */ void afterAll$(SparkConnectServerTest $this) {
        $this.afterAll();
    }

    default public void afterAll() {
        SparkConnectService$.MODULE$.stop(SparkConnectService$.MODULE$.stop$default$1(), SparkConnectService$.MODULE$.stop$default$2());
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterAll();
    }

    public static /* synthetic */ void beforeEach$(SparkConnectServerTest $this) {
        $this.beforeEach();
    }

    default public void beforeEach() {
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeEach();
        this.clearAllExecutions();
    }

    public static /* synthetic */ void afterEach$(SparkConnectServerTest $this) {
        $this.afterEach();
    }

    default public void afterEach() {
        this.clearAllExecutions();
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterEach();
    }

    public static /* synthetic */ void clearAllExecutions$(SparkConnectServerTest $this) {
        $this.clearAllExecutions();
    }

    default public void clearAllExecutions() {
        SparkConnectService$.MODULE$.executionManager().listExecuteHolders().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        SparkConnectService$.MODULE$.executionManager().periodicMaintenance(0L);
        this.assertNoActiveExecutions();
    }

    public String defaultSessionId();

    public String defaultUserId();

    public package.MockRemoteSession dsl();

    public UserContext userContext();

    public static /* synthetic */ ExecutePlanRequest buildExecutePlanRequest$(SparkConnectServerTest $this, Plan plan, String sessionId, String operationId) {
        return $this.buildExecutePlanRequest(plan, sessionId, operationId);
    }

    default public ExecutePlanRequest buildExecutePlanRequest(Plan plan, String sessionId, String operationId) {
        return ExecutePlanRequest.newBuilder().setUserContext(this.userContext()).setSessionId(sessionId).setOperationId(operationId).setPlan(plan).addRequestOptions(ExecutePlanRequest.RequestOption.newBuilder().setReattachOptions(ReattachOptions.newBuilder().setReattachable(true).build()).build()).build();
    }

    public static /* synthetic */ String buildExecutePlanRequest$default$2$(SparkConnectServerTest $this) {
        return $this.buildExecutePlanRequest$default$2();
    }

    default public String buildExecutePlanRequest$default$2() {
        return this.defaultSessionId();
    }

    public static /* synthetic */ String buildExecutePlanRequest$default$3$(SparkConnectServerTest $this) {
        return $this.buildExecutePlanRequest$default$3();
    }

    default public String buildExecutePlanRequest$default$3() {
        return UUID.randomUUID().toString();
    }

    public static /* synthetic */ ReattachExecuteRequest buildReattachExecuteRequest$(SparkConnectServerTest $this, String operationId, Option responseId) {
        return $this.buildReattachExecuteRequest(operationId, (Option<String>)responseId);
    }

    default public ReattachExecuteRequest buildReattachExecuteRequest(String operationId, Option<String> responseId) {
        ReattachExecuteRequest.Builder req = ReattachExecuteRequest.newBuilder().setUserContext(this.userContext()).setSessionId(this.defaultSessionId()).setOperationId(operationId);
        Object object = responseId.isDefined() ? req.setLastResponseId((String)responseId.get()) : BoxedUnit.UNIT;
        return req.build();
    }

    public static /* synthetic */ Plan buildPlan$(SparkConnectServerTest $this, String query) {
        return $this.buildPlan(query);
    }

    default public Plan buildPlan(String query) {
        return Plan.newBuilder().setRoot(package.plans$.MODULE$.DslMockRemoteSession(this.dsl()).sql(query)).build();
    }

    public static /* synthetic */ ExecutePlanResponseReattachableIterator getReattachableIterator$(SparkConnectServerTest $this, CloseableIterator stubIterator) {
        return $this.getReattachableIterator((CloseableIterator<ExecutePlanResponse>)stubIterator);
    }

    default public ExecutePlanResponseReattachableIterator getReattachableIterator(CloseableIterator<ExecutePlanResponse> stubIterator) {
        return (ExecutePlanResponseReattachableIterator)((WrappedCloseableIterator)stubIterator).innerIterator();
    }

    public static /* synthetic */ void assertNoActiveRpcs$(SparkConnectServerTest $this) {
        $this.assertNoActiveRpcs();
    }

    default public void assertNoActiveRpcs() {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(executions.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerTest.$anonfun$assertNoActiveRpcs$1(x$2))), "executions.forall(((x$2: org.apache.spark.sql.connect.service.ExecuteInfo) => x$2.lastAttachedRpcTime.isDefined))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(26).append("Expected no RPCs, but got ").append(executions).toString(), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            return;
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyNoActiveRpcs$(SparkConnectServerTest $this) {
        $this.assertEventuallyNoActiveRpcs();
    }

    default public void assertEventuallyNoActiveRpcs() {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertNoActiveRpcs(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }

    public static /* synthetic */ void assertNoActiveExecutions$(SparkConnectServerTest $this) {
        $this.assertNoActiveExecutions();
    }

    default public void assertNoActiveExecutions() {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            throw ((Assertions)this).fail(new StringBuilder(24).append("Expected empty, but got ").append(executions).toString(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyNoActiveExecutions$(SparkConnectServerTest $this) {
        $this.assertEventuallyNoActiveExecutions();
    }

    default public void assertEventuallyNoActiveExecutions() {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertNoActiveExecutions(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }

    public static /* synthetic */ void assertExecutionReleased$(SparkConnectServerTest $this, String operationId) {
        $this.assertExecutionReleased(operationId);
    }

    default public void assertExecutionReleased(String operationId) {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(executions.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerTest.$anonfun$assertExecutionReleased$1(operationId, x$3))), "executions.exists(((x$3: org.apache.spark.sql.connect.service.ExecuteInfo) => x$3.operationId.==(operationId)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            return;
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyExecutionReleased$(SparkConnectServerTest $this, String operationId) {
        $this.assertEventuallyExecutionReleased(operationId);
    }

    default public void assertEventuallyExecutionReleased(String operationId) {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertExecutionReleased(operationId), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }

    public static /* synthetic */ ExecuteHolder getExecutionHolder$(SparkConnectServerTest $this) {
        return $this.getExecutionHolder();
    }

    default public ExecuteHolder getExecutionHolder() {
        Seq executions;
        Seq $org_scalatest_assert_macro_left = executions = SparkConnectService$.MODULE$.executionManager().listExecuteHolders();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        return (ExecuteHolder)executions.head();
    }

    public static /* synthetic */ void withClient$(SparkConnectServerTest $this, Function1 f) {
        $this.withClient((Function1<SparkConnectClient, BoxedUnit>)f);
    }

    default public void withClient(Function1<SparkConnectClient, BoxedUnit> f) {
        SparkConnectClient client = SparkConnectClient$.MODULE$.builder().port(this.serverPort()).sessionId(this.defaultSessionId()).userId(this.defaultUserId()).enableReattachableExecute().build();
        try {
            f.apply((Object)client);
        }
        finally {
            client.shutdown();
        }
    }

    public static /* synthetic */ void withRawBlockingStub$(SparkConnectServerTest $this, Function1 f) {
        $this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)f);
    }

    default public void withRawBlockingStub(Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit> f) {
        int x$1 = this.serverPort();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        String x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$3();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        GrpcRetryHandler.RetryPolicy x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        SparkConnectClient.Configuration conf = new SparkConnectClient.Configuration(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
        ManagedChannel channel = conf.createChannel();
        SparkConnectServiceGrpc.SparkConnectServiceBlockingStub bstub = SparkConnectServiceGrpc.newBlockingStub((Channel)channel);
        try {
            f.apply((Object)bstub);
        }
        finally {
            channel.shutdownNow();
        }
    }

    public static /* synthetic */ void withCustomBlockingStub$(SparkConnectServerTest $this, GrpcRetryHandler.RetryPolicy retryPolicy, Function1 f) {
        $this.withCustomBlockingStub(retryPolicy, (Function1<CustomSparkConnectBlockingStub, BoxedUnit>)f);
    }

    default public void withCustomBlockingStub(GrpcRetryHandler.RetryPolicy retryPolicy, Function1<CustomSparkConnectBlockingStub, BoxedUnit> f) {
        int x$1 = this.serverPort();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        String x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$3();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        GrpcRetryHandler.RetryPolicy x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        SparkConnectClient.Configuration conf = new SparkConnectClient.Configuration(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
        ManagedChannel channel = conf.createChannel();
        CustomSparkConnectBlockingStub bstub = new CustomSparkConnectBlockingStub(channel, retryPolicy);
        try {
            f.apply((Object)bstub);
        }
        finally {
            channel.shutdownNow();
        }
    }

    public static /* synthetic */ GrpcRetryHandler.RetryPolicy withCustomBlockingStub$default$1$(SparkConnectServerTest $this) {
        return $this.withCustomBlockingStub$default$1();
    }

    default public GrpcRetryHandler.RetryPolicy withCustomBlockingStub$default$1() {
        return new GrpcRetryHandler.RetryPolicy(GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$1(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$7());
    }

    public static /* synthetic */ void runQuery$(SparkConnectServerTest $this, Plan plan, Span queryTimeout, long iterSleep) {
        $this.runQuery(plan, queryTimeout, iterSleep);
    }

    default public void runQuery(Plan plan, Span queryTimeout, long iterSleep) {
        this.withClient((Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            TimeLimits$.MODULE$.failAfter(queryTimeout, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                CloseableIterator iter = client.execute(plan$1);
                None$ operationId = None$.MODULE$;
                ExecutePlanResponse r = null;
                ExecutePlanResponseReattachableIterator reattachableIter = $this.getReattachableIterator((CloseableIterator<ExecutePlanResponse>)iter);
                while (iter.hasNext()) {
                    r = (ExecutePlanResponse)iter.next();
                    None$ none$ = operationId;
                    if (None$.MODULE$.equals(none$)) {
                        operationId = new Some((Object)r.getOperationId());
                    } else if (none$ instanceof Some) {
                        Some some = (Some)none$;
                        String id = (String)some.value();
                        String $org_scalatest_assert_macro_left = r.getOperationId();
                        String $org_scalatest_assert_macro_right = id;
                        String string = $org_scalatest_assert_macro_left;
                        String string2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
                    } else {
                        throw new MatchError((Object)none$);
                    }
                    if (iterSleep$1 <= 0L) continue;
                    Thread.sleep(iterSleep$1);
                }
                ExecutePlanResponse $org_scalatest_assert_macro_left = r;
                Object $org_scalatest_assert_macro_right = null;
                ExecutePlanResponse executePlanResponse = $org_scalatest_assert_macro_left;
                Object var20_17 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, executePlanResponse == null ? var20_17 != null : !executePlanResponse.equals(var20_17), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(r.hasResultComplete(), "r.hasResultComplete()", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(operationId.isDefined(), "operationId.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
                $this.assertEventuallyExecutionReleased((String)operationId.get());
            }, Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230), Timed$.MODULE$.timed());
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void runQuery$(SparkConnectServerTest $this, String query, Span queryTimeout, long iterSleep) {
        $this.runQuery(query, queryTimeout, iterSleep);
    }

    default public void runQuery(String query, Span queryTimeout, long iterSleep) {
        Plan plan = this.buildPlan(query);
        this.runQuery(plan, queryTimeout, iterSleep);
    }

    public static /* synthetic */ long runQuery$default$3$(SparkConnectServerTest $this) {
        return $this.runQuery$default$3();
    }

    default public long runQuery$default$3() {
        return 0L;
    }

    public static /* synthetic */ boolean $anonfun$assertNoActiveRpcs$1(ExecuteInfo x$2) {
        return x$2.lastAttachedRpcTime().isDefined();
    }

    public static /* synthetic */ boolean $anonfun$assertExecutionReleased$1(String operationId$1, ExecuteInfo x$3) {
        String string = x$3.operationId();
        String string2 = operationId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static void $init$(SparkConnectServerTest $this) {
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$serverPort_$eq(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT() + Random$.MODULE$.nextInt(1000));
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$eventuallyTimeout_$eq(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultSessionId_$eq(UUID.randomUUID().toString());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultUserId_$eq(UUID.randomUUID().toString());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$dsl_$eq(new package.MockRemoteSession());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$userContext_$eq(UserContext.newBuilder().setUserId($this.defaultUserId()).build());
    }
}

