/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import org.apache.spark.connect.proto.InterruptRequest;
import org.apache.spark.connect.proto.InterruptResponse;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.slf4j.Logger;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import scala.Function0;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013A\u0001B\u0003\u0001%!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u00032\u0001\u0011\u0005!\u0007C\u00037\u0001\u0011\u0005qG\u0001\u000fTa\u0006\u00148nQ8o]\u0016\u001cG/\u00138uKJ\u0014X\u000f\u001d;IC:$G.\u001a:\u000b\u0005\u00199\u0011aB:feZL7-\u001a\u0006\u0003\u0011%\tqaY8o]\u0016\u001cGO\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\f\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0010\u001c\u0005\u001daunZ4j]\u001e\f\u0001C]3ta>t7/Z(cg\u0016\u0014h/\u001a:\u0011\u0007\u0005B#&D\u0001#\u0015\t\u0019C%\u0001\u0003tiV\u0014'BA\u0013'\u0003\u00119'\u000f]2\u000b\u0003\u001d\n!![8\n\u0005%\u0012#AD*ue\u0016\fWn\u00142tKJ4XM\u001d\t\u0003W=j\u0011\u0001\f\u0006\u0003[9\nQ\u0001\u001d:pi>T!\u0001C\u0006\n\u0005Ab#!E%oi\u0016\u0014(/\u001e9u%\u0016\u001c\bo\u001c8tK\u00061A(\u001b8jiz\"\"aM\u001b\u0011\u0005Q\u0002Q\"A\u0003\t\u000b}\u0011\u0001\u0019\u0001\u0011\u0002\r!\fg\u000e\u001a7f)\tA4\b\u0005\u0002\u0015s%\u0011!(\u0006\u0002\u0005+:LG\u000fC\u0003=\u0007\u0001\u0007Q(A\u0001w!\tYc(\u0003\u0002@Y\t\u0001\u0012J\u001c;feJ,\b\u000f\u001e*fcV,7\u000f\u001e")
public class SparkConnectInterruptHandler
implements Logging {
    private final StreamObserver<InterruptResponse> responseObserver;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void handle(InterruptRequest v) {
        Seq<String> seq;
        SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(v.getUserContext().getUserId(), v.getSessionId());
        InterruptRequest.InterruptType interruptType = v.getInterruptType();
        if (InterruptRequest.InterruptType.INTERRUPT_TYPE_ALL.equals(interruptType)) {
            seq = sessionHolder.interruptAll();
        } else if (InterruptRequest.InterruptType.INTERRUPT_TYPE_TAG.equals(interruptType)) {
            if (!v.hasOperationTag()) {
                throw new IllegalArgumentException("INTERRUPT_TYPE_TAG requested, but no operation_tag provided.");
            }
            seq = sessionHolder.interruptTag(v.getOperationTag());
        } else if (InterruptRequest.InterruptType.INTERRUPT_TYPE_OPERATION_ID.equals(interruptType)) {
            if (!v.hasOperationId()) {
                throw new IllegalArgumentException("INTERRUPT_TYPE_OPERATION_ID requested, but no operation_id provided.");
            }
            seq = sessionHolder.interruptOperation(v.getOperationId());
        } else {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown InterruptType ").append(interruptType).append("!").toString());
        }
        Seq<String> interruptedIds = seq;
        InterruptResponse response = InterruptResponse.newBuilder().setSessionId(v.getSessionId()).addAllInterruptedIds((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(interruptedIds).asJava()).build();
        this.responseObserver.onNext(response);
        this.responseObserver.onCompleted();
    }

    public SparkConnectInterruptHandler(StreamObserver<InterruptResponse> responseObserver) {
        this.responseObserver = responseObserver;
        Logging.$init$((Logging)this);
    }
}

